////////////////////////////////////////////////////////////////////////////////
//    Scorched3D (c) 2000-2003
//
//    This file is part of Scorched3D.
//
//    Scorched3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    Scorched3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Scorched3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
////////////////////////////////////////////////////////////////////////////////


#ifndef _SOUND_H_
#define _SOUND_H_
// Sound.h: interface for the Sound class.
//
//////////////////////////////////////////////////////////////////////

#include <list>
#include <SDL/SDL_mixer.h>

class SoundBuffer;

class Sound  
{
public:
	static Sound *instance();

	bool init(int channels);
	void setVolume(int volume);
	int getVolume();
	void destroy();
	SoundBuffer *createBuffer(char *fileName);

protected:
	static Sound *instance_;
	std::list<SoundBuffer *> buffers_;
	bool init_;

private:
	Sound();
	virtual ~Sound();

};

#endif /* _SOUND_H_ */
