////////////////////////////////////////////////////////////////////////////////
//    Scorched3D (c) 2000-2003
//
//    This file is part of Scorched3D.
//
//    Scorched3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    Scorched3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Scorched3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
////////////////////////////////////////////////////////////////////////////////

#if !defined(__INCLUDE_TankAILogich_INCLUDE__)
#define __INCLUDE_TankAILogich_INCLUDE__

#include <coms/ComsPlayedMoveMessage.h>
#include <coms/ComsDefenseMessage.h>
#include <engine/ScorchedContext.h>

class Tank;
class TankAILogic
{
public:
	// Process the defense and move messages and perform the actions
	//
	// These methods process the messages generated by the tankais and
	// perform the actual actions the messages contain
	// e.g. actually raise the shields
	static void processPlayedMoveMessage(
		ScorchedContext &context, ComsPlayedMoveMessage &message, Tank *tank,
		bool roundStart);
	static void processMoveMessage(
		ScorchedContext &context, ComsPlayedMoveMessage &message, Tank *tank);
	static void processResignMessage(
		ScorchedContext &context, ComsPlayedMoveMessage &message, Tank *tank);
	static void processFiredMessage(
		ScorchedContext &context, ComsPlayedMoveMessage &message, Tank *tank);
	static bool processDefenseMessage(
		ScorchedContext &context, ComsDefenseMessage &message, Tank *tank);

private:
	TankAILogic();
};

#endif

