////////////////////////////////////////////////////////////////////////////////
//    Scorched3D (c) 2000-2003
//
//    This file is part of Scorched3D.
//
//    Scorched3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    Scorched3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Scorched3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
////////////////////////////////////////////////////////////////////////////////

#include <engine/PhysicsParticle.h>
#include <engine/ScorchedContext.h>
#include <engine/ActionController.h>

PhysicsParticle::PhysicsParticle()  : 
	collision_(false), totalActionTime_(0)
{

}

PhysicsParticle::~PhysicsParticle()
{

}

void PhysicsParticle::setPhysics(
	Vector &position, Vector &velocity,
	float sphereSize, float sphereDensity, float windFactor)
{
	physicsObject_.setPhysics(context_->actionController->getPhysics(), 
		position, velocity,
		sphereSize, sphereDensity, windFactor);
}

void PhysicsParticle::collision(Vector &position)
{
	collision_ = true;
}

void PhysicsParticle::setData(void *data)
{
	physicsObject_.setData(data);
}

void PhysicsParticle::applyForce(Vector &force)
{
	physicsObject_.applyForce(force);
}

Vector &PhysicsParticle::getCurrentPosition()
{
	return physicsObject_.getPosition();
}

Vector &PhysicsParticle::getCurrentVelocity()
{
	return physicsObject_.getVelocity();
}

void PhysicsParticle::simulate(float frameTime, bool &remove)
{
	physicsObject_.simulate(frameTime);
	Action::simulate(frameTime, remove);
	if (collision_) remove = true;
	totalActionTime_ += frameTime;
	if (totalActionTime_ > 30.0f) remove = true;
}

PhysicsParticleMeta::PhysicsParticleMeta()  : 
	collision_(false), totalActionTime_(0), warp_(false)
{

}

PhysicsParticleMeta::~PhysicsParticleMeta()
{

}

void PhysicsParticleMeta::setPhysics(
	Vector &position, Vector &velocity,
	float sphereSize, float sphereDensity, float windFactor)
{
	physicsObject_.setPhysics(context_->actionController->getPhysics(), 
		position, velocity,
		sphereSize, sphereDensity, windFactor);
}

void PhysicsParticleMeta::applyForce(Vector &force)
{
	physicsObject_.applyForce(force);
}

void PhysicsParticleMeta::collision(Vector &position)
{
	collision_ = true;
}

void PhysicsParticleMeta::setData(void *data)
{
	physicsObject_.setData(data);
}

Vector &PhysicsParticleMeta::getCurrentPosition()
{
	return physicsObject_.getPosition();
}

Vector &PhysicsParticleMeta::getCurrentVelocity()
{
	return physicsObject_.getVelocity();
}

void PhysicsParticleMeta::setCurrentPosition(Vector &position)
{
	warp_ = true;
	warpPosition_ = position;
}

float *PhysicsParticleMeta::getRotationQuat()
{
	return physicsObject_.getRotationQuat();
}

void PhysicsParticleMeta::simulate(float frameTime, bool &remove)
{
	if (warp_)
	{
		warp_ = false;
		physicsObject_.setPosition(warpPosition_);
	}

	physicsObject_.simulate(frameTime);
	Action::simulate(frameTime, remove);
	if (collision_) remove = true;
	totalActionTime_ += frameTime;
	if (totalActionTime_ > 30.0f) remove = true;
}

