////////////////////////////////////////////////////////////////////////////////
//    Scorched3D (c) 2000-2003
//
//    This file is part of Scorched3D.
//
//    Scorched3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    Scorched3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Scorched3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
////////////////////////////////////////////////////////////////////////////////


#if !defined(__INCLUDE_PhysicsParticleObjecth_INCLUDE__)
#define __INCLUDE_PhysicsParticleObjecth_INCLUDE__

#include <common/Vector.h>
#include <engine/PhysicsEngine.h>

class PhysicsParticleObject
{
public:
	PhysicsParticleObject();
	virtual ~PhysicsParticleObject();

	void setPhysics(PhysicsEngine &engine, 
		Vector &position, Vector &velocity,
		float sphereSize = 0.0f,
		float sphereDensity = 0.0f,
		float windFactor = 1.0f);

	void applyForce(Vector &force);
	void simulate(float frameTime);

	Vector &getPosition();
	Vector &getVelocity();
	float *getRotationQuat();
	void setPosition(Vector &position);
	void setData(void *data);

protected:
	dBodyID body_;
	dGeomID geom_;
	Vector windFactor_;
};

#endif
