////////////////////////////////////////////////////////////////////////////////
//    Scorched3D (c) 2000-2003
//
//    This file is part of Scorched3D.
//
//    Scorched3D is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//    Scorched3D is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU General Public License for more details.
//
//    You should have received a copy of the GNU General Public License
//    along with Scorched3D; if not, write to the Free Software
//    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
////////////////////////////////////////////////////////////////////////////////

#include <server/ServerResetState.h>
#include <server/ServerState.h>
#include <server/ScorchedServer.h>
#include <tank/TankDeadContainer.h>
#include <tank/TankContainer.h>
#include <tank/TankTeamScore.h>
#include <scorched/ServerDialog.h>
#include <common/OptionsTransient.h>
#include <common/Logger.h>

ServerResetState::ServerResetState() :
	GameStateI("ServerResetState")
{
}

ServerResetState::~ServerResetState()
{
}

void ServerResetState::enterState(const unsigned state)
{
	// Reset all the tanks back to their original scores etc...
	ScorchedServer::instance()->getTankContainer().newMatch();
	ScorchedServer::instance()->getContext().tankTeamScore->newMatch();
	ScorchedServer::instance()->getTankDeadContainer().clearTanks();
	ScorchedServer::instance()->getOptionsTransient().reset();

	// Start the game
	ScorchedServer::instance()->getGameState().stimulate(ServerState::ServerStimulusNewGame);
}
