<?xml version="1.0" encoding="utf-8"?>
<!DOCTYPE TS><TS version="1.1">
<context>
    <name></name>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="21"/>
        <source>getColorNames() -&gt; list

Returns a list containing the names of all defined colors in the document.
If no document is open, returns a list of the default document colors.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="35"/>
        <source>getColor(&quot;name&quot;) -&gt; tuple

Returns a tuple (C, M, Y, K) containing the four color components of the
color &quot;name&quot; from the current document. If no document is open, returns
the value of the named color from the default document colors.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="50"/>
        <source>getColorAsRGB(&quot;name&quot;) -&gt; tuple

Returns a tuple (R,G,B) containing the three color components of the
color &quot;name&quot; from the current document, converted to the RGB color
space. If no document is open, returns the value of the named color
from the default document colors.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="64"/>
        <source>changeColor(&quot;name&quot;, c, m, y, k)

Changes the color &quot;name&quot; to the specified CMYK value. The color value is
defined via four components c = Cyan, m = Magenta, y = Yellow and k = Black.
Color components should be in the range from 0 to 255.

May raise NotFoundError if the named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="77"/>
        <source>defineColor(&quot;name&quot;, c, m, y, k)

Defines a new color &quot;name&quot;. The color Value is defined via four components:
c = Cyan, m = Magenta, y = Yellow and k = Black. Color components should be in
the range from 0 to 255.

May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="94"/>
        <source>deleteColor(&quot;name&quot;, &quot;replace&quot;)

Deletes the color &quot;name&quot;. Every occurence of that color is replaced by the
color &quot;replace&quot;. If not specified, &quot;replace&quot; defaults to the color
&quot;None&quot; - transparent.

deleteColor works on the default document colors if there is no document open.
In that case, &quot;replace&quot;, if specified, has no effect.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.h" line="106"/>
        <source>replaceColor(&quot;name&quot;, &quot;replace&quot;)

Every occurence of the color &quot;name&quot; is replaced by the color &quot;replace&quot;.

May raise NotFoundError if a named color wasn&apos;t found.
May raise ValueError if an invalid color name is specified.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="22"/>
        <source>newDocDialog() -&gt; bool

Displays the &quot;New Document&quot; dialog box. Creates a new document if the user
accepts the settings. Does not create a document if the user presses cancel.
Returns true if a new document was created.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="46"/>
        <source>fileDialog(&quot;caption&quot;, [&quot;filter&quot;, &quot;defaultname&quot;, haspreview, issave, isdir]) -&gt; string with filename

Shows a File Open dialog box with the caption &quot;caption&quot;. Files are filtered
with the filter string &quot;filter&quot;. A default filename or file path can also
supplied, leave this string empty when you don&apos;t want to use it.  A value of
True for haspreview enables a small preview widget in the FileSelect box.  When
the issave parameter is set to True the dialog acts like a &quot;Save As&quot; dialog
otherwise it acts like a &quot;File Open Dialog&quot;. When the isdir parameter is True
the dialog shows and returns only directories. The default for all of the
optional parameters is False.

The filter, if specified, takes the form &apos;comment (*.type *.type2 ...)&apos;.
For example &apos;Images (*.png *.xpm *.jpg)&apos;.

Refer to the Qt-Documentation for QFileDialog for details on filters.

Example: fileDialog(&apos;Open input&apos;, &apos;CSV files (*.csv)&apos;)
Example: fileDialog(&apos;Save report&apos;, defaultname=&apos;report.txt&apos;, issave=True)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="88"/>
        <source>messageBox(&quot;caption&quot;, &quot;message&quot;,
    icon=ICON_NONE, button1=BUTTON_OK|BUTTONOPT_DEFAULT,
    button2=BUTTON_NONE, button3=BUTTON_NONE) -&gt; integer

Displays a message box with the title &quot;caption&quot;, the message &quot;message&quot;, and
an icon &quot;icon&quot; and up to 3 buttons. By default no icon is used and a single
button, OK, is displayed. Only the caption and message arguments are required,
though setting an icon and appropriate button(s) is strongly
recommended. The message text may contain simple HTML-like markup.

Returns the number of the button the user pressed. Button numbers start
at 1.

For the icon and the button parameters there are predefined constants available
with the same names as in the Qt Documentation. These are the BUTTON_* and
ICON_* constants defined in the module. There are also two extra constants that
can be binary-ORed with button constants:
    BUTTONOPT_DEFAULT   Pressing enter presses this button.
    BUTTONOPT_ESCAPE    Pressing escape presses this button.

Usage examples:
result = messageBox(&apos;Script failed&apos;,
                    &apos;This script only works when you have a text frame selected.&apos;,
                    ICON_ERROR)
result = messageBox(&apos;Monkeys!&apos;, &apos;Something went ook! &lt;i&gt;Was it a monkey?&lt;/i&gt;&apos;,
                    ICON_WARNING, BUTTON_YES|BUTTONOPT_DEFAULT,
                    BUTTON_NO, BUTTON_IGNORE|BUTTONOPT_ESCAPE)

Defined button and icon constants:
BUTTON_NONE, BUTTON_ABORT, BUTTON_CANCEL, BUTTON_IGNORE, BUTTON_NO,
BUTTON_NOALL, BUTTON_OK, BUTTON_RETRY, BUTTON_YES, BUTTON_YESALL,
ICON_NONE, ICON_INFORMATION, ICON_WARNING, ICON_CRITICAL.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="101"/>
        <source>valueDialog(caption, message [,defaultvalue]) -&gt; string

Shows the common &apos;Ask for string&apos; dialog and returns its value as a string
Parameters: window title, text in the window and optional &apos;default&apos; value.

Example: valueDialog(&apos;title&apos;, &apos;text in the window&apos;, &apos;optional&apos;)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddialog.h" line="111"/>
        <source>newStyleDialog() -&gt; string

Shows &apos;Create new paragraph style&apos; dialog. Function returns real
style name or None when user cancels the dialog.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="55"/>
        <source>newDocument(size, margins, orientation, firstPageNumber,
                        unit, pagesType, firstPageOrder, numPages) -&gt; bool

Creates a new document and returns true if successful. The parameters have the
following meaning:

size = A tuple (width, height) describing the size of the document. You can
use predefined constants named PAPER_&lt;paper_type&gt; e.g. PAPER_A4 etc.

margins = A tuple (left, right, top, bottom) describing the document
margins

orientation = the page orientation - constants PORTRAIT, LANDSCAPE

firstPageNumer = is the number of the first page in the document used for
pagenumbering. While you&apos;ll usually want 1, it&apos;s useful to have higher
numbers if you&apos;re creating a document in several parts.

unit: this value sets the measurement units used by the document. Use a
predefined constant for this, one of: UNIT_INCHES, UNIT_MILLIMETERS,
UNIT_PICAS, UNIT_POINTS.

pagesType = One of the predefined constants PAGE_n. PAGE_1 is single page,
PAGE_2 is for double sided documents, PAGE_3 is for 3 pages fold and
PAGE_4 is 4-fold.

firstPageOrder = What is position of first page in the document.
Indexed from 0 (0 = first).

numPage = Number of pages to be created.

The values for width, height and the margins are expressed in the given unit
for the document. PAPER_* constants are expressed in points. If your document
is not in points, make sure to account for this.

example: newDocument(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 7, UNIT_POINTS,
PAGE_4, 3, 1)

May raise ScribusError if is firstPageOrder bigger than allowed by pagesType.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="96"/>
        <source>newDoc(size, margins, orientation, firstPageNumber,
                   unit, facingPages, firstSideLeft) -&gt; bool

WARNING: Obsolete procedure! Use newDocument instead.

Creates a new document and returns true if successful. The parameters have the
following meaning:

    size = A tuple (width, height) describing the size of the document. You can
    use predefined constants named PAPER_&lt;paper_type&gt; e.g. PAPER_A4 etc.

    margins = A tuple (left, right, top, bottom) describing the document
    margins

    orientation = the page orientation - constants PORTRAIT, LANDSCAPE

    firstPageNumer = is the number of the first page in the document used for
    pagenumbering. While you&apos;ll usually want 1, it&apos;s useful to have higher
    numbers if you&apos;re creating a document in several parts.

    unit: this value sets the measurement units used by the document. Use a
    predefined constant for this, one of: UNIT_INCHES, UNIT_MILLIMETERS,
    UNIT_PICAS, UNIT_POINTS.

    facingPages = FACINGPAGES, NOFACINGPAGES

    firstSideLeft = FIRSTPAGELEFT, FIRSTPAGERIGHT

The values for width, height and the margins are expressed in the given unit
for the document. PAPER_* constants are expressed in points. If your document
is not in points, make sure to account for this.

example: newDoc(PAPER_A4, (10, 10, 20, 20), LANDSCAPE, 1, UNIT_POINTS,
                FACINGPAGES, FIRSTPAGERIGHT)
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="108"/>
        <source>closeDoc()

Closes the current document without prompting to save.

May throw NoDocOpenError if there is no document to close
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="117"/>
        <source>haveDoc() -&gt; bool

Returns true if there is a document open.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="128"/>
        <source>openDoc(&quot;name&quot;)

Opens the document &quot;name&quot;.

May raise ScribusError if the document could not be opened.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="141"/>
        <source>saveDoc()

Saves the current document with its current name, returns true if successful.
If the document has not already been saved, this may bring up an interactive
save file dialog.

If the save fails, there is currently no way to tell.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="152"/>
        <source>saveDocAs(&quot;name&quot;)

Saves the current document under the new name &quot;name&quot; (which may be a full or
relative path).

May raise ScribusError if the save fails.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="162"/>
        <source>setInfo(&quot;author&quot;, &quot;info&quot;, &quot;description&quot;) -&gt; bool

Sets the document information. &quot;Author&quot;, &quot;Info&quot;, &quot;Description&quot; are
strings.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="173"/>
        <source>setMargins(lr, rr, tr, br)

Sets the margins of the document, Qt::DockLeft(lr), Qt::DockRight(rr), Qt::DockTop(tr) and Qt::DockBottom(br)
margins are given in the measurement units of the document - see UNIT_&lt;type&gt;
constants.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="185"/>
        <source>setUnit(type)

Changes the measurement unit of the document. Possible values for &quot;unit&quot; are
defined as constants UNIT_&lt;type&gt;.

May raise ValueError if an invalid unit is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="196"/>
        <source>getUnit() -&gt; integer (Scribus unit constant)

Returns the measurement units of the document. The returned value will be one
of the UNIT_* constants:
UNIT_INCHES, UNIT_MILLIMETERS, UNIT_PICAS, UNIT_POINTS.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="206"/>
        <source>loadStylesFromFile(&quot;filename&quot;)

Loads paragraph styles from the Scribus document at &quot;filename&quot; into the
current document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="218"/>
        <source>setDocType(facingPages, firstPageLeft)

Sets the document type. To get facing pages set the first parameter to
FACINGPAGES, to switch facingPages off use NOFACINGPAGES instead.  If you want
to be the first page a left side set the second parameter to FIRSTPAGELEFT, for
a right page use FIRSTPAGERIGHT.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="226"/>
        <source>closeMasterPage()

Closes the currently active master page, if any, and returns editing
to normal. Begin editing with editMasterPage().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="233"/>
        <source>masterPageNames()

Returns a list of the names of all master pages in the document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="241"/>
        <source>editMasterPage(pageName)

Enables master page editing and opens the named master page
for editing. Finish editing with closeMasterPage().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="249"/>
        <source>createMasterPage(pageName)

Creates a new master page named pageName and opens it for
editing.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.h" line="256"/>
        <source>deleteMasterPage(pageName)

Delete the named master page.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="21"/>
        <source>getFillColor([&quot;name&quot;]) -&gt; string

Returns the name of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="31"/>
        <source>getFillTransparency([&quot;name&quot;]) -&gt; float

Returns the fill transparency of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="41"/>
        <source>getFillBlendmode([&quot;name&quot;]) -&gt; integer

Returns the fill blendmode of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="51"/>
        <source>getLineColor([&quot;name&quot;]) -&gt; string

Returns the name of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="61"/>
        <source>getLineTransparency([&quot;name&quot;]) -&gt; float

Returns the line transparency of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="71"/>
        <source>getLineBlendmode([&quot;name&quot;]) -&gt; integer

Returns the line blendmode of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="81"/>
        <source>getLineWidth([&quot;name&quot;]) -&gt; integer

Returns the line width of the object &quot;name&quot;. If &quot;name&quot;
is not given the currently selected Item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="91"/>
        <source>getLineShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the line color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="102"/>
        <source>getLineJoin([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line join style of the object &quot;name&quot;. If &quot;name&quot; is not given
the currently selected item is used.  The join types are:
JOIN_BEVEL, JOIN_MITTER, JOIN_ROUND
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="113"/>
        <source>getLineEnd([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line cap style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. The cap types are:
CAP_FLAT, CAP_ROUND, CAP_SQUARE
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="124"/>
        <source>getLineStyle([&quot;name&quot;]) -&gt; integer (see constants)

Returns the line style of the object &quot;name&quot;. If &quot;name&quot; is not given the
currently selected item is used. Line style constants are:
LINE_DASH, LINE_DASHDOT, LINE_DASHDOTDOT, LINE_DOT, LINE_SOLID
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="134"/>
        <source>getFillShade([&quot;name&quot;]) -&gt; integer

Returns the shading value of the fill color of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="145"/>
        <source>getCornerRadius([&quot;name&quot;]) -&gt; integer

Returns the corner radius of the object &quot;name&quot;. The radius is
expressed in points. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="155"/>
        <source>getImageScale([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple containing the scaling values of the image frame
&quot;name&quot;.  If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="165"/>
        <source>getImageName([&quot;name&quot;]) -&gt; string

Returns the filename for the image in the image frame. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="177"/>
        <source>getPosition([&quot;name&quot;]) -&gt; (x,y)

Returns a (x, y) tuple with the position of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
The position is expressed in the actual measurement unit of the document
- see UNIT_&lt;type&gt; for reference.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="189"/>
        <source>getSize([&quot;name&quot;]) -&gt; (width,height)

Returns a (width, height) tuple with the size of the object &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. The size is
expressed in the current measurement unit of the document - see UNIT_&lt;type&gt;
for reference.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="200"/>
        <source>getRotation([&quot;name&quot;]) -&gt; integer

Returns the rotation of the object &quot;name&quot;. The value is expressed in degrees,
and clockwise is positive. If &quot;name&quot; is not given the currently selected item
is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.h" line="209"/>
        <source>getAllObjects() -&gt; list

Returns a list containing the names of all objects on the current page.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="83"/>
        <source>getPropertyCType(object, property, includesuper=True)

Returns the name of the C type of `property&apos; of `object&apos;. See getProperty()
for details of arguments.

If `includesuper&apos; is true, search inherited properties too.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="101"/>
        <source>getPropertyNames(object, includesuper=True)

Return a list of property names supported by `object&apos;.
If `includesuper&apos; is true, return properties supported
by parent classes as well.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="135"/>
        <source>getProperty(object, property)

Return the value of the property `property&apos; of the passed `object&apos;.

The `object&apos; argument may be a string, in which case the named PageItem
is searched for. It may also be a PyCObject, which may point to any
C++ QObject instance.

The `property&apos; argument must be a string, and is the name of the property
to look up on `object&apos;.

The return value varies depending on the type of the property.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.h" line="165"/>
        <source>setProperty(object, property, value)

Set `property&apos; of `object&apos; to `value&apos;. If `value&apos; cannot be converted to a type
compatible with the type of `property&apos;, an exception is raised. An exception may
also be raised if the underlying setter fails.

See getProperty() for more information.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="23"/>
        <source>moveObject(dx, dy [, &quot;name&quot;])

Moves the object &quot;name&quot; by dx and dy relative to its current position. The
distances are expressed in the current measurement unit of the document (see
UNIT constants). If &quot;name&quot; is not given the currently selected item is used.
If the object &quot;name&quot; belongs to a group, the whole group is moved.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="35"/>
        <source>moveObjectAbs(x, y [, &quot;name&quot;])

Moves the object &quot;name&quot; to a new location. The coordinates are expressed in
the current measurement unit of the document (see UNIT constants).  If &quot;name&quot;
is not given the currently selected item is used.  If the object &quot;name&quot;
belongs to a group, the whole group is moved.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="48"/>
        <source>rotateObject(rot [, &quot;name&quot;])

Rotates the object &quot;name&quot; by &quot;rot&quot; degrees relatively. The object is
rotated by the vertex that is currently selected as the rotation point - by
default, the top left vertex at zero rotation. Positive values mean counter
clockwise rotation when the default rotation point is used. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="59"/>
        <source>rotateObjectAbs(rot [, &quot;name&quot;])

Sets the rotation of the object &quot;name&quot; to &quot;rot&quot;. Positive values
mean counter clockwise rotation. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="69"/>
        <source>sizeObject(width, height [, &quot;name&quot;])

Resizes the object &quot;name&quot; to the given width and height. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="80"/>
        <source>getSelectedObject([nr]) -&gt; string

Returns the name of the selected object. &quot;nr&quot; if given indicates the number
of the selected object, e.g. 0 means the first selected object, 1 means the
second selected Object and so on.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="89"/>
        <source>selectionCount() -&gt; integer

Returns the number of selected objects.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="98"/>
        <source>selectObject(&quot;name&quot;)

Selects the object with the given &quot;name&quot;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="107"/>
        <source>deselectAll()

Deselects all objects in the whole document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="118"/>
        <source>groupObjects(list)

Groups the objects named in &quot;list&quot; together. &quot;list&quot; must contain the names
of the objects to be grouped. If &quot;list&quot; is not given the currently selected
items are used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="126"/>
        <source>unGroupObjects(&quot;name&quot;)

Destructs the group the object &quot;name&quot; belongs to.If &quot;name&quot; is not given the currently selected item is used.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="141"/>
        <source>scaleGroup(factor [,&quot;name&quot;])

Scales the group the object &quot;name&quot; belongs to. Values greater than 1 enlarge
the group, values smaller than 1 make the group smaller e.g a value of 0.5
scales the group to 50 % of its original size, a value of 1.5 scales the group
to 150 % of its original size.  The value for &quot;factor&quot; must be greater than
0. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if an invalid scale factor is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="153"/>
        <source>loadImage(&quot;filename&quot; [, &quot;name&quot;])

Loads the picture &quot;picture&quot; into the image frame &quot;name&quot;. If &quot;name&quot; is
not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="166"/>
        <source>scaleImage(x, y [, &quot;name&quot;])

Sets the scaling factors of the picture in the image frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used. A number of 1
means 100 %.

May raise WrongFrameTypeError if the target frame is not an image frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="177"/>
        <source>lockObject([&quot;name&quot;]) -&gt; bool

Locks the object &quot;name&quot; if it&apos;s unlocked or unlock it if it&apos;s locked.
If &quot;name&quot; is not given the currently selected item is used. Returns true
if locked.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="187"/>
        <source>isLocked([&quot;name&quot;]) -&gt; bool

Returns true if is the object &quot;name&quot; locked.  If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.h" line="199"/>
        <source>setScaleImageToFrame(scaletoframe, proportional=None, name=&lt;selection&gt;)

Sets the scale to frame on the selected or specified image frame to `scaletoframe&apos;.
If `proportional&apos; is specified, set fixed aspect ratio scaling to `proportional&apos;.
Both `scaletoframe&apos; and `proportional&apos; are boolean.

May raise WrongFrameTypeError.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="24"/>
        <source>setRedraw(bool)

Disables page redraw when bool = False, otherwise redrawing is enabled.
This change will persist even after the script exits, so make sure to call
setRedraw(True) in a finally: clause at the top level of your script.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="33"/>
        <source>getFontNames() -&gt; list

Returns a list with the names of all available fonts.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="43"/>
        <source>getXFontNames() -&gt; list of tuples

Returns a larger font info. It&apos;s a list of the tuples with:
[ (Scribus name, Family, Real name, subset (1|0), embed PS (1|0), font file), (...), ... ]
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="62"/>
        <source>renderFont(&quot;name&quot;, &quot;filename&quot;, &quot;sample&quot;, size, format=&quot;PPM&quot;) -&gt; bool

Creates an image preview of font &quot;name&quot; with given text &quot;sample&quot; and size.
If &quot;filename&quot; is not &quot;&quot;, image is saved into &quot;filename&quot;. Otherwise
image data is returned as a string. The optional &quot;format&quot; argument
specifies the image format to generate, and supports any format allowed
by QPixmap.save(). Common formats are PPM, JPEG, PNG and XPM.

May raise NotFoundError if the specified font can&apos;t be found.
May raise ValueError if an empty sample or filename is passed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="71"/>
        <source>getLayers() -&gt; list

Returns a list with the names of all defined layers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="83"/>
        <source>setActiveLayer(&quot;name&quot;)

Sets the active layer to the layer named &quot;name&quot;.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="92"/>
        <source>getActiveLayer() -&gt; string

Returns the name of the current active layer.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="105"/>
        <source>sentToLayer(&quot;layer&quot; [, &quot;name&quot;])

Sends the object &quot;name&quot; to the layer &quot;layer&quot;. The layer must exist.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="118"/>
        <source>setLayerVisible(&quot;layer&quot;, visible)

Sets the layer &quot;layer&quot; to be visible or not. If is the visible set to false
the layer is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="131"/>
        <source>setLayerPrintable(&quot;layer&quot;, printable)

Sets the layer &quot;layer&quot; to be printable or not. If is the
printable set to false the layer won&apos;t be printed.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="144"/>
        <source>setLayerLocked(&quot;layer&quot;, locked)

Sets the layer &quot;layer&quot; to be locked or not. If locked is set to
true the layer will be locked.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="157"/>
        <source>setLayerOutlined(&quot;layer&quot;, outline)

Sets the layer &quot;layer&quot; to be locked or not. If outline is set to
true the layer will be displayed outlined.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="170"/>
        <source>setLayerFlow(&quot;layer&quot;, flow)

Sets the layers &quot;layer&quot;  flowcontrol to flow. If flow is set to
true text in layers above this one will flow around objects on this layer.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="182"/>
        <source>setLayerBlendmode(&quot;layer&quot;, blend)

Sets the layers &quot;layer&quot;  blendmode to blend.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="194"/>
        <source>setLayerTransparency(&quot;layer&quot;, trans)

Sets the layers &quot;layer&quot;  transparency to trans.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="208"/>
        <source>isLayerVisible(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is visible or not, a value of True means
that the layer &quot;layer&quot; is visible, a value of False means that the layer
&quot;layer&quot; is invisible.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="222"/>
        <source>isLayerPrintable(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is printable or not, a value of True means
that the layer &quot;layer&quot; can be printed, a value of False means that printing
the layer &quot;layer&quot; is disabled.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="236"/>
        <source>isLayerLocked(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is locked or not, a value of True means
that the layer &quot;layer&quot; is editable, a value of False means that the layer
&quot;layer&quot; is locked.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="250"/>
        <source>isLayerOutlined(&quot;layer&quot;) -&gt; bool

Returns whether the layer &quot;layer&quot; is outlined or not, a value of True means
that the layer &quot;layer&quot; is outlined, a value of False means that the layer
&quot;layer&quot; is normal.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="263"/>
        <source>isLayerFlow(&quot;layer&quot;) -&gt; bool

Returns whether text flows around objects on layer &quot;layer&quot;, a value of True means
that text flows around, a value of False means that the text does not flow around.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="275"/>
        <source>getLayerBlendmode(&quot;layer&quot;) -&gt; int

Returns the &quot;layer&quot; layer blendmode,

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="287"/>
        <source>getLayerTransparency(&quot;layer&quot;) -&gt; float

Returns the &quot;layer&quot; layer transparency,

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="300"/>
        <source>deleteLayer(&quot;layer&quot;)

Deletes the layer with the name &quot;layer&quot;. Nothing happens if the layer doesn&apos;t
exists or if it&apos;s the only layer in the document.

May raise NotFoundError if the layer can&apos;t be found.
May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="311"/>
        <source>createLayer(layer)

Creates a new layer with the name &quot;name&quot;.

May raise ValueError if the layer name isn&apos;t acceptable.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="320"/>
        <source>getGuiLanguage() -&gt; string

Returns a string with the -lang value.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="329"/>
        <source>moveSelectionToFront()

Moves current selection to front.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.h" line="338"/>
        <source>moveSelectionToFront()

Moves current selection to back.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="26"/>
        <source>createRect(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new rectangle on the current page and returns its name. The
coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name to reference that object in future. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="43"/>
        <source>createEllipse(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new ellipse on the current page and returns its name.
The coordinates are given in the current measurement units of the document
(see UNIT constants). &quot;name&quot; should be a unique identifier for the object
because you need this name for further referencing of that object. If &quot;name&quot;
is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="60"/>
        <source>createImage(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new picture frame on the current page and returns its name. The
coordinates are given in the current measurement units of the document.
&quot;name&quot; should be a unique identifier for the object because you need this
name for further access to that object. If &quot;name&quot; is not given Scribus will
create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="75"/>
        <source>createText(x, y, width, height, [&quot;name&quot;]) -&gt; string

Creates a new text frame on the actual page and returns its name.
The coordinates are given in the actual measurement unit of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further referencing of that object. If &quot;name&quot; is not
given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="90"/>
        <source>createLine(x1, y1, x2, y2, [&quot;name&quot;]) -&gt; string

Creates a new line from the point(x1, y1) to the point(x2, y2) and returns
its name. The coordinates are given in the current measurement unit of the
document (see UNIT constants). &quot;name&quot; should be a unique identifier for the
object because you need this name for further access to that object. If
&quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="108"/>
        <source>createPolyLine(list, [&quot;name&quot;]) -&gt; string

Creates a new polyline and returns its name. The points for the polyline are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
The coordinates are given in the current measurement units of the document (see
UNIT constants). &quot;name&quot; should be a unique identifier for the object because
you need this name for further access to that object. If &quot;name&quot; is not given
Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="128"/>
        <source>createPolygon(list, [&quot;name&quot;]) -&gt; string

Creates a new polygon and returns its name. The points for the polygon are
stored in the list &quot;list&quot; in the following order: [x1, y1, x2, y2...xn. yn].
At least three points are required. There is no need to repeat the first point
to close the polygon. The polygon is automatically closed by connecting the
first and the last point.  The coordinates are given in the current measurement
units of the document (see UNIT constants).  &quot;name&quot; should be a unique
identifier for the object because you need this name for further access to that
object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="149"/>
        <source>createBezierLine(list, [&quot;name&quot;]) -&gt; string

Creates a new bezier curve and returns its name. The points for the bezier
curve are stored in the list &quot;list&quot; in the following order:
[x1, y1, kx1, ky1, x2, y2, kx2, ky2...xn. yn, kxn. kyn]
In the points list, x and y mean the x and y coordinates of the point and kx
and ky meaning the control point for the curve.  The coordinates are given in
the current measurement units of the document (see UNIT constants). &quot;name&quot;
should be a unique identifier for the object because you need this name for
further access to that object. If &quot;name&quot; is not given Scribus will create one
for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise ValueError if an insufficient number of points is passed or if
the number of values passed don&apos;t group into points without leftovers.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="165"/>
        <source>createPathText(x, y, &quot;textbox&quot;, &quot;beziercurve&quot;, [&quot;name&quot;]) -&gt; string

Creates a new pathText by merging the two objects &quot;textbox&quot; and
&quot;beziercurve&quot; and returns its name. The coordinates are given in the current
measurement unit of the document (see UNIT constants). &quot;name&quot; should be a
unique identifier for the object because you need this name for further access
to that object. If &quot;name&quot; is not given Scribus will create one for you.

May raise NameExistsError if you explicitly pass a name that&apos;s already used.
May raise NotFoundError if one or both of the named base object don&apos;t exist.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="177"/>
        <source>deleteObject([&quot;name&quot;])

Deletes the item with the name &quot;name&quot;. If &quot;name&quot; is not given the currently
selected item is deleted.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="193"/>
        <source>textFlowMode(&quot;name&quot; [, state])

Enables/disables &quot;Text Flows Around Frame&quot; feature for object &quot;name&quot;.
Called with parameters string name and optional int &quot;state&quot; (0 &lt;= state &lt;= 3).
Setting &quot;state&quot; to 0 will disable text flow.
Setting &quot;state&quot; to 1 will make text flow around object frame.
Setting &quot;state&quot; to 2 will make text flow around bounding box.
Setting &quot;state&quot; to 3 will make text flow around contour line.
If &quot;state&quot; is not passed, text flow is toggled.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="211"/>
        <source>objectExists([&quot;name&quot;]) -&gt; bool

Test if an object with specified name really exists in the document.
The optional parameter is the object name. When no object name is given,
returns True if there is something selected.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="227"/>
        <source>setStyle(&quot;style&quot; [, &quot;name&quot;])

Apply the named &quot;style&quot; to the object named &quot;name&quot;. If is no object name
given, it&apos;s applied on the selected object.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="240"/>
        <source>getAllStyles() -&gt; list

Return a list of the names of all paragraph styles in the current document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.h" line="252"/>
        <source>duplicateObject([&quot;name&quot;]) -&gt; string

creates a Duplicate of the selected Object (or Selection Group).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="26"/>
        <source>newPage(where [,&quot;masterpage&quot;])

Creates a new page. If &quot;where&quot; is -1 the new Page is appended to the
document, otherwise the new page is inserted before &quot;where&quot;. Page numbers are
counted from 1 upwards, no matter what the displayed first page number of your
document is. The optional parameter &quot;masterpage&quot; specifies the name of the
master page for the new page.

May raise IndexError if the page number is out of range
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="36"/>
        <source>currentPage() -&gt; integer

Returns the number of the current working page. Page numbers are counted from 1
upwards, no matter what the displayed first page number of your document is.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="45"/>
        <source>redrawAll()

Redraws all pages.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="54"/>
        <source>getPageType() -&gt; integer

Returns the type of the Page, 0 means left Page, 1 is a middle Page and 2 is a right Page
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="65"/>
        <source>savePageAsEPS(&quot;name&quot;)

Saves the current page as an EPS to the file &quot;name&quot;.

May raise ScribusError if the save failed.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="78"/>
        <source>deletePage(nr)

Deletes the given page. Does nothing if the document contains only one page.
Page numbers are counted from 1 upwards, no matter what the displayed first
page number is.

May raise IndexError if the page number is out of range
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="91"/>
        <source>gotoPage(nr)

Moves to the page &quot;nr&quot; (that is, makes the current page &quot;nr&quot;). Note that
gotoPage doesn&apos;t (currently) change the page the user&apos;s view is displaying, it
just sets the page that script commands will operates on.

May raise IndexError if the page number is out of range.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="100"/>
        <source>pageCount() -&gt; integer

Returns the number of pages in the document.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="110"/>
        <source>getHGuides() -&gt; list

Returns a list containing positions of the horizontal guides. Values are in the
document&apos;s current units - see UNIT_&lt;type&gt; constants.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="123"/>
        <source>setHGuides(list)

Sets horizontal guides. Input parameter must be a list of guide positions
measured in the current document units - see UNIT_&lt;type&gt; constants.

Example: setHGuides(getHGuides() + [200.0, 210.0] # add new guides without any lost
         setHGuides([90,250]) # replace current guides entirely
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="132"/>
        <source>getVGuides()

See getHGuides.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="141"/>
        <source>setVGuides()

See setHGuides.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="151"/>
        <source>getPageSize() -&gt; tuple

Returns a tuple with page dimensions measured in the document&apos;s current units.
See UNIT_&lt;type&gt; constants and getPageMargins()
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="167"/>
        <source>getPageItems() -&gt; list

Returns a list of tuples with items on the current page. The tuple is:
(name, objectType, order) E.g. [(&apos;Text1&apos;, 4, 0), (&apos;Image1&apos;, 2, 1)]
means that object named &apos;Text1&apos; is a text frame (type 4) and is the first at
the page...
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="181"/>
        <source>getPageMargins()

Returns the page margins as a (top, left, right, bottom) tuple in the current
units. See UNIT_&lt;type&gt; constants and getPageSize().
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.h" line="198"/>
        <source>importPage(&quot;fromDoc&quot;, (pageList), [create, imortwhere, importwherePage])

Imports a set of pages (given as a tuple) from an existing document (the file name must be given). This functions maps the &quot;Page-&gt;Import&quot; dropdown menu function.
fromDoc: string; the filename of the document to import pages from
pageList: tuple with page numbers of pages to import
create: number; 0 to replace existing pages, 1 (default) to insert new pages
importWhere: number; the page number (of the current document) at which import the pages
importWherePage: number; used if create==1; 0 to create pages before selected page; 1 to create pages after selected page; 2 (default) to create pages at the end of the document
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="22"/>
        <source>setGradientFill(type, &quot;color1&quot;, shade1, &quot;color2&quot;, shade2, [&quot;name&quot;])

Sets the gradient fill of the object &quot;name&quot; to type. Color descriptions are
the same as for setFillColor() and setFillShade(). See the constants for
available types (FILL_&lt;type&gt;).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="33"/>
        <source>setFillColor(&quot;color&quot;, [&quot;name&quot;])

Sets the fill color of the object &quot;name&quot; to the color &quot;color&quot;. &quot;color&quot;
is the name of one of the defined colors. If &quot;name&quot; is not given the
currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="43"/>
        <source>setFillTransparency(transparency, [&quot;name&quot;])

Sets the fill transparency of the object &quot;name&quot; to transparency
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="53"/>
        <source>setFillBlendmode(blendmode, [&quot;name&quot;])

Sets the fill blendmode of the object &quot;name&quot; to blendmode
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="63"/>
        <source>setLineColor(&quot;color&quot;, [&quot;name&quot;])

Sets the line color of the object &quot;name&quot; to the color &quot;color&quot;. If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="73"/>
        <source>setLineTransparency(transparency, [&quot;name&quot;])

Sets the line transparency of the object &quot;name&quot; to transparency
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="83"/>
        <source>setLineBlendmode(blendmode, [&quot;name&quot;])

Sets the line blendmode of the object &quot;name&quot; to blendmode
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="96"/>
        <source>setLineWidth(width, [&quot;name&quot;])

Sets line width of the object &quot;name&quot; to &quot;width&quot;. &quot;width&quot; must be in the
range from 0.0 to 12.0 inclusive, and is measured in points. If &quot;name&quot; is not
given the currently selected item is used.

May raise ValueError if the line width is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="110"/>
        <source>setLineShade(shade, [&quot;name&quot;])

Sets the shading of the line color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full color intensity). If &quot;name&quot; is not given the currently selected item
is used.

May raise ValueError if the line shade is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="121"/>
        <source>setLineJoin(join, [&quot;name&quot;])

Sets the line join style of the object &quot;name&quot; to the style &quot;join&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for join - JOIN_&lt;type&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="132"/>
        <source>setLineEnd(endtype, [&quot;name&quot;])

Sets the line cap style of the object &quot;name&quot; to the style &quot;cap&quot;.
If &quot;name&quot; is not given the currently selected item is used. There are
predefined constants for &quot;cap&quot; - CAP_&lt;type&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="143"/>
        <source>setLineStyle(style, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the style &quot;style&quot;. If &quot;name&quot;
is not given the currently selected item is used. There are predefined
constants for &quot;style&quot; - LINE_&lt;style&gt;.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="157"/>
        <source>setFillShade(shade, [&quot;name&quot;])

Sets the shading of the fill color of the object &quot;name&quot; to &quot;shade&quot;.
&quot;shade&quot; must be an integer value in the range from 0 (lightest) to 100
(full Color intensity). If &quot;name&quot; is not given the currently selected
Item is used.

May raise ValueError if the fill shade is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="169"/>
        <source>setCornerRadius(radius, [&quot;name&quot;])

Sets the corner radius of the object &quot;name&quot;. The radius is expressed
in points. If &quot;name&quot; is not given the currently selected item is used.

May raise ValueError if the corner radius is negative.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.h" line="181"/>
        <source>setMultiLine(&quot;namedStyle&quot;, [&quot;name&quot;])

Sets the line style of the object &quot;name&quot; to the named style &quot;namedStyle&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise NotFoundError if the line style doesn&apos;t exist.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.h" line="43"/>
        <source>createParagraphStyle(...)

Creates a paragraph style. This function takes the following keyword parameters:

&quot;name&quot; [required] -&gt; specifies the name of the paragraphstyle to create

linespacingmode [optional] -&gt; specifies the linespacing mode; possible modes are:

fixed linespacing:          0

automatic linespacing:      1

baseline grid linespacing:  2

linespacing [optional] -&gt; specifies the linespacing if using fixed linespacing

alignment [optional] -&gt; specifies the alignment of the paragraph

-&gt; left:     0

-&gt; center:   1

-&gt; right:    2

-&gt; justify:  3

-&gt; extend:   4

leftmargin [optional], rightmargin [optional] -&gt; specify the margin

gapbefore [optional], gapafter [optional] -&gt; specify the gaps to the heading and following paragraphs

firstindent [optional] -&gt; the indent of the first line

hasdropcap [optional] -&gt; specifies if there are caps (1 = yes, 0 = no)

dropcaplines [optional] -&gt; height (in lines) of the caps if used

dropcapoffset [optional] -&gt; offset of the caps if used

&quot;charstyle&quot; [optional] -&gt; char style to use

</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdstyle.h" line="80"/>
        <source>createCharStyle(...)

Creates a character style. This function takes the following keyword parameters:

&quot;name&quot; [required] -&gt; name of the char style to create

&quot;font&quot; [optional] -&gt; name of the font to use

fontsize [optional] -&gt; font size to set (double)

&quot;features&quot; [optional] -&gt; nearer typographic details can be defined by a string that might contain the following phrases comma-seperated (without spaces!):

-&gt; inherit

-&gt; bold

-&gt; italic

-&gt; underline

-&gt; underlinewords

-&gt; strike

-&gt; superscript

-&gt; subscript

-&gt; outline

-&gt; shadowed

-&gt; allcaps

-&gt; smallcaps

&quot;fillcolor&quot; [optional], &quot;fillshade&quot; [optional] -&gt; specify fill options

&quot;strokecolor&quot; [optional], &quot;strokeshade&quot; [optional] -&gt; specify stroke options

baselineoffset [optional] -&gt; offset of the baseline

shadowxoffset [optional], shadowyoffset [optional] -&gt; offset of the shadow if used

outlinewidth [optional] -&gt; width of the outline if used

underlineoffset [optional], underlinewidth [optional] -&gt; underline options if used

strikethruoffset [optional], strikethruwidth [optional] -&gt; strikethru options if used

scaleh [optional], scalev [optional] -&gt; scale of the chars

tracking [optional] -&gt; tracking of the text

&quot;language&quot; [optional] -&gt; language code

</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="23"/>
        <source>getFontSize([&quot;name&quot;]) -&gt; float

Returns the font size in points for the text frame &quot;name&quot;. If this text
frame has some text selected the value assigned to the first character of
the selection is returned.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="35"/>
        <source>getFont([&quot;name&quot;]) -&gt; string

Returns the font name for the text frame &quot;name&quot;. If this text frame
has some text selected the value assigned to the first character
of the selection is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="45"/>
        <source>getTextLength([&quot;name&quot;]) -&gt; integer

Returns the length of the text in the text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="55"/>
        <source>getTextLines([&quot;name&quot;]) -&gt; integer

Returns the number of lines of the text in the text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="67"/>
        <source>getText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot;. If this text frame has some text
selected, the selected text is returned. All text in the frame, not just
currently visible text, is returned. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="79"/>
        <source>getAllText([&quot;name&quot;]) -&gt; string

Returns the text of the text frame &quot;name&quot; and of all text frames which are
linked with this frame. If this textframe has some text selected, the selected
text is returned. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="89"/>
        <source>getLineSpacing([&quot;name&quot;]) -&gt; float

Returns the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; expressed in
points. If &quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="100"/>
        <source>getTextDistances([&quot;name&quot;]) -&gt; tuple

Returns the text distances of the text frame &quot;name&quot; expressed in points. The
distances are returned as a tuple like (left, right, top, bottom). If &quot;name&quot;
is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="110"/>
        <source>getColumnGap([&quot;name&quot;]) -&gt; float

Returns the column gap size of the text frame &quot;name&quot; expressed in points. If
&quot;name&quot; is not given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="120"/>
        <source>getColumns([&quot;name&quot;]) -&gt; integer

Gets the number of columns of the text frame &quot;name&quot;. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="132"/>
        <source>setText(&quot;text&quot;, [&quot;name&quot;])

Sets the text of the text frame &quot;name&quot; to the text of the string &quot;text&quot;.
Text must be UTF8 encoded - use e.g. unicode(text, &apos;iso-8859-2&apos;). See the FAQ
for more details. If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="146"/>
        <source>insertText(&quot;text&quot;, pos, [&quot;name&quot;])

Inserts the text &quot;text&quot; at the position &quot;pos&quot; into the text frame &quot;name&quot;.
Text must be UTF encoded (see setText() as reference) The first character has an
index of 0. Inserting text at position -1 appends it to the frame. If &quot;name&quot; is
not given the currently selected Item is used.

May throw IndexError for an insertion out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="159"/>
        <source>setFont(&quot;font&quot;, [&quot;name&quot;])

Sets the font of the text frame &quot;name&quot; to &quot;font&quot;. If there is some text
selected only the selected text is changed.  If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError if the font cannot be found.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="173"/>
        <source>setFontSize(size, [&quot;name&quot;])

Sets the font size of the text frame &quot;name&quot; to &quot;size&quot;. &quot;size&quot; is treated
as a value in points. If there is some text selected only the selected text is
changed. &quot;size&quot; must be in the range 1 to 512. If &quot;name&quot; is not given the
currently selected item is used.

May throw ValueError for a font size that&apos;s out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="186"/>
        <source>setLineSpacing(size, [&quot;name&quot;])

Sets the line spacing (&quot;leading&quot;) of the text frame &quot;name&quot; to &quot;size&quot;.
&quot;size&quot; is a value in points. If &quot;name&quot; is not given the currently selected
item is used.

May throw ValueError if the line spacing is out of bounds.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="199"/>
        <source>setTextDistances(left, right, top, bottom, [&quot;name&quot;])

Sets the text distances of the text frame &quot;name&quot; to the values &quot;left&quot;
&quot;right&quot;, &quot;top&quot; and &quot;bottom&quot;. If &quot;name&quot; is not given the currently
selected item is used.

May throw ValueError if any of the distances are out of bounds (must be positive).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="211"/>
        <source>setColumnGap(size, [&quot;name&quot;])

Sets the column gap of the text frame &quot;name&quot; to the value &quot;size&quot;. If
&quot;name&quot; is not given the currently selected item is used.

May throw ValueError if the column gap is out of bounds (must be positive).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="223"/>
        <source>setColumns(nr, [&quot;name&quot;])

Sets the number of columns of the text frame &quot;name&quot; to the integer &quot;nr&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May throw ValueError if number of columns is not at least one.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="236"/>
        <source>setTextAlignment(align, [&quot;name&quot;])

Sets the text alignment of the text frame &quot;name&quot; to the specified alignment.
If &quot;name&quot; is not given the currently selected item is used. &quot;align&quot; should
be one of the ALIGN_ constants defined in this module - see dir(scribus).

May throw ValueError for an invalid alignment constant.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="250"/>
        <source>selectText(start, count, [&quot;name&quot;])

Selects &quot;count&quot; characters of text in the text frame &quot;name&quot; starting from the
character &quot;start&quot;. Character counting starts at 0. If &quot;count&quot; is zero, any
text selection will be cleared.  If &quot;name&quot; is not given the currently
selected item is used.

May throw IndexError if the selection is outside the bounds of the text.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="261"/>
        <source>deleteText([&quot;name&quot;])

Deletes any text in the text frame &quot;name&quot;. If there is some text selected,
only the selected text will be deleted. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="272"/>
        <source>setTextColor(&quot;color&quot;, [&quot;name&quot;])

Sets the text color of the text frame &quot;name&quot; to the color &quot;color&quot;. If there
is some text selected only the selected text is changed. If &quot;name&quot; is not
given the currently selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="282"/>
        <source>setTextStroke(&quot;color&quot;, [&quot;name&quot;])

Set &quot;color&quot; of the text stroke. If &quot;name&quot; is not given the currently
selected item is used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="295"/>
        <source>setTextShade(shade, [&quot;name&quot;])

Sets the shading of the text color of the object &quot;name&quot; to &quot;shade&quot;. If
there is some text selected only the selected text is changed. &quot;shade&quot; must
be an integer value in the range from 0 (lightest) to 100 (full color
intensity). If &quot;name&quot; is not given the currently selected item is
used.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="308"/>
        <source>linkTextFrames(&quot;fromname&quot;, &quot;toname&quot;)

Link two text frames. The frame named &quot;fromname&quot; is linked to the
frame named &quot;toname&quot;. The target frame must be an empty text frame
and must not link to or be linked from any other frames already.

May throw ScribusException if linking rules are violated.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="325"/>
        <source>unlinkTextFrames(&quot;name&quot;)

Remove the specified (named) object from the text frame flow/linkage. If the
frame was in the middle of a chain, the previous and next frames will be
connected, eg &apos;a-&gt;b-&gt;c&apos; becomes &apos;a-&gt;c&apos; when you unlinkTextFrames(b)&apos;

May throw ScribusException if linking rules are violated.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="338"/>
        <source>traceText([&quot;name&quot;])

Convert the text frame &quot;name&quot; to outlines. If &quot;name&quot; is not given the
currently selected item is used.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="352"/>
        <source>textOverflows([&quot;name&quot;, nolinks]) -&gt; integer

Returns the actual number of overflowing characters in text frame &quot;name&quot;.
If is nolinks set to non zero value it takes only one frame - it doesn&apos;t
use text frame linking. Without this parameter it search all linking chain.

May raise WrongFrameTypeError if the target frame is not an text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="365"/>
        <source>hyphenateText([&quot;name&quot;]) -&gt; bool

Does hyphenation on text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="379"/>
        <source>dehyphenateText([&quot;name&quot;]) -&gt; bool

Does dehyphenation on text frame &quot;name&quot;.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="394"/>
        <source>setPDFBookmark(&quot;toggle&quot;, [&quot;name&quot;])

Sets whether (toggle = 1) the text frame &quot;name&quot; is a bookmark nor not.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.h" line="406"/>
        <source>isPDFBookmark([&quot;name&quot;]) -&gt; bool

Returns true if the text frame &quot;name&quot; is a PDF bookmark.
If &quot;name&quot; is not given the currently selected item is used.

May raise WrongFrameTypeError if the target frame is not a text frame
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="21"/>
        <source>messagebarText(&quot;string&quot;)

Writes the &quot;string&quot; into the Scribus message bar (status line). The text
must be UTF8 encoded or &apos;unicode&apos; string(recommended).
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="34"/>
        <source>progressReset()

Cleans up the Scribus progress bar previous settings. It is called before the
new progress bar use. See progressSet.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="47"/>
        <source>progressTotal(max)

Sets the progress bar&apos;s maximum steps value to the specified number.
See progressSet.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="61"/>
        <source>progressSet(nr)

Set the progress bar position to &quot;nr&quot;, a value relative to the previously set
progressTotal. The progress bar uses the concept of steps; you give it the
total number of steps and the number of steps completed so far and it will
display the percentage of steps that have been completed. You can specify the
total number of steps with progressTotal(). The current number of steps is set
with progressSet(). The progress bar can be rewound to the beginning with
progressReset(). [based on info taken from Trolltech&apos;s Qt docs]
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="69"/>
        <source>setCursor()

[UNSUPPORTED!] This might break things, so steer clear for now.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="83"/>
        <source>docChanged(bool)

Enable/disable save icon in the Scribus icon bar and the Save menu item. It&apos;s
useful to call this procedure when you&apos;re changing the document, because Scribus
won&apos;t automatically notice when you change the document using a script.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="95"/>
        <source>zoomDocument(double)

Zoom the document in main GUI window. Actions have whole number
values like 20.0, 100.0, etc. Zoom to Fit uses -100 as a marker.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/guiapp.h" line="106"/>
        <source>scrollDocument(x,y)

Scroll the document in main GUI window by x and y.
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="21"/>
        <source>placeSVG(&quot;filename&quot;, x, y)

Places the SVG &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the SVG placed on the page

If loading was successful, the selection contains the imported SVG
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="33"/>
        <source>placeEPS(&quot;filename&quot;, x, y)

Places the EPS &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the EPS placed on the page

If loading was successful, the selection contains the imported EPS
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="45"/>
        <source>placeSXD(&quot;filename&quot;, x, y)

Places the SXD &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the SXD placed on the page

If loading was successful, the selection contains the imported SXD
</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/svgimport.h" line="57"/>
        <source>placeODG(&quot;filename&quot;, x, y)

Places the ODG &quot;filename&quot; onto the current page,
x and y specify the coordinate of the topleft corner of the ODG placed on the page

If loading was successful, the selection contains the imported ODG
</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AIPlug</name>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="124"/>
        <source>Importing: %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="127"/>
        <source>Analyzing File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="264"/>
        <source>Group%1</source>
        <translation type="unfinished">Grupp%1</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importai.cpp" line="2226"/>
        <source>Generating Items</source>
        <translation type="unfinished">Elementide genereerimine</translation>
    </message>
</context>
<context>
    <name>About</name>
    <message>
        <location filename="../../scribus/about.cpp" line="97"/>
        <source>About Scribus %1</source>
        <translation>Scribus %1 info</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="124"/>
        <source>%1 %2 %3</source>
        <translation>%1 %2 %3</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="132"/>
        <source>%3-%2-%1 %4 %5</source>
        <translation>%3-%2-%1 %4 %5</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="182"/>
        <source>Using Ghostscript version %1</source>
        <translation>Ghostscripti versioon %1</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="184"/>
        <source>No Ghostscript version available</source>
        <translation>Ghostscripti versioon pole teada</translation>
    </message>
    <message>
        <location filename="../about.cpp" line="132"/>
        <source>&lt;b&gt;Scribus Version %1&lt;/b&gt;&lt;p&gt;%2&lt;br/&gt;%3 %4&lt;br/&gt;%5&lt;/p&gt;</source>
        <translation type="obsolete">&lt;b&gt;Scribuse versioon %1&lt;/b&gt;&lt;p&gt;%2&lt;br/&gt;%3 %4&lt;br/&gt;%5&lt;/p&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="185"/>
        <source>Build ID:</source>
        <translation>Ehitamise ID:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="187"/>
        <source>&amp;About</source>
        <translation>&amp;Info</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="296"/>
        <source>Development Team:</source>
        <translation>Arendajate meeskond:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="304"/>
        <source>Contributions from:</source>
        <translation>Kaasautorid:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="298"/>
        <source>Mac OS&amp;#174; X Aqua Port:</source>
        <translation>Mac OS&amp;#174; X Aqua port:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="302"/>
        <source>Windows&amp;#174; Port:</source>
        <translation>Windows&amp;#174; port:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="306"/>
        <source>Official Documentation:</source>
        <translation>Ametlik dokumentatsioon:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="310"/>
        <source>Other Documentation:</source>
        <translation>Muu dokumentatsioon:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="316"/>
        <source>Tango Project Icons:</source>
        <translation>Tango projekti ikoonid:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="200"/>
        <source>A&amp;uthors</source>
        <translation>A&amp;utorid</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="328"/>
        <source>Official Translations and Translators:</source>
        <translation>Ametlikud tõlked ja tõlkijad:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="330"/>
        <source>Previous Translation Contributors:</source>
        <translation>Varasemad tõlkijad:</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="214"/>
        <source>&amp;Translations</source>
        <translation>&amp;Tõlked</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="344"/>
        <source>Homepage</source>
        <translation>Kodulehekülg</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="346"/>
        <source>Online Reference</source>
        <translation>Dokumentatsioon internetis</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="348"/>
        <source>Wiki</source>
        <translation>Wiki</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="350"/>
        <source>Bugs and Feature Requests</source>
        <translation>Veateated ja soovid</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="354"/>
        <source>Mailing List</source>
        <translation>Meililist</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="225"/>
        <source>&amp;Online</source>
        <translation>I&amp;nternet</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="264"/>
        <source>&amp;Close</source>
        <translation>S&amp;ulge</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This panel shows the version, build date and compiled in library support in Scribus. The C-C-T-F equates to C=littlecms C=CUPS T=TIFF support F=Fontconfig support. Last Letter is the renderer C=cairo or A=libart Missing library support is indicated by a *. This also indicates the version of Ghostscript which Scribus has detected.</source>
        <translation type="obsolete">See dialoog näitab Scribuse versiooni, ehitamise aega ja kompileeritud teekide toetust. Lühendis C-C-T-F tähendab C littlecms&apos;i, teine C CUPS-i, T TIFF-i ja F Fontconfig&apos;i tuge. Viimane täht näitab renderdajat: C=cairo või A=libart. Teegi toe puudumist näitab *. Samuti näeb siin Ghostscripti versiooni, mille Scribus leidis.</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="228"/>
        <source>&amp;Updates</source>
        <translation>&amp;Uuendused</translation>
    </message>
    <message>
        <location filename="../about.cpp" line="411"/>
        <source>Check for &amp;Updates</source>
        <translation type="obsolete">Kontrolli &amp;uuendusi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This panel shows the version, build date and compiled in library support in Scribus. The C-C-T-F equates to C=littlecms C=CUPS T=TIFF support F=Fontconfig support. Last Letter is the renderer C=cairo or A=libart Missing library support is indicated by a *. This also indicates the version of Ghostscript which Scribus has detected. The Windows version does not use fontconfig or CUPS libraries.</source>
        <translation type="obsolete">See dialoog näitab Scribuse versiooni, ehitamise aega ja kompileeritud teekide toetust. Lühendis C-C-T-F tähendab C littlecms&apos;i, teine C CUPS-i, T TIFF-i ja F Fontconfig&apos;i tuge. Viimane täht näitab renderdajat: C=cairo või A=libart. Teegi toe puudumist näitab *. Samuti näeb siin Ghostscripti versiooni, mille Scribus leidis. Windowsi versioon ei kasuta Fontconfig&apos;i ega CUPS-i teeke.</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="276"/>
        <source>Check for updates to Scribus. No data from your machine will be transferred off it.</source>
        <translation>Scribuse uuenduste kontrollimine. Masinast ei saadeta selleks välja mingeid andmeid.</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="300"/>
        <source>OS/2&amp;#174;/eComStation&amp;#8482; Port:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="314"/>
        <source>Splash Screen:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="272"/>
        <source>This panel shows the version, build date and compiled in library support in Scribus.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="273"/>
        <source>The C-C-T-F equates to C=littlecms C=CUPS T=TIFF support F=Fontconfig support.Last Letter is the renderer C=cairo or Q=Qt</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="274"/>
        <source>Missing library support is indicated by a *. This also indicates the version of Ghostscript which Scribus has detected.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="275"/>
        <source>The Windows version does not use fontconfig or CUPS libraries.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="185"/>
        <source>&lt;p align=&quot;center&quot;&gt;&lt;b&gt;%1 %2&lt;/b&gt;&lt;/p&gt;&lt;p align=&quot;center&quot;&gt;%3&lt;br&gt;%4 %5&lt;br&gt;%6&lt;/p&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="185"/>
        <source>Scribus Version</source>
        <translation type="unfinished">Scribuse versioon</translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="648"/>
        <source>Check for Updates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="646"/>
        <source>Abort Update Check</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="352"/>
        <source>Developer Blog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="239"/>
        <source>&amp;Licence</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="248"/>
        <source>Unable to open licence file. Please check your install directory or the Scribus website for licencing information.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="308"/>
        <source>Doc Translators:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="312"/>
        <source>Webmasters:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/about.cpp" line="624"/>
        <source>Unable to open %1 file. Please check your install directory or the Scribus website for %1 information.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AboutPlugins</name>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="68"/>
        <source>Filename:</source>
        <translation>Failinimi:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="69"/>
        <source>Version:</source>
        <translation>Versioon:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Yes</source>
        <translation type="obsolete">Jah</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No</source>
        <translation type="obsolete">Ei</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="72"/>
        <source>Enabled:</source>
        <translation>Lubatud:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="73"/>
        <source>Release Date:</source>
        <translation>Väljalaskeaeg:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="80"/>
        <source>Description:</source>
        <translation>Kirjeldus:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="81"/>
        <source>Author(s):</source>
        <translation>Autor(id):</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="82"/>
        <source>Copyright:</source>
        <translation>Autoriõigus:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.cpp" line="83"/>
        <source>License:</source>
        <translation>Litsents:</translation>
    </message>
    <message>
        <location filename="../../scribus/aboutplugins.ui" line="13"/>
        <source>Scribus: About Plug-ins</source>
        <translation type="unfinished">Scribus: pluginate info</translation>
    </message>
</context>
<context>
    <name>AboutPluginsBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Scribus: About Plug-ins</source>
        <translation type="obsolete">Scribus: pluginate info</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Close</source>
        <translation type="obsolete">S&amp;ulge</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
</context>
<context>
    <name>ActionManager</name>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1254"/>
        <source>&amp;New</source>
        <translation>&amp;Uus</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1255"/>
        <source>&amp;Open...</source>
        <translation>&amp;Ava...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1256"/>
        <source>&amp;Close</source>
        <translation>S&amp;ulge</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1257"/>
        <source>&amp;Save</source>
        <translation>&amp;Salvesta</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1258"/>
        <source>Save &amp;As...</source>
        <translation>Salvesta &amp;kui...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1259"/>
        <source>Re&amp;vert to Saved</source>
        <translation>&amp;Taasta salvestatud versioon</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1260"/>
        <source>Collect for O&amp;utput...</source>
        <translation>Ko&amp;gu väljundiks...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1261"/>
        <source>Get Text...</source>
        <translation>Hangi tekst...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1262"/>
        <source>Append &amp;Text...</source>
        <translation>Lisa &amp;tekst...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1263"/>
        <source>Get Image...</source>
        <translation>Hangi pilt...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1266"/>
        <source>Save &amp;Text...</source>
        <translation>Salvesta &amp;tekst...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1267"/>
        <source>Save as &amp;EPS...</source>
        <translation>Salvesta &amp;EPS-failina...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1268"/>
        <source>Save as P&amp;DF...</source>
        <translation>Salvesta P&amp;DF-failina...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1269"/>
        <source>Document &amp;Setup...</source>
        <translation>Dokumendi &amp;seadistused...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1271"/>
        <source>&amp;Print...</source>
        <translation>&amp;Trüki...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1272"/>
        <source>Print Previe&amp;w</source>
        <translation>T&amp;rükkimise eelvaatlus</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1273"/>
        <source>&amp;Quit</source>
        <translation>&amp;Välju</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1275"/>
        <source>&amp;Undo</source>
        <translation>&amp;Võta tagasi</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1276"/>
        <source>&amp;Redo</source>
        <translation>&amp;Tee uuesti</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1277"/>
        <source>&amp;Item Action Mode</source>
        <translation>Val&amp;itud elemendi režiim</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1278"/>
        <source>Cu&amp;t</source>
        <translation>&amp;Lõika</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1281"/>
        <source>&amp;Copy</source>
        <translation>&amp;Kopeeri</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1282"/>
        <source>&amp;Paste</source>
        <translation>&amp;Aseta</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1283"/>
        <source>Paste (&amp;Absolute)</source>
        <translation>Aseta (a&amp;bsoluutselt)</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1284"/>
        <source>C&amp;lear</source>
        <translation>&amp;Puhasta</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1285"/>
        <source>Select &amp;All</source>
        <translation>&amp;Vali kõik</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1287"/>
        <source>&amp;Deselect All</source>
        <translation>&amp;Tühista kõik valikud</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1288"/>
        <source>&amp;Search/Replace...</source>
        <translation>Ot&amp;si/asenda...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1289"/>
        <source>Edit Image...</source>
        <translation>Redigeeri pilti...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1291"/>
        <source>C&amp;olors...</source>
        <translation>Vä&amp;rvid...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1294"/>
        <source>S&amp;tyles...</source>
        <translation>S&amp;tiilid...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Paragraph Styles...</source>
        <translation type="obsolete">&amp;Lõigu stiilid...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Line Styles...</source>
        <translation type="obsolete">&amp;Joone stiilid...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1295"/>
        <source>&amp;Master Pages...</source>
        <translation>Le&amp;heküljetoorikud...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1296"/>
        <source>&amp;JavaScripts...</source>
        <translation>&amp;JavaScriptid...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1270"/>
        <source>P&amp;references...</source>
        <translation>&amp;Seadistused...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1303"/>
        <source>%1 pt</source>
        <translation>%1 pt</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1305"/>
        <source>&amp;Other...</source>
        <translation>&amp;Muu...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1306"/>
        <source>&amp;Left</source>
        <translation>&amp;Vasakule</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1307"/>
        <source>&amp;Center</source>
        <translation>&amp;Keskele</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1308"/>
        <source>&amp;Right</source>
        <translation>&amp;Paremale</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1309"/>
        <source>&amp;Block</source>
        <translation>&amp;Rööpjoondus</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1310"/>
        <source>&amp;Forced</source>
        <translation>Pü&amp;siv rööpjoondus</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1294"/>
        <source>&amp;%1 %</source>
        <translation type="obsolete">&amp;%1 %</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1321"/>
        <source>&amp;Normal</source>
        <translation>&amp;Normaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1322"/>
        <source>&amp;Underline</source>
        <translation>Alla&amp;joonitud</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1323"/>
        <source>Underline &amp;Words</source>
        <translation>&amp;Sõnade allajoonimine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1324"/>
        <source>&amp;Strike Through</source>
        <translation>&amp;Läbikriipsutatud</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1325"/>
        <source>&amp;All Caps</source>
        <translation>S&amp;uurtähed</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1326"/>
        <source>Small &amp;Caps</source>
        <translation>&amp;Kapiteelkiri</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1327"/>
        <source>Su&amp;perscript</source>
        <translation>Ü&amp;laindeks</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1328"/>
        <source>Su&amp;bscript</source>
        <translation>Ala&amp;indeks</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1329"/>
        <source>&amp;Outline</source>
        <comment>type effect</comment>
        <translation>K&amp;ontuur</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1330"/>
        <source>S&amp;hadow</source>
        <translation>&amp;Vari</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1332"/>
        <source>&amp;Image Effects</source>
        <translation>&amp;Pildiefektid</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1333"/>
        <source>&amp;Tabulators...</source>
        <translation>&amp;Tabeldusmärgid...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1336"/>
        <source>D&amp;uplicate</source>
        <translation>&amp;Klooni</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1337"/>
        <source>&amp;Multiple Duplicate</source>
        <translation>Klooni &amp;mitmekordselt</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1338"/>
        <source>&amp;Delete</source>
        <translation>K&amp;ustuta</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1339"/>
        <source>&amp;Group</source>
        <translation>&amp;Rühmita</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1340"/>
        <source>&amp;Ungroup</source>
        <translation>Lõh&amp;u rühm</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1341"/>
        <source>Is &amp;Locked</source>
        <translation>&amp;Lukustatud</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1342"/>
        <source>Si&amp;ze is Locked</source>
        <translation>&amp;Suurus lukustatud</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1343"/>
        <source>&amp;Printing Enabled</source>
        <translation>&amp;Trükkimine lubatud</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1344"/>
        <source>&amp;Flip Horizontally</source>
        <translation>Pee&amp;gelda rõhtsalt</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1345"/>
        <source>&amp;Flip Vertically</source>
        <translation>Pee&amp;gelda püstiselt</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1346"/>
        <source>Lower to &amp;Bottom</source>
        <translation>V&amp;ii kõige taha</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1347"/>
        <source>Raise to &amp;Top</source>
        <translation>Too &amp;kõige ette</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1348"/>
        <source>&amp;Lower</source>
        <translation>&amp;Vii tahapoole</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1349"/>
        <source>&amp;Raise</source>
        <translation>&amp;Too ettepoole</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1350"/>
        <source>Send to S&amp;crapbook</source>
        <translation>Saada &amp;visandimappi</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1352"/>
        <source>&amp;Attributes...</source>
        <translation>&amp;Atribuudid...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1353"/>
        <source>More Info...</source>
        <translation>Rohkem infot...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1354"/>
        <source>I&amp;mage Visible</source>
        <translation>Pilt &amp;nähtaval</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1355"/>
        <source>&amp;Update Image</source>
        <translation>&amp;Uuenda pilti</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1356"/>
        <source>Adjust Frame to Image</source>
        <translation>Sobita pilt kasti</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1358"/>
        <source>Extended Image Properties</source>
        <translation>Pildi laiendatud omadused</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1359"/>
        <source>&amp;Low Resolution</source>
        <translation>&amp;Madala kvaliteediga</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1360"/>
        <source>&amp;Normal Resolution</source>
        <translation>&amp;Normaalse kvaliteediga</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1361"/>
        <source>&amp;Full Resolution</source>
        <translation>&amp;Täieliku kvaliteediga</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1362"/>
        <source>Is PDF &amp;Bookmark</source>
        <translation>On PDF-i &amp;järjehoidja</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1363"/>
        <source>Is PDF A&amp;nnotation</source>
        <translation>On PDF-i &amp;annotatsioon</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1364"/>
        <source>Annotation P&amp;roperties</source>
        <translation>A&amp;nnotatsiooni omadused</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1365"/>
        <source>Field P&amp;roperties</source>
        <translation>&amp;Välja omadused</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1366"/>
        <source>&amp;Edit Shape...</source>
        <translation>&amp;Muuda kuju...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1367"/>
        <source>&amp;Attach Text to Path</source>
        <translation>Lis&amp;a tekst trajektoorile</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1368"/>
        <source>&amp;Detach Text from Path</source>
        <translation>&amp;Haagi tekst trajektoori küljest lahti</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1369"/>
        <source>&amp;Combine Polygons</source>
        <translation>Ü&amp;henda hulknurgad</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1370"/>
        <source>Split &amp;Polygons</source>
        <translation>Lah&amp;uta hulknurgad</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1371"/>
        <source>&amp;Bezier Curve</source>
        <translation>&amp;Bezier&apos; kõver</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1372"/>
        <source>&amp;Image Frame</source>
        <translation>P&amp;ildikast</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1373"/>
        <source>&amp;Outlines</source>
        <comment>Convert to oulines</comment>
        <translation>&amp;Kontuurid</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1374"/>
        <source>&amp;Polygon</source>
        <translation>&amp;Hulknurk</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1375"/>
        <source>&amp;Text Frame</source>
        <translation>&amp;Tekstikast</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1379"/>
        <source>&amp;Glyph...</source>
        <translation>&amp;Glüüf...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1380"/>
        <source>Sample Text</source>
        <translation>Näidistekst</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1384"/>
        <source>&amp;Insert...</source>
        <translation>L&amp;isa...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1385"/>
        <source>Im&amp;port...</source>
        <translation>Im&amp;pordi...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1386"/>
        <source>&amp;Delete...</source>
        <translation>&amp;Eemalda...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1387"/>
        <source>&amp;Copy...</source>
        <translation>&amp;Kopeeri...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1388"/>
        <source>&amp;Move...</source>
        <translation>&amp;Liiguta...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1389"/>
        <source>&amp;Apply Master Page...</source>
        <translation>&amp;Rakenda leheküljetoorikut...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1390"/>
        <source>Convert to Master Page...</source>
        <translation>Salvesta leheküljetoorikuna...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1391"/>
        <source>Manage &amp;Guides...</source>
        <translation>Halda &amp;juhtjooni...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1392"/>
        <source>Manage Page Properties...</source>
        <translation>Halda lehekülje omadusi...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Fit in window</source>
        <translation type="obsolete">So&amp;bita aknasse</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1397"/>
        <source>&amp;50%</source>
        <translation>&amp;50%</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1398"/>
        <source>&amp;75%</source>
        <translation>&amp;75%</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1399"/>
        <source>&amp;100%</source>
        <translation>&amp;100%</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1400"/>
        <source>&amp;200%</source>
        <translation>&amp;200%</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Thumbnails</source>
        <translation type="obsolete">&amp;Pisipildid</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1403"/>
        <source>Show &amp;Margins</source>
        <translation>&amp;Veeriste näitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1405"/>
        <source>Show &amp;Frames</source>
        <translation>&amp;Kastide näitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1407"/>
        <source>Show &amp;Images</source>
        <translation>P&amp;iltide näitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1408"/>
        <source>Show &amp;Grid</source>
        <translation>&amp;Alusvõrgu näitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1409"/>
        <source>Show G&amp;uides</source>
        <translation>&amp;Juhtjoonte näitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1411"/>
        <source>Show &amp;Baseline Grid</source>
        <translation>Al&amp;usjoonte näitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1412"/>
        <source>Show &amp;Text Chain</source>
        <translation>&amp;Tekstiahela näitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1413"/>
        <source>Show Control Characters</source>
        <translation>Mittetrükitavate märkide näitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1414"/>
        <source>Show Rulers</source>
        <translation>Joonlaudade näitamine</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1399"/>
        <source>Rulers relative to Page</source>
        <translation type="obsolete">Joonlauad on seotud leheküljega</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1416"/>
        <source>Sn&amp;ap to Grid</source>
        <translation>Tõmme &amp;alusvõrgule</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1417"/>
        <source>Sna&amp;p to Guides</source>
        <translation>Tõmme &amp;juhtjoontele</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1422"/>
        <source>&amp;Properties</source>
        <translation>&amp;Omadused</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1423"/>
        <source>&amp;Outline</source>
        <comment>Document Outline Palette</comment>
        <translation>&amp;Struktuur</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1424"/>
        <source>&amp;Scrapbook</source>
        <translation>&amp;Visandimapp</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1425"/>
        <source>&amp;Layers</source>
        <translation>&amp;Kihid</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1426"/>
        <source>&amp;Arrange Pages</source>
        <translation>L&amp;ehekülgede korraldamine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1427"/>
        <source>&amp;Bookmarks</source>
        <translation>&amp;Järjehoidjad</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1428"/>
        <source>&amp;Measurements</source>
        <translation>&amp;Mõõdud</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1429"/>
        <source>Action &amp;History</source>
        <translation>T&amp;oimingute ajalugu</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1430"/>
        <source>Preflight &amp;Verifier</source>
        <translation>Trük&amp;ieelne kontroll</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1431"/>
        <source>&amp;Align and Distribute</source>
        <translation>Joo&amp;ndus ja jaotus</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1432"/>
        <source>&amp;Tools</source>
        <translation>&amp;Tööriistad</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1433"/>
        <source>P&amp;DF Tools</source>
        <translation>P&amp;DF-i tööriistad</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1436"/>
        <source>Select Item</source>
        <translation>Vali element</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1351"/>
        <source>T&amp;able</source>
        <translation type="obsolete">T&amp;abel</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1352"/>
        <source>&amp;Shape</source>
        <translation type="obsolete">&amp;Kujund</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1354"/>
        <source>&amp;Line</source>
        <translation type="obsolete">&amp;Joon</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1356"/>
        <source>&amp;Freehand Line</source>
        <translation type="obsolete">&amp;Vabakäejoon</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1437"/>
        <source>Rotate Item</source>
        <translation>Pööra elementi</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1438"/>
        <source>Zoom in or out</source>
        <translation>Suurenda või vähenda</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1439"/>
        <source>Zoom in</source>
        <translation>Suurenda</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1440"/>
        <source>Zoom out</source>
        <translation>Vähenda</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1441"/>
        <source>Edit Contents of Frame</source>
        <translation>Redigeeri kasti sisu</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1442"/>
        <source>Edit Text...</source>
        <translation>Redigeeri teksti...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1443"/>
        <source>Link Text Frames</source>
        <translation>Lingi tekstikastid</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1444"/>
        <source>Unlink Text Frames</source>
        <translation>Eemalda tekstikastide link</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1445"/>
        <source>&amp;Eye Dropper</source>
        <translation>&amp;Värvivalija</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1446"/>
        <source>Copy Item Properties</source>
        <translation>Kopeeri elemendi omadused</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1368"/>
        <source>Edit the text with the Story Editor</source>
        <translation type="obsolete">Redigeeri teksti looredaktoris</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1370"/>
        <source>Insert Text Frame</source>
        <translation type="obsolete">Lisa tekstikast</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1371"/>
        <source>Insert Image Frame</source>
        <translation type="obsolete">Lisa pildikast</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1372"/>
        <source>Insert Table</source>
        <translation type="obsolete">Lisa tabel</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1373"/>
        <source>Insert Shape</source>
        <translation type="obsolete">Lisa kujund</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1374"/>
        <source>Insert Polygon</source>
        <translation type="obsolete">Lisa hulknurk</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1375"/>
        <source>Insert Line</source>
        <translation type="obsolete">Lisa joon</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1376"/>
        <source>Insert Bezier Curve</source>
        <translation type="obsolete">Lisa Bezier&apos; kõver</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1377"/>
        <source>Insert Freehand Line</source>
        <translation type="obsolete">Lisa vabakäejoon</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1458"/>
        <source>Insert PDF Push Button</source>
        <translation>Lisa PDF-i kinnitusnupp</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1459"/>
        <source>Insert PDF Text Field</source>
        <translation>Lisa PDF-i tekstiväli</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1460"/>
        <source>Insert PDF Check Box</source>
        <translation>Lisa PDF-i märkekast</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1461"/>
        <source>Insert PDF Combo Box</source>
        <translation>Lisa PDF-i liitkast</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1462"/>
        <source>Insert PDF List Box</source>
        <translation>Lisa PDF-i nimekirjakast</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1463"/>
        <source>Insert Text Annotation</source>
        <translation>Lisa teksti annotatsioon</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1464"/>
        <source>Insert Link Annotation</source>
        <translation>Lisa lingi annotatsioon</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1412"/>
        <source>&amp;Manage Pictures</source>
        <translation type="obsolete">Piltide &amp;haldamine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1469"/>
        <source>&amp;Hyphenate Text</source>
        <translation>&amp;Poolitamise lubamine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1470"/>
        <source>Dehyphenate Text</source>
        <translation>Poolitamise keelamine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1471"/>
        <source>&amp;Generate Table Of Contents</source>
        <translation>Sisukorra &amp;genereerimine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1474"/>
        <source>&amp;Cascade</source>
        <translation>&amp;Kaskaadi</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1475"/>
        <source>&amp;Tile</source>
        <translation>&amp;Paanidena</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1478"/>
        <source>&amp;About Scribus</source>
        <translation>&amp;Scribuse info</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1423"/>
        <source>&amp;About Plug-ins</source>
        <translation type="obsolete">&amp;Pluginate info</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1480"/>
        <source>About &amp;Qt</source>
        <translation>&amp;Qt info</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1481"/>
        <source>Toolti&amp;ps</source>
        <translation>&amp;Vihjed</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1483"/>
        <source>Scribus &amp;Manual...</source>
        <translation>S&amp;cribuse käsiraamat...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1491"/>
        <source>Toggle Palettes</source>
        <translation>Lülita palette</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1492"/>
        <source>Toggle Guides</source>
        <translation>Lülita juhtjooni</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1501"/>
        <source>Smart &amp;Hyphen</source>
        <translation>&amp;Poolituskoht</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1502"/>
        <source>Non Breaking Dash</source>
        <translation>Sidekriips</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1503"/>
        <source>Non Breaking &amp;Space</source>
        <translation>&amp;Sisetühik</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1504"/>
        <source>Page &amp;Number</source>
        <translation>Lehekülje&amp;number</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1506"/>
        <source>New Line</source>
        <translation>Uus rida</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1507"/>
        <source>Frame Break</source>
        <translation>Kasti katkestus</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1508"/>
        <source>Column Break</source>
        <translation>Veeru katkestus</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1511"/>
        <source>Copyright</source>
        <translation>Autoriõigus</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1512"/>
        <source>Registered Trademark</source>
        <translation>Registreeritud kaubamärk</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1513"/>
        <source>Trademark</source>
        <translation>Kaubamärk</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1514"/>
        <source>Solidus</source>
        <translation>Kaldkriips</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1515"/>
        <source>Bullet</source>
        <translation>Täpp</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1516"/>
        <source>Middle Dot</source>
        <translation>Punkt keskel</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1517"/>
        <source>Em Dash</source>
        <translation>Pikk mõttekriips</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1518"/>
        <source>En Dash</source>
        <translation>Lühike mõttekriips</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1519"/>
        <source>Figure Dash</source>
        <translation>Arvuvahemiku kriips</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1520"/>
        <source>Quotation Dash</source>
        <translation>Tsitaadikriips</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apostrophe</source>
        <translation type="obsolete">Ülakoma</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Straight Double</source>
        <translation type="obsolete">Sirged topelt</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Left</source>
        <translation type="obsolete">Ühekordne vasakpoolne</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Right</source>
        <translation type="obsolete">Ühekordne parempoolne</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Left</source>
        <translation type="obsolete">Kahekordne vasakpoolne</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Right</source>
        <translation type="obsolete">Kahekordne parempoolne</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Reversed</source>
        <translation type="obsolete">Ühekordne ümberpööratud</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Reversed</source>
        <translation type="obsolete">Kahekordne ümberpööratud</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Left Guillemet</source>
        <translation type="obsolete">Ühekordne vasakpoolne prantsuse</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Single Right Guillemet</source>
        <translation type="obsolete">Ühekordne parempoolne prantsuse</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Left Guillemet</source>
        <translation type="obsolete">Kahekordne vasakpoolne prantsuse</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Right Guillemet</source>
        <translation type="obsolete">Kahekordne parempoolne prantsuse</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Low Single Comma</source>
        <translation type="obsolete">Ühekordne alumine koma</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Low Double Comma</source>
        <translation type="obsolete">Kahekordne alumine koma</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Single Left</source>
        <translation type="obsolete">CJK ühekordne vasakpoolne</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Single Right</source>
        <translation type="obsolete">CJK ühekordne parempoolne</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Double Left</source>
        <translation type="obsolete">CJK kahekordne vasakpoolne</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CJK Double Right</source>
        <translation type="obsolete">CJK kahekordne parempoolne</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1541"/>
        <source>En Space</source>
        <translation>Enn-tühik</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1542"/>
        <source>Em Space</source>
        <translation>Emm-tühik</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1543"/>
        <source>Thin Space</source>
        <translation>Kitsas tühik</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1544"/>
        <source>Thick Space</source>
        <translation>Lai tühik</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1545"/>
        <source>Mid Space</source>
        <translation>Keskmine tühik</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1546"/>
        <source>Hair Space</source>
        <translation>Juuksekarvatühik</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1461"/>
        <source>Insert Smart Hyphen</source>
        <translation type="obsolete">Lisa poolituskoht</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1462"/>
        <source>Insert Non Breaking Dash</source>
        <translation type="obsolete">Lisa sidekriips</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1463"/>
        <source>Insert Non Breaking Space</source>
        <translation type="obsolete">Lisa sisetühik</translation>
    </message>
    <message>
        <location filename="../actionmanager.cpp" line="1464"/>
        <source>Insert Page Number</source>
        <translation type="obsolete">Lisa leheküljenumber</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1558"/>
        <source>ff</source>
        <translation>ff</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1559"/>
        <source>fi</source>
        <translation>fi</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1560"/>
        <source>fl</source>
        <translation>fl</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1561"/>
        <source>ffi</source>
        <translation>ffi</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1562"/>
        <source>ffl</source>
        <translation>ffl</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1563"/>
        <source>ft</source>
        <translation>ft</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1564"/>
        <source>st</source>
        <translation>st</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1410"/>
        <source>Show Text Frame Columns</source>
        <translation>Tekstikasti veergude näitamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Get Text 2...</source>
        <translation type="obsolete">Hangi tekst 2...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1378"/>
        <source>&amp;Frame...</source>
        <translation>&amp;Kast...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1402"/>
        <source>Preview Mode</source>
        <translation>Eelvaatluse režiim</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1406"/>
        <source>Show Layer Indicators</source>
        <translation>Kihi indikaatorite näitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1293"/>
        <source>Patterns...</source>
        <translation>Mustrid...</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1351"/>
        <source>Send to Patterns</source>
        <translation>Lisatakse mustritesse</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1381"/>
        <source>Sticky Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1395"/>
        <source>&amp;Fit to Height</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1396"/>
        <source>Fit to Width</source>
        <translation type="unfinished">Mahutamine laiusele</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1404"/>
        <source>Show Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1509"/>
        <source>&amp;Zero Width Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1510"/>
        <source>Zero Width NB Space</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1522"/>
        <source>Apostrophe</source>
        <comment>Unicode 0x0027</comment>
        <translation type="unfinished">Ülakoma</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1523"/>
        <source>Straight Double</source>
        <comment>Unicode 0x0022</comment>
        <translation type="unfinished">Sirged topelt</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1524"/>
        <source>Single Left</source>
        <comment>Unicode 0x2018</comment>
        <translation type="unfinished">Ühekordne vasakpoolne</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1525"/>
        <source>Single Right</source>
        <comment>Unicode 0x2019</comment>
        <translation type="unfinished">Ühekordne parempoolne</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1526"/>
        <source>Double Left</source>
        <comment>Unicode 0x201C</comment>
        <translation type="unfinished">Kahekordne vasakpoolne</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1527"/>
        <source>Double Right</source>
        <comment>Unicode 0x201D</comment>
        <translation type="unfinished">Kahekordne parempoolne</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1528"/>
        <source>Single Reversed</source>
        <comment>Unicode 0x201B</comment>
        <translation type="unfinished">Ühekordne ümberpööratud</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1529"/>
        <source>Double Reversed</source>
        <comment>Unicode 0x201F</comment>
        <translation type="unfinished">Kahekordne ümberpööratud</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1530"/>
        <source>Single Left Guillemet</source>
        <comment>Unicode 0x2039</comment>
        <translation type="unfinished">Ühekordne vasakpoolne prantsuse</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1531"/>
        <source>Single Right Guillemet</source>
        <comment>Unicode 0x203A</comment>
        <translation type="unfinished">Ühekordne parempoolne prantsuse</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1532"/>
        <source>Double Left Guillemet</source>
        <comment>Unicode 0x00AB</comment>
        <translation type="unfinished">Kahekordne vasakpoolne prantsuse</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1533"/>
        <source>Double Right Guillemet</source>
        <comment>Unicode 0x00BB</comment>
        <translation type="unfinished">Kahekordne parempoolne prantsuse</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1534"/>
        <source>Low Single Comma</source>
        <comment>Unicode 0x201A</comment>
        <translation type="unfinished">Ühekordne alumine koma</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1535"/>
        <source>Low Double Comma</source>
        <comment>Unicode 0x201E</comment>
        <translation type="unfinished">Kahekordne alumine koma</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1536"/>
        <source>CJK Single Left</source>
        <comment>Unicode 0x300C</comment>
        <translation type="unfinished">CJK ühekordne vasakpoolne</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1537"/>
        <source>CJK Single Right</source>
        <comment>Unicode 0x300D</comment>
        <translation type="unfinished">CJK ühekordne parempoolne</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1538"/>
        <source>CJK Double Left</source>
        <comment>Unicode 0x300E</comment>
        <translation type="unfinished">CJK kahekordne vasakpoolne</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1539"/>
        <source>CJK Double Right</source>
        <comment>Unicode 0x300F</comment>
        <translation type="unfinished">CJK kahekordne parempoolne</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1401"/>
        <source>&amp;400%</source>
        <translation type="unfinished">&amp;200% {400%?}</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1448"/>
        <source>Insert &amp;Text Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1449"/>
        <source>Insert &amp;Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1451"/>
        <source>Insert T&amp;able</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1452"/>
        <source>Insert &amp;Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1453"/>
        <source>Insert &amp;Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1454"/>
        <source>Insert &amp;Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1455"/>
        <source>Insert &amp;Bezier Curve</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1456"/>
        <source>Insert &amp;Freehand Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1484"/>
        <source>Scribus Homepage</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1485"/>
        <source>Scribus Online Documentation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1486"/>
        <source>Scribus Wiki</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1487"/>
        <source>Getting Started with Scribus</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1418"/>
        <source>Show Context Menu</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1468"/>
        <source>&amp;Manage Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1479"/>
        <source>&amp;About Plugins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1493"/>
        <source>Insert Unicode Character Begin Sequence</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1264"/>
        <source>Get Vector File...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1286"/>
        <source>Advanced Select All...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1290"/>
        <source>Edit Source...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1292"/>
        <source>Replace Colors...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1415"/>
        <source>Rulers Relative to Page</source>
        <translation type="unfinished">Joonlauad on seotud leheküljega</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1450"/>
        <source>Insert &amp;Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1488"/>
        <source>Check for Updates</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1505"/>
        <source>Number of Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1357"/>
        <source>Adjust Image to Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1685"/>
        <source>File</source>
        <translation type="unfinished">Fail</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1685"/>
        <source>&amp;File</source>
        <translation type="unfinished">&amp;Fail</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1687"/>
        <source>Edit</source>
        <translation type="unfinished">Redigeerimine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1687"/>
        <source>&amp;Edit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1689"/>
        <source>Style</source>
        <translation type="unfinished">Stiil</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1689"/>
        <source>&amp;Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1691"/>
        <source>Item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1691"/>
        <source>&amp;Item</source>
        <translation type="unfinished">&amp;Element</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1693"/>
        <source>Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1693"/>
        <source>I&amp;nsert</source>
        <translation type="unfinished">L&amp;isamine</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1695"/>
        <source>Page</source>
        <translation type="unfinished">Lehekülg</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1695"/>
        <source>&amp;Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1697"/>
        <source>View</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1697"/>
        <source>&amp;View</source>
        <translation type="unfinished">&amp;Vaade</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1699"/>
        <source>Extras</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1699"/>
        <source>E&amp;xtras</source>
        <translation type="unfinished">E&amp;kstra</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1701"/>
        <source>Windows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1701"/>
        <source>&amp;Windows</source>
        <translation type="unfinished">&amp;Aknad</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1703"/>
        <source>Help</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1703"/>
        <source>&amp;Help</source>
        <translation type="unfinished">A&amp;bi</translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1871"/>
        <source>Plugin Menu Items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1873"/>
        <source>Others</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1875"/>
        <source>Unicode Characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/actionmanager.cpp" line="1482"/>
        <source>Move/Resize Value Indicator</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AdjustCmsDialog</name>
    <message>
        <location filename="../../scribus/adjustcmsdialog.cpp" line="16"/>
        <source>CMS Settings</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AlignDistribute</name>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="35"/>
        <source>Align</source>
        <translation type="unfinished">Joondus</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="79"/>
        <source>&amp;Selected Guide:</source>
        <translation type="unfinished">&amp;Valitud juhtjoon:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="92"/>
        <source>&amp;Relative To:</source>
        <translation type="unfinished">&amp;Seotud:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="431"/>
        <source>...</source>
        <translation type="unfinished">...</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="270"/>
        <source>Distribute</source>
        <translation type="unfinished">Jaotus</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.ui" line="490"/>
        <source>&amp;Distance:</source>
        <translation type="unfinished">Va&amp;hemaa:</translation>
    </message>
</context>
<context>
    <name>AlignDistributeBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Align and Distribute</source>
        <translation type="obsolete">Joondus ja jaotus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align</source>
        <translation type="obsolete">Joondus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Selected Guide:</source>
        <translation type="obsolete">&amp;Valitud juhtjoon:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Relative To:</source>
        <translation type="obsolete">&amp;Seotud:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>...</source>
        <translation type="obsolete">...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distribute</source>
        <translation type="obsolete">Jaotus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Distance:</source>
        <translation type="obsolete">Va&amp;hemaa:</translation>
    </message>
</context>
<context>
    <name>AlignDistributePalette</name>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="90"/>
        <source>Align and Distribute</source>
        <translation>Joondus ja jaotus</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="91"/>
        <source>Align</source>
        <translation type="unfinished">Joondus</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="93"/>
        <source>&amp;Relative to:</source>
        <translation>&amp;Joondamise alus:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="96"/>
        <source>First Selected</source>
        <translation>Esimene valitud</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="97"/>
        <source>Last Selected</source>
        <translation>Viimane valitud</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="98"/>
        <source>Page</source>
        <translation>Lehekülg</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="99"/>
        <source>Margins</source>
        <translation>Veerised</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="100"/>
        <source>Guide</source>
        <translation>Juhtjoon</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="101"/>
        <source>Selection</source>
        <translation>Valik</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align right sides of objects to left side of anchor</source>
        <translation type="obsolete">Objektide parema serva joondamine ankru vasaku serva järgi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align left sides of objects to right side of anchor</source>
        <translation type="obsolete">Objektide vasaku serva joondamine ankru parema serva järgi</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="111"/>
        <source>Align bottoms</source>
        <translation>Joondamine alumise serva järgi</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="113"/>
        <source>Align right sides</source>
        <translation>Joondamine parema serva järgi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align tops of objects to bottom of anchor</source>
        <translation type="obsolete">Objektide ülemise serva joondamine ankru alumise serva järgi</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="117"/>
        <source>Center on vertical axis</source>
        <translation>Tsentreerimine püstteljel</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="119"/>
        <source>Align left sides</source>
        <translation>Joondamine vasaku serva järgi</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="121"/>
        <source>Center on horizontal axis</source>
        <translation>Tsentreerimine rõhtteljel</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Align bottoms of objects to top of anchor</source>
        <translation type="obsolete">Objektide alumise serva joondamine ankru ülemise serva järgi</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="125"/>
        <source>Align tops</source>
        <translation>Joondamine ülemise serva järgi</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="127"/>
        <source>&amp;Selected Guide:</source>
        <translation>&amp;Valitud juhtjoon:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="92"/>
        <source>Distribute</source>
        <translation type="unfinished">Jaotus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make horizontal gaps between objects equal</source>
        <translation type="obsolete">Objektide rõhtsate vahede võrdsustamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make horizontal gaps between objects equal to the value specified</source>
        <translation type="obsolete">Objektide rõhtsate vahede võrdsustamine määratud väärtuse järgi</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="135"/>
        <source>Distribute right sides equidistantly</source>
        <translation>Paremate servade võrdsed vahed</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="137"/>
        <source>Distribute bottoms equidistantly</source>
        <translation>Alumiste servade võrdsed vahed</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="139"/>
        <source>Distribute centers equidistantly horizontally</source>
        <translation>Rõhtsuunas keskmete võrdsed vahed</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make vertical gaps between objects equal</source>
        <translation type="obsolete">Objektide püstiste vahede võrdsustamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make vertical gaps between objects equal to the value specified</source>
        <translation type="obsolete">Objektide püstiste vahede võrdsustamine määratud väärtuse järgi</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="145"/>
        <source>Distribute left sides equidistantly</source>
        <translation>Vasakute servade võrdsed vahed</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="147"/>
        <source>Distribute centers equidistantly vertically</source>
        <translation>Püstsuunas keskmete võrdsed vahed</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="149"/>
        <source>Distribute tops equidistantly</source>
        <translation>Ülemiste servade võrdsed vahed</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="159"/>
        <source>&amp;Distance:</source>
        <translation>Va&amp;hemaa:</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="160"/>
        <source>Distribute the items with the distance specified</source>
        <translation>Elementide jaotus määratud vahemaa järgi</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="162"/>
        <source>None Selected</source>
        <translation>Valik puudub</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="443"/>
        <source>Y: %1%2</source>
        <translation>Y: %1%2</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="451"/>
        <source>X: %1%2</source>
        <translation>X: %1%2</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make horizontal gaps between objects and sides of page equal</source>
        <translation type="obsolete">Objektide ja lehekülje külgede rõhtsate vahede võrdsustamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make vertical gaps between objects and the top and bottom of page margins equal</source>
        <translation type="obsolete">Objektide ja lehekülje üla- ja alaveerise püstiste vahede võrdsustamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make horizontal gaps between objects and sides of page margins equal</source>
        <translation type="obsolete">Objektide ja lehekülje külgveeriste rõhtsate vahede võrdsustamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make vertical gaps between objects and the top and bottom of page equal</source>
        <translation type="obsolete">Objektide ja lehekülje üla- ja alaserva püstiste vahede võrdsustamine</translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="107"/>
        <source>Align right sides of items to left side of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="109"/>
        <source>Align left sides of items to right side of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="115"/>
        <source>Align tops of items to bottom of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="123"/>
        <source>Align bottoms of items to top of anchor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="130"/>
        <source>Make horizontal gaps between items equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="132"/>
        <source>Make horizontal gaps between items equal to the value specified</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="141"/>
        <source>Make vertical gaps between items equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="143"/>
        <source>Make vertical gaps between items equal to the value specified</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="151"/>
        <source>Make horizontal gaps between items and sides of page equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="157"/>
        <source>Make vertical gaps between items and the top and bottom of page margins equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="155"/>
        <source>Make horizontal gaps between items and sides of page margins equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="153"/>
        <source>Make vertical gaps between items and the top and bottom of page equal</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="103"/>
        <source>&lt;qt&gt;Align relative to the:&lt;ul&gt;&lt;li&gt;First selected item&lt;/li&gt;&lt;li&gt;Second Selected Item&lt;/li&gt;&lt;li&gt;The current page&lt;/li&gt;&lt;li&gt;The margins of the current page&lt;/li&gt;&lt;li&gt;A Guide&lt;/li&gt;&lt;li&gt;The selection&lt;/ul&gt;&lt;/qt&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/aligndistribute.cpp" line="105"/>
        <source>The location of the selected guide to align to</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AlignSelect</name>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="110"/>
        <source>Align Text Left</source>
        <translation>Joonda tekst vasakule</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="111"/>
        <source>Align Text Right</source>
        <translation>Joonda tekst paremale</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="112"/>
        <source>Align Text Center</source>
        <translation>Joonda tekst keskele</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="113"/>
        <source>Align Text Justified</source>
        <translation>Rööpjoondus</translation>
    </message>
    <message>
        <location filename="../../scribus/alignselect.cpp" line="114"/>
        <source>Align Text Forced Justified</source>
        <translation>Püsiv rööpjoondus</translation>
    </message>
</context>
<context>
    <name>Annot</name>
    <message>
        <location filename="../../scribus/annot.cpp" line="61"/>
        <source>Field Properties</source>
        <translation>Välja omadused</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="533"/>
        <source>Type:</source>
        <translation>Tüüp:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Button</source>
        <translation>Nupp</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Text Field</source>
        <translation>Tekstiväli</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Check Box</source>
        <translation>Märkekast</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>Combo Box</source>
        <translation>Liitkast</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="96"/>
        <source>List Box</source>
        <translation>Nimekirjakast</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="111"/>
        <source>Properties</source>
        <translation>Omadused</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="121"/>
        <source>Name:</source>
        <translation>Nimi:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tool-Tip:</source>
        <translation type="obsolete">Kohtspikker:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="274"/>
        <source>Text</source>
        <translation>Tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="152"/>
        <source>Font for use with PDF 1.3:</source>
        <translation>Font PDF 1.2 jaoks:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="176"/>
        <source>Border</source>
        <translation>Piire</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="182"/>
        <source>Color:</source>
        <translation>Värv:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="197"/>
        <source>Width:</source>
        <translation>Laius:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="201"/>
        <source>Thin</source>
        <translation>Peen</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="311"/>
        <source>Normal</source>
        <translation>Normaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="201"/>
        <source>Wide</source>
        <translation>Lai</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="209"/>
        <source>Style:</source>
        <translation>Stiil:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="213"/>
        <source>Solid</source>
        <translation>Ühtlane</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="213"/>
        <source>Dashed</source>
        <translation>Punktiir</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="213"/>
        <source>Underline</source>
        <translation>Allajoonitud</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="214"/>
        <source>Beveled</source>
        <translation>Esilekerkiv</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="214"/>
        <source>Inset</source>
        <translation>Süvistatud</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="224"/>
        <source>Other</source>
        <translation>Muu</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="230"/>
        <source>Read Only</source>
        <translation>Ainult lugemiseks</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="236"/>
        <source>Required</source>
        <translation>Nõutav</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Don&apos;t Export Value</source>
        <translation type="obsolete">Väärtust ei ekspordita</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="248"/>
        <source>Visibility:</source>
        <translation>Nähtavus:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="252"/>
        <source>Visible</source>
        <translation>Nähtav</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="252"/>
        <source>Hidden</source>
        <translation>Peidetud</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="252"/>
        <source>No Print</source>
        <translation>Ei trükita</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="253"/>
        <source>No View</source>
        <translation>Ei näidata</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="262"/>
        <source>Appearance</source>
        <translation>Välimus</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="280"/>
        <source>Text for Button Down</source>
        <translation>Button Down tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="283"/>
        <source>Text for Roll Over</source>
        <translation>Roll Over tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="294"/>
        <source>Icons</source>
        <translation>Ikoonid</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="300"/>
        <source>Use Icons</source>
        <translation>Ikoonide kasutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="357"/>
        <source>Remove</source>
        <translation>Eemalda</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="329"/>
        <source>Pressed</source>
        <translation>Allavajutatud</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="347"/>
        <source>Roll Over</source>
        <translation>Pealeliikumisel</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="366"/>
        <source>Icon Placement...</source>
        <translation>Ikooni paigutus...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="414"/>
        <source>Highlight</source>
        <translation>Esiletõstmine</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>None</source>
        <comment>highlight</comment>
        <translation>Puudub</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>Invert</source>
        <translation>Inverteeritud</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>Outlined</source>
        <translation>Kontuuriga</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="421"/>
        <source>Push</source>
        <translation>Vajutatav</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="438"/>
        <source>Multi-Line</source>
        <translation>Mitmerealine</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="442"/>
        <source>Password</source>
        <translation>Parool</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="449"/>
        <source>Limit of</source>
        <translation>Piiratud</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="460"/>
        <source>Characters</source>
        <translation>märgiga</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="466"/>
        <source>Do Not Scroll</source>
        <translation>Ei kerita</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="470"/>
        <source>Do Not Spell Check</source>
        <translation>Õigekirja ei kontrollita</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="485"/>
        <source>Check Style:</source>
        <translation>Märkimise stiil:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Check</source>
        <translation>Linnuke</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Cross</source>
        <translation>Rist</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Diamond</source>
        <translation>Romb</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Circle</source>
        <translation>Ring</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Star</source>
        <translation>Täht</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="488"/>
        <source>Square</source>
        <translation>Ruut</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="502"/>
        <source>Default is Checked</source>
        <translation>Vaikimisi on märgitud</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="514"/>
        <source>Editable</source>
        <translation>Redigeeritav</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="521"/>
        <source>Options</source>
        <translation>Valikud</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2050"/>
        <source>None</source>
        <comment>action</comment>
        <translation>Puudub</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2088"/>
        <source>JavaScript</source>
        <translation>JavaScript</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2050"/>
        <source>Go To</source>
        <translation>Liikumine</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2051"/>
        <source>Submit Form</source>
        <translation>Vormi saatmine</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2051"/>
        <source>Reset Form</source>
        <translation>Vormi lähtetamine</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2051"/>
        <source>Import Data</source>
        <translation>Andmete import</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="570"/>
        <source>Event:</source>
        <translation>Sündmus:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2030"/>
        <source>Mouse Up</source>
        <translation>Hiir alla</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2030"/>
        <source>Mouse Down</source>
        <translation>Hiir üles</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2030"/>
        <source>Mouse Enter</source>
        <translation>Hiir peale</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2031"/>
        <source>Mouse Exit</source>
        <translation>Hiir ära</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2031"/>
        <source>On Focus</source>
        <translation>Fookuses</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2031"/>
        <source>On Blur</source>
        <translation>Pole fookuses</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="585"/>
        <source>Script:</source>
        <translation>Skript:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1095"/>
        <source>Edit...</source>
        <translation>Redigeeri...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="670"/>
        <source>Submit to URL:</source>
        <translation>Saatmine URL-ile:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="678"/>
        <source>Submit Data as HTML</source>
        <translation>Andmed saadetakse HTML-ina</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="691"/>
        <source>Import Data from:</source>
        <translation>Andmed imporditakse asukohast:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="610"/>
        <source>Destination</source>
        <translation>Sihtkoht</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="616"/>
        <source>To File:</source>
        <translation>Fail:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="623"/>
        <source>Change...</source>
        <translation>Muuda...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="632"/>
        <source>Page:</source>
        <translation>Lehekülg:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="646"/>
        <source>X-Pos:</source>
        <translation>X-asukoht:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="658"/>
        <source> pt</source>
        <translation> pt</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="654"/>
        <source>Y-Pos:</source>
        <translation>Y-asukoht:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="700"/>
        <source>Action</source>
        <translation>Toiming</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="731"/>
        <source>Field is formatted as:</source>
        <translation>Välja vorming:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Plain</source>
        <translation>Puhas</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Number</source>
        <translation>Arv</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Percentage</source>
        <translation>Protsent</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Date</source>
        <translation>Kuupäev</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Time</source>
        <translation>Kellaaeg</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="734"/>
        <source>Custom</source>
        <translation>Kohandatud</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="752"/>
        <source>Number Format</source>
        <translation>Arvuvorming</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="820"/>
        <source>Decimals:</source>
        <translation>Kümnendkohti:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="775"/>
        <source>Use Currency Symbol</source>
        <translation>Rahasümboli kasutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="784"/>
        <source>Prepend Currency Symbol</source>
        <translation>Rahasümbol ees</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="831"/>
        <source>Formatting</source>
        <translation>Vorming</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="811"/>
        <source>Percent Format</source>
        <translation>Protsendivorming</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="854"/>
        <source>Date Format</source>
        <translation>Kuupäevavorming</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="880"/>
        <source>Time Format</source>
        <translation>Kellaajavorming</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="902"/>
        <source>Custom Scripts</source>
        <translation>Kohandatud skriptid</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="914"/>
        <source>Format:</source>
        <translation>Vorming:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="940"/>
        <source>Keystroke:</source>
        <translation>Klahv:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="964"/>
        <source>Format</source>
        <translation>Vorming</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="980"/>
        <source>Value is not validated</source>
        <translation>Väärtuse sobivust ei kontrollita</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="989"/>
        <source>Value must be greater than or equal to:</source>
        <translation>Väärtus peab olema suurem kui või võrdne:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="993"/>
        <source>and less or equal to:</source>
        <translation>ja väiksem kui või võrdne:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1004"/>
        <source>Custom validate script:</source>
        <translation>Kohandatud sobivuse kontrollimise skript:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1025"/>
        <source>Validate</source>
        <translation>Sobivuse kontroll</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1042"/>
        <source>Value is not calculated</source>
        <translation>Väärtust ei arvutata</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1051"/>
        <source>Value is the</source>
        <translation>Väärtus on järgmiste väljade</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>sum</source>
        <translation>summa</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>product</source>
        <translation>korrutis</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>average</source>
        <translation>keskmine</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1056"/>
        <source>minimum</source>
        <translation>miinimum</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1057"/>
        <source>maximum</source>
        <translation>maksimum</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1064"/>
        <source>of the following fields:</source>
        <translation> :</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1074"/>
        <source>Pick...</source>
        <translation>Vali...</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1079"/>
        <source>Custom calculation script:</source>
        <translation>Kohandatud arvutamise skript:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1099"/>
        <source>Calculate</source>
        <translation>Arvutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1118"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1122"/>
        <source>Cancel</source>
        <translation>Loobu</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1174"/>
        <source>Flag is ignored for PDF 1.3</source>
        <translation>Lippu ignoreeritakse PDF 1.3 korral</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1175"/>
        <source>Enter a comma separated list of fields here</source>
        <translation>Sisesta siia komadega eraldatult väljade nimekiri</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1176"/>
        <source>You need at least the Icon for Normal to use Icons for Buttons</source>
        <translation>Nuppudel ikoonide kasutamiseks on vaja vähemalt normaalse nupu ikooni</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2244"/>
        <source>Open</source>
        <translation>Avamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;PostScript (*.eps);;All Files (*)</source>
        <translation type="obsolete">Pildid (*.tif *.png *.jpg *.xpm);;PostScript (*.eps);;Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1453"/>
        <source>Example:</source>
        <translation>Näide:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2079"/>
        <source>Selection Change</source>
        <translation>Valiku muutmine</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2087"/>
        <source>None</source>
        <translation>Puudub</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="2244"/>
        <source>PDF Files (*.pdf);;All Files (*)</source>
        <translation>PDF-failid (*.pdf);;Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="134"/>
        <source>Tooltip:</source>
        <translation>Kohtspikker:</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="242"/>
        <source>Do Not Export Value</source>
        <translation>Väärtust ei ekspordita</translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1342"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;PostScript (*.eps *.epsi);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="1287"/>
        <source>Images (*.tif *.png *.jpg *.xpm);;%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annot.cpp" line="625"/>
        <source>Export absolute Filename</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Annota</name>
    <message>
        <location filename="../../scribus/annota.cpp" line="47"/>
        <source>Annotation Properties</source>
        <translation>Annotatsiooni omadused</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="77"/>
        <source>Text</source>
        <translation>Tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="78"/>
        <source>Link</source>
        <translation>Link</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="79"/>
        <source>External Link</source>
        <translation>Väline link</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="80"/>
        <source>External Web-Link</source>
        <translation>Väline veebilink</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="82"/>
        <source>&amp;Type:</source>
        <translation>&amp;Tüüp:</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="118"/>
        <source>Destination</source>
        <translation>Sihtkoht</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="129"/>
        <source>C&amp;hange...</source>
        <translation>&amp;Muuda...</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="147"/>
        <source>&amp;Page:</source>
        <translation>&amp;Lehekülg:</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="177"/>
        <source> pt</source>
        <translation>pt</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="171"/>
        <source>&amp;X-Pos</source>
        <translation>&amp;X-asukoht</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="179"/>
        <source>&amp;Y-Pos:</source>
        <translation>&amp;Y-asukoht:</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="409"/>
        <source>Open</source>
        <translation>Avamine</translation>
    </message>
    <message>
        <location filename="../annota.cpp" line="351"/>
        <source>PDF-Documents (*.pdf);;All Files (*)</source>
        <translation type="obsolete">PDF-dokumendid (*.pdf);;Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="409"/>
        <source>%1;;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/annota.cpp" line="131"/>
        <source>Export absolute Filename</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ApplyMasterPageDialog</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal</source>
        <translation type="obsolete">Normaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="267"/>
        <source>Apply Master Page</source>
        <translation>Leheküljetooriku rakendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="268"/>
        <source>&amp;Master Page:</source>
        <translation>&amp;Leheküljetoorik:</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="269"/>
        <source>Apply To</source>
        <translation>Rakendatakse</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="270"/>
        <source>Current &amp;page</source>
        <translation>&amp;Aktiivsele leheküljele</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="271"/>
        <source>Alt+P</source>
        <translation>Alt+P</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="272"/>
        <source>&amp;Even pages</source>
        <translation>&amp;Paarislehekülgedele</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="273"/>
        <source>Alt+E</source>
        <translation>Alt+E</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="274"/>
        <source>O&amp;dd pages</source>
        <translation>Paa&amp;ritutele lehekülgedele</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="275"/>
        <source>Alt+D</source>
        <translation>Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="276"/>
        <source>&amp;All pages</source>
        <translation>&amp;Kõigile lehekülgedele</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="277"/>
        <source>Alt+A</source>
        <translation>Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="278"/>
        <source>&amp;Within range</source>
        <translation>&amp;Vahemikule</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="279"/>
        <source>Alt+W</source>
        <translation>Alt+W</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="280"/>
        <source>Apply the selected master page to even, odd or all pages within the following range</source>
        <translation>Valitud leheküljetooriku rakendamine paaris-, paaritutele või kõigile lehekülgedele määratud vahemikus</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="281"/>
        <source>to</source>
        <translation>kuni</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="283"/>
        <source>Alt+O</source>
        <translation>Alt+O</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="285"/>
        <source>Alt+C</source>
        <translation>Alt+C</translation>
    </message>
    <message>
        <location filename="../../scribus/applytemplatedialog.cpp" line="52"/>
        <source>Possible Hyphenation</source>
        <translation type="unfinished">Võimalik poolitus</translation>
    </message>
</context>
<context>
    <name>ArrowChooser</name>
    <message>
        <location filename="../arrowchooser.cpp" line="33"/>
        <source>None</source>
        <translation type="obsolete">Puudub</translation>
    </message>
</context>
<context>
    <name>AspellPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="64"/>
        <source>Spell-checking support</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="69"/>
        <source>Adds support for spell-checking via aspell. Languages can be chosen from among the installed aspell dictionaries, and spell-checking can be done on the fly, or on selected text.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="70"/>
        <source>0.1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="32"/>
        <source>Spell Checker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellplugin.cpp" line="95"/>
        <source>Aspell Plugin Error</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AspellPluginBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="13"/>
        <source>Spell Check</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="118"/>
        <source>Replacement:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="278"/>
        <source>&amp;Add Word</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="306"/>
        <source>&amp;Change</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="351"/>
        <source>&amp;Exit</source>
        <translation type="obsolete">&amp;Välju</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="45"/>
        <source>Not in Dictionary:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="70"/>
        <source>Word that was not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="125"/>
        <source>Replacement text for the current word that was not found in the dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="181"/>
        <source>Active Dictionary: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="194"/>
        <source>The currently active dictionary. Scribus uses aspell for dictionary support.&lt;br /&gt;If you require updated or more dictionaries, you should install them via your system&apos;s installation system or package manager.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="225"/>
        <source>Ignore the current text not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="228"/>
        <source>&amp;Ignore</source>
        <translation type="unfinished">&amp;Ignoreeri</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="247"/>
        <source>Ignore all occurrences of the current text not found in the active dictionary</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="250"/>
        <source>I&amp;gnore All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="275"/>
        <source>Add the current word to the your personal spelling dictionary for future use</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="303"/>
        <source>Change the current word that was not found to that shown in the replacement entry field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="331"/>
        <source>Change all occurrences of the current word in the text that was not found to that shown in the replacement entry field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="334"/>
        <source>Change A&amp;ll</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginbase.ui" line="372"/>
        <source>Close</source>
        <translation type="unfinished">Sulge</translation>
    </message>
</context>
<context>
    <name>AspellPluginImpl</name>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="32"/>
        <source>Loaded </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="32"/>
        <source>default </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="32"/>
        <source> aspell dictionary.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="79"/>
        <source>aspellplugin (AspellPluginImpl::AspellPluginImpl): Error in aspell speller configuration.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="86"/>
        <source>aspellplugin (AspellPluginImpl::AspellPluginImpl): Error in creating aspell speller.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="337"/>
        <source>AspellPluginImpl::on_fskipAllBtn_clicked(): Unable to skip all instances of &quot;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="338"/>
        <source> by adding it to the session list.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="360"/>
        <source>AspellPluginImpl::on_faddWordBtn_clicked(): Unable to add word to personal list.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="218"/>
        <source>Spelling check complete</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="405"/>
        <source>Spell Checker</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="57"/>
        <source>No available Aspell dictionaries found. Install some, please.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/spellcheck/aspellpluginimpl.cpp" line="407"/>
        <source>Do you want start from the beginning of the selection with new language selected?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>AutoformButtonGroup</name>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1280"/>
        <source>Arrows</source>
        <translation type="unfinished">Nooled</translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1281"/>
        <source>Flow Chart</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1282"/>
        <source>Jigsaw</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1283"/>
        <source>Specials</source>
        <translation type="unfinished">Erisümbolid</translation>
    </message>
    <message>
        <location filename="../../scribus/autoformbuttongroup.cpp" line="1279"/>
        <source>Default Shapes</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Barcode</name>
    <message>
        <location filename="../plugins/barcodegenerator/barcode.cpp" line="22"/>
        <source>&amp;Barcode Generator...</source>
        <translation type="obsolete">Ri&amp;bakoodi generaator...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="39"/>
        <source>Scribus frontend for Pure Postscript Barcode Writer</source>
        <translation type="obsolete">Scribuse kasutajaliides puhtas PostScriptis loodud ribakoodi generaatorile</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="22"/>
        <source>&amp;Barcode...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="39"/>
        <source>Scribus frontend for Pure PostScript Barcode Writer</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BarcodeGenerator</name>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="41"/>
        <source>12 or 13 digits</source>
        <translation>12 või 13 arvu</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="43"/>
        <source>8 digits</source>
        <translation>8 arvu</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="45"/>
        <source>11 or 12 digits</source>
        <translation>11 või 12 arvu</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="47"/>
        <source>7 or 8 digits</source>
        <translation>7 või 8 arvu</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="49"/>
        <source>5 digits</source>
        <translation>5 arvu</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="51"/>
        <source>2 digits</source>
        <translation>2 arvu</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>9 or 10 digits separated appropriately with dashes</source>
        <translation type="obsolete">9 või 10 arvu, mugavuse mõttes eraldatud kriipsudega</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="58"/>
        <source>Variable number of characters, digits and any of the symbols -. *$/+%.</source>
        <translation>Varieeruv arv tähti, arve ja sümboleid -. *$/+%</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="67"/>
        <source>Variable number of ASCII characters and special function symbols, starting with the appropriate start character for the initial character set. UCC/EAN-128s must have a mandatory FNC 1 symbol immediately following the start character.</source>
        <translation>Varieeruv arv ASCII sümboleid ja erifunktsioonide sümboleid. Algab esialgsele märgistikule vastava sobiva algustähega. UCC/EAN-128 nõuab, et algustähele järgneks tingimata FNC 1 sümbol.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="70"/>
        <source>Variable number of digits and any of the symbols -$:/.+ABCD.</source>
        <translation>Varieeruv arv arve ja sümboleid -$:/.+ABCD</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="93"/>
        <source>Variable number of digits</source>
        <translation>Varieeruv arv arve</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="78"/>
        <source>Variable number of digits. An ITF-14 is 14 characters and does not have a check digit</source>
        <translation>Varieeruv arv arve. ITF-14 koosneb 14 arvust ega sisalda kontrollarvu</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="89"/>
        <source>Variable number of digits and capital letters</source>
        <translation>Varieeruv arv arve ja suurtähti</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="98"/>
        <source>Variable number of hexadecimal characters</source>
        <translation>Varieeruv arv kuueteistkümnendsüsteemi märke</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="315"/>
        <source>Error opening file: %1</source>
        <translation>Viga faili avamisel: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="349"/>
        <source>Barcode incomplete</source>
        <translation>Ribakood pole täielik</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>For ISBN-10 the data should contain 9 or 10 <byte value="x9"/><byte value="x9"/><byte value="x9"/><byte value="x9"/><byte value="x9"/><byte value="x9"/><byte value="x9"/><byte value="x9"/>digits separated appropriately by dash characters.
For ISBN-13 the data should contain 12 or 13 <byte value="x9"/><byte value="x9"/><byte value="x9"/><byte value="x9"/><byte value="x9"/><byte value="x9"/><byte value="x9"/><byte value="x9"/>digits separated appropriately by dash characters.
If the last digit is not given then the ISBN <byte value="x9"/><byte value="x9"/><byte value="x9"/><byte value="x9"/><byte value="x9"/><byte value="x9"/><byte value="x9"/><byte value="x9"/>checkdigit is calculated automatically.</source>
        <translation type="obsolete">ISBN-10 korral peavad andmed sisaldama 9 või 10 (tab)(tab)(tab)(tab)(tab)(tab)(tab)(tab)arvu, mida eraldavad kriipsud.(new line)
ISBN-13 korral peavad andmed sisaldama 12 või 13 (tab)(tab)(tab)(tab)(tab)(tab)(tab)(tab)arvu, mida eraldavad kriipsud.(new line)
Kui viimast arvu ei ole antud, arvutatakse (tab)(tab)(tab)(tab)(tab)(tab)(tab)(tab)ISBN kontrollarv automaatselt.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="54"/>
        <source>12 or 13 digits with dashes. The legacy ISBN-10 format accepts 9 or 10 digits with dashes, but this standard was depreciated for public use after 1st January 2007. (Note: To convert an old ISBN-10 to a new ISBN-13, prefix 978- to the first 9 digits, e.g. 1-56592-479-7 -&gt; 978-1-56592-479. The final check-digit will be calculated automatically.)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="105"/>
        <source>Select Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.cpp" line="145"/>
        <source>Select Barcode Type</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BarcodeGeneratorBase</name>
    <message>
        <location filename="../plugins/barcodegenerator/barcodegenerator.ui" line="15"/>
        <source>Barcode Creator</source>
        <translation type="obsolete">Ribakoodi generaator</translation>
    </message>
    <message>
        <location filename="../plugins/barcodegenerator/barcodegenerator.ui" line="193"/>
        <source>Barcode</source>
        <translation type="obsolete">Ribakood</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="152"/>
        <source>&amp;Type:</source>
        <translation>&amp;Tüüp:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="132"/>
        <source>Co&amp;de:</source>
        <translation>Koo&amp;d:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="145"/>
        <source>Select one of the available barcode type here</source>
        <translation>Vali mõni saadaolevatest ribakoodi tüüpidest</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="125"/>
        <source>The numeric representation of the code itself. See the help message below</source>
        <translation>Kood ise arvuna. Vaata täpsemalt allolevat abiteadet.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="115"/>
        <source>Reset the barcode samples</source>
        <translation>Lähtesta ribakoodi näited</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="90"/>
        <source>&amp;Include text in barcode</source>
        <translation>Tekst&amp;i kaasamine ribakoodi</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="93"/>
        <source>Alt+I</source>
        <translation>Alt+I</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="87"/>
        <source>If checked, there will be numbers in the barcode too</source>
        <translation>Märkimise korral võib ribakoodis olla ka tähti</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="77"/>
        <source>&amp;Guard whitespace</source>
        <translation>Tühimär&amp;gi kaitse</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="80"/>
        <source>Alt+G</source>
        <translation>Alt+G</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="74"/>
        <source>Draw arrows to be sure of space next the code</source>
        <translation>Noolte joonistamine koodi järel tühiku tagamiseks</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="64"/>
        <source>I&amp;nclude checksum</source>
        <translation>Ko&amp;ntrollsumma kaasamine</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="67"/>
        <source>Alt+N</source>
        <translation>Alt+N</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="61"/>
        <source>Generate and include a checksum in barcode</source>
        <translation>Kontrollsumma genereerimine ja kaasamine ribakoodi</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="51"/>
        <source>Incl&amp;ude checksum digit</source>
        <translation>Kontrolls&amp;umma arvu kaasamine</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="54"/>
        <source>Alt+U</source>
        <translation>Alt+U</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="48"/>
        <source>Include the checksum digit in the barcode text</source>
        <translation>Kontrollsumma arvu lisamine ribakoodi teksti</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="168"/>
        <source>Colors</source>
        <translation>Värvid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="208"/>
        <source>&amp;Background</source>
        <translation>&amp;Taust</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="211"/>
        <source>Alt+B</source>
        <translation>Alt+B</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="205"/>
        <source>Background color - under the code lines</source>
        <translation>Taustavärv ribade taga</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="240"/>
        <source>&amp;Lines</source>
        <translation>&amp;Ribad</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="243"/>
        <source>Alt+L</source>
        <translation>Alt+L</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="237"/>
        <source>Color of the lines in barcode</source>
        <translation>Ribakoodi ribade värv</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="272"/>
        <source>&amp;Text</source>
        <translation>&amp;Tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="275"/>
        <source>Alt+T</source>
        <translation>Alt+T</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="269"/>
        <source>Color of the text and numbers</source>
        <translation>Teksti ja arvude värv</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="304"/>
        <source>Hints and help is shown here</source>
        <translation>Siin näeb vihjeid ja abi</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="314"/>
        <source>Preview of the result. 72dpi sample.</source>
        <translation>Tulemuse eelvaatlus. 72dpi näide.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="15"/>
        <source>Insert Barcode</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcodegenerator.ui" line="24"/>
        <source>Format</source>
        <translation type="unfinished">Vorming</translation>
    </message>
</context>
<context>
    <name>Biblio</name>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="698"/>
        <source>Choose a Scrapbook Directory</source>
        <translation>Visandimapi kataloogi valik</translation>
    </message>
    <message>
        <location filename="../scrapbookpalette.cpp" line="747"/>
        <source>Scrapbook (*.scs)</source>
        <translation type="obsolete">Visandimapp (*.scs)</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="737"/>
        <source>Choose a scrapbook file to import</source>
        <translation>Imporditava visandimapifaili valik</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="759"/>
        <source>Choose a Directory</source>
        <translation>Kataloogi valik</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="837"/>
        <source>Rename</source>
        <translation>Nimeta ümber</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="839"/>
        <source>Delete</source>
        <translation>Kustuta</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1120"/>
        <source>Name &quot;%1&quot; is not unique.
Please choose another.</source>
        <translation>Nimi &quot;%1&quot; ei ole unikaalne.
Palun vali mõni muu nimi.</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1344"/>
        <source>Object</source>
        <translation>Objekt</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1257"/>
        <source>&amp;Name:</source>
        <translation>&amp;Nimi:</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1257"/>
        <source>New Entry</source>
        <translation>Uus kirje</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1444"/>
        <source>Scrapbook</source>
        <translation>Visandimapp</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1445"/>
        <source>Create a new scrapbook page</source>
        <translation>Loo uus visandimapi lehekülg</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1446"/>
        <source>Load an existing scrapbook</source>
        <translation>Ava olemasolev visandimapp</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1447"/>
        <source>Save the selected scrapbook</source>
        <translation>Salvesta valitud visandimapp</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1448"/>
        <source>Import an scrapbook file from Scribus &lt;=1.3.2</source>
        <translation>Impordi visandimapifail Scribuse versioonist &lt;=1.3.2</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1449"/>
        <source>Close the selected scrapbook</source>
        <translation>Sulge valitud visandimapp</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="844"/>
        <source>Copy To:</source>
        <translation>Kopeerimine:</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="845"/>
        <source>Move To:</source>
        <translation>Liigutamine:</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="560"/>
        <source>Main</source>
        <translation>Peamine</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="562"/>
        <source>Copied Items</source>
        <translation>Kopeeritud elemendid</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1113"/>
        <source>New Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="739"/>
        <source>Scrapbook (*.scs *.SCS)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="833"/>
        <source>Paste to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="889"/>
        <source>Save as...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="892"/>
        <source>Close</source>
        <translation type="unfinished">Sulge</translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="895"/>
        <source>Delete Contents</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/scrapbookpalette.cpp" line="1068"/>
        <source>Do you really want to delete all entries?</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>BookMView</name>
    <message>
        <location filename="../bookmwin.cpp" line="219"/>
        <source>Move Bookmark</source>
        <translation type="obsolete">Liiguta järjehoidjat</translation>
    </message>
    <message>
        <location filename="../bookmwin.cpp" line="220"/>
        <source>Insert Bookmark</source>
        <translation type="obsolete">Lisa järjehoidja</translation>
    </message>
    <message>
        <location filename="../bookmwin.cpp" line="221"/>
        <source>Cancel</source>
        <translation type="obsolete">Loobu</translation>
    </message>
    <message>
        <location filename="../bookmwin.cpp" line="554"/>
        <source>Bookmarks</source>
        <translation type="obsolete">Järjehoidjad</translation>
    </message>
</context>
<context>
    <name>BookPalette</name>
    <message>
        <location filename="../../scribus/bookmarkpalette.cpp" line="51"/>
        <source>Bookmarks</source>
        <translation>Järjehoidjad</translation>
    </message>
</context>
<context>
    <name>ButtonIcon</name>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="29"/>
        <source>Icon Placement</source>
        <translation>Ikooni paigutus</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="38"/>
        <source>Layout:</source>
        <translation>Välimus:</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption only</source>
        <translation>Ainult pealdis</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Icon only</source>
        <translation>Ainult ikoon</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption below Icon</source>
        <translation>Pealdis ikooni all</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="41"/>
        <source>Caption above Icon</source>
        <translation>Pealdis ikooni kohal</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption right to Icon</source>
        <translation>Pealdis ikoonist paremal</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption left to Icon</source>
        <translation>Pealdis ikoonist vasakul</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="42"/>
        <source>Caption overlays Icon</source>
        <translation>Pealdis ikooni peal</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="50"/>
        <source>Scale:</source>
        <translation>Skaleerimine:</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="55"/>
        <source>Always</source>
        <translation>Alati</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="55"/>
        <source>When Icon is too small</source>
        <translation>Kui ikoon on liiga väike</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="56"/>
        <source>When Icon is too big</source>
        <translation>Kui ikoon on liiga suur</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="56"/>
        <source>Never</source>
        <translation>Mitte kunagi</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="63"/>
        <source>Scale How:</source>
        <translation>Skaleerimine viis:</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="66"/>
        <source>Proportional</source>
        <translation>Proportsionaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="67"/>
        <source>Non Proportional</source>
        <translation>Mitteproportsionaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="90"/>
        <source>Icon</source>
        <translation>Ikoon</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="117"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="121"/>
        <source>Cancel</source>
        <translation>Loobu</translation>
    </message>
    <message>
        <location filename="../../scribus/buttonicon.cpp" line="124"/>
        <source>Reset</source>
        <translation>Lähtesta</translation>
    </message>
</context>
<context>
    <name>CMSPrefs</name>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="31"/>
        <source>&amp;Activate Color Management</source>
        <translation type="obsolete">Värvih&amp;alduse lubamine</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="34"/>
        <source>System Profiles</source>
        <translation type="obsolete">Süsteemsed profiilid</translation>
    </message>
    <message>
        <location filename="../cmsprefs.cpp" line="43"/>
        <source>&amp;RGB Pictures:</source>
        <translation type="obsolete">&amp;RGB pildid:</translation>
    </message>
    <message>
        <location filename="../cmsprefs.cpp" line="51"/>
        <source>&amp;CMYK Pictures:</source>
        <translation type="obsolete">&amp;CMYK pildid:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="59"/>
        <source>&amp;RGB Solid Colors:</source>
        <translation type="obsolete">&amp;RGB ühtlased värvid:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="67"/>
        <source>&amp;CMYK Solid Colors:</source>
        <translation type="obsolete">&amp;CMYK ühtlased värvid:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="75"/>
        <source>&amp;Monitor:</source>
        <translation type="obsolete">&amp;Monitor:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="83"/>
        <source>P&amp;rinter:</source>
        <translation type="obsolete">P&amp;rinter:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="89"/>
        <source>Rendering Intents</source>
        <translation type="obsolete">Renderdamisviisid</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="69"/>
        <source>Perceptual</source>
        <translation>Pertseptuaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="69"/>
        <source>Relative Colorimetric</source>
        <translation>Suhteline kolorimeetriline</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="70"/>
        <source>Saturation</source>
        <translation>Küllastus</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="70"/>
        <source>Absolute Colorimetric</source>
        <translation>Absoluutne kolorimeetriline</translation>
    </message>
    <message>
        <location filename="../cmsprefs.cpp" line="98"/>
        <source>Pictures:</source>
        <translation type="obsolete">Pildid:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="106"/>
        <source>Sol&amp;id Colors:</source>
        <translation type="obsolete">Ühtlased värv&amp;id:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="113"/>
        <source>Sim&amp;ulate Printer on the Screen</source>
        <translation type="obsolete">Printeri sim&amp;uleerimine ekraanil</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="121"/>
        <source>Convert all colors to printer space</source>
        <translation type="obsolete">Kõigi värvide teisendamine printeriruumi</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="130"/>
        <source>Mark Colors out of &amp;Gamut</source>
        <translation type="obsolete">Värviulatusest väl&amp;jajäävate värvide märkimine</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="134"/>
        <source>Use &amp;Blackpoint Compensation</source>
        <translation type="obsolete">Must&amp;punkti kompenseerimine</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="139"/>
        <source>Default color profile for imported CMYK images</source>
        <translation type="obsolete">Imporditud CMYK piltide vaikimisi värviprofiil</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="140"/>
        <source>Default color profile for imported RGB images</source>
        <translation type="obsolete">Imporditud RGB piltide vaikimisi värviprofiil</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="141"/>
        <source>Default color profile for solid RGB colors on the page</source>
        <translation type="obsolete">Ühtlaste RGB värvide vaikimisi värviprofiil leheküljel</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="142"/>
        <source>Default color profile for solid CMYK colors on the page</source>
        <translation type="obsolete">Ühtlaste CMYK värvide vaikimisi värviprofiil leheküljel</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="143"/>
        <source>Color profile that you have generated or received from the manufacturer.
This profile should be specific to your monitor and not a generic profile (i.e. sRGB).</source>
        <translation type="obsolete">Värviprofiil, mille oled genereerinud või saanud tootjalt.
See profiil peab vastama monitorile ega tohi olla üldine profiil (s.t. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="144"/>
        <source>Color profile for your printer model from the manufacturer.
This profile should be specific to your printer and not a generic profile (i.e. sRGB).</source>
        <translation type="obsolete">Printeri tootjapoolne värviprofiil.
See profiil peab vastama printerile ega tohi olla üldine profiil (s.t. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="145"/>
        <source>Default rendering intent for solid colors. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="obsolete">Ühtlaste värvide vaikimisi renderdamisviis. Kui sa ei tea, kuidas seda muuta,
tuleks valida suhteline kolorimeetriline või pertseptuaalne.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="146"/>
        <source>Default rendering intent for images. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="obsolete">Piltide vaikimisi renderdamisviis. Kui sa ei tea, kuidas seda muuta,
tuleks valida suhteline kolorimeetriline või pertseptuaalne.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="147"/>
        <source>Enable &apos;soft proofing&apos; of how your document colors will print,
based on the chosen printer profile.</source>
        <translation type="obsolete">Niinimetatud väljundvaate lubamine, mis näitab printeri profiili alusel,
millised näevad dokumendi värvid välja trükkimisel.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="148"/>
        <source>Simulate a full color managed environment :
all colors, rgb or cmyk, are converted to printer color space.</source>
        <translation type="obsolete">Täieliku värvihaldusega keskkonna simuleerimine:
kõik värvid, nii RGB kui CMYK, teisendatakse printeri värviruumi.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="149"/>
        <source>Method of showing colors on the screen which may not print properly.
This requires very accurate profiles and serves only as a warning.</source>
        <translation type="obsolete">Ekraanil näidatakse värve, mida ei pruugi olla võimalik korralikult trükkida.
See nõuab väga täpseid profiile ja on mõeldud lihtsalt hoiatuseks.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="150"/>
        <source>Black Point Compensation is a method of improving contrast in photos.
It is recommended that you enable this if you have photos in your document.</source>
        <translation type="obsolete">Mustpunkti kompenseerimisega saab parandada fotode kontrasti.
Kui dokumendis leidub fotosid, on soovitatav see valik sisse lülitada.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefs.cpp" line="98"/>
        <source>Images:</source>
        <translation type="obsolete">Pildid:</translation>
    </message>
</context>
<context>
    <name>CMSPrefsBase</name>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="19"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="40"/>
        <source>&amp;Activate Color Management</source>
        <translation type="unfinished">Värvih&amp;alduse lubamine</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="50"/>
        <source>System Profiles</source>
        <translation type="unfinished">Süsteemsed profiilid</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="74"/>
        <source>&amp;RGB Images:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="90"/>
        <source>Default color profile for imported RGB images</source>
        <translation type="unfinished">Imporditud RGB piltide vaikimisi värviprofiil</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="97"/>
        <source>&amp;CMYK Images:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="113"/>
        <source>Default color profile for imported CMYK images</source>
        <translation type="unfinished">Imporditud CMYK piltide vaikimisi värviprofiil</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="120"/>
        <source>&amp;RGB Solid Colors:</source>
        <translation type="unfinished">&amp;RGB ühtlased värvid:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="136"/>
        <source>Default color profile for solid RGB colors on the page</source>
        <translation type="unfinished">Ühtlaste RGB värvide vaikimisi värviprofiil leheküljel</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="143"/>
        <source>&amp;CMYK Solid Colors:</source>
        <translation type="unfinished">&amp;CMYK ühtlased värvid:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="159"/>
        <source>Default color profile for solid CMYK colors on the page</source>
        <translation type="unfinished">Ühtlaste CMYK värvide vaikimisi värviprofiil leheküljel</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="166"/>
        <source>&amp;Monitor:</source>
        <translation type="unfinished">&amp;Monitor:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="182"/>
        <source>Color profile that you have generated or received from the manufacturer.
This profile should be specific to your monitor and not a generic profile (i.e. sRGB).</source>
        <translation type="unfinished">Värviprofiil, mille oled genereerinud või saanud tootjalt.
See profiil peab vastama monitorile ega tohi olla üldine profiil (s.t. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="190"/>
        <source>P&amp;rinter:</source>
        <translation type="unfinished">P&amp;rinter:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="206"/>
        <source>Color profile for your printer model from the manufacturer.
This profile should be specific to your printer and not a generic profile (i.e. sRGB).</source>
        <translation type="unfinished">Printeri tootjapoolne värviprofiil.
See profiil peab vastama printerile ega tohi olla üldine profiil (s.t. sRGB).</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="220"/>
        <source>Rendering Intents</source>
        <translation type="unfinished">Renderdamisviisid</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="244"/>
        <source>Images:</source>
        <translation type="unfinished">Pildid:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="260"/>
        <source>Default rendering intent for images. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="unfinished">Piltide vaikimisi renderdamisviis. Kui sa ei tea, kuidas seda muuta,
tuleks valida suhteline kolorimeetriline või pertseptuaalne.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="268"/>
        <source>Sol&amp;id Colors:</source>
        <translation type="unfinished">Ühtlased värv&amp;id:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="284"/>
        <source>Default rendering intent for solid colors. Unless you know why to change it,
Relative Colorimetric or Perceptual should be chosen.</source>
        <translation type="unfinished">Ühtlaste värvide vaikimisi renderdamisviis. Kui sa ei tea, kuidas seda muuta,
tuleks valida suhteline kolorimeetriline või pertseptuaalne.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="298"/>
        <source>Enable &apos;soft proofing&apos; of how your document colors will print,
based on the chosen printer profile.</source>
        <translation type="unfinished">Niinimetatud väljundvaate lubamine, mis näitab printeri profiili alusel,
millised näevad dokumendi värvid välja trükkimisel.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="302"/>
        <source>Sim&amp;ulate Printer on the Screen</source>
        <translation type="unfinished">Printeri sim&amp;uleerimine ekraanil</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="329"/>
        <source>Simulate a full color managed environment :
all colors, rgb or cmyk, are converted to printer color space.</source>
        <translation type="unfinished">Täieliku värvihaldusega keskkonna simuleerimine:
kõik värvid, nii RGB kui CMYK, teisendatakse printeri värviruumi.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="333"/>
        <source>Convert all colors to printer space</source>
        <translation type="unfinished">Kõigi värvide teisendamine printeriruumi</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="340"/>
        <source>Method of showing colors on the screen which may not print properly.
This requires very accurate profiles and serves only as a warning.</source>
        <translation type="unfinished">Ekraanil näidatakse värve, mida ei pruugi olla võimalik korralikult trükkida.
See nõuab väga täpseid profiile ja on mõeldud lihtsalt hoiatuseks.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="344"/>
        <source>Mark Colors out of &amp;Gamut</source>
        <translation type="unfinished">Värviulatusest väl&amp;jajäävate värvide märkimine</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="357"/>
        <source>Black Point Compensation is a method of improving contrast in photos.
It is recommended that you enable this if you have photos in your document.</source>
        <translation type="unfinished">Mustpunkti kompenseerimisega saab parandada fotode kontrasti.
Kui dokumendis leidub fotosid, on soovitatav see valik sisse lülitada.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmsprefsbase.ui" line="361"/>
        <source>Use &amp;Blackpoint Compensation</source>
        <translation type="unfinished">Must&amp;punkti kompenseerimine</translation>
    </message>
</context>
<context>
    <name>CMYKChoose</name>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="92"/>
        <source>Edit Color</source>
        <translation>Värvi muutmine</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="101"/>
        <source>&amp;Name:</source>
        <translation>&amp;Nimi:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="111"/>
        <source>Color &amp;Model</source>
        <translation>Värvi&amp;mudel</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="906"/>
        <source>CMYK</source>
        <translation>CMYK</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="911"/>
        <source>RGB</source>
        <translation>RGB</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="764"/>
        <source>Web Safe RGB</source>
        <translation>Web Safe RGB</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="125"/>
        <source>Is Spot Color</source>
        <translation>Spot-värv</translation>
    </message>
    <message>
        <location filename="../cmykfw.cpp" line="128"/>
        <source>Is Registration Color</source>
        <translation type="obsolete">Kokkutrükivärv</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="141"/>
        <source>New</source>
        <translation>Uus</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="158"/>
        <source>Old</source>
        <translation>Vana</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="195"/>
        <source>HSV-Colormap</source>
        <translation type="obsolete">HSV-värvikaart</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="705"/>
        <source>C:</source>
        <translation>C:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="704"/>
        <source> %</source>
        <translation>%</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="706"/>
        <source>M:</source>
        <translation>M:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="707"/>
        <source>Y:</source>
        <translation>Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="347"/>
        <source>K:</source>
        <translation>K:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="444"/>
        <source>Dynamic Color Bars</source>
        <translation>Dünaamilised värviribad</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="442"/>
        <source>Static Color Bars</source>
        <translation>Staatilised värviribad</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="749"/>
        <source>R:</source>
        <translation>R:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="750"/>
        <source>G:</source>
        <translation>G:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="751"/>
        <source>B:</source>
        <translation>B:</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="1002"/>
        <source>You cannot create a color named &quot;%1&quot;.
It is a reserved name for transparent color</source>
        <translation>Värvi nimega &quot;%1&quot; ei saa luua.
See nimi on reserveeritud läbipaistvale värvile.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name of the color is not unique</source>
        <translation type="obsolete">Värvi nimi ei ole unikaalne</translation>
    </message>
    <message>
        <location filename="../cmykfw.cpp" line="385"/>
        <source>Choosing this will enable printing this on all plates. Registration colors are used for printer marks such as crop marks, registration marks and the like. These are not typically used in the layout itself.</source>
        <translation type="obsolete">Selle valimine võimaldab trükkimise kõigil plaatidel. Kokkutrükivärve kasutatakse enamasti selliste printeritähiste jaoks, nagu kärpimisääred, registreerimismärgid ja nii edasi. Tavaliselt ei kasutata neid küljenduses endas.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>If color management is enabled, a triangle warning indicator is a warning the the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="obsolete">Kui värvihaldus on lubatud, hoiatab kolmnurkne märk värvi ees, et see võib jääda parajasti valitud printeriprofiili värviulatusest välja. See tähendab, et trükkimisel ei pruugi värv olla täpselt selline, nagu seda näeb ekraanil. Lähemalt räägib värviulatuse hoiatustest käsiraamat värvihalduse osas.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="1011"/>
        <source>The name of the color already exists,
please choose another one.</source>
        <translation>Selle nimega värv on juba olemas, palun vali mõni muu nimi.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="390"/>
        <source>Choosing this will make this color a spot color, thus creating another spot when creating plates or separations. This is used most often when a logo or other color needs exact representation or cannot be replicated with CMYK inks. Metallic and fluorescent inks are good examples which cannot be easily replicated with CMYK inks.</source>
        <translation>Selle valimisel muudetakse värv spot-värviks, luues plaatide või separeerimise jaoks täiendava värvi. Enamasti on seda mõtet kasutada siis, kui logo või mõned muud värvid peavad olema äärmiselt täpsed või neid ei saa tekitada CMYK-i abil. Heaks näiteks on metallik- ja fluorestsensvärv, mida CMYK-iga on raske saavutada.</translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="785"/>
        <source>If color management is enabled, a triangle warning indicator is a warning that the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="995"/>
        <source>You cannot create a color without a name
Please give it a name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cmykfw.cpp" line="196"/>
        <source>HSV Color Map</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CStyleP</name>
    <message>
        <location filename="../smcstylew.ui" line="13"/>
        <source>Form1</source>
        <translation type="obsolete">Vorm1</translation>
    </message>
    <message>
        <location filename="../smcstylew.ui" line="109"/>
        <source>Colors</source>
        <translation type="obsolete">Värvid</translation>
    </message>
</context>
<context>
    <name>CStylePBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Form1</source>
        <translation type="obsolete">Vorm1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Parent</source>
        <translation type="obsolete">Eellane</translation>
    </message>
</context>
<context>
    <name>CWDialog</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal Vision</source>
        <translation type="obsolete">Tavaline nägemine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Protanopia (Red)</source>
        <translation type="obsolete">Protanoopia (punane)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Deuteranopia (Green)</source>
        <translation type="obsolete">Deuteranoopia (roheline)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tritanopia (Blue)</source>
        <translation type="obsolete">Tritanoopia (sinine)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Full Color Blindness</source>
        <translation type="obsolete">Täielik värvipimedus</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="319"/>
        <source>Merging colors</source>
        <translation>Värvide ühendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="325"/>
        <source>Error: </source>
        <translation>Viga: </translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="325"/>
        <source>Color %1 exists already!</source>
        <translation>Värv %1 on juba olemas!</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="330"/>
        <source>Color %1 appended.</source>
        <translation>Värv %1 lisatud.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="334"/>
        <source>Now opening the color manager.</source>
        <translation>Avatakse värvihaldur.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="337"/>
        <source>Color Merging</source>
        <translation>Värvide ühendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.cpp" line="488"/>
        <source>Unable to find the requested color. You have probably selected black, gray or white. There is no way to process this color.</source>
        <translation>Soovitud värvi ei leitud. Arvatavasti valisid musta, halli või valge. Seda värvi pole võimalik töödelda.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="15"/>
        <source>Color Wheel</source>
        <translation type="unfinished">Värviratas</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="47"/>
        <source>Click the wheel to get the base color. Its color model depends on the chosen tab.</source>
        <translation type="unfinished">Klõpsa rattal baasvärvi valimiseks. Selle värvimudel sõltub valitud meetodist.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="54"/>
        <source>Result Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="311"/>
        <source>CMYK</source>
        <translation type="unfinished">CMYK</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="532"/>
        <source>RGB</source>
        <translation type="unfinished">RGB</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="718"/>
        <source>HSV</source>
        <translation type="unfinished">HSV</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="108"/>
        <source>Colors of your chosen color scheme.</source>
        <translation type="unfinished">Valitud värviskeemi värvid.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="118"/>
        <source>Color Scheme Method</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="144"/>
        <source>Angle:</source>
        <translation type="unfinished">Nurk:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="154"/>
        <source>Difference between the selected value and the counted ones. Refer to documentation for more information.</source>
        <translation type="unfinished">Erinevus valitud ja arvutatud väärtuse vahel. Lähemalt räägib sellest dokumentatsioon.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="169"/>
        <source>Select one of the methods to create a color scheme. Refer to documentation for more information.</source>
        <translation type="unfinished">Vali värviskeemi loomiseks mõni meetod. Lähemalt räägib neist dokumentatsioon.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="203"/>
        <source>Merge created colors into the document colors</source>
        <translation type="unfinished">Loodud värvide ühendamine dokumendi värvidega</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="206"/>
        <source>&amp;Merge</source>
        <translation type="unfinished">Ü&amp;henda</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="209"/>
        <source>Alt+M</source>
        <translation type="unfinished">Alt+M</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="216"/>
        <source>Replace created colors in the document colors</source>
        <translation type="unfinished">Dokumendi värvide asendamine loodud värvidega</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="219"/>
        <source>&amp;Replace</source>
        <translation type="unfinished">&amp;Asenda</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="222"/>
        <source>Alt+R</source>
        <translation type="unfinished">Alt+R</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="229"/>
        <source>Leave colors untouched</source>
        <translation type="unfinished">Värvid jäetakse muutmata</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="232"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Loobu</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="235"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="244"/>
        <source>Preview:</source>
        <translation type="unfinished">Eelvaatlus:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="268"/>
        <source>Sample color scheme.</source>
        <translation type="unfinished">Näidisvärviskeem.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="287"/>
        <source>Simulate common vision defects here. Select type of the defect.</source>
        <translation type="unfinished">Levinumate nägemishäirete simuleerimine. Vali vajalik puudetüüp.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="294"/>
        <source>Vision Defect Type:</source>
        <translation type="unfinished">Nägemishäire tüüp:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="331"/>
        <source>C:</source>
        <translation type="unfinished">C:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="431"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="361"/>
        <source>M:</source>
        <translation type="unfinished">M:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="391"/>
        <source>Y:</source>
        <translation type="unfinished">Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="421"/>
        <source>K:</source>
        <translation type="unfinished">K:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="827"/>
        <source>RGB:</source>
        <translation type="unfinished">RGB:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="674"/>
        <source>HSV:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="560"/>
        <source>R:</source>
        <translation type="unfinished">R:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="587"/>
        <source>G:</source>
        <translation type="unfinished">G:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="614"/>
        <source>B:</source>
        <translation type="unfinished">B:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="863"/>
        <source>CMYK:</source>
        <translation type="unfinished">CMYK:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="746"/>
        <source>H:</source>
        <translation type="unfinished">H:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="773"/>
        <source>S:</source>
        <translation type="unfinished">S:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="800"/>
        <source>V:</source>
        <translation type="unfinished">V:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/cwdialog.ui" line="907"/>
        <source>Document</source>
        <translation type="unfinished">Dokument</translation>
    </message>
</context>
<context>
    <name>CWDialogBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Wheel</source>
        <translation type="obsolete">Värviratas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Click the wheel to get the base color. Its color model depends on the chosen tab.</source>
        <translation type="obsolete">Klõpsa rattal baasvärvi valimiseks. Selle värvimudel sõltub valitud meetodist.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C:</source>
        <translation type="obsolete">C:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>M:</source>
        <translation type="obsolete">M:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y:</source>
        <translation type="obsolete">Y:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>K:</source>
        <translation type="obsolete">K:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>RGB:</source>
        <translation type="obsolete">RGB:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>R:</source>
        <translation type="obsolete">R:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>G:</source>
        <translation type="obsolete">G:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>B:</source>
        <translation type="obsolete">B:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>CMYK:</source>
        <translation type="obsolete">CMYK:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document</source>
        <translation type="obsolete">Dokument</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Scheme Method:</source>
        <translation type="obsolete">Värviskeemi meetod:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select one of the methods to create a color scheme. Refer to documentation for more information.</source>
        <translation type="obsolete">Vali värviskeemi loomiseks mõni meetod. Lähemalt räägib neist dokumentatsioon.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Angle:</source>
        <translation type="obsolete">Nurk:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Difference between the selected value and the counted ones. Refer to documentation for more information.</source>
        <translation type="obsolete">Erinevus valitud ja arvutatud väärtuse vahel. Lähemalt räägib sellest dokumentatsioon.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preview:</source>
        <translation type="obsolete">Eelvaatlus:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vision Defect Type:</source>
        <translation type="obsolete">Nägemishäire tüüp:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample color scheme.</source>
        <translation type="obsolete">Näidisvärviskeem.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Colors of your chosen color scheme.</source>
        <translation type="obsolete">Valitud värviskeemi värvid.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Merge</source>
        <translation type="obsolete">Ü&amp;henda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+M</source>
        <translation type="obsolete">Alt+M</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Merge created colors into the document colors</source>
        <translation type="obsolete">Loodud värvide ühendamine dokumendi värvidega</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Replace</source>
        <translation type="obsolete">&amp;Asenda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+R</source>
        <translation type="obsolete">Alt+R</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Replace created colors in the document colors</source>
        <translation type="obsolete">Dokumendi värvide asendamine loodud värvidega</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Loobu</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Leave colors untouched</source>
        <translation type="obsolete">Värvid jäetakse muutmata</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Simulate common vision defects here. Select type of the defect.</source>
        <translation type="obsolete">Levinumate nägemishäirete simuleerimine. Vali vajalik puudetüüp.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>HSV</source>
        <translation type="obsolete">HSV</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>H:</source>
        <translation type="obsolete">H:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>S:</source>
        <translation type="obsolete">S:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>V:</source>
        <translation type="obsolete">V:</translation>
    </message>
</context>
<context>
    <name>Canvas</name>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2252"/>
        <source>X: %1
Y: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2243"/>
        <source>X: %1</source>
        <translation type="unfinished">X: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2245"/>
        <source>Y: %1</source>
        <translation type="unfinished">Y: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2260"/>
        <source>Length: %1
Angle: %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvas.cpp" line="2262"/>
        <source>Width: %1
Height: %2</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CanvasMode_Normal</name>
    <message>
        <location filename="../../scribus/canvasmode_normal.cpp" line="1822"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Kõik toetatud vormingud</translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_normal.cpp" line="1852"/>
        <source>Open</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ChTable</name>
    <message>
        <location filename="" line="136966688"/>
        <source>You can see a thumbnail if you press and hold down the right mouse button. The Insert key inserts a Glyph into the Selection below and the Delete key removes the last inserted one</source>
        <translation type="obsolete">Hiire paremat klahvi all hoides näeb pisipilti. Klahviga Insert saab glüüfi allolevasse valikukasti lisada, klahviga Delete viimati lisatud glüüfi eemaldada.</translation>
    </message>
</context>
<context>
    <name>CharSelect</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Select Character:</source>
        <translation type="obsolete">Märgi valimine:</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="100"/>
        <source>Font:</source>
        <translation type="obsolete">Font:</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="123"/>
        <source>Character Class:</source>
        <translation type="obsolete">Märgiklass:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Insert Code:</source>
        <translation type="obsolete">L&amp;isatava märgi kood:</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="203"/>
        <source>&amp;Insert</source>
        <translation type="obsolete">L&amp;isa</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="213"/>
        <source>C&amp;lear</source>
        <translation type="obsolete">&amp;Puhasta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Close</source>
        <translation type="obsolete">S&amp;ulge</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="200"/>
        <source>Insert the characters at the cursor in the text</source>
        <translation type="obsolete">Lisab märgid teksti kursori asukohta</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="210"/>
        <source>Delete the current selection(s).</source>
        <translation type="obsolete">Kustutab aktiivse valiku.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Close this dialog and return to text editing</source>
        <translation type="obsolete">Sulgeb dialoogi ja naaseb teksti redigeerimise juurde</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Type in a four digit unicode value directly here</source>
        <translation type="obsolete">Siia saab otse kirjutada Unicode&apos;i neljakohalise arvväärtuse</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="250"/>
        <source>Full Character Set</source>
        <translation type="obsolete">Täielik märgistik</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="255"/>
        <source>Basic Latin</source>
        <translation type="obsolete">Ladina alusosa</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="261"/>
        <source>Latin-1 Supplement</source>
        <translation type="obsolete">Latin-1 täiendosa</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="267"/>
        <source>Latin Extended-A</source>
        <translation type="obsolete">Ladina laiendatud A</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="273"/>
        <source>Latin Extended-B</source>
        <translation type="obsolete">Ladina laiendatud B</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="279"/>
        <source>General Punctuation</source>
        <translation type="obsolete">Üldised kirjavahemärgid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="285"/>
        <source>Super- and Subscripts</source>
        <translation type="obsolete">Üla- ja alaindeksid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="291"/>
        <source>Currency Symbols</source>
        <translation type="obsolete">Rahasümbolid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="297"/>
        <source>Letterlike Symbols</source>
        <translation type="obsolete">Tähelaadsed sümbolid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="303"/>
        <source>Number Forms</source>
        <translation type="obsolete">Arvuvormid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="309"/>
        <source>Arrows</source>
        <translation type="obsolete">Nooled</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="315"/>
        <source>Mathematical Operators</source>
        <translation type="obsolete">Matemaatilised märgid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="321"/>
        <source>Box Drawing</source>
        <translation type="obsolete">Joonekombinatsioonid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="327"/>
        <source>Block Elements</source>
        <translation type="obsolete">Plokid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="333"/>
        <source>Geometric Shapes</source>
        <translation type="obsolete">Geomeetrilised kujundid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="339"/>
        <source>Miscellaneous Symbols</source>
        <translation type="obsolete">Mitmesugused sümbolid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="345"/>
        <source>Dingbats</source>
        <translation type="obsolete">Piltmärgid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="351"/>
        <source>Small Form Variants</source>
        <translation type="obsolete">Väikesed märgid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="357"/>
        <source>Ligatures</source>
        <translation type="obsolete">Ligatuurid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="363"/>
        <source>Specials</source>
        <translation type="obsolete">Erisümbolid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="369"/>
        <source>Greek</source>
        <translation type="obsolete">Kreeka</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="375"/>
        <source>Greek Extended</source>
        <translation type="obsolete">Kreeka laiendatud</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="381"/>
        <source>Cyrillic</source>
        <translation type="obsolete">Kirillitsa</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="387"/>
        <source>Cyrillic Supplement</source>
        <translation type="obsolete">Kirillitsa täiendosa</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="393"/>
        <source>Arabic</source>
        <translation type="obsolete">Araabia</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="399"/>
        <source>Arabic Extended A</source>
        <translation type="obsolete">Araabia laiendatud A</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="405"/>
        <source>Arabic Extended B</source>
        <translation type="obsolete">Araabia laiendatud B</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="411"/>
        <source>Hebrew</source>
        <translation type="obsolete">Heebrea</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="164"/>
        <source>You can see a thumbnail if you press and hold down the right mouse button. The Insert key inserts a Glyph into the Selection below and the Delete key removes the last inserted one</source>
        <translation type="obsolete">Hiire paremat klahvi all hoides näeb pisipilti. Klahviga Insert saab glüüfi allolevasse valikukasti lisada, klahviga Delete viimati lisatud glüüfi eemaldada</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="31"/>
        <source>Scribus Char Palette (*.ucp);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="226"/>
        <source>Choose a filename to open</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="297"/>
        <source>Error</source>
        <translation type="unfinished">Viga</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="256"/>
        <source>Error reading file %1 - file is corrupted propably.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="298"/>
        <source>Cannot write file %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="13"/>
        <source>Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../charselect.ui" line="56"/>
        <source>&amp;Search</source>
        <translation type="obsolete">Ot&amp;si</translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="306"/>
        <source>Empty the Palette?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="307"/>
        <source>You will remove all characters from this palette. Are you sure?</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.ui" line="24"/>
        <source>Hide/Show Enhanced Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselect.cpp" line="272"/>
        <source>Save Quick Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CharSelectEnhanced</name>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="205"/>
        <source>Full Character Set</source>
        <translation type="unfinished">Täielik märgistik</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="210"/>
        <source>Basic Latin</source>
        <translation type="unfinished">Ladina alusosa</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="216"/>
        <source>Latin-1 Supplement</source>
        <translation type="unfinished">Latin-1 täiendosa</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="222"/>
        <source>Latin Extended-A</source>
        <translation type="unfinished">Ladina laiendatud A</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="228"/>
        <source>Latin Extended-B</source>
        <translation type="unfinished">Ladina laiendatud B</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="234"/>
        <source>General Punctuation</source>
        <translation type="unfinished">Üldised kirjavahemärgid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="240"/>
        <source>Super- and Subscripts</source>
        <translation type="unfinished">Üla- ja alaindeksid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="246"/>
        <source>Currency Symbols</source>
        <translation type="unfinished">Rahasümbolid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="252"/>
        <source>Letterlike Symbols</source>
        <translation type="unfinished">Tähelaadsed sümbolid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="258"/>
        <source>Number Forms</source>
        <translation type="unfinished">Arvuvormid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="264"/>
        <source>Arrows</source>
        <translation type="unfinished">Nooled</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="270"/>
        <source>Mathematical Operators</source>
        <translation type="unfinished">Matemaatilised märgid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="276"/>
        <source>Box Drawing</source>
        <translation type="unfinished">Joonekombinatsioonid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="282"/>
        <source>Block Elements</source>
        <translation type="unfinished">Plokid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="288"/>
        <source>Geometric Shapes</source>
        <translation type="unfinished">Geomeetrilised kujundid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="294"/>
        <source>Miscellaneous Symbols</source>
        <translation type="unfinished">Mitmesugused sümbolid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="300"/>
        <source>Dingbats</source>
        <translation type="unfinished">Piltmärgid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="306"/>
        <source>Small Form Variants</source>
        <translation type="unfinished">Väikesed märgid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="312"/>
        <source>Ligatures</source>
        <translation type="unfinished">Ligatuurid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="318"/>
        <source>Specials</source>
        <translation type="unfinished">Erisümbolid</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="324"/>
        <source>Greek</source>
        <translation type="unfinished">Kreeka</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="330"/>
        <source>Greek Extended</source>
        <translation type="unfinished">Kreeka laiendatud</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="336"/>
        <source>Cyrillic</source>
        <translation type="unfinished">Kirillitsa</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="342"/>
        <source>Cyrillic Supplement</source>
        <translation type="unfinished">Kirillitsa täiendosa</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="348"/>
        <source>Arabic</source>
        <translation type="unfinished">Araabia</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="354"/>
        <source>Arabic Extended A</source>
        <translation type="unfinished">Araabia laiendatud A</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="360"/>
        <source>Arabic Extended B</source>
        <translation type="unfinished">Araabia laiendatud B</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.cpp" line="366"/>
        <source>Hebrew</source>
        <translation type="unfinished">Heebrea</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="13"/>
        <source>Enhanced Character Palette</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="19"/>
        <source>&amp;Font:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="45"/>
        <source>C&amp;haracter Class:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="77"/>
        <source>You can see a thumbnail if you press and hold down the right mouse button.
The Insert key inserts a Glyph into the Selection below and the Delete key removes the last inserted one</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="96"/>
        <source>Insert &amp;Code:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="106"/>
        <source>Type in a four digit unicode value directly here</source>
        <translation type="obsolete">Siia saab otse kirjutada Unicode&apos;i neljakohalise arvväärtuse</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="131"/>
        <source>Glyphs to Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="171"/>
        <source>Insert the characters at the cursor in the text</source>
        <translation type="unfinished">Lisab märgid teksti kursori asukohta</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="174"/>
        <source>&amp;Insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="181"/>
        <source>Delete the current selection(s).</source>
        <translation type="unfinished">Kustutab aktiivse valiku.</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="184"/>
        <source>C&amp;lear</source>
        <translation type="unfinished">&amp;Puhasta</translation>
    </message>
    <message>
        <location filename="../../scribus/charselectenhanced.ui" line="106"/>
        <source>Type in a four digit Unicode value directly here</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CharStyleComboBox</name>
    <message>
        <location filename="../../scribus/spalette.cpp" line="118"/>
        <source>No Style</source>
        <translation type="unfinished">Stiil puudub</translation>
    </message>
</context>
<context>
    <name>CharTableView</name>
    <message>
        <location filename="../../scribus/chartableview.cpp" line="22"/>
        <source>Delete</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CheckDocument</name>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="250"/>
        <source>Document</source>
        <translation>Dokument</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="254"/>
        <source>No Problems found</source>
        <translation>Probleeme ei esinenud</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="656"/>
        <source>Page </source>
        <translation>Lehekülg</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="837"/>
        <source>Free Objects</source>
        <translation>Vabad objektid</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="843"/>
        <source>Problems found</source>
        <translation>Esines probleeme</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="863"/>
        <source>Preflight Verifier</source>
        <translation>Trükieelne kontroll</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="865"/>
        <source>Items</source>
        <translation>Elemendid</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="866"/>
        <source>Problems</source>
        <translation>Probleemid</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="869"/>
        <source>Current Profile:</source>
        <translation>Aktiivne profiil:</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="870"/>
        <source>&amp;Ignore Errors</source>
        <translation>&amp;Ignoreeri vigu</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="871"/>
        <source>Check again</source>
        <translation>Kontrolli uuesti</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="877"/>
        <source>Glyphs missing</source>
        <translation>Puuduvad glüüfid</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="878"/>
        <source>Text overflow</source>
        <translation>Teksti ülejooksmine</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="879"/>
        <source>Object is not on a Page</source>
        <translation>Objekt ei paikne leheküljel</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="880"/>
        <source>Missing Image</source>
        <translation>Puuduv pilt</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="882"/>
        <source>Image resolution below %1 DPI, currently %2 x %3 DPI</source>
        <translation>Pildi lahutus on alla %1 DPI, praegu %2 x %3 DPI-d</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="883"/>
        <source>Image resolution above %1 DPI, currently %2 x %3 DPI</source>
        <translation>Pildi lahutus on üle %1 DPI, praegu %2 x %3 DPI-d</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="884"/>
        <source>Object has transparency</source>
        <translation>Objekt on läbipaistev</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="885"/>
        <source>Object is a PDF Annotation or Field</source>
        <translation>Objekt on PDF-i annotatsioon või väli</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="886"/>
        <source>Object is a placed PDF</source>
        <translation>Objekt on põimitud PDF-fail</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="887"/>
        <source>Image is GIF</source>
        <translation>Pilt on GIF</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="255"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="276"/>
        <source>Transparency used</source>
        <translation>Läbipaistvuse kasutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="279"/>
        <source>Blendmode used</source>
        <translation>Ühtesulamise kasutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="286"/>
        <source>Layer &quot;%1&quot;</source>
        <translation>Kiht &quot;%1&quot;</translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="888"/>
        <source>Annotation uses a non TrueType font</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="873"/>
        <source>Preflight profile to base the report generation on. Options can be set in Document Setup or Preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="874"/>
        <source>Ignore found errors and continue to export or print. Be sure to understand the errors you are ignoring before continuing.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="875"/>
        <source>Rerun the document scan to check corrections you may have made</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/checkDocument.cpp" line="881"/>
        <source>Empty Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ChooseStyles</name>
    <message>
        <location filename="../editformats.cpp" line="95"/>
        <source>Choose Styles</source>
        <translation type="obsolete">Stiilide valik</translation>
    </message>
    <message>
        <location filename="../editformats.cpp" line="100"/>
        <source>Available Styles</source>
        <translation type="obsolete">Saadaolevad stiilid</translation>
    </message>
</context>
<context>
    <name>CollectForOutput</name>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="52"/>
        <source>Choose a Directory</source>
        <translation>Kataloogi valik</translation>
    </message>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="68"/>
        <source>Collecting...</source>
        <translation>Kogumine...</translation>
    </message>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="87"/>
        <source>Cannot collect the file: 
%1</source>
        <translation>Faili ei õnnestunud koguda:
%1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Warning</source>
        <translation type="obsolete">Hoiatus</translation>
    </message>
    <message>
        <location filename="../../scribus/collect4output.cpp" line="73"/>
        <source>Cannot collect all files for output for file:
%1</source>
        <translation>Ei õnnestunud koguda kõigi faile väljundiks failile:
%1</translation>
    </message>
</context>
<context>
    <name>ColorManager</name>
    <message>
        <location filename="../../scribus/colorm.cpp" line="54"/>
        <source>Colors</source>
        <translation>Värvid</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="80"/>
        <source>&amp;Import</source>
        <translation>&amp;Impordi</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="82"/>
        <source>&amp;New</source>
        <translation>&amp;Uus</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="84"/>
        <source>&amp;Edit</source>
        <translation>&amp;Redigeeri</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="88"/>
        <source>D&amp;uplicate</source>
        <translation>&amp;Klooni</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="91"/>
        <source>&amp;Delete</source>
        <translation>K&amp;ustuta</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="96"/>
        <source>&amp;Remove Unused</source>
        <translation>&amp;Eemalda kasutud</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="103"/>
        <source>Color Sets</source>
        <translation>Värvikomplektid</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="109"/>
        <source>Current Color Set:</source>
        <translation>Aktiivne värvikomplekt:</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="140"/>
        <source>&amp;Save Color Set</source>
        <translation>&amp;Salvesta värvikomplekt</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="159"/>
        <source>Choose a color set to load</source>
        <translation>Vali avatav värvikomplekt</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="160"/>
        <source>Save the current color set</source>
        <translation>Salvesta aktiivne värvikomplekt</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="165"/>
        <source>Remove unused colors from current document&apos;s color set</source>
        <translation>Eemalda kasutamata värvid dokumendi aktiivsest värvikomplektist</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="167"/>
        <source>Import colors to the current set from an existing document</source>
        <translation>Impordi olemasolevast dokumendist värvid aktiivsesse värvikomplekti</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="168"/>
        <source>Create a new color within the current set</source>
        <translation>Loo aktiivses värvikomplektis uus värv</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="169"/>
        <source>Edit the currently selected color</source>
        <translation>Redigeeri valitud värvi</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="170"/>
        <source>Make a copy of the currently selected color</source>
        <translation>Kopeeri valitud värv</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="171"/>
        <source>Delete the currently selected color</source>
        <translation>Kustuta valitud värv</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="172"/>
        <source>Make the current colorset the default color set</source>
        <translation>Muuda aktiivne värvikomplekt vaikimisi värvikomplektiks</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="190"/>
        <source>&amp;Name:</source>
        <translation>&amp;Nimi:</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="190"/>
        <source>Choose a Name</source>
        <translation>Nime valik</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Open</source>
        <translation type="obsolete">Avamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;All Files (*)</source>
        <translation type="obsolete">Dokumendid (*.sla *.sla.gz *.scd *.scd.gz);;Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Documents (*.sla *.scd);;All Files (*)</source>
        <translation type="obsolete">Dokumendid (*.sla *.scd);;Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="353"/>
        <source>Copy of %1</source>
        <translation>%1 koopia</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="364"/>
        <source>New Color</source>
        <translation>Uus värv</translation>
    </message>
    <message>
        <location filename="../colorm.cpp" line="172"/>
        <source>If color management is enabled, a triangle warning indicator is a warning the the color maybe outside of the color gamut of the current printer profile selected.What this means is the color may not print exactly as indicated on screen. Spot colors are indicated by a red circle. Registration colors will have a registration mark next to the color. More hints about gamut warnings are in the online help under Color Management.</source>
        <translation type="obsolete">Kui värvihaldus on lubatud, hoiatab kolmnurkne märk värvi ees, et see võib jääda parajasti valitud printeriprofiili värviulatusest välja. See tähendab, et trükkimisel ei pruugi värv olla täpselt selline, nagu seda näeb ekraanil. Lähemalt räägib värviulatuse hoiatustest käsiraamat värvihalduse osas.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;Other Files (*.eps *.ps *.ai);;All Files (*)</source>
        <translation type="obsolete">Dokumendid (*.sla *.sla.gz *.scd *.scd.gz);;Teised failid (*.eps *.ps *.ai);;Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Documents (*.sla *.scd);;Other Files (*.eps *.ps *.ai);;All Files (*)</source>
        <translation type="obsolete">Dokumendid (*.sla *.scd);;Teised failid (*.eps *.ps *.ai);;Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="321"/>
        <source>Information</source>
        <translation type="unfinished">Info</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="321"/>
        <source>Import</source>
        <translation type="obsolete">Impordi</translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="321"/>
        <source>The file %1 does not contain colors which can be imported.
If the file was a PostScript-based, try to import it with File -&amp;gt; Import. 
Not all files have DSC conformant comments where the color descriptions are located.
 This prevents importing colors from some files.
See the Edit Colors section of the documentation for more details.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="173"/>
        <source>If color management is enabled, a triangle warning indicator is a warning that the color maybe outside of the color gamut of the current printer profile selected. What this means is the color may not print exactly as indicated on screen. Spot colors are indicated by a red circle. More hints about gamut warnings are in the online help under Color Management. Registration colors will have a registration mark next to the color. Use Registration only for printers marks and crop marks.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="311"/>
        <source>All Supported Formats (%1);;Documents (%2);;Other Files (%3);;All Files (*)</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/colorm.cpp" line="312"/>
        <source>Import Colors</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ColorWheel</name>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="139"/>
        <source>Monochromatic</source>
        <translation>Monokromaatiline</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="140"/>
        <source>Analogous</source>
        <translation>Analoogvärvid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="224"/>
        <source>Complementary</source>
        <translation>Komplementaarvärvid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="142"/>
        <source>Split Complementary</source>
        <translation>Lõhestatud komplementaarvärvid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="143"/>
        <source>Triadic</source>
        <translation>Triaad</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="144"/>
        <source>Tetradic (Double Complementary)</source>
        <translation>Nelikõla (topeltkomplementaarsus)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="44"/>
        <source>Base Color</source>
        <translation>Baasvärv</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="206"/>
        <source>Monochromatic Light</source>
        <translation>Mnonokromaatiline hele</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="209"/>
        <source>Monochromatic Dark</source>
        <translation>Monokromaatiline tume</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="216"/>
        <source>1st. Analogous</source>
        <translation>1. analoogvärv</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="217"/>
        <source>2nd. Analogous</source>
        <translation>2. analoogvärv</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="231"/>
        <source>1st. Split</source>
        <translation>1. lõhestatud värv</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="232"/>
        <source>2nd. Split</source>
        <translation>2. lõhestatud värv</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="233"/>
        <source>3rd. Split</source>
        <translation>3. lõhestatud värv</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="234"/>
        <source>4th. Split</source>
        <translation>4. lõhestatud värv</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="241"/>
        <source>1st. Triadic</source>
        <translation>1. triaad</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="242"/>
        <source>2nd. Triadic</source>
        <translation>2. triaad</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="249"/>
        <source>1st. Tetradic (base opposite)</source>
        <translation>1. tetraad (baasi vastand)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="250"/>
        <source>2nd. Tetradic (angle)</source>
        <translation>2. tetraad (nurk)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheelwidget.cpp" line="251"/>
        <source>3rd. Tetradic (angle opposite)</source>
        <translation>3. tetraad (nurga vastand)</translation>
    </message>
</context>
<context>
    <name>ColorWheelDialog</name>
    <message>
        <location filename="" line="136966688"/>
        <source>E&amp;xit</source>
        <translation type="obsolete">&amp;Välju</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C&amp;olor</source>
        <translation type="obsolete">&amp;Värv</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color Wheel</source>
        <translation type="obsolete">Värviratas</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color</source>
        <translation type="obsolete">Värv</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name</source>
        <translation type="obsolete">Nimi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C</source>
        <translation type="obsolete">C</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>M</source>
        <translation type="obsolete">M</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y</source>
        <translation type="obsolete">Y</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>K</source>
        <translation type="obsolete">K</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Error: </source>
        <translation type="obsolete">Viga: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color %1 exists already!</source>
        <translation type="obsolete">Värv %1 on juba olemas!</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color %1 appended.</source>
        <translation type="obsolete">Värv %1 lisatud.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>New Color</source>
        <translation type="obsolete">Uus värv</translation>
    </message>
</context>
<context>
    <name>ColorWheelPlugin</name>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="47"/>
        <source>&amp;Color Wheel...</source>
        <translation>&amp;Värviratas...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="64"/>
        <source>Color setting helper</source>
        <translation>Värviseadistuste abiline</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="65"/>
        <source>Color selector with color theory included.</source>
        <translation>Värvivalija, mis arvestab värviteooriat.</translation>
    </message>
</context>
<context>
    <name>CommonStrings</name>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="244"/>
        <source>&amp;Apply</source>
        <translation>&amp;Rakenda</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="247"/>
        <source>&amp;Cancel</source>
        <translation>&amp;Loobu</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="251"/>
        <source>None</source>
        <comment>color name</comment>
        <translation>Puudub</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="254"/>
        <source>&amp;OK</source>
        <translation>&amp;OK</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="257"/>
        <source>&amp;Save</source>
        <translation>&amp;Salvesta</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="260"/>
        <source>Warning</source>
        <translation>Hoiatus</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="285"/>
        <source>Custom</source>
        <comment>CommonStrings, custom page size</comment>
        <translation>Kohandatud</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="291"/>
        <source>Single Page</source>
        <translation>Üks lehekülg</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="292"/>
        <source>Double Sided</source>
        <translation>Kaks lehekülge</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="293"/>
        <source>3-Fold</source>
        <translation>Kolm lehekülge</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="294"/>
        <source>4-Fold</source>
        <translation>4 lehekülge</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Left Page</source>
        <translation type="obsolete">Vasakpoolne</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Middle</source>
        <translation type="obsolete">Keskmine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Middle Left</source>
        <translation type="obsolete">Vasak keskmine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Middle Right</source>
        <translation type="obsolete">Parem keskmine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Right Page</source>
        <translation type="obsolete">Parempoolne</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="330"/>
        <source>Monday</source>
        <translation>Esmaspäev</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="331"/>
        <source>Tuesday</source>
        <translation>Teisipäev</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="332"/>
        <source>Wednesday</source>
        <translation>Kolmapäev</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="333"/>
        <source>Thursday</source>
        <translation>Neljapäev</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="334"/>
        <source>Friday</source>
        <translation>Reede</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="335"/>
        <source>Saturday</source>
        <translation>Laupäev</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="336"/>
        <source>Sunday</source>
        <translation>Pühapäev</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="337"/>
        <source>January</source>
        <translation>Jaanuar</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="338"/>
        <source>February</source>
        <translation>Veebruar</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="339"/>
        <source>March</source>
        <translation>Märts</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="340"/>
        <source>April</source>
        <translation>Aprill</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="341"/>
        <source>May</source>
        <translation>Mai</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="342"/>
        <source>June</source>
        <translation>Juuni</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="343"/>
        <source>July</source>
        <translation>Juuli</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="344"/>
        <source>August</source>
        <translation>August</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="345"/>
        <source>September</source>
        <translation>September</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="346"/>
        <source>October</source>
        <translation>Oktoober</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="347"/>
        <source>November</source>
        <translation>November</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="348"/>
        <source>December</source>
        <translation>Detsember</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="262"/>
        <source>Yes</source>
        <translation>Jah</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="263"/>
        <source>No</source>
        <translation>Ei</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="264"/>
        <source>&amp;Yes</source>
        <translation>&amp;Jah</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="265"/>
        <source>&amp;No</source>
        <translation>&amp;Ei</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal</source>
        <translation type="obsolete">Normaalne</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal Left</source>
        <translation type="obsolete">Normaalne vasakul</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal Middle</source>
        <translation type="obsolete">Normaalne keskel</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal Right</source>
        <translation type="obsolete">Normaalne paremal</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="301"/>
        <source>Left Page</source>
        <comment>Left page location</comment>
        <translation type="unfinished">Vasakpoolne</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="302"/>
        <source>Middle</source>
        <comment>Middle page location</comment>
        <translation type="unfinished">Keskmine</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="303"/>
        <source>Middle Left</source>
        <comment>Middle Left page location</comment>
        <translation type="unfinished">Vasak keskmine</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="304"/>
        <source>Middle Right</source>
        <comment>Middle Right page location</comment>
        <translation type="unfinished">Parem keskmine</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="305"/>
        <source>Right Page</source>
        <comment>Right page location</comment>
        <translation type="unfinished">Parempoolne</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="308"/>
        <source>Normal</source>
        <comment>Default single master page</comment>
        <translation type="unfinished">Normaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="310"/>
        <source>Normal Left</source>
        <comment>Default left master page</comment>
        <translation type="unfinished">Normaalne vasakul</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="312"/>
        <source>Normal Middle</source>
        <comment>Default middle master page</comment>
        <translation type="unfinished">Normaalne keskel</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="314"/>
        <source>Normal Right</source>
        <comment>Default right master page</comment>
        <translation type="unfinished">Normaalne paremal</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="356"/>
        <source>Normal Vision</source>
        <comment>Color Blindness - Normal Vision</comment>
        <translation type="unfinished">Tavaline nägemine</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="357"/>
        <source>Protanopia (Red)</source>
        <comment>Color Blindness - Red Color Blind</comment>
        <translation type="unfinished">Protanoopia (punane)</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="358"/>
        <source>Deuteranopia (Green)</source>
        <comment>Color Blindness - Greed Color Blind</comment>
        <translation type="unfinished">Deuteranoopia (roheline)</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="359"/>
        <source>Tritanopia (Blue)</source>
        <comment>Color Blindness - Blue Color Blind</comment>
        <translation type="unfinished">Tritanoopia (sinine)</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="360"/>
        <source>Full Color Blindness</source>
        <comment>Color Blindness - Full Color Blindness</comment>
        <translation type="unfinished">Täielik värvipimedus</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="362"/>
        <source>Custom: </source>
        <comment>Custom Tab Fill Option</comment>
        <translation type="unfinished">Kohandatud: </translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="250"/>
        <source>None</source>
        <translation type="unfinished">Puudub</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="316"/>
        <source>Solid Line</source>
        <translation type="unfinished">Ühtlane joon</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="317"/>
        <source>Dashed Line</source>
        <translation type="unfinished">Punktiirjoon</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="318"/>
        <source>Dotted Line</source>
        <translation type="unfinished">Punktjoon</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="319"/>
        <source>Dash Dot Line</source>
        <translation type="unfinished">Kriipspunktjoon</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="320"/>
        <source>Dash Dot Dot Line</source>
        <translation type="unfinished">Kriipspunktpunktjoon</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="364"/>
        <source>None</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished">Puudub</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="365"/>
        <source>Left Protruding</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="366"/>
        <source>Right Protruding</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="367"/>
        <source>Left Hanging Punctuation</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="368"/>
        <source>Right Hanging Punctuation</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="369"/>
        <source>Default</source>
        <comment>Optical Margin Setting</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="372"/>
        <source>Min. Word Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="373"/>
        <source>Max. Word Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="376"/>
        <source>Min. Glyph Extension</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="377"/>
        <source>Max. Glyph Extension</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="350"/>
        <source>RGB</source>
        <comment>Colorspace</comment>
        <translation type="unfinished">RGB</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="351"/>
        <source>CMYK</source>
        <comment>Colorspace</comment>
        <translation type="unfinished">CMYK</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="352"/>
        <source>Grayscale</source>
        <comment>Colorspace</comment>
        <translation type="unfinished">Halltoonid</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="353"/>
        <source>Duotone</source>
        <comment>Colorspace</comment>
        <translation type="unfinished">Duotone</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="354"/>
        <source>Unknown</source>
        <comment>Colorspace (Unknown)</comment>
        <translation type="unfinished">Teadmata</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="381"/>
        <source>PostScript</source>
        <translation type="unfinished">PostScript</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="267"/>
        <source>Text Frame</source>
        <translation type="unfinished">Tekstikast</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="268"/>
        <source>Image Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="269"/>
        <source>Line</source>
        <translation type="unfinished">Joon</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="270"/>
        <source>Polygon</source>
        <translation type="unfinished">Hulknurk</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="271"/>
        <source>Polyline</source>
        <translation type="unfinished">Kompleksjoon</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="272"/>
        <source>Text on a Path</source>
        <translation type="unfinished">Trajektoori tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="274"/>
        <source>Multiple</source>
        <comment>Multiple frame types</comment>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="275"/>
        <source>PDF Push Button</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="276"/>
        <source>PDF Text Field</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="277"/>
        <source>PDF Check Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="278"/>
        <source>PDF Combo Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="279"/>
        <source>PDF List Box</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="280"/>
        <source>PDF Text Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="281"/>
        <source>PDF Link Annotation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="388"/>
        <source>PostScript Level 1</source>
        <translation type="unfinished">PostScript tase 1</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="390"/>
        <source>PostScript Level 2</source>
        <translation type="unfinished">PostScript tase 2</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="392"/>
        <source>PostScript Level 3</source>
        <translation type="unfinished">PostScript tase 3</translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="394"/>
        <source>Windows GDI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="273"/>
        <source>Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="325"/>
        <source>Default Paragraph Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="326"/>
        <source>Default Character Style</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/commonstrings.cpp" line="327"/>
        <source>Default Line Style</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ContextMenu</name>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="210"/>
        <source>Preview Settings</source>
        <translation type="unfinished">Eelvaatluse seadistused</translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="421"/>
        <source>Paste File...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="454"/>
        <source>Delete Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/contextmenu.cpp" line="182"/>
        <source>Paste Image from Clipboard</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CopyPageToMasterPageBase</name>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpage.ui" line="16"/>
        <source>Convert Page to Master Page</source>
        <translation type="unfinished">Lehekülje salvestamine toorikuna</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpage.ui" line="24"/>
        <source>Name:</source>
        <translation type="unfinished">Nimi:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpage.ui" line="39"/>
        <source>Copy Applied Master Page Items</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CopyPageToMasterPageDialog</name>
    <message>
        <location filename="../../scribus/ui/copypagetomasterpagedialog.cpp" line="18"/>
        <source>New Master Page %1</source>
        <translation type="unfinished">Uus leheküljetoorik %1</translation>
    </message>
</context>
<context>
    <name>Cpalette</name>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="984"/>
        <source> pt</source>
        <translation> pt</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="985"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1001"/>
        <source>Shade:</source>
        <translation>Varjund:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1002"/>
        <source>Opacity:</source>
        <translation>Läbipaistmatus:</translation>
    </message>
    <message>
        <location filename="../cpalette.cpp" line="922"/>
        <source>X1:</source>
        <translation type="obsolete">X1:</translation>
    </message>
    <message>
        <location filename="../cpalette.cpp" line="923"/>
        <source>Y1:</source>
        <translation type="obsolete">Y1:</translation>
    </message>
    <message>
        <location filename="../cpalette.cpp" line="924"/>
        <source>X2:</source>
        <translation type="obsolete">X2:</translation>
    </message>
    <message>
        <location filename="../cpalette.cpp" line="925"/>
        <source>Y2:</source>
        <translation type="obsolete">Y2:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1003"/>
        <source>Move Vector</source>
        <translation>Liiguta vektorit</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1020"/>
        <source>Normal</source>
        <translation>Normaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1008"/>
        <source>Horizontal Gradient</source>
        <translation>Rõhtne üleminek</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1009"/>
        <source>Vertical Gradient</source>
        <translation>Püstine üleminek</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1010"/>
        <source>Diagonal Gradient</source>
        <translation>Diagonaalne üleminek</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1011"/>
        <source>Cross Diagonal Gradient</source>
        <translation>Ristdiagonaalne üleminek</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1012"/>
        <source>Radial Gradient</source>
        <translation>Radiaalne üleminek</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1013"/>
        <source>Free linear Gradient</source>
        <translation>Vaba lineaarne üleminek</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1014"/>
        <source>Free radial Gradient</source>
        <translation>Vaba radiaalne üleminek</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1038"/>
        <source>Edit Line Color Properties</source>
        <translation>Muuda joonevärvi omadusi</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1039"/>
        <source>Edit Fill Color Properties</source>
        <translation>Muuda täitevärvi omadusi</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1040"/>
        <source>Saturation of color</source>
        <translation>Värviküllastus</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1041"/>
        <source>Normal or gradient fill method</source>
        <translation>Normaalne või ülemineku täitmise meetod</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1042"/>
        <source>Set the transparency for the color selected</source>
        <translation>Määra valitud värvi läbipaistvus</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1043"/>
        <source>Move the start of the gradient vector with the left mouse button pressed and move the end of the gradient vector with the right mouse button pressed</source>
        <translation>Liiguta üleminekuvektori algust hiire vasakut nuppu ja üleminekuvektori lõppu hiire paremat nuppu all hoides</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1017"/>
        <source>Transparency Settings</source>
        <translation>Läbipaistvuse seadistused</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1018"/>
        <source>Blend Mode:</source>
        <translation>Ühtesulamise režiim:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1021"/>
        <source>Darken</source>
        <translation>Tumendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1022"/>
        <source>Lighten</source>
        <translation>Helendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1023"/>
        <source>Multiply</source>
        <translation>Korrutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1024"/>
        <source>Screen</source>
        <translation>Ekraan</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1025"/>
        <source>Overlay</source>
        <translation>Ülekatmine</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1026"/>
        <source>Hard Light</source>
        <translation>Külm valgus</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1027"/>
        <source>Soft Light</source>
        <translation>Soe valgus</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1028"/>
        <source>Difference</source>
        <translation>Lahutamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Exlusion</source>
        <translation type="obsolete">Väljajätmine</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1030"/>
        <source>Color Dodge</source>
        <translation>Värvi helestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1031"/>
        <source>Color Burn</source>
        <translation>Värvi tumestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1032"/>
        <source>Hue</source>
        <translation>Toon</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1033"/>
        <source>Saturation</source>
        <translation>Küllastus</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1034"/>
        <source>Color</source>
        <translation>Värv</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1035"/>
        <source>Luminosity</source>
        <translation>Valgsus</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="988"/>
        <source>Offsets</source>
        <translation>Nihe</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="989"/>
        <source>X:</source>
        <translation>X:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="991"/>
        <source>Y:</source>
        <translation>Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="993"/>
        <source>Scaling</source>
        <translation>Skaleerimine</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="998"/>
        <source>Rotation</source>
        <translation>Pööramine</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="999"/>
        <source>Angle</source>
        <translation>Nurk</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1015"/>
        <source>Pattern</source>
        <translation>Muster</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1029"/>
        <source>Exclusion</source>
        <translation>VäljajätmineVäljajätmine</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="994"/>
        <source>X-Scale:</source>
        <translation>X-skaala:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="996"/>
        <source>Y-Scale:</source>
        <translation>Y-skaala:</translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1036"/>
        <source>Display only used Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="1044"/>
        <source>Display all colors from the document color list, or only the already used colors</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CreateRange</name>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="13"/>
        <source>Create Range</source>
        <translation type="unfinished">Vahemiku loomine</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="54"/>
        <source>Number of Pages in Document:</source>
        <translation type="unfinished">Lehekülgede arv dokumendis:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="64"/>
        <source>Doc Page Range</source>
        <translation type="unfinished">Dokumendi lehekülgede vahemik</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="112"/>
        <source>Basic Range Selection</source>
        <translation type="unfinished">Vahemiku valimine</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="136"/>
        <source>Range of Pages</source>
        <translation type="unfinished">Lehekülgede vahemik</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="160"/>
        <source>De&amp;lete</source>
        <translation type="unfinished">&amp;Kustuta</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="163"/>
        <source>Alt+L</source>
        <translation type="unfinished">Alt+L</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="186"/>
        <source>Move &amp;Down</source>
        <translation type="unfinished">L&amp;iiguta alla</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="189"/>
        <source>Alt+D</source>
        <translation type="unfinished">Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="196"/>
        <source>Move &amp;Up</source>
        <translation type="unfinished">&amp;Liiguta üles</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="199"/>
        <source>Alt+U</source>
        <translation type="unfinished">Alt+U</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="218"/>
        <source>Add a Range of Pages</source>
        <translation type="unfinished">Lisa lehekülgede vahemik</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="242"/>
        <source>Consecutive Pages</source>
        <translation type="unfinished">Järjestikused lehed</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="252"/>
        <source>Even Pages</source>
        <translation type="unfinished">Paarisleheküljed</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="259"/>
        <source>From:</source>
        <translation type="unfinished">Alates:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="291"/>
        <source>To:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="334"/>
        <source>&amp;Add To Range</source>
        <translation type="unfinished">Lis&amp;a vahemikku</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="337"/>
        <source>Alt+A</source>
        <translation type="unfinished">Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="362"/>
        <source>Odd Pages</source>
        <translation type="unfinished">Paaritud leheküljed</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="372"/>
        <source>Comma Separated List</source>
        <translation type="unfinished">Komadega eraldatud loend</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="383"/>
        <source>Advanced Reordering</source>
        <translation type="unfinished">Täpsem ümberkorraldamine</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="439"/>
        <source>Page Order</source>
        <translation type="unfinished">Lehekülgede järjekord</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="449"/>
        <source>Sample Page Order:</source>
        <translation type="unfinished">Lehekülgede näidisjärjekord:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="478"/>
        <source>Page Group Size:</source>
        <translation type="unfinished">Leheküljerühma suurus:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="525"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;OK</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="528"/>
        <source>Alt+O</source>
        <translation type="unfinished">Alt+O</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="535"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Loobu</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/createrange.ui" line="538"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
</context>
<context>
    <name>CreateRangeBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Create Range</source>
        <translation type="obsolete">Vahemiku loomine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of Pages in Document:</source>
        <translation type="obsolete">Lehekülgede arv dokumendis:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Doc Page Range</source>
        <translation type="obsolete">Dokumendi lehekülgede vahemik</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Basic Range Selection</source>
        <translation type="obsolete">Vahemiku valimine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Add a Range of Pages</source>
        <translation type="obsolete">Lisa lehekülgede vahemik</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Consecutive Pages</source>
        <translation type="obsolete">Järjestikused lehed</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>From:</source>
        <translation type="obsolete">Alates:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>To:</source>
        <translation type="obsolete">Kuni:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Comma Separated List</source>
        <translation type="obsolete">Komadega eraldatud loend</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Even Pages</source>
        <translation type="obsolete">Paarisleheküljed</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Odd Pages</source>
        <translation type="obsolete">Paaritud leheküljed</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Add To Range</source>
        <translation type="obsolete">Lis&amp;a vahemikku</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Range of Pages</source>
        <translation type="obsolete">Lehekülgede vahemik</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move &amp;Up</source>
        <translation type="obsolete">&amp;Liiguta üles</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+U</source>
        <translation type="obsolete">Alt+U</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Move &amp;Down</source>
        <translation type="obsolete">L&amp;iiguta alla</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>De&amp;lete</source>
        <translation type="obsolete">&amp;Kustuta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+L</source>
        <translation type="obsolete">Alt+L</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Advanced Reordering</source>
        <translation type="obsolete">Täpsem ümberkorraldamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Group Size:</source>
        <translation type="obsolete">Leheküljerühma suurus:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample Page Order:</source>
        <translation type="obsolete">Lehekülgede näidisjärjekord:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Order</source>
        <translation type="obsolete">Lehekülgede järjekord</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;OK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+O</source>
        <translation type="obsolete">Alt+O</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Loobu</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
</context>
<context>
    <name>CsvDialog</name>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="27"/>
        <source>CSV Importer Options</source>
        <translation>CSV importija valikud</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="37"/>
        <source>Field delimiter:</source>
        <translation>Väljade eraldaja:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="89"/>
        <source>(TAB)</source>
        <translation>(TAB)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="53"/>
        <source>Value delimiter:</source>
        <translation>Väärtuste eraldaja:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="59"/>
        <source>None</source>
        <comment>delimiter</comment>
        <translation>Puudub</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="68"/>
        <source>First row is a header</source>
        <translation>Esimene rida on päis</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="76"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/csvim/csvdia.cpp" line="79"/>
        <source>Cancel</source>
        <translation>Loobu</translation>
    </message>
</context>
<context>
    <name>CupsOptions</name>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="52"/>
        <source>Printer Options</source>
        <translation>Printeri valikud</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="143"/>
        <source>Page Set</source>
        <translation>Lehekülgede valim</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="147"/>
        <source>All Pages</source>
        <translation>Kõik leheküljed</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="141"/>
        <source>Even Pages only</source>
        <translation>Ainult paarisleheküljed</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="142"/>
        <source>Odd Pages only</source>
        <translation>Ainult paaritud leheküljed</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="160"/>
        <source>Mirror</source>
        <translation>Peegeldamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No</source>
        <translation type="obsolete">Ei</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Yes</source>
        <translation type="obsolete">Jah</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="177"/>
        <source>Orientation</source>
        <translation>Orientatsioon</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="181"/>
        <source>Portrait</source>
        <translation>Püstpaigutus</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="175"/>
        <source>Landscape</source>
        <translation>Rõhtpaigutus</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="197"/>
        <source>N-Up Printing</source>
        <translation>Lehekülgi lehele</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="201"/>
        <source>Page per Sheet</source>
        <translation>lehekülg lehe kohta</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="196"/>
        <source>Pages per Sheet</source>
        <translation>lehekülge lehe kohta</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="63"/>
        <source>Option</source>
        <translation>Valik</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="64"/>
        <source>Value</source>
        <translation>Väärtus</translation>
    </message>
    <message>
        <location filename="../../scribus/cupsoptions.cpp" line="224"/>
        <source>This panel displays various CUPS options when printing. The exact parameters available will depend on your printer driver. You can confirm CUPS support by selecting Help &gt; About. Look for the listings: C-C-T These equate to C=CUPS C=littlecms T=TIFF support. Missing library support is indicated by a *</source>
        <translation>See dialoog näitab trükkimisel kasutatavaid CUPS-i valikuid. Täpsed parameetrid sõltuvad printeri draiverist. CUPS-i toetust saab kontrollida dialoogis Abi -&gt; Info. Seal tuleb otsida kirjet C-C-T, milles C=CUPS, teine C=littlecms ja T=TIFF. Puuduva toetuse korral seisab vastava teegi asemel *.</translation>
    </message>
</context>
<context>
    <name>CurveWidget</name>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="414"/>
        <source>Open</source>
        <translation>Avamine</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="449"/>
        <source>Curve Files (*.scu);;All Files (*)</source>
        <translation>Trajektoorifailid (*.scu);;Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="449"/>
        <source>Save as</source>
        <translation>Salvestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="483"/>
        <source>Cannot write the file: 
%1</source>
        <translation>Ei õnnestunud kirjutada faili:
%1</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="509"/>
        <source>Inverts the curve</source>
        <translation>Inverteerib trajektoori</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="510"/>
        <source>Resets the curve</source>
        <translation>Lähtestab trajektoori</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="511"/>
        <source>Switches between linear and cubic interpolation of the curve</source>
        <translation>Lülitab trajektoori lineaarse ja kolmanda astme intepolatsiooni vahel</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="512"/>
        <source>Loads a curve</source>
        <translation>Laadib trajektoori</translation>
    </message>
    <message>
        <location filename="../../scribus/curvewidget.cpp" line="513"/>
        <source>Saves this curve</source>
        <translation>Salvestab trajektoori</translation>
    </message>
</context>
<context>
    <name>CustomFDialog</name>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="327"/>
        <source>&amp;Compress File</source>
        <translation>&amp;Faili tihendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="306"/>
        <source>&amp;Include Fonts</source>
        <translation>Fo&amp;ntide kaasamine</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="355"/>
        <source>Encoding:</source>
        <translation>Kodeering:</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="366"/>
        <source>Moves to your Document Directory.
This can be set in the Preferences.</source>
        <translation type="obsolete">Liigub määratud dokumentide kataloogi.
Selle saab määrata seadistustes.</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="314"/>
        <source>&amp;Include ICC Profiles</source>
        <translation type="obsolete">&amp;ICC profiilide kaasamine</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="274"/>
        <source>Show Preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="308"/>
        <source>&amp;Include Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="275"/>
        <source>Show a preview and information for the selected file</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="342"/>
        <source>Compress the Scribus document on save</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="344"/>
        <source>Include fonts when collecting files for the document. Be sure to know and understand licensing information for any fonts you collect and possibly redistribute.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="346"/>
        <source>Include color profiles when collecting files for the document</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>CwSetColor</name>
    <message>
        <location filename="" line="136966688"/>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>HSV</source>
        <translation type="obsolete">HSV</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>H:</source>
        <translation type="obsolete">H:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>S:</source>
        <translation type="obsolete">S:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>V:</source>
        <translation type="obsolete">V:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>R:</source>
        <translation type="obsolete">R:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>G:</source>
        <translation type="obsolete">G:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>B:</source>
        <translation type="obsolete">B:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C:</source>
        <translation type="obsolete">C:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>M:</source>
        <translation type="obsolete">M:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y:</source>
        <translation type="obsolete">Y:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>K:</source>
        <translation type="obsolete">K:</translation>
    </message>
</context>
<context>
    <name>DashEditor</name>
    <message>
        <location filename="../../scribus/dasheditor.cpp" line="363"/>
        <source>Value:</source>
        <translation type="unfinished">Väärtus:</translation>
    </message>
    <message>
        <location filename="../../scribus/dasheditor.cpp" line="364"/>
        <source>Offset:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>DeferredTask</name>
    <message>
        <location filename="../../scribus/deferredtask.cpp" line="82"/>
        <source>Cancelled by user</source>
        <translation>Kasutaja katkestas toimingu</translation>
    </message>
</context>
<context>
    <name>DelColor</name>
    <message>
        <location filename="../../scribus/dcolor.cpp" line="28"/>
        <source>Delete Color</source>
        <translation>Värvi kustutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/dcolor.cpp" line="36"/>
        <source>Delete Color:</source>
        <translation>Kustutatav värv:</translation>
    </message>
    <message>
        <location filename="../../scribus/dcolor.cpp" line="45"/>
        <source>Replace With:</source>
        <translation>Asendus:</translation>
    </message>
</context>
<context>
    <name>DelPages</name>
    <message>
        <location filename="../../scribus/delpages.cpp" line="17"/>
        <source>Delete Pages</source>
        <translation>Lehekülgede kustutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/delpages.cpp" line="26"/>
        <source>Delete From:</source>
        <translation>Kustutatakse alates:</translation>
    </message>
    <message>
        <location filename="../../scribus/delpages.cpp" line="34"/>
        <source>to:</source>
        <translation>kuni:</translation>
    </message>
</context>
<context>
    <name>DelStyle</name>
    <message>
        <location filename="../editformats.cpp" line="36"/>
        <source>Delete Style</source>
        <translation type="obsolete">Stiili kustutamine</translation>
    </message>
    <message>
        <location filename="../editformats.cpp" line="42"/>
        <source>Delete Style:</source>
        <translation type="obsolete">Kustutatav stiil:</translation>
    </message>
    <message>
        <location filename="../editformats.cpp" line="46"/>
        <source>Replace With:</source>
        <translation type="obsolete">Asendus:</translation>
    </message>
    <message>
        <location filename="../editformats.cpp" line="49"/>
        <source>No Style</source>
        <translation type="obsolete">Stiil puudub</translation>
    </message>
</context>
<context>
    <name>DocIm</name>
    <message>
        <location filename="../../scribus/plugins/gettext/docim/docim.cpp" line="160"/>
        <source>Importing failed</source>
        <translation>Import ebaõnnestus</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/docim/docim.cpp" line="161"/>
        <source>Importing Word document failed 
%1</source>
        <translation>Word&apos;i dokumendi import ebaõnnestus
%1</translation>
    </message>
</context>
<context>
    <name>DocInfos</name>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="30"/>
        <source>Document Information</source>
        <translation>Dokumendi info</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="39"/>
        <source>&amp;Title:</source>
        <translation>&amp;Pealkiri:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="46"/>
        <source>&amp;Author:</source>
        <translation>A&amp;utor:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="53"/>
        <source>&amp;Keywords:</source>
        <translation>&amp;Võtmesõnad:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="61"/>
        <source>Descri&amp;ption:</source>
        <translation>&amp;Kirjeldus:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="74"/>
        <source>P&amp;ublisher:</source>
        <translation>&amp;Avaldaja:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="81"/>
        <source>&amp;Contributors:</source>
        <translation>&amp;Kaasautorid:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="89"/>
        <source>Dat&amp;e:</source>
        <translation>Kuupä&amp;ev:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="96"/>
        <source>T&amp;ype:</source>
        <translation>&amp;Tüüp:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="103"/>
        <source>F&amp;ormat:</source>
        <translation>&amp;Vorming:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="110"/>
        <source>Identi&amp;fier:</source>
        <translation>I&amp;dentifikaator:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="117"/>
        <source>&amp;Source:</source>
        <translation>All&amp;ikas:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="124"/>
        <source>&amp;Language:</source>
        <translation>&amp;Keel:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="131"/>
        <source>&amp;Relation:</source>
        <translation>&amp;Seos:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="138"/>
        <source>Co&amp;verage:</source>
        <translation>&amp;Hõlmamine:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="145"/>
        <source>Ri&amp;ghts:</source>
        <translation>Õi&amp;gused:</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="152"/>
        <source>Documen&amp;t</source>
        <translation>&amp;Dokument</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="153"/>
        <source>Further &amp;Information</source>
        <translation>Täiendav &amp;info</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="159"/>
        <source>The person or organisation primarily responsible for making the content of the document. This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation>Isik või organisatsioon, kes vastutab dokumendi sisu eest tervikuna. Selle välja saab info huvides põimida nii Scribuse dokumenti kui ka PDF-i metaandmetesse.</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="160"/>
        <source>A name given to the document. This field can be embedded in the Scribus document for reference, as well as in the metadata of a PDF</source>
        <translation>Dokumendi nimi. Selle välja saab info huvides põimida nii Scribuse dokumenti kui ka PDF-i metaandmetesse.</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="161"/>
        <source>An account of the content of the document. This field is for a brief description or abstract of the document. It is embedded in the PDF on export</source>
        <translation>Dokumendi sisu ülevaade. See väli sisaldab dokumendi lühikirjeldust või kokkuvõtet. See põimitakse eksportimisel PDF-i.</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="162"/>
        <source>The topic of the content of the document. This field is for document keywords you wish to embed in a PDF, to assist searches and indexing of PDF files</source>
        <translation>Dokumendi sisu teema. See väli on mõeldud PDF-i põimitavate dokumendi võtmesõnade jaoks, mis aitavad PDF-failides otsida ja neid indekseerida.</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="163"/>
        <source>A person or organisation responsible for making the document available</source>
        <translation>Isik või organisatsioon, kes vastutab dokumendi avaldamise eest</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="164"/>
        <source>A person or organisation responsible for making contributions to the content of the document</source>
        <translation>Isik või organisatsioon, kes on andnud panuse dokumendi sisu loomisse</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="165"/>
        <source>A date associated with an event in the life cycle of the document, in YYYY-MM-DD format, as per ISO 8601</source>
        <translation>Dokumendi loomisega seotud kuupäev vormingus YYYY-MM-DD (vastavalt ISO 8601 nõuetele)</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="166"/>
        <source>The nature or genre of the content of the document, eg. categories, functions, genres, etc</source>
        <translation>Dokumendi sisu iseloom või žanr, nt. kategooria, funktsioon, žanr vms</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="167"/>
        <source>The physical or digital manifestation of the document. Media type and dimensions would be worth noting. RFC2045,RFC2046 for MIME types are also useful here</source>
        <translation>Dokumendi füüsiline või digitaalne kuju. Mainida tasuks nii andmekandja tüüpi kui ka mõõtmeid. Siin saab ära kasutada MIME tüüpide jaoks mõeldud RFC2045 ja RFC2046.</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="168"/>
        <source>An unambiguous reference to the document within a given context such as ISBN or URI</source>
        <translation>Üheselt mõistetav viide dokumendile kindlas kontekstis, n. ISBN või URI</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="169"/>
        <source>A reference to a document from which the present document is derived, eg. ISBN or URI</source>
        <translation>Viide dokumendile, millest aktiivne dokument on tuletatud, nt. ISBN või URI</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="170"/>
        <source>The language in which the content of the document is written, usually a ISO-639 language code optionally suffixed with a hypen and an ISO-3166 country code, eg. en-GB, fr-CH</source>
        <translation>Keel, milles on kirja pandud dokumendi sisu. Tavaliselt keelekood (ISO-639 järgi), millele võib lisanduda sidekriips ja riigikood (ISO-3166 järgi), nt. et, en-GB, fr-CH.</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="171"/>
        <source>A reference to a related document, possibly using a formal identifier such as a ISBN or URI</source>
        <translation>Viide seotud dokumendile, võib olla formaalne identifikaator, nt. ISBN või URI</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="172"/>
        <source>The extent or scope of the content of the document, possibly including location, time and jurisdiction ranges</source>
        <translation>Dokumendi sisu haare või ulatus, võib sisaldada asukohta, aega, jurisdiktsiooni</translation>
    </message>
    <message>
        <location filename="../../scribus/docinfo.cpp" line="173"/>
        <source>Information about rights held in and over the document, eg. copyright, patent or trademark</source>
        <translation>Info dokumendiga seotud õiguste kohta, nt. autoriõigus, patent, kaubamärk</translation>
    </message>
</context>
<context>
    <name>DocSections</name>
    <message>
        <location filename="../../scribus/docsections.cpp" line="72"/>
        <source>Add a page numbering section to the document. The new section will be added after the currently selected section.</source>
        <translation>Lisa dokumendile lehekülgede nummerdamise sektsioon. Uus sektsioon lisatakse valitud sektsiooni järele.</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="73"/>
        <source>Delete the currently selected section.</source>
        <translation>Kustuta valitud sektsioon</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="79"/>
        <source>&lt;b&gt;Name:&lt;/b&gt; Optional name for section eg. Index&lt;br/&gt;&lt;b&gt;Shown:&lt;/b&gt; Select to show the page numbers in this section if there is one or more text frames setup to do so.&lt;br/&gt;&lt;b&gt;From:&lt;/b&gt; The page index for this section to start at.&lt;br/&gt;&lt;b&gt;To:&lt;/b&gt; The page index for this section to stop at.&lt;br/&gt;&lt;b&gt;Style:&lt;/b&gt; Select the page number style to be used.&lt;br/&gt;&lt;b&gt;Start:&lt;/b&gt; The index within the Style&apos;s range to star at. Eg. If Start=2 and Style=a,b,c, ..., the numbers will begin at b. For the first section in the document this replaces the older First Page Number in the new file window.</source>
        <translation>&lt;b&gt;Nimi:&lt;/b&gt; sektsiooni nimi, nt Indeks; võib ka ära jääda&lt;br/&gt;&lt;b&gt;Näitamine:&lt;/b&gt; märkimise korral näidatakse sektsioonis leheküljenumbreid, kui seda vajab üks või enam tekstikasti.&lt;br/&gt;&lt;b&gt;Alates:&lt;/b&gt; lehekülg, millest antud sektsiooni indeks algab.&lt;br/&gt;&lt;b&gt;Kuni:&lt;/b&gt; lehekülg, milleni antud sektsiooni indeks ulatub.&lt;br/&gt;&lt;b&gt;Stiil:&lt;/b&gt; kasutatav leheküljenumbri stiil.&lt;br/&gt;&lt;b&gt;Algus:&lt;/b&gt; indeks stiili vahemikus, millest alustatakse. Kui nt. Algus=2 ja Stiil=a,b,c, ..., algavad numbrid b-ga. Dokumendi esimese sektsiooni korral asendab see senise esimese lehekülje numbri uues failiaknas.</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>1, 2, 3, ...</source>
        <translation>1, 2, 3, ...</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>i, ii, iii, ...</source>
        <translation>i, ii, iii, ...</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>I, II, III, ...</source>
        <translation>I, II, III, ...</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>a, b, c, ...</source>
        <translation>a, b, c, ...</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="87"/>
        <source>A, B, C, ...</source>
        <translation>A, B, C, ...</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="201"/>
        <source>Page Number Out Of Bounds</source>
        <translation>Leheküljenumber väljub piiridest</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.cpp" line="201"/>
        <source>The value you have entered is outside the range of page numbers in the current document (%1-%2).</source>
        <translation>Sisestatud väärtus väljub aktiivse dokumendi leheküljenumbrite vahemikust (%1-%2).</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="13"/>
        <source>Document Sections</source>
        <translation type="unfinished">Dokumendi sektsioonid</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="83"/>
        <source>&amp;Add</source>
        <translation type="unfinished">Lis&amp;a</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="86"/>
        <source>Alt+A</source>
        <translation type="unfinished">Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="93"/>
        <source>&amp;Delete</source>
        <translation type="unfinished">K&amp;ustuta</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="96"/>
        <source>Alt+D</source>
        <translation type="unfinished">Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="32"/>
        <source>Name</source>
        <translation type="unfinished">Nimi</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="37"/>
        <source>Shown</source>
        <translation type="unfinished">Näitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="42"/>
        <source>From</source>
        <translation type="unfinished">Alates</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="47"/>
        <source>To</source>
        <translation type="unfinished">Kuni</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="52"/>
        <source>Style</source>
        <translation type="unfinished">Stiil</translation>
    </message>
    <message>
        <location filename="../../scribus/docsections.ui" line="57"/>
        <source>Start</source>
        <translation type="unfinished">Algus</translation>
    </message>
</context>
<context>
    <name>DocSectionsBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Document Sections</source>
        <translation type="obsolete">Dokumendi sektsioonid</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name</source>
        <translation type="obsolete">Nimi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shown</source>
        <translation type="obsolete">Näitamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>From</source>
        <translation type="obsolete">Alates</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>To</source>
        <translation type="obsolete">Kuni</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Style</source>
        <translation type="obsolete">Stiil</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Start</source>
        <translation type="obsolete">Algus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Add</source>
        <translation type="obsolete">Lis&amp;a</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Delete</source>
        <translation type="obsolete">K&amp;ustuta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
</context>
<context>
    <name>DocumentItemAttributes</name>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>None</source>
        <comment>relationship</comment>
        <translation>Puudub</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Relates To</source>
        <translation>On seotud elemendiga</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Is Parent Of</source>
        <translation>On eellane elemendile</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="17"/>
        <source>Is Child Of</source>
        <translation>On järglane elemendile</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>None</source>
        <comment>auto add</comment>
        <translation>Puudub</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>Text Frames</source>
        <translation>Tekstikastid</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="19"/>
        <source>Image Frames</source>
        <translation>Pildikastid</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>None</source>
        <comment>types</comment>
        <translation>Puudub</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Boolean</source>
        <translation>Tõeväärtus</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Integer</source>
        <translation>Täisarv</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>Real Number</source>
        <translation>Reaalarv</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.cpp" line="21"/>
        <source>String</source>
        <translation>String</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="13"/>
        <source>Document Item Attributes</source>
        <translation type="unfinished">Dokumendi elemendi atribuudid</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="82"/>
        <source>&amp;Add</source>
        <translation type="unfinished">Lis&amp;a</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="85"/>
        <source>Alt+A</source>
        <translation type="unfinished">Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="92"/>
        <source>&amp;Copy</source>
        <translation type="unfinished">&amp;Kopeeri</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="95"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="102"/>
        <source>&amp;Delete</source>
        <translation type="unfinished">K&amp;ustuta</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="105"/>
        <source>Alt+D</source>
        <translation type="unfinished">Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="112"/>
        <source>C&amp;lear</source>
        <translation type="unfinished">&amp;Puhasta</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="115"/>
        <source>Alt+L</source>
        <translation type="unfinished">Alt+L</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="26"/>
        <source>Name</source>
        <translation type="unfinished">Nimi</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="31"/>
        <source>Type</source>
        <translation type="unfinished">Tüüp</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="36"/>
        <source>Value</source>
        <translation type="unfinished">Väärtus</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="41"/>
        <source>Parameter</source>
        <translation type="unfinished">Parameeter</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="46"/>
        <source>Relationship</source>
        <translation type="unfinished">Seos</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="51"/>
        <source>Relationship To</source>
        <translation type="unfinished">Seos elemendiga</translation>
    </message>
    <message>
        <location filename="../../scribus/docitemattrprefs.ui" line="56"/>
        <source>Auto Add To</source>
        <translation type="unfinished">Automaane lisamine elemendile</translation>
    </message>
</context>
<context>
    <name>DocumentItemAttributesBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Document Item Attributes</source>
        <translation type="obsolete">Dokumendi elemendi atribuudid</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name</source>
        <translation type="obsolete">Nimi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Type</source>
        <translation type="obsolete">Tüüp</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Value</source>
        <translation type="obsolete">Väärtus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Parameter</source>
        <translation type="obsolete">Parameeter</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relationship</source>
        <translation type="obsolete">Seos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relationship To</source>
        <translation type="obsolete">Seos elemendiga</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Auto Add To</source>
        <translation type="obsolete">Automaane lisamine elemendile</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Add</source>
        <translation type="obsolete">Lis&amp;a</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Copy</source>
        <translation type="obsolete">&amp;Kopeeri</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Delete</source>
        <translation type="obsolete">K&amp;ustuta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C&amp;lear</source>
        <translation type="obsolete">&amp;Puhasta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+L</source>
        <translation type="obsolete">Alt+L</translation>
    </message>
</context>
<context>
    <name>EPSPlug</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Importing PostScript</source>
        <translation type="obsolete">PostScripti import</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="83"/>
        <source>Analyzing PostScript:</source>
        <translation>PostScripti analüüsimine:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="473"/>
        <source>Importing File:
%1
failed!</source>
        <translation>Faili:
%1
import ebaõnnestus!</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="474"/>
        <source>Fatal Error</source>
        <translation>Saatuslik viga</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="479"/>
        <source>Generating Items</source>
        <translation>Elementide genereerimine</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="871"/>
        <source>Converting of %1 images failed!</source>
        <translation>%1 pildi teisendamine ebaõnnestus!</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="872"/>
        <source>Error</source>
        <translation>Viga</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="738"/>
        <source>Group%1</source>
        <translation>Grupp%1</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importps.cpp" line="80"/>
        <source>Importing: %1</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>EditStyle</name>
    <message>
        <location filename="../edit1format.cpp" line="47"/>
        <source>Edit Style</source>
        <translation type="obsolete">Stiili redigeerimine</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="67"/>
        <source>&amp;Name:</source>
        <translation type="obsolete">&amp;Nimi:</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="80"/>
        <source>Character</source>
        <translation type="obsolete">Märk</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="272"/>
        <source> pt</source>
        <translation type="obsolete"> pt</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="239"/>
        <source> %</source>
        <translation type="obsolete"> %</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="200"/>
        <source>Distances</source>
        <translation type="obsolete">Vahemaad</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="209"/>
        <source>Fixed Linespacing</source>
        <translation type="obsolete">Fikseeritud reavahe</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="210"/>
        <source>Automatic Linespacing</source>
        <translation type="obsolete">Automaatne reavahe</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="211"/>
        <source>Align to Baseline Grid</source>
        <translation type="obsolete">Joondamine alusjoontele</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="257"/>
        <source>Drop Caps</source>
        <translation type="obsolete">Süvisinitsiaalid</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="268"/>
        <source>&amp;Lines:</source>
        <translation type="obsolete">&amp;Ridu:</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="274"/>
        <source>Distance from Text:</source>
        <translation type="obsolete">Kaugus tekstist:</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="300"/>
        <source>Tabulators and Indentation</source>
        <translation type="obsolete">Tabeldusmärgid ja taandus</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="324"/>
        <source>Preview of the Paragraph Style</source>
        <translation type="obsolete">Lõigustiili eelvaatlus</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="328"/>
        <source>Background</source>
        <translation type="obsolete">Taust</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select for easier reading of light coloured text styles</source>
        <translation type="obsolete">Vali heleda tekstistiili paremaks nägemiseks</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="360"/>
        <source>Name of your paragraph style</source>
        <translation type="obsolete">Lõigustiili nimi</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="361"/>
        <source>Font of selected text or object</source>
        <translation type="obsolete">Valitud teksti või objekti font</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="362"/>
        <source>Font Size</source>
        <translation type="obsolete">Fondi suurus</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="363"/>
        <source>Color of text fill</source>
        <translation type="obsolete">Teksti täidise värv</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="364"/>
        <source>Color of text stroke</source>
        <translation type="obsolete">Teksti äärejoone värv</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="366"/>
        <source>Determines the overall height, in line numbers, of the Drop Caps</source>
        <translation type="obsolete">Määrab ridades süvisinitsiaalide kogukõrguse</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="367"/>
        <source>Determines the gap between the DropCaps and the Text</source>
        <translation type="obsolete">Määrab vahe süvisinitsiaali ja teksti vahel</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="369"/>
        <source>Spacing above the paragraph</source>
        <translation type="obsolete">Vahe enne lõiku</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="370"/>
        <source>Spacing below the paragraph</source>
        <translation type="obsolete">Vahe pärast lõiku</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="371"/>
        <source>Manual Tracking</source>
        <translation type="obsolete">Märkide koondamine</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="372"/>
        <source>Offset to baseline of characters</source>
        <translation type="obsolete">Nihe märkide alusjoone suhtes</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="373"/>
        <source>Line Spacing</source>
        <translation type="obsolete">Reavahe</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="374"/>
        <source>Click to select the line spacing mode</source>
        <translation type="obsolete">Klõpsa reavahe režiimi valimiseks</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="375"/>
        <source>Toggles sample text of this paragraph style</source>
        <translation type="obsolete">Näitab näidisteksti antud lõigustiiliga</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="508"/>
        <source>Name of the style is not unique</source>
        <translation type="obsolete">Stiili nimi pole unikaalne</translation>
    </message>
    <message>
        <location filename="../edit1format.cpp" line="448"/>
        <source>Auto</source>
        <translation type="obsolete">Automaatne</translation>
    </message>
</context>
<context>
    <name>EditToolBar</name>
    <message>
        <location filename="../../scribus/ui/edittoolbar.cpp" line="29"/>
        <source>Edit</source>
        <translation type="unfinished">Redigeerimine</translation>
    </message>
</context>
<context>
    <name>Editor</name>
    <message>
        <location filename="../../scribus/editor.cpp" line="30"/>
        <source>Editor</source>
        <translation>Redaktor</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="36"/>
        <source>&amp;New</source>
        <translation>&amp;Uus</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="39"/>
        <source>&amp;Open...</source>
        <translation>&amp;Ava...</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="41"/>
        <source>Save &amp;As...</source>
        <translation>Salvesta &amp;kui...</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="43"/>
        <source>&amp;Save and Exit</source>
        <translation>&amp;Salvesta ja välju</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="45"/>
        <source>&amp;Exit without Saving</source>
        <translation>&amp;Välju salvestamata</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="47"/>
        <source>&amp;Undo</source>
        <translation>&amp;Võta tagasi</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="50"/>
        <source>&amp;Redo</source>
        <translation>&amp;Tee uuesti</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="52"/>
        <source>Cu&amp;t</source>
        <translation>&amp;Lõika</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="55"/>
        <source>&amp;Copy</source>
        <translation>&amp;Kopeeri</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="58"/>
        <source>&amp;Paste</source>
        <translation>&amp;Aseta</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="61"/>
        <source>C&amp;lear</source>
        <translation>&amp;Puhasta</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="63"/>
        <source>&amp;Get Field Names</source>
        <translation>&amp;Hangi väljanimed</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="65"/>
        <source>&amp;File</source>
        <translation>&amp;Fail</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="72"/>
        <source>&amp;Edit</source>
        <translation>&amp;Redigeerimine</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="127"/>
        <source>JavaScripts (*.js);;All Files (*)</source>
        <translation>JavaScriptid (*.js);;Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="37"/>
        <source>Ctrl+N</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="48"/>
        <source>Ctrl+Z</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="53"/>
        <source>Ctrl+X</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="56"/>
        <source>Ctrl+C</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/editor.cpp" line="59"/>
        <source>Ctrl-V</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>EffectsDialog</name>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="44"/>
        <source>Image Effects</source>
        <translation>Pildiefektid</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="81"/>
        <source>Options:</source>
        <translation>Valikud:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="98"/>
        <source>Color:</source>
        <translation>Värv:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="109"/>
        <source>Shade:</source>
        <translation>Varjund:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="125"/>
        <source>Brightness:</source>
        <translation>Heledus:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="147"/>
        <source>Contrast:</source>
        <translation>Kontrast:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="198"/>
        <source>Radius:</source>
        <translation>Raadius:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="180"/>
        <source>Value:</source>
        <translation>Väärtus:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="216"/>
        <source>Posterize:</source>
        <translation>Poster:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="500"/>
        <source>Available Effects</source>
        <translation>Saadaolevad efektid</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1393"/>
        <source>Blur</source>
        <translation>Pehmendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1371"/>
        <source>Brightness</source>
        <translation>Heledus</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1362"/>
        <source>Colorize</source>
        <translation>Toonimine</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1377"/>
        <source>Contrast</source>
        <translation>Kontrast</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="981"/>
        <source>Grayscale</source>
        <translation>Halltoonid</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="983"/>
        <source>Invert</source>
        <translation>Inverteerimine</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1406"/>
        <source>Posterize</source>
        <translation>Poster</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1383"/>
        <source>Sharpen</source>
        <translation>Teravustamine</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="482"/>
        <source>&gt;&gt;</source>
        <translation>&gt;&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="486"/>
        <source>&lt;&lt;</source>
        <translation>&lt;&lt;</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="497"/>
        <source>Effects in use</source>
        <translation>Kasutatavad efektid</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="616"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="620"/>
        <source>Cancel</source>
        <translation>Loobu</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="351"/>
        <source>Color 1:</source>
        <translation>Värv 1:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="371"/>
        <source>Color 2:</source>
        <translation>Värv 2:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="391"/>
        <source>Color 3:</source>
        <translation>Värv 3:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="411"/>
        <source>Color 4:</source>
        <translation>Värv 4:</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1412"/>
        <source>Duotone</source>
        <translation>Duotone</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1448"/>
        <source>Tritone</source>
        <translation>Tritone</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1499"/>
        <source>Quadtone</source>
        <translation>Quadtone</translation>
    </message>
    <message>
        <location filename="../../scribus/effectsdialog.cpp" line="1565"/>
        <source>Curves</source>
        <translation>Trajektoorid</translation>
    </message>
</context>
<context>
    <name>ExportBitmap</name>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="204"/>
        <source>File exists. Overwrite?</source>
        <translation>Fail on olemas. Kas kirjutada üle?</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="205"/>
        <source>exists already. Overwrite?</source>
        <translation>on juba olemas. Kas kirjutada üle?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>All</source>
        <translation type="obsolete">Kõik</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="218"/>
        <source>Save as Image</source>
        <translation type="unfinished">Salvestamine pildina</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="192"/>
        <source>Insufficient memory for this image size.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="219"/>
        <source>Error writing the output file(s).</source>
        <translation type="unfinished">Viga väljundfaili kirjutamisel.</translation>
    </message>
</context>
<context>
    <name>ExportForm</name>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="80"/>
        <source>Choose a Export Directory</source>
        <translation>Ekspordikataloogi valik</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="13"/>
        <source>Export as Image(s)</source>
        <translation>Eksport piltidena</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="153"/>
        <source>&amp;Export to Directory:</source>
        <translation>&amp;Ekspordikataloog:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="166"/>
        <source>C&amp;hange...</source>
        <translation>&amp;Muuda...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="25"/>
        <source>Options</source>
        <translation>Valikud</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="54"/>
        <source>Image &amp;Type:</source>
        <translation>Pildi &amp;tüüp:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="64"/>
        <source>&amp;Quality:</source>
        <translation>&amp;Kvaliteet:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="74"/>
        <source>&amp;Resolution:</source>
        <translation>&amp;Lahutus:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="84"/>
        <source>&amp;Size:</source>
        <translation>&amp;Suurus:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="126"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="110"/>
        <source> dpi</source>
        <translation> dpi</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="175"/>
        <source>Range</source>
        <translation>Vahemik</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="197"/>
        <source>&amp;Current page</source>
        <translation>&amp;Aktiivne lehekülg</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="224"/>
        <source>&amp;All pages</source>
        <translation>&amp;Kõik leheküljed</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="217"/>
        <source>&amp;Range</source>
        <translation>&amp;Vahemik</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C</source>
        <translation type="obsolete">C</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="44"/>
        <source>Image size in Pixels</source>
        <translation>Pildi suurus pikslites</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="117"/>
        <source>Export a range of pages</source>
        <translation>Lehekülgede vahemiku eksport</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="118"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation>Sisesta komadega eradatud arvud või märgid:
* tähistab kõiki lehekülgi, 1-5 lehekülgede vahemikku,
konkreetsed leheküljenumbrid vastavaid lehekülgi.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="119"/>
        <source>Export all pages</source>
        <translation>Kõigi lehekülgede eksport</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="120"/>
        <source>Export only the current page</source>
        <translation>Ainult aktiivse lehekülje eksport</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="121"/>
        <source>Resolution of the Images
Use 72 dpi for Images intended for the Screen</source>
        <translation>Piltide lahutus
Ekraanile mõeldud piltide korral võiks see olla 72 dpi</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="122"/>
        <source>Size of the images. 100% for no changes, 200% for two times larger etc.</source>
        <translation>Piltide suurus. 100% tähendab muudatusteta, 200% kaks korda suuremat jne.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="114"/>
        <source>The quality of your images - 100% is the best, 1% the lowest quality</source>
        <translation type="obsolete">Piltide kvaliteet. 100% on parim, 1% halvim kvaliteet</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="125"/>
        <source>Available export formats</source>
        <translation>Saadaolevad ekspordivormingud</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="126"/>
        <source>The output directory - the place to store your images.
Name of the export file will be &apos;documentname-pagenumber.filetype&apos;</source>
        <translation>Väljundkataloog, kuhu pildid salvestatakse.
Eksportfaili nimeks saab &apos;dokumendinimi-leheküljenumber.failitüüp&apos;.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="127"/>
        <source>Change the output directory</source>
        <translation>Muuda väljundkataloogi</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/exportform.ui" line="37"/>
        <source>TextLabel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="123"/>
        <source>The compression ratio of your images - 100% is no compression, 0% highest compression. If in doubt, use &apos;Automatic&apos;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/dialog.cpp" line="124"/>
        <source>Automatic</source>
        <translation type="unfinished">Automaatne</translation>
    </message>
</context>
<context>
    <name>ExtImageProps</name>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="39"/>
        <source>Extended Image Properties</source>
        <translation>Laiendatud pildi omadused</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="102"/>
        <source>Normal</source>
        <translation>Normaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="103"/>
        <source>Darken</source>
        <translation>Tumendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="104"/>
        <source>Lighten</source>
        <translation>Helendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="105"/>
        <source>Hue</source>
        <translation>Toon</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="106"/>
        <source>Saturation</source>
        <translation>KüllastusKüllastus</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="107"/>
        <source>Color</source>
        <translation>VärvVärv</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="108"/>
        <source>Luminosity</source>
        <translation>Valgsus</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="109"/>
        <source>Multiply</source>
        <translation>Korrutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="110"/>
        <source>Screen</source>
        <translation>Ekraan</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="111"/>
        <source>Dissolve</source>
        <translation>Hägunemine</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="112"/>
        <source>Overlay</source>
        <translation>Ülekatmine</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="113"/>
        <source>Hard Light</source>
        <translation>Külm valgus</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="114"/>
        <source>Soft Light</source>
        <translation>Soe valgus</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="115"/>
        <source>Difference</source>
        <translation>Lahutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="116"/>
        <source>Exclusion</source>
        <translation>Väljajätmine</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="117"/>
        <source>Color Dodge</source>
        <translation>Värvi helestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="118"/>
        <source>Color Burn</source>
        <translation>Värvi tumestamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Exlusion</source>
        <translation type="obsolete">Väljajätmine</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="98"/>
        <source>Blend Mode:</source>
        <translation>Ühtesulamise režiim:</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="121"/>
        <source>Opacity:</source>
        <translation>Läbipaistmatus:</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="127"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="133"/>
        <source>Name</source>
        <translation>Nimi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Background</source>
        <translation type="obsolete">Taust</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="214"/>
        <source>Layers</source>
        <translation>Kihid</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="267"/>
        <source>Don&apos;t use any Path</source>
        <translation>Trajektoore ei kasutata</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="269"/>
        <source>Paths</source>
        <translation>Trajektoorid</translation>
    </message>
    <message>
        <location filename="../../scribus/extimageprops.cpp" line="276"/>
        <source>Live Preview</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FDialogPreview</name>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="198"/>
        <source>Size:</source>
        <translation>Suurus:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="199"/>
        <source>Resolution:</source>
        <translation>Lahutus:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="199"/>
        <source>DPI</source>
        <translation>DPI</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="229"/>
        <source>Unknown</source>
        <translation>Teadmata</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="190"/>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="193"/>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="196"/>
        <source>Grayscale</source>
        <translation type="obsolete">Halltoonid</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="205"/>
        <source>Colorspace:</source>
        <translation>Värviruum:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="216"/>
        <source>Title:</source>
        <translation>Pealkiri:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="219"/>
        <source>No Title</source>
        <translation>Pealkiri puudub</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="221"/>
        <source>Author:</source>
        <translation>Autor:</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="231"/>
        <source>Scribus Document</source>
        <translation>Scribuse dokument</translation>
    </message>
    <message>
        <location filename="../customfdialog.cpp" line="199"/>
        <source>Duotone</source>
        <translation type="obsolete">Duotone</translation>
    </message>
    <message>
        <location filename="../../scribus/customfdialog.cpp" line="226"/>
        <source>File Format:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FileLoader</name>
    <message>
        <location filename="../../scribus/fileloader.cpp" line="593"/>
        <source>Some fonts used by this document have been substituted:</source>
        <translation>Mõned selles dokumendis kasutatavad fondid on asendatud:</translation>
    </message>
    <message>
        <location filename="../../scribus/fileloader.cpp" line="597"/>
        <source> was replaced by: </source>
        <translation> asendati fondiga: </translation>
    </message>
</context>
<context>
    <name>FileToolBar</name>
    <message>
        <location filename="../../scribus/ui/filetoolbar.cpp" line="31"/>
        <source>File</source>
        <translation type="unfinished">Fail</translation>
    </message>
</context>
<context>
    <name>FontComboH</name>
    <message>
        <location filename="../../scribus/fontcombo.cpp" line="148"/>
        <source>Face:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontcombo.cpp" line="149"/>
        <source>Style:</source>
        <translation type="unfinished">Stiil:</translation>
    </message>
</context>
<context>
    <name>FontListModel</name>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="63"/>
        <source>Font Name</source>
        <translation type="unfinished">Fondi nimi</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="65"/>
        <source>Use Font</source>
        <translation type="unfinished">Kasutusel</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="67"/>
        <source>Family</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="69"/>
        <source>Style</source>
        <translation type="unfinished">Stiil</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="71"/>
        <source>Variant</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="73"/>
        <source>Type</source>
        <translation type="unfinished">Tüüp</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="75"/>
        <source>Format</source>
        <translation type="unfinished">Vorming</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="77"/>
        <source>Embed in PostScript</source>
        <translation type="unfinished">Põimimine PostScripti</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="79"/>
        <source>Subset</source>
        <translation type="unfinished">Alamhulk</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="81"/>
        <source>Access</source>
        <translation type="unfinished">Õigused</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="83"/>
        <source>Used in Doc</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="85"/>
        <source>Path to Font File</source>
        <translation type="unfinished">Fondifaili asukoht</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="144"/>
        <source>Unknown</source>
        <comment>font type</comment>
        <translation type="unfinished">Teadmata</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="157"/>
        <source>Unknown</source>
        <comment>font format</comment>
        <translation type="unfinished">Teadmata</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="164"/>
        <source>User</source>
        <comment>font preview</comment>
        <translation type="unfinished">Kasutaja</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="165"/>
        <source>System</source>
        <comment>font preview</comment>
        <translation type="unfinished">Süsteem</translation>
    </message>
    <message>
        <location filename="../../scribus/fontlistmodel.cpp" line="190"/>
        <source>Click to change the value</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontPrefs</name>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="48"/>
        <source>Available Fonts</source>
        <translation>Saadaolevad fondid</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="48"/>
        <source>Font Substitutions</source>
        <translation>Fondiasendused</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="48"/>
        <source>Additional Paths</source>
        <translation>Lisaasukohad</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="48"/>
        <source>Font Name</source>
        <comment>font preview</comment>
        <translation type="obsolete">Fondi nimi</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="49"/>
        <source>Use Font</source>
        <comment>font preview</comment>
        <translation type="obsolete">Kasutusel</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Embed in:</source>
        <comment>font preview</comment>
        <translation type="obsolete">Põimimine:</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="53"/>
        <source>Subset</source>
        <comment>font preview</comment>
        <translation type="obsolete">Alamhulk</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="55"/>
        <source>Path to Font File</source>
        <comment>font preview</comment>
        <translation type="obsolete">Fondifaili asukoht</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>PostScript</source>
        <translation type="obsolete">PostScript</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="58"/>
        <source>&amp;Available Fonts</source>
        <translation>&amp;Saadaolevad fondid</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="66"/>
        <source>Font Name</source>
        <translation>Fondi nimi</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="67"/>
        <source>Replacement</source>
        <translation>Asendus</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="82"/>
        <source>&amp;Delete</source>
        <translation>K&amp;ustuta</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="88"/>
        <source>Font &amp;Substitutions</source>
        <translation>&amp;Fondiasendused</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="107"/>
        <source>C&amp;hange...</source>
        <translation>&amp;Muuda...</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="109"/>
        <source>A&amp;dd...</source>
        <translation>Lis&amp;a...</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="111"/>
        <source>&amp;Remove</source>
        <translation>&amp;Eemalda</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font search paths can only be set in Preferences, and only when there is no document currently open. Close any open documents, then use Edit-&gt;Settings to change the font search path.</source>
        <translation type="obsolete">Fontide asukohad saab määrata ainult seadistustes ja ainult siis, kui ükski dokument pole avatud. Sulge kõik avatud dokumendid ning muuda siis fontide asukohta menüükäsuga Redigeerimine-&gt;Seadistused.</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="135"/>
        <source>Additional &amp;Paths</source>
        <translation>Lis&amp;aasukohad</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="247"/>
        <source>Choose a Directory</source>
        <translation>Kataloogi valik</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="51"/>
        <source>Embed in PostScript</source>
        <comment>font preview</comment>
        <translation type="obsolete">Põimimine PostScripti</translation>
    </message>
    <message>
        <location filename="../../scribus/fontprefs.cpp" line="130"/>
        <source>Font search paths can only be set in File &gt; Preferences, and only when there is no document currently open. Close any open documents, then use File &gt; Preferences &gt; Fonts to change the font search path.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="57"/>
        <source>Use Font</source>
        <translation type="obsolete">Kasutusel</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="58"/>
        <source>Embed in PostScript</source>
        <translation type="obsolete">Põimimine PostScripti</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="59"/>
        <source>Subset</source>
        <translation type="obsolete">Alamhulk</translation>
    </message>
    <message>
        <location filename="../fontprefs.cpp" line="60"/>
        <source>Path to Font File</source>
        <translation type="obsolete">Fondifaili asukoht</translation>
    </message>
</context>
<context>
    <name>FontPreview</name>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="44"/>
        <source>Woven silk pyjamas exchanged for blue quartz</source>
        <comment>font preview</comment>
        <translation>Põdur Zagrebi tšellomängija-följetonist Ciqo külmetas kehvas garaažis</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="164"/>
        <source>Append selected font into Style, Font menu</source>
        <comment>font preview</comment>
        <translation type="obsolete">Lisa valitud font stiili- ja fondimenüüsse</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="111"/>
        <source>Leave preview</source>
        <comment>font preview</comment>
        <translation>Sulge eelvaatlus</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="165"/>
        <source>Typing the text here provides quick searching in the font names. Searching is case insensitive. You can provide a common wild cards (*, ?, [...]) in your phrase. Examples: t* will list all fonts starting with t or T. *bold* will list all fonts with word bold, bolder etc. in the name.</source>
        <translation type="obsolete">Siin saab kiiresti vajaliku fondi leida. Otsing on tõstutundetu. Otsingus võib kasutada metamärke (*, ?, [...]). Näide: t* leiab kõik fondid, mille alguses seisab t või T. *bold* leiab kõik fondid, mille nimes esineb sõna bold, bolder vms.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="114"/>
        <source>Start searching</source>
        <translation type="obsolete">Alusta otsimist</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="113"/>
        <source>Size of the selected font</source>
        <translation>Valitud fondi suurus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample will be shown after key release</source>
        <translation type="obsolete">Näidet näeb pärast klahvi vabastamist</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="97"/>
        <source>User</source>
        <comment>font preview</comment>
        <translation type="obsolete">Kasutaja</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="98"/>
        <source>System</source>
        <comment>font preview</comment>
        <translation type="obsolete">Süsteem</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="42"/>
        <source>Font Name</source>
        <translation type="obsolete">Fondi nimi</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="43"/>
        <source>Doc</source>
        <translation type="obsolete">Dok</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="44"/>
        <source>Type</source>
        <translation type="obsolete">Tüüp</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="45"/>
        <source>Subset</source>
        <translation type="obsolete">Alamhulk</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.cpp" line="46"/>
        <source>Access</source>
        <translation type="obsolete">Õigused</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="13"/>
        <source>Fonts Preview</source>
        <translation type="unfinished">Fontide eelvaatlus</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="19"/>
        <source>&amp;Quick Search:</source>
        <translation type="unfinished">&amp;Kiirotsing:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="35"/>
        <source>&amp;Search</source>
        <translation type="obsolete">Ot&amp;si</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="38"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="80"/>
        <source>&amp;Font Size:</source>
        <translation type="unfinished">&amp;Fondi suurus:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="103"/>
        <source>Text</source>
        <translation type="unfinished">Tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="113"/>
        <source>Sample text to display</source>
        <translation type="unfinished">Näitetekst</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="123"/>
        <source>Se&amp;t</source>
        <translation type="unfinished">&amp;Määra</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="126"/>
        <source>Alt+T</source>
        <translation type="unfinished">Alt+T</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="133"/>
        <source>Reset the text</source>
        <translation type="unfinished">Lähtesta tekst</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.ui" line="209"/>
        <source>&amp;Append</source>
        <translation type="obsolete">Lis&amp;a</translation>
    </message>
    <message>
        <location filename="../plugins/fontpreview/fontpreview.ui" line="212"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="167"/>
        <source>&amp;Close</source>
        <translation type="unfinished">S&amp;ulge</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="170"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.cpp" line="112"/>
        <source>Typing the text here provides quick searching in the font names. Searching is case insensitive. The given text is taken as substring.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="136"/>
        <source>&amp;Default</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="35"/>
        <source>Show Extended Font Information</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreview.ui" line="120"/>
        <source>Set the preview text</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>FontPreviewBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Fonts Preview</source>
        <translation type="obsolete">Fontide eelvaatlus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Quick Search:</source>
        <translation type="obsolete">&amp;Kiirotsing:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Search</source>
        <translation type="obsolete">Ot&amp;si</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font Name</source>
        <translation type="obsolete">Fondi nimi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Doc</source>
        <translation type="obsolete">Dok</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Type</source>
        <translation type="obsolete">Tüüp</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Subset</source>
        <translation type="obsolete">Alamhulk</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Access</source>
        <translation type="obsolete">Õigused</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Font Size:</source>
        <translation type="obsolete">&amp;Fondi suurus:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text</source>
        <translation type="obsolete">Tekst</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Sample text to display</source>
        <translation type="obsolete">Näitetekst</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Se&amp;t</source>
        <translation type="obsolete">&amp;Määra</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+T</source>
        <translation type="obsolete">Alt+T</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reset the text</source>
        <translation type="obsolete">Lähtesta tekst</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Append</source>
        <translation type="obsolete">Lis&amp;a</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Close</source>
        <translation type="obsolete">S&amp;ulge</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
</context>
<context>
    <name>FontPreviewPlugin</name>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="49"/>
        <source>&amp;Font Preview...</source>
        <translation>&amp;Fontide eelvaatlus...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="66"/>
        <source>Font Preview dialog</source>
        <translation>Fontide eelvaatluse dialoog</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="67"/>
        <source>Sorting, searching and browsing available fonts.</source>
        <translation>Saadaolevate fontide sortimine, otsimine ja sirvimine.</translation>
    </message>
</context>
<context>
    <name>FontReplaceDialog</name>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="30"/>
        <source>Font Substitution</source>
        <translation>Fondiasendus</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="40"/>
        <source>This document contains some fonts that are not installed on your system, please choose a suitable replacement for them. Cancel will stop the document from loading.</source>
        <translation>Dokument sisaldab fonte, mida pole sinu süsteemi paigaldatut. Palun vali neile sobiv asendus. Loobumisel dokumenti ei avata.</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="45"/>
        <source>Original Font</source>
        <translation>Originaalfont</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="46"/>
        <source>Substitution Font</source>
        <translation>Asendusfont</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="72"/>
        <source>Make these substitutions permanent</source>
        <translation>Alati kasutatakse määratud asendusi</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="83"/>
        <source>Cancels these font substitutions and stops loading the document.</source>
        <translation>Katkestab fontide asendamise ja dokumendi avamise</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="84"/>
        <source>Enabling this tells Scribus to use these replacements for missing fonts permanently in all future layouts. This can be reverted or changed in Edit &gt; Preferences &gt; Fonts.</source>
        <translation>Sisselülitamisel kasutab Scribus määratud asendusi puuduvate fontide jaoks ka edaspidi. Seda saab tühistada või muuta menüükäsuga Redigeerimine-&gt;Seadistused-&gt;Fondid.</translation>
    </message>
    <message>
        <location filename="../../scribus/fontreplacedialog.cpp" line="85"/>
        <source>If you select OK, then save, these substitutions are made permanent in the document.</source>
        <translation>Kui valida OK ja siis salvestada, kehtestatakse asendused dokumendis püsivalt.</translation>
    </message>
</context>
<context>
    <name>GradientEditor</name>
    <message>
        <location filename="../../scribus/gradienteditor.cpp" line="336"/>
        <source>Add, change or remove color stops here</source>
        <translation>Lisa, muuda või eemalda värvimarkereid</translation>
    </message>
    <message>
        <location filename="../../scribus/gradienteditor.cpp" line="327"/>
        <source>Position:</source>
        <translation>Asukoht:</translation>
    </message>
    <message>
        <location filename="../../scribus/gradienteditor.cpp" line="328"/>
        <source> %</source>
        <translation> %</translation>
    </message>
</context>
<context>
    <name>GradientVectorDialog</name>
    <message>
        <location filename="../../scribus/cpalette.cpp" line="100"/>
        <source>Gradient Vector</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GuideManager</name>
    <message>
        <location filename="../guidemanager.cpp" line="229"/>
        <source>Edit Guide</source>
        <translation type="obsolete">Juhtjoone redigeerimine</translation>
    </message>
    <message>
        <location filename="../guidemanager.cpp" line="257"/>
        <source>Enter a position:</source>
        <translation type="obsolete">Asukoht:</translation>
    </message>
    <message>
        <location filename="../guidemanager.cpp" line="256"/>
        <source>New Guide</source>
        <translation type="obsolete">Uus juhtjoon</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="31"/>
        <source>&amp;Single</source>
        <translation type="unfinished">Ü&amp;ksik</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="146"/>
        <source>Horizontals</source>
        <translation type="unfinished">Rõhtjooned</translation>
    </message>
    <message>
        <location filename="../guidemanager.ui" line="99"/>
        <source>Guide</source>
        <translation type="obsolete">Juhtjoon</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="55"/>
        <source>&amp;Add</source>
        <translation type="unfinished">Lis&amp;a</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="356"/>
        <source>Alt+A</source>
        <translation type="unfinished">Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="65"/>
        <source>D&amp;elete</source>
        <translation type="unfinished">K&amp;ustuta</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="307"/>
        <source>Alt+E</source>
        <translation type="unfinished">Alt+E</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="233"/>
        <source>Verticals</source>
        <translation type="unfinished">Püstjooned</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="94"/>
        <source>A&amp;dd</source>
        <translation type="unfinished">L&amp;isa</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="97"/>
        <source>Alt+D</source>
        <translation type="unfinished">Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="104"/>
        <source>De&amp;lete</source>
        <translation type="unfinished">&amp;Kustuta</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="122"/>
        <source>Alt+L</source>
        <translation type="unfinished">Alt+L</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="119"/>
        <source>&amp;Lock Guides</source>
        <translation type="unfinished">&amp;Juhtjoonte lukustamine</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="320"/>
        <source>Appl&amp;y to All Pages</source>
        <translation type="unfinished">&amp;Rakendamine kõigile lehekülgedele</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="323"/>
        <source>Alt+Y</source>
        <translation type="unfinished">Alt+Y</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="140"/>
        <source>&amp;Column/Row</source>
        <translation type="unfinished">&amp;Veerg/rida</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="152"/>
        <source>&amp;Number:</source>
        <translation type="unfinished">&amp;Arv:</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="175"/>
        <source>U&amp;se Gap:</source>
        <translation type="unfinished">&amp;Vahe:</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="178"/>
        <source>Alt+S</source>
        <translation type="unfinished">Alt+S</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="275"/>
        <source>Refer To</source>
        <translation type="unfinished">Sidumine</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="281"/>
        <source>&amp;Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="343"/>
        <source>Alt+P</source>
        <translation type="unfinished">Alt+P</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="294"/>
        <source>M&amp;argins</source>
        <translation type="unfinished">V&amp;eerised</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="304"/>
        <source>S&amp;election</source>
        <translation type="unfinished">&amp;Valik</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="239"/>
        <source>Nu&amp;mber:</source>
        <translation type="unfinished">A&amp;rv:</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="262"/>
        <source>Use &amp;Gap:</source>
        <translation type="unfinished">Va&amp;he:</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="265"/>
        <source>Alt+G</source>
        <translation type="unfinished">Alt+G</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="331"/>
        <source>&amp;Misc</source>
        <translation type="unfinished">&amp;Muud</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="337"/>
        <source>Delete all guides from the current page</source>
        <translation type="unfinished">Kõigi juhtjoonte kustutamine aktiivselt lehelt</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="340"/>
        <source>Delete Guides from Current &amp;Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="350"/>
        <source>Delete all guides from the current document</source>
        <translation type="unfinished">Kõigi juhtjoonte kustutamine aktiivsest dokumendist</translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="353"/>
        <source>Delete Guides from &amp;All Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.ui" line="15"/>
        <source>Guide Manager</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="253"/>
        <source>Add a new horizontal guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="254"/>
        <source>Delete the selected horizontal guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="255"/>
        <source>Add a new vertical guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="256"/>
        <source>Delete the selected vertical guide</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="257"/>
        <source>Lock the guides</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="258"/>
        <source>Apply to all pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="259"/>
        <source>Number of horizontal guides to create</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="260"/>
        <source>Number of vertical guides to create</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="261"/>
        <source>Create rows with guides, with an additional gap between the rows</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="262"/>
        <source>Create columns with guides, with an additional gap between the columns</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="263"/>
        <source>Create the selected number of horizontal guides relative to the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="264"/>
        <source>Create the selected number of horizontal guides relative to the current page&apos;s margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="265"/>
        <source>Create the selected number of horizontal guides relative to the current selection of items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="266"/>
        <source>Create the selected number of vertical guides relative to the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="267"/>
        <source>Create the selected number of vertical guides relative to the current page&apos;s margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="268"/>
        <source>Create the selected number of vertical guides relative to the current selection of items</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="269"/>
        <source>Apply the shown guides to all pages in the document</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="270"/>
        <source>Delete all guides shown on the current page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/guidemanager.cpp" line="271"/>
        <source>Delete all guides from all pages</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>GuideManagerBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Manage Guides</source>
        <translation type="obsolete">Juhtjoonte haldamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Standard</source>
        <translation type="obsolete">&amp;Standard</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Horizontals</source>
        <translation type="obsolete">Rõhtjooned</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Guide</source>
        <translation type="obsolete">Juhtjoon</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Unit</source>
        <translation type="obsolete">Ühik</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Add</source>
        <translation type="obsolete">Lis&amp;a</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>D&amp;elete</source>
        <translation type="obsolete">K&amp;ustuta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+E</source>
        <translation type="obsolete">Alt+E</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Verticals</source>
        <translation type="obsolete">Püstjooned</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A&amp;dd</source>
        <translation type="obsolete">L&amp;isa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>De&amp;lete</source>
        <translation type="obsolete">&amp;Kustuta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+L</source>
        <translation type="obsolete">Alt+L</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Lock Guides</source>
        <translation type="obsolete">&amp;Juhtjoonte lukustamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Appl&amp;y to All Pages</source>
        <translation type="obsolete">&amp;Rakendamine kõigile lehekülgedele</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+Y</source>
        <translation type="obsolete">Alt+Y</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A&amp;utomatic</source>
        <translation type="obsolete">A&amp;utomaatne</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Number:</source>
        <translation type="obsolete">&amp;Arv:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>U&amp;se Gap:</source>
        <translation type="obsolete">&amp;Vahe:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Nu&amp;mber:</source>
        <translation type="obsolete">A&amp;rv:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use &amp;Gap:</source>
        <translation type="obsolete">Va&amp;he:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+G</source>
        <translation type="obsolete">Alt+G</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Refer To</source>
        <translation type="obsolete">Sidumine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Page</source>
        <translation type="obsolete">Le&amp;hekülg</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+P</source>
        <translation type="obsolete">Alt+P</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>M&amp;argins</source>
        <translation type="obsolete">V&amp;eerised</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>S&amp;election</source>
        <translation type="obsolete">&amp;Valik</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Misc</source>
        <translation type="obsolete">&amp;Muud</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete &amp;Page Guides</source>
        <translation type="obsolete">K&amp;ustuta lehekülje juhtjooned</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete all guides from the current page</source>
        <translation type="obsolete">Kõigi juhtjoonte kustutamine aktiivselt lehelt</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete &amp;Document guides</source>
        <translation type="obsolete">Kustuta &amp;dokumendi juhtjooned</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Delete all guides from the current document</source>
        <translation type="obsolete">Kõigi juhtjoonte kustutamine aktiivsest dokumendist</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Single</source>
        <translation type="obsolete">Ü&amp;ksik</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Column/Row</source>
        <translation type="obsolete">&amp;Veerg/rida</translation>
    </message>
</context>
<context>
    <name>HelpBrowser</name>
    <message>
        <location filename="../helpbrowser.cpp" line="457"/>
        <source>Contents</source>
        <translation type="obsolete">Sisukord</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="343"/>
        <source>Link</source>
        <translation type="obsolete">Link</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="31"/>
        <source>&amp;Contents</source>
        <translation>&amp;Sisukord</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="60"/>
        <source>&amp;Search</source>
        <translation>Ot&amp;si</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="325"/>
        <source>Relevance</source>
        <translation type="obsolete">Asjakohasus</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="45"/>
        <source>Se&amp;arch</source>
        <translation>O&amp;tsing</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="96"/>
        <source>&amp;New</source>
        <translation>&amp;Uus</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="178"/>
        <source>&amp;Delete</source>
        <translation>K&amp;ustuta</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="355"/>
        <source>De&amp;lete All</source>
        <translation type="obsolete">&amp;Kustuta kõik</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="79"/>
        <source>Book&amp;marks</source>
        <translation>&amp;Järjehoidjad</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="148"/>
        <source>&amp;Print...</source>
        <translation>&amp;Trüki...</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="216"/>
        <source>E&amp;xit</source>
        <translation type="obsolete">&amp;Välju</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="289"/>
        <source>&amp;File</source>
        <translation>&amp;Fail</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="158"/>
        <source>&amp;Find...</source>
        <translation>Ot&amp;si...</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="296"/>
        <source>Find &amp;Next</source>
        <translation>Otsi &amp;järgmine</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="297"/>
        <source>Find &amp;Previous</source>
        <translation>Otsi &amp;eelmine</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="290"/>
        <source>&amp;Edit</source>
        <translation>&amp;Redigeerimine</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="298"/>
        <source>&amp;Add Bookmark</source>
        <translation>Lis&amp;a järjehoidja</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="183"/>
        <source>D&amp;elete All</source>
        <translation>&amp;Kustuta kõik</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="291"/>
        <source>&amp;Bookmarks</source>
        <translation>&amp;Järjehoidjad</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="287"/>
        <source>Scribus Online Help</source>
        <translation>Scribuse abi</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="461"/>
        <source>Searching is case unsensitive</source>
        <translation type="obsolete">Otsimine on tõstutundetu</translation>
    </message>
    <message>
        <location filename="../helpbrowser.cpp" line="265"/>
        <source>Sorry, no manual available! Please see: http://docs.scribus.net for updated docs
and www.scribus.net for downloads.</source>
        <translation type="obsolete">Vabandust, käsiraamatut pole!
Palun otsi saidilt http://docs.scribus.net värsket dokumentatsiooni
ja saidilt www.scribus.net allalaadimisvõimalusi.</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="377"/>
        <source>Find</source>
        <translation>Otsimine</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="377"/>
        <source>Search Term:</source>
        <translation>Otsingusõna:</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="409"/>
        <source>New Bookmark</source>
        <translation>Uus järjehoidja</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="409"/>
        <source>New Bookmark&apos;s Title:</source>
        <translation>Uue järjehoidja nimi:</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="137"/>
        <source>Scribus Help</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="53"/>
        <source>Searching is case insensitive</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="86"/>
        <source>1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="153"/>
        <source>&amp;Exit</source>
        <translation type="unfinished">&amp;Välju</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="163"/>
        <source>Find &amp;Next...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="168"/>
        <source>Find &amp;Previous...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/ui/helpbrowser.ui" line="173"/>
        <source>&amp;Add</source>
        <translation type="unfinished">Lis&amp;a</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="294"/>
        <source>&amp;Quit</source>
        <translation type="unfinished">&amp;Välju</translation>
    </message>
    <message>
        <location filename="../../scribus/helpbrowser.cpp" line="715"/>
        <source>&lt;h2&gt;&lt;p&gt;Sorry, no manual is installed!&lt;/p&gt;&lt;p&gt;Please see:&lt;/p&gt;&lt;ul&gt;&lt;li&gt;http://docs.scribus.net for updated documentation&lt;/li&gt;&lt;li&gt;http://www.scribus.net for downloads&lt;/li&gt;&lt;/ul&gt;&lt;/h2&gt;</source>
        <comment>HTML message for no documentation available to show</comment>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>HelpBrowser2</name>
    <message>
        <location filename="../ui/hb2.ui" line="30"/>
        <source>&amp;Contents</source>
        <translation type="obsolete">&amp;Sisukord</translation>
    </message>
    <message>
        <location filename="../ui/hb2.ui" line="49"/>
        <source>Se&amp;arch</source>
        <translation type="obsolete">O&amp;tsing</translation>
    </message>
    <message>
        <location filename="../ui/hb2.ui" line="64"/>
        <source>&amp;Search</source>
        <translation type="obsolete">Ot&amp;si</translation>
    </message>
    <message>
        <location filename="../ui/hb2.ui" line="77"/>
        <source>Book&amp;marks</source>
        <translation type="obsolete">&amp;Järjehoidjad</translation>
    </message>
</context>
<context>
    <name>HyAsk</name>
    <message>
        <location filename="../../scribus/hyask.cpp" line="48"/>
        <source>Possible Hyphenation</source>
        <translation>Võimalik poolitus</translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="68"/>
        <source>Accept</source>
        <translation>Nõus</translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="89"/>
        <source>Skip</source>
        <translation>Jäta vahele</translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="107"/>
        <source>Cancel</source>
        <translation>Loobu</translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="77"/>
        <source>Add to the
Exception List</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hyask.cpp" line="97"/>
        <source>Add to the
Ignore List</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>HySettings</name>
    <message>
        <location filename="../hysettings.cpp" line="20"/>
        <source>&amp;Hyphenation Suggestions</source>
        <translation type="obsolete">&amp;Poolitamisettepanekud</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="23"/>
        <source>Hyphenate Text Automatically &amp;During Typing</source>
        <translation type="obsolete">&amp;Teksti automaatne poolitamine kirjutamise ajal</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="40"/>
        <source>&amp;Language:</source>
        <translation type="obsolete">&amp;Keel:</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="46"/>
        <source>&amp;Smallest Word:</source>
        <translation type="obsolete">Lü&amp;him poolitatav sõna:</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="52"/>
        <source>Consecutive Hyphenations &amp;Allowed:</source>
        <translation type="obsolete">Poolitamisega lõppevaid ridu &amp;järjestikku:</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="56"/>
        <source>A dialog box showing all possible hyphens for each word will show up when you use the Extras, Hyphenate Text option.</source>
        <translation type="obsolete">Sisselülitamise korral avatakse menüükäsu Ekstra-&gt;Teksti poolitamine valimisel dialoog, kus näidatakse iga sõna võimalikke poolitusi.</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="57"/>
        <source>Enables automatic hyphenation of your text while typing.</source>
        <translation type="obsolete">Lülitab sisse teksti automaatse poolitamise kirjutamise ajal.</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="58"/>
        <source>Length of the smallest word to be hyphenated.</source>
        <translation type="obsolete">Väikseima sõna pikkus, mida veel poolitatakse.</translation>
    </message>
    <message>
        <location filename="../hysettings.cpp" line="59"/>
        <source>Maximum number of Hyphenations following each other.
A value of 0 means unlimited hyphenations.</source>
        <translation type="obsolete">Järjestikuste poolitamisega lõppevate ridade maksimaalne arv.
0 tähendab, et piirang puudub.</translation>
    </message>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="92"/>
        <source>Ignore List</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="121"/>
        <source>Add a new Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="133"/>
        <source>Edit Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/hysettings.cpp" line="133"/>
        <source>Exception List</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImageInfoDialog</name>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="23"/>
        <source>Image Info</source>
        <translation>Pildi info</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="30"/>
        <source>General Info</source>
        <translation>Üldine info</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="34"/>
        <source>Date / Time:</source>
        <translation>Kuupäev/kellaaeg:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="38"/>
        <source>Has Embedded Profile:</source>
        <translation>Põimitud profiil:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Yes</source>
        <translation type="obsolete">Jah</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No</source>
        <translation type="obsolete">Ei</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="46"/>
        <source>Profile Name:</source>
        <translation>Profiili nimi:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="50"/>
        <source>Has Embedded Paths:</source>
        <translation>Põimitud asukohad:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="58"/>
        <source>Has Layers:</source>
        <translation>Kihid:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="69"/>
        <source>EXIF Info</source>
        <translation>EXIF-info</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="84"/>
        <source>Artist:</source>
        <translation>Kunstnik:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="126"/>
        <source>Comment:</source>
        <translation>Kommentaar:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="127"/>
        <source>User Comment:</source>
        <translation>Kasutaja kommentaar:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="128"/>
        <source>Camera Model:</source>
        <translation>Kaamera mudel:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="129"/>
        <source>Camera Manufacturer:</source>
        <translation>Kaamera tootja:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="135"/>
        <source>Description:</source>
        <translation>Kirjeldus:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="136"/>
        <source>Copyright:</source>
        <translation>Autoriõigus:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="137"/>
        <source>Scanner Model:</source>
        <translation>Skänneri mudel:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="138"/>
        <source>Scanner Manufacturer:</source>
        <translation>Skänneri tootja:</translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="130"/>
        <source>Exposure time</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="131"/>
        <source>Aperture:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/imageinfodialog.cpp" line="132"/>
        <source>ISO equiv.:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImportAIPlugin</name>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="58"/>
        <source>Import AI...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="79"/>
        <source>Imports Illustrator Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="80"/>
        <source>Imports most Illustrator files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/aiimplugin/importaiplugin.cpp" line="162"/>
        <source>The file could not be imported</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImportDialog</name>
    <message>
        <location filename="../smstyleimport.cpp" line="30"/>
        <source>Choose Styles</source>
        <translation type="obsolete">Stiilide valik</translation>
    </message>
    <message>
        <location filename="../smstyleimport.cpp" line="35"/>
        <source>Available Styles</source>
        <translation type="obsolete">Saadaolevad stiilid</translation>
    </message>
    <message>
        <location filename="../smstyleimport.cpp" line="40"/>
        <source>Character Styles</source>
        <translation type="obsolete">Märgistiilid</translation>
    </message>
    <message>
        <location filename="../smstyleimport.cpp" line="49"/>
        <source>Paragraph Styles</source>
        <translation type="obsolete">Lõigustiilid</translation>
    </message>
    <message>
        <location filename="../smstyleimport.cpp" line="58"/>
        <source>Line Styles</source>
        <translation type="obsolete">Joone stiilid</translation>
    </message>
</context>
<context>
    <name>ImportPSPlugin</name>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="57"/>
        <source>Import &amp;EPS/PS...</source>
        <translation type="obsolete">Impordi &amp;EPS/PS...</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="78"/>
        <source>Imports EPS Files</source>
        <translation type="obsolete">Impordib EPS-faile</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="79"/>
        <source>Imports most EPS files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="obsolete">Impordib EPS-failid aktiivsesse dokumenti,
muutes nende vektorandmed Scribuse objektideks.</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="92"/>
        <source>PostScript</source>
        <translation type="obsolete">PostScript</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="105"/>
        <source>PDF</source>
        <translation type="obsolete">PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importpsplugin.cpp" line="57"/>
        <source>Import PostScript...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importpsplugin.cpp" line="78"/>
        <source>Imports PostScript Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/psimport/importpsplugin.cpp" line="79"/>
        <source>Imports most PostScript files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>ImportXfigPlugin</name>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="58"/>
        <source>Import Xfig...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="79"/>
        <source>Imports Xfig Files</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="80"/>
        <source>Imports most Xfig files into the current document,
converting their vector data into Scribus objects.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="128"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Kõik toetatud vormingud</translation>
    </message>
</context>
<context>
    <name>Imposition</name>
    <message>
        <location filename="../../scribus/plugins/imposition/imposition.cpp" line="72"/>
        <source>Portrait</source>
        <translation type="unfinished">Püstpaigutus</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/imposition.cpp" line="73"/>
        <source>Landscape</source>
        <translation type="unfinished">Rõhtpaigutus</translation>
    </message>
</context>
<context>
    <name>ImpositionBase</name>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="19"/>
        <source>Imposition</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="44"/>
        <source>Gri&amp;d</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="102"/>
        <source>Copies</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="157"/>
        <source>Do&amp;uble sided</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="160"/>
        <source>Alt+U</source>
        <translation type="unfinished">Alt+U</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="186"/>
        <source>Front side</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="218"/>
        <source>Back side</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="253"/>
        <source>&amp;Booklet</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="285"/>
        <source>Pages per sheet</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="296"/>
        <source>4</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="301"/>
        <source>8</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="306"/>
        <source>16</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="318"/>
        <source>Pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="325"/>
        <source>&lt;html&gt;&lt;head&gt;&lt;meta name=&quot;qrichtext&quot; content=&quot;1&quot; /&gt;&lt;style type=&quot;text/css&quot;&gt;
p, li { white-space: pre-wrap; }
&lt;/style&gt;&lt;/head&gt;&lt;body style=&quot; font-family:&apos;Sans Serif&apos;; font-size:9pt; font-weight:400; font-style:normal;&quot;&gt;
&lt;p style=&quot; margin-top:0px; margin-bottom:0px; margin-left:0px; margin-right:0px; -qt-block-indent:0; text-indent:0px;&quot;&gt;Separate pages with a comma, ranges with a hyphen, e.g. 1,4,9-11 to get pages 1,4,9,10,11.&lt;/p&gt;&lt;/body&gt;&lt;/html&gt;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="339"/>
        <source>Fold</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="349"/>
        <source>Front page from</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="376"/>
        <source>Double sided</source>
        <translation type="unfinished">Kaks lehekülge</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="387"/>
        <source>Back page from</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="415"/>
        <source>Destination page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="455"/>
        <source>Size</source>
        <translation type="unfinished">Suurus</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="487"/>
        <source>Orientation</source>
        <translation type="unfinished">Orientatsioon</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="519"/>
        <source>Width</source>
        <translation type="unfinished">Laius</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="564"/>
        <source>Height</source>
        <translation type="unfinished">Kõrgus</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="620"/>
        <source>Preview</source>
        <translation type="unfinished">Eelvaatlus</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="627"/>
        <source>Refresh preview</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="671"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;OK</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="674"/>
        <source>Alt+G</source>
        <translation type="unfinished">Alt+G</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="681"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Loobu</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionbase.ui" line="684"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
</context>
<context>
    <name>ImpositionPlugin</name>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionplugin.cpp" line="37"/>
        <source>&amp;Imposition...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionplugin.cpp" line="69"/>
        <source>Imposition dialog</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/imposition/impositionplugin.cpp" line="70"/>
        <source>Imposition on grids, booklets and folds</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>InsPage</name>
    <message>
        <location filename="../../scribus/inspage.cpp" line="30"/>
        <source>Insert Page</source>
        <translation>Lehekülje lisamine</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="63"/>
        <source>&amp;Insert</source>
        <translation>L&amp;isatakse</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="46"/>
        <source>Page(s)</source>
        <translation>lehekülg(e)</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="50"/>
        <source>before Page</source>
        <translation>enne lehekülge</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="51"/>
        <source>after Page</source>
        <translation>pärast lehekülge</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="52"/>
        <source>at End</source>
        <translation>lõppu</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="67"/>
        <source>Master Pages</source>
        <translation>Leheküljetoorikud</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal</source>
        <translation type="obsolete">Normaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="77"/>
        <source>&amp;Master Page:</source>
        <translation>&amp;Leheküljetoorik:</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="205"/>
        <source>Page Size</source>
        <translation>Lehekülje suurus</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="209"/>
        <source>&amp;Size:</source>
        <translation>&amp;Suurus:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom</source>
        <translation type="obsolete">Kohandatud</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="224"/>
        <source>Orie&amp;ntation:</source>
        <translation>Orie&amp;ntatsioon:</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="227"/>
        <source>Portrait</source>
        <translation>Püstpaigutus</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="228"/>
        <source>Landscape</source>
        <translation>Rõhtpaigutus</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="233"/>
        <source>&amp;Width:</source>
        <translation>&amp;Laius:</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="240"/>
        <source>&amp;Height:</source>
        <translation>&amp;Kõrgus:</translation>
    </message>
    <message>
        <location filename="../../scribus/inspage.cpp" line="245"/>
        <source>Move Objects with their Page</source>
        <translation>Objektide liigutamine koos leheküljega</translation>
    </message>
</context>
<context>
    <name>InsertAFrame</name>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="237"/>
        <source>Open</source>
        <translation>Avamine</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="115"/>
        <source>&lt;b&gt;Insert a text frame&lt;/b&gt;&lt;br/&gt;A text frame allows you to enter any text in a defined position with the formatting you choose. You may select a text file on the Options tab if you want to immediately import a document into the frame. Scribus supports a wide variety of importable format from plain text to OpenOffice.org.&lt;br/&gt;Your text may be edited and formatted on the page directly or in the simple Story Editor.</source>
        <translation type="obsolete">&lt;b&gt;Tekstikasti lisamine&lt;/b&gt;&lt;br/&gt;Tekstikast võimaldab sisestada teksti vajalikku kohta vajaliku vormindusega. Kui soovid kohe kasti dokumendi importida, vali tekstifail valikute kaardilt. Scribus toetab paljude vormingute importimist alates klaartekstist ja lõpetades OpenOffice.org-i dokumentidega.&lt;br/&gt;Sisestatud teksti saab redigeerida ja vormindada kas otse leheküljel või lihtsas looredaktoris.</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="119"/>
        <source>&lt;b&gt;Insert an image frame&lt;/b&gt;&lt;br/&gt;An image frame allows you to place an image onto your page. Various image effects may be applied or combined including transparencies, brightness, posterisation that allow retouching or the creation of interesting visual results. Image scaling and shaping is performed with the Properties Palette.</source>
        <translation type="obsolete">&lt;b&gt;Pildikasti lisamine&lt;/b&gt;&lt;br/&gt;Pildikast võimaldab sisestada leheküljele pildi. Piltidele saab ükshaaval või kombineeritult rakendada mitmesuguseid pildiefekte, sealhulgas läbipaistvus, toon ja muud sellised, mis võimaldavad pilti retušeerida või luua huvitavaid visuaalseid efekte. Piltide skaleerimine ja kuju muutmine käib omaduste paleti abil.</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="13"/>
        <source>Insert A Frame</source>
        <translation type="unfinished">Kasti lisamine</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="37"/>
        <source>T&amp;ype</source>
        <translation type="unfinished">Tüü&amp;p</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="75"/>
        <source>&amp;Text Frame</source>
        <translation type="unfinished">&amp;Tekstikast</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="73"/>
        <source>Alt+T</source>
        <translation type="obsolete">Alt+T</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="85"/>
        <source>&amp;Image Frame</source>
        <translation type="unfinished">P&amp;ildikast</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="83"/>
        <source>Alt+I</source>
        <translation type="obsolete">Alt+I</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="93"/>
        <source>T&amp;able</source>
        <translation type="obsolete">T&amp;abel</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="96"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="106"/>
        <source>Shape</source>
        <translation type="obsolete">Kujund</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="116"/>
        <source>Polygon</source>
        <translation type="obsolete">Hulknurk</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="122"/>
        <source>&amp;Location</source>
        <translation type="unfinished">Asuko&amp;ht</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="137"/>
        <source>Page Placement</source>
        <translation type="unfinished">Asetus lehekülgedel</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="195"/>
        <source>Selecting this will place the frame only on the current page.</source>
        <translation type="obsolete">Selle valimisel asetatakse kast ainult aktiivsele leheküljele.</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="152"/>
        <source>Current Page</source>
        <translation type="unfinished">Aktiivne lehekülg</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="162"/>
        <source>All Pages</source>
        <translation type="unfinished">Kõik leheküljed</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="205"/>
        <source>Selecting this will place frame on the selected range. </source>
        <translation type="obsolete">Selle valimisel asetatakse kast valitud lehekülgede vahemikku. </translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="208"/>
        <source>Range of Pages:</source>
        <translation type="obsolete">Lehekülgede vahemik:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="773"/>
        <source>...</source>
        <translation type="unfinished">...</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="225"/>
        <source>Position of Frame</source>
        <translation type="unfinished">Kasti asukoht</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="310"/>
        <source>Selecting this places the frame in the upper left of the page margins defined in your doc setup.</source>
        <translation type="obsolete">Selle valimisel asetatakse kast dokumendi seadistustes määratud veeriste ülemisse vasakusse nurka.</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="240"/>
        <source>Top Left of Margins</source>
        <translation type="unfinished">Veeriste ülemine vasak nurk</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="320"/>
        <source>Selecting this puts the frame on the top left with postion 0,0</source>
        <translation type="obsolete">Selle valimisel asetatakse kast üles vasakule asukohta 0,0</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="250"/>
        <source>Top Left of Page</source>
        <translation type="unfinished">Lehekülje ülemine vasak nurk</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="260"/>
        <source>Top Left of Bleed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="340"/>
        <source>Set the dimensions wished below in the X: Y: dialog below.</source>
        <translation type="obsolete">Määra allolevas dialoogis vajalikud X- ja Y-asukoht.</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="343"/>
        <source>Custom Position:</source>
        <translation type="obsolete">Kohandatud asukoht:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="316"/>
        <source>X:</source>
        <translation type="unfinished">X:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="309"/>
        <source>Y:</source>
        <translation type="unfinished">Y:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="379"/>
        <source>&amp;Size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="409"/>
        <source>Same as the Page Margins</source>
        <translation type="unfinished">Sama lehekülje veeristega</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="419"/>
        <source>Same as the Page</source>
        <translation type="unfinished">Sama leheküljega</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="429"/>
        <source>Same as the Bleed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="439"/>
        <source>Same as the Imported Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="539"/>
        <source>Custom Size:</source>
        <translation type="obsolete">Kohandatud suurus:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="488"/>
        <source>Height:</source>
        <translation type="unfinished">Kõrgus:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="495"/>
        <source>Width:</source>
        <translation type="unfinished">Laius:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="558"/>
        <source>&amp;Options</source>
        <translation type="unfinished">&amp;Valikud</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="759"/>
        <source>Source Image:</source>
        <translation type="unfinished">Lähtepilt:</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="914"/>
        <source>&amp;Select File...</source>
        <translation type="obsolete">&amp;Vali fail...</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="917"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="813"/>
        <source>There are no options for this type of frame</source>
        <translation type="unfinished">Seda tüüpi kasti jaoks pole valikuid</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="625"/>
        <source>Columns:</source>
        <translation type="unfinished">Veerud:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="611"/>
        <source>Gap:</source>
        <translation type="unfinished">Vahe:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="531"/>
        <source>Link Created Frames</source>
        <translation type="obsolete">Loodud kastid lingitakse</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="697"/>
        <source>Source Document:</source>
        <translation type="unfinished">Lähtedokument:</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="974"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;OK</translation>
    </message>
    <message>
        <location filename="../insertaframe.ui" line="990"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Loobu</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="172"/>
        <source>Range of Pages</source>
        <translation type="unfinished">Lehekülgede vahemik</translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="270"/>
        <source>Custom Position</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="449"/>
        <source>Custom Size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="133"/>
        <source>&lt;b&gt;Insert a text frame&lt;/b&gt;&lt;br/&gt;A text frame allows you to enter any text in a defined position with the formatting you choose. You may select a text file on the Options tab if you want to immediately import a document into the frame. Scribus supports a wide variety of importable formats from plain text to OpenOffice.org.&lt;br/&gt;Your text may be edited and formatted on the page directly or in the Story Editor.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.cpp" line="137"/>
        <source>&lt;b&gt;Insert an image frame&lt;/b&gt;&lt;br/&gt;An image frame allows you to place an image onto your page. Various image effects may be applied or combined including transparencies, brightness, and posterisation that allow retouching or the creation of interesting visual results. Image scaling and shaping is performed with the Properties Palette.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="72"/>
        <source>Insert one or more text frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="82"/>
        <source>Insert one or more image frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="134"/>
        <source>Place the new frames on the current page, on all pages or on a selected range</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="149"/>
        <source>Insert the frame on the current page only</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="159"/>
        <source>Insert one frame for each existing page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="169"/>
        <source>Insert frames on a range of pages</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="187"/>
        <source>Range of pages to insert frames on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="222"/>
        <source>Position the new frame in relation to the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="237"/>
        <source>Insert the frame at the top left of the page margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="247"/>
        <source>Insert the frame at the top left of the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="257"/>
        <source>Insert the frame at the top left of the page bleed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="267"/>
        <source>Insert the frame at a custom position on the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="323"/>
        <source>Top position of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="330"/>
        <source>Left position of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="406"/>
        <source>Insert the new frame with the same dimensions as the page margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="416"/>
        <source>Insert the new frame with the same dimensions as the page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="426"/>
        <source>Insert the new frame with the same dimensions as the bleed area outside the boundary of the page itself</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="436"/>
        <source>Insert the new frame with the same dimensions as the image that will be imported</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="446"/>
        <source>Insert the new frame with a custom size</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="502"/>
        <source>Width of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="509"/>
        <source>Height of the inserted frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="601"/>
        <source>Number of columns for the inserted text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="618"/>
        <source>Distance between the columns in the text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="649"/>
        <source>Link the inserted text frames together to form a chain of frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="652"/>
        <source>Link Inserted Frames</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="661"/>
        <source>Link the first inserted frame to a preexisting text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="664"/>
        <source>Link to Existing Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="680"/>
        <source>Name of existing text frame to link to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="704"/>
        <source>Source document to load into the text frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/insertaframe.ui" line="766"/>
        <source>Source image to load into the inserted image frame</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>InsertAFrameBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Insert A Frame</source>
        <translation type="obsolete">Kasti lisamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>T&amp;ype</source>
        <translation type="obsolete">Tüü&amp;p</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Text Frame</source>
        <translation type="obsolete">&amp;Tekstikast</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+T</source>
        <translation type="obsolete">Alt+T</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Image Frame</source>
        <translation type="obsolete">P&amp;ildikast</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+I</source>
        <translation type="obsolete">Alt+I</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>T&amp;able</source>
        <translation type="obsolete">T&amp;abel</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shape</source>
        <translation type="obsolete">Kujund</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Polygon</source>
        <translation type="obsolete">Hulknurk</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Location</source>
        <translation type="obsolete">Asuko&amp;ht</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Placement</source>
        <translation type="obsolete">Asetus lehekülgedel</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Current Page</source>
        <translation type="obsolete">Aktiivne lehekülg</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selecting this will place the frame only on the current page.</source>
        <translation type="obsolete">Selle valimisel asetatakse kast ainult aktiivsele leheküljele.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Range of Pages:</source>
        <translation type="obsolete">Lehekülgede vahemik:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selecting this will place frame on the selected range. </source>
        <translation type="obsolete">Selle valimisel asetatakse kast valitud lehekülgede vahemikku. </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Position of Frame</source>
        <translation type="obsolete">Kasti asukoht</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Top Left of Page</source>
        <translation type="obsolete">Lehekülje ülemine vasak nurk</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selecting this puts the frame on the top left with postion 0,0</source>
        <translation type="obsolete">Selle valimisel asetatakse kast üles vasakule asukohta 0,0</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Top Left of Margins</source>
        <translation type="obsolete">Veeriste ülemine vasak nurk</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Selecting this places the frame in the upper left of the page margins defined in your doc setup.</source>
        <translation type="obsolete">Selle valimisel asetatakse kast dokumendi seadistustes määratud veeriste ülemisse vasakusse nurka.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom Position:</source>
        <translation type="obsolete">Kohandatud asukoht:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set the dimensions wished below in the X: Y: dialog below.</source>
        <translation type="obsolete">Määra allolevas dialoogis vajalikud X- ja Y-asukoht.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>X:</source>
        <translation type="obsolete">X:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Y:</source>
        <translation type="obsolete">Y:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Size</source>
        <translation type="obsolete">&amp;Suurus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Same as the Page</source>
        <translation type="obsolete">Sama leheküljega</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Same as the Page Margins</source>
        <translation type="obsolete">Sama lehekülje veeristega</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom Size:</source>
        <translation type="obsolete">Kohandatud suurus:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Height:</source>
        <translation type="obsolete">Kõrgus:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Width:</source>
        <translation type="obsolete">Laius:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Options</source>
        <translation type="obsolete">&amp;Valikud</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Source Image:</source>
        <translation type="obsolete">Lähtepilt:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Select File...</source>
        <translation type="obsolete">&amp;Vali fail...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>There are no options for this type of frame</source>
        <translation type="obsolete">Seda tüüpi kasti jaoks pole valikuid</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Source Document:</source>
        <translation type="obsolete">Lähtedokument:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Columns:</source>
        <translation type="obsolete">Veerud:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Gap:</source>
        <translation type="obsolete">Vahe:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;OK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Loobu</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Link Created Frames</source>
        <translation type="obsolete">Loodud kastid lingitakse</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>All Pages</source>
        <translation type="obsolete">Kõik leheküljed</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>...</source>
        <translation type="obsolete">...</translation>
    </message>
</context>
<context>
    <name>InsertTable</name>
    <message>
        <location filename="../../scribus/insertTable.cpp" line="15"/>
        <source>Insert Table</source>
        <translation>Tabeli lisamine</translation>
    </message>
    <message>
        <location filename="../../scribus/insertTable.cpp" line="28"/>
        <source>Number of rows:</source>
        <translation>Ridade arv:</translation>
    </message>
    <message>
        <location filename="../../scribus/insertTable.cpp" line="29"/>
        <source>Number of columns:</source>
        <translation>Veergude arv:</translation>
    </message>
</context>
<context>
    <name>JavaDocs</name>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="27"/>
        <source>Edit JavaScripts</source>
        <translation>JavaScriptide redigeerimine</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="46"/>
        <source>&amp;Edit...</source>
        <translation>&amp;Redigeeri...</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="49"/>
        <source>&amp;Add...</source>
        <translation>Lis&amp;a...</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="52"/>
        <source>&amp;Delete</source>
        <translation>K&amp;ustuta</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="57"/>
        <source>&amp;Close</source>
        <translation>S&amp;ulge</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="71"/>
        <source>Adds a new Script, predefines a function with the same name. If you want to use this script as an &quot;Open Action&quot; script be sure not to change the name of the function.</source>
        <translation>Lisab uue skripti, määrates samas kindlaks samanimelise funktsiooni. Kui soovid seda skripti kasuada avamistoimingu (Open Action) skriptina, ära kindlasti funktsiooni nime muuda.</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="77"/>
        <source>&amp;New Script:</source>
        <translation>&amp;Uus skript:</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="78"/>
        <source>New Script</source>
        <translation>Uus skript</translation>
    </message>
    <message>
        <location filename="../../scribus/javadocs.cpp" line="123"/>
        <source>Do you really want to delete this script?</source>
        <translation>Kas tõesti see skript kustutada?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Yes</source>
        <translation type="obsolete">&amp;Jah</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;No</source>
        <translation type="obsolete">&amp;Ei</translation>
    </message>
</context>
<context>
    <name>KeyManager</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Action</source>
        <translation type="obsolete">Toiming</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Current Key</source>
        <translation type="obsolete">Aktiivne klahv</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select a Key for this Action</source>
        <translation type="obsolete">Toimingu klahvi valimine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;No Key</source>
        <translation type="obsolete">&amp;Klahv puudub</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;User Defined Key</source>
        <translation type="obsolete">Kas&amp;utaja määratud klahv</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>ALT+SHIFT+T</source>
        <translation type="obsolete">ALT+SHIFT+T</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set &amp;Key</source>
        <translation type="obsolete">&amp;Määra klahv</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Loadable Shortcut Sets</source>
        <translation type="obsolete">Laaditavad kiirklahvikomplektid</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Load</source>
        <translation type="obsolete">&amp;Laadi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Import...</source>
        <translation type="obsolete">&amp;Impordi...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Export...</source>
        <translation type="obsolete">&amp;Ekspordi...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Reset</source>
        <translation type="obsolete">Lä&amp;htesta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Keyboard shortcut sets available to load</source>
        <translation type="obsolete">Saadaolevad kiirklahvikomplektid</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Load the selected shortcut set</source>
        <translation type="obsolete">Laadi valitud kiirklahvikomplekt</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Import a shortcut set into the current configuration</source>
        <translation type="obsolete">Impordib kiirklahvikomplekti praegusse seadistusse</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export the current shortcuts into an importable file</source>
        <translation type="obsolete">Ekspordib aktiivsed kiirklahvid imporditavasse faili</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Reload the default Scribus shortcuts</source>
        <translation type="obsolete">Laadib uuesti Scribuse vaikimisi kiirklahvid</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt</source>
        <translation type="obsolete">Alt</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ctrl</source>
        <translation type="obsolete">Ctrl</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shift</source>
        <translation type="obsolete">Shift</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Meta</source>
        <translation type="obsolete">Meta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Meta+</source>
        <translation type="obsolete">Meta+</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Shift+</source>
        <translation type="obsolete">Shift+</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+</source>
        <translation type="obsolete">Alt+</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ctrl+</source>
        <translation type="obsolete">Ctrl+</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This key sequence is already in use</source>
        <translation type="obsolete">See klahvikombinatsioon on juba kasutusel</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Key Set XML Files (*.ksxml)</source>
        <translation type="obsolete">Klahvikomplektide XML-failid (*.ksxml)</translation>
    </message>
</context>
<context>
    <name>LatexEditor</name>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="32"/>
        <source>Enter Code:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="44"/>
        <source>Update</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="51"/>
        <source>Revert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="130"/>
        <source>Program Messages:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="181"/>
        <source>Status: Unknown</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="165"/>
        <source>Kill Program</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="73"/>
        <source>Options</source>
        <translation type="unfinished">Valikud</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="81"/>
        <source>Resolution:</source>
        <translation type="unfinished">Lahutus:</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="88"/>
        <source>Automatic</source>
        <translation type="unfinished">Automaatne</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="91"/>
        <source> DPI</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="104"/>
        <source>Program:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="116"/>
        <source>Use Preamble</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="330"/>
        <source>Status: </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="334"/>
        <source>Error</source>
        <translation type="unfinished">Viga</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="336"/>
        <source>Finished</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="339"/>
        <source>Running</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="518"/>
        <source>No item selected!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="520"/>
        <source>Insert symbol</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="13"/>
        <source>Editor</source>
        <translation type="unfinished">Redaktor</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="130"/>
        <source>Information</source>
        <translation type="unfinished">Info</translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="124"/>
        <source>An editor for this frame is already running!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="150"/>
        <source>Editor running!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="132"/>
        <source>Please specify an editor in the preferences!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="167"/>
        <source>Could not create a temporary file to run the external editor!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="222"/>
        <source>Run External Editor...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="207"/>
        <source>Running the editor failed with exitcode %d!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.cpp" line="225"/>
        <source>Running the editor &quot;%1&quot; failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/latexeditor.ui" line="155"/>
        <source>Run external editor...</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LayerPalette</name>
    <message>
        <location filename="../../scribus/layers.cpp" line="290"/>
        <source>Delete Layer</source>
        <translation>Kihi kustutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="291"/>
        <source>Do you want to delete all objects on this layer too?</source>
        <translation>Kas kustutada ka kõik selle kihi objektid?</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="567"/>
        <source>Layers</source>
        <translation>Kihid</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="588"/>
        <source>Name</source>
        <translation>Nimi</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="596"/>
        <source>Add a new layer</source>
        <translation>Lisa uus kiht</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="598"/>
        <source>Delete layer</source>
        <translation>Kustuta kiht</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="599"/>
        <source>Raise layer</source>
        <translation>Too kiht ettepoole</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="600"/>
        <source>Lower layer</source>
        <translation>Vii kiht tahapoole</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="586"/>
        <source>Opacity:</source>
        <translation>Läbipaistmatus:</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="587"/>
        <source> %</source>
        <translation>(sp)%</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="568"/>
        <source>Blend Mode:</source>
        <translation>Ühtesulamise režiim:</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="570"/>
        <source>Normal</source>
        <translation>Normaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="571"/>
        <source>Darken</source>
        <translation>Tumendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="572"/>
        <source>Lighten</source>
        <translation>Helendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="573"/>
        <source>Multiply</source>
        <translation>Korrutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="574"/>
        <source>Screen</source>
        <translation>Ekraan</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="575"/>
        <source>Overlay</source>
        <translation>Ülekatmine</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="576"/>
        <source>Hard Light</source>
        <translation>Külm valgus</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="577"/>
        <source>Soft Light</source>
        <translation>Soe valgus</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="578"/>
        <source>Difference</source>
        <translation>Lahutamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Exlusion</source>
        <translation type="obsolete">Väljajätmine</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="580"/>
        <source>Color Dodge</source>
        <translation>Värvi helestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="581"/>
        <source>Color Burn</source>
        <translation>Värvi tumestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="579"/>
        <source>Exclusion</source>
        <translation>Väljajätmine</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="582"/>
        <source>Hue</source>
        <translation>Toon</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="583"/>
        <source>Saturation</source>
        <translation>Küllastus</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="584"/>
        <source>Color</source>
        <translation>Värv</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="585"/>
        <source>Luminosity</source>
        <translation>Valgsus</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="603"/>
        <source>Color of the Layer Indicator - Each layer has a color assigned to display on the canvas when layer indicators are enabled. You can double click to edit the color. </source>
        <translation type="unfinished">Kihi indikaatori värv - igale kihile omistatakse värv, kui kihi indikaatorid on sisse lülitatud. Topeltklõpsuga saab värvi redigeerida. </translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="604"/>
        <source>Make Layer Visible - Uncheck to hide the layer from the display </source>
        <translation type="unfinished">Kiht on nähtaval - märke eemaldamisel ei ole kihti näha </translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="605"/>
        <source>Print Layer - Uncheck to disable printing. </source>
        <translation type="unfinished">Kihi trükkimine - märke eemaldamisel kihti ei trükita. </translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="606"/>
        <source>Lock or Unlock Layer - Unchecked is unlocked </source>
        <translation type="unfinished">Kihi lukustamine - märke eemaldamisel ei ole kiht lukustatud </translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="607"/>
        <source>Text flows around objects in lower Layers - Enabling this forces text frames to flow around other objects, even in layers below</source>
        <translation type="unfinished">Tekst kulgeb ümber alumiste kihtide objektide - märkimisel kulgeb tekstikastide tekst ümber teiste objektide, isegi kui need asuvad alumistel kihtidel</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="608"/>
        <source>Outline Mode - Toggles the &apos;wireframe&apos; display of objects to speed the display of very complex objects.</source>
        <translation type="unfinished">Kontuurirežiim - lülitab punktiirjoone näitamist objektide ümber, mis kiirendab väga keeruliste objektide kuvamist.</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="609"/>
        <source>Name of the Layer - Double clicking on the name of a layer enabled editing</source>
        <translation type="unfinished">Kihi nimi - topeltklõpsuga kihi nimel saab seda redigeerida</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="597"/>
        <source>Duplicates the current layer</source>
        <translation>Kloonib aktiivse kihi</translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="601"/>
        <source>Selects the Blendmode, works only in PDF 1.4</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/layers.cpp" line="602"/>
        <source>Layer Transparency, works only in PDF 1.4 and SVG</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LegacyMode</name>
    <message>
        <location filename="../canvasmode_legacy.cpp" line="4973"/>
        <source>All Files (*)</source>
        <translation type="obsolete">Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_legacy.cpp" line="5023"/>
        <source>Open</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/canvasmode_legacy.cpp" line="4993"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Kõik toetatud vormingud</translation>
    </message>
</context>
<context>
    <name>LensDialogBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="13"/>
        <source>Optical Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="98"/>
        <source>+</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="108"/>
        <source>-</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="126"/>
        <source>Lens Parameters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="198"/>
        <source>Radius:</source>
        <translation type="obsolete">Raadius:</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="55"/>
        <source>Add a new lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="58"/>
        <source>&amp;Add Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="65"/>
        <source>Remove selected lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="68"/>
        <source>&amp;Remove Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="95"/>
        <source>Zoom In</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="105"/>
        <source>Zoom Out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="138"/>
        <source>&amp;X Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="148"/>
        <source>Horizontal position of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="161"/>
        <source>&amp;Y Pos:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="171"/>
        <source>Vertical position of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="184"/>
        <source>The selected lens acts like a magnification lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="187"/>
        <source>&amp;Magnification Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="197"/>
        <source>The selected lens acts like a fish eye lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="200"/>
        <source>&amp;Fish Eye Lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="207"/>
        <source>Ra&amp;dius:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="217"/>
        <source>Radius of the lens</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="230"/>
        <source>&amp;Strength:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lensdialogbase.ui" line="240"/>
        <source>Strength of the lens</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LensEffectsPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="66"/>
        <source>Lens Effects...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="70"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="90"/>
        <source>Lens Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/lenseffects/lenseffects.cpp" line="91"/>
        <source>Apply fancy lens effects</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LineFormate</name>
    <message>
        <location filename="../lineformats.cpp" line="33"/>
        <source>Edit Line Styles</source>
        <translation type="obsolete">Joonestiilide redigeerimine</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="49"/>
        <source>&amp;Import</source>
        <translation type="obsolete">&amp;Impordi</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="52"/>
        <source>&amp;New</source>
        <translation type="obsolete">&amp;Uus</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="55"/>
        <source>&amp;Edit</source>
        <translation type="obsolete">&amp;Redigeeri</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="60"/>
        <source>D&amp;uplicate</source>
        <translation type="obsolete">&amp;Klooni</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="64"/>
        <source>&amp;Delete</source>
        <translation type="obsolete">K&amp;ustuta</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="68"/>
        <source>&amp;Save</source>
        <translation type="obsolete">&amp;Salvesta</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="125"/>
        <source>Copy of %1</source>
        <translation type="obsolete">%1 koopia</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="154"/>
        <source>New Style</source>
        <translation type="obsolete">Uus stiil</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="194"/>
        <source>Do you really want to delete this style?</source>
        <translation type="obsolete">Kas tõesti see stiil kustutada?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Yes</source>
        <translation type="obsolete">&amp;Jah</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;No</source>
        <translation type="obsolete">&amp;Ei</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="216"/>
        <source>Open</source>
        <translation type="obsolete">Avamine</translation>
    </message>
    <message>
        <location filename="../lineformats.cpp" line="216"/>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;All Files (*)</source>
        <translation type="obsolete">Dokumendid (*.sla *.sla.gz *.scd *.scd.gz);;Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Documents (*.sla *.scd);;All Files (*)</source>
        <translation type="obsolete">Dokumendid (*.sla *.scd);;Kõik failid (*)</translation>
    </message>
</context>
<context>
    <name>LineStyleW</name>
    <message>
        <location filename="../smlinestylew.ui" line="184"/>
        <source>%</source>
        <translation type="obsolete">%</translation>
    </message>
    <message>
        <location filename="../smlinestylew.ui" line="208"/>
        <source>Line Width:</source>
        <translation type="obsolete">Joone jämedus:</translation>
    </message>
</context>
<context>
    <name>LineStyleWBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>LineStyleWBase</source>
        <translation type="obsolete">LineStyleWBase</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>%</source>
        <translation type="obsolete">%</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line Width:</source>
        <translation type="obsolete">Joone jämedus:</translation>
    </message>
</context>
<context>
    <name>LineStyleWidget</name>
    <message>
        <location filename="../smlinestyle.cpp" line="180"/>
        <source> pt</source>
        <translation type="obsolete"> pt</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="52"/>
        <source>Flat Cap</source>
        <translation type="obsolete">Lameots</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="53"/>
        <source>Square Cap</source>
        <translation type="obsolete">Ruutots</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="54"/>
        <source>Round Cap</source>
        <translation type="obsolete">Ümarots</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="56"/>
        <source>Miter Join</source>
        <translation type="obsolete">Nurkühendus</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="57"/>
        <source>Bevel Join</source>
        <translation type="obsolete">Längühendus</translation>
    </message>
    <message>
        <location filename="../smlinestyle.cpp" line="58"/>
        <source>Round Join</source>
        <translation type="obsolete">Ümarühendus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Solid Line</source>
        <translation type="obsolete">Ühtlane joon</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dashed Line</source>
        <translation type="obsolete">Punktiirjoon</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dotted Line</source>
        <translation type="obsolete">Punktjoon</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dash Dot Line</source>
        <translation type="obsolete">Kriipspunktjoon</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dash Dot Dot Line</source>
        <translation type="obsolete">Kriipspunktpunktjoon</translation>
    </message>
</context>
<context>
    <name>LoadSavePlugin</name>
    <message>
        <location filename="../../scribus/loadsaveplugin.cpp" line="81"/>
        <source>All Files (*)</source>
        <translation>Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/loadsaveplugin.cpp" line="80"/>
        <source>No File Loader Plugins Found</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>LoremManager</name>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="152"/>
        <source>Select Lorem Ipsum</source>
        <translation>Lorem Ipsumi valik</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="220"/>
        <source>Author:</source>
        <translation>Autor:</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="222"/>
        <source>Get More:</source>
        <translation>Allikas:</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="224"/>
        <source>XML File:</source>
        <translation>XML-fail:</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="264"/>
        <source>Lorem Ipsum</source>
        <translation>Lorem Ipsum</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="265"/>
        <source>Paragraphs:</source>
        <translation>Lõigud:</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="268"/>
        <source>Alt+O</source>
        <translation>Alt+O</translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="270"/>
        <source>Alt+C</source>
        <translation></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="271"/>
        <source>Standard Lorem Ipsum</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="266"/>
        <source>Random Paragraphs</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="272"/>
        <source>Number of paragraphs of selected sample text to insert</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/loremipsum.cpp" line="273"/>
        <source>List of languages available to insert sample text in</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MarginDialog</name>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="31"/>
        <source>Manage Page Properties</source>
        <translation>Lehekülje omaduste haldamine</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="39"/>
        <source>Page Size</source>
        <translation>Lehekülje suurus</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="44"/>
        <source>&amp;Size:</source>
        <translation>&amp;Suurus:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom</source>
        <translation type="obsolete">Kohandatud</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="60"/>
        <source>Orie&amp;ntation:</source>
        <translation>Orie&amp;ntatsioon:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="63"/>
        <source>Portrait</source>
        <translation>Püstpaigutus</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="64"/>
        <source>Landscape</source>
        <translation>Rõhtpaigutus</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="71"/>
        <source>&amp;Width:</source>
        <translation>&amp;Laius:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="78"/>
        <source>&amp;Height:</source>
        <translation>&amp;Kõrgus:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="83"/>
        <source>Move Objects with their Page</source>
        <translation>Objektide liigutamine koos leheküljega</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="89"/>
        <source>Type:</source>
        <translation>Tüüp:</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="109"/>
        <source>Margin Guides</source>
        <translation>Veerisejooned</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="116"/>
        <source>Other Settings</source>
        <translation>Muud seadistused</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="121"/>
        <source>Master Page:</source>
        <translation>Leheküljetoorik:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal</source>
        <translation type="obsolete">Normaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="175"/>
        <source>Size of the inserted pages, either a standard or custom size.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="176"/>
        <source>Orientation of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="177"/>
        <source>Width of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="178"/>
        <source>Height of the page(s) to be inserted</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/margindialog.cpp" line="179"/>
        <source>When inserting a new page between others, move objects with their current pages. This is the default action.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MarginWidget</name>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="33"/>
        <source>Preset Layouts:</source>
        <translation>Valmispaigutused:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="43"/>
        <source>&amp;Bottom:</source>
        <translation>&amp;All:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="45"/>
        <source>&amp;Top:</source>
        <translation>Ü&amp;lal:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="212"/>
        <source>&amp;Right:</source>
        <translation>&amp;Paremal:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="211"/>
        <source>&amp;Left:</source>
        <translation>&amp;Vasakul:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Apply margin settings to all pages</source>
        <translation type="obsolete">Veeriseseadistusi rakendatakse kõigile lehekülgedele</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="90"/>
        <source>Apply the margin changes to all existing pages in the document</source>
        <translation>Veeriste muudatused rakendatakse kõigile dokumendi olemasolevatele lehekülgedele</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="102"/>
        <source>Printer Margins...</source>
        <translation>Printeri veerised...</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="104"/>
        <source>Import the margins for the selected page size from the available printers.</source>
        <translation>Veeriste import valitud leheküljesuurusele saadaolevatelt printeritelt</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="156"/>
        <source>Distance between the top margin guide and the edge of the page</source>
        <translation>Vahemaa ülemise veerisejoone ja lehekülje serva vahel</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="157"/>
        <source>Distance between the bottom margin guide and the edge of the page</source>
        <translation>Vahemaa alumise veerisejoone ja lehekülje serva vahel</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance between the left margin guide and the edge of the page. If Facing Pages is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="obsolete">Vahemaa vasaku veerisejoone ja lehekülje serva vahel. Kui valitud on kaks lehekülge kõrvuti, saab seda veeriste vahet kasutada köitmiseks vajalike veeriste korrigeerimiseks.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distance between the right margin guide and the edge of the page. If Facing Pages is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="obsolete">Vahemaa parema veerisejoone ja lehekülje serva vahel. Kui valitud on kaks lehekülge kõrvuti, saab seda veeriste vahet kasutada köitmiseks vajalike veeriste korrigeerimiseks.</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="211"/>
        <source>&amp;Inside:</source>
        <translation>S&amp;isemine:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="212"/>
        <source>O&amp;utside:</source>
        <translation>Vä&amp;limine:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="79"/>
        <source>Apply settings to:</source>
        <translation>Seadistuste rakendamine:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="82"/>
        <source>All Document Pages</source>
        <translation>Dokumendi kõigile lehekülgedele</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="86"/>
        <source>All Master Pages</source>
        <translation>Kõigile leheküljetoorikutele</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="91"/>
        <source>Apply the margin changes to all existing master pages in the document</source>
        <translation>Veeriste muudatused rakendatakse dokumendi kõigile leheküljetoorikutele</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="108"/>
        <source>Margin Guides</source>
        <translation type="unfinished">Veerisejooned</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="126"/>
        <source>Top:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="131"/>
        <source>Bottom:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="143"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="unfinished">Lõikevaru füüsilise lehekülje ülaservas</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="144"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="unfinished">Lõikevaru füüsilise lehekülje allservas</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="145"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="unfinished">Lõikevaru füüsilise lehekülje vasakus servas</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="146"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="unfinished">Lõikevaru füüsilise lehekülje paremas servas</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="152"/>
        <source>Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="217"/>
        <source>Inside:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="218"/>
        <source>Outside:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="222"/>
        <source>Left:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="223"/>
        <source>Right:</source>
        <translation type="unfinished">Paremal:</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="158"/>
        <source>Distance between the left margin guide and the edge of the page. If a double-sided, 3 or 4-fold layout is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="159"/>
        <source>Distance between the right margin guide and the edge of the page. If a double-sided, 3 or 4-fold layout is selected, this margin space can be used to achieve the correct margins for binding</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MasterPagesPalette</name>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="39"/>
        <source>Edit Master Pages</source>
        <translation>Leheküljetoorikute redigeerimine</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="79"/>
        <source>Duplicate the selected master page</source>
        <translation>Klooni valitud leheküljetoorik</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="80"/>
        <source>Delete the selected master page</source>
        <translation>Kustuta valitud leheküljetoorik</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="81"/>
        <source>Add a new master page</source>
        <translation>Lisa uus leheküljetoorik</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="82"/>
        <source>Import master pages from another document</source>
        <translation>Impordi leheküljetoorikuid mõnest muust dokumendist</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="116"/>
        <source>Do you really want to delete this master page?</source>
        <translation>Kas tõesti kustutada see leheküljetoorik?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Yes</source>
        <translation type="obsolete">&amp;Jah</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;No</source>
        <translation type="obsolete">&amp;Ei</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="143"/>
        <source>&amp;Name:</source>
        <translation>&amp;Nimi:</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="143"/>
        <source>New Master Page</source>
        <translation>Uus leheküljetoorik</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Copy of %1</source>
        <translation type="obsolete">%1 koopia</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="258"/>
        <source>Name:</source>
        <translation>Nimi:</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="258"/>
        <source>New MasterPage</source>
        <translation>Uus leheküljetoorik</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="258"/>
        <source>New Master Page %1</source>
        <translation>Uus leheküljetoorik %1</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="325"/>
        <source>Copy #%1 of </source>
        <translation>Koopia nr. %1 toorikust </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal</source>
        <translation type="obsolete">Normaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="415"/>
        <source>Unable to Rename Master Page</source>
        <translation>Leheküljetooriku ümbernimetamine ebaõnnestus</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="415"/>
        <source>The Normal page is not allowed to be renamed.</source>
        <translation>Normaalset lehekülge ei saa ümber nimetada.</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="419"/>
        <source>Rename Master Page</source>
        <translation>Leheküljetooriku ümbernimetamine</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="419"/>
        <source>New Name:</source>
        <translation>Uus nimi:</translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="141"/>
        <source>Copy #%1 of %2</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/masterpagepalette.cpp" line="112"/>
        <source>This master page is used at least once in the document.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Mdup</name>
    <message>
        <location filename="../mdup.cpp" line="29"/>
        <source>Multiple Duplicate</source>
        <translation type="obsolete">Mitmekordne kloonimine</translation>
    </message>
    <message>
        <location filename="../mdup.cpp" line="48"/>
        <source>&amp;Number of Copies:</source>
        <translation type="obsolete">Koo&amp;piate arv:</translation>
    </message>
    <message>
        <location filename="../mdup.cpp" line="50"/>
        <source>&amp;Horizontal Shift:</source>
        <translation type="obsolete">Ni&amp;he rõhtsuunas:</translation>
    </message>
    <message>
        <location filename="../mdup.cpp" line="52"/>
        <source>&amp;Vertical Shift:</source>
        <translation type="obsolete">&amp;Nihe püstsuunas:</translation>
    </message>
</context>
<context encoding="UTF-8">
    <name>Measurements</name>
    <message>
        <location filename="../measurements.cpp" line="49"/>
        <source>pt</source>
        <translation type="obsolete">pt</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="127"/>
        <source>Distances</source>
        <translation type="obsolete">Mõõtmine</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="129"/>
        <source>X1:</source>
        <translation type="obsolete">X1:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="130"/>
        <source>Y1:</source>
        <translation type="obsolete">Y1:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="131"/>
        <source>X2:</source>
        <translation type="obsolete">X2:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="132"/>
        <source>Y2:</source>
        <translation type="obsolete">Y2:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="133"/>
        <source>DX:</source>
        <translation type="obsolete">DX:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="134"/>
        <source>DY:</source>
        <translation type="obsolete">DY:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="135"/>
        <source>Angle:</source>
        <translation type="obsolete">Nurk:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurements.cpp" line="136"/>
        <source>Length:</source>
        <translation type="obsolete">Pikkus:</translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/measurements.cpp" line="51"/>
        <source> °</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MeasurementsBase</name>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="13"/>
        <source>Distances</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="19"/>
        <source>X1:</source>
        <translation type="unfinished">X1:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="145"/>
        <source>10000.0000</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="36"/>
        <source>Y1:</source>
        <translation type="unfinished">Y1:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="53"/>
        <source>X2:</source>
        <translation type="unfinished">X2:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="70"/>
        <source>Y2:</source>
        <translation type="unfinished">Y2:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="87"/>
        <source>Length:</source>
        <translation type="unfinished">Pikkus:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="104"/>
        <source>DX:</source>
        <translation type="unfinished">DX:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="121"/>
        <source>DY:</source>
        <translation type="unfinished">DY:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="138"/>
        <source>Angle:</source>
        <translation type="unfinished">Nurk:</translation>
    </message>
    <message>
        <location filename="../../scribus/measurementsbase.ui" line="155"/>
        <source>Unit:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MergeDoc</name>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="37"/>
        <source>Import Master Page</source>
        <translation>Leheküljetooriku import</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="37"/>
        <source>Import Page(s)</source>
        <translation>Lehekülgede import</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="48"/>
        <source>&amp;From Document:</source>
        <translation>&amp;Dokumendist:</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="52"/>
        <source>Chan&amp;ge...</source>
        <translation type="obsolete">&amp;Muuda...</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="55"/>
        <source>&amp;Import Page(s):</source>
        <translation>&amp;Imporditakse leheküljed:</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="59"/>
        <source>&amp;Import Master Page</source>
        <translation>&amp;Imporditakse leheküljetoorik</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="72"/>
        <source>Insert a comma separated list of tokens import where a token can be * for all the pages, 1-5 for a range of pages or a single page number.</source>
        <translation>Sisesta komadega eradatud arvud või märgid: * tähistab kõiki lehekülgi, 1-5 lehekülgede vahemikku, konkreetsed leheküljenumbrid vastavaid lehekülgi.</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="75"/>
        <source> from 0</source>
        <translation> 0 leheküljest</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="78"/>
        <source>Create Page(s)</source>
        <translation>Leheküljed luuakse</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="82"/>
        <source>Before Page</source>
        <translation>enne lehekülge</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="83"/>
        <source>After Page</source>
        <translation>pärast lehekülge</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="84"/>
        <source>At End</source>
        <translation>lõppu</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="101"/>
        <source>&amp;Import</source>
        <translation>&amp;Impordi</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="135"/>
        <source>Open</source>
        <translation>Avamine</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="135"/>
        <source>Documents (*.sla *.sla.gz *.scd *.scd.gz);;All Files (*)</source>
        <translation>Dokumendid (*.sla *.sla.gz *.scd *.scd.gz);;Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Documents (*.sla *.scd);;All Files (*)</source>
        <translation type="obsolete">Dokumendid (*.sla *.scd);;Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="190"/>
        <source> from %1</source>
        <translation> %1 leheküljest</translation>
    </message>
    <message>
        <location filename="../../scribus/mergedoc.cpp" line="52"/>
        <source>&amp;Select...</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MeshDistortionDialog</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="44"/>
        <source>+</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="54"/>
        <source>-</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="13"/>
        <source>Mesh Distortion</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="27"/>
        <source>Drag the red handles with the mouse to distort the mesh</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="41"/>
        <source>Zoom In</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="51"/>
        <source>Zoom Out</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="82"/>
        <source>Resets the selected handles to their initial position.
If no handle is selected all handles will be reset.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortiondialog.ui" line="86"/>
        <source>&amp;Reset</source>
        <translation type="unfinished">Lä&amp;htesta</translation>
    </message>
</context>
<context>
    <name>MeshDistortionPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="69"/>
        <source>Mesh Distortion...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="73"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/meshdistortion/meshdistortion.cpp" line="95"/>
        <source>Mesh Distortion of Polygons</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MissingFont</name>
    <message>
        <location filename="../../scribus/missing.cpp" line="309"/>
        <source>Missing Font</source>
        <translation>Puuduv font</translation>
    </message>
    <message>
        <location filename="../../scribus/missing.cpp" line="317"/>
        <source>The Font %1 is not installed.</source>
        <translation>Font %1 ei ole paigaldatud.</translation>
    </message>
    <message>
        <location filename="../../scribus/missing.cpp" line="322"/>
        <source>Use</source>
        <translation>Font</translation>
    </message>
    <message>
        <location filename="../../scribus/missing.cpp" line="336"/>
        <source>instead</source>
        <translation>asendab fondi</translation>
    </message>
</context>
<context>
    <name>ModeToolBar</name>
    <message>
        <location filename="../../scribus/ui/modetoolbar.cpp" line="39"/>
        <source>Tools</source>
        <translation>Tööriistad</translation>
    </message>
    <message>
        <location filename="../../scribus/ui/modetoolbar.cpp" line="121"/>
        <source>Properties...</source>
        <translation>Omadused...</translation>
    </message>
</context>
<context>
    <name>MovePages</name>
    <message>
        <location filename="../../scribus/movepage.cpp" line="28"/>
        <source>Move Pages</source>
        <translation>Lehekülgede liigutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="37"/>
        <source>Copy Page</source>
        <translation>Lehekülje kopeerimine</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="37"/>
        <source>Move Page(s)</source>
        <translation>Lehekülgede liigutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="48"/>
        <source>To:</source>
        <translation>leheküljele:</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="58"/>
        <source>Number of copies:</source>
        <translation>Koopiate arv:</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="68"/>
        <source>Before Page</source>
        <translation>Enne lehekülge</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="69"/>
        <source>After Page</source>
        <translation>Pärast lehekülge</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="70"/>
        <source>At End</source>
        <translation>Lõppu</translation>
    </message>
    <message>
        <location filename="../../scribus/movepage.cpp" line="78"/>
        <source>Move Page(s):</source>
        <translation>Lehekülgede liigutamine:</translation>
    </message>
</context>
<context>
    <name>MultiLine</name>
    <message>
        <location filename="../multiline.cpp" line="32"/>
        <source>Edit Style</source>
        <translation type="obsolete">Stiili redigeerimine</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="86"/>
        <source>Flat Cap</source>
        <translation type="obsolete">Lameots</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="87"/>
        <source>Square Cap</source>
        <translation type="obsolete">Ruutots</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="88"/>
        <source>Round Cap</source>
        <translation type="obsolete">Ümarots</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="92"/>
        <source>Miter Join</source>
        <translation type="obsolete">Nurkühendus</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="93"/>
        <source>Bevel Join</source>
        <translation type="obsolete">Längühendus</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="94"/>
        <source>Round Join</source>
        <translation type="obsolete">Ümarühendus</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="100"/>
        <source>Line Width:</source>
        <translation type="obsolete">Joone jämedus:</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="105"/>
        <source> pt</source>
        <translation type="obsolete"> pt</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="118"/>
        <source> %</source>
        <translation type="obsolete"> %</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> pt </source>
        <translation type="obsolete"> pt </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Solid Line</source>
        <translation type="obsolete">Ühtlane joon</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dashed Line</source>
        <translation type="obsolete">Punktiirjoon</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dotted Line</source>
        <translation type="obsolete">Punktjoon</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dash Dot Line</source>
        <translation type="obsolete">Kriipspunktjoon</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Dash Dot Dot Line</source>
        <translation type="obsolete">Kriipspunktpunktjoon</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="284"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation type="obsolete">Nimi &quot;%1&quot; ei ole unikaalne.&lt;br/&gt;Palun vali mõni muu nimi.</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="284"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="../multiline.cpp" line="270"/>
        <source>pt</source>
        <translation type="obsolete">pt</translation>
    </message>
</context>
<context>
    <name>MultiProgressDialog</name>
    <message>
        <location filename="../../scribus/multiprogressdialog.ui" line="13"/>
        <source>Progress</source>
        <translation type="unfinished">Edenemine</translation>
    </message>
    <message>
        <location filename="../../scribus/multiprogressdialog.ui" line="24"/>
        <source>Overall Progress:</source>
        <translation type="unfinished">Üldine edenemine:</translation>
    </message>
    <message>
        <location filename="../../scribus/multiprogressdialog.ui" line="67"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Loobu</translation>
    </message>
    <message>
        <location filename="../../scribus/multiprogressdialog.cpp" line="74"/>
        <source>%v of %m</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>MultiProgressDialogBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Progress</source>
        <translation type="obsolete">Edenemine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Overall Progress:</source>
        <translation type="obsolete">Üldine edenemine:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Loobu</translation>
    </message>
</context>
<context>
    <name>MultipleDuplicate</name>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="112"/>
        <source>&amp;Horizontal Shift:</source>
        <translation>Ni&amp;he rõhtsuunas:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="165"/>
        <source>&amp;Vertical Shift:</source>
        <translation>&amp;Nihe püstsuunas:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.cpp" line="69"/>
        <source>&amp;Horizontal Gap:</source>
        <translation>V&amp;ahe rõhtsuunas:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.cpp" line="70"/>
        <source>&amp;Vertical Gap:</source>
        <translation>&amp;Vahe püstsuunas:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="13"/>
        <source>Multiple Duplicate</source>
        <translation type="unfinished">Mitmekordne kloonimine</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="32"/>
        <source>&amp;By Number of Copies</source>
        <translation type="unfinished">Koo&amp;piate arvu järgi</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="50"/>
        <source>&amp;Number of Copies:</source>
        <translation type="unfinished">Koo&amp;piate arv:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="91"/>
        <source>&amp;Shift Created Items By</source>
        <translation type="unfinished">Loo&amp;dud elementide nihutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="94"/>
        <source>Alt+S</source>
        <translation type="unfinished">Alt+S</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="81"/>
        <source>Create &amp;Gap Between Items Of</source>
        <translation type="unfinished">&amp;Vahe loomine elementide vahele</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="84"/>
        <source>Alt+G</source>
        <translation type="unfinished">Alt+G</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="145"/>
        <source>Rotation:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="217"/>
        <source>By &amp;Rows &amp;&amp; Columns</source>
        <translation type="unfinished">&amp;Ridade ja veergude järgi</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="245"/>
        <source>Vertical Gap:</source>
        <translation type="unfinished">Vahe püstsuunas:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="272"/>
        <source>Horizontal Gap:</source>
        <translation type="unfinished">Vahe rõhtsuunas:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="289"/>
        <source>Number of Rows:</source>
        <translation type="unfinished">Ridade arv:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="309"/>
        <source>Number of Columns:</source>
        <translation type="unfinished">Veergude arv:</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="383"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;OK</translation>
    </message>
    <message>
        <location filename="../../scribus/multipleduplicate.ui" line="399"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Loobu</translation>
    </message>
</context>
<context>
    <name>MultipleDuplicateBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Multiple Duplicate</source>
        <translation type="obsolete">Mitmekordne kloonimine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;By Number of Copies</source>
        <translation type="obsolete">Koo&amp;piate arvu järgi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Number of Copies:</source>
        <translation type="obsolete">Koo&amp;piate arv:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Create &amp;Gap Between Items Of</source>
        <translation type="obsolete">&amp;Vahe loomine elementide vahele</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+G</source>
        <translation type="obsolete">Alt+G</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Shift Created Items By</source>
        <translation type="obsolete">Loo&amp;dud elementide nihutamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Horizontal Shift:</source>
        <translation type="obsolete">Ni&amp;he rõhtsuunas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Vertical Shift:</source>
        <translation type="obsolete">&amp;Nihe püstsuunas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>By &amp;Rows &amp;&amp; Columns</source>
        <translation type="obsolete">&amp;Ridade ja veergude järgi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vertical Gap:</source>
        <translation type="obsolete">Vahe püstsuunas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Horizontal Gap:</source>
        <translation type="obsolete">Vahe rõhtsuunas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of Rows:</source>
        <translation type="obsolete">Ridade arv:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of Columns:</source>
        <translation type="obsolete">Veergude arv:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;OK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Loobu</translation>
    </message>
</context>
<context>
    <name>MyPlugin</name>
    <message>
        <location filename="../../scribus/plugins/myplugin/myplugin.cpp" line="31"/>
        <source>My &amp;Plugin</source>
        <translation>Minu &amp;plugin</translation>
    </message>
</context>
<context>
    <name>MyPluginImpl</name>
    <message>
        <location filename="../../scribus/plugins/myplugin/mypluginimpl.cpp" line="23"/>
        <source>Scribus - My Plugin</source>
        <translation>Scribus - Minu plugin</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/myplugin/mypluginimpl.cpp" line="24"/>
        <source>The plugin worked!</source>
        <translation>Plugin töötas!</translation>
    </message>
</context>
<context>
    <name>NewDoc</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom</source>
        <translation type="obsolete">Kohandatud</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="100"/>
        <source>New Document</source>
        <translation>Uus dokument</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="110"/>
        <source>&amp;New Document</source>
        <translation>&amp;Uus dokument</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="112"/>
        <source>Open &amp;Existing Document</source>
        <translation>Ol&amp;emasolev dokument</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="115"/>
        <source>Open Recent &amp;Document</source>
        <translation>Viimati kasutatud &amp;dokument</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="126"/>
        <source>Do not show this dialog again</source>
        <translation>Seda dialoogi rohkem ei näidata</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="140"/>
        <source>Document page size, either a standard size or a custom size</source>
        <translation>Dokumendi lehekülje suurus: kas mõni standardne või kohandatud</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="141"/>
        <source>Orientation of the document&apos;s pages</source>
        <translation>Dokumendi lehekülgede orientatsioon</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="142"/>
        <source>Width of the document&apos;s pages, editable if you have chosen a custom page size</source>
        <translation>Dokumendi lehekülgede laius. Kui valisid kohandatud suuruse, saab seda muuta.</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="143"/>
        <source>Height of the document&apos;s pages, editable if you have chosen a custom page size</source>
        <translation>Dokumendi lehekülgede kõrgus. Kui valisid kohandatud suuruse, saab seda muuta.</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="144"/>
        <source>Initial number of pages of the document</source>
        <translation>Esialgne dokumendi lehekülgede arv</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="145"/>
        <source>Default unit of measurement for document editing</source>
        <translation>Dokumendi redigeerimisel vaikimisi kasutatav mõõtühik</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="146"/>
        <source>Create text frames automatically when new pages are added</source>
        <translation>Tekstikastide automaatne loomine uute lehekülgede lisamisel</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="147"/>
        <source>Number of columns to create in automatically created text frames</source>
        <translation>Veergude arv automaatselt loodud tekstikastides</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="148"/>
        <source>Distance between automatically created columns</source>
        <translation>Automaatselt loodud veergude vahe</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Size</source>
        <translation type="obsolete">Lehekülje suurus</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="218"/>
        <source>&amp;Size:</source>
        <translation>&amp;Suurus:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="227"/>
        <source>Orie&amp;ntation:</source>
        <translation>Orie&amp;ntatsioon:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="230"/>
        <source>Portrait</source>
        <translation>Püstpaigutus</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="231"/>
        <source>Landscape</source>
        <translation>Rõhtpaigutus</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="237"/>
        <source>&amp;Width:</source>
        <translation>&amp;Laius:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="243"/>
        <source>&amp;Height:</source>
        <translation>&amp;Kõrgus:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="259"/>
        <source>Margin Guides</source>
        <translation>Veerisejooned</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="278"/>
        <source>Options</source>
        <translation>Valikud</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="285"/>
        <source>N&amp;umber of Pages:</source>
        <translation>Le&amp;hekülgede arv:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="291"/>
        <source>&amp;Default Unit:</source>
        <translation>Va&amp;ikimisi ühik:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="301"/>
        <source>&amp;Automatic Text Frames</source>
        <translation>&amp;Automaatsed tekstikastid</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="311"/>
        <source>&amp;Gap:</source>
        <translation>Va&amp;he:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="303"/>
        <source>Colu&amp;mns:</source>
        <translation>V&amp;eergude arv:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="356"/>
        <source>Open</source>
        <translation>Avamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Layout</source>
        <translation type="obsolete">Lehekülgede paigutus</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="250"/>
        <source>First Page is:</source>
        <translation type="unfinished">Esimene lehekülg on:</translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="323"/>
        <source>Show Document Settings After Creation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/newfile.cpp" line="175"/>
        <source>Document Layout</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>NewFromTemplatePlugin</name>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="59"/>
        <source>New &amp;from Template...</source>
        <translation>Uus &amp;mallist...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="79"/>
        <source>Load documents with predefined layout</source>
        <translation>Laadib valmispaigutusega dokumente</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="81"/>
        <source>Start a document from a template made by other users or yourself (f.e. for documents you have a constant style).</source>
        <translation>Teiste või enda loodud dokumendipõhja avamine (tagab dokumentidele ühtse stiili).</translation>
    </message>
</context>
<context>
    <name>NodePalette</name>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="898"/>
        <source>Nodes</source>
        <translation>Sõlmed</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="899"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="901"/>
        <source>&amp;Absolute Coordinates</source>
        <translation>&amp;Absoluutsed koordinaadid</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="904"/>
        <source>&amp;X-Pos:</source>
        <translation>&amp;X-asukoht:</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="905"/>
        <source>&amp;Y-Pos:</source>
        <translation>&amp;Y-asukoht:</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="906"/>
        <source>Edit &amp;Contour Line</source>
        <translation>&amp;Kontuurjoone redigeerimine</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="907"/>
        <source>&amp;Reset Contour Line</source>
        <translation>Lä&amp;htesta kontuurjoon</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="910"/>
        <source>&amp;End Editing</source>
        <translation>Lõp&amp;eta redigeerimine</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="911"/>
        <source>Move Nodes</source>
        <translation>Sõlmede liigutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="912"/>
        <source>Move Control Points</source>
        <translation>Kontrollpunktide liigutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="913"/>
        <source>Add Nodes</source>
        <translation>Sõlmede lisamine</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="914"/>
        <source>Delete Nodes</source>
        <translation>Sõlmede kustutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="915"/>
        <source>Move Control Points Independently</source>
        <translation>Kontrollpunktide liigutamine ükshaaval</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="916"/>
        <source>Move Control Points Symmetrical</source>
        <translation>Kontrollpunktide liigutamine sümmeetriliselt</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="917"/>
        <source>Reset Control Points</source>
        <translation>Kontrollpunktide lähtestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="918"/>
        <source>Reset this Control Point</source>
        <translation>Konkreetse kontrollpunkti lähtestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="919"/>
        <source>Open a Polygon or Cuts a Bezier Curve</source>
        <translation>Hulknurga avamine või Bezier&apos; kõvera lõikamine</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="920"/>
        <source>Close this Bezier Curve</source>
        <translation>Bezier&apos; kõvera sulgemine</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="921"/>
        <source>Mirror the Path Horizontally</source>
        <translation>Asukoha peegeldamine rõhtsuunas</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="922"/>
        <source>Mirror the Path Vertically</source>
        <translation>Asukoha peegeldamine püstsuunas</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="923"/>
        <source>Shear the Path Horizontally to the Right</source>
        <translation>Asukoha nihe rõhtsuunas paremale</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="924"/>
        <source>Shear the Path Horizontally to the Left</source>
        <translation>Asukoha nihe rõhtsuunas vasakule</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="925"/>
        <source>Shear the Path Vertically Up</source>
        <translation>Asukoha nihe püstsuunas üles</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="926"/>
        <source>Shear the Path Vertically Down</source>
        <translation>Asukoha nihe püstsuunas alla</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="927"/>
        <source>Rotate the Path Counter-Clockwise</source>
        <translation>Asukoha pööramine vastupäeva</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="928"/>
        <source>Rotate the Path Clockwise</source>
        <translation>Asukoha pööramine päripäeva</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="929"/>
        <source>Shrink the Size of the Path by shown %</source>
        <translation>Asukoha suuruse kärpimine määratud protsendi võrra</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="930"/>
        <source>Enlarge the Size of the Path by shown %</source>
        <translation>Asukoha suuruse suurendamine määratud protsendi võrra</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="931"/>
        <source>Reduce the Size of the Path by the shown value</source>
        <translation>Asukoha suuruse kärpimine määratud väärtuse võrra</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="932"/>
        <source>Enlarge the Size of the Path by the shown value</source>
        <translation>Asukoha suuruse suurendamine määratud väärtuse võrra</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="933"/>
        <source>Angle of Rotation</source>
        <translation>Pööramisnurk</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="934"/>
        <source>% to Enlarge or Shrink By</source>
        <translation>Suurendamise või vähendamise protsent</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="935"/>
        <source>Value to Enlarge or Shrink By</source>
        <translation>Suurendamise või vähendamise väärtus</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="936"/>
        <source>Activate Contour Line Editing Mode</source>
        <translation>Kontuurjoone redigeerimise lubamine</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="937"/>
        <source>Reset the Contour Line to the Original Shape of the Frame</source>
        <translation>Kontuurjoone lähtestamine kasti esialgsele kujule</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="940"/>
        <source>When checked use coordinates relative to the page, otherwise coordinates are relative to the Object.</source>
        <translation>Sisselülitamisel kasutatakse leheküljega, vastasel juhul objektiga seotud koordinaate.</translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="908"/>
        <source>Set Contour to Image Clip</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="938"/>
        <source>Reset the Contour Line to the Clipping Path of the Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="902"/>
        <source>to Canvas</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="903"/>
        <source>to Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="909"/>
        <source>Set Shape to Image Clip</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/nodeeditpalette.cpp" line="939"/>
        <source>Set the Shape to the Clipping Path of the Image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OODPlug</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="297"/>
        <source>This document does not seem to be an OpenOffice Draw file.</source>
        <translation>See dokument ei paista olevat OpenOffice Draw&apos; fail.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="613"/>
        <source>Group%1</source>
        <translation type="unfinished">Grupp%1</translation>
    </message>
</context>
<context>
    <name>OODrawImportPlugin</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="96"/>
        <source>Import &amp;OpenOffice.org Draw...</source>
        <translation>Impordi &amp;OpenOffice.org Draw...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="111"/>
        <source>Imports OpenOffice.org Draw Files</source>
        <translation>Impordib OpenOffice.org Draw&apos; faile</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="112"/>
        <source>Imports most OpenOffice.org Draw files into the current document, converting their vector data into Scribus objects.</source>
        <translation>Impordib OpenOffice.org Draw&apos; failid aktiivsesse dokumenti, muutes nende vektorandmed Scribuse objektideks.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="126"/>
        <source>OpenDocument 1.0 Draw</source>
        <comment>Import/export format name</comment>
        <translation>OpenDocument 1.0 Draw</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="138"/>
        <source>OpenOffice.org 1.x Draw</source>
        <comment>Import/export format name</comment>
        <translation>OpenOffice.org 1.x Draw</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="208"/>
        <source>This file contains some unsupported features</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oodraw/oodrawimp.cpp" line="206"/>
        <source>The file could not be imported</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OdtDialog</name>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="43"/>
        <source>OpenDocument Importer Options</source>
        <translation>OpenDocument&apos;i importija valikud</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="52"/>
        <source>Overwrite Paragraph Styles</source>
        <translation>Lõigustiilide ülekirjutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="54"/>
        <source>Enabling this will overwrite existing styles in the current Scribus document</source>
        <translation>Sisselülitamisel kirjutatakse aktiivses Scribuse dokumendis olemasolevad stiilid üle</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="61"/>
        <source>Merge Paragraph Styles</source>
        <translation>Lõigustiilide ühendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="63"/>
        <source>Merge paragraph styles by attributes. This will result in fewer similar paragraph styles, will retain style attributes, even if the original document&apos;s styles are named differently.</source>
        <translation>Lõigustiilid ühendatakse atribuutide kaupa. See vähendab erinevate lõigustiilide hulka, kui originaaldokumendis kasutatakse teistsuguse nimega, aga samasuguste atribuutidega stiili.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="70"/>
        <source>Use document name as a prefix for paragraph styles</source>
        <translation>Dokumendi nime kasutamine lõigustiili prefiksina</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="72"/>
        <source>Prepend the document name to the paragraph style name in Scribus.</source>
        <translation>Dokumendi nimi lisatakse Scribuses lõigustiilide ette.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="79"/>
        <source>Do not ask again</source>
        <translation>Rohkem ei küsita</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="81"/>
        <source>Make these settings the default and do not prompt again when importing an OASIS OpenDocument.</source>
        <translation>Määratud seadistused muudetakse vaikeseadistusteks ning dialoogi OASIS OpenDocument&apos;i importimisel enam ei näidata.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="90"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/gettext/odtim/odtdia.cpp" line="92"/>
        <source>Cancel</source>
        <translation>Loobu</translation>
    </message>
</context>
<context>
    <name>OldScribusFormat</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/oldscribusformat/oldscribusformat.cpp" line="59"/>
        <source>Scribus Document</source>
        <translation>Scribuse dokument</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/oldscribusformat/oldscribusformat.cpp" line="70"/>
        <source>Scribus 1.2.x Document</source>
        <translation>Scribus 1.2.x dokument</translation>
    </message>
</context>
<context>
    <name>OneClick</name>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="37"/>
        <source>Origin</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="54"/>
        <source>Size</source>
        <translation type="unfinished">Suurus</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="59"/>
        <source>Width:</source>
        <translation type="unfinished">Laius:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="61"/>
        <source>Length:</source>
        <translation type="unfinished">Pikkus:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="69"/>
        <source>Height:</source>
        <translation type="unfinished">Kõrgus:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="71"/>
        <source>Angle:</source>
        <translation type="unfinished">Nurk:</translation>
    </message>
    <message>
        <location filename="../../scribus/oneclick.cpp" line="101"/>
        <source>Remember Values</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OutlinePalette</name>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="908"/>
        <source>Element</source>
        <translation type="unfinished">Element</translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="287"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation type="unfinished">Nimi &quot;%1&quot; ei ole unikaalne.&lt;br/&gt;Palun vali mõni muu nimi.</translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="876"/>
        <source>Group </source>
        <translation type="unfinished">Grupp </translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="751"/>
        <source>Page </source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="806"/>
        <source>Free Objects</source>
        <translation type="unfinished">Vabad objektid</translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="907"/>
        <source>Outline</source>
        <translation type="unfinished">Struktuur</translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="140"/>
        <source>Enter a keyword or regular expression to filter the outline.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="909"/>
        <source>Filter:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/outlinepalette.cpp" line="141"/>
        <source>Ctrl+F</source>
        <comment>Filter the Outline using a keyword</comment>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>OutlineValues</name>
    <message>
        <location filename="../../scribus/styleselect.cpp" line="97"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../scribus/styleselect.cpp" line="98"/>
        <source>Linewidth</source>
        <translation>Joone jämedus</translation>
    </message>
</context>
<context>
    <name>PDFExportDialog</name>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="152"/>
        <source>Save as PDF</source>
        <translation>Salvestamine PDF-failina</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="65"/>
        <source>O&amp;utput to File:</source>
        <translation>Välj&amp;undfail:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="94"/>
        <source>Cha&amp;nge...</source>
        <translation>&amp;Muuda...</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="97"/>
        <source>Output one file for eac&amp;h page</source>
        <translation>I&amp;ga lehekülg salvestatakse eraldi failina</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="110"/>
        <source>&amp;Save</source>
        <translation>&amp;Salvesta</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="122"/>
        <source>This enables exporting one individually named PDF file for each page in the document. Page numbers are added automatically. This is most useful for imposing PDF for commercial printing.</source>
        <translation>Võimaldab iga dokumendi lehekülje eksportida omaette nimega PDF-failina. Leheküljenumbrid lisatakse automaatselt. See on eriti abiks PDF-failide järjestamisel trükikotta saatmiseks.</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="123"/>
        <source>The save button will be disabled if you are trying to export PDF/X-3 and the info string is missing from the PDF/X-3 tab.</source>
        <translation>Salvestamisnupp ei ole aktiivne, kui püüad eksportida PDF/X-3 ning PDF/X-3 kaardil puudub infostring.</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="204"/>
        <source>Save as</source>
        <translation type="obsolete">Salvestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="204"/>
        <source>PDF Files (*.pdf);;All Files (*)</source>
        <translation>PDF-failid (*.pdf);;Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="153"/>
        <source>%1 does not exists and will be created, continue?</source>
        <translation>%1 puudub, mistõttu see luuakse. Kas jätkata?</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="170"/>
        <source>Cannot create directory: 
%1</source>
        <translation>Kataloogi ei õnnestunud luua: (new line)
%1</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfopts.cpp" line="204"/>
        <source>Save As</source>
        <translation type="unfinished">Salvestamine</translation>
    </message>
</context>
<context>
    <name>PDFLibCore</name>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="135"/>
        <source>Saving PDF</source>
        <translation type="unfinished">PDF-i salvestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="139"/>
        <source>Exporting Master Page:</source>
        <translation type="unfinished">Leheküljetooriku eksport:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="139"/>
        <source>Exporting Page:</source>
        <translation type="unfinished">Lehekülje eksport:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="139"/>
        <source>Exporting Items on Current Page:</source>
        <translation type="unfinished">Aktiivse lehekülje elementide eksport:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="2536"/>
        <source>Page:</source>
        <translation type="unfinished">Lehekülg:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="2549"/>
        <source>Date:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7702"/>
        <source>Failed to load an image : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7707"/>
        <source>Failed to write an image : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7712"/>
        <source>Failed to load an image mask : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7717"/>
        <source>Insufficient memory for processing an image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pdflib_core.cpp" line="7697"/>
        <source>A write error occured, please check available disk space</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PDFToolBar</name>
    <message>
        <location filename="../../scribus/ui/pdftoolbar.cpp" line="29"/>
        <source>PDF Tools</source>
        <translation>PDF-i tööriistad</translation>
    </message>
</context>
<context>
    <name>PDFlib</name>
    <message>
        <location filename="../pdflib.cpp" line="119"/>
        <source>Saving PDF</source>
        <translation type="obsolete">PDF-i salvestamine</translation>
    </message>
    <message>
        <location filename="../pdflib.cpp" line="123"/>
        <source>Exporting Master Page:</source>
        <translation type="obsolete">Leheküljetooriku eksport:</translation>
    </message>
    <message>
        <location filename="../pdflib.cpp" line="123"/>
        <source>Exporting Page:</source>
        <translation type="obsolete">Lehekülje eksport:</translation>
    </message>
    <message>
        <location filename="../pdflib.cpp" line="123"/>
        <source>Exporting Items on Current Page:</source>
        <translation type="obsolete">Aktiivse lehekülje elementide eksport:</translation>
    </message>
    <message>
        <location filename="../pdflib.cpp" line="2275"/>
        <source>Page:</source>
        <translation type="obsolete">Lehekülg:</translation>
    </message>
</context>
<context>
    <name>PPreview</name>
    <message>
        <location filename="../../scribus/preview.cpp" line="81"/>
        <source>Print Preview</source>
        <translation>Trükkimise eelvaatlus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Anti-alias &amp;Text</source>
        <translation type="obsolete">&amp;Teksti antialias</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Anti-alias &amp;Graphics</source>
        <translation type="obsolete">&amp;Graafika antialias</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="133"/>
        <source>Display Trans&amp;parency</source>
        <translation>Lä&amp;bipaistvuse näitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="248"/>
        <source>&amp;Under Color Removal</source>
        <translation>&amp;Under Color Removal</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="138"/>
        <source>&amp;Display CMYK</source>
        <translation>CMYK-i &amp;näitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="252"/>
        <source>Force Overprint Mode</source>
        <translation type="obsolete">Ületrükirežiim</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="206"/>
        <source>&amp;C</source>
        <translation>&amp;C</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="211"/>
        <source>&amp;M</source>
        <translation>&amp;M</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="216"/>
        <source>&amp;Y</source>
        <translation>&amp;Y</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="221"/>
        <source>&amp;K</source>
        <translation>&amp;K</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="150"/>
        <source>Separation Name</source>
        <translation>Värvilahutuse nimi</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="162"/>
        <source>Cyan</source>
        <translation>Tsüaan</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="169"/>
        <source>Magenta</source>
        <translation>Magenta</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="176"/>
        <source>Yellow</source>
        <translation>Kollane</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="183"/>
        <source>Black</source>
        <translation>Must</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="269"/>
        <source>Scaling:</source>
        <translation>Skaleerimine:</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="294"/>
        <source>Close</source>
        <translation>Sulge</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="297"/>
        <source>Print...</source>
        <translation>Trüki...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Provides a more pleasant view of text items in the viewer, at the expense of a slight slowdown in previewing. This only affects Type 1 fonts</source>
        <translation type="obsolete">Võimaldab tekstielementide ilusamat esitamist aknas, seda küll mõningase eelvaatluse aeglustumisega. See puudutab ainult Type 1 fonte.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Provides a more pleasant view of TrueType Fonts, OpenType Fonts, EPS, PDF and vector graphics in the preview, at the expense of a slight slowdown in previewing</source>
        <translation type="obsolete">Võimaldab TrueType fontide, OpenType fontide, EPS-i, PDF-i ja vektorgraafika ilusamat esitamist aknas, seda küll mõningase eelvaatluse aeglustumisega. See puudutab ainult Type 1 fonte.</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="326"/>
        <source>Shows transparency and transparent items in your document. Requires Ghostscript 7.07 or later</source>
        <translation>Näitab läbipaistvust ja dokumendi läbipaistvaid elemente. Vajalik on Ghostscript 7.07 või uuem.</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="327"/>
        <source>Gives a print preview using simulations of generic CMYK inks, instead of RGB colors</source>
        <translation>Trükkimise eelvaatlusel simuleeritakse RGB värvide asemel CMYK värve</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="328"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis. UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation>Võimalus lülitada välja mõningad tsüaanist, kollasest ja magentast koosnevad halli toonid ning kasutada selle asemel musta. UCR mõjutab kõige rohkem piltide neid osi, kus valitsevad neutraalsed ja/või tumedad toonid, mis on suhteliselt lähedal hallile. Selle valiku kasutamisel võib paraneda mõningate piltide trükikvaliteet, kuid alati tuleb seda katse-eksituse meetodil ise järele proovida. UCR vähendab üleküllastuse võimalust CMY värvides.</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="329"/>
        <source>Resize the scale of the page.</source>
        <translation>Lehekülje skaleerimise muutmine.</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="350"/>
        <source>Enable/disable the C (Cyan) ink plate</source>
        <translation>C värvi (tsüaan) lubamine/keelamine</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="351"/>
        <source>Enable/disable the M (Magenta) ink plate</source>
        <translation>M värvi (magenta) lubamine/keelamine</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="352"/>
        <source>Enable/disable the Y (Yellow) ink plate</source>
        <translation>Y värvi (kollane) lubamine/keelamine</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="353"/>
        <source>Enable/disable the K (Black) ink plate</source>
        <translation>K värvi (must) lubamine/keelamine</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="619"/>
        <source>All</source>
        <translation>Kõik</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="1106"/>
        <source>File</source>
        <translation>Fail</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="128"/>
        <source>Enable &amp;Antialiasing</source>
        <translation>&amp;Antialiase lubamine</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="281"/>
        <source>Fit to Width</source>
        <translation>Mahutamine laiusele</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="282"/>
        <source>Fit to Height</source>
        <translation>Mahutamine kõrgusele</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="283"/>
        <source>Fit to Page</source>
        <translation>Mahutamine leheküljele</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="325"/>
        <source>Provides a more pleasant view of Type 1 fonts, TrueType Fonts, OpenType Fonts, EPS, PDF and vector graphics in the preview, at the expense of a slight slowdown in previewing</source>
        <translation>Võimaldab Type 1 fontide, TrueType fontide, OpenType fontide, EPS-i, PDF-i ja vektorgraafika ilusamat esitamist aknas, seda küll mõningase eelvaatluse aeglustumisega</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="122"/>
        <source>Display Settings</source>
        <translation>Vaateseadistused</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="230"/>
        <source>Print Settings</source>
        <translation>Trükkimisseadistused</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="236"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation>Lehekülgede peegeldamine rõhtsalt</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="239"/>
        <source>Mirror Page(s) Vertical</source>
        <translation>Lehekülgede peegeldamine püstiselt</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="242"/>
        <source>Clip to Page Margins</source>
        <translation type="obsolete">Kärpimine lehekülje veeriste juures</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="245"/>
        <source>Print in Grayscale</source>
        <translation>Halltoonis trükk</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="251"/>
        <source>Convert Spot Colors</source>
        <translation>Spot-värvidesse teisendamine</translation>
    </message>
    <message>
        <location filename="../preview.cpp" line="255"/>
        <source>Apply ICC Profiles</source>
        <translation type="obsolete">ICC profiilide rakendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="330"/>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation>Sisselülitamisel teisendatakse spot-värvid komposiitvärvideks. Kui sa ei kavatse just saata trükikotta spot-värve, on mõttekas see sisse lülitada.</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="335"/>
        <source>Enables global Overprint Mode for this document, overrides object settings</source>
        <translation type="obsolete">Sisselülitamisel kehtestatakse dokumendile üldine ületrükirežiim, mis tühistab objektide määratlused</translation>
    </message>
    <message>
        <location filename="../preview.cpp" line="326"/>
        <source>Allows you to embed ICC profiles in the print stream when color management is enabled</source>
        <translation type="obsolete">Võimaldab värvihalduse korral põimida trükkimisandmetesse ICC profiilid</translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="254"/>
        <source>Apply Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="331"/>
        <source>Allows you to embed color profiles in the print stream when color management is enabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/preview.cpp" line="242"/>
        <source>Clip to Printer Margins</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PSLib</name>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1793"/>
        <source>Processing Master Page:</source>
        <translation>Leheküljetooriku töötlemine:</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1793"/>
        <source>Exporting Page:</source>
        <translation>Lehekülje eksport:</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1726"/>
        <source>Failed to write data for an image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1731"/>
        <source>Failed to load an image : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1736"/>
        <source>Failed to load an image mask : %1</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1741"/>
        <source>Insufficient memory for processing an image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PStyleW</name>
    <message>
        <location filename="../smpstylew.ui" line="13"/>
        <source>Form1</source>
        <translation type="obsolete">Vorm1</translation>
    </message>
    <message>
        <location filename="../smpstylew.ui" line="46"/>
        <source>Tabulators and Indentation</source>
        <translation type="obsolete">Tabeldusmärgid ja taandus</translation>
    </message>
    <message>
        <location filename="../smpstylew.ui" line="104"/>
        <source>Distances and Alignment</source>
        <translation type="obsolete">Vahed ja joondus</translation>
    </message>
    <message>
        <location filename="../smpstylew.ui" line="130"/>
        <source>Drop Caps</source>
        <translation type="obsolete">Süvisinitsiaalid</translation>
    </message>
    <message>
        <location filename="../smpstylew.ui" line="146"/>
        <source>Parent&apos;s Drop Cap Status</source>
        <translation type="obsolete">Eellase süvisinitsiaali olek</translation>
    </message>
    <message>
        <location filename="../smpstylew.ui" line="190"/>
        <source>Ch&amp;aracter Style</source>
        <translation type="obsolete">Mär&amp;gistiil</translation>
    </message>
</context>
<context>
    <name>PStyleWBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Form1</source>
        <translation type="obsolete">Vorm1</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Properties</source>
        <translation type="obsolete">OmadusedOmadused</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Parent</source>
        <translation type="obsolete">Eellane</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Distances and Alignment</source>
        <translation type="obsolete">Vahed ja joondus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Drop Caps</source>
        <translation type="obsolete">Süvisinitsiaalid</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Parent&apos;s Drop Cap Status</source>
        <translation type="obsolete">Eellase süvisinitsiaali olek</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Tabulators and Indentation</source>
        <translation type="obsolete">Tabeldusmärgid ja taandus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ch&amp;aracter Style</source>
        <translation type="obsolete">Mär&amp;gistiil</translation>
    </message>
</context>
<context>
    <name>PageItem</name>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="388"/>
        <source>Image</source>
        <translation>Pilt</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="392"/>
        <source>Text</source>
        <translation>Tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="396"/>
        <source>Line</source>
        <translation>Joon</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="400"/>
        <source>Polygon</source>
        <translation>Hulknurk</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="404"/>
        <source>Polyline</source>
        <translation>Kompleksjoon</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="408"/>
        <source>PathText</source>
        <translation>Trajektooritekst</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem.cpp" line="3612"/>
        <source>Copy of</source>
        <translation>Koopia -</translation>
    </message>
</context>
<context>
    <name>PageItemAttributes</name>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>None</source>
        <comment>relationship</comment>
        <translation>Puudub</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Relates To</source>
        <translation>On seotud elemendiga</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Is Parent Of</source>
        <translation>On eellane elemendile</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.cpp" line="21"/>
        <source>Is Child Of</source>
        <translation>On järglane elemendile</translation>
    </message>
    <message>
        <location filename="../pageitemattributes.ui" line="13"/>
        <source>Page Item Attributes</source>
        <translation type="obsolete">Lehekülje elemendi atribuudid</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="58"/>
        <source>&amp;Add</source>
        <translation type="unfinished">Lis&amp;a</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="61"/>
        <source>Alt+A</source>
        <translation type="unfinished">Alt+A</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="68"/>
        <source>&amp;Copy</source>
        <translation type="unfinished">&amp;Kopeeri</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="71"/>
        <source>Alt+C</source>
        <translation type="unfinished">Alt+C</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="78"/>
        <source>&amp;Delete</source>
        <translation type="unfinished">K&amp;ustuta</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="81"/>
        <source>Alt+D</source>
        <translation type="unfinished">Alt+D</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="88"/>
        <source>C&amp;lear</source>
        <translation type="unfinished">&amp;Puhasta</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="91"/>
        <source>Alt+L</source>
        <translation type="unfinished">Alt+L</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="114"/>
        <source>&amp;OK</source>
        <translation type="unfinished">&amp;OK</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="130"/>
        <source>&amp;Cancel</source>
        <translation type="unfinished">&amp;Loobu</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="23"/>
        <source>Name</source>
        <translation type="unfinished">Nimi</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="28"/>
        <source>Type</source>
        <translation type="unfinished">Tüüp</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="33"/>
        <source>Value</source>
        <translation type="unfinished">Väärtus</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="38"/>
        <source>Parameter</source>
        <translation type="unfinished">Parameeter</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="43"/>
        <source>Relationship</source>
        <translation type="unfinished">Seos</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="48"/>
        <source>Relationship To</source>
        <translation type="unfinished">Seos elemendiga</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitemattributes.ui" line="13"/>
        <source>Attributes</source>
        <translation type="unfinished">Atribuudid</translation>
    </message>
</context>
<context>
    <name>PageItemAttributesBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Item Attributes</source>
        <translation type="obsolete">Lehekülje elemendi atribuudid</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name</source>
        <translation type="obsolete">Nimi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Type</source>
        <translation type="obsolete">Tüüp</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Value</source>
        <translation type="obsolete">Väärtus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Parameter</source>
        <translation type="obsolete">Parameeter</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relationship</source>
        <translation type="obsolete">Seos</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Relationship To</source>
        <translation type="obsolete">Seos elemendiga</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Add</source>
        <translation type="obsolete">Lis&amp;a</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+A</source>
        <translation type="obsolete">Alt+A</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Copy</source>
        <translation type="obsolete">&amp;Kopeeri</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+C</source>
        <translation type="obsolete">Alt+C</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Delete</source>
        <translation type="obsolete">K&amp;ustuta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+D</source>
        <translation type="obsolete">Alt+D</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C&amp;lear</source>
        <translation type="obsolete">&amp;Puhasta</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+L</source>
        <translation type="obsolete">Alt+L</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;OK</source>
        <translation type="obsolete">&amp;OK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Cancel</source>
        <translation type="obsolete">&amp;Loobu</translation>
    </message>
</context>
<context>
    <name>PageItem_ImageFrame</name>
    <message>
        <location filename="../pageitem_imageframe.cpp" line="244"/>
        <source>Picture</source>
        <translation type="obsolete">Pilt</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="394"/>
        <source>Preview Settings</source>
        <translation type="unfinished">Eelvaatluse seadistused</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="463"/>
        <source>Image</source>
        <translation type="unfinished">Pilt</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="469"/>
        <source>Embedded Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="498"/>
        <source>File:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="472"/>
        <source>Original PPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="473"/>
        <source>Actual PPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="104"/>
        <source>Size:</source>
        <translation type="unfinished">Suurus:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="474"/>
        <source>Colorspace:</source>
        <translation type="unfinished">Värviruum:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="478"/>
        <source>Unknown</source>
        <translation type="unfinished">Teadmata</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="485"/>
        <source>Page:</source>
        <translation type="unfinished">Lehekülg:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="487"/>
        <source>Pages:</source>
        <translation type="unfinished">Leheküljed:</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="496"/>
        <source>Embedded Image missing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="498"/>
        <source>missing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_imageframe.cpp" line="501"/>
        <source>No Image Loaded</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageItem_LatexFrame</name>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="564"/>
        <source>Error</source>
        <translation type="unfinished">Viga</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="166"/>
        <source>Running the external application failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="239"/>
        <source>Could not create a temporary file to run the application!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="248"/>
        <source>Information</source>
        <translation type="obsolete">Info</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="415"/>
        <source>Running the application &quot;%1&quot; failed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../pageitem_latexframe.cpp" line="647"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="569"/>
        <source>Running</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="405"/>
        <source>The application &quot;%1&quot; failed to start!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="409"/>
        <source>The application &quot;%1&quot; crashed!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="558"/>
        <source>Application</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="559"/>
        <source>DPI</source>
        <translation type="unfinished">DPI</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="561"/>
        <source>State</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="566"/>
        <source>Finished</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="44"/>
        <source>Render</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="260"/>
        <source>The config file didn&apos;t specify a executable path!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="557"/>
        <source>Render Frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="224"/>
        <source>No configuration defined to run the application!</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="421"/>
        <source>No application defined</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="130"/>
        <source>Rendering...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_latexframe.cpp" line="139"/>
        <source>Render Error</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PageItem_PathText</name>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="319"/>
        <source>Paragraphs: </source>
        <translation type="unfinished">Lõike: </translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="327"/>
        <source>Lines: </source>
        <translation type="unfinished">Read: </translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="333"/>
        <source>Words: </source>
        <translation type="unfinished">Sõnu: </translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_pathtext.cpp" line="341"/>
        <source>Chars: </source>
        <translation type="unfinished">Märke: </translation>
    </message>
</context>
<context>
    <name>PageItem_TextFrame</name>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3422"/>
        <source>Linked Text</source>
        <translation type="unfinished">Lingitud tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3424"/>
        <source>Text Frame</source>
        <translation type="unfinished">Tekstikast</translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3428"/>
        <source>Paragraphs: </source>
        <translation type="unfinished">Lõike: </translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3436"/>
        <source>Lines: </source>
        <translation type="unfinished">Read: </translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3442"/>
        <source>Words: </source>
        <translation type="unfinished">Sõnu: </translation>
    </message>
    <message>
        <location filename="../../scribus/pageitem_textframe.cpp" line="3450"/>
        <source>Chars: </source>
        <translation type="unfinished">Märke: </translation>
    </message>
</context>
<context>
    <name>PageLayouts</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Layout</source>
        <translation type="obsolete">Lehekülgede paigutus</translation>
    </message>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="266"/>
        <source>First Page is:</source>
        <translation>Esimene lehekülg on:</translation>
    </message>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="197"/>
        <source>Document Layout</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="268"/>
        <source>Number of pages to show side-by-side on the canvas
Often used for allowing items to be placed across page spreads</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagelayout.cpp" line="273"/>
        <source>Location on the canvas where the first page of the document is placed</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PagePalette</name>
    <message>
        <location filename="../pagepalette.cpp" line="533"/>
        <source>Double sided</source>
        <translation type="obsolete">Kaks lehekülge</translation>
    </message>
    <message>
        <location filename="../pagepalette.cpp" line="541"/>
        <source>Middle Right</source>
        <translation type="obsolete">Parem keskmine</translation>
    </message>
    <message>
        <location filename="../pagepalette.cpp" line="573"/>
        <source>Drag pages or master pages onto the trashbin to delete them</source>
        <translation type="obsolete">Lohista leheküljed või leheküljetoorikud kustutamiseks prügikasti</translation>
    </message>
    <message>
        <location filename="../pagepalette.cpp" line="574"/>
        <source>Here are all your master pages. To create a new page, drag a master page to the page view below</source>
        <translation type="obsolete">Siin on näha kõik leheküljetoorikud. Uue lehekülje loomiseks lohista toorik allolevasse leheküljekasti.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Normal</source>
        <translation type="obsolete">Normaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="933"/>
        <source>Arrange Pages</source>
        <translation>Lehekülgede korraldamine</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="934"/>
        <source>Available Master Pages:</source>
        <translation>Saadaolevad leheküljetoorikud:</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="935"/>
        <source>Document Pages:</source>
        <translation>Dokumendi leheküljed:</translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="938"/>
        <source>List of normal pages in the document, shown with the document layout. Pages may be dragged to rearrange or delete them.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="939"/>
        <source>Drag pages or master pages onto the trash to delete them</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="937"/>
        <source>List of master pages in the document. Master page names may be dragged onto the page view below to apply master pages, or onto the empty space between pages to create new pages.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="628"/>
        <source>This master page is used at least once in the document.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/pagepalette.cpp" line="632"/>
        <source>Do you really want to delete this master page?</source>
        <translation type="unfinished">Kas tõesti kustutada see leheküljetoorik?</translation>
    </message>
</context>
<context>
    <name>PageSelector</name>
    <message>
        <location filename="" line="136966688"/>
        <source>%1 of %1</source>
        <translation type="obsolete">%1 (kokku %1)</translation>
    </message>
    <message>
        <location filename="../../scribus/pageselector.cpp" line="266"/>
        <source>%1 of %2</source>
        <translation>%1 (kokku %2)</translation>
    </message>
</context>
<context>
    <name>PageSize</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Quarto</source>
        <translation type="obsolete">Quarto</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Foolscap</source>
        <translation type="obsolete">Foolscap</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Letter</source>
        <translation type="obsolete">Letter</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Government Letter</source>
        <translation type="obsolete">Government Letter</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Legal</source>
        <translation type="obsolete">Legal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ledger</source>
        <translation type="obsolete">Ledger</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Executive</source>
        <translation type="obsolete">Executive</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Post</source>
        <translation type="obsolete">Post</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Crown</source>
        <translation type="obsolete">Crown</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Large Post</source>
        <translation type="obsolete">Large Post</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Demy</source>
        <translation type="obsolete">Demy</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Medium</source>
        <translation type="obsolete">Medium</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Royal</source>
        <translation type="obsolete">Royal</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Elephant</source>
        <translation type="obsolete">Elephant</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Double Demy</source>
        <translation type="obsolete">Double Demy</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Quad Demy</source>
        <translation type="obsolete">Quad Demy</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>STMT</source>
        <translation type="obsolete">STMT</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>A</source>
        <translation type="obsolete">A</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>B</source>
        <translation type="obsolete">B</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C</source>
        <translation type="obsolete">C</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>D</source>
        <translation type="obsolete">D</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>E</source>
        <translation type="obsolete">E</translation>
    </message>
</context>
<context>
    <name>ParaStyleComboBox</name>
    <message>
        <location filename="../../scribus/spalette.cpp" line="62"/>
        <source>No Style</source>
        <translation type="unfinished">Stiil puudub</translation>
    </message>
</context>
<context>
    <name>PathAlongPathPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="69"/>
        <source>Path Along Path...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="73"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="96"/>
        <source>Bends a Polygon along a Polyline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathalongpath.cpp" line="97"/>
        <source>This plugin bends a Polygon with the help of a Polyline.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathConnectDialogBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="13"/>
        <source>Connect Paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="19"/>
        <source>Connect first Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="48"/>
        <source>Starting Point</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="53"/>
        <source>End Point</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="40"/>
        <source>with second Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="61"/>
        <source>with:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="69"/>
        <source>a straight Line</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="74"/>
        <source>Points moving</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnectdialogbase.ui" line="82"/>
        <source>Preview on Canvas</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathConnectPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="90"/>
        <source>Connect Paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="69"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathconnect/pathconnect.cpp" line="91"/>
        <source>Connect 2 Polylines.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathCutPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="70"/>
        <source>Cut Polygon</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="76"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="100"/>
        <source>Cuts a Polygon by a Polyline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="119"/>
        <source>Qt Version too old</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="119"/>
        <source>This plugin requires at least version 4.3.3 of the Qt library</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="150"/>
        <source>Error</source>
        <translation type="unfinished">Viga</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathcut/pathcut.cpp" line="150"/>
        <source>The cutting line must cross the polygon and
both end points must lie outside of the polygon</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context encoding="UTF-8">
    <name>PathDialogBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="13"/>
        <source>Path along Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="21"/>
        <source>Effect Type</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="29"/>
        <source>Single</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="34"/>
        <source>Single, stretched</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="39"/>
        <source>Repeated</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="44"/>
        <source>Repeated, stretched</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="52"/>
        <source>Horizontal Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="62"/>
        <source>Vertical Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="103"/>
        <source>Gap between Objects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="113"/>
        <source>Preview on Canvas</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="72"/>
        <source>Rotate Objects by:</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="80"/>
        <source>0°</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="85"/>
        <source>90°</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="90"/>
        <source>180°</source>
        <translation type="unfinished"></translation>
    </message>
    <message encoding="UTF-8">
        <location filename="../../scribus/plugins/tools/2geomtools/pathalongpath/pathdialogbase.ui" line="95"/>
        <source>270°</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathFinderBase</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="13"/>
        <source>Boolean Path Operations</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="97"/>
        <source>+</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="195"/>
        <source>=</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="274"/>
        <source>Operation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="357"/>
        <source>...</source>
        <translation type="unfinished">...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="381"/>
        <source>Swap Shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="386"/>
        <source>Options</source>
        <translation type="obsolete">Valikud</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="41"/>
        <source>First source shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="139"/>
        <source>Second source shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="234"/>
        <source>The resulting shape.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="286"/>
        <source>Unites the shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="321"/>
        <source>Intersection of the shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="337"/>
        <source>Result is the area where the two shapes do not intersect</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="353"/>
        <source>Break apart,
The result is a combination of &quot;Intersection&quot; and &quot;Exclusion&quot;</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="450"/>
        <source>Custom Colors</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="462"/>
        <source>Stroke:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="488"/>
        <source>Fill:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="158"/>
        <source>Keep a copy of the original item after applying the operation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="161"/>
        <source>Keep</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="305"/>
        <source>Subtracts the second shape from the first shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="378"/>
        <source>Exchange the Source Shapes</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="418"/>
        <source>Result takes color from:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="424"/>
        <source>The resulting shape uses the color of the first source shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="427"/>
        <source>First Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="437"/>
        <source>The resulting shape uses the color of the second source shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="440"/>
        <source>Second Shape</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="447"/>
        <source>The resulting shape uses the colors listed below</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="478"/>
        <source>Stroke Color</source>
        <translation type="unfinished">Äärejoone värv</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderbase.ui" line="498"/>
        <source>Fill Color</source>
        <translation type="unfinished">Täidise värv</translation>
    </message>
</context>
<context>
    <name>PathFinderDialog</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderdialog.cpp" line="103"/>
        <source>Result gets Color of:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinderdialog.cpp" line="127"/>
        <source>Intersection gets Color of:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathFinderPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="74"/>
        <source>Path Operations...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="78"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="103"/>
        <source>Path Operations</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="104"/>
        <source>Apply fancy boolean operations to paths.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="123"/>
        <source>Qt Version too old</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathfinder/pathfinder.cpp" line="123"/>
        <source>This plugin requires at least version 4.3.3 of the Qt library</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PathStrokerPlugin</name>
    <message>
        <location filename="../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="95"/>
        <source>Create Path from Stroke</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="74"/>
        <source>Path Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/tools/pathstroker/pathstroker.cpp" line="96"/>
        <source>Converts the stroke of a Path to a filled Path.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PatternDialog</name>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="134"/>
        <source>Choose a Directory</source>
        <translation>Kataloogi valik</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="162"/>
        <source>Loading Patterns</source>
        <translation>Mustrite laadimine</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="296"/>
        <source>All Files (*)</source>
        <translation>Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="310"/>
        <source>Open</source>
        <translation>Ava</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="14"/>
        <source>Patterns</source>
        <translation type="unfinished">Mustrid</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="56"/>
        <source>Load</source>
        <translation type="unfinished">Laadi</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="63"/>
        <source>Load Set</source>
        <translation type="unfinished">Laadi kogu</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="77"/>
        <source>Remove</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="84"/>
        <source>Remove All</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="107"/>
        <source>OK</source>
        <translation type="unfinished">OK</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="114"/>
        <source>Cancel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="84"/>
        <source>&amp;Name:</source>
        <translation type="unfinished">&amp;Nimi:</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="84"/>
        <source>Rename Entry</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.cpp" line="213"/>
        <source>All Supported Formats</source>
        <translation type="unfinished">Kõik toetatud vormingud</translation>
    </message>
    <message>
        <location filename="../../scribus/patterndialog.ui" line="70"/>
        <source>Rename</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PicSearch</name>
    <message>
        <location filename="../../scribus/picsearch.ui" line="14"/>
        <source>Result</source>
        <translation type="unfinished">Tulemus</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="34"/>
        <source>Search Results for: </source>
        <translation type="unfinished">Otsingutulemused: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preview</source>
        <translation type="obsolete">Eelvaatlus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select</source>
        <translation type="obsolete">Vali</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="128"/>
        <source>Cancel</source>
        <translation type="unfinished">Loobu</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="108"/>
        <source>Size:</source>
        <translation type="unfinished">Suurus:</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="109"/>
        <source>Resolution:</source>
        <translation type="unfinished">Lahutus:</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="109"/>
        <source>DPI</source>
        <translation type="unfinished">DPI</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="112"/>
        <source>Unknown</source>
        <translation type="unfinished">Teadmata</translation>
    </message>
    <message>
        <location filename="../picsearch.cpp" line="118"/>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="../picsearch.cpp" line="121"/>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="../picsearch.cpp" line="124"/>
        <source>Grayscale</source>
        <translation type="obsolete">Halltoonid</translation>
    </message>
    <message>
        <location filename="../picsearch.cpp" line="127"/>
        <source>Duotone</source>
        <translation type="obsolete">Duotone</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.cpp" line="115"/>
        <source>Colorspace:</source>
        <translation type="unfinished">Värviruum:</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="86"/>
        <source>&amp;Preview</source>
        <translation type="unfinished">&amp;Eelvaatlus</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="89"/>
        <source>Alt+P</source>
        <translation type="unfinished">Alt+P</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="115"/>
        <source>&amp;Select</source>
        <translation type="unfinished">&amp;Vali</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearch.ui" line="118"/>
        <source>Alt+S</source>
        <translation type="unfinished">Alt+S</translation>
    </message>
</context>
<context>
    <name>PicSearchBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Result</source>
        <translation type="obsolete">Tulemus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Search Results for: </source>
        <translation type="obsolete">Otsingutulemused: </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Preview</source>
        <translation type="obsolete">&amp;Eelvaatlus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+P</source>
        <translation type="obsolete">Alt+P</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Select</source>
        <translation type="obsolete">&amp;Vali</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+S</source>
        <translation type="obsolete">Alt+S</translation>
    </message>
</context>
<context>
    <name>PicSearchOptions</name>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="51"/>
        <source>The filesystem will be searched for case insensitive file names when you check this on. Remember it is not default on most operating systems except MS Windows</source>
        <translation type="unfinished">Märkimisel otsitakse failisüsteemist failinimesid suur- ja väiketähtede erinevust arvestamata. Arvesta, et see on vaikevalik ainult vähestes operatsioonisüsteemides, nt. MS Windowsis</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="58"/>
        <source>Cancel Search</source>
        <translation type="unfinished">Katkesta otsing</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="124"/>
        <source>Start Search</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="91"/>
        <source>Select a base directory for search</source>
        <translation type="unfinished">Otsingu baaskataloogi valik</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="140"/>
        <source>Scribus - Image Search</source>
        <translation type="unfinished">Scribus - pildiotsing</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="140"/>
        <source>The search failed: %1</source>
        <translation type="unfinished">Otsing ebaõnnestus: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="13"/>
        <source>Search Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="25"/>
        <source>Search for:</source>
        <translation type="unfinished">Otsimine:</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="38"/>
        <source>Start at:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="64"/>
        <source>Change...</source>
        <translation type="unfinished">Muuda...</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="79"/>
        <source>Searching</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="141"/>
        <source>Case insensitive search</source>
        <translation type="unfinished">Tõstutundetu otsing</translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.ui" line="148"/>
        <source>Search recursively</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picsearchoptions.cpp" line="103"/>
        <source>Base directory for search does not exist.
Please choose another one.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PicStatus</name>
    <message>
        <location filename="../picstatus.ui" line="16"/>
        <source>Manage Pictures</source>
        <translation type="obsolete">Piltide haldamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Name</source>
        <translation type="obsolete">Nimi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Path</source>
        <translation type="obsolete">Asukoht</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page</source>
        <translation type="obsolete">Lehekülg</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Print</source>
        <translation type="obsolete">Trükitav</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Status</source>
        <translation type="obsolete">Olek</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Yes</source>
        <translation type="obsolete">Jah</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>OK</source>
        <translation type="obsolete">OK</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Missing</source>
        <translation type="obsolete">Puuduv</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Search</source>
        <translation type="obsolete">Otsi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cancel Search</source>
        <translation type="obsolete">Katkesta otsing</translation>
    </message>
    <message>
        <location filename="../picstatus.ui" line="575"/>
        <source>Goto</source>
        <translation type="obsolete">Liigu</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select a base directory for search</source>
        <translation type="obsolete">Otsingu baaskataloogi valik</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="422"/>
        <source>Scribus - Image Search</source>
        <translation>Scribus - pildiotsing</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The search failed: %1</source>
        <translation type="obsolete">Otsing ebaõnnestus: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="422"/>
        <source>No images named &quot;%1&quot; were found.</source>
        <translation>Pilti nimega &quot;%1&quot; ei leitud.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Search Directory</source>
        <translation type="obsolete">Otsingukataloog</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="684"/>
        <source>Close</source>
        <translation>Sulge</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set a new location for the selected items. Useful when you may have moved the document but not the images.</source>
        <translation type="obsolete">Määra valitud elementide uus asukoht. Kasulik, kui oled näiteks liigutanud dokumenti, aga mitte pilte.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select a base directory for your selected rows</source>
        <translation type="obsolete">Vali valitud ridade baaskataloog</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Case insensitive search</source>
        <translation type="obsolete">Tõstutundetu otsing</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>The filesystem will be searched for case insensitive file names when you check this on. Remember it is not default on most operating systems except MS Windows</source>
        <translation type="obsolete">Märkimisel otsitakse failisüsteemist failinimesid suur- ja väiketähtede erinevust arvestamata. Arvesta, et see on vaikevalik ainult vähestes operatsioonisüsteemides, nt. MS Windowsis</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="253"/>
        <source>Not on a Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="278"/>
        <source>JPG</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="281"/>
        <source>TIFF</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="284"/>
        <source>PSD</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="287"/>
        <source>EPS/PS</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="290"/>
        <source>PDF</source>
        <translation type="unfinished">PDF</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="293"/>
        <source>JPG2000</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="299"/>
        <source>emb. PSD</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="305"/>
        <source>Unknown</source>
        <translation type="unfinished">Teadmata</translation>
    </message>
    <message>
        <location filename="../picstatus.cpp" line="194"/>
        <source>RGB</source>
        <translation type="obsolete">RGB</translation>
    </message>
    <message>
        <location filename="../picstatus.cpp" line="197"/>
        <source>CMYK</source>
        <translation type="obsolete">CMYK</translation>
    </message>
    <message>
        <location filename="../picstatus.cpp" line="200"/>
        <source>Grayscale</source>
        <translation type="obsolete">Halltoonid</translation>
    </message>
    <message>
        <location filename="../picstatus.cpp" line="203"/>
        <source>Duotone</source>
        <translation type="obsolete">Duotone</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="322"/>
        <source>n/a</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="83"/>
        <source>Information</source>
        <translation type="unfinished">Info</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="155"/>
        <source>Path:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="198"/>
        <source>Search...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="105"/>
        <source>Name:</source>
        <translation type="unfinished">Nimi:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="215"/>
        <source>Image</source>
        <translation type="unfinished">Pilt</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="288"/>
        <source>DPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="221"/>
        <source>Format:</source>
        <translation type="unfinished">Vorming:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="256"/>
        <source>Colorspace:</source>
        <translation type="unfinished">Värviruum:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="323"/>
        <source>Size</source>
        <translation type="unfinished">Suurus</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="329"/>
        <source>Pixels:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="358"/>
        <source>Scale:</source>
        <translation type="unfinished">Skaleerimine:</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="387"/>
        <source>Printed:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="425"/>
        <source>Layout</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="433"/>
        <source>On Page:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="546"/>
        <source>Select</source>
        <translation type="unfinished">Vali</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="575"/>
        <source>Image Tools</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="623"/>
        <source>Image Visible</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="633"/>
        <source>Image Effects...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="613"/>
        <source>Edit Image...</source>
        <translation type="unfinished">Redigeeri pilti...</translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="600"/>
        <source>Extended Image Properties...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="228"/>
        <source>Sort by Name</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="230"/>
        <source>Sort by Page</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="16"/>
        <source>Manage Images</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="530"/>
        <source>Go to</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="127"/>
        <source>Name of the image file</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="177"/>
        <source>Location where the image file is stored</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="195"/>
        <source>Search for a missing image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="240"/>
        <source>Type of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="253"/>
        <source>The colorspace of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="275"/>
        <source>Colorspace used within the image, eg RGB or CMYK</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="307"/>
        <source>Native resolution of the image, in dots per inch</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="345"/>
        <source>Height and width of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="374"/>
        <source>Horizontal and vertical scaling applied to the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="409"/>
        <source>Size of the image when printed</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="449"/>
        <source>Page that the image is displayed on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="462"/>
        <source>Page Item:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="478"/>
        <source>Name of the page item that contains the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="491"/>
        <source>Effective DPI:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="510"/>
        <source>Effective resolution of the image after scaling</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="527"/>
        <source>Move to the page that the image is on</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="543"/>
        <source>Move to the page that the item is on and select it</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="587"/>
        <source>Enable or disable exporting of the item</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="590"/>
        <source>Export/Print Image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="597"/>
        <source>Set format specfic properties of certain image types, like clipping paths</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="610"/>
        <source>Edit the image in the default editor</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="620"/>
        <source>Make the image visible or invisible</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.ui" line="630"/>
        <source>Apply non destructive effects to the image in its frame</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/picstatus.cpp" line="264"/>
        <source>Embedded Image</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PixmapExportPlugin</name>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="59"/>
        <source>Save as &amp;Image...</source>
        <translation>Salvesta p&amp;ildina...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="78"/>
        <source>Export As Image</source>
        <translation>Eksport pildina</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="79"/>
        <source>Exports selected pages as bitmap images.</source>
        <translation>Ekspordib valitud leheküljed bittrasterpiltidena.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="123"/>
        <source>Save as Image</source>
        <translation type="unfinished">Salvestamine pildina</translation>
    </message>
    <message>
        <location filename="../plugins/pixmapexport/export.cpp" line="130"/>
        <source>Error writing the output file(s).</source>
        <translation type="obsolete">Viga väljundfaili kirjutamisel.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="145"/>
        <source>Export successful</source>
        <translation>Eksport õnnestus</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="118"/>
        <source>The target location %1 must be an existing directory</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/pixmapexport/export.cpp" line="124"/>
        <source>The target location %1 must be writable</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PluginManager</name>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="72"/>
        <source>Cannot find plugin</source>
        <comment>plugin manager</comment>
        <translation>Pluginat ei leitud</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="61"/>
        <source>unknown error</source>
        <comment>plugin manager</comment>
        <translation>tundmatu viga</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="97"/>
        <source>Cannot find symbol (%1)</source>
        <comment>plugin manager</comment>
        <translation>Sümbolit ei leitud (%1)</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="157"/>
        <source>Plugin: loading %1</source>
        <comment>plugin manager</comment>
        <translation>Plugin: %1 laadimine</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="261"/>
        <source>init failed</source>
        <comment>plugin load error</comment>
        <translation>init ebaõnnestus</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="267"/>
        <source>unknown plugin type</source>
        <comment>plugin load error</comment>
        <translation>tundmatu plugina tüüp</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="271"/>
        <source>Plugin: %1 loaded</source>
        <comment>plugin manager</comment>
        <translation>Plugin; %1 laaditud</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="275"/>
        <source>Plugin: %1 failed to load: %2</source>
        <comment>plugin manager</comment>
        <translation>Plugin: %1 laadimine ebaõnnestus: %2</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="341"/>
        <source>Plugin: %1 initialized ok </source>
        <comment>plugin manager</comment>
        <translation>Plugin: %1 initsialiseerimine korras </translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="343"/>
        <source>Plugin: %1 failed post initialization</source>
        <comment>plugin manager</comment>
        <translation>Plugin: %1 ebaõnnestus initsialiseerimise järel</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanager.cpp" line="228"/>
        <source>There is a problem loading %1 of %2 plugins. %3 This is probably caused by some kind of dependency issue or old plugins existing in your install directory. If you clean out your install directory and reinstall and this still occurs, please report it on bugs.scribus.net.</source>
        <translation>Tekkis probleem %1 plugina laadimisel (%2 pluginast). Arvatavasti põhjustas seda mingi sõltuvusprobleem või vanade pluginate olemasolu paigaldamiskataloogis. Kui puhastad paigaldamiskataloogi ja taaspaigaldamisel tekib endiselt probleem, anna sellest palun teada veebisaidil bugs.scribus.net.</translation>
    </message>
</context>
<context>
    <name>PluginManagerPrefsGui</name>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="19"/>
        <source>Plugin Manager</source>
        <translation>Pluginahaldur</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="35"/>
        <source>Plugin</source>
        <translation>Plugin</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="40"/>
        <source>How to run</source>
        <translation>Käivitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="45"/>
        <source>Type</source>
        <translation>Tüüp</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="50"/>
        <source>Load it?</source>
        <translation>Laaditav?</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="55"/>
        <source>Plugin ID</source>
        <translation>Plugina ID</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="60"/>
        <source>File</source>
        <translation>Fail</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Yes</source>
        <translation type="obsolete">Jah</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No</source>
        <translation type="obsolete">Ei</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="68"/>
        <source>You need to restart the application to apply the changes.</source>
        <translation>Muudatuste rakendamiseks tuleb rakendus uuesti käivitada.</translation>
    </message>
    <message>
        <location filename="../../scribus/pluginmanagerprefsgui.ui" line="13"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PolygonProps</name>
    <message>
        <location filename="../../scribus/polyprops.cpp" line="20"/>
        <source>Polygon Properties</source>
        <translation>Hulknurga omadused</translation>
    </message>
</context>
<context>
    <name>PolygonWidget</name>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="55"/>
        <source>Corn&amp;ers:</source>
        <translation type="obsolete">&amp;Nurki:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="75"/>
        <source>&amp;Rotation:</source>
        <translation type="obsolete">Pöö&amp;ramine:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="91"/>
        <source>Apply &amp;Factor</source>
        <translation type="obsolete">Te&amp;guri rakendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="106"/>
        <source> %</source>
        <translation type="obsolete"> %</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="110"/>
        <source>&amp;Factor:</source>
        <translation type="obsolete">Te&amp;gur:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="140"/>
        <source>Number of corners for polygons</source>
        <translation type="obsolete">Hulknurga nurkade arv</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="142"/>
        <source>Degrees of rotation for polygons</source>
        <translation type="obsolete">Hulknurga pööramine kraadides</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="143"/>
        <source>Apply Convex/Concave Factor to change shape of Polygons</source>
        <translation type="obsolete">Nõgususe/kumeruse teguri rakendamine hulknurga kuju muutmiseks</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="144"/>
        <source>Sample Polygon</source>
        <translation type="obsolete">Näidishulknurk</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidget.cpp" line="146"/>
        <source>A negative value will make the polygon concave (or star shaped), a positive value will make it convex</source>
        <translation type="obsolete">Negatiivne väärtus muudab hulknurga nõgusaks (tähekujuliseks), positiivne kumeraks</translation>
    </message>
</context>
<context>
    <name>PolygonWidgetBase</name>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="19"/>
        <source>Form</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="30"/>
        <source>Corn&amp;ers:</source>
        <translation type="unfinished">&amp;Nurki:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="40"/>
        <source>Number of corners for polygons</source>
        <translation type="unfinished">Hulknurga nurkade arv</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="53"/>
        <source>&amp;Rotation:</source>
        <translation type="unfinished">Pöö&amp;ramine:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="76"/>
        <source>Degrees of rotation for polygons</source>
        <translation type="unfinished">Hulknurga pööramine kraadides</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="121"/>
        <source>Sample Polygon</source>
        <translation type="unfinished">Näidishulknurk</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="143"/>
        <source>Apply Convex/Concave Factor to change shape of Polygons</source>
        <translation type="unfinished">Nõgususe/kumeruse teguri rakendamine hulknurga kuju muutmiseks</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="146"/>
        <source>Apply &amp;Factor</source>
        <translation type="unfinished">Te&amp;guri rakendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="161"/>
        <source>&amp;Factor:</source>
        <translation type="unfinished">Te&amp;gur:</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="187"/>
        <source>A negative value will make the polygon concave (or star shaped), a positive value will make it convex</source>
        <translation type="unfinished">Negatiivne väärtus muudab hulknurga nõgusaks (tähekujuliseks), positiivne kumeraks</translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="216"/>
        <source> %</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/polygonwidgetbase.ui" line="206"/>
        <source>C&amp;urvature:</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>Preferences</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom</source>
        <translation type="obsolete">Kohandatud</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="72"/>
        <source>Preferences</source>
        <translation>Seadistused</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>GUI</source>
        <translation type="obsolete">Kasutajaliides</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Language:</source>
        <translation type="obsolete">&amp;Keel:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Theme:</source>
        <translation type="obsolete">&amp;Teema:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show S&amp;plashscreen On Startup:</source>
        <translation type="obsolete">Käivitusekraani &amp;näitamine:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source> pt</source>
        <translation type="obsolete"> pt</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Font Size (Menus):</source>
        <translation type="obsolete">&amp;Fondi suurus (menüüs):</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font Size (&amp;Palettes):</source>
        <translation type="obsolete">Fondi suurus (&amp;palettides):</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Wheel Jump:</source>
        <translation type="obsolete">&amp;Hiireratas kerib:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Recent Documents:</source>
        <translation type="obsolete">V&amp;iimati kasutatud dokumente:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Paths</source>
        <translation type="obsolete">Asukohad</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Documents:</source>
        <translation type="obsolete">&amp;Dokumendid:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Change...</source>
        <translation type="obsolete">&amp;Muuda...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;ICC Profiles:</source>
        <translation type="obsolete">I&amp;CC profiilid:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>C&amp;hange...</source>
        <translation type="obsolete">M&amp;uuda...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Scripts:</source>
        <translation type="obsolete">&amp;Skriptid:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Ch&amp;ange...</source>
        <translation type="obsolete">Muu&amp;da...</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Document T&amp;emplates:</source>
        <translation type="obsolete">Do&amp;kumendimallid:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Cha&amp;nge...</source>
        <translation type="obsolete">Muud&amp;a...</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="75"/>
        <source>General</source>
        <translation>Üldine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Size</source>
        <translation type="obsolete">Lehekülje suurus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Size:</source>
        <translation type="obsolete">&amp;Suurus:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Portrait</source>
        <translation type="obsolete">Püstpaigutus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Landscape</source>
        <translation type="obsolete">Rõhtpaigutus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Orie&amp;ntation:</source>
        <translation type="obsolete">Orie&amp;ntatsioon:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Units:</source>
        <translation type="obsolete">Ühikud:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Width:</source>
        <translation type="obsolete">&amp;Laius:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Height:</source>
        <translation type="obsolete">&amp;Kõrgus:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Margin Guides</source>
        <translation type="obsolete">Veerisejooned</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Autosave</source>
        <translation type="obsolete">Automaatne salvestamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>min</source>
        <translation type="obsolete">min</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Interval:</source>
        <translation type="obsolete">&amp;Intervall:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Undo/Redo</source>
        <translation type="obsolete">Tagasivõtmine/uuestitegemine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Action history length</source>
        <translation type="obsolete">Toimingute ajaloo pikkus</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="78"/>
        <source>Document</source>
        <translation>Dokument</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="81"/>
        <source>Guides</source>
        <translation>Juhtjooned</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="84"/>
        <source>Typography</source>
        <translation>Tüpograafia</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="87"/>
        <source>Tools</source>
        <translation>Tööriistad</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="90"/>
        <source>Hyphenator</source>
        <translation>Poolitaja</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="93"/>
        <source>Fonts</source>
        <translation>Fondid</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="99"/>
        <source>Preflight Verifier</source>
        <translation>Trükieelne kontroll</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="104"/>
        <source>Color Management</source>
        <translation>Värvihaldus</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="119"/>
        <source>PDF Export</source>
        <translation>PDF-i eksport</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="124"/>
        <source>Document Item Attributes</source>
        <translation>Dokumendi elemendi atribuudid</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="129"/>
        <source>Table of Contents and Indexes</source>
        <translation>Sisukord ja registrid</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="132"/>
        <source>Keyboard Shortcuts</source>
        <translation>Kiirklahvid</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Page Display</source>
        <translation type="obsolete">Lehekülje vaade</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color:</source>
        <translation type="obsolete">Värv:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Display &amp;Unprintable Area in Margin Color</source>
        <translation type="obsolete">&amp;Mittetrükitavat ala näidatakse veerise värviga</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Alt+U</source>
        <translation type="obsolete">Alt+U</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Pictures</source>
        <translation type="obsolete">Piltide näitamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Text Chains</source>
        <translation type="obsolete">Tekstiahela näitamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Text Control Characters</source>
        <translation type="obsolete">Mittetrükitavate märkide näitamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Frames</source>
        <translation type="obsolete">Kastide näitamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Rulers relative to Page</source>
        <translation type="obsolete">Joonlauad on seotud leheküljega</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Scratch Space</source>
        <translation type="obsolete">Sodiala</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Top:</source>
        <translation type="obsolete">Ü&amp;lal:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Left:</source>
        <translation type="obsolete">&amp;Vasakul:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Bottom:</source>
        <translation type="obsolete">&amp;All:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Right:</source>
        <translation type="obsolete">&amp;Paremal:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Gaps between Pages</source>
        <translation type="obsolete">Lehekülgede vahe</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Horizontal:</source>
        <translation type="obsolete">Rõhtsuunas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Vertical:</source>
        <translation type="obsolete">Püstsuunas:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Adjust Display Size</source>
        <translation type="obsolete">V&amp;aate suuruse muutmine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>To adjust the display drag the ruler below with the slider.</source>
        <translation type="obsolete">Vaate kohandamiseks lohista allpool joonlaual liugurit.</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="138"/>
        <source>Display</source>
        <translation>Vaade</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="141"/>
        <source>External Tools</source>
        <translation>Välised tööriistad</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Always ask before fonts are replaced when loading a document</source>
        <translation type="obsolete">Dokumendi avamisel küsitakse alati, kas fonte asendada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Preview of current Paragraph Style visible when editing Styles</source>
        <translation type="obsolete">Stiili redigeerimisel näidatakse aktiivse lõigustiili eelvaatlust</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Show Startup Dialog</source>
        <translation type="obsolete">Käivitusdialoogi näitamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lorem Ipsum</source>
        <translation type="obsolete">Lorem Ipsum</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Always use standard Lorem Ipsum</source>
        <translation type="obsolete">Alati kasutatakse standardset Lorem Ipsumit</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Count of the Paragraphs:</source>
        <translation type="obsolete">Lõikude arv:</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="144"/>
        <source>Miscellaneous</source>
        <translation>Muud</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="148"/>
        <source>Plugins</source>
        <translation>Pluginad</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Enable or disable  the display of linked frames.</source>
        <translation type="obsolete">Seotud kastide näitamise lubamine või keelamine.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Display non-printing characters such as paragraph markers in text frames</source>
        <translation type="obsolete">Mittetrükitavate märkide näitamine (nt. lõigutähised tekstikastis)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Turns the display of frames on or off</source>
        <translation type="obsolete">Kastide näitamise lubamine või keelamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Turns the display of pictures on or off</source>
        <translation type="obsolete">Piltide näitamise lubamine või keelamine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Select your default language for Scribus to run with. Leave this blank to choose based on environment variables. You can still override this by passing a command line option when starting Scribus</source>
        <translation type="obsolete">Scribuse vaikimisi töökeele valimine. Tühjaksjätmisel kasutatakse keskkonnamuutujatega määratud väärtust. Seda saab siiski tühistada, kui Scribust käsurealt käivitades vastav võti lisada.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose the default window decoration and looks. Scribus inherits any available KDE or Qt themes, if Qt is configured to search KDE plugins.</source>
        <translation type="obsolete">Akna dekoratsioonide ja välimuse vaikeväärtus. Scribus kasutab kõiki saadaolevaid KDE või Qt teemasid, kui Qt on seadistatud leidma KDE pluginaid.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default font size for the menus and windows</source>
        <translation type="obsolete">Menüüde ja akende fondi vaikesuurus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default font size for the tool windows</source>
        <translation type="obsolete">Tööriistaakende fondi vaikesuurus</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default unit of measurement for document editing</source>
        <translation type="obsolete">Vaikimisi mõõtühik dokumendi redigeerimisel</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of lines Scribus will scroll for each move of the mouse wheel</source>
        <translation type="obsolete">Ridade arv, mille võrra Scribus kerib hiireratta liigutamisel</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Number of recently edited documents to show in the File menu</source>
        <translation type="obsolete">Menüüs Fail näidatavate viimati kasutatud dokumentide arv</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default documents directory</source>
        <translation type="obsolete">Dokumentide vaikimisi kataloog</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default ICC profiles directory. This cannot be changed with a document open. By default, Scribus will look in the System Directories under Mac OSX and Windows. On Linux and Unix, Scribus will search $home/.color/icc,/usr/share/color/icc and /usr/local/share/color/icc </source>
        <translation type="obsolete">ICC profiilide vaikimisi kataloog. Seda ei saa muuta, kui mõni dokument on avatud. Vaikimisi otsib Scribus neid Mac OS X ja Windowsi korral süsteemsetest kataloogidest. Linuxi ja Unixi korral otsib Scribus neid kataloogidest $home/.color/icc,/usr/share/color/icc ja /usr/local/share/color/icc.(sp)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default Scripter scripts directory</source>
        <translation type="obsolete">Skriptija vaikimisi skriptide kataloog</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Additional directory for document templates</source>
        <translation type="obsolete">Täiendav dokumendimallide kataloog</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default page size, either a standard size or a custom size</source>
        <translation type="obsolete">Dokumendi lehekülje suurus: kas mõni standardne või kohandatud</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Default orientation of document pages</source>
        <translation type="obsolete">Dokumendi lehekülgede vaikimisi orientatsioon</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Width of document pages, editable if you have chosen a custom page size</source>
        <translation type="obsolete">Dokumendi lehekülgede laius. Kui valisid kohandatud suuruse, saab seda muuta.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Height of document pages, editable if you have chosen a custom page size</source>
        <translation type="obsolete">Dokumendi lehekülgede kõrgus. Kui valisid kohandatud suuruse, saab seda muuta.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>When enabled, Scribus saves a backup copy of your file with the .bak extension each time the time period elapses</source>
        <translation type="obsolete">Sisselülitamise korral salvestab Scribus määratud aja möödumisel alati varukoopia laiendiga .bak</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Time period between saving automatically</source>
        <translation type="obsolete">Automaatsete salvestamiste intervall</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set the length of the action history in steps. If set to 0 infinite amount of actions will be stored.</source>
        <translation type="obsolete">Toimingute ajaloo pikkus sammudes. 0 tähendab, et salvestatakse piiramatu hulk toiminguid.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Color for paper</source>
        <translation type="obsolete">Paberi värv</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Mask the area outside the margins in the margin color</source>
        <translation type="obsolete">Veeristest väljapoole jäävale alale antakse veerise värv</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Set the default zoom level</source>
        <translation type="obsolete">Vaikimisi suurendustaseme määramine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Place a ruler against your screen and drag the slider to set the zoom level so Scribus will display your pages and objects on them at the correct size</source>
        <translation type="obsolete">Liugurit lohistades saab kindlaks määrata vajaliku suurendustaseme, millega Scribus näitab lehekülgi ja objekte</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Defines amount of space left of the document canvas available as a pasteboard for creating and modifying elements and dragging them onto the active page</source>
        <translation type="obsolete">Määrab ruumi suuruse vasakul pool dokumendiala, mida saab kasutada lõikelauana elementide loomiseks ja muutmiseks ja kust neid saab aktiivsele leheküljele lohistada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Defines amount of space right of the document canvas available as a pasteboard for creating and modifying elements and dragging them onto the active page</source>
        <translation type="obsolete">Määrab ruumi suuruse paremal pool dokumendiala, mida saab kasutada lõikelauana elementide loomiseks ja muutmiseks ja kust neid saab aktiivsele leheküljele lohistada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Defines amount of space above the document canvas available as a pasteboard for creating and modifying elements and dragging them onto the active page</source>
        <translation type="obsolete">Määrab ruumi suuruse dokumendiala kohal, mida saab kasutada lõikelauana elementide loomiseks ja muutmiseks ja kust neid saab aktiivsele leheküljele lohistada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Defines amount of space below the document canvas available as a pasteboard for creating and modifying elements and dragging them onto the active page</source>
        <translation type="obsolete">Määrab ruumi suuruse dokumendiala all, mida saab kasutada lõikelauana elementide loomiseks ja muutmiseks ja kust neid saab aktiivsele leheküljele lohistada</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Choose a Directory</source>
        <translation type="obsolete">Kataloogi valik</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="135"/>
        <source>Scrapbook</source>
        <translation>Visandimapp</translation>
    </message>
    <message>
        <location filename="../../scribus/prefs.cpp" line="96"/>
        <source>Printer</source>
        <translation type="unfinished">Printer</translation>
    </message>
</context>
<context>
    <name>PrefsDialogBase</name>
    <message>
        <location filename="" line="136966688"/>
        <source>Save...</source>
        <translation type="obsolete">Salvesta...</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="191"/>
        <source>&amp;Defaults</source>
        <translation>&amp;Vaikeväärtused</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="200"/>
        <source>Save Preferences</source>
        <translation>Seadistuste salvestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="190"/>
        <source>Export...</source>
        <translation>Ekspordi...</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="192"/>
        <source>&amp;Apply</source>
        <translation>&amp;Rakenda</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="193"/>
        <source>All preferences can be reset here</source>
        <translation>Siin saab lähtestada kõik seadistused</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="194"/>
        <source>Apply all changes without closing the dialog</source>
        <translation>Kõigi muudatuste rakendamine ilma dialoogi sulgemata</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsdialogbase.cpp" line="195"/>
        <source>Export current preferences into file</source>
        <translation>Kehtivate seadistuste eksportimine faili</translation>
    </message>
</context>
<context>
    <name>PrefsManager</name>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2055"/>
        <source>PostScript</source>
        <translation>PostScript</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="809"/>
        <source>Migrate Old Scribus Settings?</source>
        <translation>Kas migreerida Scribuse vanad seadistused?</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="811"/>
        <source>Scribus has detected existing Scribus 1.2 preferences files.
Do you want to migrate them to the new Scribus version?</source>
        <translation>Scribus tuvastas Scribus 1.2 seadistustefailide olemasolu.
Kas soovid need migreerida Scribuse uude versiooni?</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1684"/>
        <source>Could not open preferences file &quot;%1&quot; for writing: %2</source>
        <translation>Seadistustefaili &quot;%1&quot; avamine kirjutamiseks ebaõnnestus: %2</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1696"/>
        <source>Writing to preferences file &quot;%1&quot; failed: QIODevice status code %2</source>
        <translation>Seadistustefaili &quot;%1&quot; kirjutamine ebaõnnestus: QIODevice olekukood %2</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1710"/>
        <source>Failed to open prefs file &quot;%1&quot;: %2</source>
        <translation>Seadistustefaili &quot;%1&quot; avamine ebaõnnestus: %2</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="1720"/>
        <source>Failed to read prefs XML from &quot;%1&quot;: %2 at line %3, col %4</source>
        <translation>Seadistuste XML-i lugemine failist &quot;%1&quot; ebaõnnestus: %2 real %3, veerus %4</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2055"/>
        <source>Postscript</source>
        <translation>PostScript</translation>
    </message>
    <message>
        <location filename="../prefsmanager.cpp" line="2099"/>
        <source>PDF 1.3</source>
        <translation type="obsolete">PDF 1.3</translation>
    </message>
    <message>
        <location filename="../prefsmanager.cpp" line="2101"/>
        <source>PDF 1.4</source>
        <translation type="obsolete">PDF 1.4</translation>
    </message>
    <message>
        <location filename="../prefsmanager.cpp" line="2106"/>
        <source>PDF/X-3</source>
        <translation type="obsolete">PDF/X-3</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2393"/>
        <source>Error Writing Preferences</source>
        <translation>Viga seadistuste salvestamisel</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2399"/>
        <source>Scribus was not able to save its preferences:&lt;br&gt;%1&lt;br&gt;Please check file and directory permissions and available disk space.</source>
        <comment>scribus app error</comment>
        <translation>Scribus ei suutnud seadistusi salvestada:&lt;br&gt;%1&lt;br&gt;Palun kontrolli faili ja kataloogi õigusi ning kettaruumi.</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2412"/>
        <source>Error Loading Preferences</source>
        <translation>Viga seadistuste laadimisel</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2417"/>
        <source>Scribus was not able to load its preferences:&lt;br&gt;%1&lt;br&gt;Default settings will be loaded.</source>
        <translation>Scribus ei suutnud seadistusi laadida:&lt;br&gt;%1&lt;br&gt;Laaditakse vaikeseadistused.</translation>
    </message>
    <message>
        <location filename="../prefsmanager.cpp" line="2102"/>
        <source>PDF 1.5</source>
        <translation type="obsolete">PDF 1.5</translation>
    </message>
    <message>
        <location filename="../../scribus/prefsmanager.cpp" line="2125"/>
        <source>No valid renderframe config found. Using defaults!</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PresetLayout</name>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="553"/>
        <source>None</source>
        <comment>layout type</comment>
        <translation>Puudub</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="554"/>
        <source>Gutenberg</source>
        <translation>Gutenberg</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="555"/>
        <source>Magazine</source>
        <translation>Ajakiri</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="556"/>
        <source>Fibonacci</source>
        <translation>Fibonacci</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="557"/>
        <source>Golden Mean</source>
        <translation>Kuldne keskmine</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="558"/>
        <source>Nine Parts</source>
        <translation>Üheksa osa</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>You can select predefined page layout here. &apos;None&apos; leave margins as is, Gutenberg sets margins classically. &apos;Magazine&apos; sets all margins for same value. Leading is Left/Inside value.</source>
        <translation type="obsolete">Siin saab valida lehekülje valmispaigutuse. &apos;Puudub&apos; jätab veerised endiseks, Gutenberg määratleb need klassikaliselt, &apos;Magazine&apos; aga kõik veerised võrdseks. Aluseks võetakse vasak/sisemise veerise väärtus.</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="490"/>
        <source>You can select a predefined page layout here. &apos;None&apos; leave margins as is, Gutenberg sets margins classically. &apos;Magazine&apos; sets all margins for same value. Leading is Left/Inside value.</source>
        <translation type="obsolete">Siin saab valida eelmääratud kujunduse. &apos;Puudub&apos; jätab veerised puutumata, Gutenberg kehtestab klassikalised veerised, &apos;Ajakiri&apos; määrab kõigile veeristele sama väärtuse. Aluseks võetakse vasaku/sisemise veerise väärtus.</translation>
    </message>
    <message>
        <location filename="../../scribus/marginwidget.cpp" line="561"/>
        <source>When you have selected a Document Layout other than Single Page, you can select a predefined page layout here. &apos;None&apos; leaves margins as is, Gutenberg sets margins classically. &apos;Magazine&apos; sets all margins to the same value. Leading is Left/Inside value.</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PrintDialog</name>
    <message>
        <location filename="../printdialog.cpp" line="67"/>
        <source>Setup Printer</source>
        <translation type="obsolete">Printeri seadistused</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="74"/>
        <source>Print Destination</source>
        <translation type="obsolete">Trükkimise sihtkoht</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="563"/>
        <source>File</source>
        <translation>Fail</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="89"/>
        <source>&amp;Options...</source>
        <translation type="obsolete">&amp;Valikud...</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="100"/>
        <source>&amp;File:</source>
        <translation type="obsolete">&amp;Fail:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="106"/>
        <source>C&amp;hange...</source>
        <translation type="obsolete">&amp;Muuda...</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="113"/>
        <source>A&amp;lternative Printer Command</source>
        <translation type="obsolete">Al&amp;ternatiivne trükkimiskäsk</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="122"/>
        <source>Co&amp;mmand:</source>
        <translation type="obsolete">Kä&amp;sk:</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="130"/>
        <source>Range</source>
        <translation type="obsolete">Vahemik</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="135"/>
        <source>Print &amp;All</source>
        <translation type="obsolete">&amp;Kõik</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="373"/>
        <source>Print Current Pa&amp;ge</source>
        <translation>&amp;Aktiivne lehekülg</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="139"/>
        <source>Print &amp;Range</source>
        <translation type="obsolete">T&amp;rükkimisvahemik</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="159"/>
        <source>N&amp;umber of Copies:</source>
        <translation type="obsolete">Koo&amp;piate arv:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="334"/>
        <source>Print Normal</source>
        <translation>Normaalne trükk</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="172"/>
        <source>Print Separations</source>
        <translation type="obsolete">Trükkimine separeeritult</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="176"/>
        <source>Print in Color if Available</source>
        <translation type="obsolete">Värvitrükk (kui võimalik)</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="177"/>
        <source>Print in Grayscale</source>
        <translation type="obsolete">Halltoonis trükk</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="507"/>
        <source>All</source>
        <translation>Kõik</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="506"/>
        <source>Cyan</source>
        <translation>Tsüaan</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="505"/>
        <source>Magenta</source>
        <translation>Magenta</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="504"/>
        <source>Yellow</source>
        <translation>Kollane</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="503"/>
        <source>Black</source>
        <translation>Must</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="221"/>
        <source>PostScript Level 1</source>
        <translation type="obsolete">PostScript tase 1</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="222"/>
        <source>PostScript Level 2</source>
        <translation type="obsolete">PostScript tase 2</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="223"/>
        <source>PostScript Level 3</source>
        <translation type="obsolete">PostScript tase 3</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="190"/>
        <source>Options</source>
        <translation type="obsolete">Valikud</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="196"/>
        <source>Page</source>
        <translation type="obsolete">Lehekülg</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="202"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation type="obsolete">Lehekülgede peegeldamine rõhtsalt</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="205"/>
        <source>Mirror Page(s) Vertical</source>
        <translation type="obsolete">Lehekülgede peegeldamine püstiselt</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="208"/>
        <source>Set Media Size</source>
        <translation type="obsolete">Andmekandja suuruse määramine</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="210"/>
        <source>Clip to Page Margins</source>
        <translation type="obsolete">Kärpimine lehekülje veeriste juures</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="214"/>
        <source>Color</source>
        <translation type="obsolete">Värv</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="220"/>
        <source>Apply Under Color Removal</source>
        <translation type="obsolete">UCR-i (Under Color Removal) rakendamine</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="223"/>
        <source>Convert Spot Colors to Process Colors</source>
        <translation type="obsolete">Spot-värvide teisendamine protsessivärvideks</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="226"/>
        <source>Force Overprint Mode</source>
        <translation type="obsolete">Ületrükirežiim</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="263"/>
        <source>Apply ICC Profiles</source>
        <translation type="obsolete">ICC profiilide rakendamine</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="232"/>
        <source>Advanced Options</source>
        <translation type="obsolete">Muud valikud</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="303"/>
        <source>Preview...</source>
        <translation type="obsolete">Eelvaatlus...</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="308"/>
        <source>&amp;Print</source>
        <translation type="obsolete">&amp;Trüki</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="375"/>
        <source>Do not show objects outside the margins on the printed page</source>
        <translation type="obsolete">Trükitava lehekülje veeristest väljapoole jäävaid objekte ei näidata</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="378"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation type="obsolete">Sisesta komadega eradatud arvud või märgid:
* tähistab kõiki lehekülgi, 1-5 lehekülgede vahemikku,
konkreetsed leheküljenumbrid vastavaid lehekülgi.</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="379"/>
        <source>Use an alternative print manager, such as kprinter or gtklp, to utilize additional printing options</source>
        <translation type="obsolete">Alternatiivse trükkimishalduri (nt. kprinter või gtklp) kasutamine täiendavate trükkimisvalikute huvides</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="380"/>
        <source>Sets the PostScript Level.
 Setting to Level 1 or 2 can create huge files</source>
        <translation type="obsolete">PostScripti taseme määramine.
Tase 1 või 2 võib tekitada hiiglaslikud failid.</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="381"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis.UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="obsolete">Võimalus lülitada välja mõningad tsüaanist, kollasest ja magentast koosnevad halli toonid ning kasutada selle asemel musta. UCR mõjutab kõige rohkem piltide neid osi, kus valitsevad neutraalsed ja/või tumedad toonid, mis on suhteliselt lähedal hallile. Selle valiku kasutamisel võib paraneda mõningate piltide trükikvaliteet, kuid alati tuleb seda katse-eksituse meetodil ise järele proovida. UCR vähendab üleküllastuse võimalust CMY värvides.</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="382"/>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation type="obsolete">Sisselülitamisel teisendatakse spot-värvid komposiitvärvideks. Kui sa ei kavatse just saata trükikotta spot-värve, on mõttekas see sisse lülitada.</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="383"/>
        <source>Enables global Overprint Mode for this document, overrides object settings</source>
        <translation type="obsolete">Sisselülitamisel kehtestatakse dokumendile üldine ületrükirežiim, mis tühistab objektide määratlused</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="383"/>
        <source>Allows you to embed ICC profiles in the print stream when color management is enabled</source>
        <translation type="obsolete">Võimaldab värvihalduse korral põimida trükkimisandmetesse ICC profiilid</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="385"/>
        <source>This enables you to explicitely set the media size of the PostScript file. Not recommended unless requested by your printer.</source>
        <translation type="obsolete">Võimaldab konkreetselt määrata kindlaks PostScript-faili andmekandja (paberi, kile vms.) suuruse. Kui printer seda otseselt ei nõua, ei ole seda mõtet sisse lülitada.</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="309"/>
        <source>Failed to retrieve printer settings</source>
        <translation>Printeri seadistuste hankimine ebaõnnestus</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="359"/>
        <source>Save as</source>
        <translation type="obsolete">Salvestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="359"/>
        <source>PostScript Files (*.ps);;All Files (*)</source>
        <translation>PostScript-failid (*.ps);;Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="286"/>
        <source>Right:</source>
        <translation type="obsolete">Paremal:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="103"/>
        <source>Inside:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="104"/>
        <source>Outside:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="391"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="obsolete">Lõikevaru füüsilise lehekülje ülaservas</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="392"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="obsolete">Lõikevaru füüsilise lehekülje allservas</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="393"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="obsolete">Lõikevaru füüsilise lehekülje vasakus servas</translation>
    </message>
    <message>
        <location filename="../printdialog.cpp" line="394"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="obsolete">Lõikevaru füüsilise lehekülje paremas servas</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialog.cpp" line="359"/>
        <source>Save As</source>
        <translation type="unfinished">Salvestamine</translation>
    </message>
</context>
<context>
    <name>PrintDialogBase</name>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="13"/>
        <source>Setup Printer</source>
        <translation type="unfinished">Printeri seadistused</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="22"/>
        <source>Print Destination</source>
        <translation type="unfinished">Trükkimise sihtkoht</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="49"/>
        <source>&amp;Options...</source>
        <translation type="unfinished">&amp;Valikud...</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="85"/>
        <source>&amp;File:</source>
        <translation type="unfinished">&amp;Fail:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="101"/>
        <source>C&amp;hange...</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="116"/>
        <source>Use an alternative print manager, such as kprinter or gtklp, to utilize additional printing options</source>
        <translation type="unfinished">Alternatiivse trükkimishalduri (nt. kprinter või gtklp) kasutamine täiendavate trükkimisvalikute huvides</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="119"/>
        <source>A&amp;lternative Printer Command</source>
        <translation type="unfinished">Al&amp;ternatiivne trükkimiskäsk</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="137"/>
        <source>Co&amp;mmand:</source>
        <translation type="unfinished">Kä&amp;sk:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="159"/>
        <source>Range</source>
        <translation type="unfinished">Vahemik</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="171"/>
        <source>Print &amp;All</source>
        <translation type="unfinished">&amp;Kõik</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="191"/>
        <source>N&amp;umber of Copies:</source>
        <translation type="unfinished">Koo&amp;piate arv:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="211"/>
        <source>Print Current Pa&amp;ge</source>
        <translation type="unfinished">&amp;Aktiivne lehekülg</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="218"/>
        <source>Print &amp;Range</source>
        <translation type="unfinished">T&amp;rükkimisvahemik</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="228"/>
        <source>Insert a comma separated list of tokens where
a token can be * for all the pages, 1-5 for
a range of pages or a single page number.</source>
        <translation type="unfinished">Sisesta komadega eradatud arvud või märgid:
* tähistab kõiki lehekülgi, 1-5 lehekülgede vahemikku,
konkreetsed leheküljenumbrid vastavaid lehekülgi.</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="273"/>
        <source>Options</source>
        <translation type="unfinished">Valikud</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="280"/>
        <source>Print Normal</source>
        <translation type="unfinished">Normaalne trükk</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="285"/>
        <source>Print Separations</source>
        <translation type="unfinished">Trükkimine separeeritult</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="294"/>
        <source>Print in Color if Available</source>
        <translation type="unfinished">Värvitrükk (kui võimalik)</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="299"/>
        <source>Print in Grayscale</source>
        <translation type="unfinished">Halltoonis trükk</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="314"/>
        <source>Sets the PostScript Level.
 Setting to Level 1 or 2 can create huge files</source>
        <translation type="unfinished">PostScripti taseme määramine.
Tase 1 või 2 võib tekitada hiiglaslikud failid.</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="334"/>
        <source>Advanced Options</source>
        <translation type="unfinished">Muud valikud</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="340"/>
        <source>Page</source>
        <translation type="unfinished">Lehekülg</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="346"/>
        <source>Mirror Page(s) Horizontal</source>
        <translation type="unfinished">Lehekülgede peegeldamine rõhtsalt</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="353"/>
        <source>Mirror Page(s) Vertical</source>
        <translation type="unfinished">Lehekülgede peegeldamine püstiselt</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="360"/>
        <source>This enables you to explicitely set the media size of the PostScript file. Not recommended unless requested by your printer.</source>
        <translation type="obsolete">Võimaldab konkreetselt määrata kindlaks PostScript-faili andmekandja (paberi, kile vms.) suuruse. Kui printer seda otseselt ei nõua, ei ole seda mõtet sisse lülitada.</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="363"/>
        <source>Set Media Size</source>
        <translation type="unfinished">Andmekandja suuruse määramine</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="370"/>
        <source>Clip to Page Margins</source>
        <translation type="obsolete">Kärpimine lehekülje veeriste juures</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="380"/>
        <source>Color</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="386"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis.UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="obsolete">Võimalus lülitada välja mõningad tsüaanist, kollasest ja magentast koosnevad halli toonid ning kasutada selle asemel musta. UCR mõjutab kõige rohkem piltide neid osi, kus valitsevad neutraalsed ja/või tumedad toonid, mis on suhteliselt lähedal hallile. Selle valiku kasutamisel võib paraneda mõningate piltide trükikvaliteet, kuid alati tuleb seda katse-eksituse meetodil ise järele proovida. UCR vähendab üleküllastuse võimalust CMY värvides.</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="389"/>
        <source>Apply Under Color Removal</source>
        <translation type="unfinished">UCR-i (Under Color Removal) rakendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="396"/>
        <source>Enables Spot Colors to be converted to composite colors. Unless you are planning to print spot colors at a commercial printer, this is probably best left enabled.</source>
        <translation type="unfinished">Sisselülitamisel teisendatakse spot-värvid komposiitvärvideks. Kui sa ei kavatse just saata trükikotta spot-värve, on mõttekas see sisse lülitada.</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="399"/>
        <source>Convert Spot Colors to Process Colors</source>
        <translation type="unfinished">Spot-värvide teisendamine protsessivärvideks</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="416"/>
        <source>Enables global Overprint Mode for this document, overrides object settings</source>
        <translation type="obsolete">Sisselülitamisel kehtestatakse dokumendile üldine ületrükirežiim, mis tühistab objektide määratlused</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="419"/>
        <source>Force Overprint Mode</source>
        <translation type="obsolete">Ületrükirežiim</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="406"/>
        <source>Allows you to embed color profiles in the print stream when color management is enabled</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="409"/>
        <source>Apply Color Profiles</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="436"/>
        <source>Marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="442"/>
        <source>This creates crop marks in the PDF indicating where the paper should be cut or trimmed after printing</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="445"/>
        <source>Crop Marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="452"/>
        <source>Add registration marks which are added to each separation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="455"/>
        <source>Registration Marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="462"/>
        <source>This creates bleed marks which are indicated by  _ . _ and show the bleed limit</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="465"/>
        <source>Bleed Marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="472"/>
        <source>Add color calibration bars</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="475"/>
        <source>Color Bars</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="484"/>
        <source>Offset:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="491"/>
        <source>Indicate the distance offset for the registration marks</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="514"/>
        <source>Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="520"/>
        <source>Top:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="527"/>
        <source>Distance for bleed from the top of the physical page</source>
        <translation type="unfinished">Lõikevaru füüsilise lehekülje ülaservas</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="534"/>
        <source>Left:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="541"/>
        <source>Distance for bleed from the right of the physical page</source>
        <translation type="unfinished">Lõikevaru füüsilise lehekülje paremas servas</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="548"/>
        <source>Bottom:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="555"/>
        <source>Distance for bleed from the bottom of the physical page</source>
        <translation type="unfinished">Lõikevaru füüsilise lehekülje allservas</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="562"/>
        <source>Right:</source>
        <translation type="unfinished">Paremal:</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="569"/>
        <source>Distance for bleed from the left of the physical page</source>
        <translation type="unfinished">Lõikevaru füüsilise lehekülje vasakus servas</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="576"/>
        <source>Use the existing bleed settings from the document preferences</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="579"/>
        <source>Use Document Bleeds</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="605"/>
        <source>Preview...</source>
        <translation type="unfinished">Eelvaatlus...</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="615"/>
        <source>&amp;Print</source>
        <translation type="unfinished">&amp;Trüki</translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="625"/>
        <source>Cancel</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="322"/>
        <source>Include PDF Annotations and Links into the output.
Note: PDF Forms will not be exported.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="326"/>
        <source>Include PDF Annotations and Links</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="360"/>
        <source>This enables you to explicitly set the media size of the PostScript file. Not recommended unless requested by your printer.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="370"/>
        <source>Clip to Printer Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/printdialogbase.ui" line="386"/>
        <source>A way of switching off some of the gray shades which are composed of cyan, yellow and magenta and using black instead. UCR most affects parts of images which are neutral and/or dark tones which are close to the gray. Use of this may improve printing some images and some experimentation and testing is need on a case by case basis. UCR reduces the possibility of over saturation with CMY inks.</source>
        <translation type="unfinished">Võimalus lülitada välja mõningad tsüaanist, kollasest ja magentast koosnevad halli toonid ning kasutada selle asemel musta. UCR mõjutab kõige rohkem piltide neid osi, kus valitsevad neutraalsed ja/või tumedad toonid, mis on suhteliselt lähedal hallile. Selle valiku kasutamisel võib paraneda mõningate piltide trükikvaliteet, kuid alati tuleb seda katse-eksituse meetodil ise järele proovida. UCR vähendab üleküllastuse võimalust CMY värvides.</translation>
    </message>
</context>
<context>
    <name>PropertiesPalette</name>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5019"/>
        <source>Fixed Linespacing</source>
        <translation>Fikseeritud reavahe</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5020"/>
        <source>Automatic Linespacing</source>
        <translation>Automaatne reavahe</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5021"/>
        <source>Align to Baseline Grid</source>
        <translation>Joondamine alusjoontele</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3869"/>
        <source>&amp;X1:</source>
        <translation>&amp;X1:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3870"/>
        <source>X&amp;2:</source>
        <translation>X&amp;2:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3871"/>
        <source>Y&amp;1:</source>
        <translation>Y&amp;1:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3872"/>
        <source>&amp;Y2:</source>
        <translation>&amp;Y2:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5005"/>
        <source>&amp;X-Pos:</source>
        <translation>&amp;X-asukoht:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4904"/>
        <source>&amp;Width:</source>
        <translation>&amp;Laius:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5006"/>
        <source>&amp;Y-Pos:</source>
        <translation>&amp;Y-asukoht:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4905"/>
        <source>&amp;Height:</source>
        <translation>&amp;Kõrgus:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5293"/>
        <source>Distance between columns</source>
        <translation>Veergude vahe</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3633"/>
        <source>Column width</source>
        <translation>Veeru laius</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5120"/>
        <source>No Style</source>
        <translation>Stiil puudub</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4766"/>
        <source>Name &quot;%1&quot; isn&apos;t unique.&lt;br/&gt;Please choose another.</source>
        <translation>Nimi &quot;%1&quot; ei ole unikaalne.&lt;br/&gt;Palun vali mõni muu nimi.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4890"/>
        <source>Properties</source>
        <translation>Omadused</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4892"/>
        <source>X, Y, &amp;Z</source>
        <translation>X, Y, &amp;Z</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4893"/>
        <source>&amp;Text</source>
        <translation>&amp;Tekst</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4894"/>
        <source>&amp;Image</source>
        <translation>P&amp;ilt</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4895"/>
        <source>&amp;Shape</source>
        <translation>&amp;Kujund</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4896"/>
        <source>&amp;Line</source>
        <translation>&amp;Joon</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4897"/>
        <source>&amp;Colors</source>
        <translation>&amp;Värvid</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4900"/>
        <source>Name</source>
        <translation>Nimi</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4901"/>
        <source>Geometry</source>
        <translation>Geomeetria</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4906"/>
        <source>&amp;Rotation:</source>
        <translation>Pöö&amp;ramine:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4907"/>
        <source>Basepoint:</source>
        <translation>Baaspunkt:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4908"/>
        <source>Level</source>
        <translation>Tase</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4914"/>
        <source>Shape:</source>
        <translation>Kujund:</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4341"/>
        <source>&amp;Edit Shape...</source>
        <translation type="obsolete">&amp;Muuda kuju...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4934"/>
        <source>R&amp;ound
Corners:</source>
        <translation>Ümarad
n&amp;urgad:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4923"/>
        <source>Distance of Text</source>
        <translation type="obsolete">Teksti kaugus</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4935"/>
        <source>Colu&amp;mns:</source>
        <translation>V&amp;eergude arv:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Gap:</source>
        <translation type="obsolete">Va&amp;he:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4942"/>
        <source>To&amp;p:</source>
        <translation>Ü&amp;lal:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4943"/>
        <source>&amp;Bottom:</source>
        <translation>&amp;All:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4944"/>
        <source>&amp;Left:</source>
        <translation>&amp;Vasakul:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4945"/>
        <source>&amp;Right:</source>
        <translation>&amp;Paremal:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4946"/>
        <source>T&amp;abulators...</source>
        <translation>&amp;Tabeldusmärgid...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5000"/>
        <source>Path Text Properties</source>
        <translation>Trajektoori teksti omadused</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4953"/>
        <source>Show Curve</source>
        <translation>Trajektoori näitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4955"/>
        <source>Start Offset:</source>
        <translation>Alguse nihe:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4956"/>
        <source>Distance from Curve:</source>
        <translation>Kaugus trajektoorist:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4957"/>
        <source>Fill Rule</source>
        <translation>Täitmise reegel</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4958"/>
        <source>Even-Odd</source>
        <translation>Paaris-paaritu</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4959"/>
        <source>Non Zero</source>
        <translation>Mittenull</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Text &amp;Flows Around Frame</source>
        <translation type="obsolete">Teksti&amp;voog ümber kasti</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4969"/>
        <source>Use &amp;Bounding Box</source>
        <translation>Üm&amp;britsev kast</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4970"/>
        <source>&amp;Use Contour Line</source>
        <translation>Kont&amp;uurjoon</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>St&amp;yle:</source>
        <translation type="obsolete">St&amp;iil:</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Lan&amp;guage:</source>
        <translation type="obsolete">&amp;Keel:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5002"/>
        <source>&amp;Free Scaling</source>
        <translation>&amp;Vaba skaleerimine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5003"/>
        <source>Actual X-DPI:</source>
        <translation>Tegelik X-DPI:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5004"/>
        <source>Actual Y-DPI:</source>
        <translation>Tegelik Y-DPI:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5007"/>
        <source>X-Sc&amp;ale:</source>
        <translation>X-sk&amp;aala:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5008"/>
        <source>Y-Scal&amp;e:</source>
        <translation>Y-s&amp;kaala:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5009"/>
        <source>Scale &amp;To Frame Size</source>
        <translation>Skaleerimine kas&amp;ti suuruse järgi</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5010"/>
        <source>P&amp;roportional</source>
        <translation>P&amp;roportsionaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5013"/>
        <source>Input Profile:</source>
        <translation>Sisendprofiil:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5014"/>
        <source>Rendering Intent:</source>
        <translation>Renderdamisviis:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5024"/>
        <source>Perceptual</source>
        <translation>Pertseptuaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5025"/>
        <source>Relative Colorimetric</source>
        <translation>Suhteline kolorimeetriline</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5026"/>
        <source>Saturation</source>
        <translation>Küllastus</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5027"/>
        <source>Absolute Colorimetric</source>
        <translation>Absoluutne kolorimeetriline</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5036"/>
        <source>Left Point</source>
        <translation>Vasak ots</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5037"/>
        <source>End Points</source>
        <translation>Otspunktid</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5039"/>
        <source>&amp;Basepoint:</source>
        <translation>&amp;Baaspunkt:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5040"/>
        <source>T&amp;ype of Line:</source>
        <translation>&amp;Joone tüüp:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5041"/>
        <source>Start Arrow:</source>
        <translation>Algusnool:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5042"/>
        <source>End Arrow:</source>
        <translation>Lõppnool:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5052"/>
        <source>Line &amp;Width:</source>
        <translation>J&amp;oone jämedus:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5053"/>
        <source>Ed&amp;ges:</source>
        <translation>Se&amp;rvad:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5056"/>
        <source>Miter Join</source>
        <translation>Nurkühendus</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5057"/>
        <source>Bevel Join</source>
        <translation>Längühendus</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5058"/>
        <source>Round Join</source>
        <translation>Ümarühendus</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5063"/>
        <source>Flat Cap</source>
        <translation>Lameots</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5064"/>
        <source>Square Cap</source>
        <translation>Ruutots</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5065"/>
        <source>Round Cap</source>
        <translation>Ümarots</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5067"/>
        <source>&amp;Endings:</source>
        <translation>&amp;Otsad:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5069"/>
        <source>Cell Lines</source>
        <translation>Lahtri jooned</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5070"/>
        <source>Line at Top</source>
        <translation>Joon üleval</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5071"/>
        <source>Line at the Left</source>
        <translation>Joon vasakul</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5072"/>
        <source>Line at the Right </source>
        <translation>Joon paremal </translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5073"/>
        <source>Line at Bottom</source>
        <translation>Joon all</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5075"/>
        <source>Overprinting</source>
        <translation>Ületrükk</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5076"/>
        <source>Knockout</source>
        <translation>Väljajätmine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5077"/>
        <source>Overprint</source>
        <translation>Ületrükk</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5079"/>
        <source> %</source>
        <translation> %</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5093"/>
        <source> pt</source>
        <translation> pt</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5215"/>
        <source>Name of selected object</source>
        <translation>Valitud objekti nimi</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5216"/>
        <source>Horizontal position of current basepoint</source>
        <translation>Aktiivse baaspunkti asukoht rõhtteljel</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5217"/>
        <source>Vertical position of current basepoint</source>
        <translation>Aktiivse baaspunkti asukoht püstteljel</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5218"/>
        <source>Width</source>
        <translation>Laius</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5219"/>
        <source>Height</source>
        <translation>Kõrgus</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5220"/>
        <source>Rotation of object at current basepoint</source>
        <translation>Objekti pööramine aktiivse baaspunkti suhtes</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5221"/>
        <source>Point from which measurements or rotation angles are referenced</source>
        <translation>Punkt, millest arvestatakse mõõte või pööramisnurka</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4783"/>
        <source>Select top left for basepoint</source>
        <translation type="obsolete">Vali baaspunktiks ülemine vasak punkt</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4784"/>
        <source>Select top right for basepoint</source>
        <translation type="obsolete">Vali baaspunktiks ülemine parem punkt</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4785"/>
        <source>Select bottom left for basepoint</source>
        <translation type="obsolete">Vali baaspunktiks alumine vasak punkt</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4786"/>
        <source>Select bottom right for basepoint</source>
        <translation type="obsolete">Vali baaspunktiks alumine parem punkt</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4787"/>
        <source>Select center for basepoint</source>
        <translation type="obsolete">Vali baaspunktiks keskpunkt</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5229"/>
        <source>Flip Horizontal</source>
        <translation>Peegelda rõhtsalt</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5230"/>
        <source>Flip Vertical</source>
        <translation>Peegelda püstiselt</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5231"/>
        <source>Move one level up</source>
        <translation>Liiguta üks tase ettepoole</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5232"/>
        <source>Move one level down</source>
        <translation>Liiguta üks tase tahapoole</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5233"/>
        <source>Move to front</source>
        <translation>Liiguta kõige ette</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5234"/>
        <source>Move to back</source>
        <translation>Liiguta kõige taha</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5235"/>
        <source>Indicates the level the object is on, 0 means the object is at the bottom</source>
        <translation>Tähistab taset, millel objekt asub. 0 tähendab, et objekt asub kõige all.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5236"/>
        <source>Lock or unlock the object</source>
        <translation>Lukusta objekt või eemalda lukustus</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5237"/>
        <source>Lock or unlock the size of the object</source>
        <translation>Lukusta objekti suurus või eemalda lukustus</translation>
    </message>
    <message>
        <location filename="../propertiespalette.cpp" line="4619"/>
        <source>Enable or disable printing of the object</source>
        <translation type="obsolete">Luba või keela objekti trükkimine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Make text in lower frames flow around the object shape</source>
        <translation type="obsolete">Sunnib allpool asuvate kastide teksti kulgema ümber objekti</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use a surrounding box instead of the frame&apos;s shape for text flow</source>
        <translation type="obsolete">Tekstivoo määramiseks kasutatakse objektipiirete asemel neid ümbritsevat kasti</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use a second line originally based on the frame&apos;s shape for text flow</source>
        <translation type="obsolete">Tekstivoo jaoks kasutatakse teist joont, mis tugineb kastipiiretele</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5251"/>
        <source>Font of selected text or object</source>
        <translation>Valitud teksti või objekti font</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5252"/>
        <source>Font Size</source>
        <translation>Fondi suurus</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5253"/>
        <source>Offset to baseline of characters</source>
        <translation>Nihe märkide alusjoone suhtes</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5254"/>
        <source>Scaling width of characters</source>
        <translation>Märkide skaleerimislaius</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5255"/>
        <source>Scaling height of characters</source>
        <translation>Märkide skaleerimiskõrgus</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5256"/>
        <source>Color of text stroke and/or drop shadow, depending which is chosen.If both are chosen, then they share the same color.</source>
        <translation>Teksti äärejoone ja/või varju värv (sõltuvalt valikust). Kui mõlemad on valitud, kasutatakse üht ja sama värvi.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5257"/>
        <source>Color of selected text. If Outline text decoration is enabled, this color will be the fill color. If Drop Shadow Text is enabled, then this will be the top most color.</source>
        <translation>Valitud teksti värv. Kui sisse on lülitatud kontuuriefekt, on see täidise värv. Kui sisse on lülitatud varjuefekt, on see kõige ülemine värv.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5258"/>
        <source>Saturation of color of text stroke</source>
        <translation>Teksti äärejoone värvi küllastus</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5259"/>
        <source>Saturation of color of text fill</source>
        <translation>Teksti täidise värvi küllastus</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5260"/>
        <source>Right to Left Writing</source>
        <translation>Kirjutamine paremalt vasakule</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5261"/>
        <source>Manual Tracking</source>
        <translation>Märkide koondamine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5262"/>
        <source>Line Spacing</source>
        <translation>Reavahe</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Click to select the line spacing mode</source>
        <translation type="obsolete">Klõpsa reavahe režiimi valimiseks</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Style of current paragraph</source>
        <translation type="obsolete">Aktiivse lõigu stiil</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Hyphenation language of frame</source>
        <translation type="obsolete">Tekstikastis kasutatav keel</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5281"/>
        <source>Change settings for left or end points</source>
        <translation>Vasaku või otspunktide seadistuste muutmine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5282"/>
        <source>Pattern of line</source>
        <translation>Joone muster</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5283"/>
        <source>Thickness of line</source>
        <translation>Joone jämedus</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5284"/>
        <source>Type of line joins</source>
        <translation>Jooneühenduste tüüp</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5285"/>
        <source>Type of line end</source>
        <translation>Jooneotste tüüp</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5286"/>
        <source>Line style of current object</source>
        <translation>Aktiivse objekti joonestiil</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5288"/>
        <source>Choose the shape of frame...</source>
        <translation>Vali kasti kuju...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5289"/>
        <source>Edit shape of the frame...</source>
        <translation>Muuda kasti kuju...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5290"/>
        <source>Set radius of corner rounding</source>
        <translation>Määra nurkade ümardamise raadius</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5291"/>
        <source>Number of columns in text frame</source>
        <translation>Veergude arv tekstikastis</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5292"/>
        <source>Switches between Gap or Column width</source>
        <translation>Vahe või veerulaiuse lülitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5294"/>
        <source>Distance of text from top of frame</source>
        <translation>Teksti kaugus kasti ülaservast</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5295"/>
        <source>Distance of text from bottom of frame</source>
        <translation>Teksti kaugus kasti alaservast</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5296"/>
        <source>Distance of text from left of frame</source>
        <translation>Teksti kaugus kasti vasakust servast</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5297"/>
        <source>Distance of text from right of frame</source>
        <translation>Teksti kaugus kasti paremast servast</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5298"/>
        <source>Edit tab settings of text frame...</source>
        <translation>Muuda tekstikasti tabeldusmärke...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5300"/>
        <source>Allow the image to be a different size to the frame</source>
        <translation>Võimaldab pildil olla kastist erineva suurusega</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5301"/>
        <source>Horizontal offset of image within frame</source>
        <translation>Pildi rõhtsuunaline nihe kastis</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5302"/>
        <source>Vertical offset of image within frame</source>
        <translation>Pildi püstsuunaline nihe kastis</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5303"/>
        <source>Resize the image horizontally</source>
        <translation>Pildi suuruse muutmine rõhtsuunas</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5304"/>
        <source>Resize the image vertically</source>
        <translation>Pildi suuruse muutmine püstsuunas</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5305"/>
        <source>Keep the X and Y scaling the same</source>
        <translation>X- ja Y-skaala hoitakse võrdsena</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5306"/>
        <source>Keep the aspect ratio</source>
        <translation>Säilitatakse proportsioon</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5307"/>
        <source>Make the image fit within the size of the frame</source>
        <translation>Pilt sobitatakse kasti suurusega</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5308"/>
        <source>Use image proportions rather than those of the frame</source>
        <translation>Kasti proportsioonide asemel kasutatakse pildi proportsioone</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5309"/>
        <source>Source profile of the image</source>
        <translation>Pildi lähteprofiil</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5310"/>
        <source>Rendering intent for the image</source>
        <translation>Pildi renderdamisviis</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4938"/>
        <source>Gap:</source>
        <translation>Vahe:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4939"/>
        <source>Width:</source>
        <translation>Laius:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4966"/>
        <source>Text &amp;Flow Around Frame</source>
        <translation>Teksti&amp;voog ümber kasti</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4967"/>
        <source>Disabled</source>
        <translation>Keelatud</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4968"/>
        <source>Use Frame &amp;Shape</source>
        <translation>Kasti ku&amp;jundi kasutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5011"/>
        <source>Image Effects</source>
        <translation>Pildiefektid</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5012"/>
        <source>Extended Image Properties</source>
        <translation>Pildi laiendatud omadused</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5245"/>
        <source>Disable text flow from lower frames around object</source>
        <translation>Alumiste kastide teksti kulgemine ümber objekti keelatakse</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5246"/>
        <source>Use the frame shape for text flow of text frames below the object.</source>
        <translation>Kasti kujundi kasutamine objekti all asuvate tekstikastide tekstivoo jaoks.</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5247"/>
        <source>Use the bounding box, which is always rectangular, instead of the frame&apos;s shape for text flow of text frames below the object. </source>
        <translation>Kasti kujundi asemel kasutatakse alati nelinurkset ümbritsevat kasti objekti all asuvate tekstiraamide tekstivoo jaoks. </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Use a second line originally based on the frame&apos;s shape for text flow of text frames below the object. </source>
        <translation type="obsolete">Algselt kasti kujundil põhineva teise joone kasutamine objekti all asuvate tekstikastide tekstivoo jaoks. </translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4915"/>
        <source>Transparency Settings</source>
        <translation>Läbipaistvuse seadistused</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4898"/>
        <source>&amp;Group</source>
        <translation>&amp;Rühmitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4916"/>
        <source>Opacity:</source>
        <translation>Läbipaistmatus:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4917"/>
        <source>Blend Mode:</source>
        <translation>Ühtesulamise režiim:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4919"/>
        <source>Normal</source>
        <translation>Normaalne</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4920"/>
        <source>Darken</source>
        <translation>Tumendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4921"/>
        <source>Lighten</source>
        <translation>Helendamine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4922"/>
        <source>Multiply</source>
        <translation>Korrutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4923"/>
        <source>Screen</source>
        <translation>Ekraan</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4924"/>
        <source>Overlay</source>
        <translation>Ülekatmine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4925"/>
        <source>Hard Light</source>
        <translation>Külm valgus</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4926"/>
        <source>Soft Light</source>
        <translation>Soe valgus</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4927"/>
        <source>Difference</source>
        <translation>Lahutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4928"/>
        <source>Exclusion</source>
        <translation>Väljajätmine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4929"/>
        <source>Color Dodge</source>
        <translation>Värvi helestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4930"/>
        <source>Color Burn</source>
        <translation>Värvi tumestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4931"/>
        <source>Hue</source>
        <translation>Toon</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4933"/>
        <source>Color</source>
        <translation>Värv</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5227"/>
        <source>Group the selected objects</source>
        <translation>Valitud objektide rühmitamine</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4739"/>
        <source>Destroys the selected group</source>
        <translation type="obsolete">Kustutab valitud rühma</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3009"/>
        <source>Auto</source>
        <translation type="unfinished">Automaatne</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5248"/>
        <source>When chosen, the contour line can be edited with the Edit Shape Tool on the palette further above. When edited via the shape palette, this becomes a second separate line originally based on the frame&apos;s shape for text flow of text frames below the object. T</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4949"/>
        <source>Default</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4950"/>
        <source>Stair Step</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4951"/>
        <source>Skew</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4952"/>
        <source>Flip Text</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4954"/>
        <source>Type:</source>
        <translation type="unfinished">Tüüp:</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4971"/>
        <source>Use Image Clip Path</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4972"/>
        <source>Paragraph St&amp;yle:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4973"/>
        <source>Character St&amp;yle:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4989"/>
        <source>Word Tracking</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4993"/>
        <source>Min:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4991"/>
        <source>Norm:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4992"/>
        <source>Glyph Extension</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4994"/>
        <source>Max:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5249"/>
        <source>Use the clipping path of the image</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5265"/>
        <source>Paragraph style of currently selected text or paragraph</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5266"/>
        <source>Character style of currently selected text or paragraph</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5267"/>
        <source>Remove Direct Paragraph Formatting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5268"/>
        <source>Remove Direct Character Formatting</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5275"/>
        <source>Minimal width of spaces between words</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5276"/>
        <source>Normal width of spaces between words</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5277"/>
        <source>Minimal shrinkage of glyphs for justification</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5278"/>
        <source>Maximal extension of glyphs for justification</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5238"/>
        <source>Enable or disable exporting of the object</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5032"/>
        <source>Custom</source>
        <translation type="unfinished">Kohandatud</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4913"/>
        <source>&amp;Edit...</source>
        <translation type="unfinished">&amp;Redigeeri...</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4998"/>
        <source>First Line Offset</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="832"/>
        <source>Maximum Ascent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="833"/>
        <source>Font Ascent</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4995"/>
        <source>Color &amp; Effects</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4996"/>
        <source>Advanced Settings</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4997"/>
        <source>Style Settings</source>
        <translation type="unfinished">Stiiliseadistused</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="3011"/>
        <source>Baseline</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5228"/>
        <source>Ungroup the selected group</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5264"/>
        <source>Select the line spacing mode.</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5271"/>
        <source>Set the height of the first line of the text frame to use the tallest height of the included characters</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5272"/>
        <source>Set the height of the first line of text frame to use the full ascent of the font(s) in use</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5273"/>
        <source>Set the height of the first line of the text frame to the specified line height</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5001"/>
        <source>&amp;Page Number:</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4999"/>
        <source>Columns &amp; Text Distances</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4984"/>
        <source>Left Protruding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4985"/>
        <source>Right Protruding</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4986"/>
        <source>Left Hanging Punctuation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4987"/>
        <source>Right Hanging Punctuation</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="4988"/>
        <source>Reset</source>
        <translation type="unfinished">Lähtesta</translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="937"/>
        <source>Optical Margins</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/propertiespalette.cpp" line="5102"/>
        <source>Hairline</source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>PythonConsole</name>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="93"/>
        <source>&amp;Open...</source>
        <translation>&amp;Ava...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="98"/>
        <source>&amp;Save</source>
        <translation>&amp;Salvesta</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="103"/>
        <source>Save &amp;As...</source>
        <translation>Salvesta &amp;kui...</translation>
    </message>
    <message>
        <location filename="../plugins/scriptplugin/pconsole.ui" line="96"/>
        <source>&amp;Exit</source>
        <translation type="obsolete">&amp;Välju</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="71"/>
        <source>&amp;File</source>
        <translation>&amp;Fail</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="113"/>
        <source>&amp;Run</source>
        <translation>&amp;Käivita</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="118"/>
        <source>Run As &amp;Console</source>
        <translation>Kä&amp;ivita konsoolina</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="123"/>
        <source>&amp;Save Output...</source>
        <translation>&amp;Salvesta väljund...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="81"/>
        <source>&amp;Script</source>
        <translation>&amp;Skript</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="60"/>
        <source>Scribus Python Console</source>
        <translation>Scribuse Pythoni konsool</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>This is derived from standard Python console so it contains some limitations esp. in the case of whitespaces. Please consult Scribus manual for more informations.</source>
        <translation type="obsolete">Selle aluseks on standardne Pythoni konsool, mistõttu selles on teatud piiranguid, eriti tühimärkide kasutamises. Täpsemalt räägib sellest Scribuse käsiraamat.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="13"/>
        <source>Script Console</source>
        <translation>Skriptikonsool</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="117"/>
        <source>Write your commands here. A selection is processed as script</source>
        <translation>Kirjuta siia oma käsud. Valikut töödeldakse skriptina.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="118"/>
        <source>Output of your script</source>
        <translation>Skripti väljund</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Python Scripts (*.py)</source>
        <translation type="obsolete">Pythoni skriptid (*.py)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="161"/>
        <source>Open Python Script File</source>
        <translation>Pythoni skriptifaili avamine</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="195"/>
        <source>Save the Python Commands in File</source>
        <translation>Pythoni käskude salvestamine failina</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Warning</source>
        <translation type="obsolete">Hoiatus</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="220"/>
        <source>Text Files (*.txt)</source>
        <translation>Tekstifailid (*.txt)</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="218"/>
        <source>Save Current Output</source>
        <translation>Aktiivse väljundi salvestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="197"/>
        <source>Python Scripts (*.py *.PY)</source>
        <translation>Pythoni skriptid (*.py *.PY)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Line: %1 Column: %2</source>
        <translation type="obsolete">Rida: %1 Veerg : %2</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="33"/>
        <source>Col: %1 Row: %2/%3</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="44"/>
        <source>Ctrl+O</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="45"/>
        <source>Ctrl+S</source>
        <translation type="unfinished"></translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.ui" line="108"/>
        <source>&amp;Quit</source>
        <translation type="unfinished">&amp;Välju</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/pconsole.cpp" line="65"/>
        <source>This is a standard Python console with some 
known limitations. Please consult the Scribus 
Scripter documentation for futher information. </source>
        <translation type="unfinished"></translation>
    </message>
</context>
<context>
    <name>QColorDialog</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="130"/>
        <source>Hu&amp;e:</source>
        <translation>&amp;Toon:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="131"/>
        <source>&amp;Sat:</source>
        <translation>&amp;Küll:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="132"/>
        <source>&amp;Val:</source>
        <translation>&amp;Väär:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="133"/>
        <source>&amp;Red:</source>
        <translation>&amp;Punane:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="134"/>
        <source>&amp;Green:</source>
        <translation>&amp;Roheline:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="135"/>
        <source>Bl&amp;ue:</source>
        <translation>&amp;Sinine:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="136"/>
        <source>A&amp;lpha channel:</source>
        <translation>Al&amp;fakanal:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="137"/>
        <source>&amp;Basic colors</source>
        <translation>&amp;Baasvärvid</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="138"/>
        <source>&amp;Custom colors</source>
        <translation>&amp;Kohandatud värvid</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="139"/>
        <source>&amp;Define Custom Colors &gt;&gt;</source>
        <translation>&amp;Defineeri kohandatud värvid &gt;&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="140"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="141"/>
        <source>Cancel</source>
        <translation>Loobu</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="142"/>
        <source>&amp;Add to Custom Colors</source>
        <translation>Lis&amp;a kohandatud värvidesse</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="143"/>
        <source>Select color</source>
        <translation>Värvi valik</translation>
    </message>
</context>
<context>
    <name>QFileDialog</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="14"/>
        <source>Copy or Move a File</source>
        <translation>Faili kopeerimine või liigutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="15"/>
        <source>Read: %1</source>
        <translation>Lugeda: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="16"/>
        <source>Write: %1</source>
        <translation>Kirjutada: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="17"/>
        <source>File &amp;name:</source>
        <translation>Faili &amp;nimi:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="18"/>
        <source>File &amp;type:</source>
        <translation>Faili &amp;tüüp:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="19"/>
        <source>One directory up</source>
        <translation>Üks kataloog ülespoole</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="20"/>
        <source>Cancel</source>
        <translation>Loobu</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="21"/>
        <source>All Files (*)</source>
        <translation>Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="22"/>
        <source>Name</source>
        <translation>Nimi</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="23"/>
        <source>Size</source>
        <translation>Suurus</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="24"/>
        <source>Type</source>
        <translation>Tüüp</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="25"/>
        <source>Date</source>
        <translation>Kuupäev</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="26"/>
        <source>Attributes</source>
        <translation>Atribuudid</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="27"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="28"/>
        <source>Look &amp;in:</source>
        <translation>&amp;Asukoht:</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="29"/>
        <source>Back</source>
        <translation>Tagasi</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="30"/>
        <source>Create New Folder</source>
        <translation>Loo uus kataloog</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="31"/>
        <source>List View</source>
        <translation>Nimekirjavaade</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="32"/>
        <source>Detail View</source>
        <translation>Detailne vaade</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="33"/>
        <source>Preview File Info</source>
        <translation>Faili info eelvaatlus</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="34"/>
        <source>Preview File Contents</source>
        <translation>Faili sisu eelvaatlus</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="35"/>
        <source>Read-write</source>
        <translation>Lugeda/kirjutada</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="36"/>
        <source>Read-only</source>
        <translation>Ainult lugemiseks</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="37"/>
        <source>Write-only</source>
        <translation>Ainult kirjutamiseks</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="38"/>
        <source>Inaccessible</source>
        <translation>Ligipääsmatu</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="39"/>
        <source>Symlink to File</source>
        <translation>Nimeviit failile</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="40"/>
        <source>Symlink to Directory</source>
        <translation>Nimeviit kataloogile</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="41"/>
        <source>Symlink to Special</source>
        <translation>Nimeviit spetsiaalsele failile</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="42"/>
        <source>File</source>
        <translation>Fail</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="43"/>
        <source>Dir</source>
        <translation>Kataloog</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="44"/>
        <source>Special</source>
        <translation>Spetsiaalne fail</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="45"/>
        <source>Open</source>
        <translation>Avamine</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="46"/>
        <source>Save As</source>
        <translation>Salvestamine</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="47"/>
        <source>&amp;Open</source>
        <translation>&amp;Ava</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="48"/>
        <source>&amp;Save</source>
        <translation>&amp;Salvesta</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="49"/>
        <source>&amp;Rename</source>
        <translation>&amp;Nimeta ümber</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="50"/>
        <source>&amp;Delete</source>
        <translation>K&amp;ustuta</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="51"/>
        <source>R&amp;eload</source>
        <translation>&amp;Laadi uuesti</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="52"/>
        <source>Sort by &amp;Name</source>
        <translation>&amp;Nime järgi</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="53"/>
        <source>Sort by &amp;Size</source>
        <translation>&amp;Suuruse järgi</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="54"/>
        <source>Sort by &amp;Date</source>
        <translation>&amp;Kuupäeva järgi</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="55"/>
        <source>&amp;Unsorted</source>
        <translation>S&amp;orteerimata</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="56"/>
        <source>Sort</source>
        <translation>Sorteerimine</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="57"/>
        <source>Show &amp;hidden files</source>
        <translation>Näita &amp;peidetud faile</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="58"/>
        <source>the file</source>
        <translation>fail</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="59"/>
        <source>the directory</source>
        <translation>kataloog</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="60"/>
        <source>the symlink</source>
        <translation>nimeviit</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="61"/>
        <source>Delete %1</source>
        <translation>Kustutamine: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="62"/>
        <source>&lt;qt&gt;Are you sure you wish to delete %1 &quot;%2&quot;?&lt;/qt&gt;</source>
        <translation>&lt;qt&gt;Kas tõesti kustutada %1 &quot;%2&quot;?&lt;/qt&gt;</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Yes</source>
        <translation type="obsolete">&amp;Jah</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;No</source>
        <translation type="obsolete">&amp;Ei</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="65"/>
        <source>New Folder 1</source>
        <translation>Uus kataloog 1</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="66"/>
        <source>New Folder</source>
        <translation>Uus kataloog</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="67"/>
        <source>New Folder %1</source>
        <translation>Uus kataloog %1</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="68"/>
        <source>Find Directory</source>
        <translation>Kataloogi otsimine</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="69"/>
        <source>Directories</source>
        <translation>Kataloogid</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="70"/>
        <source>Save</source>
        <translation>Salvesta</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="71"/>
        <source>Error</source>
        <translation>Viga</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="72"/>
        <source>%1
File not found.
Check path and filename.</source>
        <translation>%1
Faili ei leitud.
Palun kontrolli asukohta ja nime.</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="73"/>
        <source>All Files (*.*)</source>
        <translation>Kõik failid (*.*)</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="74"/>
        <source>Select a Directory</source>
        <translation>Kataloogi valik</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="75"/>
        <source>Directory:</source>
        <translation>Kataloog:</translation>
    </message>
</context>
<context>
    <name>QFontDialog</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="147"/>
        <source>&amp;Font</source>
        <translation>&amp;Font</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="148"/>
        <source>Font st&amp;yle</source>
        <translation>Fondi st&amp;iil</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="149"/>
        <source>&amp;Size</source>
        <translation>&amp;Suurus</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="150"/>
        <source>Effects</source>
        <translation>Efektid</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="151"/>
        <source>Stri&amp;keout</source>
        <translation>Läbi &amp;kriipsutatud</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="152"/>
        <source>&amp;Underline</source>
        <translation>Allajoonit&amp;ud</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="153"/>
        <source>&amp;Color</source>
        <translation>&amp;Värv</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="154"/>
        <source>Sample</source>
        <translation>Näide</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="155"/>
        <source>Scr&amp;ipt</source>
        <translation>K&amp;iri</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="156"/>
        <source>OK</source>
        <translation>OK</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="157"/>
        <source>Apply</source>
        <translation>Rakenda</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="158"/>
        <source>Cancel</source>
        <translation>Loobu</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="159"/>
        <source>Close</source>
        <translation>Sulge</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="160"/>
        <source>Select Font</source>
        <translation>Fondi valik</translation>
    </message>
</context>
<context>
    <name>QLineEdit</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="79"/>
        <source>Clear</source>
        <translation>Puhasta</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="80"/>
        <source>Select All</source>
        <translation>Vali kõik</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="81"/>
        <source>&amp;Undo</source>
        <translation>&amp;Võta tagasi</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="82"/>
        <source>&amp;Redo</source>
        <translation>&amp;Tee uuesti</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="83"/>
        <source>Cu&amp;t</source>
        <translation>&amp;Lõika</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="84"/>
        <source>&amp;Copy</source>
        <translation>&amp;Kopeeri</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="85"/>
        <source>&amp;Paste</source>
        <translation>&amp;Aseta</translation>
    </message>
</context>
<context>
    <name>QMainWindow</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="99"/>
        <source>Line up</source>
        <translation>Joonda</translation>
    </message>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="100"/>
        <source>Customize...</source>
        <translation>Kohanda...</translation>
    </message>
</context>
<context>
    <name>QMessageBox</name>
    <message>
        <location filename="../../scribus/translationdummy.cpp" line="9"/>
        <source>&lt;h3&gt;About Qt&lt;/h3&gt;&lt;p&gt;This program uses Qt version %1.&lt;/p&gt;&lt;p&gt;Qt is a C++ toolkit for multiplatform GUI &amp;amp; application development.&lt;/p&gt;&lt;p&gt;Qt provides single-source portability across MS&amp;nbsp;Windows, Mac&amp;nbsp;OS&amp;nbsp;X, Linux, and all major commercial Unix variants.&lt;br&gt;Qt is also available for embedded devices.&lt;/p&gt;&lt;p&gt;Qt is a Trolltech product. See &lt;tt&gt;http://www.trolltech.com/qt/&lt;/tt&gt; for more information.&lt;/p&gt;</source>
        <translation>&lt;h3&gt;Qt info&lt;/h3&gt;&lt;p&gt;See programm kasutab Qt versiooni %1.&lt;/p&gt;&lt;p&gt;Qt on C++ tööriistakomplekt multiplatvormse GUI &amp;amp; rakenduste arendamiseks.&lt;/p&gt;&lt;p&gt;Qt kasutamine kindlustab lähtekoodi porditavuse MS&amp;nbsp;Windowsi, Mac&amp;nbsp;OS&amp;nbsp;X, Linuxi ja kõigi peamiste Unixi platvormide vahel.&lt;br&gt;Qt on saadaval ka integreeritud seadmete tarbeks.&lt;/p&gt;&lt;p&gt;Qt on firma Trolltech toode. Kui soovid rohkem infot, vaata &lt;tt&gt;http://www.trolltech.com/qt/&lt;/tt&gt;.&lt;/p&gt;</translation>
    </message>
</context>
<context>
    <name>QObject</name>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="2620"/>
        <source>Copy #%1 of </source>
        <translation>Koopia nr. %1  - </translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fileloader/scribus13format/scribus13format.cpp" line="1100"/>
        <source>Background</source>
        <translation>Taust</translation>
    </message>
    <message>
        <location filename="../../scribus/gtaction.cpp" line="76"/>
        <source>Importing text</source>
        <translation>Teksti import</translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="195"/>
        <source>All Supported Formats</source>
        <translation>Kõik toetatud vormingud</translation>
    </message>
    <message>
        <location filename="../../scribus/util_formats.cpp" line="242"/>
        <source>All Files (*)</source>
        <translation>Kõik failid (*)</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="58"/>
        <source>Afrikaans</source>
        <translation>Afrikaani</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="60"/>
        <source>Albanian</source>
        <translation>Albaania</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="61"/>
        <source>Basque</source>
        <translation>Baski</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="64"/>
        <source>Bulgarian</source>
        <translation>Bulgaaria</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Brazilian</source>
        <translation type="obsolete">Brasiilia</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="65"/>
        <source>Catalan</source>
        <translation>Katalaani</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="66"/>
        <source>Chinese</source>
        <translation>Hiina</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="68"/>
        <source>Croatian</source>
        <translation>Horvaadi</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="70"/>
        <source>Czech</source>
        <translation>Tšehhi</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="72"/>
        <source>Danish</source>
        <translation>Taani</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="74"/>
        <source>Dutch</source>
        <translation>Hollandi</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="228"/>
        <source>English</source>
        <translation>Inglise</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="77"/>
        <source>English (British)</source>
        <translation>Inglise (Briti)</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="79"/>
        <source>Esperanto</source>
        <translation>Esperanto</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="81"/>
        <source>German</source>
        <translation>Saksa</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="83"/>
        <source>German (Trad.)</source>
        <translation>Saksa (tradits.)</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="84"/>
        <source>Finnish</source>
        <translation>Soome</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="85"/>
        <source>French</source>
        <translation>Prantsuse</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="88"/>
        <source>Galician</source>
        <translation>Galeegi</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="89"/>
        <source>Greek</source>
        <translation>Kreeka</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="91"/>
        <source>Hungarian</source>
        <translation>Ungari</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="94"/>
        <source>Indonesian</source>
        <translation>Indoneesia</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="95"/>
        <source>Italian</source>
        <translation>Itaalia</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="96"/>
        <source>Japanese</source>
        <translation>Jaapani</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="98"/>
        <source>Korean</source>
        <translation>Korea</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="102"/>
        <source>Lithuanian</source>
        <translation>Leedu</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="103"/>
        <source>Luxembourgish</source>
        <translation>Letseburgi</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Norwegian (Bokmaal)</source>
        <translation type="obsolete">Norra (Bokmaal)</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="108"/>
        <source>Norwegian (Nnyorsk)</source>
        <translation>Norra (Nynorsk)</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="110"/>
        <source>Norwegian</source>
        <translation>Norra</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="112"/>
        <source>Polish</source>
        <translation>Poola</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="113"/>
        <source>Portuguese</source>
        <translation>Portugali</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="114"/>
        <source>Portuguese (BR)</source>
        <translation>Portugali (BR)</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="116"/>
        <source>Russian</source>
        <translation>Vene</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="124"/>
        <source>Swedish</source>
        <translation>Rootsi</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="119"/>
        <source>Spanish</source>
        <translation>Hispaania</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="120"/>
        <source>Spanish (Latin)</source>
        <translation>Hispaania (Lad-Am)</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="121"/>
        <source>Slovak</source>
        <translation>Slovaki</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="122"/>
        <source>Slovenian</source>
        <translation>Sloveeni</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="123"/>
        <source>Serbian</source>
        <translation>Serbia</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="126"/>
        <source>Thai</source>
        <translation>Tai</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="128"/>
        <source>Turkish</source>
        <translation>Türgi</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="129"/>
        <source>Ukranian</source>
        <translation>Ukraina</translation>
    </message>
    <message>
        <location filename="../../scribus/langmgr.cpp" line="131"/>
        <source>Welsh</source>
        <translation>Uelsi</translation>
    </message>
    <message>
        <location filename="../../scribus/main_win32.cpp" line="259"/>
        <source>Scribus Crash</source>
        <translation>Scribuse krahh</translation>
    </message>
    <message>
        <location filename="../../scribus/main_nix.cpp" line="128"/>
        <source>Scribus crashes due to Signal #%1</source>
        <translation>Scribust tabas krahh signaaliga #%1</translation>
    </message>
    <message>
        <location filename="../../scribus/main_win32.cpp" line="261"/>
        <source>&amp;OK</source>
        <translation>&amp;OK</translation>
    </message>
    <message>
        <location filename="../../scribus/main_win32.cpp" line="236"/>
        <source>Scribus crashes due to the following exception : %1</source>
        <translation>Scribust tabas krahh järgmise erindi tõttu: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/page.cpp" line="82"/>
        <source>Page</source>
        <translation>Lehekülg</translation>
    </message>
    <message>
        <location filename="../../scribus/page.cpp" line="91"/>
        <source>Master Page </source>
        <translation>Leheküljetoorik </translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Custom</source>
        <translation type="obsolete">Kohandatud</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="124"/>
        <source>4A0</source>
        <translation>4A0</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="130"/>
        <source>2A0</source>
        <translation>2A0</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="220"/>
        <source>Comm10E</source>
        <translation>Comm10E</translation>
    </message>
    <message>
        <location filename="../../scribus/pagesize.cpp" line="226"/>
        <source>DLE</source>
        <translation>DLE</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="40"/>
        <source>Could not open output file %1</source>
        <translation>Väljundfaili %1 avamine ebaõnnestus</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="56"/>
        <source>Output stream not writeable</source>
        <translation>Väljundvoog ei ole kirjutamisõigusega</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="79"/>
        <source>Verification of settings failed: %1</source>
        <translation>Seadistuste kontroll ebaõnnestus: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="281"/>
        <source>Could not open input file %1</source>
        <translation>Sisendfaili %1 avamine ebaõnnestus</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="663"/>
        <source>Unable to read settings XML:</source>
        <translation>Seadistuste XML-i lugemine ebaõnnestus:</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="297"/>
        <source>%1 (line %2 col %3)</source>
        <comment>Load PDF settings</comment>
        <translation>%1 (rida %2 veerg %3)</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="316"/>
        <source>Unable to read settings XML: %1</source>
        <translation>Seadistuste XML-i lugemine ebaõnnestus: %1</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="316"/>
        <source>null root node</source>
        <comment>Load PDF settings</comment>
        <translation>null juursõlm</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="441"/>
        <source>&lt;pdfVersion&gt; invalid</source>
        <comment>Load PDF settings</comment>
        <translation>&lt;pdfVersion&gt; vigane</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="454"/>
        <source>found %1 &lt;%2&gt; nodes, need 1.</source>
        <comment>Load PDF settings</comment>
        <translation>leiti %1 &lt;%2&gt; sõlme, vaja on 1.</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="469"/>
        <source>unexpected null &lt;%2&gt; node</source>
        <comment>Load PDF settings</comment>
        <translation>ootamatu null &lt;%2&gt; sõlm</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="477"/>
        <source>node &lt;%1&gt; not an element</source>
        <comment>Load PDF settings</comment>
        <translation>sõlm &lt;%1&gt; ei ole element</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="497"/>
        <source>element &lt;%1&gt; lacks `value&apos; attribute</source>
        <comment>Load PDF settings</comment>
        <translation>elemendil &lt;%1&gt; puudub atribuut `value&apos;</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="526"/>
        <source>element &lt;%1&gt; value must be `true&apos; or `false&apos;</source>
        <comment>Load PDF settings</comment>
        <translation>elemendi &lt;%1&gt; väärtus peab olema `true&apos; või `false&apos;</translation>
    </message>
    <message>
        <location filename="../../scribus/pdfoptionsio.cpp" line="664"/>
        <source>element &lt;lpiSettingsEntry&gt; lacks `name&apos; attribute</source>
        <comment>Load PDF settings</comment>
        <translation>elemendil &lt;lpiSettingsEntry&gt; puudub atribuut `name&apos;</translation>
    </message>
    <message>
        <location filename="../../scribus/scprintengine_gdi.cpp" line="486"/>
        <source>All</source>
        <translation>Kõik</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1783"/>
        <source>Exporting PostScript File</source>
        <translation>PostScript-faili eksport</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1785"/>
        <source>Printing File</source>
        <translation>Faili trükkimine</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1967"/>
        <source>Black</source>
        <translation>Must</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1969"/>
        <source>Cyan</source>
        <translation>Tsüaan</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1971"/>
        <source>Magenta</source>
        <translation>Magenta</translation>
    </message>
    <message>
        <location filename="../../scribus/pslib.cpp" line="1973"/>
        <source>Yellow</source>
        <translation>Kollane</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/ftface.cpp" line="48"/>
        <source>Freetype2 library not available</source>
        <translation>Freetype2 teek pole kättesaadav</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/ftface.cpp" line="80"/>
        <source>Font %1(%2) is broken</source>
        <translation>Font %1(%2) on vigane</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="186"/>
        <source>Font %1 is broken (read stream), no embedding</source>
        <translation>Font %1 on vigane (voo lugemine), ei põimita</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="390"/>
        <source>Font %1 has broken glyph %2 (charcode %3)</source>
        <translation>Fondis %1 on vigane glüüf %2 (kood %3)</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font %1 is broken and will be discarded</source>
        <translation type="obsolete">Font %1 on vigane ja jäetakse kõrvale</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ps.h" line="216"/>
        <source>Font %1 cannot be read, no embedding</source>
        <translation>Fondi %1 lugemine ebaõnnestus, ei põimita</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="318"/>
        <source>Creating Font Cache</source>
        <translation>Fondipuhvri loomine</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="327"/>
        <source>Font %1 is broken, discarding it</source>
        <translation>Font %1 on vigane, jäetakse kõrvale</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="334"/>
        <source>Failed to load font %1 - font type unknown</source>
        <translation>Fondi %1 laadimine ebaõnnestus - fondi tüüp on tundmatu</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="344"/>
        <source>New Font found, checking...</source>
        <translation>Leiti uus font, kontrollitakse...</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="381"/>
        <source>Modified Font found, checking...</source>
        <translation>Leiti muudetud font, kontrollitakse...</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="538"/>
        <source>Font %1 loaded from %2(%3)</source>
        <translation>Font %1 laaditud failist %2(%3)</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="554"/>
        <source>Font %1(%2) is duplicate of %3</source>
        <translation>Font %1(%2) on %3 kloon</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="666"/>
        <source>Loading font %1 (found using fontconfig)</source>
        <translation>Fondi %1 laadimine (leiti fontconfig&apos;i abil)</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="671"/>
        <source>Failed to load a font - freetype2 couldn&apos;t find the font file</source>
        <translation>Fondi laadimine ebaõnnestus - freetype2 ei leidnud fondifaili</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="767"/>
        <source>Reading Font Cache</source>
        <translation>Fondipuhvri lugemine</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="814"/>
        <source>Writing updated Font Cache</source>
        <translation>Uuendatud fondipuhvri kirjutamine</translation>
    </message>
    <message>
        <location filename="../../scribus/scfonts.cpp" line="831"/>
        <source>Searching for Fonts</source>
        <translation>Fontide otsimine</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Font %1  has invalid glyph %2 (charcode %3), discarding it</source>
        <translation type="obsolete">Fondis %1 on vigane glüüf %2 (kood %3), jäetakse kõrvale</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="72"/>
        <source>extracting face %1 from font %2 (offset=%3, nTables=%4)</source>
        <translation>tüübi %1 ekstraktimine fondist %2 (sihtaadress=%3, nTables=%4)</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="85"/>
        <source>memcpy header: %1 %2 %3</source>
        <translation>memcpy päis: %1 %2 %3</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="94"/>
        <source>table &apos;%1&apos;</source>
        <translation>tabel &apos;%1&apos;</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="95"/>
        <source>memcpy table: %1 %2 %3</source>
        <translation>memcpy tabel: %1 %2 %3</translation>
    </message>
    <message>
        <location filename="../../scribus/fonts/scface_ttf.cpp" line="98"/>
        <source>memcpy offset: %1 %2 %3</source>
        <translation>memcpy suhtaadress: %1 %2 %3</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="581"/>
        <source>Scribus Development Version</source>
        <translation>Scribuse arendusversioon</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>You are running a development version of Scribus 1.3.x. The document you are working with was created in Scribus 1.2.3 or lower. The process of saving will make this file unusable again in Scribus 1.2.3 unless you use File-&gt;Save As. Are you sure you wish to proceed with this operation?</source>
        <translation type="obsolete">Kasutad Scribus 1.3.x arendusversiooni. Redigeeritav dokument on loodud Scribuse versiooniga 1.2.3 või vanemaga. Salvestamisel ei saa seda enam Scribus 1.2.3 või vanemas kasutada, kui sa ei vali just Fail-&gt;Salvesta kui. Kas soovid kindlasti jätkata?</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3635"/>
        <source>&lt;p&gt;You are trying to import more pages than there are available in the current document counting from the active page.&lt;/p&gt;Choose one of the following:&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;b&gt;Create&lt;/b&gt; missing pages&lt;/li&gt;&lt;li&gt;&lt;b&gt;Import&lt;/b&gt; pages until the last page&lt;/li&gt;&lt;li&gt;&lt;b&gt;Cancel&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;</source>
        <translation>&lt;p&gt;Üritad importida rohkem lehekülgi, kui neid leidub aktiivses dokumendis alates aktiivsest leheküljest.&lt;/p&gt;Vali üks järgmistest võimalustest:&lt;br&gt;&lt;ul&gt;&lt;li&gt;&lt;b&gt;Loo&lt;/b&gt; puuduvad leheküljed&lt;/li&gt;&lt;li&gt;&lt;b&gt;Impordi&lt;/b&gt; leheküljed viimase leheküljeni&lt;/li&gt;&lt;li&gt;&lt;b&gt;Loobu&lt;/b&gt;&lt;/li&gt;&lt;/ul&gt;</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3636"/>
        <source>C&amp;reate</source>
        <translation>&amp;Loo</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="3637"/>
        <source>&amp;Import</source>
        <translation>&amp;Impordi</translation>
    </message>
    <message>
        <location filename="../../scribus/scribus.cpp" line="4287"/>
        <source>The changes to your document have not been saved and you have requested to revert them. Do you wish to continue?</source>
        <translation>Dokumenti tehtud muudatused pole salvestatud, nüüd aga soovisid need tühistada. Kas soovid jätkata?</translation>
    </message>
    <message>
        <location filename="../../scribus/scribuscore.cpp" line="240"/>
        <source>Initializing...</source>
        <translation>Initsialiseerimine...</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/svgexplugin/svgexplugin.cpp" line="126"/>
        <source>Save as</source>
        <translation>Salvestamine</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="135"/>
        <source> pt</source>
        <translation type="obsolete"> pt</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="136"/>
        <source> mm</source>
        <translation type="obsolete"> mm</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="137"/>
        <source> in</source>
        <translation type="obsolete"> in</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="138"/>
        <source> p</source>
        <translation type="obsolete"> p</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="139"/>
        <source> cm</source>
        <translation type="obsolete"> cm</translation>
    </message>
    <message>
        <location filename="../units.cpp" line="140"/>
        <source> c</source>
        <translation type="obsolete"> c</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="155"/>
        <source>pt</source>
        <translation>pt</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="156"/>
        <source>mm</source>
        <translation>mm</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="157"/>
        <source>in</source>
        <translation>in</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="158"/>
        <source>p</source>
        <translation>p</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="159"/>
        <source>cm</source>
        <translation>cm</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="160"/>
        <source>c</source>
        <translation>c</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="207"/>
        <source>Points (pt)</source>
        <translation>Punktid (pt)</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="208"/>
        <source>Millimeters (mm)</source>
        <translation>Millimeetrid (mm)</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="209"/>
        <source>Inches (in)</source>
        <translation>Tollid (in)</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="210"/>
        <source>Picas (p)</source>
        <translation>Pikad (p)</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="211"/>
        <source>Centimeters (cm)</source>
        <translation>Sentimeetrid (cm)</translation>
    </message>
    <message>
        <location filename="../../scribus/units.cpp" line="212"/>
        <source>Cicero (c)</source>
        <translation>Tsiitserod (c)</translation>
    </message>
    <message>
        <location filename="../../scribus/util.cpp" line="362"/>
        <source>File exists</source>
        <translation>Fail on olemas</translation>
    </message>
    <message>
        <location filename="../../scribus/util.cpp" line="363"/>
        <source>A file named &apos;%1&apos; already exists.&lt;br/&gt;Do you want to replace it with the file you are saving?</source>
        <translation>Fail nimega &apos;%1&apos; on juba olemas.&lt;br/&gt;Kas asendada see failiga, mida soovisid salvestada?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>&amp;Replace</source>
        <translation type="obsolete">&amp;Asenda</translation>
    </message>
    <message>
        <location filename="../../scribus/util.cpp" line="525"/>
        <source>page</source>
        <comment>page export</comment>
        <translation>lk</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/barcodegenerator/barcode.cpp" line="31"/>
        <source>Barcode Generator</source>
        <translation>Ribakoodi generaator</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/colorwheel/colorwheel.cpp" line="56"/>
        <source>Color Wheel</source>
        <translation>Värviratas</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/fontpreview/fontpreviewplugin.cpp" line="58"/>
        <source>Font Preview</source>
        <translation>Fontide eelvaatlus</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/myplugin/myplugin.cpp" line="45"/>
        <source>My Plugin</source>
        <translation>Minu plugin</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="71"/>
        <source>New From Template</source>
        <translation>Uus mallist</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/newfromtemplateplugin/nftemplate.cpp" line="117"/>
        <source>Document Template: </source>
        <translation>Dokumendimall: </translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="155"/>
        <source>Newsletters</source>
        <translation>Ajalehed</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="156"/>
        <source>Brochures</source>
        <translation>Brošüürid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="157"/>
        <source>Catalogs</source>
        <translation>Almanahhid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="158"/>
        <source>Flyers</source>
        <translation>Lendlehed</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="159"/>
        <source>Signs</source>
        <translation>Sildid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="160"/>
        <source>Cards</source>
        <translation>Kaardid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="161"/>
        <source>Letterheads</source>
        <translation>Kirjablanketid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="162"/>
        <source>Envelopes</source>
        <translation>Ümbrikud</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="163"/>
        <source>Business Cards</source>
        <translation>Visiitkaardid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="164"/>
        <source>Calendars</source>
        <translation>Kalendrid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="165"/>
        <source>Advertisements</source>
        <translation>Reklaamid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="166"/>
        <source>Labels</source>
        <translation>Etiketid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="167"/>
        <source>Menus</source>
        <translation>Menüüd</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="168"/>
        <source>Programs</source>
        <translation>Programmid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="169"/>
        <source>PDF Forms</source>
        <translation>PDF-vormid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="170"/>
        <source>PDF Presentations</source>
        <translation>PDF-esitlused</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="171"/>
        <source>Magazines</source>
        <translation>Ajakirjad</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="172"/>
        <source>Posters</source>
        <translation>Postrid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="173"/>
        <source>Announcements</source>
        <translation>Kuulutused</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="174"/>
        <source>Text Documents</source>
        <translation>Tekstidokumendid</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="175"/>
        <source>Folds</source>
        <translation>Voldikud</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satdialog.cpp" line="176"/>
        <source>Media Cases</source>
        <translation>Ümbrised</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satemplate.cpp" line="261"/>
        <source>Own Templates</source>
        <translation>Enda mallid</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export As Image</source>
        <translation type="obsolete">Eksport pildina</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Save as Image</source>
        <translation type="obsolete">Salvestamine pildina</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Error writing the output file(s).</source>
        <translation type="obsolete">Viga väljundfaili kirjutamisel.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Export successful.</source>
        <translation type="obsolete">Eksport õnnestus.</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>File exists. Overwrite?</source>
        <translation type="obsolete">Fail on olemas. Kas kirjutada üle?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>exists already. Overwrite?</source>
        <translation type="obsolete">on juba olemas. Kas kirjutada üle?</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Yes</source>
        <translation type="obsolete">Jah</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>No</source>
        <translation type="obsolete">Ei</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>Yes all</source>
        <translation type="obsolete">Jah kõigile</translation>
    </message>
    <message>
        <location filename="../plugins/psimport/importpsplugin.cpp" line="70"/>
        <source>PS/EPS Importer</source>
        <translation type="obsolete">PS/EPS-i importija</translation>
    </message>
    <message>
        <location filename="" line="136966688"/>
        <source>All Supported Formats (*.eps *.EPS *.ps *.PS);;</source>
        <translation type="obsolete">Kõik toetatud vormingud (*.eps *.EPS *.ps *.PS);;</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/xfigimplugin/importxfigplugin.cpp" line="128"/>
        <source>Open</source>
        <translation>Avamine</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/saveastemplateplugin/satemplate.cpp" line="66"/>
        <source>Save As Template</source>
        <translation>Salvestamine mallina</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="64"/>
        <source>Cannot get a color with an empty name.</source>
        <comment>python error</comment>
        <translation>Nimeta värvi hankimine ei ole võimalik.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="213"/>
        <source>Color not found.</source>
        <comment>python error</comment>
        <translation>Värvi ei leitud.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="87"/>
        <source>Cannot change a color with an empty name.</source>
        <comment>python error</comment>
        <translation>Nimeta värvi muutmine ei ole võimalik.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="173"/>
        <source>Color not found in document.</source>
        <comment>python error</comment>
        <translation>Dokumendist ei leitud värvi.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="184"/>
        <source>Color not found in default colors.</source>
        <comment>python error</comment>
        <translation>Värvi ei leitud vaikimisi värvide seast.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="123"/>
        <source>Cannot create a color with an empty name.</source>
        <comment>python error</comment>
        <translation>Nimeta värvi ei ole võimalik luua.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="159"/>
        <source>Cannot delete a color with an empty name.</source>
        <comment>python error</comment>
        <translation>Nimeta värvi ei ole võimalik kustutada.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdcolor.cpp" line="204"/>
        <source>Cannot replace a color with an empty name.</source>
        <comment>python error</comment>
        <translation>Nimeta värvi ei ole võimalik asendada.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="45"/>
        <source>firstPageOrder is bigger than allowed.</source>
        <comment>python error</comment>
        <translation>firstPageOrder on suurem kui lubatud.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="149"/>
        <source>Failed to open document.</source>
        <comment>python error</comment>
        <translation>Dokumendi avamine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="178"/>
        <source>Failed to save document.</source>
        <comment>python error</comment>
        <translation>Dokumendi salvestamine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmddoc.cpp" line="216"/>
        <source>Unit out of range. Use one of the scribus.UNIT_* constants.</source>
        <comment>python error</comment>
        <translation>Ühik väljaspool piire. Kasuta mõnda  scribus.UNIT_* konstanti.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetprop.cpp" line="65"/>
        <source>Color not found - python error</source>
        <comment>python error</comment>
        <translation>Värvi ei leitud - Pythoni viga</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="39"/>
        <source>Argument must be page item name, or PyCObject instance</source>
        <translation>Argument peab olema lehekülje elemendi nimi või PyCObject&apos;i eksemplar</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="90"/>
        <source>Property not found</source>
        <translation>Omadust ei leitud</translation>
    </message>
    <message>
        <location filename="../plugins/scriptplugin/cmdgetsetprop.cpp" line="202"/>
        <source>Child not found</source>
        <translation type="obsolete">Järglast ei leitud</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="310"/>
        <source>Couldn&apos;t convert result type &apos;%1&apos;.</source>
        <translation>Tulemuse tüübi &apos;%1&apos; teisendamine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="442"/>
        <source>Property type &apos;%1&apos; not supported</source>
        <translation>Omaduse tüüp &apos;%1&apos; ei ole toetatud</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="461"/>
        <source>Couldn&apos;t convert &apos;%1&apos; to property type &apos;%2&apos;</source>
        <translation>&apos;%1&apos; teisendamine omaduse tüübiks &apos;%2&apos; ebaõnnestus</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdgetsetprop.cpp" line="469"/>
        <source>Types matched, but setting property failed.</source>
        <translation>Tüübid klapivad, aga omaduse määramine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="27"/>
        <source>Target is not an image frame.</source>
        <comment>python error</comment>
        <translation>Sihtmärk ei ole pildikast.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="386"/>
        <source>Specified item not an image frame.</source>
        <comment>python error</comment>
        <translation>Määratud element ei ole pildikast.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="204"/>
        <source>Cannot group less than two items</source>
        <comment>python error</comment>
        <translation>Vähem kui kaht elementi ei saa rühmitada</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="229"/>
        <source>Can&apos;t group less than two items</source>
        <comment>python error</comment>
        <translation>Vähem kui kaht elementi ei saa rühmitada</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="237"/>
        <source>Need selection or argument list of items to group</source>
        <comment>python error</comment>
        <translation>Rühmitamiseks on vajalik valik või elementide nimekiri</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmani.cpp" line="271"/>
        <source>Cannot scale by 0%.</source>
        <comment>python error</comment>
        <translation>0% võrra ei saa skaleerida.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="417"/>
        <source>Font not found.</source>
        <comment>python error</comment>
        <translation>Fonti ei leitud.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="104"/>
        <source>Cannot render an empty sample.</source>
        <comment>python error</comment>
        <translation>Tühja eksemplari ei saa renderdada.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="138"/>
        <source>Unable to save pixmap</source>
        <comment>scripter error</comment>
        <translation>Pikselrastri salvestamine ebaõnnestus</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="690"/>
        <source>Cannot have an empty layer name.</source>
        <comment>python error</comment>
        <translation>Kihil ei saa nimi puududa.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="729"/>
        <source>Layer not found.</source>
        <comment>python error</comment>
        <translation>Kihti ei leitud.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="695"/>
        <source>Cannot remove the last layer.</source>
        <comment>python error</comment>
        <translation>Viimast kihti ei saa eemaldada.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdmisc.cpp" line="746"/>
        <source>Cannot create layer without a name.</source>
        <comment>python error</comment>
        <translation>Nimeta kihti ei ole võimalik luua.</translation>
    </message>
    <message>
        <location filename="../plugins/scriptplugin/cmdobj.cpp" line="432"/>
        <source>An object with the requested name already exists.</source>
        <comment>python error</comment>
        <translation type="obsolete">Soovitud nimega objekt on juba olemas.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="214"/>
        <source>Point list must contain at least two points (four values).</source>
        <comment>python error</comment>
        <translation>Punktide nimekiri peab sisaldama vähemalt kaht punkti (neli väärtust).</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="299"/>
        <source>Point list must contain an even number of values.</source>
        <comment>python error</comment>
        <translation>Punktide nimekiri peab sisaldama paarisarvu väärtusi.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="294"/>
        <source>Point list must contain at least three points (six values).</source>
        <comment>python error</comment>
        <translation>Punktide nimekiri peab sisaldama vähemalt kolme punkti (kuus väärtust).</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="376"/>
        <source>Point list must contain at least four points (eight values).</source>
        <comment>python error</comment>
        <translation>Punktide nimekiri peab sisaldama vähemalt nelja punkti (kaheksa väärtust).</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="381"/>
        <source>Point list must have a multiple of six values.</source>
        <comment>python error</comment>
        <translation>Punktide nimekiri peab sisaldama x korda kuut väärtust.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="480"/>
        <source>Object not found.</source>
        <comment>python error</comment>
        <translation>Objekti ei leitud.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="606"/>
        <source>Style not found.</source>
        <comment>python error</comment>
        <translation>Stiili ei leitud.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdobj.cpp" line="632"/>
        <source>Cannot set style on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Stiili saab määrata ainult tekstikastile.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="58"/>
        <source>Failed to save EPS.</source>
        <comment>python error</comment>
        <translation>EPS-i salvestamine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="149"/>
        <source>Page number out of range.</source>
        <comment>python error</comment>
        <translation>Leheküljenumber väljub piiridest.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="139"/>
        <source>Given master page name does not match any existing.</source>
        <comment>python error</comment>
        <translation>Määratud leheküljetooriku nimele ei vasta ükski olemasolev toorik.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="292"/>
        <source>argument is not list: must be list of float values.</source>
        <comment>python error</comment>
        <translation>argument ei ole nimekiri: peab olema murdarvväärtuste nimekiri.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="252"/>
        <source>argument contains non-numeric values: must be list of float values.</source>
        <comment>python error</comment>
        <translation>argument sisaldab mittearvulisi väärtusi: peab olema murdarvväärtuste nimekiri.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdpage.cpp" line="303"/>
        <source>argument contains no-numeric values: must be list of float values.</source>
        <comment>python error</comment>
        <translation>argument sisaldab mittearvulisi väärtusi: peab olema murdarvväärtuste nimekiri.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="217"/>
        <source>Line width out of bounds, must be 0 &lt;= line_width &lt;= 12.</source>
        <comment>python error</comment>
        <translation>Joone jämedus väljub piiridest, peab olema  0 &lt;= joone_jämedus &lt;= 12.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="239"/>
        <source>Line shade out of bounds, must be 0 &lt;= shade &lt;= 100.</source>
        <comment>python error</comment>
        <translation>Joone varjund väljub piiridest, peab olema 0 &lt;= varjund &lt;= 100.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="261"/>
        <source>Fill shade out of bounds, must be 0 &lt;= shade &lt;= 100.</source>
        <comment>python error</comment>
        <translation>Täidise varjund väljub piiridest, peab olema 0 &lt;= varjund &lt;= 100.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="334"/>
        <source>Corner radius must be a positive number.</source>
        <comment>python error</comment>
        <translation>Nurga raadius peab olema positiivne arv.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdsetprop.cpp" line="363"/>
        <source>Line style not found.</source>
        <comment>python error</comment>
        <translation>Joone stiili ei leitud.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="28"/>
        <source>Cannot get font size of non-text frame.</source>
        <comment>python error</comment>
        <translation>Mitte-tekstikasti fondi suuruse hankimine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="54"/>
        <source>Cannot get font of non-text frame.</source>
        <comment>python error</comment>
        <translation>Mitte-tekstikasti fondi hankimine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="80"/>
        <source>Cannot get text size of non-text frame.</source>
        <comment>python error</comment>
        <translation>Mitte-tekstikasti teksti suuruse hankimine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="116"/>
        <source>Cannot get column count of non-text frame.</source>
        <comment>python error</comment>
        <translation>Mitte-tekstikasti veergude arvu hankimine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="134"/>
        <source>Cannot get line space of non-text frame.</source>
        <comment>python error</comment>
        <translation>Mitte-tekstikasti reavahe hankimine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="174"/>
        <source>Cannot get column gap of non-text frame.</source>
        <comment>python error</comment>
        <translation>Mitte-tekstikasti veergude vahe hankimine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="224"/>
        <source>Cannot get text of non-text frame.</source>
        <comment>python error</comment>
        <translation>Mitte-tekstikasti teksti hankimine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="257"/>
        <source>Cannot set text of non-text frame.</source>
        <comment>python error</comment>
        <translation>Mitte-tekstikasti teksti määramine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="291"/>
        <source>Cannot insert text into non-text frame.</source>
        <comment>python error</comment>
        <translation>Teksti lisamine mitte-tekstikasti ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="300"/>
        <source>Insert index out of bounds.</source>
        <comment>python error</comment>
        <translation>Lisamise indeks väljub piiridest.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="329"/>
        <source>Alignment out of range. Use one of the scribus.ALIGN* constants.</source>
        <comment>python error</comment>
        <translation>Joondus väljub piiridest. Kasutada mõnda  scribus.ALIGN* konstanti.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="337"/>
        <source>Cannot set text alignment on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Mitte-tekstikasti teksti joonduse määramine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="363"/>
        <source>Font size out of bounds - must be 1 &lt;= size &lt;= 512.</source>
        <comment>python error</comment>
        <translation>Fondi suurus väljub piiridest, peab olema 1 &lt;= suurus &lt;= 512.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="372"/>
        <source>Cannot set font size on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Mitte-tekstikasti fondi suuruse määramine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="401"/>
        <source>Cannot set font on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Mitte-tekstikasti fondi määramine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="435"/>
        <source>Line space out of bounds, must be &gt;= 0.1.</source>
        <comment>python error</comment>
        <translation>Reavahe väljub piiridest, peab olema &gt;=0,1.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="443"/>
        <source>Cannot set line spacing on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Mitte-tekstikasti reavahe määramine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="488"/>
        <source>Column gap out of bounds, must be positive.</source>
        <comment>python error</comment>
        <translation>Veergude vahe väljub piiridest, peab olema positiivne.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="496"/>
        <source>Cannot set column gap on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Mitte-tekstikasti veergude vahe määramine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="515"/>
        <source>Column count out of bounds, must be &gt; 1.</source>
        <comment>python error</comment>
        <translation>Veergude arv väljub piiridest, peab olema &gt; 1.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="523"/>
        <source>Cannot set number of columns on a non-text frame.</source>
        <comment>python error</comment>
        <translation>Mitte-tekstikasti veergude arvu määramine ebaõnnestus.</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="554"/>
        <source>Selection index out of bounds</source>
        <comment>python error</comment>
        <translation>Valiku indeks väljub piiridest</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="559"/>
        <source>Cannot select text in a non-text frame</source>
        <comment>python error</comment>
        <translation>Teksti valimine mitte-tekstikastis ebaõnnestus</translation>
    </message>
    <message>
        <location filename="../../scribus/plugins/scriptplugin/cmdtext.cpp" line="596"/>
        <source>Cannot delete text from a non-text frame.</source>
        <comment>python error</comment>
        <translation>Teksti kustutamine mitte-tekstikastis ebaõnnestus.</tr