
#include <stdio.h>
#include <stdlib.h>

#include "SDL_imageFilter.h"

void setup_src(unsigned char *src1, unsigned char *src2)
{
 src1[0]=src1[2]=1; 
 src1[1]=0;
 src1[3]=3;
 src1[4]=33;
 src2[1]=src2[2]=3; 
 src2[0]=0;
 src2[3]=2;
 src1[14]=8;
 src2[14]=10;
 src2[4]=44;
}

void print_result(char *label,unsigned char *src1, unsigned char *src2, unsigned char *dst) 
{
 char blabel[80];
 
 memset(blabel,' ',80);
 blabel[strlen(label)]=0;
 printf ("%s   src1  %02x %02x %02x %02x %02x .. %02x\n",blabel,src1[0],src1[1],src1[2],src1[3],src1[4],src1[14]);
 printf ("%s   src2  %02x %02x %02x %02x %02x .. %02x\n",blabel,src2[0],src2[1],src2[2],src2[3],src2[4],src2[14]);
 printf ("%s   dest  %02x %02x %02x %02x %02x .. %02x\n",label, dst[0], dst[1], dst[2], dst[3], dst[4], dst[14]);
 printf ("\n");
}

void print_result_src1(char *label,unsigned char *src1,unsigned char *dst) 
{
 char blabel[80];
 
 memset(blabel,' ',80);
 blabel[strlen(label)]=0;
 printf ("%s   src1  %02x %02x %02x %02x %02x .. %02x\n",blabel,src1[0],src1[1],src1[2],src1[3], src1[4], src1[14]);
 printf ("%s   dest  %02x %02x %02x %02x %02x .. %02x\n",label, dst[0], dst[1], dst[2], dst[3], dst[4], dst[14]);
 printf ("\n");
}

int main(int argc, char *argv[])
{

 unsigned char src1[15],src2[15],dst[15];

 /* SDL_imageFilter Test */

 printf ("TestImageFilter\n\n");
 printf ("Testing an array of 15 bytes - first 8 bytes should be processed\n");
 printf ("by MMX or C code, the last 7 bytes only by C code.\n\n");
 

 printf ("---\n");

 SDL_imageFilterMMXon();
 
 setup_src(src1, src2); 
 SDL_imageFilterBitAnd ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15); 
 print_result ("MMX BitAnd", src1, src2, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2); 
 SDL_imageFilterBitAnd ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15); 
 print_result (" C  BitAnd", src1, src2, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterBitOr ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result ("MMX BitOr", src1, src2, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterBitOr ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result (" C  BitOr", src1, src2, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterAdd ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result ("MMX Add", src1, src2, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterAdd ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result (" C  Add", src1, src2, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterAbsDiff ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result ("MMX AbsDiff", src1, src2, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterAbsDiff ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result (" C  AbsDiff", src1, src2, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterMean ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result ("MMX Mean", src1, src2, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterMean ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result (" C  Mean", src1, src2, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterSub ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result ("MMX Sub", src1, src2, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterSub ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result (" C  Sub", src1, src2, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterMult ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result ("MMX Mult", src1, src2, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterMult ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result (" C  Mult", src1, src2, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterMultNor ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result ("ASM MultNor", src1, src2, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterMultNor ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result (" C  MultNor", src1, src2, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterMultDivby2 ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result ("MMX MultDivby2", src1, src2, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterMultDivby2 ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result (" C  MultDivby2", src1, src2, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterMultDivby4 ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result ("MMX MultDivby4", src1, src2, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterMultDivby4 ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result (" C  MultDivby4", src1, src2, dst);


 printf ("---\n");
 
 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterDiv ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result ("ASM Div", src1, src2, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterDiv ((unsigned char *)src1,(unsigned char *)src2,(unsigned char *)dst,15);
 print_result (" C  Div", src1, src2, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterBitNegation ((unsigned char *)src1,(unsigned char *)dst,15);
 print_result_src1 ("MMX BitNegation", src1, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterBitNegation ((unsigned char *)src1,(unsigned char *)dst,15);
 print_result_src1 (" C  BitNegation", src1, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterAddByte ((unsigned char *)src1,(unsigned char *)dst,15, 3);
 print_result_src1 ("MMX AddByte(3)", src1, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterAddByte ((unsigned char *)src1,(unsigned char *)dst,15, 3);
 print_result_src1 (" C  AddByte(3)", src1, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterAddByteToHalf ((unsigned char *)src1,(unsigned char *)dst,15, 3);
 print_result_src1 ("MMX AddByteToHalf(3)", src1, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterAddByteToHalf ((unsigned char *)src1,(unsigned char *)dst,15, 3);
 print_result_src1 (" C  AddByteToHalf(3)", src1, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterSubByte ((unsigned char *)src1,(unsigned char *)dst,15, 3);
 print_result_src1 ("MMX SubByte(3)", src1, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterSubByte ((unsigned char *)src1,(unsigned char *)dst,15, 3);
 print_result_src1 (" C  SubByte(3)", src1, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterShiftRight ((unsigned char *)src1,(unsigned char *)dst,15, 1);
 print_result_src1 ("MMX ShiftRight(1)", src1, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterShiftRight ((unsigned char *)src1,(unsigned char *)dst,15, 1);
 print_result_src1 (" C  ShiftRight(1)", src1, dst);

 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterMultByByte ((unsigned char *)src1,(unsigned char *)dst,15, 3);
 print_result_src1 ("MMX MultByByte(3)", src1, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterMultByByte ((unsigned char *)src1,(unsigned char *)dst,15, 3);
 print_result_src1 (" C  MultByByte(3)", src1, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterShiftRightAndMultByByte ((unsigned char *)src1,(unsigned char *)dst,15, 1, 3);
 print_result_src1 ("MMX ShiftRightAndMultByByte(1,3)", src1, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterShiftRightAndMultByByte ((unsigned char *)src1,(unsigned char *)dst,15, 1, 3);
 print_result_src1 (" C  ShuftRightAndMultByByte(1,3)", src1, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterShiftLeftByte ((unsigned char *)src1,(unsigned char *)dst,15, 3);
 print_result_src1 ("MMX ShiftLeftByte(3)", src1, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterShiftLeftByte ((unsigned char *)src1,(unsigned char *)dst,15, 3);
 print_result_src1 (" C  ShiftLeftByte(3)", src1, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterShiftLeft ((unsigned char *)src1,(unsigned char *)dst,15, 3);
 print_result_src1 ("MMX ShiftLeft(3)", src1, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterShiftLeft ((unsigned char *)src1,(unsigned char *)dst,15, 3);
 print_result_src1 (" C  ShiftLeft(3)", src1, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterBinarizeUsingThreshold ((unsigned char *)src1,(unsigned char *)dst,15, 2);
 print_result_src1 ("MMX BinarizeUsingThreshold(2)", src1, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterBinarizeUsingThreshold ((unsigned char *)src1,(unsigned char *)dst,15, 2);
 print_result_src1 (" C  BinarizeUsingThreshold(2)", src1, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterClipToRange ((unsigned char *)src1,(unsigned char *)dst,15, 1,7);
 print_result_src1 ("MMX ClipToRange(1,7)", src1, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterClipToRange ((unsigned char *)src1,(unsigned char *)dst,15, 1,7);
 print_result_src1 (" C  ClipToRange(1,7)", src1, dst);


 printf ("---\n");

 SDL_imageFilterMMXon();

 setup_src(src1, src2);
 SDL_imageFilterNormalizeLinear ((unsigned char *)src1,(unsigned char *)dst,15, 0,33,0,255);
 print_result_src1 ("MMX NormalizeLinear(0,33,0,255)", src1, dst);

 SDL_imageFilterMMXoff();

 setup_src(src1, src2);
 SDL_imageFilterNormalizeLinear ((unsigned char *)src1,(unsigned char *)dst,15, 0,33,0,255);
 print_result_src1 (" C  NormalizeLinear(0,33,0,255)", src1, dst);

 exit(0);
}

