#!/usr/bin/perl -w

# basic testing of SDL::Mixer

use Test::More tests => 4;
use strict;
use vars qw/@INC/;

BEGIN
  {
  unshift @INC, ('../blib/lib');
  unshift @INC, ('../blib/arch');
  chdir 't' if -d 't';
  use_ok( 'SDL::Mixer' ); 
  }
  
can_ok ('SDL::Mixer', qw/
	new
	query_spec
	reserve_channels
	allocate_channels
	group_channel
	group_channels
	group_available
	group_count
	group_oldest
	group_newer
	play_channel
	play_music
	fade_in_channel
	fade_in_music
	channel_volume
	music_volume
	halt_channel
	halt_group
	halt_music
	channel_expire
	fade_out_channel
	fade_out_group
	fade_out_music
	fading_music
	fading_channel
	pause
	resume
	paused
	pause_music
	resume_music
	rewind_music
	music_paused
	playing
	playing_music
	/);

use SDL::Event;

# these are exported by defaultby Event, so main:: should know them:
can_ok ('main', qw/
	MIX_MAX_VOLUME
	MIX_DEFAULT_FREQUENCY
	MIX_DEFAULT_FORMAT
	MIX_DEFAULT_CHANNELS
	MIX_NO_FADING
	MIX_FADING_OUT
	MIX_FADING_IN
	AUDIO_U8
	AUDIO_S8
	AUDIO_U16
	AUDIO_S16
	AUDIO_U16MSB
	AUDIO_S16MSB
	/);

my $mixer = SDL::Mixer->new();
is (ref($mixer), 'SDL::Mixer', 'new was ok');

