function gensdpafile(filename,mDIM,nBLOCK,bLOCKsTRUCT,c,F)
% 
% Generate SDP data file with SDPA Sparse format
% 
% gensdpafile(filename,mDIM,nBLOCK,bLOCKsTRUCT,c,F)
% 
% <INPUT>
% - filename   : string    ; generated filename
% - mDIM       : integer   ; number of decision variables
% - nBLOCK     : integer   ; number of blocks of F
% - bLOCKsTRUCT: vector    ; represetns the block structure of F
% - c          : vector    ; coefficient vector
% - F          : cell array; coefficient matrices
% 

% This file is a component of SDPA
% Copyright (C) 2004-2012 SDPA Project
% 
% This program is free software; you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation; either version 2 of the License, or
% (at your option) any later version.
%
% This program is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
% 
% You should have received a copy of the GNU General Public License
% along with this program; if not, write to the Free Software
% Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
%
% SDPA-M: $Revision: 6.2 $
% $Id: gensdpafile.m,v 6.2 2005/05/28 02:36:40 drophead Exp $

% check the validity of arguments
if nargin ~= 6
  error('input arguments must be 6.');
elseif ~ischar(filename)
  error('1st argument must be a filename.');
end

% open file
fid=fopen(filename, 'w');
if fid == -1
  error(sprintf('Failed to open %s.', filename));
end

% comment
stamp=clock;
fprintf(fid,...
  '"Generated by gensdpafile() %04d/%02d/%02d %02d:%02d:%02d"\n',...
  stamp(1),stamp(2),stamp(3),stamp(4),stamp(5),fix(stamp(6)));

% mDIM
fprintf(fid, '%d\n', mDIM);
% nBLOCK
fprintf(fid, '%d\n', nBLOCK);

% bLOCKsTRUCT
for l=1:nBLOCK
  if l~= nBLOCK
    fprintf(fid,'%d,', bLOCKsTRUCT(l));
  else
    fprintf(fid,'%d\n', bLOCKsTRUCT(l));
  end
end

% cost vector c
for k=1:mDIM
  if k ~= mDIM
    fprintf(fid,'%g,', c(k));
  else
    fprintf(fid,'%g\n', c(k));
  end
end

% coefficient matrices F => Sparse format
for k=1:mDIM+1
  for l=1:nBLOCK
    dim=abs(bLOCKsTRUCT(l));
    tmpF=F{l,k};
    if isempty(tmpF) 
      continue; 
    end
    [m,n]=size(tmpF);
    if m == dim & n == dim & bLOCKsTRUCT(l) > 0
      % normal block
      for i=1:dim
	for j=1:dim
	  if (i <= j & tmpF(i,j) ~= 0)
	    % upper triangle part only
	    fprintf(fid, '%d,%d,%d,%d,%g\n',k-1,l,i,j,tmpF(i,j));
	  end
	end
      end
    elseif ( m==1 | n==1 ) & m*n==dim & bLOCKsTRUCT(l) < 0
      % diagonal block with vector
      for i=1:dim
	if tmpF(i) ~= 0
	  fprintf(fid, '%d,%d,%d,%d,%g\n',k-1,l,i,i,tmpF(i));
	end
      end
    elseif m == dim & n == dim & bLOCKsTRUCT(l) < 0
      % diagonal block with matrix
      for i=1:dim
	if tmpF(i,i) ~= 0
	  fprintf(fid, '%d,%d,%d,%d,%g\n',k-1,l,i,i,tmpF(i,i));
	end
      end
    else
      error(sprintf('Inconsistent data at F{%d,%d}',l,k));
      fclose(fid);
      return;
    end
  end
end

% close file
fclose(fid);

% End of File