#include <sys/types.h>

#ifdef __MSW__
# include <windows.h>
#endif
#include <GL/gl.h>
#include <GL/glu.h>

#include "gw.h"
#include "sar.h"
#include "sardraw.h"
#include "sardrawdefs.h"
#include "config.h"


void SARDrawBoxNS(float x_len, float y_len, float z_len);
void SARDrawBoxBaseNS(
	float x_len, float y_len, float z_len,
	Boolean draw_base
);


#define SWAP_VALUES_D(x,y)	\
{ float t = x;			\
  x = y; y = t;			\
}


/*
 *      Draws a box at the center, normals set for smooth finish.
 */
void SARDrawBoxNS(
        float x_len, float y_len, float z_len
)
{
        float x_min, x_max;
        float y_min, y_max;
        float z_min, z_max;

        x_max = x_len / 2.0f;
        x_min = -x_max;
        if(x_max < x_min)
            SWAP_VALUES_D(x_min, x_max);

        y_max = y_len / 2.0f;
        y_min = -y_max;
        if(y_max < y_min)
            SWAP_VALUES_D(y_min, y_max);

        z_max = z_len / 2.0f;
        z_min = -z_max;
        if(z_max < z_min)
            SWAP_VALUES_D(z_min, z_max);

        /* Front and back. */
        glNormal3f(-0.33f, -0.33f, -0.88f);
        glVertex3f(x_min, z_min, -y_max);
        glNormal3f(-0.33f, 0.33f, -0.88f);
        glVertex3f(x_min, z_max, -y_max);
        glNormal3f(0.33f, 0.33f, -0.88f);
        glVertex3f(x_max, z_max, -y_max);
        glNormal3f(0.33f, -0.33f, -0.88f);
        glVertex3f(x_max, z_min, -y_max);

        glNormal3f(-0.33f, 0.33f, 0.88f);
        glVertex3f(x_min, z_max, -y_min);
        glNormal3f(-0.33f, -0.33f, 0.88f);
        glVertex3f(x_min, z_min, -y_min);
        glNormal3f(0.33f, -0.33f, 0.88f);
        glVertex3f(x_max, z_min, -y_min);
        glNormal3f(0.33f, 0.33f, 0.88f);
        glVertex3f(x_max, z_max, -y_min);

        /* Left and right. */
        glNormal3f(-0.88f, 0.33f, -0.33f);
        glVertex3f(x_min, z_max, -y_max);
        glNormal3f(-0.88f, -0.33f, -0.33f);
        glVertex3f(x_min, z_min, -y_max);
        glNormal3f(-0.88f, -0.33f, 0.33f);
        glVertex3f(x_min, z_min, -y_min);
        glNormal3f(-0.88f, 0.33f, 0.33f);
        glVertex3f(x_min, z_max, -y_min);

        glNormal3f(0.88f, -0.33f, -0.33f);
        glVertex3f(x_max, z_min, -y_max);
        glNormal3f(0.88f, 0.33f, -0.33f);
        glVertex3f(x_max, z_max, -y_max);
        glNormal3f(0.88f, 0.33f, 0.33f);
        glVertex3f(x_max, z_max, -y_min);
        glNormal3f(0.88f, -0.33f, 0.33f);
        glVertex3f(x_max, z_min, -y_min);

        /* Top and bottom. */
        glNormal3f(-0.33f, 0.88f, 0.33f);
        glVertex3f(x_min, z_max, -y_min);
        glNormal3f(0.33f, 0.88f, 0.33f);
        glVertex3f(x_max, z_max, -y_min);
        glNormal3f(0.33f, 0.88f, -0.33f);
        glVertex3f(x_max, z_max, -y_max);
        glNormal3f(-0.33f, 0.88f, -0.33f);
        glVertex3f(x_min, z_max, -y_max);

        glNormal3f(-0.33f, -0.88f, -0.33f);
        glVertex3f(x_min, z_min, -y_max);
        glNormal3f(0.33f, -0.88f, -0.33f);
        glVertex3f(x_max, z_min, -y_max);
        glNormal3f(0.33f, -0.88f, 0.33f);
        glVertex3f(x_max, z_min, -y_min);
        glNormal3f(-0.33f, -0.88f, 0.33f);
        glVertex3f(x_min, z_min, -y_min);
}

/*
 *	Draws a box in the positive octant with respect to the xy
 *	plane, the xy walls are centered, normals are set for smooth
 *	finish.
 *
 *	If draw_base is False then the bottom of the box is not closed.
 */
void SARDrawBoxBaseNS(
        float x_len, float y_len, float z_len,
	Boolean draw_base
)
{
        float x_min, x_max;
        float y_min, y_max;
        float z_min, z_max;

        x_max = x_len / 2;
        x_min = -x_max;
        if(x_max < x_min)
            SWAP_VALUES_D(x_min, x_max);

        y_max = y_len / 2;
        y_min = -y_max;
        if(y_max < y_min)
            SWAP_VALUES_D(y_min, y_max);

        z_min = 0;
        z_max = z_len;
	if(z_max < z_min)
	    SWAP_VALUES_D(z_min, z_max);

        /* Front and back. */
        glNormal3f(-0.33f, -0.33f, -0.88f);
        glVertex3f(x_min, z_min, -y_max);
        glNormal3f(-0.33f, 0.33f, -0.88f);
        glVertex3f(x_min, z_max, -y_max);
        glNormal3f(0.33f, 0.33f, -0.88f);
        glVertex3f(x_max, z_max, -y_max);
        glNormal3f(0.33f, -0.33f, -0.88f);
        glVertex3f(x_max, z_min, -y_max);

        glNormal3f(-0.33f, 0.33f, 0.88f);
        glVertex3f(x_min, z_max, -y_min);
        glNormal3f(-0.33f, -0.33f, 0.88f);
        glVertex3f(x_min, z_min, -y_min);
        glNormal3f(0.33f, -0.33f, 0.88f);
        glVertex3f(x_max, z_min, -y_min);
        glNormal3f(0.33f, 0.33f, 0.88f);
        glVertex3f(x_max, z_max, -y_min);

        /* Left and right. */
        glNormal3f(-0.88f, 0.33f, -0.33f);
        glVertex3f(x_min, z_max, -y_max);
        glNormal3f(-0.88f, -0.33f, -0.33f);
        glVertex3f(x_min, z_min, -y_max);
        glNormal3f(-0.88f, -0.33f, 0.33f);
        glVertex3f(x_min, z_min, -y_min);
        glNormal3f(-0.88f, 0.33f, 0.33f);
        glVertex3f(x_min, z_max, -y_min);

        glNormal3f(0.88f, -0.33f, -0.33f);
        glVertex3f(x_max, z_min, -y_max);
        glNormal3f(0.88f, 0.33f, -0.33f);
        glVertex3f(x_max, z_max, -y_max);
        glNormal3f(0.88f, 0.33f, 0.33f);
        glVertex3f(x_max, z_max, -y_min);
        glNormal3f(0.88f, -0.33f, 0.33f);
        glVertex3f(x_max, z_min, -y_min);

        /* Top. */
        glNormal3f(-0.33f, 0.88f, 0.33f);
        glVertex3f(x_min, z_max, -y_min);
        glNormal3f(0.33f, 0.88f, 0.33f);
        glVertex3f(x_max, z_max, -y_min);
        glNormal3f(0.33f, 0.88f, -0.33f);
        glVertex3f(x_max, z_max, -y_max);
        glNormal3f(-0.33f, 0.88f, -0.33f);
        glVertex3f(x_min, z_max, -y_max);

	/* Bottom. */
	if(draw_base)
	{
            glNormal3f(-0.33f, -0.88f, -0.33f);
            glVertex3f(x_min, z_min, -y_max);
            glNormal3f(0.33f, -0.88f, -0.33f);
            glVertex3f(x_max, z_min, -y_max);
            glNormal3f(0.33f, -0.88f, 0.33f);
            glVertex3f(x_max, z_min, -y_min);
            glNormal3f(-0.33f, -0.88f, 0.33f);
            glVertex3f(x_min, z_min, -y_min);
	}
}
