#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <gdk/gdkkeysyms.h>

#include "callbacks.h"
#include "interface.h"
#include "support.h"
#include "search.h"
#include "lgpl.h"

/* Top level definitions */
GtkWidget *testRegExDialog1 = NULL;
GtkWidget *fileRegexWizard = NULL;
GtkWidget *contextRegexWizard = NULL;

void
on_window1_destroy                     (GtkObject       *object,
                                        gpointer         user_data)
{
  gtk_main_quit();
}


void
on_menubar1_realize                    (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GKeyFile *keyString = getGKeyFile(widget);
  realizeMenuCheck(widget, keyString, "menuOptions", "word_wrap1");
  realizeMenuCheck(widget, keyString, "menuOptions", "toolbar2");
  realizeMenuCheck(widget, keyString, "menuOptions", "status_bar1");
  realizeMenuCheck(widget, keyString, "menuOptions", "one_phase_searching1");  

  /* Store radio check status */
  realizeMenuCheck(widget, keyString, "menuOptions", "file_name1");
  realizeMenuCheck(widget, keyString, "menuOptions", "location1");
  realizeMenuCheck(widget, keyString, "menuOptions", "size1");
  realizeMenuCheck(widget, keyString, "menuOptions", "type1");
  realizeMenuCheck(widget, keyString, "menuOptions", "modified1");
}


void
on_menubar1_unrealize                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GKeyFile *keyString = getGKeyFile(widget);
  unrealizeMenuCheck(widget, keyString, "menuOptions", "word_wrap1");
  unrealizeMenuCheck(widget, keyString, "menuOptions", "toolbar2");
  unrealizeMenuCheck(widget, keyString, "menuOptions", "status_bar1");
  unrealizeMenuCheck(widget, keyString, "menuOptions", "one_phase_searching1");

  /* Store radio check status */
  unrealizeMenuCheck(widget, keyString, "menuOptions", "file_name1");
  unrealizeMenuCheck(widget, keyString, "menuOptions", "location1");
  unrealizeMenuCheck(widget, keyString, "menuOptions", "size1");
  unrealizeMenuCheck(widget, keyString, "menuOptions", "type1");
  unrealizeMenuCheck(widget, keyString, "menuOptions", "modified1");
}


void
on_new2_activate                       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  spawnNewSearchmonkey();
}


void
on_open_criteria1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  importCriteria(GTK_WIDGET(menuitem));
}


void
on_save_criteria1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  exportCriteria(GTK_WIDGET(menuitem));
}


void
on_save_results1_activate              (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  saveResults(GTK_WIDGET(menuitem));
}


void
on_print1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_print_preview1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_print_setup1_activate               (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_quit1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GObject *window1 = G_OBJECT(lookup_widget(GTK_WIDGET(menuitem), "window1"));
  gtk_object_destroy(GTK_OBJECT(window1));
}


void
on_word_wrap1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    gboolean setWordWrap;
    GtkWidget *textBox = lookup_widget(GTK_WIDGET(menuitem), "textview1");
    
    setWordWrap = gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem));
    gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(textBox), setWordWrap);
}


void
on_set_font1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    gchar *newFont;
    GtkWidget *textView = lookup_widget(GTK_WIDGET(menuitem), "textview1");
    
    GtkFontSelectionDialog *dialog = GTK_FONT_SELECTION_DIALOG(create_fontSelectionDialog());
    PangoContext* context = gtk_widget_get_pango_context  (textView);
    PangoFontDescription *desc = pango_context_get_font_description(context);    
    newFont = pango_font_description_to_string(desc);
    
    gtk_font_selection_dialog_set_font_name(dialog, newFont);
    if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK) {
      newFont = gtk_font_selection_dialog_get_font_name(dialog);
      if (newFont != NULL) { 
        desc = pango_font_description_from_string (newFont);
        if (desc != NULL) {
          gtk_widget_modify_font (GTK_WIDGET(textView), desc);
          pango_font_description_free(desc);
        }
        g_free(newFont);
      }
    }
    gtk_widget_destroy(GTK_WIDGET(dialog));
}


void
on_set_highligting_colour1_activate    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GdkColor color, *cp;
    GtkTextView *textView = GTK_TEXT_VIEW(lookup_widget(GTK_WIDGET(menuitem), "textview1"));
    GtkTextBuffer* textBuf = gtk_text_view_get_buffer (textView);
    GtkTextTagTable* tagTable = gtk_text_buffer_get_tag_table(textBuf);
    GtkTextTag* tag = gtk_text_tag_table_lookup(tagTable, "word_highlight");
    GtkWidget *dialog = create_highlightColourDialog();
    GtkColorSelection *colorsel = GTK_COLOR_SELECTION(lookup_widget(dialog, "color_selection1"));
    g_object_get( G_OBJECT(tag), "foreground-gdk", &cp, NULL);
    gtk_color_selection_set_current_color(colorsel, cp);
    gdk_color_free(cp);
    if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK) {
        GtkColorSelection *colorsel = GTK_COLOR_SELECTION(lookup_widget(dialog, "color_selection1"));
        gtk_color_selection_get_current_color(colorsel, &color);
        g_object_set( G_OBJECT(tag), "foreground-gdk", &color, NULL);
    }
    gtk_widget_destroy(dialog);
}


void
on_cl_ear_history1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkToggleButton *check;
    GtkComboBox *combo;
    gchar *activeText;
    GtkEntry *entry;
    GtkWidget *dialog = create_clearSearchHistoryDialog();

    if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK) {
        /* Clear file names? */
        check = GTK_TOGGLE_BUTTON(lookup_widget(dialog, "clearFileNamesCheck"));
        if(gtk_toggle_button_get_active(check)) {
            clearComboBox(lookup_widget(GTK_WIDGET(menuitem), "fileName"));
        }

        /* Clear containing text? */
        check = GTK_TOGGLE_BUTTON(lookup_widget(dialog, "clearContainingTextCheck"));
        if(gtk_toggle_button_get_active(check)) {
            clearComboBox(lookup_widget(GTK_WIDGET(menuitem), "containingText"));
        }

        /* Clear look in? */
        check = GTK_TOGGLE_BUTTON(lookup_widget(dialog, "clearLookInCheck"));
        if(gtk_toggle_button_get_active(check)) {
            clearComboBox(lookup_widget(GTK_WIDGET(menuitem), "lookIn"));
        }

        /* Clear size/modified? */
        check = GTK_TOGGLE_BUTTON(lookup_widget(dialog, "resetSizeModifiedCheck"));
        if(gtk_toggle_button_get_active(check)) {
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(menuitem), "lessThanCheck")), FALSE);
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(menuitem), "moreThanCheck")), FALSE);
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(menuitem), "afterCheck")), FALSE);
            gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(menuitem), "beforeCheck")), FALSE);

            entry = GTK_ENTRY(lookup_widget(GTK_WIDGET(menuitem), "lessThanEntry"));
            gtk_entry_set_text(entry, "");
            entry = GTK_ENTRY(lookup_widget(GTK_WIDGET(menuitem), "moreThanEntry"));
            gtk_entry_set_text(entry, "");
            entry = GTK_ENTRY(lookup_widget(GTK_WIDGET(menuitem), "afterEntry"));
            gtk_entry_set_text(entry, "");
            entry = GTK_ENTRY(lookup_widget(GTK_WIDGET(menuitem), "beforeEntry"));
            gtk_entry_set_text(entry, "");
        }
    }
    gtk_widget_destroy(dialog);
}


void
on_delete1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  deleteFile (GTK_WIDGET(menuitem));
}


void
on_copy2_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  copyFile (GTK_WIDGET(menuitem));
}


void
on_toolbar2_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
    GtkWidget *widget = lookup_widget(GTK_WIDGET(menuitem), "toolbar1");
    if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem))) {
        gtk_widget_show(widget);
    } else {
        gtk_widget_hide(widget);
    }
}


void
on_status_bar1_activate                (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *widget = lookup_widget(GTK_WIDGET(menuitem), "statusbar1");
  if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem))) {
    gtk_widget_show(widget);
  } else {
    gtk_widget_hide(widget);
  }
}


void
on_file_name1_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem))) {
    columnClick(GTK_WIDGET(menuitem), FILENAME_COLUMN);
  }
}


void
on_location1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem))) {
    columnClick(GTK_WIDGET(menuitem), LOCATION_COLUMN);
  }
}


void
on_size1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem))) {
    columnClick(GTK_WIDGET(menuitem), INT_SIZE_COLUMN);
  }
}


void
on_type1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem))) {
    columnClick(GTK_WIDGET(menuitem), TYPE_COLUMN);
  }
}


void
on_modified1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem))) {
    columnClick(GTK_WIDGET(menuitem), INT_MODIFIED_COLUMN);
  }
}


void
on_search1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_playButton_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  start_search_thread(GTK_WIDGET(menuitem));
}


void
on_stopButton_activate                 (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  stop_search_thread(GTK_WIDGET(menuitem));
}


void
on_one_phase_searching1_activate       (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_configuration1_activate             (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWidget *dialog = create_configDialog();

  realize_configDialog(dialog);

  switch (gtk_dialog_run(GTK_DIALOG(dialog))) {
  case GTK_RESPONSE_OK:
    unrealize_configDialog(dialog);
    break;
  default:
    break;
  }
  gtk_widget_destroy(dialog);
}


void
on_test1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_reg_expression1_activate            (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (testRegExDialog1 == NULL) {
    testRegExDialog1 = create_testRegExDialog();
    gtk_widget_show(testRegExDialog1);
  } else {
    gtk_widget_grab_focus(lookup_widget(testRegExDialog1, "testEntry"));
  }
}


void
on_1_search1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{

}


void
on_contents1_activate                  (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  SMsyscall("http://searchmonkey.sourceforge.net/index.php/SearchMonkey_User_Guide", BROWSER_LIST);
}


void
on_support1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  SMsyscall("http://sourceforge.net/support/getsupport.php?group_id=175143", BROWSER_LIST);
}


void
on_about1_activate                     (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkWindow *main_window = GTK_WINDOW(lookup_widget(GTK_WIDGET(menuitem), "window1"));
  gchar *authors[] = { "Adam Cottrell <cottrela@users.sourceforge.net>", NULL };
  gchar *copyright = "Copyright (c) 2006  Adam Cottrell";
  gchar *name = PACKAGE;
  const gchar *version = VERSION;
  gchar *url = "http://www.sourceforge.net/projects/" PACKAGE;
  gchar *label = PACKAGE " hosted by SourceForge";
  gtk_about_dialog_set_url_hook(openUrlLinkFunc, NULL, NULL);
  gtk_show_about_dialog (main_window,
                         "authors", authors,
                         "copyright", copyright,
                         "name", name,
                         "website-label", label,
                         "version", version,
                         "license", LGPL_LICENSE,
                         "wrap-license", TRUE,
                         "website", url,
                         NULL);
}


void
on_saveResults_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  saveResults(GTK_WIDGET(button));
}


void
on_playButton_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  start_search_thread(GTK_WIDGET(button));
}


void
on_stopButton_clicked                  (GtkButton       *button,
                                        gpointer         user_data)
{
  stop_search_thread(GTK_WIDGET(button));
}


void
on_printResult_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  //    g_print("Creating XML data...\n");
  //    g_print("Printing XML data...\n");
}


void
on_Question_clicked                    (GtkButton       *button,
                                        gpointer         user_data)
{
  SMsyscall("http://sourceforge.net/forum/?group_id=175143", BROWSER_LIST);
}


void
on_searchNotebook_realize              (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GKeyFile *keyString = getGKeyFile(widget);

  /* Create list models for each combo box */
  initComboBox(lookup_widget(widget, "fileName"));
  initComboBox(lookup_widget(widget, "containingText"));
  initComboBox(lookup_widget(widget, "lookIn"));

  addUniqueRow(lookup_widget(widget, "fileName"), ".+"); /* Set default to everything */
  addUniqueRow(lookup_widget(widget, "lookIn"), g_get_home_dir()); /* Set default look in folder */

  /* Store notebook global settings */
  realizeNotebook(widget, keyString, "history", "searchNotebook");
  
  /* Store basic Tab */
  realizeCombo(widget, keyString, "history", "fileName2");
  realizeCombo(widget, keyString, "history", "containingText2");
  realizeToggle(widget, keyString, "history", "containingTextCheck2");
  realizeCombo(widget, keyString, "history", "lookIn2");
  realizeToggle(widget, keyString, "history", "searchSubfoldersCheck2");
  realizeToggle(widget, keyString, "history", "ignoreHiddenFiles");

  /* Store advanced Tab */
  realizeComboModel(widget, keyString, "history", "fileName");
  realizeToggle(widget, keyString, "history", "expertUserCheck");
  realizeComboModel(widget, keyString, "history", "containingText");
  realizeToggle(widget, keyString, "history", "containingTextCheck");
  realizeComboModel(widget, keyString, "history", "lookIn");
  realizeToggle(widget, keyString, "history", "searchSubfoldersCheck");
  realizeToggle(widget, keyString, "history", "moreThanCheck");
  realizeString(widget, keyString, "history", "moreThanEntry");
  realizeToggle(widget, keyString, "history", "lessThanCheck");
  realizeString(widget, keyString, "history", "lessThanEntry");
  realizeToggle(widget, keyString, "history", "afterCheck");
  realizeString(widget, keyString, "history", "afterEntry");
  realizeToggle(widget, keyString, "history", "beforeCheck");
  realizeString(widget, keyString, "history", "beforeEntry");

  /* Store Options Tab */
  realizeToggle(widget, keyString, "history", "regularExpressionCheckContents");
  realizeToggle(widget, keyString, "history", "matchCaseCheckContents");
  realizeToggle(widget, keyString, "history", "dosExpressionRadioFile");
  realizeToggle(widget, keyString, "history", "regularExpressionRadioFile");
  realizeToggle(widget, keyString, "history", "notExpressionCheckFile");
  realizeToggle(widget, keyString, "history", "matchCaseCheckFile");
}


void
on_searchNotebook_unrealize            (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GKeyFile *keyString = getGKeyFile(widget);

  /* Store notebook global settings */
  unrealizeNotebook(widget, keyString, "history", "searchNotebook");
  
  /* Store basic Tab */
  unrealizeCombo(widget, keyString, "history", "fileName2");
  unrealizeCombo(widget, keyString, "history", "containingText2");
  unrealizeToggle(widget, keyString, "history", "containingTextCheck2");
  unrealizeCombo(widget, keyString, "history", "lookIn2");
  unrealizeToggle(widget, keyString, "history", "searchSubfoldersCheck2");
  unrealizeToggle(widget, keyString, "history", "ignoreHiddenFiles");

  /* Store advanced Tab */
  unrealizeComboModel(widget, keyString, "history", "fileName");
  unrealizeToggle(widget, keyString, "history", "expertUserCheck");
  unrealizeComboModel(widget, keyString, "history", "containingText");
  unrealizeToggle(widget, keyString, "history", "containingTextCheck");
  unrealizeComboModel(widget, keyString, "history", "lookIn");
  unrealizeToggle(widget, keyString, "history", "searchSubfoldersCheck");
  unrealizeToggle(widget, keyString, "history", "moreThanCheck");
  unrealizeString(widget, keyString, "history", "moreThanEntry");
  unrealizeToggle(widget, keyString, "history", "lessThanCheck");
  unrealizeString(widget, keyString, "history", "lessThanEntry");
  unrealizeToggle(widget, keyString, "history", "afterCheck");
  unrealizeString(widget, keyString, "history", "afterEntry");
  unrealizeToggle(widget, keyString, "history", "beforeCheck");
  unrealizeString(widget, keyString, "history", "beforeEntry");

  /* Store Options Tab */
  unrealizeToggle(widget, keyString, "history", "regularExpressionCheckContents");
  unrealizeToggle(widget, keyString, "history", "matchCaseCheckContents");
  unrealizeToggle(widget, keyString, "history", "dosExpressionRadioFile");
  unrealizeToggle(widget, keyString, "history", "regularExpressionRadioFile");
  unrealizeToggle(widget, keyString, "history", "notExpressionCheckFile");
  unrealizeToggle(widget, keyString, "history", "matchCaseCheckFile");
}


void
on_containingText_changed              (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
  GtkToggleButton *checkBox = GTK_TOGGLE_BUTTON(lookup_widget(GTK_WIDGET(combobox), "containingTextCheck"));
  gchar *test = gtk_combo_box_get_active_text   (combobox);

  if (test == NULL){
    gtk_toggle_button_set_active(checkBox, FALSE);
    return;
  } else {
    if (*test == '\0') {
      gtk_toggle_button_set_active(checkBox, FALSE);
    } else {
      gtk_toggle_button_set_active(checkBox, TRUE);
    }
    free(test);
  }
}


void
on_folderSelector_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkWidget *dialog;
  GtkComboBox *fileWidget;
  gint result;
  const gchar *currentFolderName = (gchar *)gtk_combo_box_get_active_text(GTK_COMBO_BOX(lookup_widget(GTK_WIDGET(button), "lookIn")));
  
  dialog = create_folderChooserDialog();
  gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(dialog), currentFolderName);

  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK) {
    char *filename;
    
    filename = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (dialog));
    fileWidget = GTK_COMBO_BOX(lookup_widget(GTK_WIDGET(button), "lookIn"));
    addUniqueRow(GTK_WIDGET(fileWidget), filename);
    g_free (filename);
  }
  gtk_widget_destroy (dialog);
}


void
on_lessThanCheck_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget *pTextBox = lookup_widget(GTK_WIDGET(togglebutton), "lessThanEntry");
  gtk_widget_set_sensitive(pTextBox, gtk_toggle_button_get_active(togglebutton));
}


void
on_beforeCheck_toggled                 (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget *pTextBox = lookup_widget(GTK_WIDGET(togglebutton), "beforeEntry");
  gtk_widget_set_sensitive(pTextBox, gtk_toggle_button_get_active(togglebutton));
}


void
on_moreThanCheck_toggled               (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget *pTextBox = lookup_widget(GTK_WIDGET(togglebutton), "moreThanEntry");
  gtk_widget_set_sensitive(pTextBox, gtk_toggle_button_get_active(togglebutton));
}


void
on_afterCheck_toggled                  (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget *pTextBox = lookup_widget(GTK_WIDGET(togglebutton), "afterEntry");
  gtk_widget_set_sensitive(pTextBox, gtk_toggle_button_get_active(togglebutton));
}


void
on_expertUserCheck_toggled             (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GtkWidget *basicPage, *advancedPage;
  GtkNotebook *searchNotebook = GTK_NOTEBOOK(lookup_widget(GTK_WIDGET(togglebutton), "searchNotebook"));
  gint pos;
  basicPage = gtk_notebook_get_nth_page(searchNotebook, 0);
  advancedPage = gtk_notebook_get_nth_page(searchNotebook, 1);
  pos = gtk_notebook_get_current_page(searchNotebook);
  if (gtk_toggle_button_get_active(togglebutton)) {
    gtk_widget_hide (basicPage);
    gtk_widget_show (advancedPage);
    if (pos == 0) {
      gtk_notebook_set_current_page(searchNotebook, 1);
    }
  } else {
    gtk_widget_show (basicPage);
    gtk_widget_hide (advancedPage);
    if (pos == 1) {
      gtk_notebook_set_current_page(searchNotebook, 0);
    }
  }
}


void
on_expertUserCheck_unrealize           (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GKeyFile *keyString = getGKeyFile(widget);

  unrealizeToggle(widget, keyString, "history", "expertUserCheck");
}


void
on_expertUserCheck_realize             (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GKeyFile *keyString = getGKeyFile(widget);

  realizeToggle(widget, keyString, "history", "expertUserCheck");

  on_expertUserCheck_toggled(GTK_TOGGLE_BUTTON(widget), user_data); /* ensure that toggle is adherred to */
}


void
on_playButton1_activate                (GtkButton       *button,
                                        gpointer         user_data)
{
    start_search_thread(GTK_WIDGET(button));
}


void
on_treeview1_realize                   (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GKeyFile *keyString = getGKeyFile(widget);
  gboolean autoColumnWidth = ((!g_key_file_has_key (keyString, "configuration", "autoAdjustColumnWidth", NULL)) ||
                              (g_key_file_get_boolean (keyString, "configuration", "autoAdjustColumnWidth", NULL)));

  initTreeView(GTK_TREE_VIEW(widget));
  realizeTreeview(widget, keyString, "history", "treeview", autoColumnWidth); /* restore column widths, search order */
  realizeTreeviewColumns(widget, keyString, "history", "treeview", autoColumnWidth); /* restore column widths, search order */
}


gboolean
on_treeview1_button_press_event        (GtkWidget       *widget,
                                        GdkEventButton  *event,
                                        gpointer         user_data)
{
  GtkWidget *treeview = lookup_widget(widget, "treeview1");
  GtkTreePath *path;
  GtkTreeViewDropPosition *pos;
  GtkTreeSelection *selection = gtk_tree_view_get_selection (GTK_TREE_VIEW(treeview));
  
  /* Capture right button click */
  if ((event->button == 3) && (event->type == GDK_BUTTON_PRESS)) {
    if (gtk_tree_view_get_dest_row_at_pos (GTK_TREE_VIEW(treeview),
                                           event->x, (event->y + TREEVIEW_HEADER_PIXEL_SIZE_Y),
                                           &path, pos)) {
      gtk_tree_selection_select_path (selection, path);
      do_popup_menu(treeview, event);
    }
    
    return TRUE;
    /* or double click detect */
  } else if ((event->button == 1) && (event->type == GDK_2BUTTON_PRESS)) {
    GtkTreeView *treeView = GTK_TREE_VIEW(lookup_widget(widget, "treeview1"));
    gchar *fullFileName = getFullFileName(treeView, FULL_FILENAME_COLUMN);
    
    if (fullFileName != NULL) {
      SMsyscall(fullFileName, TEXTEDITOR_LIST);
      g_free(fullFileName);
    }
    return TRUE;
  }
  

  return FALSE;
}


gboolean
on_treeview1_popup_menu                (GtkWidget       *widget,
                                        gpointer         user_data)
{
  do_popup_menu(widget, NULL);
  return TRUE;
}


void
on_textview1_realize                   (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GKeyFile *keyString = getGKeyFile(widget);
  initTextView(GTK_TEXT_VIEW(widget));

  realizeTextviewFont(widget, keyString, "menuOptions", "font");
  realizeTextviewHighlight(widget, keyString, "menuOptions", "highlight");
}

void
on_textview1_unrealize                 (GtkWidget       *widget,
                                        gpointer         user_data)
{
/* Save state data now! */
  GKeyFile *keyString = getGKeyFile(widget);
  unrealizeTextviewFont(widget, keyString, "menuOptions", "font");
  unrealizeTextviewHighlight(widget, keyString, "menuOptions", "highlight");
}


void
on_statusbar1_realize                  (GtkWidget       *widget,
                                        gpointer         user_data)
{
  statusbarData *status;
  GObject *main_window = G_OBJECT(lookup_widget(widget, "window1"));
  
  createStatusbarData(main_window, MASTER_STATUSBAR_DATA);

  status = g_object_get_data(main_window, MASTER_STATUSBAR_DATA);
  g_sprintf(status->constantString, "Ready");
  gtk_statusbar_push(GTK_STATUSBAR(widget), STATUSBAR_CONTEXT_ID(GTK_STATUSBAR(widget)), status->constantString);
}


void
on_open1_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkTreeView *treeView = GTK_TREE_VIEW(lookup_widget(GTK_WIDGET(menuitem), "treeview1"));
  gchar *fullFileName = getFullFileName(treeView, FULL_FILENAME_COLUMN);

  if (fullFileName != NULL) {
    SMsyscall(fullFileName, TEXTEDITOR_LIST);
    g_free(fullFileName);
  }
  
  detachMenu(menuitem);
}


void
on_copy3_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  copyFile(GTK_WIDGET(menuitem));
    
  detachMenu(menuitem);
}


void
on_delete2_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  deleteFile (GTK_WIDGET(menuitem));
  detachMenu(menuitem);
}


void
on_explore1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  GtkTreeView *treeView = GTK_TREE_VIEW(lookup_widget(GTK_WIDGET(menuitem), "treeview1"));
  gchar *location = getFullFileName(treeView, LOCATION_COLUMN);

  if (location != NULL) {
    SMsyscall(location, FILEEXPLORER_LIST);
    g_free(location);
  }
  
  detachMenu(menuitem);
}


void
on_cancel1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  detachMenu(menuitem);
}


void
on_testRegExDialog_response            (GtkDialog       *dialog,
                                        gint             response_id,
                                        gpointer         user_data)
{
    switch (response_id) {
        case GTK_RESPONSE_APPLY:
            refreshTestResults(GTK_WIDGET(dialog));
            break;
        default:
            testRegExDialog1 = NULL;
            gtk_widget_destroy(GTK_WIDGET(dialog));
            break;
    }
}


void
on_SampleTextView_realize              (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GtkTextBuffer *buffer = gtk_text_view_get_buffer (GTK_TEXT_VIEW(widget));
  GtkTextTag *tag;
  
  tag = gtk_text_buffer_create_tag (buffer, "word_highlight",
                                    "foreground", "blue",
                                    "underline", PANGO_UNDERLINE_SINGLE,
                                    "underline-set", TRUE,
                                    NULL);
#ifdef NOT_YET
  tag = gtk_text_buffer_create_tag (buffer, "word_highlight1",
                                    "foreground", "lightBlue",
                                    NULL);
#endif
}


void
on_expWizard_response                  (GtkDialog       *dialog,
                                        gint             response_id,
                                        gpointer         user_data)
{
    gint cpage;
    gint typeRegex = (gint)g_object_get_data(G_OBJECT(dialog), "regexType");
    GtkNotebook *expNotebook = GTK_NOTEBOOK(lookup_widget(GTK_WIDGET(dialog), "notebook2"));
    GtkEntry *output = GTK_ENTRY(lookup_widget(GTK_WIDGET(dialog), "resultExp"));
    gchar *finalRegex;
    GtkComboBox *retCombo;
    gint maxPages = gtk_notebook_get_n_pages (expNotebook);
    
    if (typeRegex == FILE_REGEX_TYPE) {
        retCombo = GTK_COMBO_BOX(lookup_widget(mainWindowApp, "fileName"));
    } else if (typeRegex == CONTEXT_REGEX_TYPE) {
        retCombo = GTK_COMBO_BOX(lookup_widget(mainWindowApp, "containingText"));
    } else {
        g_print ("Internal Error! Unable to find calling wizard type!");
        gtk_widget_destroy(GTK_WIDGET(dialog));
        return;
    }
    
    switch (response_id) {
        case GTK_RESPONSE_ACCEPT:
            cpage = gtk_notebook_get_current_page(expNotebook) + 1;
            gtk_notebook_set_current_page(expNotebook, cpage);
            break;
        case GTK_RESPONSE_REJECT:
            cpage = gtk_notebook_get_current_page(expNotebook) - 1;
            gtk_notebook_set_current_page(expNotebook, cpage);
            break;
        case GTK_RESPONSE_OK:
            finalRegex = (gchar *)gtk_entry_get_text(output);
            if (*finalRegex != '\0') {
                addUniqueRow(GTK_WIDGET(retCombo), finalRegex);
            }
            /* Do not break here! We want the widget to be destroyed! */
        default:
            if (typeRegex == FILE_REGEX_TYPE) {
                fileRegexWizard = NULL;
            } else if (typeRegex == CONTEXT_REGEX_TYPE) {
                contextRegexWizard = NULL;
            }
            gtk_widget_destroy(GTK_WIDGET(dialog));
            break;
    }
}


void
on_startType_changed                   (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
    GtkWidget *entry = lookup_widget(GTK_WIDGET(combobox), "startEntry");
    GtkWidget *repeat = lookup_widget(GTK_WIDGET(combobox), "startOccurance");
    updateTypeChangeEntry(combobox, entry, repeat);
    updateRegExWizard(GTK_WIDGET(combobox));
}


void
on_startEntry_changed                  (GtkEditable     *editable,
                                        gpointer         user_data)
{
    updateRegExWizard(GTK_WIDGET(editable));
}


void
on_startOccurance_changed              (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
    updateRegExWizard(GTK_WIDGET(combobox));
}


void
on_midType_changed                     (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
    GtkWidget *entry = lookup_widget(GTK_WIDGET(combobox), "midEntry");
    GtkWidget *repeat = lookup_widget(GTK_WIDGET(combobox), "midOccurance");

    updateTypeChangeEntry(combobox, entry, repeat);
    updateRegExWizard(GTK_WIDGET(combobox));
    
}


void
on_midEntry_changed                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
    updateRegExWizard(GTK_WIDGET(editable));
}


void
on_midOccurance_changed                (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
    updateRegExWizard(GTK_WIDGET(combobox));
}


void
on_endType_changed                     (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
    GtkWidget *entry = lookup_widget(GTK_WIDGET(combobox), "endEntry");
    GtkWidget *repeat = lookup_widget(GTK_WIDGET(combobox), "endOccurance");
    updateTypeChangeEntry(combobox, entry, repeat);
    updateRegExWizard(GTK_WIDGET(combobox));
}


void
on_endEntry_changed                    (GtkEditable     *editable,
                                        gpointer         user_data)
{
    updateRegExWizard(GTK_WIDGET(editable));
}


void
on_endOccurance_changed                (GtkComboBox     *combobox,
                                        gpointer         user_data)
{
    updateRegExWizard(GTK_WIDGET(combobox));
}


void
on_regExpWizard1_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
    /* Create filename wizard */
    if (fileRegexWizard == NULL) {
        fileRegexWizard = create_expWizard();
        g_object_set_data(G_OBJECT(fileRegexWizard), "regexType", (gpointer)FILE_REGEX_TYPE); /* file type */
        gtk_widget_show(fileRegexWizard);
    } else {
        gtk_widget_grab_focus(lookup_widget(fileRegexWizard, "startEntry"));
    }
}


void
on_regExpWizard2_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
    /* Create filename wizard */
    if (contextRegexWizard == NULL) {
        contextRegexWizard = create_expWizard();
        g_object_set_data(G_OBJECT(contextRegexWizard), "regexType", (gpointer)CONTEXT_REGEX_TYPE); /* file type */
        gtk_widget_show(contextRegexWizard);
    } else {
        gtk_widget_grab_focus(lookup_widget(contextRegexWizard, "startEntry"));
    }
}


void
on_convertRegex_toggled                (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
    updateRegExWizard(GTK_WIDGET(togglebutton));
}


void
on_addMidContents_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
    GtkComboBox *type = GTK_COMBO_BOX(lookup_widget(GTK_WIDGET(button), "midType"));    
    GtkEntry *entry = GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "midEntry"));
    GtkComboBox *repeat = GTK_COMBO_BOX(lookup_widget(GTK_WIDGET(button), "midOccurance"));
    GtkEntry *iterStr = GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "midSelection"));
    
    appendTableRow(lookup_widget(GTK_WIDGET(button), "midTreeView"),
                   5,
                   gtk_combo_box_get_active_text(type),
                   gtk_entry_get_text(entry),
                   gtk_combo_box_get_active_text(repeat),
                   gtk_combo_box_get_active(type),
                   gtk_combo_box_get_active(repeat));
    gtk_combo_box_set_active(type, 0);
    gtk_entry_set_text(entry, "");
    gtk_combo_box_set_active(repeat, 0);
    gtk_entry_set_text(iterStr, "");
    gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(button), "deleteSelectedContents"), TRUE);
    gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(button), "modifiedSelectedContents"), TRUE);
}


void
on_modifiedSelectedContents_clicked    (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkTreeView *treeview = GTK_TREE_VIEW(lookup_widget(GTK_WIDGET(button), "midTreeView"));
  GtkTreeSelection *selection = gtk_tree_view_get_selection (treeview);
  GtkTreeIter iter;
  GtkTreeModel *model;
  gint type = REGWIZ_NONE;
  gchar *entry = NULL;
  gint repeat = REGWIZ_NONE;
  gchar *iterStr;
  
  if (gtk_tree_selection_get_selected (selection, &model, &iter)) {
    gtk_tree_model_get (model, &iter, REGEX_TYPE_INT_COLUMN, &type,
                        REGEX_ENTRY_COLUMN, &entry,
                        REGEX_REPEAT_INT_COLUMN, &repeat,
                        -1);
    
    gtk_combo_box_set_active(GTK_COMBO_BOX(lookup_widget(GTK_WIDGET(button), "midType")), type);
    gtk_entry_set_text(GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "midEntry")), entry);
    gtk_combo_box_set_active(GTK_COMBO_BOX(lookup_widget(GTK_WIDGET(button), "midOccurance")), repeat);
    g_free (entry);

    iterStr = gtk_tree_model_get_string_from_iter (model, &iter);
    if (iterStr != NULL) {
      gtk_entry_set_text(GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "midSelection")), iterStr);
      g_free(iterStr);
    }
    
  }
}


void
on_deleteSelectedContents_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkTreeView *treeview = GTK_TREE_VIEW(lookup_widget(GTK_WIDGET(button), "midTreeView"));
  GtkTreeSelection *selection = gtk_tree_view_get_selection (treeview);
  GtkTreeIter iter;
  GtkTreeModel *model;
  GtkComboBox *type = GTK_COMBO_BOX(lookup_widget(GTK_WIDGET(button), "midType"));    
  GtkEntry *entry = GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "midEntry"));
  GtkEntry *iterC = GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "midSelection"));
  GtkComboBox *repeat = GTK_COMBO_BOX(lookup_widget(GTK_WIDGET(button), "midOccurance"));
  
  if (gtk_tree_selection_get_selected (selection, &model, &iter)) {
    gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
    gtk_combo_box_set_active(type, 0);
    gtk_entry_set_text(entry, "");
    gtk_combo_box_set_active(repeat, 0);
    gtk_entry_set_text(iterC, "");
  }
  if (gtk_tree_model_iter_n_children (model, NULL) <= 0) {
    gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(button), "modifiedSelectedContents"), FALSE);
    gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(button), "deleteSelectedContents"), FALSE);
  }
  updateRegExWizard(GTK_WIDGET(button));
}


void
on_midTreeView_realize                 (GtkWidget       *widget,
                                        gpointer         user_data)
{
    GtkTreeViewColumn *column;
    GtkCellRenderer *renderer = gtk_cell_renderer_text_new ();

    GtkListStore *store = gtk_list_store_new (REGEX_N_COLUMNS,
                                              G_TYPE_STRING,
                                              G_TYPE_STRING,
                                              G_TYPE_STRING,
                                              G_TYPE_INT,
                                              G_TYPE_INT,
                                              G_TYPE_INT);
    gtk_tree_view_set_model (GTK_TREE_VIEW(widget), GTK_TREE_MODEL(store));
    g_object_unref (G_OBJECT (store));

    /* Create columns */
    column = gtk_tree_view_column_new_with_attributes ("Type", renderer,
                                                       "text", REGEX_TYPE_COLUMN,
                                                       NULL);
    gtk_tree_view_append_column (GTK_TREE_VIEW (widget), column);

    column = gtk_tree_view_column_new_with_attributes ("Entry", renderer,
                                                       "text", REGEX_ENTRY_COLUMN,
                                                       NULL);
    gtk_tree_view_append_column (GTK_TREE_VIEW (widget), column);

    column = gtk_tree_view_column_new_with_attributes ("Repeat", renderer,
                                                       "text", REGEX_REPEAT_COLUMN,
                                                       NULL);
    gtk_tree_view_append_column (GTK_TREE_VIEW (widget), column);
}


void
on_updateSelectedContents_clicked      (GtkButton       *button,
                                        gpointer         user_data)
{
  GtkTreeView *treeview = GTK_TREE_VIEW(lookup_widget(GTK_WIDGET(button), "midTreeView"));
  GtkTreeIter iter;
  GtkTreeModel *model = gtk_tree_view_get_model (treeview);
  GtkComboBox *type = GTK_COMBO_BOX(lookup_widget(GTK_WIDGET(button), "midType"));    
  GtkEntry *entry = GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "midEntry"));
  GtkEntry *iterC = GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "midSelection"));
  GtkComboBox *repeat = GTK_COMBO_BOX(lookup_widget(GTK_WIDGET(button), "midOccurance"));
  const gchar *iterStr = gtk_entry_get_text(GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "midSelection")));

  g_assert (treeview != NULL);
  g_assert (model != NULL);
  g_assert (type != NULL);
  g_assert (entry != NULL);
  g_assert (repeat != NULL);
  g_assert (iterStr != NULL);
  
  if (*iterStr == '\0') {
    return;
  }
  
  gtk_tree_model_get_iter_from_string (model, &iter, iterStr);
  if (gtk_combo_box_get_active(type) == REGWIZ_DONT_KNOW) {
    gtk_list_store_remove(GTK_LIST_STORE(model), &iter);
    if (gtk_tree_model_iter_n_children (model, NULL) <= 0) {
      gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(button), "modifiedSelectedContents"), FALSE);
      gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(button), "deleteSelectedContents"), FALSE);
    }
    gtk_combo_box_set_active(type, 0);
    gtk_entry_set_text(entry, "");
    gtk_combo_box_set_active(repeat, 0);
    gtk_entry_set_text(iterC, "");
    gtk_entry_set_text(GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "midSelection")), "");
    return; /* Delete entry instead */
  }
    
  gtk_list_store_set (GTK_LIST_STORE(model), &iter,
                      REGEX_TYPE_COLUMN, gtk_combo_box_get_active_text(type),
                      REGEX_ENTRY_COLUMN, gtk_entry_get_text(entry),
                      REGEX_REPEAT_COLUMN, gtk_combo_box_get_active_text(repeat),
                      REGEX_TYPE_INT_COLUMN, gtk_combo_box_get_active(type),
                      REGEX_REPEAT_INT_COLUMN, gtk_combo_box_get_active(repeat),
                      -1);
    gtk_combo_box_set_active(type, 0);
    gtk_entry_set_text(entry, "");
    gtk_combo_box_set_active(repeat, 0);
    gtk_entry_set_text(iterC, "");
    gtk_entry_set_text(GTK_ENTRY(lookup_widget(GTK_WIDGET(button), "midSelection")), "");
}


void
on_midSelection_changed                (GtkEditable     *editable,
                                        gpointer         user_data)
{
  const gchar *selection = gtk_entry_get_text(GTK_ENTRY(editable));
  
  if (*selection != '\0') {
    gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(editable), "updateSelectedContents"), TRUE);
  } else {
    gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(editable), "updateSelectedContents"), FALSE);
  }
}


void
on_expWizard_realize                   (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GKeyFile *keyString = getGKeyFile(mainWindowApp);
  gint widgetType = (gint)g_object_get_data(G_OBJECT(widget), "regexType");

  if (widgetType == FILE_REGEX_TYPE) {
    realizeToggle(widget, keyString, "fileWizardGroup", "skipRegwizHelp");
    gtk_window_set_title (GTK_WINDOW (fileRegexWizard), _("File Expression Wizard"));
  } else if (widgetType == CONTEXT_REGEX_TYPE) {
    realizeToggle(widget, keyString, "contentWizardGroup", "skipRegwizHelp");
    gtk_window_set_title (GTK_WINDOW (contextRegexWizard), _("Context Expression Wizard"));
  }

  if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(widget, "skipRegwizHelp")))) {
    gtk_notebook_set_current_page(GTK_NOTEBOOK(lookup_widget(widget, "notebook2")), 1);
  }
  
  gtk_combo_box_set_active(GTK_COMBO_BOX(lookup_widget(widget, "startType")), REGWIZ_DONT_KNOW);
  gtk_combo_box_set_active(GTK_COMBO_BOX(lookup_widget(widget, "startOccurance")), REGWIZ_REPEAT_ONCE);
  gtk_combo_box_set_active(GTK_COMBO_BOX(lookup_widget(widget, "midType")), REGWIZ_DONT_KNOW);
  gtk_combo_box_set_active(GTK_COMBO_BOX(lookup_widget(widget, "midOccurance")), REGWIZ_REPEAT_ONCE);
  gtk_combo_box_set_active(GTK_COMBO_BOX(lookup_widget(widget, "endType")), REGWIZ_DONT_KNOW);
  gtk_combo_box_set_active(GTK_COMBO_BOX(lookup_widget(widget, "endOccurance")), REGWIZ_REPEAT_ONCE);
}


void
on_expWizard_unrealize                 (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GKeyFile *keyString = getGKeyFile(mainWindowApp);
  gint widgetType = (gint)g_object_get_data(G_OBJECT(widget), "regexType");

  if (widgetType == FILE_REGEX_TYPE) {
    unrealizeToggle(widget, keyString, "fileWizardGroup", "skipRegwizHelp");
  } else if (widgetType == CONTEXT_REGEX_TYPE) {
    unrealizeToggle(widget, keyString, "contentWizardGroup", "skipRegwizHelp");
  }
}


void
on_midTreeView_drag_end                (GtkWidget       *widget,
                                        GdkDragContext  *drag_context,
                                        gpointer         user_data)
{
    updateRegExWizard(widget);
}


void
on_multiFolderSelector_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
#ifdef NOTYET
  GtkWidget *dialog;
  GtkComboBox *fileWidget;
  gint result;
  const gchar *currentFolderName = (gchar *)gtk_combo_box_get_active_text(GTK_COMBO_BOX(lookup_widget(GTK_WIDGET(button), "lookIn")));
  
  dialog = create_folderChooserDialog();
  gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(dialog), currentFolderName);
  gtk_file_chooser_set_select_multiple (GTK_FILE_CHOOSER(dialog), TRUE);
 
  if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_OK) {
//    char *filename;
    GSList*     filenames = gtk_file_chooser_get_filenames  (GTK_FILE_CHOOSER(dialog));
    gchar *tmpStr = (gchar *)g_slist_nth_data(filenames, 0);
    if (tmpStr != NULL) {
        do {
            g_print("%s -- ok1?\n", tmpStr);
            g_free(tmpStr);
        } while (tmpStr);
    }
    tmpStr = (gchar *)g_slist_nth_data(filenames, 1);
    if (tmpStr != NULL) {    
        g_print("%s -- ok2?\n", tmpStr);
        g_free(tmpStr);
    }
    g_slist_free(filenames);
//    filename = gtk_file_chooser_get_current_folder (GTK_FILE_CHOOSER (dialog));
//    fileWidget = GTK_COMBO_BOX(lookup_widget(GTK_WIDGET(button), "lookIn"));
//    addUniqueRow(GTK_WIDGET(fileWidget), filename);
//    g_free (filename);
  }
  gtk_widget_destroy (dialog);
#endif /* NOTYET */
}


void
on_notebook2_switch_page               (GtkNotebook     *notebook,
                                        GtkNotebookPage *page,
                                        guint            page_num,
                                        gpointer         user_data)
{
  if (gtk_notebook_get_current_page(notebook) <= 0) { /* First */
    gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(notebook), "nextScreen"), FALSE);
    gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(notebook), "prevScreen"), TRUE);
  } else if (gtk_notebook_get_current_page(notebook) >= (gtk_notebook_get_n_pages(notebook) - 1)) { /* Last */
    gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(notebook), "nextScreen"), TRUE);
    gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(notebook), "prevScreen"), FALSE);
  } else { /* All other (if any) pages */
    gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(notebook), "nextScreen"), TRUE);
    gtk_widget_set_sensitive(lookup_widget(GTK_WIDGET(notebook), "prevScreen"), TRUE);
  }
}


void
on_configDialog_realize                (GtkWidget       *widget,
                                        gpointer         user_data)
{
    realize_configDialog(widget);
}


void
on_treeview1_unrealize                 (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GKeyFile *keyString = getGKeyFile(widget);
  gboolean autoColumnWidth = ((!g_key_file_has_key (keyString, "configuration", "autoAdjustColumnWidth", NULL)) ||
                              (g_key_file_get_boolean (keyString, "configuration", "autoAdjustColumnWidth", NULL)));
  unrealizeTreeview(widget, keyString, "history", "treeview", autoColumnWidth);
  unrealizeTreeviewColumns(widget, keyString, "history", "treeview", autoColumnWidth);
}

void
on_autoFindExe_clicked                 (GtkButton       *button,
                                        gpointer         user_data)
{
  GThread *threadId;
  gpointer retVal;
  GtkWidget *dialog = create_autoComplete();
  GtkProgressBar *pbar = GTK_PROGRESS_BAR(lookup_widget(GTK_WIDGET(dialog), "progressbar3"));
  gint responseId;
  gchar *filenameList[EXE_LIST_LEN]; /* Hold pointers to each of the three file names */
  volatile gboolean cancelThread = FALSE;
  gint i;

  /* Create filename get thread */
  g_object_set_data(G_OBJECT(dialog), "returnFilenames", filenameList);
  g_object_set_data(G_OBJECT(dialog), "cancelThread", (gpointer)&cancelThread);
  g_object_set_data(G_OBJECT(dialog), "configWidget", GTK_WIDGET(button));
  threadId = g_thread_create (findExecutables, dialog, TRUE, NULL);

  /* Run dialog to show status */
  responseId = gtk_dialog_run(GTK_DIALOG(dialog));
  if (responseId != GTK_RESPONSE_OK) {
    cancelThread = TRUE; 
    if (gtk_progress_bar_get_fraction(pbar) < 1.0) { /* Still in progress */
      responseId = gtk_dialog_run(GTK_DIALOG(dialog));
    }
  }
  retVal = g_thread_join(threadId);
  gtk_widget_destroy(dialog);

}


void
on_online_release_notes1_activate      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  SMsyscall("http://searchmonkey.sourceforge.net/index.php?title=V0.6.x_Release_Notes", BROWSER_LIST);
}


void
on_configResetAll_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  gchar *searchmonkeyExe = g_object_get_data(G_OBJECT(mainWindowApp), "argvPointer");
  GtkWidget *confirmDialog = gtk_message_dialog_new (GTK_WINDOW(lookup_widget(GTK_WIDGET(button), "configDialog")),
                                                     (GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT),
                                                     GTK_MESSAGE_WARNING,
                                                     GTK_BUTTONS_OK_CANCEL,
                                                     "Are you sure that you wish to delete the config file, and restart searchmonkey?");

  if (gtk_dialog_run (GTK_DIALOG (confirmDialog)) == GTK_RESPONSE_OK) {

    /* Delete the config file, and disable saving on exit - attempt to restart searchmonkey too? */
    if (g_remove(gConfigFile) != 0) {
      g_print("Error! Unable to remove config file %s.\n", gConfigFile);    
    }
    g_object_set_data(G_OBJECT(mainWindowApp), "CONFIG_DISABLE_SAVE_CONFIG", GINT_TO_POINTER(CONFIG_DISABLE_SAVE_CONFIG));
    g_spawn_command_line_async (searchmonkeyExe, NULL); /* Assume it worked */
    gtk_dialog_response (GTK_DIALOG(lookup_widget(GTK_WIDGET(button), "configDialog")), GTK_RESPONSE_REJECT);
    gtk_main_quit(); /* Exit this instance */
    return;
  }
  gtk_widget_destroy (confirmDialog);  
}


void
on_configSaveNow_clicked               (GtkButton       *button,
                                        gpointer         user_data)
{
  GKeyFile *keyString = getGKeyFile(GTK_WIDGET(mainWindowApp));
  
  storeGKeyFile(keyString);
  setConfigFileLocation (GTK_WIDGET(button));
}


void
on_forums1_activate                    (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  SMsyscall("http://sourceforge.net/forum/?group_id=175143", BROWSER_LIST);
}


void
on_newWindow_clicked                   (GtkButton       *button,
                                        gpointer         user_data)
{
  spawnNewSearchmonkey();
}


void
on_importCriteria_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  importCriteria(GTK_WIDGET(button));
}


void
on_exportCriteria_clicked              (GtkButton       *button,
                                        gpointer         user_data)
{
  exportCriteria(GTK_WIDGET(button));
}


void
on_matches1_activate                   (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
  if (gtk_check_menu_item_get_active(GTK_CHECK_MENU_ITEM(menuitem))) {
    columnClick(GTK_WIDGET(menuitem), MATCHES_COUNT_COLUMN);
  }
}


void
on_window1_unrealize                   (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GKeyFile *keyString = getGKeyFile(widget);
  unrealizeWindow(widget, keyString, "application", "window1");
}


void
on_window1_realize                     (GtkWidget       *widget,
                                        gpointer         user_data)
{
  GKeyFile *keyString = getGKeyFile(widget);
  realizeWindow(widget, keyString, "application", "window1");
}

void
on_autoAdjustColumnWidth_toggled       (GtkToggleButton *togglebutton,
                                        gpointer         user_data)
{
  GKeyFile *keyString = getGKeyFile(GTK_WIDGET(mainWindowApp));
  gboolean autoColumnWidth = gtk_toggle_button_get_active(togglebutton);

  realizeTreeviewColumns (GTK_WIDGET(mainWindowApp), keyString, "history", "treeview", autoColumnWidth);
}

void
on_configResultEOL_changed             (GtkEditable     *editable,
                                        gpointer         user_data)
{
  resizeCsvEntry(GTK_ENTRY(editable));
}


void
on_configResultEOF_changed             (GtkEditable     *editable,
                                        gpointer         user_data)
{
  resizeCsvEntry(GTK_ENTRY(editable));
}


void
on_configResultDelimiter_changed       (GtkEditable     *editable,
                                        gpointer         user_data)
{
  resizeCsvEntry(GTK_ENTRY(editable));
}


gboolean
on_configResultEOL_focus_out_event     (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
  checkCsvEntry(GTK_ENTRY(lookup_widget(widget, "configResultEOL")));
  return FALSE;
}



gboolean
on_configResultEOF_focus_out_event     (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
  checkCsvEntry(GTK_ENTRY(lookup_widget(widget, "configResultEOF")));
  return FALSE;
}


gboolean
on_configResultDelimiter_focus_out_event
                                        (GtkWidget       *widget,
                                        GdkEventFocus   *event,
                                        gpointer         user_data)
{
  checkCsvEntry(GTK_ENTRY(lookup_widget(widget, "configResultDelimiter")));
  return FALSE;
}

