/*  selectwm - X11 window manager selector
 *
 *  Copyright (C) 1999-2004  Luc Dufresne - luc@ordiluc.net
 *                           26, rue des Comices
 *                           59650 Villeneuve d'Ascq
 *                           FRANCE
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  See the file COPYING
 */

#include "define.h"

#include <stdlib.h>
#include <gtk/gtk.h>
#include <getopt.h>

#include "misc.h"

static void version () {
	g_print (""PACKAGE" "VERSION" http://ordiluc.net/selectwm/\n");
	g_print ("Copyright (c) 1999-2004 Luc Dufresne <luc@ordiluc.net>\n");
}

static void usage () {
	version ();
	g_print ("\n");
	g_print (_("usage: selectwm [OPTIONS]\n"));
	g_print (_("  -h, --help\t\t\tprints this message\n"));
	g_print (_("  -v, --version\t\t\tprints version information\n"));
	g_print (_("  -d, --DontSaveOnExit\t\tdon't save the config on exit\n"));
	g_print (_("  -c, --config <filename>\tselect the config file\n"));
}

void get_cmdl_opt (gint argc, gchar *argv[], config *selectwm_config) {
	gint c, opind;
	extern char *optarg;

	static struct option long_options[] = {
		{"help", 0, 0, 'h'},
		{"version", 0, 0, 'v'},
		{"DontSaveOnExit", 0, 0, 'd'},
		{"config", 1, 0, 'c'},
		{0, 0, 0, 0}
	};

	while (1) {
		opind = 0;
		c = getopt_long (argc, argv, "hvdc:", long_options, &opind);
		if (c == -1)
		break;
		switch (c) {
				case 0:
					break;
				case 'h':
					usage ();
					exit (0);
					break;
				case 'v':
					version ();
					exit (0);
					break;			
				case 'd':
					g_print (_("don't save the config on exit\n"));
					selectwm_config->SaveOnExit = FALSE;
					break;
				case 'c':
					g_print (_("using %s\n"), optarg);
					g_string_printf (selectwm_config->ConfigFile,"%s", optarg);
					break;
				default:
					usage ();
					exit (1);
					break;
			}
	}
}
