/*
 * Copyright (C) 2005 Alex Murray <murray.alex@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif /* HAVE_CONFIG_H */

#include <gnome.h>
#include "about-dialog.h"

void about_dialog_open(SensorsApplet *sensors_applet) {
#ifndef HAVE_GTK_26
	g_assert(sensors_applet->about_dialog == NULL);
#endif /* NOT HAVE_GTK_26 */

	GdkPixbuf *logo;
	gchar *translator;
	const gchar *authors[] = {
		"Alex Murray <murray.alex@gmail.com>",
		"Nathan Hand <nathanh@manu.com.au>",
		NULL
	};

	if (_("Translator") == "Translator") {
		translator = NULL;
	} else {
		translator = g_strdup(_("To translator: Put your name here to show up in the About dialog as the translator"));
	}

	logo = gdk_pixbuf_new_from_file(PIXMAPS_DIR SENSORS_APPLET_ICON, NULL);

	/* Construct the about dialog */
#ifndef HAVE_GTK_26 
	/* Do not have Gtk 2.6 so use old Gnome about dialog way */
	sensors_applet->about_dialog = gnome_about_new(PACKAGE_NAME, PACKAGE_VERSION,
						       "(C) 2005, Alex Murray <murray.alex@gmail.com>",
						       NULL,
						       authors,
						       NULL, /* should be documenters */
						       translator,
						       logo);
	g_object_unref(logo);

	g_signal_connect(sensors_applet->about_dialog, "destroy", GTK_SIGNAL_FUNC(gtk_widget_destroyed), &sensors_applet->about_dialog);
	gtk_widget_show(sensors_applet->about_dialog);			
#endif /* NOT HAVE_GTK_26 */

#ifdef HAVE_GTK_26
	/* can instead use Gtk about dialog from Gtk 2.6 */
	gtk_show_about_dialog(NULL,
			      "name", PACKAGE_NAME, 
			      "version", PACKAGE_VERSION,
			      "copyright", "(C) 2005, Alex Murray <murray.alex@gmail.com>",
			      "authors", authors,
			      "documenters", NULL,
			      "translator-credits", translator,
			      "logo", logo,
			      "website", "http://sensors-applet.sourceforge.net/",
			      NULL);
	g_object_unref(logo);	

#endif /* HAVE_GTK_26 */

}
