/*
 * Sentinella
 * http://sourceforge.net/projects/sentinella/
 * Copyright (c) 2009 Carlos Olmedo Escobar <carlos.olmedo.e@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <sys/types.h>
#include <QSet>
#include <QCloseEvent>
#include <KMainWindow>
#include <KAboutData>
#include <KCmdLineArgs>
#include <kstatusnotifieritem.h>
#include <solid/powermanagement.h>
#include "ui_MainWindow.h"
#include "Actions/AbstractAction.h"
#include "Conditions/AbstractCondition.h"

class MainWindow : public KMainWindow {
Q_OBJECT

public:
	MainWindow(const KAboutData& aboutData, KCmdLineArgs* cmdLineArgs, const short cmdSelectedCondition, const short cmdSelectedAction);
	~MainWindow();

protected:
	void checkShutdownSleepStates();
	void initConditionWidgets(const short cmdSelectedCondition);
	void initActionWidgets(const short cmdSelectedAction);
	void startClicked();
	void stopClicked();
	void showError(const int error);
	void saveConfig();
	void chooseProcess(bool isAction);
	void closeEvent(QCloseEvent *event);

private:
	Ui::MainWindow gui;
	bool isKDE;
	KAboutData aboutData;
	KCmdLineArgs* cmdLineArgs;
	QButtonGroup actionsGroup;
	KSharedConfig::Ptr config;
	bool supportedShutdown;
	KIconLoader* iconLoader;
	KStatusNotifierItem trayIcon;
	AbstractCondition* condition;
	AbstractAction* action;
	QSet<Solid::PowerManagement::SleepState> supportedSleepStates;
	pid_t pidProcessDies;
	pid_t pidKillProcess;
	QStringList* availableSounds;
	QList<AbstractCondition*>* abortedConditions;

public slots:
	void conditionRadioButtonToggled(bool checked);
	void actionRadioButtonToggled(bool checked);
	void programDiesClicked();
	void startStopClicked();
	void conditionFinished();
	void abortedConditionFinished();
	void killProcessClicked();
	void showAboutApp();
};

#endif /* MAINWINDOW_H */
