//----------------------------------------------------------------------------
//
//  This file is part of seq24.
//
//  seq24 is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  seq24 is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with seq24; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//-----------------------------------------------------------------------------

#include "options.h"
#include <sstream>


const int c_status = 0;
const int c_status_inv =1;
const int c_d1 = 2;
const int c_d2 = 3;
const int c_d3 = 4;


options::options( perform *a_p )
{
    m_perf = a_p;

    set_title ("options");

	HBox *hbox = manage( new HBox());
	get_vbox()->pack_start( *hbox, false, false );

    get_action_area()->set_border_width( 2 );
    hbox->set_border_width( 6 );
	
    m_button_ok = manage( new Button( " Ok " ) );
    get_action_area()->pack_end( *m_button_ok, false, false );
    m_button_ok->clicked.connect( hide.slot() );
	
    //m_frame_clock = manage( new Frame( " Midi Clock " ));
    //hbox->pack_start( *m_frame_clock, false, false );

	//m_frame_midi = manage( new Frame( " Midi Control " ));
	//	hbox->pack_start( *m_frame_midi, false, false );

	//m_frame_test = manage( new Frame( " Test " ));
	//hbox->pack_start( *m_frame_test, false, false );

	m_notebook = manage( new Notebook() );
	hbox->pack_start( *m_notebook );
	
    int buses = m_perf->get_master_midi_bus( )->get_num_out_buses();
	
    VBox *vbox = manage( new VBox( ));
	m_notebook->pages().push_back(  Notebook_Helpers::TabElem( *vbox, "MIDI Clock"));

    for ( int i=0; i<buses; i++ ){
		
		CheckButton *check = manage( new CheckButton(  m_perf->get_master_midi_bus( )->get_midi_bus_name( i ), 0 ));
		check->toggled.connect( bind(slot(this,&options::clock_callback), i, check ));
		check->set_active( m_perf->get_master_midi_bus( )->get_clock( i ));
		
		vbox->pack_start( *check, false, false );
    }


	VBox *vbox2 = manage( new VBox());
	vbox2->set_border_width(4);
	m_notebook->pages().push_back(  Notebook_Helpers::TabElem( *vbox2, "MIDI Control"));

	m_table = manage( new Table( (c_seqs_in_set / 2) + 1,46, false));
	m_table = manage( new Table( ));
	m_table->set_spacings(2);
   
	

	vbox2->add( *m_table );

	for ( int i=0; i<2; i++ ){

		int c = i * 20;
		
		m_table->attach( *manage( new Label( "Toggle")),  1+c, 8+c,   0, 1, 0, 0 );
		m_table->attach( *manage( new Label( "On")),      8+c, 15+c,  0, 1, 0, 0 );
		m_table->attach( *manage( new Label( "Off")),    15+c, 23+c,  0, 1, 0, 0 );
	
	}
	
	

	for( int i=0; i<c_seqs_in_set; i++ ){

		int c = (i / (c_seqs_in_set / 2)) * 23;
		int r = i % (c_seqs_in_set /2);

		bool state_toggle = m_perf->get_midi_control_toggle(i)->m_active;
		bool state_on =     m_perf->get_midi_control_on(i)->m_active;
		bool state_off =    m_perf->get_midi_control_off(i)->m_active;

		bool state_toggle_inverse = m_perf->get_midi_control_toggle(i)->m_inverse_active;
		bool state_on_inverse =     m_perf->get_midi_control_on(i)->m_inverse_active;
		bool state_off_inverse =    m_perf->get_midi_control_off(i)->m_inverse_active;

		m_entry_toggle_status[i] = manage( new Entry(2));
		m_entry_toggle_d1[i]     = manage( new Entry(2));
	    m_entry_toggle_d2[i]     = manage( new Entry(2));	
		m_entry_toggle_d3[i]     = manage( new Entry(2));	
	
		m_entry_on_status[i] = manage( new Entry(2));
		m_entry_on_d1[i]     = manage( new Entry(2));
		m_entry_on_d2[i]     = manage( new Entry(2));	
		m_entry_on_d3[i]     = manage( new Entry(2));	
		
		m_entry_off_status[i] = manage( new Entry(2));
		m_entry_off_d1[i]     = manage( new Entry(2));
		m_entry_off_d2[i]     = manage( new Entry(2));
		m_entry_off_d3[i]     = manage( new Entry(2));
		 
		m_entry_toggle_status[i]->changed.connect( bind( slot( this, 
															   &options::on_changed_callback_toggle_status), 
														 m_entry_toggle_status[i], i ));
		m_entry_toggle_d1[i]->changed.connect( bind( slot( this, 
															   &options::on_changed_callback_toggle_d1), 
														 m_entry_toggle_d1[i], i ));
		m_entry_toggle_d2[i]->changed.connect( bind( slot( this, 
															   &options::on_changed_callback_toggle_d2), 
														 m_entry_toggle_d2[i], i ));	   
		m_entry_toggle_d3[i]->changed.connect( bind( slot( this, 
															   &options::on_changed_callback_toggle_d3), 
														 m_entry_toggle_d3[i], i ));


		m_entry_off_status[i]->changed.connect( bind( slot( this, 
															   &options::on_changed_callback_off_status), 
														 m_entry_off_status[i], i ));
		m_entry_off_d1[i]->changed.connect( bind( slot( this, 
															   &options::on_changed_callback_off_d1), 
														 m_entry_off_d1[i], i ));
		m_entry_off_d2[i]->changed.connect( bind( slot( this, 
															   &options::on_changed_callback_off_d2), 
														 m_entry_off_d2[i], i ));	   
		m_entry_off_d3[i]->changed.connect( bind( slot( this, 
															   &options::on_changed_callback_off_d3), 
														 m_entry_off_d3[i], i ));


		 
		m_entry_on_status[i]->changed.connect( bind( slot( this, 
															   &options::on_changed_callback_on_status), 
														 m_entry_on_status[i], i ));
		m_entry_on_d1[i]->changed.connect( bind( slot( this, 
															   &options::on_changed_callback_on_d1), 
														 m_entry_on_d1[i], i ));
		m_entry_on_d2[i]->changed.connect( bind( slot( this, 
															   &options::on_changed_callback_on_d2), 
														 m_entry_on_d2[i], i ));	   
		m_entry_on_d3[i]->changed.connect( bind( slot( this, 
															   &options::on_changed_callback_on_d3), 
														 m_entry_on_d3[i], i ));




				
		m_entry_toggle_status[i]->set_usize(20, -1); 
		m_entry_toggle_d1[i]->set_usize(20, -1); 
	    m_entry_toggle_d2[i]->set_usize(20, -1); 	
		m_entry_toggle_d3[i]->set_usize(20, -1); 	
   
		m_entry_on_status[i]->set_usize(20, -1); 
		m_entry_on_d1[i]->set_usize(20, -1);     
		m_entry_on_d2[i]->set_usize(20, -1);     	
		m_entry_on_d3[i]->set_usize(20, -1);    
		
		m_entry_off_status[i]->set_usize(20, -1);
		m_entry_off_d1[i]->set_usize(20, -1);
		m_entry_off_d2[i]->set_usize(20, -1);
		m_entry_off_d3[i]->set_usize(20, -1);

		m_check_toggle[i] = manage( new ToggleButton());
		m_check_toggle[i]->set_usize(10,10);
		m_check_on[i] = manage( new ToggleButton());
		m_check_on[i]->set_usize(10,10);
		m_check_off[i] = manage( new ToggleButton());
		m_check_off[i]->set_usize(10,10);

		m_check_toggle_inverse[i] = manage( new ToggleButton());
		m_check_toggle_inverse[i]->set_usize(10,10);
		m_check_on_inverse[i] = manage( new ToggleButton());
		m_check_on_inverse[i]->set_usize(10,10);
		m_check_off_inverse[i] = manage( new ToggleButton());
		m_check_off_inverse[i]->set_usize(10,10);

		m_check_toggle[i]->toggled.connect( bind( slot( this, &options::toggle_callback_toggle), m_check_toggle[i], i ));
		m_check_on[i]->toggled.connect(     bind( slot( this, &options::toggle_callback_on),     m_check_on[i],     i ));
		m_check_off[i]->toggled.connect(    bind( slot( this, &options::toggle_callback_off),    m_check_off[i],    i ));
	
		m_check_toggle_inverse[i]->toggled.connect( bind( slot( this, &options::toggle_callback_toggle_inverse), m_check_toggle_inverse[i], i ));
		m_check_on_inverse[i]->toggled.connect(     bind( slot( this, &options::toggle_callback_on_inverse),     m_check_on_inverse[i],     i ));
		m_check_off_inverse[i]->toggled.connect(    bind( slot( this, &options::toggle_callback_off_inverse),    m_check_off_inverse[i],    i ));
	
		m_check_toggle[i]->set_active( state_toggle );
		m_check_on[i]->set_active( state_on );
		m_check_off[i]->set_active( state_off );

		m_check_toggle_inverse[i]->set_active( state_toggle_inverse );
		m_check_on_inverse[i]->set_active( state_on_inverse );
		m_check_off_inverse[i]->set_active( state_off_inverse );

		toggle_callback_toggle( m_check_toggle[i], i );
		toggle_callback_on(     m_check_on[i],     i );
		toggle_callback_off(    m_check_off[i],    i );

		toggle_callback_toggle_inverse( m_check_toggle_inverse[i], i );
		toggle_callback_on_inverse(     m_check_on_inverse[i],     i );
		toggle_callback_off_inverse(    m_check_off_inverse[i],    i );



		char num[10];
		sprintf( num, " %d ", i );
		
		m_table->attach( *manage( new Label( num )), 0+c,  1+c, r+1, r+2, 0, 0 );

		m_table->attach( *m_check_toggle[i],         1+c,  2+c, r+1, r+2, 0, 0 );
		//m_table->attach( *m_check_toggle_inverse[i], 2+c,  3+c, r+1, r+2, 0, 0 );
		m_table->attach( *m_entry_toggle_status[i],  3+c,  4+c, r+1, r+2, 0, 0 );
		m_table->attach( *m_entry_toggle_d1[i],      4+c,  5+c, r+1, r+2, 0, 0 );
		m_table->attach( *m_entry_toggle_d2[i],      5+c,  6+c, r+1, r+2, 0, 0 );
		m_table->attach( *manage( new Label( "-" )), 6+c,  7+c, r+1, r+2, 0, 0 );
		m_table->attach( *m_entry_toggle_d3[i],      7+c,  8+c, r+1, r+2, 0, 0 );

		m_table->attach( *m_check_on[i],             8+c,  9+c, r+1, r+2, 0, 0 );
		m_table->attach( *m_check_on_inverse[i],     9+c,  10+c, r+1, r+2, 0, 0 );
		m_table->attach( *m_entry_on_status[i],      10+c, 11+c, r+1, r+2, 0, 0 );
		m_table->attach( *m_entry_on_d1[i],          11+c, 12+c, r+1, r+2, 0, 0 );
		m_table->attach( *m_entry_on_d2[i],          12+c, 13+c, r+1, r+2, 0, 0 );
		m_table->attach( *manage( new Label( "-" )), 13+c, 14+c, r+1, r+2, 0, 0 );
		m_table->attach( *m_entry_on_d3[i],          14+c, 15+c, r+1, r+2, 0, 0 );

		m_table->attach( *m_check_off[i],            15+c, 16+c, r+1, r+2, 0, 0 );
		m_table->attach( *m_check_off_inverse[i],    16+c, 17+c, r+1, r+2, 0, 0 );
		m_table->attach( *m_entry_off_status[i],     17+c, 18+c, r+1, r+2, 0, 0 );
		m_table->attach( *m_entry_off_d1[i],         18+c, 19+c, r+1, r+2, 0, 0 );
		m_table->attach( *m_entry_off_d2[i],         19+c, 20+c, r+1, r+2, 0, 0 );
		m_table->attach( *manage( new Label( "-" )), 20+c, 21+c, r+1, r+2, 0, 0 );
		m_table->attach( *m_entry_off_d3[i],         21+c, 22+c, r+1, r+2, 0, 0 );

		m_table->attach( *manage( new Label( "  " )), 22+c, 23+c, r+1, r+2, 0, 0 );

	}

	//m_notebook->pages().push_back(  Notebook_Helpers::TabElem( *manage( new Label("TEST2")), "tab2"));
	//m_notebook->pages().push_back(  Notebook_Helpers::TabElem( *manage( new Label("TEST3")), "tab3"));


    /* show everything */
    show_all();
}

	
string 
options::uc_2_hex_string( unsigned char a_c )
{
	ostringstream os;
	string s;
	
	os.width (2);
	os << right; 
    os.fill ('0'); 
	os.setf(ios::hex, ios::basefield);

	os << hex << uppercase << (int) a_c;
	s = os.str();

	return s;
}
	
unsigned char 
options::hex_string_2_uc( string a_s )
{
	istringstream is;
	int ret=0;

	is.str( "0x" + a_s );
	is.setf(ios::hex, ios::basefield);
  	is >> hex >> ret;

	//printf ( "%s to 0x%x\n", a_s.c_str(), ret );

	return (unsigned char) ret;
}

void
options::clock_callback( int a_bus, CheckButton *a_button )
{
    bool clocking = a_button->get_active( );
    m_perf->get_master_midi_bus( )->set_clock( a_bus, clocking );
}


void 
options::toggle_callback(  ToggleButton *a_toggle, 
						   ToggleButton *a_toggle_inv,
						   Entry *a_entry_status,
						   Entry *a_entry_d1,
						   Entry *a_entry_d2,	
						   Entry *a_entry_d3,
						   int a_sequence,
						   midi_control *a_midi_control )
{

	bool state = a_toggle->get_active( );

	//printf ( "toggle_callback( a_seq[%d] state[%d]\n", a_sequence, state );
	a_midi_control->m_active = state;

 	a_toggle->set_active( state );
	
	a_entry_status->set_editable( state );
	a_entry_d1->set_editable( state );
	a_entry_d2->set_editable( state );
	a_entry_d3->set_editable( state );

	a_toggle_inv->set_active( a_midi_control->m_inverse_active );
	a_entry_status->set_text( uc_2_hex_string( a_midi_control->m_status    ) );
	a_entry_d1->set_text( uc_2_hex_string(     a_midi_control->m_data      ) );
	a_entry_d2->set_text( uc_2_hex_string(     a_midi_control->m_min_value ) );
	a_entry_d3->set_text( uc_2_hex_string(     a_midi_control->m_max_value ) );

}


void
options::toggle_callback_toggle(   ToggleButton *a_check_toggle, int a_sequence  )
{
	toggle_callback( a_check_toggle, 
					 m_check_toggle_inverse[a_sequence],
					 m_entry_toggle_status[a_sequence],
					 m_entry_toggle_d1[a_sequence],
					 m_entry_toggle_d2[a_sequence],
					 m_entry_toggle_d3[a_sequence],
					 a_sequence,
					 m_perf->get_midi_control_toggle(a_sequence));
}

void
options::toggle_callback_on(   ToggleButton *a_check_toggle, int a_sequence  )
{
	toggle_callback( a_check_toggle, 
					 m_check_on_inverse[a_sequence],
					 m_entry_on_status[a_sequence],
					 m_entry_on_d1[a_sequence],
					 m_entry_on_d2[a_sequence],
					 m_entry_on_d3[a_sequence],
					 a_sequence,
					 m_perf->get_midi_control_on(a_sequence));
}

void
options::toggle_callback_off(   ToggleButton *a_check_toggle, int a_sequence  )
{
	toggle_callback( a_check_toggle, 
					 m_check_off_inverse[a_sequence],
					 m_entry_off_status[a_sequence],
					 m_entry_off_d1[a_sequence],
					 m_entry_off_d2[a_sequence],
					 m_entry_off_d3[a_sequence],
					 a_sequence,
					 m_perf->get_midi_control_off(a_sequence));
}



void
options::toggle_callback_toggle_inverse(   ToggleButton *a_toggle, int a_sequence  )
{
	m_perf->get_midi_control_toggle(a_sequence)->m_inverse_active =  a_toggle->get_active( );
}

void
options::toggle_callback_on_inverse(   ToggleButton *a_toggle, int a_sequence  )
{
	m_perf->get_midi_control_on(a_sequence)->m_inverse_active =  a_toggle->get_active( );
	
}

void
options::toggle_callback_off_inverse(   ToggleButton *a_toggle, int a_sequence  )
{
	m_perf->get_midi_control_off(a_sequence)->m_inverse_active =  a_toggle->get_active( );
}




void 
options::validate_hex_entry( Entry *a_entry )
{
	string o = a_entry->get_text();
	string s = "";
	
	string::iterator cur;
	
	for (cur = o.begin(); cur != o.end(); ++cur){

		if (('0' <=   *cur &&  *cur <= '9')  ||
			('a' <=   *cur &&  *cur <= 'f')  ||
			('A' <=   *cur &&  *cur <= 'F'))
			
			s += *cur;
	}
	
	if ( o.compare(s) != 0)
		a_entry->set_text(s);
		
}


void options::on_changed_callback_toggle_status( Entry *a_entry, int a_sequence) 
{	on_changed_callback( a_entry, c_status, m_perf->get_midi_control_toggle(a_sequence));  }

void options::on_changed_callback_toggle_d1( Entry *a_entry, int a_sequence)     
{	on_changed_callback( a_entry, c_d1, m_perf->get_midi_control_toggle(a_sequence));   }

void options::on_changed_callback_toggle_d2( Entry *a_entry, int a_sequence)     
{	on_changed_callback( a_entry, c_d2, m_perf->get_midi_control_toggle(a_sequence));   }

void options::on_changed_callback_toggle_d3( Entry *a_entry, int a_sequence)     
{	on_changed_callback( a_entry, c_d3, m_perf->get_midi_control_toggle(a_sequence));   }

void options::on_changed_callback_on_status( Entry *a_entry, int a_sequence) 
{	on_changed_callback( a_entry, c_status, m_perf->get_midi_control_on(a_sequence));  }

void options::on_changed_callback_on_d1( Entry *a_entry, int a_sequence)     
{	on_changed_callback( a_entry, c_d1, m_perf->get_midi_control_on(a_sequence));   }

void options::on_changed_callback_on_d2( Entry *a_entry, int a_sequence)     
{	on_changed_callback( a_entry, c_d2, m_perf->get_midi_control_on(a_sequence));   }

void options::on_changed_callback_on_d3( Entry *a_entry, int a_sequence)     
{	on_changed_callback( a_entry, c_d3, m_perf->get_midi_control_on(a_sequence));   }

void options::on_changed_callback_off_status( Entry *a_entry, int a_sequence) 
{	on_changed_callback( a_entry, c_status, m_perf->get_midi_control_off(a_sequence));  }

void options::on_changed_callback_off_d1( Entry *a_entry, int a_sequence)     
{	on_changed_callback( a_entry, c_d1, m_perf->get_midi_control_off(a_sequence));   }

void options::on_changed_callback_off_d2( Entry *a_entry, int a_sequence)     
{	on_changed_callback( a_entry, c_d2, m_perf->get_midi_control_off(a_sequence));   }

void options::on_changed_callback_off_d3( Entry *a_entry, int a_sequence)     
{	on_changed_callback( a_entry, c_d3, m_perf->get_midi_control_off(a_sequence));   }
		


void
options::on_changed_callback( Entry *a_entry, int a_pos,  midi_control *a_midi_control )
{
	validate_hex_entry( a_entry );

	string s = a_entry->get_text();

	unsigned char value = hex_string_2_uc( s );

	//printf ( "on_changed_callback a_pos[%d] = 0x%x %s\n", a_pos, value, s.c_str() ); 

	switch( a_pos ){
		
	case c_status:
		a_midi_control->m_status = value;
		break;
		
	case c_d1:
		a_midi_control->m_data = value;
		break;
		
	case c_d2:
		a_midi_control->m_min_value = value;
		break;
		
	case c_d3:
		a_midi_control->m_max_value = value;
		break;
		
	default:
		break;
		
	}
}
