 /*==========================================================================
                SeqAn - The Library for Sequence Analysis
                          http://www.seqan.de 
 ============================================================================
  Copyright (C) 2007

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 3 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  Lesser General Public License for more details.

 ==========================================================================*/

#ifndef SEQAN_HEADER_MAP_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_MAP_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// AllocatorType

template <typename T> struct AllocatorType;       	// "projects/library/seqan/map/map_skiplist.h"(72)

//____________________________________________________________________________
// ChooseMap

template <typename TValue> struct ChooseMap;       	// "projects/library/seqan/map/map_chooser.h"(47)

//____________________________________________________________________________
// DIMENSION

template <typename T> struct DIMENSION;       	// "projects/library/seqan/map/sumlist.h"(42)

//____________________________________________________________________________
// Map

template <typename TElement, typename TSpec > class Map;       	// "projects/library/seqan/map/map_base.h"(50)
template <typename TValue, typename TSpec> class Map;       	// "projects/library/seqan/map/map_skiplist.h"(53)

//____________________________________________________________________________
// MapValue

template <typename TMap> struct MapValue;       	// "projects/library/seqan/map/map_base.h"(89)

//____________________________________________________________________________
// MiniSumList

template <unsigned short SIZE , typename TSpec > struct MiniSumList;       	// "projects/library/seqan/map/sumlist_mini.h"(151)

//____________________________________________________________________________
// MiniSumListIterator

struct MiniSumListIterator;       	// "projects/library/seqan/map/sumlist_mini.h"(631)

//____________________________________________________________________________
// STLMapIterator

struct STLMapIterator;       	// "projects/library/seqan/map/map_adapter_stl.h"(279)

//____________________________________________________________________________
// STLSetIterator

struct STLSetIterator;       	// "projects/library/seqan/map/map_adapter_stl.h"(278)

//____________________________________________________________________________
// SkipSumList

template <typename TSpec > struct SkipSumList;       	// "projects/library/seqan/map/sumlist.h"(31)

//____________________________________________________________________________
// Skiplist

template <typename TSpec > struct Skiplist;       	// "projects/library/seqan/map/map_base.h"(34)

//____________________________________________________________________________
// SkiplistElement

template <typename TValue, typename TSpec> class SkiplistElement;       	// "projects/library/seqan/map/map_skiplist.h"(56)
template <typename TValue, typename TSpec> class SkiplistElement;       	// "projects/library/seqan/map/map_skiplist.h"(200)

//____________________________________________________________________________
// SkiplistIterator

struct SkiplistIterator;       	// "projects/library/seqan/map/map_skiplist.h"(67)

//____________________________________________________________________________
// SkiplistNext

template <typename TValue, typename TSpec> class SkiplistNext;       	// "projects/library/seqan/map/map_skiplist.h"(59)
template <typename TValue, typename TSpec> class SkiplistNext;       	// "projects/library/seqan/map/map_skiplist.h"(223)

//____________________________________________________________________________
// SkiplistPath

template <typename TValue, typename TSpec> class SkiplistPath;       	// "projects/library/seqan/map/map_skiplist.h"(62)
template <typename TValue, typename TSpec> class SkiplistPath;       	// "projects/library/seqan/map/map_skiplist.h"(251)

//____________________________________________________________________________
// SumList

template <unsigned int DIM, typename TValue, typename TSpec > class SumList;       	// "projects/library/seqan/map/sumlist.h"(36)

//____________________________________________________________________________
// SumListValues

template <unsigned int DIM, typename TValue> struct SumListValues;       	// "projects/library/seqan/map/sumlist.h"(79)

//____________________________________________________________________________
// Values

template <typename T> struct Values;       	// "projects/library/seqan/map/sumlist.h"(123)

//____________________________________________________________________________
// VectorSet

template <typename TSpec > struct VectorSet;       	// "projects/library/seqan/map/map_vector.h"(52)

//____________________________________________________________________________
// VectorSetIterator

struct VectorSetIterator;       	// "projects/library/seqan/map/map_vector.h"(164)

//____________________________________________________________________________
// _ChooseMap2

template <typename TValue, size_t SIZE> struct _ChooseMap2;       	// "projects/library/seqan/map/map_chooser.h"(34)

//____________________________________________________________________________
// _Impl_mapValue

template <typename TCargo> struct _Impl_mapValue;       	// "projects/library/seqan/map/map_base.h"(96)

//____________________________________________________________________________
// _MapValue_Impl

template <typename TMap, typename TCargo> struct _MapValue_Impl;       	// "projects/library/seqan/map/map_base.h"(77)

//____________________________________________________________________________
// _MiniListEntry

template <typename TValue> struct _MiniListEntry;       	// "projects/library/seqan/map/sumlist_mini.h"(34)

//____________________________________________________________________________
// _MiniSumListValueIterator

struct _MiniSumListValueIterator;       	// "projects/library/seqan/map/sumlist_mini.h"(153)

//____________________________________________________________________________
// _STLIterator

template <typename T> struct _STLIterator;       	// "projects/library/seqan/map/map_adapter_stl.h"(115)

//____________________________________________________________________________
// _SkiplistElement

template <typename T> struct _SkiplistElement;       	// "projects/library/seqan/map/map_skiplist.h"(92)

//____________________________________________________________________________
// _Skiplist_mapValue

template <typename TCargo> struct _Skiplist_mapValue;       	// "projects/library/seqan/map/map_skiplist.h"(938)

//____________________________________________________________________________
// _VectorSetElement

template <typename TCargo> struct _VectorSetElement;       	// "projects/library/seqan/map/map_vector.h"(60)

//____________________________________________________________________________
// _VectorSetElements

template <typename T> struct _VectorSetElements;       	// "projects/library/seqan/map/map_vector.h"(74)

//____________________________________________________________________________
// _VectorSet_Insert

template <typename TCargo> struct _VectorSet_Insert;       	// "projects/library/seqan/map/map_vector.h"(242)

} //namespace SEQAN_NAMESPACE_MAIN


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace SEQAN_NAMESPACE_MAIN {

//____________________________________________________________________________
// _MiniSumList_assignValue

template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec, typename TValue2> inline bool _MiniSumList_assignValue(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me, unsigned char * ptr, int dim, TValue2 new_value);       	// "projects/library/seqan/map/sumlist_mini.h"(301)

//____________________________________________________________________________
// _MiniSumList_insertValues

template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec, typename TPosition, typename TValue2> inline bool _MiniSumList_insertValues(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me, TPosition byte_pos, TValue2 const & new_values,  unsigned int & new_values_size);       	// "projects/library/seqan/map/sumlist_mini.h"(343)

//____________________________________________________________________________
// _MiniSumList_sizeOfValues

template <unsigned int DIM, typename TValue> inline TValue _MiniSumList_sizeOfValues(SumListValues<DIM, TValue> const & vals);       	// "projects/library/seqan/map/sumlist_mini.h"(324)

//____________________________________________________________________________
// _insertValues

template <typename TSumList, typename TValues> inline bool _insertValues(TSumList & me, Iter<TSumList, _MiniSumListValueIterator> it, TValues const & new_values,  unsigned int & new_values_size);       	// "projects/library/seqan/map/sumlist_mini.h"(376)
template <typename TSumList, typename TValue> inline bool _insertValues(TSumList & me, Iter<TSumList, _MiniSumListValueIterator> it, TValue const * new_values,  unsigned int & new_values_size);       	// "projects/library/seqan/map/sumlist_mini.h"(385)

//____________________________________________________________________________
// _skiplistAllocateElement

template <typename TValue, typename TSpec> inline SkiplistElement<TValue, TSpec> & _skiplistAllocateElement(Map<TValue, Skiplist<TSpec> > & me, unsigned char height);       	// "projects/library/seqan/map/map_skiplist.h"(307)

//____________________________________________________________________________
// _skiplistConstructElement

template <typename TValue, typename TSpec, typename TValue2> inline SkiplistElement<TValue, TSpec> & _skiplistConstructElement(Map<TValue, Skiplist<TSpec> > & me, unsigned char height, TValue2 const & _value);       	// "projects/library/seqan/map/map_skiplist.h"(351)

//____________________________________________________________________________
// _skiplistCreateHeight

template <typename TValue, typename TSpec> inline unsigned char _skiplistCreateHeight(Map<TValue, Skiplist<TSpec> > & me);       	// "projects/library/seqan/map/map_skiplist.h"(395)
template <typename TValue, typename TSpec> inline unsigned char _skiplistCreateHeight(Map<TValue, Skiplist<TSpec> > & me, SkiplistPath<TValue, TSpec> & path);       	// "projects/library/seqan/map/map_skiplist.h"(410)

//____________________________________________________________________________
// _skiplistDeallocateElement

template <typename TValue, typename TSpec> inline void _skiplistDeallocateElement(Map<TValue, Skiplist<TSpec> > & me, SkiplistElement<TValue, TSpec> & el, unsigned char height);       	// "projects/library/seqan/map/map_skiplist.h"(367)

//____________________________________________________________________________
// _skiplistDestructElement

template <typename TValue, typename TSpec> inline void _skiplistDestructElement(Map<TValue, Skiplist<TSpec> > & me, SkiplistElement<TValue, TSpec> & el, unsigned char height);       	// "projects/library/seqan/map/map_skiplist.h"(382)

//____________________________________________________________________________
// _skiplistFind

template <typename TValue, typename TSpec, typename TFind> inline void _skiplistFind(Map<TValue, Skiplist<TSpec> > & me, TFind const & find,  SkiplistPath<TValue, TSpec> & path);       	// "projects/library/seqan/map/map_skiplist.h"(506)

//____________________________________________________________________________
// _skiplistFindGoNext

template <typename TValue, typename TSpec, typename TKey> inline bool _skiplistFindGoNext(SkiplistNext<TValue, TSpec> & next, unsigned char, TKey const & _key);       	// "projects/library/seqan/map/map_skiplist.h"(477)
template <typename TValue, typename TSpec> inline bool _skiplistFindGoNext(SkiplistNext<TValue, TSpec> & next, unsigned char, SkiplistElement<TValue, TSpec> const & el);       	// "projects/library/seqan/map/map_skiplist.h"(486)
template <typename TValue, typename TSpec> inline bool _skiplistFindGoNext(SkiplistNext<TValue, TSpec> & next, unsigned char height, GoEnd);       	// "projects/library/seqan/map/map_skiplist.h"(495)

//____________________________________________________________________________
// _skiplistGetHeight

template <typename TValue, typename TSpec> inline unsigned char _skiplistGetHeight(Map<TValue, Skiplist<TSpec> > & me, SkiplistElement<TValue, TSpec> & el, SkiplistPath<TValue, TSpec> & path);       	// "projects/library/seqan/map/map_skiplist.h"(435)
template <typename TValue, typename TSpec> inline unsigned char _skiplistGetHeight(Map<TValue, Skiplist<TSpec> > & me, SkiplistElement<TValue, TSpec> & el);       	// "projects/library/seqan/map/map_skiplist.h"(448)

//____________________________________________________________________________
// _skiplistInsertElement

template <typename TValue, typename TSpec> inline void _skiplistInsertElement(Map<TValue, Skiplist<TSpec> > & me, SkiplistElement<TValue, TSpec> & el, SkiplistPath<TValue, TSpec> & path, unsigned char height);       	// "projects/library/seqan/map/map_skiplist.h"(576)
template <typename TValue, typename TSpec> inline void _skiplistInsertElement(Map<TValue, Skiplist<TSpec> > & me, SkiplistElement<TValue, TSpec> & el, unsigned char height);       	// "projects/library/seqan/map/map_skiplist.h"(591)

//____________________________________________________________________________
// _skiplistUnlinkElement

template <typename TValue, typename TSpec> inline void _skiplistUnlinkElement(Map<TValue, Skiplist<TSpec> > & me, SkiplistElement<TValue, TSpec> & el);       	// "projects/library/seqan/map/map_skiplist.h"(769)

//____________________________________________________________________________
// add

template <typename TValue, typename TSpec, typename TValue2> inline void add(Map<TValue, Skiplist<TSpec> > & me, TValue2 const & _value);       	// "projects/library/seqan/map/map_skiplist.h"(741)
template <typename TValue, typename TSpec, typename TKey2, typename TCargo2> inline void add(Map<TValue, Skiplist<TSpec> > & me, TKey2 const & _key, TCargo2 const & _cargo);       	// "projects/library/seqan/map/map_skiplist.h"(754)

//____________________________________________________________________________
// appendValues

template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec, typename TValues> inline bool appendValues(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me, TValues const & new_values);       	// "projects/library/seqan/map/sumlist_mini.h"(397)
template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec, typename TValue2> inline bool appendValues(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me, TValue2 const * new_values);       	// "projects/library/seqan/map/sumlist_mini.h"(405)

//____________________________________________________________________________
// assign

template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline void assign(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & target, SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > const & source);       	// "projects/library/seqan/map/sumlist_mini.h"(218)
template <typename TKey, typename TCompare, typename TAlloc> inline void assign(::std::set<TKey, TCompare, TAlloc> & target, ::std::set<TKey, TCompare, TAlloc> const & source);       	// "projects/library/seqan/map/map_adapter_stl.h"(135)
template <typename TKey,typename TCargo, typename TCompare, typename TAlloc> inline void assign(::std::map<TKey,TCargo, TCompare, TAlloc> & target, ::std::map<TKey,TCargo, TCompare, TAlloc> const & source);       	// "projects/library/seqan/map/map_adapter_stl.h"(143)
template <typename TValue, typename TSpec> inline void assign(Map<TValue, Skiplist<TSpec> > & target, Map<TValue, Skiplist<TSpec> > const & source);       	// "projects/library/seqan/map/map_skiplist.h"(270)

//____________________________________________________________________________
// assignValue

template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec, typename TValue2> inline bool assignValue(Iter<SumList<DIM, TValue, MiniSumList<SIZE, TSpec> >, MiniSumListIterator > & it, int dim, TValue2 val);       	// "projects/library/seqan/map/sumlist_mini.h"(818)

//____________________________________________________________________________
// atEnd

template <typename TSet> inline bool atEnd(Iter<TSet, VectorSetIterator> & a);       	// "projects/library/seqan/map/map_vector.h"(392)
template <typename TSet> inline bool atEnd(Iter<TSet, VectorSetIterator> const & a);       	// "projects/library/seqan/map/map_vector.h"(398)
template <typename TSumList, typename TSumList2> inline bool atEnd(Iter< TSumList, _MiniSumListValueIterator > & it, TSumList2 const & container);       	// "projects/library/seqan/map/sumlist_mini.h"(622)
template <typename TSumList> inline bool atEnd(Iter<TSumList, MiniSumListIterator> & it);       	// "projects/library/seqan/map/sumlist_mini.h"(772)
template <typename TSTLMap> inline bool atEnd(Iter<TSTLMap, STLMapIterator> & it);       	// "projects/library/seqan/map/map_adapter_stl.h"(416)
template <typename TSTLMap> inline bool atEnd(Iter<TSTLMap, STLSetIterator> & it);       	// "projects/library/seqan/map/map_adapter_stl.h"(614)
template <typename TSkiplist> inline bool atEnd(Iter<TSkiplist, SkiplistIterator> & it);       	// "projects/library/seqan/map/map_skiplist.h"(1053)

//____________________________________________________________________________
// begin

template <typename TElement, typename TSpec> inline typename Iterator< Map<TElement, VectorSet<TSpec> > >::Type begin(Map<TElement, VectorSet<TSpec> > & set);       	// "projects/library/seqan/map/map_vector.h"(353)
template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline typename Iterator< SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > >::Type begin(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me);       	// "projects/library/seqan/map/sumlist_mini.h"(260)
template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline typename Iterator< SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > const>::Type begin(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > const & me);       	// "projects/library/seqan/map/sumlist_mini.h"(268)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TIteratorSpec> inline typename Iterator< ::std::map<TKey,TCargo, TCompare, TAlloc>, TIteratorSpec>::Type begin(::std::map<TKey,TCargo, TCompare, TAlloc> & me, TIteratorSpec);       	// "projects/library/seqan/map/map_adapter_stl.h"(372)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc> inline typename Iterator< ::std::map<TKey,TCargo, TCompare, TAlloc> >::Type begin(::std::map<TKey,TCargo, TCompare, TAlloc> & me);       	// "projects/library/seqan/map/map_adapter_stl.h"(380)
template <typename TValue, typename TCompare, typename TAlloc, typename TIteratorSpec> inline typename Iterator< ::std::set<TValue,TCompare,TAlloc>, TIteratorSpec>::Type begin(::std::set<TValue,TCompare,TAlloc> & me, TIteratorSpec);       	// "projects/library/seqan/map/map_adapter_stl.h"(570)
template <typename TValue, typename TCompare, typename TAlloc> inline typename Iterator< ::std::set<TValue,TCompare,TAlloc> >::Type begin(::std::set<TValue,TCompare,TAlloc> & me);       	// "projects/library/seqan/map/map_adapter_stl.h"(578)
template <typename TValue, typename TSpec, typename TIteratorSpec> inline typename Iterator< Map<TValue, Skiplist<TSpec> >, TIteratorSpec>::Type begin(Map<TValue, Skiplist<TSpec> > & me, TIteratorSpec);       	// "projects/library/seqan/map/map_skiplist.h"(900)
template <typename TValue, typename TSpec> inline typename Iterator< Map<TValue, Skiplist<TSpec> > >::Type begin(Map<TValue, Skiplist<TSpec> > & me);       	// "projects/library/seqan/map/map_skiplist.h"(907)

//____________________________________________________________________________
// cargo

template <typename TKey, typename TObject, typename TSpec> inline TObject & cargo(Pair<TKey, TObject, TSpec> & element);       	// "projects/library/seqan/map/map_base.h"(203)
template <typename TKey, typename TObject, typename TSpec> inline TObject const & cargo(Pair<TKey, TObject, TSpec> const & element);       	// "projects/library/seqan/map/map_base.h"(209)
template <typename TKey, typename TSpec, typename TKey2> inline typename Cargo< Map<TKey, VectorSet<TSpec> > >::Type & cargo(Map<TKey, VectorSet<TSpec> > & set, TKey2 const & _key);       	// "projects/library/seqan/map/map_vector.h"(336)
template <typename TSet> inline typename Cargo<TSet>::Type & cargo(Iter<TSet, VectorSetIterator> &it);       	// "projects/library/seqan/map/map_vector.h"(421)
template <typename TSet> inline typename Cargo<TSet>::Type & cargo(Iter<TSet, VectorSetIterator> const &it);       	// "projects/library/seqan/map/map_vector.h"(426)
template <typename TSet> inline typename Cargo<TSet>::Type & cargo(Proxy<IteratorProxy<Iter<TSet, VectorSetIterator> > >& pr);       	// "projects/library/seqan/map/map_vector.h"(484)
template <typename TSet> inline typename Cargo<TSet>::Type & cargo(Proxy<IteratorProxy<Iter<TSet, VectorSetIterator> > > const & pr);       	// "projects/library/seqan/map/map_vector.h"(490)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TKey2> inline typename Cargo< ::std::map<TKey,TCargo, TCompare, TAlloc> >::Type & cargo(::std::map<TKey,TCargo, TCompare, TAlloc> & me, TKey2 const & _key);       	// "projects/library/seqan/map/map_adapter_stl.h"(271)
template <typename TSTLMap> inline typename Cargo<TSTLMap>::Type & cargo(Iter<TSTLMap, STLMapIterator> & it);       	// "projects/library/seqan/map/map_adapter_stl.h"(470)
template <typename TSTLMap> inline typename Cargo<TSTLMap>::Type & cargo(Iter<TSTLMap, STLMapIterator> const & it);       	// "projects/library/seqan/map/map_adapter_stl.h"(477)
template <typename TValue, typename TSpec, typename TKey2> inline typename Cargo< Map<TValue, Skiplist<TSpec> > >::Type & cargo(Map<TValue, Skiplist<TSpec> > & me, TKey2 const & _key);       	// "projects/library/seqan/map/map_skiplist.h"(673)
template <typename TSkiplist> inline typename Cargo<TSkiplist>::Type & cargo(Iter<TSkiplist, SkiplistIterator> & it);       	// "projects/library/seqan/map/map_skiplist.h"(1101)
template <typename TSkiplist> inline typename Cargo<TSkiplist>::Type & cargo(Iter<TSkiplist, SkiplistIterator> const & it);       	// "projects/library/seqan/map/map_skiplist.h"(1107)

//____________________________________________________________________________
// clear

template <typename TValue, typename TSpec> inline void clear(Map<TValue, VectorSet<TSpec> > & me);       	// "projects/library/seqan/map/map_vector.h"(226)
template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline void clear(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me);       	// "projects/library/seqan/map/sumlist_mini.h"(249)
template <typename TSumList> inline void clear(Iter<TSumList, MiniSumListIterator> & it);       	// "projects/library/seqan/map/sumlist_mini.h"(722)
template <typename TValue, typename TCompare, typename TAlloc> inline void clear(::std::set<TValue, TCompare, TAlloc> & me);       	// "projects/library/seqan/map/map_adapter_stl.h"(242)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc> inline void clear(::std::map<TKey,TCargo, TCompare, TAlloc> & me);       	// "projects/library/seqan/map/map_adapter_stl.h"(250)
template <unsigned int DIM, typename TValue> inline void clear(SumListValues<DIM, TValue> & me);       	// "projects/library/seqan/map/sumlist.h"(188)
template <typename TValue, typename TSpec> inline void clear(Map<TValue, Skiplist<TSpec> > & me);       	// "projects/library/seqan/map/map_skiplist.h"(865)

//____________________________________________________________________________
// end

template <typename TElement, typename TSpec> inline typename Iterator< Map<TElement, VectorSet<TSpec> > >::Type end(Map<TElement, VectorSet<TSpec> > &set);       	// "projects/library/seqan/map/map_vector.h"(364)
template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline typename Iterator< SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > >::Type end(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me);       	// "projects/library/seqan/map/sumlist_mini.h"(278)
template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline typename Iterator< SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > const>::Type end(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > const& me);       	// "projects/library/seqan/map/sumlist_mini.h"(286)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TIteratorSpec> inline typename Iterator< ::std::map<TKey,TCargo, TCompare, TAlloc> >::Type end(::std::map<TKey,TCargo, TCompare, TAlloc> & me, TIteratorSpec);       	// "projects/library/seqan/map/map_adapter_stl.h"(392)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc> inline typename Iterator< ::std::map<TKey,TCargo, TCompare, TAlloc> >::Type end(::std::map<TKey,TCargo, TCompare, TAlloc> & me);       	// "projects/library/seqan/map/map_adapter_stl.h"(403)
template <typename TValue, typename TCompare, typename TAlloc, typename TIteratorSpec> inline typename Iterator< ::std::set<TValue, TCompare, TAlloc>, TIteratorSpec>::Type end(::std::set<TValue, TCompare, TAlloc> & me, TIteratorSpec);       	// "projects/library/seqan/map/map_adapter_stl.h"(590)
template <typename TValue, typename TCompare, typename TAlloc> inline typename Iterator< ::std::set<TValue,TCompare,TAlloc> >::Type end(::std::set<TValue,TCompare,TAlloc> & me);       	// "projects/library/seqan/map/map_adapter_stl.h"(601)
template <typename TValue, typename TSpec, typename TIteratorSpec> inline typename Iterator< Map<TValue, Skiplist<TSpec> >, TIteratorSpec>::Type end(Map<TValue, Skiplist<TSpec> > &, TIteratorSpec);       	// "projects/library/seqan/map/map_skiplist.h"(920)
template <typename TValue, typename TSpec> inline typename Iterator< Map<TValue, Skiplist<TSpec> > >::Type end(Map<TValue, Skiplist<TSpec> > &);       	// "projects/library/seqan/map/map_skiplist.h"(927)

//____________________________________________________________________________
// erase

template <typename TValue, typename TSpec, typename T> inline void erase(Map<TValue, VectorSet<TSpec> > &set, T const & tokill);       	// "projects/library/seqan/map/map_vector.h"(301)
template <typename TValue, typename TCompare, typename TAlloc, typename TMap2> inline void erase(::std::set<TValue, TCompare, TAlloc> & me, Iter<TMap2, STLSetIterator> const & it);       	// "projects/library/seqan/map/map_adapter_stl.h"(705)
template <typename TKey, typename TCargo ,typename TMap2> inline void erase(::std::map<TKey,TCargo> & me, Iter<TMap2, STLMapIterator> const & it);       	// "projects/library/seqan/map/map_adapter_stl.h"(714)
template <typename TValue, typename TCompare, typename TAlloc, typename TToRemove> inline void erase(::std::set<TValue, TCompare, TAlloc> & me, TToRemove const & to_remove);       	// "projects/library/seqan/map/map_adapter_stl.h"(726)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TToRemove> inline void erase(::std::map<TKey,TCargo, TCompare, TAlloc> & me, TToRemove const & to_remove);       	// "projects/library/seqan/map/map_adapter_stl.h"(735)
template <typename TValue, typename TSpec, typename TMap2> inline void erase(Map<TValue, Skiplist<TSpec> > & me, Iter<TMap2, SkiplistIterator> const & it);       	// "projects/library/seqan/map/map_skiplist.h"(808)
template <typename TValue, typename TSpec, typename TToRemove> inline void erase(Map<TValue, Skiplist<TSpec> > & me, TToRemove const & to_remove);       	// "projects/library/seqan/map/map_skiplist.h"(817)

//____________________________________________________________________________
// eraseAll

template <typename TValue, typename TSpec, typename TToRemove> inline void eraseAll(Map<TValue, Skiplist<TSpec> > & me, TToRemove const & to_remove);       	// "projects/library/seqan/map/map_skiplist.h"(848)

//____________________________________________________________________________
// find

template <typename TKey, typename TKey2, typename TSpec> inline typename Iterator< Map<TKey2, VectorSet<TSpec> > >::Type find(Map<TKey2, VectorSet<TSpec> > & set, TKey const &key);       	// "projects/library/seqan/map/map_vector.h"(324)
template <typename TValue, typename TCompare, typename TAlloc,typename TFind> inline typename Iterator< ::std::set<TValue, TCompare, TAlloc> >::Type find(::std::set<TValue, TCompare, TAlloc> & me, TFind const & _find);       	// "projects/library/seqan/map/map_adapter_stl.h"(668)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TFind> inline typename Iterator< ::std::map<TKey,TCargo, TCompare, TAlloc> >::Type find(::std::map<TKey,TCargo, TCompare, TAlloc> & me, TFind const & _find);       	// "projects/library/seqan/map/map_adapter_stl.h"(685)
template <typename TValue, typename TSpec, typename TFind> inline typename Iterator< Map<TValue, Skiplist<TSpec> > >::Type find(Map<TValue, Skiplist<TSpec> > & me, TFind const & _find, SkiplistPath<TValue, TSpec> & path);       	// "projects/library/seqan/map/map_skiplist.h"(547)
template <typename TValue, typename TSpec, typename TFind> inline typename Iterator< Map<TValue, Skiplist<TSpec> > >::Type find(Map<TValue, Skiplist<TSpec> > & me, TFind const & _find);       	// "projects/library/seqan/map/map_skiplist.h"(557)

//____________________________________________________________________________
// getSum

template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline typename Value< SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > >::Type & getSum(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me, unsigned int dim);       	// "projects/library/seqan/map/sumlist_mini.h"(240)
template <typename TSumList> inline typename Value<TSumList>::Type getSum(Iter<TSumList, MiniSumListIterator > & it, int dim);       	// "projects/library/seqan/map/sumlist_mini.h"(792)

//____________________________________________________________________________
// getValue

template <typename TSumList> inline typename Value<TSumList>::Type getValue(Iter<TSumList, _MiniSumListValueIterator > & it);       	// "projects/library/seqan/map/sumlist_mini.h"(595)
template <typename TSumList> inline typename Value<TSumList>::Type getValue(Iter<TSumList, MiniSumListIterator > & it, int dim);       	// "projects/library/seqan/map/sumlist_mini.h"(782)

//____________________________________________________________________________
// goBeforeEnd

template <typename TSumList> inline void goBeforeEnd(Iter<TSumList, MiniSumListIterator> & it);       	// "projects/library/seqan/map/sumlist_mini.h"(759)

//____________________________________________________________________________
// goBegin

template <typename TSumList> inline void goBegin(Iter<TSumList, MiniSumListIterator> & it);       	// "projects/library/seqan/map/sumlist_mini.h"(748)

//____________________________________________________________________________
// goNext

template <typename TSet> inline void goNext(Iter<TSet, VectorSetIterator> & it);       	// "projects/library/seqan/map/map_vector.h"(453)
template <typename TSumList> inline void goNext(Iter< TSumList, _MiniSumListValueIterator > & it);       	// "projects/library/seqan/map/sumlist_mini.h"(583)
template <typename TSumList> inline void goNext(Iter<TSumList, MiniSumListIterator> & it);       	// "projects/library/seqan/map/sumlist_mini.h"(734)
template <typename TSTLMap> inline void goNext(Iter<TSTLMap, STLMapIterator> & it);       	// "projects/library/seqan/map/map_adapter_stl.h"(426)
template <typename TSTLMap> inline void goNext(Iter<TSTLMap, STLSetIterator> & it);       	// "projects/library/seqan/map/map_adapter_stl.h"(624)
template <typename TSkiplist> inline void goNext(Iter<TSkiplist, SkiplistIterator> & it);       	// "projects/library/seqan/map/map_skiplist.h"(1062)

//____________________________________________________________________________
// hasKey

template <typename TKey, typename TValue, typename TSpec> inline bool hasKey(Map<TValue, VectorSet<TSpec> > const &set, TKey const &key);       	// "projects/library/seqan/map/map_vector.h"(314)
template <typename TValue, typename TCompare, typename TAlloc, typename TKey2> inline bool hasKey(::std::set<TValue,TCompare,TAlloc> & me, TKey2 const & _key);       	// "projects/library/seqan/map/map_adapter_stl.h"(152)
template <typename TValue, typename TCompare, typename TAlloc, typename TKey2> inline bool hasKey(::std::set<TValue,TCompare,TAlloc> const & me, TKey2 const & _key);       	// "projects/library/seqan/map/map_adapter_stl.h"(160)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TKey2> inline bool hasKey(::std::map<TKey, TCargo, TCompare, TAlloc> & me, TKey2 const & _key);       	// "projects/library/seqan/map/map_adapter_stl.h"(169)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TKey2> inline bool hasKey(::std::map<TKey, TCargo, TCompare, TAlloc> const & me, TKey2 const & _key);       	// "projects/library/seqan/map/map_adapter_stl.h"(177)
template <typename TValue, typename TSpec, typename TKey2> inline bool hasKey(Map<TValue, Skiplist<TSpec> > & me, TKey2 const & _key);       	// "projects/library/seqan/map/map_skiplist.h"(988)

//____________________________________________________________________________
// insert

template <typename TValue, typename TSpec, typename TElement> inline void insert(Map<TValue, VectorSet<TSpec> > & set, TElement const &element);       	// "projects/library/seqan/map/map_vector.h"(276)
template <typename TValue, typename TSpec, typename TKey, typename TCargo> inline void insert(Map<TValue, VectorSet<TSpec> > &set, TKey const & _key, TCargo const & _cargo);       	// "projects/library/seqan/map/map_vector.h"(286)
template <typename TValue, typename TCompare, typename TAlloc, typename TValue2> inline void insert(::std::set<TValue, TCompare, TAlloc> & me,TValue2 const & _value);       	// "projects/library/seqan/map/map_adapter_stl.h"(205)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TKey2, typename TCargo2> inline void insert(::std::map<TKey,TCargo, TCompare, TAlloc> & me, TKey2 const & _key, TCargo2 const & _cargo);       	// "projects/library/seqan/map/map_adapter_stl.h"(215)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TKey2> inline void insert(::std::map<TKey,TCargo, TCompare, TAlloc> & me,TKey2 const & _key);       	// "projects/library/seqan/map/map_adapter_stl.h"(223)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc, typename TKey2, typename TCargo2, typename TSpec> inline void insert(::std::map<TKey,TCargo, TCompare, TAlloc> & me, Pair<TKey2,TCargo2,TSpec> const & _value);       	// "projects/library/seqan/map/map_adapter_stl.h"(231)
template <typename TValue, typename TSpec, typename TValue2> inline void insert(Map<TValue, Skiplist<TSpec> > & me, TValue2 const & _value);       	// "projects/library/seqan/map/map_skiplist.h"(705)
template <typename TValue, typename TSpec, typename TKey2, typename TCargo2> inline void insert(Map<TValue, Skiplist<TSpec> > & me, TKey2 const & _key, TCargo2 const & _cargo);       	// "projects/library/seqan/map/map_skiplist.h"(713)

//____________________________________________________________________________
// insertValues

template <typename TSumList, typename TValues> inline bool insertValues(Iter<TSumList, MiniSumListIterator > & it, TValues const & vals);       	// "projects/library/seqan/map/sumlist_mini.h"(867)
template <typename TSumList, typename TValue> inline bool insertValues(Iter<TSumList, MiniSumListIterator > & it, TValue const * p_vals);       	// "projects/library/seqan/map/sumlist_mini.h"(881)

//____________________________________________________________________________
// key

template <typename TElement> inline TElement & key(TElement & element);       	// "projects/library/seqan/map/map_base.h"(157)
template <typename TElement> inline TElement const & key(TElement const & element);       	// "projects/library/seqan/map/map_base.h"(163)
template <typename TKey, typename TObject, typename TSpec> inline TKey & key(Pair<TKey, TObject, TSpec> & element);       	// "projects/library/seqan/map/map_base.h"(170)
template <typename TKey, typename TObject, typename TSpec> inline TKey const & key(Pair<TKey, TObject, TSpec> const & element);       	// "projects/library/seqan/map/map_base.h"(176)
template <typename TSet> inline typename Key<TSet>::Type key(Iter<TSet, VectorSetIterator> &it);       	// "projects/library/seqan/map/map_vector.h"(407)
template <typename TSet> inline typename Key<TSet>::Type key(Iter<TSet, VectorSetIterator> const &it);       	// "projects/library/seqan/map/map_vector.h"(413)
template <typename TSet> inline typename Key<TSet>::Type key(Proxy<IteratorProxy<Iter<TSet, VectorSetIterator> > > & pr);       	// "projects/library/seqan/map/map_vector.h"(469)
template <typename TSet> inline typename Key<TSet>::Type key(Proxy<IteratorProxy<Iter<TSet, VectorSetIterator> > > const & pr);       	// "projects/library/seqan/map/map_vector.h"(475)
template <typename TSTLMap> inline typename Key<TSTLMap>::Type const & key(Iter<TSTLMap, STLMapIterator> & it);       	// "projects/library/seqan/map/map_adapter_stl.h"(453)
template <typename TSTLMap> inline typename Key<TSTLMap>::Type const & key(Iter<TSTLMap, STLMapIterator> const & it);       	// "projects/library/seqan/map/map_adapter_stl.h"(460)
template <typename TSTLMap> inline typename Key<TSTLMap>::Type const & key(Iter<TSTLMap, STLSetIterator> & it);       	// "projects/library/seqan/map/map_adapter_stl.h"(649)
template <typename TSTLMap> inline typename Key<TSTLMap>::Type const & key(Iter<TSTLMap, STLSetIterator> const & it);       	// "projects/library/seqan/map/map_adapter_stl.h"(656)
template <typename TSkiplist> inline typename Key<TSkiplist>::Type const & key(Iter<TSkiplist, SkiplistIterator> & it);       	// "projects/library/seqan/map/map_skiplist.h"(1086)
template <typename TSkiplist> inline typename Key<TSkiplist>::Type const & key(Iter<TSkiplist, SkiplistIterator> const & it);       	// "projects/library/seqan/map/map_skiplist.h"(1092)

//____________________________________________________________________________
// length

template <typename TValue, typename TSpec> inline typename Size< Map<TValue, VectorSet<TSpec> > >::Type length(Map<TValue, VectorSet<TSpec> > const &set);       	// "projects/library/seqan/map/map_vector.h"(157)
template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline typename Size< SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > >::Type length(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me);       	// "projects/library/seqan/map/sumlist_mini.h"(230)
template <typename TValue, typename TCompare, typename TAlloc> inline typename Size< ::std::set<TValue, TCompare, TAlloc> >::Type length(::std::set<TValue, TCompare, TAlloc> const & me);       	// "projects/library/seqan/map/map_adapter_stl.h"(187)
template <typename TKey, typename TCargo, typename TCompare, typename TAlloc> inline typename Size< ::std::map<TKey,TCargo, TCompare, TAlloc> >::Type length(::std::map<TKey,TCargo, TCompare, TAlloc> const & me);       	// "projects/library/seqan/map/map_adapter_stl.h"(195)
template <typename TValue, typename TSpec> inline typename Size< Map<TValue, Skiplist<TSpec> > >::Type length(Map<TValue, Skiplist<TSpec> > const & me);       	// "projects/library/seqan/map/map_skiplist.h"(888)

//____________________________________________________________________________
// mapValue

template <typename TMap, typename TKey> inline typename MapValue<TMap>::Type mapValue(TMap & me, TKey const & _key);       	// "projects/library/seqan/map/map_base.h"(147)
template <typename TValue, typename TSpec, typename TKey2> inline typename MapValue< Map<TValue, Skiplist<TSpec> > >::Type mapValue(Map<TValue, Skiplist<TSpec> > & me, TKey2 const & _key);       	// "projects/library/seqan/map/map_skiplist.h"(964)

//____________________________________________________________________________
// operator!=

template <typename TSet> inline bool operator!=(Iter<TSet, VectorSetIterator> const &a, Iter<TSet, VectorSetIterator> const &b);       	// "projects/library/seqan/map/map_vector.h"(383)
template <typename TSumList, typename TSumList2> inline bool operator!= (Iter<TSumList, MiniSumListIterator> const & left, Iter<TSumList2, MiniSumListIterator> const & right);       	// "projects/library/seqan/map/sumlist_mini.h"(927)
template <typename TSTLMap> inline bool operator!= (Iter<TSTLMap, STLMapIterator> const & left, Iter<TSTLMap, STLMapIterator> const & right);       	// "projects/library/seqan/map/map_adapter_stl.h"(361)
template <typename TSTLMap> inline bool operator!= (Iter<TSTLMap, STLSetIterator> const & left, Iter<TSTLMap, STLSetIterator> const & right);       	// "projects/library/seqan/map/map_adapter_stl.h"(559)
template <unsigned int DIM, typename TValue> inline bool operator!= (SumListValues<DIM, TValue> const & left, SumListValues<DIM, TValue> const & right);       	// "projects/library/seqan/map/sumlist.h"(176)
template <typename TSkiplist> inline bool operator!= (Iter<TSkiplist, SkiplistIterator> const & left, Iter<TSkiplist, SkiplistIterator> const & right);       	// "projects/library/seqan/map/map_skiplist.h"(1125)

//____________________________________________________________________________
// operator+=

template <unsigned int DIM, typename TValue> inline SumListValues<DIM, TValue> const & operator+= (SumListValues<DIM, TValue> & left, SumListValues<DIM, TValue> const & right);       	// "projects/library/seqan/map/sumlist.h"(137)

//____________________________________________________________________________
// operator-=

template <unsigned int DIM, typename TValue> inline SumListValues<DIM, TValue> const & operator-= (SumListValues<DIM, TValue> & left, SumListValues<DIM, TValue> const & right);       	// "projects/library/seqan/map/sumlist.h"(151)

//____________________________________________________________________________
// operator==

template <typename TSet> inline bool operator==(Iter<TSet, VectorSetIterator> const &a, Iter<TSet, VectorSetIterator> const &b);       	// "projects/library/seqan/map/map_vector.h"(376)
template <typename TSumList, typename TSumList2> inline bool operator== (Iter<TSumList, MiniSumListIterator> const & left, Iter<TSumList2, MiniSumListIterator> const & right);       	// "projects/library/seqan/map/sumlist_mini.h"(919)
template <typename TSTLMap> inline bool operator== (Iter<TSTLMap, STLMapIterator> const & left, Iter<TSTLMap, STLMapIterator> const & right);       	// "projects/library/seqan/map/map_adapter_stl.h"(352)
template <typename TSTLMap> inline bool operator== (Iter<TSTLMap, STLSetIterator> const & left, Iter<TSTLMap, STLSetIterator> const & right);       	// "projects/library/seqan/map/map_adapter_stl.h"(550)
template <unsigned int DIM, typename TValue> inline bool operator== (SumListValues<DIM, TValue> const & left, SumListValues<DIM, TValue> const & right);       	// "projects/library/seqan/map/sumlist.h"(165)
template <typename TSkiplist> inline bool operator== (Iter<TSkiplist, SkiplistIterator> const & left, Iter<TSkiplist, SkiplistIterator> const & right);       	// "projects/library/seqan/map/map_skiplist.h"(1117)

//____________________________________________________________________________
// removeValues

template <typename TSumList> inline void removeValues(Iter<TSumList, MiniSumListIterator > & it);       	// "projects/library/seqan/map/sumlist_mini.h"(891)

//____________________________________________________________________________
// scanValues

template <typename TSumList, typename TValues> inline void scanValues( Iter< TSumList, _MiniSumListValueIterator > & it,  TValues & values);       	// "projects/library/seqan/map/sumlist_mini.h"(608)

//____________________________________________________________________________
// searchSumList

template <typename TSumList, typename TValue> inline void searchSumList(Iter< TSumList, MiniSumListIterator > & it, TValue const & val, int dim);       	// "projects/library/seqan/map/sumlist_mini.h"(803)

//____________________________________________________________________________
// setCargo

template <typename TKey, typename TObject, typename TSpec, typename TSource> inline void setCargo(Pair<TKey, TObject, TSpec> & element, TSource const & source);       	// "projects/library/seqan/map/map_base.h"(219)

//____________________________________________________________________________
// setKey

template <typename TElement, typename TSource> inline void setKey(TElement & element, TSource const & source);       	// "projects/library/seqan/map/map_base.h"(186)
template <typename TKey, typename TObject, typename TSpec, typename TSource> inline void setKey(Pair<TKey, TObject, TSpec> & element, TSource const & source);       	// "projects/library/seqan/map/map_base.h"(193)

//____________________________________________________________________________
// splitSumList

template <unsigned int DIM, typename TValue, unsigned short SIZE, typename TSpec> inline void splitSumList(SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & me, SumList<DIM, TValue, MiniSumList<SIZE, TSpec> > & right);       	// "projects/library/seqan/map/sumlist_mini.h"(419)

//____________________________________________________________________________
// value

template <typename TSet> inline typename Reference<TSet>::Type value(Iter<TSet, VectorSetIterator> &it);       	// "projects/library/seqan/map/map_vector.h"(435)
template <typename TSet> inline typename Reference<TSet>::Type value(Iter<TSet, VectorSetIterator> const &it);       	// "projects/library/seqan/map/map_vector.h"(442)
template <typename TSTLMap> inline typename Value<TSTLMap>::Type & value(Iter<TSTLMap, STLMapIterator> & it);       	// "projects/library/seqan/map/map_adapter_stl.h"(436)
template <typename TSTLMap> inline typename Value<TSTLMap>::Type & value(Iter<TSTLMap, STLMapIterator> const & it);       	// "projects/library/seqan/map/map_adapter_stl.h"(443)
template <typename TValue, typename TSpec, typename TKey2> inline typename Value< Map<TValue, Skiplist<TSpec> > >::Type & value(Map<TValue, Skiplist<TSpec> > & me, TKey2 const & _key);       	// "projects/library/seqan/map/map_skiplist.h"(626)
template <typename TSkiplist> inline typename Value<TSkiplist>::Type & value(Iter<TSkiplist, SkiplistIterator> & it);       	// "projects/library/seqan/map/map_skiplist.h"(1071)
template <typename TSkiplist> inline typename Value<TSkiplist>::Type & value(Iter<TSkiplist, SkiplistIterator> const & it);       	// "projects/library/seqan/map/map_skiplist.h"(1077)

} //namespace SEQAN_NAMESPACE_MAIN

#endif

