// ==========================================================================
//                 SeqAn - The Library for Sequence Analysis
// ==========================================================================
// Copyright (c) 2006-2010, Knut Reinert, FU Berlin
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
//     * Redistributions of source code must retain the above copyright
//       notice, this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright
//       notice, this list of conditions and the following disclaimer in the
//       documentation and/or other materials provided with the distribution.
//     * Neither the name of Knut Reinert or the FU Berlin nor the names of
//       its contributors may be used to endorse or promote products derived
//       from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL KNUT REINERT OR THE FU BERLIN BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
// LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
// OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
// DAMAGE.
//
// ==========================================================================


#ifndef SEQAN_HEADER_SEEDS2_GENERATED_FORWARDS_H 
#define SEQAN_HEADER_SEEDS2_GENERATED_FORWARDS_H 

//////////////////////////////////////////////////////////////////////////////
// NOTE: This file is automatically generated by build_forwards.py
//       Do not edit this file manually!
//////////////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////////////
// CLASSES
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// AlignmentChain_

template <typename TSegment, typename TScoringScheme, typename TAlignmentTag> class AlignmentChain_;       	// "projects/library/seqan/seeds2/align_chain_banded.h"(84)

//____________________________________________________________________________
// AlignmentMatrixDimension_

template <typename AlignmentAlgorithm> struct AlignmentMatrixDimension_;       	// "projects/library/seqan/seeds2/align_chain_banded.h"(68)

//____________________________________________________________________________
// Chained_

struct Chained_;       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(46)

//____________________________________________________________________________
// Chaos_

struct Chaos_;       	// "projects/library/seqan/seeds2/seeds_combination.h"(64)

//____________________________________________________________________________
// DefaultSeedConfig

struct DefaultSeedConfig;       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(66)

//____________________________________________________________________________
// DefaultSeedConfigScore

struct DefaultSeedConfigScore;       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(77)

//____________________________________________________________________________
// DefaultSeedSetConfig

struct DefaultSeedSetConfig;       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(57)

//____________________________________________________________________________
// DefaultSeedSetConfigLength

struct DefaultSeedSetConfigLength;       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(102)

//____________________________________________________________________________
// DefaultSeedSetConfigScore

struct DefaultSeedSetConfigScore;       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(139)

//____________________________________________________________________________
// Diagonal

template <typename T> struct Diagonal;       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(134)

//____________________________________________________________________________
// GappedXDrop_

struct GappedXDrop_;       	// "projects/library/seqan/seeds2/seeds_extension.h"(76)

//____________________________________________________________________________
// HasScore

template <typename T> struct HasScore;       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(156)

//____________________________________________________________________________
// Indirect

template <typename TWrappedIter> struct Indirect;       	// "projects/library/seqan/seeds2/basic_iter_indirect.h"(48)

//____________________________________________________________________________
// MatchExtend_

struct MatchExtend_;       	// "projects/library/seqan/seeds2/seeds_extension.h"(70)

//____________________________________________________________________________
// Merge_

struct Merge_;       	// "projects/library/seqan/seeds2/seeds_combination.h"(61)

//____________________________________________________________________________
// MinScoreMixin_

template <typename TScore> struct MinScoreMixin_;       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(110)

//____________________________________________________________________________
// MinScore_

struct MinScore_;       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(50)

//____________________________________________________________________________
// MinSeedSizeMixin_

template <typename TSize> struct MinSeedSizeMixin_;       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(74)

//____________________________________________________________________________
// MinSeedSize_

struct MinSeedSize_;       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(47)

//____________________________________________________________________________
// ScoreMixin_

template <typename TScore> struct ScoreMixin_;       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(49)

//____________________________________________________________________________
// Seed

template <typename TSpec, typename TConfig > class Seed;       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(96)

//____________________________________________________________________________
// SeedDiagonal

template <typename TPosition, typename TSize> class SeedDiagonal;       	// "projects/library/seqan/seeds2/seeds_seed_diagonal.h"(58)

//____________________________________________________________________________
// SeedScore

template <typename T> struct SeedScore;       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(178)

//____________________________________________________________________________
// SeedSet

template <typename TSeedSpec, typename TSpec, typename TSeedSetConfig > class SeedSet;       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(158)

//____________________________________________________________________________
// Simple

struct Simple;       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(49)

//____________________________________________________________________________
// SimpleChain_

struct SimpleChain_;       	// "projects/library/seqan/seeds2/seeds_combination.h"(67)

//____________________________________________________________________________
// Single_

struct Single_;       	// "projects/library/seqan/seeds2/seeds_combination.h"(70)

//____________________________________________________________________________
// SparseChaining_

struct SparseChaining_;       	// "projects/library/seqan/seeds2/seeds_global_chaining.h"(55)

//____________________________________________________________________________
// Tikz_

struct Tikz_;       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(317)

//____________________________________________________________________________
// UngappedXDrop_

struct UngappedXDrop_;       	// "projects/library/seqan/seeds2/seeds_extension.h"(73)

//____________________________________________________________________________
// Unordered_

struct Unordered_;       	// "projects/library/seqan/seeds2/seeds_seed_set_unordered.h"(49)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// TYPEDEFS
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// ChainedSeed

typedef Tag<Chained_> ChainedSeed;       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(47)

//____________________________________________________________________________
// Chaos

typedef Tag<Chaos_> Chaos;       	// "projects/library/seqan/seeds2/seeds_combination.h"(65)

//____________________________________________________________________________
// GappedXDrop

typedef Tag<GappedXDrop_> const GappedXDrop;       	// "projects/library/seqan/seeds2/seeds_extension.h"(77)

//____________________________________________________________________________
// MatchExtend

typedef Tag<MatchExtend_> const MatchExtend;       	// "projects/library/seqan/seeds2/seeds_extension.h"(71)

//____________________________________________________________________________
// Merge

typedef Tag<Merge_> Merge;       	// "projects/library/seqan/seeds2/seeds_combination.h"(62)

//____________________________________________________________________________
// MinScore

typedef Tag<MinScore_> MinScore;       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(51)

//____________________________________________________________________________
// MinSeedSize

typedef Tag<MinSeedSize_> MinSeedSize;       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(48)

//____________________________________________________________________________
// SimpleChain

typedef Tag<SimpleChain_> SimpleChain;       	// "projects/library/seqan/seeds2/seeds_combination.h"(68)

//____________________________________________________________________________
// Single

typedef Tag<Single_> Single;       	// "projects/library/seqan/seeds2/seeds_combination.h"(71)

//____________________________________________________________________________
// SparseChaining

typedef Tag<SparseChaining_> SparseChaining;       	// "projects/library/seqan/seeds2/seeds_global_chaining.h"(56)

//____________________________________________________________________________
// UnGappedXDrop

typedef Tag<UngappedXDrop_> const UnGappedXDrop;       	// "projects/library/seqan/seeds2/seeds_extension.h"(74)

//____________________________________________________________________________
// Unordered

typedef Tag<Unordered_> Unordered;       	// "projects/library/seqan/seeds2/seeds_seed_set_unordered.h"(50)

} //namespace seqan


//////////////////////////////////////////////////////////////////////////////
// FUNCTIONS
//////////////////////////////////////////////////////////////////////////////

namespace seqan {

//____________________________________________________________________________
// _alignBandedFillMatrix

template <typename TScoreValue, typename TSequence, typename TDiagonal> inline void _alignBandedFillMatrix(Matrix<TScoreValue, 3> & matrix, TSequence const & sequence0, TSequence const & sequence1, Score<TScoreValue, Simple> const & scoringScheme, TDiagonal lowerDiagonal, TDiagonal upperDiagonal, Gotoh const &);       	// "projects/library/seqan/seeds2/align_dynprog_banded_affine.h"(234)
template <typename TScoreValue, typename TSequence, typename TDiagonal> inline void _alignBandedFillMatrix(Matrix<TScoreValue, 2> & matrix, TSequence const & sequence0, TSequence const & sequence1, Score<TScoreValue, Simple> const & scoringScheme, TDiagonal lowerDiagonal, TDiagonal upperDiagonal, NeedlemanWunsch const &);       	// "projects/library/seqan/seeds2/align_dynprog_banded_linear.h"(201)

//____________________________________________________________________________
// _alignBandedInitGutter

template <typename TScoreValue, typename TDiagonal, bool BEGIN1_FREE, bool BEGIN0_FREE, bool END1_FREE, bool END0_FREE> inline void _alignBandedInitGutter(Matrix<TScoreValue, 3> & matrix, Score<TScoreValue, Simple> const & scoringScheme, TDiagonal lowerDiagonal, TDiagonal upperDiagonal, AlignConfig<BEGIN1_FREE, BEGIN0_FREE, END1_FREE, END0_FREE> const &, Gotoh const &);       	// "projects/library/seqan/seeds2/align_dynprog_banded_affine.h"(79)
template <typename TScoreValue, typename TDiagonal, bool BEGIN1_FREE, bool BEGIN0_FREE, bool END1_FREE, bool END0_FREE> inline void _alignBandedInitGutter(Matrix<TScoreValue, 2> & matrix, Score<TScoreValue, Simple> const & scoringScheme, TDiagonal lowerDiagonal, TDiagonal upperDiagonal, AlignConfig<BEGIN1_FREE, BEGIN0_FREE, END1_FREE, END0_FREE> const &, NeedlemanWunsch const &);       	// "projects/library/seqan/seeds2/align_dynprog_banded_linear.h"(89)

//____________________________________________________________________________
// _alignBandedInitGutterFromUnbanded

template <typename TScoreValue, typename TDiagonal, typename TOverlap> inline void _alignBandedInitGutterFromUnbanded(Matrix<TScoreValue, 3> & matrix, Score<TScoreValue, Simple> const & scoringScheme, TDiagonal lowerDiagonal, TDiagonal upperDiagonal, Matrix<TScoreValue, 3> & otherMatrix, TOverlap overlap0, TOverlap overlap1, Gotoh const &);       	// "projects/library/seqan/seeds2/align_dynprog_banded_affine.h"(150)
template <typename TScoreValue, typename TDiagonal, typename TOverlap> inline void _alignBandedInitGutterFromUnbanded(Matrix<TScoreValue, 2> & matrix, Score<TScoreValue, Simple> const & scoringScheme, TDiagonal lowerDiagonal, TDiagonal upperDiagonal, Matrix<TScoreValue, 2> & otherMatrix, TOverlap overlap0, TOverlap overlap1, NeedlemanWunsch const &);       	// "projects/library/seqan/seeds2/align_dynprog_banded_linear.h"(140)

//____________________________________________________________________________
// _alignBandedResizeMatrix

template <typename TScoreValue, typename TSequence, typename TDiagonal> inline void _alignBandedResizeMatrix(Matrix<TScoreValue, 3> & matrix, TSequence const & sequence0, TSequence const & sequence1, TDiagonal lowerDiagonal, TDiagonal upperDiagonal, Gotoh const &);       	// "projects/library/seqan/seeds2/align_dynprog_banded_affine.h"(57)
template <typename TScoreValue, typename TSequence, typename TDiagonal> inline void _alignBandedResizeMatrix(Matrix<TScoreValue, 2> & matrix, TSequence const & sequence0, TSequence const & sequence1, TDiagonal lowerDiagonal, TDiagonal upperDiagonal, NeedlemanWunsch const &);       	// "projects/library/seqan/seeds2/align_dynprog_banded_linear.h"(67)

//____________________________________________________________________________
// _alignBandedTraceback

template <typename TAlignmentIterator, typename TSequenceIterator, typename TPosition, typename TScoreValue, typename TScoringScheme, typename TOverlap, bool START0_FREE, bool START1_FREE, bool END0_FREE, bool END1_FREE> TScoreValue _alignBandedTraceback(TAlignmentIterator & alignmentIt0, TAlignmentIterator & alignmentIt1, TSequenceIterator & sourceIt0, TSequenceIterator & sourceIt1, TPosition & finalPos0, TPosition & finalPos1, Matrix<TScoreValue, 3> & matrix, TScoringScheme const & scoringScheme, TOverlap overlap0, TOverlap overlap1, TOverlap upperTriangleEdgeLength, TOverlap lowerTriangleEdgeLength, bool goToTopLeft, AlignConfig<START1_FREE, START0_FREE, END1_FREE, END0_FREE> const &, Gotoh const &);       	// "projects/library/seqan/seeds2/align_dynprog_banded_affine.h"(373)
template <typename TAlignmentIterator, typename TSequenceIterator, typename TPosition, typename TScoreValue, typename TScoringScheme, typename TOverlap, bool START0_FREE, bool START1_FREE, bool END0_FREE, bool END1_FREE> TScoreValue _alignBandedTraceback(TAlignmentIterator & alignmentIt0, TAlignmentIterator & alignmentIt1, TSequenceIterator & sourceIt0, TSequenceIterator & sourceIt1, TPosition & finalPos0, TPosition & finalPos1, Matrix<TScoreValue, 2> & matrix, TScoringScheme const & scoringScheme, TOverlap overlap0, TOverlap overlap1, TOverlap upperTriangleEdgeLength, TOverlap lowerTriangleEdgeLength, bool goToTopLeft, AlignConfig<START1_FREE, START0_FREE, END1_FREE, END0_FREE> const &, NeedlemanWunsch const &);       	// "projects/library/seqan/seeds2/align_dynprog_banded_linear.h"(326)

//____________________________________________________________________________
// _alignFillMatrix

template <typename TScoreValue, typename TSequence> inline void _alignFillMatrix(Matrix<TScoreValue, 3> & matrix, TSequence const & sequence0, TSequence const & sequence1, Score<TScoreValue, Simple> const & scoringScheme, Gotoh const &);       	// "projects/library/seqan/seeds2/align_dynprog_affine.h"(221)
template <typename TScoreValue, typename TSequence> inline void _alignFillMatrix(Matrix<TScoreValue, 2> & matrix, TSequence const & sequence0, TSequence const & sequence1, Score<TScoreValue, Simple> const & scoringScheme, NeedlemanWunsch const &);       	// "projects/library/seqan/seeds2/align_dynprog_linear.h"(177)

//____________________________________________________________________________
// _alignInitGutter

template <typename TScoreValue, bool BEGIN1_FREE, bool BEGIN0_FREE, bool END1_FREE, bool END0_FREE> inline void _alignInitGutter(Matrix<TScoreValue, 3> & matrix, Score<TScoreValue, Simple> const scoringScheme, AlignConfig<BEGIN1_FREE, BEGIN0_FREE, END1_FREE, END0_FREE> const &, Gotoh const &);       	// "projects/library/seqan/seeds2/align_dynprog_affine.h"(78)
template <typename TScoreValue, bool BEGIN1_FREE, bool BEGIN0_FREE, bool END1_FREE, bool END0_FREE> inline void _alignInitGutter(Matrix<TScoreValue, 2> & matrix, Score<TScoreValue, Simple> const & scoringScheme, AlignConfig<BEGIN1_FREE, BEGIN0_FREE, END1_FREE, END0_FREE> const &, NeedlemanWunsch const &);       	// "projects/library/seqan/seeds2/align_dynprog_linear.h"(78)

//____________________________________________________________________________
// _alignInitGutterFromBanded

template <typename TScoreValue, typename TDiagonal, typename TOverlap> inline void _alignInitGutterFromBanded(Matrix<TScoreValue, 3> & matrix, Score<TScoreValue, Simple> const & scoringScheme, TDiagonal lowerDiagonal, TDiagonal upperDiagonal, Matrix<TScoreValue, 3> & otherMatrix, TOverlap overlap0, TOverlap overlap1, Gotoh const &);       	// "projects/library/seqan/seeds2/align_dynprog_affine.h"(145)
template <typename TScoreValue, typename TDiagonal, typename TOverlap> inline void _alignInitGutterFromBanded(Matrix<TScoreValue, 2> & matrix, Score<TScoreValue, Simple> const & scoringScheme, TDiagonal lowerDiagonal, TDiagonal upperDiagonal, Matrix<TScoreValue, 2> & otherMatrix, TOverlap overlap0, TOverlap overlap1, NeedlemanWunsch const &);       	// "projects/library/seqan/seeds2/align_dynprog_linear.h"(130)

//____________________________________________________________________________
// _alignLeadingRectangle

template <typename TSequence, typename TScoringScheme, typename TAlignmentTag, typename TSeedSpec, typename TSeedConfig, bool START1_FREE, bool START0_FREE, bool END1_FREE, bool END0_FREE> void _alignLeadingRectangle( AlignmentChain_<TSequence, TScoringScheme, TAlignmentTag> & alignmentChain, Seed<TSeedSpec, TSeedConfig> const & rightSeed, AlignConfig<START1_FREE, START0_FREE, END1_FREE, END0_FREE> const & alignConfig);       	// "projects/library/seqan/seeds2/align_chain_banded.h"(182)

//____________________________________________________________________________
// _alignRectangle

template <typename TSequence, typename TScoringScheme, typename TAlignmentTag, typename TSeedSpec, typename TSeedConfig> void _alignRectangle( AlignmentChain_<TSequence, TScoringScheme, TAlignmentTag> & alignmentChain, Seed<TSeedSpec, TSeedConfig> const & leftSeed, Seed<TSeedSpec, TSeedConfig> const & rightSeed);       	// "projects/library/seqan/seeds2/align_chain_banded.h"(323)

//____________________________________________________________________________
// _alignResizeMatrix

template <typename TScoreValue, typename TSequence> inline void _alignResizeMatrix(Matrix<TScoreValue, 3> & matrix, TSequence const & sequence0, TSequence const & sequence1, Gotoh const &);       	// "projects/library/seqan/seeds2/align_dynprog_affine.h"(65)
template <typename TScoreValue, typename TSequence> inline void _alignResizeMatrix(Matrix<TScoreValue, 2> & matrix, TSequence const & sequence0, TSequence const & sequence1, NeedlemanWunsch const &);       	// "projects/library/seqan/seeds2/align_dynprog_linear.h"(65)

//____________________________________________________________________________
// _alignSeed

template <typename TSequence, typename TScoringScheme, typename TAlignmentTag, typename TSeedSpec, typename TSeedConfig> void _alignSeed( AlignmentChain_<TSequence, TScoringScheme, TAlignmentTag> & alignmentChain, Seed<TSeedSpec, TSeedConfig> const & seed);       	// "projects/library/seqan/seeds2/align_chain_banded.h"(406)

//____________________________________________________________________________
// _alignTraceback

template <typename TAlignmentIterator, typename TSequenceIterator, typename TPosition, typename TScoreValue, typename TScoringScheme, typename TOverlap, bool START0_FREE, bool START1_FREE, bool END0_FREE, bool END1_FREE> TScoreValue _alignTraceback(TAlignmentIterator & alignmentIt0, TAlignmentIterator & alignmentIt1, TSequenceIterator & sourceIt0, TSequenceIterator & sourceIt1, TPosition & finalPos0, TPosition & finalPos1, Matrix<TScoreValue, 3> & matrix, TScoringScheme const & scoringScheme, TOverlap lowerRightOverlap0, TOverlap lowerRightOverlap1, TOverlap upperLeftOverlap0, TOverlap upperLeftOverlap1, bool goToTopLeft, AlignConfig<START1_FREE, START0_FREE, END1_FREE, END0_FREE> const &, Gotoh const &);       	// "projects/library/seqan/seeds2/align_dynprog_affine.h"(314)
template <typename TAlignmentIterator, typename TSequenceIterator, typename TPosition, typename TScoreValue, typename TScoringScheme, typename TOverlap, bool START0_FREE, bool START1_FREE, bool END0_FREE, bool END1_FREE> TScoreValue _alignTraceback(TAlignmentIterator & alignmentIt0, TAlignmentIterator & alignmentIt1, TSequenceIterator & sourceIt0, TSequenceIterator & sourceIt1, TPosition & finalPos0, TPosition & finalPos1, Matrix<TScoreValue, 2> & matrix, TScoringScheme const & scoringScheme, TOverlap lowerRightOverlap0, TOverlap lowerRightOverlap1, TOverlap upperLeftOverlap0, TOverlap upperLeftOverlap1, bool goToTopLeft, AlignConfig<START1_FREE, START0_FREE, END1_FREE, END0_FREE> const &, NeedlemanWunsch const &);       	// "projects/library/seqan/seeds2/align_dynprog_linear.h"(247)

//____________________________________________________________________________
// _alignTrailingRectangle

template <typename TSequence, typename TScoringScheme, typename TAlignmentTag, typename TSeedSpec, typename TSeedConfig> void _alignTrailingRectangle( AlignmentChain_<TSequence, TScoringScheme, TAlignmentTag> & alignmentChain, Seed<TSeedSpec, TSeedConfig> const & leftSeed);       	// "projects/library/seqan/seeds2/align_chain_banded.h"(240)

//____________________________________________________________________________
// _assignScoreMixin

template <typename TSpec, typename TConfig> inline void _assignScoreMixin(Seed<TSpec, TConfig> & , Seed<TSpec, TConfig> const & , False const &);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(552)
template <typename TSpec, typename TConfig> inline void _assignScoreMixin(Seed<TSpec, TConfig> & seed, Seed<TSpec, TConfig> const & other, True const &);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(562)

//____________________________________________________________________________
// _bandedChainAlignment

template <typename TContainer, typename TBandwidth, typename TScoreValue, typename TAlign, bool START1_FREE, bool START0_FREE, bool END1_FREE, bool END0_FREE, typename TGlobalAlignmentTag> TScoreValue _bandedChainAlignment( TAlign & alignment, TContainer const & seedChain, TBandwidth k, Score<TScoreValue, Simple> const & scoringScheme, AlignConfig<START1_FREE, START0_FREE, END1_FREE, END0_FREE> const & alignConfig, TGlobalAlignmentTag const &);       	// "projects/library/seqan/seeds2/align_chain_banded.h"(709)

//____________________________________________________________________________
// _calcExtendedLowerDiag

template <typename TDiagonal, typename TSize> inline void _calcExtendedLowerDiag(TDiagonal & lowerDiag, TSize minCol, TSize antiDiagNo);       	// "projects/library/seqan/seeds2/seeds_extension.h"(437)

//____________________________________________________________________________
// _calcExtendedUpperDiag

template <typename TDiagonal, typename TSize> inline void _calcExtendedUpperDiag(TDiagonal & upperDiag, TSize maxCol, TSize antiDiagNo);       	// "projects/library/seqan/seeds2/seeds_extension.h"(449)

//____________________________________________________________________________
// _combineSeeds

template <typename TSeedConfig, typename TScoreValue> inline void _combineSeeds(Seed<Simple, TSeedConfig> & seed, Seed<Simple, TSeedConfig> const & other, Score<TScoreValue, Simple> const & , Nothing const & , Nothing const & , Merge const &);       	// "projects/library/seqan/seeds2/seeds_combination.h"(197)
template <typename TSeedConfig, typename TScoreValue> inline void _combineSeeds(Seed<Simple, TSeedConfig> & seed, Seed<Simple, TSeedConfig> const & other, Score<TScoreValue, Simple> const & scoringScheme, Nothing const & , Nothing const & , SimpleChain const &);       	// "projects/library/seqan/seeds2/seeds_combination.h"(213)
template <typename TSeedConfig, typename TScoreValue, typename TSequence0, typename TSequence1> inline void _combineSeeds(Seed<Simple, TSeedConfig> & seed, Seed<Simple, TSeedConfig> const & other, Score<TScoreValue, Simple> const & scoringScheme, TSequence0 const & sequence0, TSequence1 const & sequence1, Chaos const &);       	// "projects/library/seqan/seeds2/seeds_combination.h"(232)
template <typename TSeedConfig, typename TScoreValue> inline void _combineSeeds(Seed<ChainedSeed, TSeedConfig> & seed, Seed<ChainedSeed, TSeedConfig> const & other, Score<TScoreValue, Simple> const & , Nothing const & , Nothing const & , Merge const &);       	// "projects/library/seqan/seeds2/seeds_combination.h"(304)
template <typename TSeedConfig, typename TScoreValue> inline void _combineSeeds(Seed<ChainedSeed, TSeedConfig> & seed, Seed<ChainedSeed, TSeedConfig> const & other, Score<TScoreValue, Simple> const & scoringScheme, Nothing const & , Nothing const & , SimpleChain const &);       	// "projects/library/seqan/seeds2/seeds_combination.h"(366)
template <typename TSeedConfig, typename TScoreValue, typename TSequence0, typename TSequence1> inline void _combineSeeds(Seed<ChainedSeed, TSeedConfig> & seed, Seed<ChainedSeed, TSeedConfig> const & other, Score<TScoreValue, Simple> const & scoringScheme, TSequence0 const & sequence0, TSequence1 const & sequence1, Chaos const &);       	// "projects/library/seqan/seeds2/seeds_combination.h"(389)

//____________________________________________________________________________
// _computeLowerRightOverlap

template <typename TSize, typename TSequence, typename TScoringScheme, typename TSeedSpec, typename TSeedConfig, typename TAlignmentTag> inline void _computeLowerRightOverlap(TSize & overlap0, TSize & overlap1, Seed<TSeedSpec, TSeedConfig> const & seed, AlignmentChain_<TSequence, TScoringScheme, TAlignmentTag> const & alignmentChain);       	// "projects/library/seqan/seeds2/align_chain_banded.h"(145)

//____________________________________________________________________________
// _computeUpperLeftOverlap

template <typename TSize, typename TSequence, typename TScoringScheme, typename TSeedSpec, typename TSeedConfig, typename TAlignmentTag> inline void _computeUpperLeftOverlap(TSize & overlap0, TSize & overlap1, Seed<TSeedSpec, TSeedConfig> const & seed, AlignmentChain_<TSequence, TScoringScheme, TAlignmentTag> const & alignmentChain);       	// "projects/library/seqan/seeds2/align_chain_banded.h"(164)

//____________________________________________________________________________
// _extendSeedGappedXDropOneDirection

template <typename TConfig, typename TQuerySegment, typename TDatabaseSegment, typename TScoreValue> TScoreValue _extendSeedGappedXDropOneDirection( Seed<Simple, TConfig> & seed, TQuerySegment const & querySeg, TDatabaseSegment const & databaseSeg, ExtensionDirection direction, Score<TScoreValue, Simple> const & scoringScheme, TScoreValue scoreDropOff);       	// "projects/library/seqan/seeds2/seeds_extension.h"(504)

//____________________________________________________________________________
// _findSeedForCombination

template <typename TSeedSpec, typename TSeedSetConfig, typename TDistanceThreshold, typename TBandwidth, typename TCombination> bool _findSeedForCombination( typename Iterator<typename SeedSet<TSeedSpec, Unordered, TSeedSetConfig>::TAllSeeds, Standard>::Type & mergePartner, bool & seedIsOnTheLeft, SeedSet<TSeedSpec, Unordered, TSeedSetConfig> & seedSet, typename Value<SeedSet<TSeedSpec, Unordered, TSeedSetConfig> >::Type const & seed, TDistanceThreshold const & maxDistance, TBandwidth const & bandwidth, TCombination const & tag);       	// "projects/library/seqan/seeds2/seeds_seed_set_unordered.h"(276)

//____________________________________________________________________________
// _glueAlignmentChain

template <typename TAlignment, typename TSequence, typename TScoringScheme, typename TAlignmentTag, typename TSeedChain, bool START1_FREE, bool START0_FREE, bool END1_FREE, bool END0_FREE> typename Value<typename ScoringScheme<Alignment<TSequence, TScoringScheme, TAlignmentTag> >::Type >::Type _glueAlignmentChain( TAlignment & alignment, AlignmentChain_<TSequence, TScoringScheme, TAlignmentTag> const & alignmentChain, TSeedChain const & seedChain, AlignConfig<START1_FREE, START0_FREE, END1_FREE, END0_FREE> const & alignConfig);       	// "projects/library/seqan/seeds2/align_chain_banded.h"(501)

//____________________________________________________________________________
// _initAntiDiag3

template <typename TAntiDiag, typename TSize, typename TScoreValue> inline TSize _initAntiDiag3(TAntiDiag & antiDiag3, TSize offset, TSize maxCol, TSize antiDiagNo, TScoreValue minScore, TScoreValue gapCost, TScoreValue undefined);       	// "projects/library/seqan/seeds2/seeds_extension.h"(413)

//____________________________________________________________________________
// _initAntiDiags

template <typename TAntiDiag, typename TDropOff, typename TScoreValue> inline void _initAntiDiags(TAntiDiag & , TAntiDiag & antiDiag2, TAntiDiag & antiDiag3, TDropOff dropOff, TScoreValue gapCost, TScoreValue undefined);       	// "projects/library/seqan/seeds2/seeds_extension.h"(374)

//____________________________________________________________________________
// _qualityReached

template <typename TSeed, typename TSeedSet> bool _qualityReached(TSeed const & , TSeedSet const & , Nothing const &);       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(67)
template <typename TSeed, typename TSeedSet> bool _qualityReached(TSeed const & seed, TSeedSet const & seedSet, MinSeedSize const &);       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(96)
template <typename TSeed, typename TSeedSet> bool _qualityReached(TSeed const & seed, TSeedSet const & seedSet, MinScore const &);       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(132)

//____________________________________________________________________________
// _seedsCombineable

template <typename TSeedSpec, typename TSeedConfig, typename TThreshold> inline bool _seedsCombineable(Seed<TSeedSpec, TSeedConfig> const & a, Seed<TSeedSpec, TSeedConfig> const & b, TThreshold const & maxDiagonalDistance, Nothing const & , Merge const &);       	// "projects/library/seqan/seeds2/seeds_combination.h"(90)
template <typename TSeedSpec, typename TSeedConfig, typename TThreshold> inline bool _seedsCombineable(Seed<TSeedSpec, TSeedConfig> const & a, Seed<TSeedSpec, TSeedConfig> const & b, TThreshold const & maxGapSize, Nothing const & , SimpleChain const &);       	// "projects/library/seqan/seeds2/seeds_combination.h"(119)
template <typename TSeedSpec, typename TSeedConfig, typename TDistanceThreshold, typename TBandwidthThreshold> inline bool _seedsCombineable(Seed<TSeedSpec, TSeedConfig> const & a, Seed<TSeedSpec, TSeedConfig> const & b, TDistanceThreshold const & maxGapSize, TBandwidthThreshold const & bandwidth, Chaos const &);       	// "projects/library/seqan/seeds2/seeds_combination.h"(148)

//____________________________________________________________________________
// _swapAntiDiags

template <typename TAntiDiag> inline void _swapAntiDiags(TAntiDiag & antiDiag1, TAntiDiag & antiDiag2, TAntiDiag & antiDiag3);       	// "projects/library/seqan/seeds2/seeds_extension.h"(396)

//____________________________________________________________________________
// _updateExtendedSeed

template <typename TSeed, typename TSize, typename TDiagonal> inline void _updateExtendedSeed(TSeed & seed, ExtensionDirection direction, TSize cols, TSize rows, TDiagonal lowerDiag, TDiagonal upperDiag);       	// "projects/library/seqan/seeds2/seeds_extension.h"(464)

//____________________________________________________________________________
// _updateSeedsCoordinatesMergeOrSimpleChain

template <typename TSeedConfig> inline void _updateSeedsCoordinatesMergeOrSimpleChain( Seed<Simple, TSeedConfig> & seed, Seed<Simple, TSeedConfig> const & other);       	// "projects/library/seqan/seeds2/seeds_combination.h"(177)

//____________________________________________________________________________
// _updateSeedsScoreChaos

template <typename TSpec, typename TConfig, typename TScoreValue> inline void _updateSeedsScoreChaos(Seed<TSpec, TConfig> & seed, Seed<TSpec, TConfig> const & other, TScoreValue const & scoreDelta);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(523)

//____________________________________________________________________________
// _updateSeedsScoreChaosHelper

template <typename TSpec, typename TConfig, typename TScoreValue> inline void _updateSeedsScoreChaosHelper(Seed<TSpec, TConfig> & , Seed<TSpec, TConfig> const & , TScoreValue const & , False const &);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(504)
template <typename TSpec, typename TConfig, typename TScoreValue> inline void _updateSeedsScoreChaosHelper(Seed<TSpec, TConfig> & seed, Seed<TSpec, TConfig> const & other, TScoreValue const & scoreDelta, True const &);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(513)

//____________________________________________________________________________
// _updateSeedsScoreMerge

template <typename TSpec, typename TConfig> inline void _updateSeedsScoreMerge(Seed<TSpec, TConfig> & seed, Seed<TSpec, TConfig> const & other);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(439)

//____________________________________________________________________________
// _updateSeedsScoreMergeHelper

template <typename TSpec, typename TConfig> inline void _updateSeedsScoreMergeHelper(Seed<TSpec, TConfig> & , Seed<TSpec, TConfig> const & , False const &);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(394)
template <typename TSpec, typename TConfig> inline void _updateSeedsScoreMergeHelper(Seed<TSpec, TConfig> & seed, Seed<TSpec, TConfig> const & other, True const &);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(405)

//____________________________________________________________________________
// _updateSeedsScoreSimpleChain

template <typename TSpec, typename TConfig, typename TScoreValue> inline void _updateSeedsScoreSimpleChain(Seed<TSpec, TConfig> & seed, Seed<TSpec, TConfig> const & other, Score<TScoreValue, Simple> const & scoringScheme);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(493)

//____________________________________________________________________________
// _updateSeedsScoreSimpleChainHelper

template <typename TSpec, typename TConfig, typename TScoreValue> inline void _updateSeedsScoreSimpleChainHelper(Seed<TSpec, TConfig> & , Seed<TSpec, TConfig> const & , Score<TScoreValue, Simple> const & , False const &);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(449)
template <typename TSpec, typename TConfig, typename TScoreValue> inline void _updateSeedsScoreSimpleChainHelper(Seed<TSpec, TConfig> & seed, Seed<TSpec, TConfig> const & other, Score<TScoreValue, Simple> const & scoringScheme, True const &);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(458)

//____________________________________________________________________________
// _write

template <typename TStream, typename TQuerySequence, typename TDatabaseSequence, typename TSeedSetSpec, typename TSeedSpec, typename TSeedConfig> inline void _write(TStream & stream, TQuerySequence & sequence0, TDatabaseSequence & sequence1, SeedSet<TSeedSpec, TSeedSetSpec, TSeedConfig> const & seedSet, Tikz_ const &);       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(255)
template <typename TStream, typename TConfig> inline void _write(TStream & stream, Seed<Simple, TConfig> const & seed, Tikz_ const &);       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(322)
template <typename TStream, typename TConfig> inline void _write(TStream & stream, Seed<ChainedSeed, TConfig> const & seed, Tikz_ const &);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(407)

//____________________________________________________________________________
// addSeed

template <typename TSeedSpec, typename TSeedSetConfig, typename TDistanceThreshold, typename TBandwidth, typename TScoreValue, typename TSequence0, typename TSequence1, typename TCombination> inline bool addSeed(SeedSet<TSeedSpec, Unordered, TSeedSetConfig> & seedSet, typename Value<SeedSet<TSeedSpec, Unordered, TSeedSetConfig> >::Type const & seed, TDistanceThreshold const & maxDiagDist, TBandwidth const & bandwidth, Score<TScoreValue, Simple> const & scoringScheme, TSequence0 const & sequence0, TSequence1 const & sequence1, TCombination const & tag);       	// "projects/library/seqan/seeds2/seeds_seed_set_unordered.h"(319)
template <typename TSeedSpec, typename TSeedSetConfig> inline void addSeed(SeedSet<TSeedSpec, Unordered, TSeedSetConfig> & seedSet, typename Value<SeedSet<TSeedSpec, Unordered, TSeedSetConfig> >::Type const & seed, Single const &);       	// "projects/library/seqan/seeds2/seeds_seed_set_unordered.h"(361)

//____________________________________________________________________________
// appendDiagonal

template <typename TConfig> inline void appendDiagonal(Seed<ChainedSeed, TConfig> & seed, typename Value<Seed<ChainedSeed, TConfig> >::Type const & diagonal);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(258)

//____________________________________________________________________________
// assign

template <typename TConfig> void assign(Seed<Simple, TConfig> & target, Seed<Simple, TConfig> const & source);       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(295)
template <typename TConfig> void assign(Seed<Simple, TConfig> & target, Seed<Simple, TConfig> & source);       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(309)
template <typename TConfig> void assign(Seed<ChainedSeed, TConfig> & target, Seed<ChainedSeed, TConfig> const & source);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(385)
template <typename TConfig> void assign(Seed<ChainedSeed, TConfig> & target, Seed<ChainedSeed, TConfig> & source);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(396)

//____________________________________________________________________________
// back

template <typename TSeedSpec, typename TSeedSetConfig> inline typename Value<SeedSet<TSeedSpec, Unordered, TSeedSetConfig> >::Type back(SeedSet<TSeedSpec, Unordered, TSeedSetConfig> & seedSet);       	// "projects/library/seqan/seeds2/seeds_seed_set_unordered.h"(247)
template <typename TSeedSpec, typename TSeedSetConfig> inline typename Value<SeedSet<TSeedSpec, Unordered, TSeedSetConfig> const>::Type back(SeedSet<TSeedSpec, Unordered, TSeedSetConfig> const & seedSet);       	// "projects/library/seqan/seeds2/seeds_seed_set_unordered.h"(256)
template <typename TConfig> inline typename Reference<Seed<ChainedSeed, TConfig> >::Type back(Seed<ChainedSeed, TConfig> & seed);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(336)
template <typename TConfig> inline typename Reference<Seed<ChainedSeed, TConfig> const>::Type back(Seed<ChainedSeed, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(344)

//____________________________________________________________________________
// bandedChainAlignment

template <typename TContainer, typename TValue, typename TScoreValue, typename TAlign, bool START1_FREE, bool START0_FREE, bool END1_FREE, bool END0_FREE> TScoreValue bandedChainAlignment(TAlign & alignment, TContainer const & seedChain, TValue k, Score<TScoreValue, Simple> const & scoringScheme, AlignConfig<START1_FREE, START0_FREE, END1_FREE, END0_FREE> const & alignConfig);       	// "projects/library/seqan/seeds2/align_chain_banded.h"(817)

//____________________________________________________________________________
// begin

template <typename TSeedSpec, typename TSeedSetConfig> inline typename Iterator<SeedSet<TSeedSpec, Unordered, TSeedSetConfig> >::Type begin(SeedSet<TSeedSpec, Unordered, TSeedSetConfig> & seedSet, Standard const &);       	// "projects/library/seqan/seeds2/seeds_seed_set_unordered.h"(189)
template <typename TSeedSpec, typename TSeedSetConfig> inline typename Iterator<SeedSet<TSeedSpec, Unordered, TSeedSetConfig> const>::Type begin(SeedSet<TSeedSpec, Unordered, TSeedSetConfig> const & seedSet, Standard const &);       	// "projects/library/seqan/seeds2/seeds_seed_set_unordered.h"(199)
template <typename TConfig> inline typename Iterator<Seed<ChainedSeed, TConfig> >::Type begin(Seed<ChainedSeed, TConfig> & seed, Standard const &);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(296)
template <typename TConfig> inline typename Iterator<Seed<ChainedSeed, TConfig> const>::Type begin(Seed<ChainedSeed, TConfig> const & seed, Standard const &);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(304)

//____________________________________________________________________________
// chainSeedsGlobally

template <typename TTargetContainer, typename TSeedSpec, typename TSeedSetSpec, typename TSeedConfig> void chainSeedsGlobally( TTargetContainer & target, SeedSet<TSeedSpec, TSeedSetSpec, TSeedConfig> const & seedSet, SparseChaining const &);       	// "projects/library/seqan/seeds2/seeds_global_chaining.h"(79)

//____________________________________________________________________________
// end

template <typename TSeedSpec, typename TSeedSetConfig> inline typename Iterator<SeedSet<TSeedSpec, Unordered, TSeedSetConfig> >::Type end(SeedSet<TSeedSpec, Unordered, TSeedSetConfig> & seedSet, Standard const &);       	// "projects/library/seqan/seeds2/seeds_seed_set_unordered.h"(209)
template <typename TSeedSpec, typename TSeedSetConfig> inline typename Iterator<SeedSet<TSeedSpec, Unordered, TSeedSetConfig> const>::Type end(SeedSet<TSeedSpec, Unordered, TSeedSetConfig> const & seedSet, Standard const &);       	// "projects/library/seqan/seeds2/seeds_seed_set_unordered.h"(219)
template <typename TConfig> inline typename Iterator<Seed<ChainedSeed, TConfig> >::Type end(Seed<ChainedSeed, TConfig> & seed, Standard const &);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(356)
template <typename TConfig> inline typename Iterator<Seed<ChainedSeed, TConfig> const>::Type end(Seed<ChainedSeed, TConfig> const & seed, Standard const &);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(364)

//____________________________________________________________________________
// extendSeed

template <typename TConfig, typename TQuery, typename TDatabase> inline void extendSeed(Seed<Simple, TConfig> & seed, TQuery const & query, TDatabase const & database, ExtensionDirection direction, MatchExtend const &);       	// "projects/library/seqan/seeds2/seeds_extension.h"(131)
template <typename TConfig, typename TQuery, typename TDatabase> inline void extendSeed(Seed<ChainedSeed, TConfig> & seed, TQuery const & query, TDatabase const & database, ExtensionDirection direction, MatchExtend const &);       	// "projects/library/seqan/seeds2/seeds_extension.h"(175)
template <typename TConfig, typename TQuery, typename TDatabase, typename TScoreValue, typename TScoreSpec> inline void extendSeed(Seed<Simple, TConfig> & seed, TQuery const & query, TDatabase const & database, ExtensionDirection direction, Score<TScoreValue, TScoreSpec> const & scoringScheme, TScoreValue scoreDropOff, UnGappedXDrop const &);       	// "projects/library/seqan/seeds2/seeds_extension.h"(230)
template <typename TConfig, typename TQuery, typename TDatabase, typename TScoreValue, typename TScoreSpec> inline void extendSeed(Seed<ChainedSeed, TConfig> & seed, TQuery const & query, TDatabase const & database, ExtensionDirection direction, Score<TScoreValue, TScoreSpec> const & scoringScheme, TScoreValue scoreDropOff, UnGappedXDrop const &);       	// "projects/library/seqan/seeds2/seeds_extension.h"(300)
template <typename TConfig, typename TQuery, typename TDatabase, typename TScoreValue> inline void extendSeed(Seed<Simple, TConfig> & seed, TQuery const & query, TDatabase const & database, ExtensionDirection direction, Score<TScoreValue, Simple> const & scoringScheme, TScoreValue scoreDropOff, GappedXDrop const &);       	// "projects/library/seqan/seeds2/seeds_extension.h"(649)
template <typename TConfig, typename TQuery, typename TDatabase, typename TScoreValue> inline void extendSeed(Seed<ChainedSeed, TConfig> & , TQuery const & , TDatabase const & , ExtensionDirection , Score<TScoreValue, Simple> const & , TScoreValue , GappedXDrop const &);       	// "projects/library/seqan/seeds2/seeds_extension.h"(707)

//____________________________________________________________________________
// front

template <typename TSeedSpec, typename TSeedSetConfig> inline typename Value<SeedSet<TSeedSpec, Unordered, TSeedSetConfig> >::Type front(SeedSet<TSeedSpec, Unordered, TSeedSetConfig> & seedSet);       	// "projects/library/seqan/seeds2/seeds_seed_set_unordered.h"(229)
template <typename TSeedSpec, typename TSeedSetConfig> inline typename Value<SeedSet<TSeedSpec, Unordered, TSeedSetConfig> const>::Type front(SeedSet<TSeedSpec, Unordered, TSeedSetConfig> const & seedSet);       	// "projects/library/seqan/seeds2/seeds_seed_set_unordered.h"(238)
template <typename TConfig> inline typename Reference<Seed<ChainedSeed, TConfig> >::Type front(Seed<ChainedSeed, TConfig> & seed);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(316)
template <typename TConfig> inline typename Reference<Seed<ChainedSeed, TConfig> const>::Type front(Seed<ChainedSeed, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(324)

//____________________________________________________________________________
// getBeginDim0

template <typename TConfig> inline typename Position<Seed<Simple, TConfig> >::Type getBeginDim0(Seed<Simple, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(171)
template <typename TConfig> inline typename Position<Seed<ChainedSeed, TConfig> >::Type getBeginDim0(Seed<ChainedSeed, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(201)

//____________________________________________________________________________
// getBeginDim1

template <typename TConfig> inline typename Position<Seed<Simple, TConfig> >::Type getBeginDim1(Seed<Simple, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(206)
template <typename TConfig> inline typename Position<Seed<ChainedSeed, TConfig> >::Type getBeginDim1(Seed<ChainedSeed, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(217)

//____________________________________________________________________________
// getEndDiagonal

template <typename TSpec, typename TConfig> inline typename Diagonal<Seed<TSpec, TConfig> >::Type getEndDiagonal(Seed<TSpec, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(383)

//____________________________________________________________________________
// getEndDim0

template <typename TConfig> inline typename Position<Seed<Simple, TConfig> >::Type getEndDim0(Seed<Simple, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(198)
template <typename TConfig> inline typename Position<Seed<ChainedSeed, TConfig> >::Type getEndDim0(Seed<ChainedSeed, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(209)

//____________________________________________________________________________
// getEndDim1

template <typename TConfig> inline typename Position<Seed<Simple, TConfig> >::Type getEndDim1(Seed<Simple, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(233)
template <typename TConfig> inline typename Position<Seed<ChainedSeed, TConfig> >::Type getEndDim1(Seed<ChainedSeed, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(225)

//____________________________________________________________________________
// getLowerDiagonal

template <typename TSpec, typename TConfig> inline typename Diagonal<Seed<TSpec, TConfig> >::Type getLowerDiagonal(Seed<TSpec, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(261)

//____________________________________________________________________________
// getMinScoreThreshold

template <typename TScore> TScore getMinScoreThreshold(MinScoreMixin_<TScore> const & mixin);       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(124)

//____________________________________________________________________________
// getMinSeedSizeThreshold

template <typename TSize> TSize getMinSeedSizeThreshold(MinSeedSizeMixin_<TSize> const & mixin);       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(89)

//____________________________________________________________________________
// getScore

template <typename TSeed> inline typename SeedScore<TSeed>::Type getScore(TSeed const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(533)

//____________________________________________________________________________
// getSeedSize

template <typename TSpec, typename TConfig> inline typename Size<Seed<TSpec, TConfig> >::Type getSeedSize(Seed<TSpec, TConfig> & seed);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(332)
template <typename TSpec, typename TConfig> inline typename Size<Seed<TSpec, TConfig> >::Type getSeedSize(Seed<TSpec, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(342)

//____________________________________________________________________________
// getStartDiagonal

template <typename TSpec, typename TConfig> inline typename Diagonal<Seed<TSpec, TConfig> >::Type getStartDiagonal(Seed<TSpec, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(365)

//____________________________________________________________________________
// getUpperDiagonal

template <typename TSpec, typename TConfig> inline typename Diagonal<Seed<TSpec, TConfig> >::Type getUpperDiagonal(Seed<TSpec, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(298)

//____________________________________________________________________________
// length

template <typename TSeedSpec, typename TSeedSetConfig> inline typename Size<SeedSet<TSeedSpec, Unordered, TSeedSetConfig> >::Type length(SeedSet<TSeedSpec, Unordered, TSeedSetConfig> & seedSet);       	// "projects/library/seqan/seeds2/seeds_seed_set_unordered.h"(171)
template <typename TSeedSpec, typename TSeedSetConfig> inline typename Size<SeedSet<TSeedSpec, Unordered, TSeedSetConfig> const>::Type length(SeedSet<TSeedSpec, Unordered, TSeedSetConfig> const & seedSet);       	// "projects/library/seqan/seeds2/seeds_seed_set_unordered.h"(180)
template <typename TConfig> inline typename Size<Seed<ChainedSeed, TConfig> >::Type length(Seed<ChainedSeed, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(237)

//____________________________________________________________________________
// move

template <typename TConfig> void move(Seed<Simple, TConfig> & target, Seed<Simple, TConfig> & source);       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(281)
template <typename TConfig> void move(Seed<ChainedSeed, TConfig> & target, Seed<ChainedSeed, TConfig> & source);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(374)

//____________________________________________________________________________
// operator!=

template <typename TContainer, typename TWrappedIter> inline bool operator!=(Iter<TContainer, Indirect<TWrappedIter> > const & a, Iter<TContainer, Indirect<TWrappedIter> > const & b);       	// "projects/library/seqan/seeds2/basic_iter_indirect.h"(97)

//____________________________________________________________________________
// operator*

template <typename TContainer, typename TWrappedIter> inline typename Value<TWrappedIter>::Type & operator*(Iter<TContainer, Indirect<TWrappedIter> > & iter);       	// "projects/library/seqan/seeds2/basic_iter_indirect.h"(137)
template <typename TContainer, typename TWrappedIter> inline typename Value<TWrappedIter>::Type & operator*(Iter<TContainer, Indirect<TWrappedIter> > const & iter);       	// "projects/library/seqan/seeds2/basic_iter_indirect.h"(146)

//____________________________________________________________________________
// operator+

template <typename TContainer, typename TWrappedIter, typename TDiff> Iter<TContainer, Indirect<TWrappedIter> > operator+(Iter<TContainer, Indirect<TWrappedIter> > const & it, TDiff const diff);       	// "projects/library/seqan/seeds2/basic_iter_indirect.h"(105)

//____________________________________________________________________________
// operator++

template <typename TContainer, typename TWrappedIter> inline Iter<TContainer, Indirect<TWrappedIter> > & operator++(Iter<TContainer, Indirect<TWrappedIter> > & iter);       	// "projects/library/seqan/seeds2/basic_iter_indirect.h"(115)
template <typename TContainer, typename TWrappedIter> inline Iter<TContainer, Indirect<TWrappedIter> > operator++(Iter<TContainer, Indirect<TWrappedIter> > & iter, int );       	// "projects/library/seqan/seeds2/basic_iter_indirect.h"(125)

//____________________________________________________________________________
// operator<<

template <typename TStream, typename TPosition, typename TSize> inline TStream & operator<<(TStream & stream, SeedDiagonal<TPosition, TSize> const & seedDiagonal);       	// "projects/library/seqan/seeds2/seeds_seed_diagonal.h"(115)
template <typename TStream, typename TConfig> inline TStream & operator<<(TStream & stream, Seed<Simple, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(148)
template <typename TStream, typename TConfig> inline TStream & operator<<(TStream & stream, Seed<ChainedSeed, TConfig> const & seed);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(174)

//____________________________________________________________________________
// operator==

template <typename TPosition, typename TSize> inline bool operator==(SeedDiagonal<TPosition, TSize> const & a, SeedDiagonal<TPosition, TSize> const & b);       	// "projects/library/seqan/seeds2/seeds_seed_diagonal.h"(123)
template <typename TConfig> inline bool operator==(Seed<Simple, TConfig> const & a, Seed<Simple, TConfig> const & b);       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(158)
template <typename TContainer, typename TWrappedIter> inline bool operator==(Iter<TContainer, Indirect<TWrappedIter> > const & a, Iter<TContainer, Indirect<TWrappedIter> > const & b);       	// "projects/library/seqan/seeds2/basic_iter_indirect.h"(88)
template <typename TConfig> inline bool operator==(Seed<ChainedSeed, TConfig> const & a, Seed<ChainedSeed, TConfig> const & b);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(191)

//____________________________________________________________________________
// setBeginDim0

template <typename TConfig, typename TPosition> inline void setBeginDim0(Seed<Simple, TConfig> & seed, TPosition newLeftPosition);       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(190)

//____________________________________________________________________________
// setBeginDim1

template <typename TConfig, typename TPosition> inline void setBeginDim1(Seed<Simple, TConfig> & seed, TPosition newLeftPosition);       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(225)

//____________________________________________________________________________
// setEndDim0

template <typename TConfig, typename TPosition> inline void setEndDim0(Seed<Simple, TConfig> & seed, TPosition newRightPosition);       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(252)

//____________________________________________________________________________
// setEndDim1

template <typename TConfig, typename TPosition> inline void setEndDim1(Seed<Simple, TConfig> & seed, TPosition newRightPosition);       	// "projects/library/seqan/seeds2/seeds_seed_simple.h"(271)

//____________________________________________________________________________
// setLowerDiagonal

template <typename TSpec, typename TConfig, typename TPosition> inline void setLowerDiagonal(Seed<TSpec, TConfig> & seed, TPosition newDiag);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(280)

//____________________________________________________________________________
// setMinScoreThreshold

template <typename TSeedSet, typename TScore> void setMinScoreThreshold(TSeedSet & seedSet, TScore const & score);       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(117)

//____________________________________________________________________________
// setMinSeedSizeThreshold

template <typename TSeedSet, typename TSize> void setMinSeedSizeThreshold(TSeedSet & seedSet, TSize const & size);       	// "projects/library/seqan/seeds2/seeds_seed_set_base.h"(82)

//____________________________________________________________________________
// setScore

template <typename TSeed, typename TScore> inline void setScore(TSeed & seed, TScore const & score);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(542)

//____________________________________________________________________________
// setUpperDiagonal

template <typename TSpec, typename TConfig, typename TPosition> inline void setUpperDiagonal(Seed<TSpec, TConfig> & seed, TPosition newDiag);       	// "projects/library/seqan/seeds2/seeds_seed_base.h"(317)

//____________________________________________________________________________
// truncateDiagonals

template <typename TConfig> inline void truncateDiagonals(Seed<ChainedSeed, TConfig> & seed, typename Iterator<Seed<ChainedSeed, TConfig> >::Type const & first);       	// "projects/library/seqan/seeds2/seeds_seed_chained.h"(283)

//____________________________________________________________________________
// value

template <typename TContainer, typename TWrappedIter> inline typename Reference<Iter<TContainer, Indirect<TWrappedIter> > >::Type value(Iter<TContainer, Indirect<TWrappedIter> > & iter);       	// "projects/library/seqan/seeds2/basic_iter_indirect.h"(155)
template <typename TContainer, typename TWrappedIter> inline typename Reference<Iter<TContainer, Indirect<TWrappedIter> > >::Type value(Iter<TContainer, Indirect<TWrappedIter> > const & iter);       	// "projects/library/seqan/seeds2/basic_iter_indirect.h"(164)

//____________________________________________________________________________
// write

template <typename TStream, typename TAlignment, typename TAlignmentChain, typename TSeedChain> void write(TStream & stream, TAlignment const & alignment, TAlignmentChain const & alignmentChain, TSeedChain const & seedChain, Tikz_ const &);       	// "projects/library/seqan/seeds2/align_chain_banded.h"(613)

} //namespace seqan

#endif

