#!/bin/sh
[ -z "$1" -o ! -f "$1" ] && echo "No schema given or schema does not exist." && exit 1
schema="$1"
# variant 1 (like phpbb)
for s in $(sed -n 's/^CREATE SEQUENCE \(.\+\);/\1/ p' < $schema); do
	for c in $(grep $s $schema | grep nextval | awk '{print $1}'); do
		echo "ALTER SEQUENCE $s MINVALUE 1;"
		echo "SELECT setval('$s', (SELECT MAX($c) FROM ${s%_seq})+1, false);"
	done
done
# variant 2 (like s9y)
for line in $(sed -n 's/create table \(\w\+\).*[(,]\s*\(\w\+\)\s*SERIAL.*/\1*\2/ip' < $schema); do
    tab=$(echo $line | cut -d* -f1)
    col=$(echo $line | cut -d* -f2)
    echo "SELECT setval('${tab}_${col}_seq', (SELECT MAX($col) FROM $tab)+1, false);"
done