#include <ctype.h>

/* soundex routine is sto^H^H^Hborrowed from python soundexmodule.c */
void soundex_hash(char *str, char *result, int len)
{
    char *sptr = str;		/* pointer into str */
    char *rptr = result;	/* pointer into result */

    if (*str == '\0') {
        memset(result, '0', len);
        result[len+1] = '\0';
	return;
    }
    /*  Preserve the first character of the input string.
     */
    *(rptr++) = toupper(*(sptr++));

    /* Translate the rest of the input string into result.  The following
       transformations are used:

       1) All vowels, W, and H, are skipped.

       2) BFPV = 1
       CGJKQSXZ = 2
       DT = 3
       L = 4
       MN = 5
       R = 6

       3) Only translate the first of adjacent equal translations.  I.E.
       remove duplicate digits.
     */

    for (; (rptr - result) < len && *sptr != '\0'; sptr++) {
	switch (toupper(*sptr)) {
	case 'W':
	case 'H':
	case 'A':
	case 'I':
	case 'O':
	case 'U':
	case 'Y':
	    break;
	case 'B':
	case 'F':
	case 'P':
	case 'V':
	    if (*(rptr - 1) != '1')
		*(rptr++) = '1';
	    break;
	case 'C':
	case 'G':
	case 'J':
	case 'K':
	case 'Q':
	case 'S':
	case 'X':
	case 'Z':
	    if (*(rptr - 1) != '2')
		*(rptr++) = '2';
	    break;
	case 'D':
	case 'T':
	    if (*(rptr - 1) != '3')
		*(rptr++) = '3';
	    break;
	case 'L':
	    if (*(rptr - 1) != '4')
		*(rptr++) = '4';
	    break;
	case 'M':
	case 'N':
	    if (*(rptr - 1) != '5')
		*(rptr++) = '5';
	    break;
	case 'R':
	    if (*(rptr - 1) != '6')
		*(rptr++) = '6';
	default:
	    break;
	}
    }

    /* Pad 0's on right side of string out to len characters.
     */
    for (; rptr < result + len; rptr++)
	*rptr = '0';

    /* Terminate the result string.
     */
    *(result + len) = '\0';
}
