#!/usr/bin/python

# convert ding-like dictionary into .tei format
# dictionary consists of lines, each line is one entry and looks like this:
#   first : second
# where first is a word in first language, second is translation
# : is separator, can be changed below (sep)
# there can be more words as entries:
#   first : second1, second2, second3
# separated by , (see sep1 below)

sep = " :: "
sep1 = ", " # set this to some nonsense if you have one phrase per line

import sys, string

f = open(sys.argv[1], "r")

pos = 0
lastlinepos = 0

inword = 0
word = ""


def teiheader():
    print """<!DOCTYPE TEI.2       PUBLIC "-//TEI P3//DTD Main Document Type//EN"  [
   <!ENTITY % TEI.dictionaries "INCLUDE" >
]>

<tei.2>
  <teiHeader>
    <filedesc>
      <titlestmt>
        <title>           </title>
      </titlestmt>
      <publicationstmt>
        <authority>Freedict.de</authority>
      </publicationstmt>
      <sourcedesc>
        <p>http://www.freedict.de</p>
      </sourcedesc>
    </filedesc>
  </teiHeader>
"""    

words = {}

block = ""

teiheader()
print "<text>"
print "<body>"

while 1:
    #i = readblock(f) # or f.readline
    i = f.readline()
    if not i:
        break
    endpos = pos+len(i)
    i = string.replace(i, '\n', '')
    spl = string.split(i, sep)
    one, two = spl[:2]
    if len(spl)==3:
        clen="[%s]" % spl[2]
    else:
        clen=""
    # uncomment this line to change order of languages
    one, two = two, one
    if clen:
        two = clen+" "+two
    two = [two] # or:
    #two = string.split(two, sep1)
    
    if words.has_key(one):
        words[one].extend(two)
    else:
        words[one] = two

for i, j in words.items():
    print "<entry>"
    print "  <form>"
    for k in string.split(i, sep1):
        print "    <orth>"+k+"</orth>"
    print "  </form>"
    print "  <trans>"
    for k in j:
        print "    <tr>"+k+"</tr>"
    print "  </trans>"
    print "</entry>"

print "</body>"
print "</text>"

print "</tei.2>"
