#
# Copyright (C) 2006 Red Hat, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#

import gettext
_ = gettext.translation('setroubleshoot-plugins', '/usr/share/locale', fallback=True).lgettext

from setroubleshoot.util import *
from setroubleshoot.Plugin import Plugin
import re


class plugin(Plugin):
    summary =_('''
    SELinux is preventing the $SOURCE from using potentially mislabeled files ($TARGET_PATH).
    ''')

    problem_description = _('''
    SELinux has denied $SOURCE access to potentially
    mislabeled file(s) ($TARGET_PATH).  This means that SELinux will not
    allow $SOURCE to use these files.  It is common for users to edit
    files in their home directory or tmp directories and then move
    (mv) them to system directories.  The problem is that the files 
    end up with the wrong file context which confined applications are not allowed to access.
    ''')

    fix_description = _('''
    If you want $SOURCE to access this files, you need to
    relabel them using restorecon -v '$TARGET_PATH'.  You might want to
    relabel the entire directory using restorecon -R -v '$TARGET_DIR'.
    ''')

    def __init__(self):
        Plugin.__init__(self, __name__)
        self.set_priority(90)

    def analyze(self, avc):
        if avc.matches_target_types(['.*_home_t', '.*_tmp_t', 'tmp_t']):
            # MATCH
            return self.report(avc, _("File Label"),
                               self.summary, self.problem_description,
                               self.fix_description, self.fix_cmd)
        return None

