/* @(#)misc.c	1.4 04/10/14 Copyright 2004 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)misc.c	1.4 04/10/14 Copyright 2004 J. Schilling";
#endif
/*
 *	Copyright (c) 2004 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <mconfig.h>
#include <unixstd.h>
#include <standard.h>
#include <statdefs.h>
#include <schily.h>
#include <nlsdefs.h>

#include "misc.h"

#ifdef	USE_ACL
#ifdef	HAVE_SYS_ACL_H
#	include <sys/acl.h>
#endif
#ifdef	HAVE_ACL_LIBACL_H
#	include <acl/libacl.h>	/* Needed for acl_extended_file() */
#endif
#endif

/*
 * Define some things that either are missing or defined in a different way
 * on SCO UnixWare
 */
#if	defined(UNIXWARE) && defined(HAVE_ACL)
typedef struct acl	aclent_t;
#endif
#ifndef	GETACL
#define	GETACL	ACL_GET
#endif
#ifndef	SETACL
#define	SETACL	ACL_SET
#endif
#ifndef	GETACLCNT
#define	GETACLCNT	ACL_CNT
#endif
#ifndef	MIN_ACL_ENTRIES
#define	MIN_ACL_ENTRIES	NACLBASE
#endif

EXPORT	BOOL	has_acl		__PR((char *name, char *sname, struct stat *sp));
EXPORT	BOOL	has_xattr	__PR((char *sname));

EXPORT BOOL
has_acl(name, sname, sp)
	char	*name;
	char	*sname;
	struct stat *sp;
{
#ifdef	USE_ACL
#ifdef	HAVE_SUN_ACL	/* Solaris & UnixWare */
	int	aclcount;

	/*
	 * Symlinks don't have ACLs
	 */
	if (S_ISLNK(sp->st_mode))
		return (FALSE);
#ifdef	HAVE_ST_ACLCNT
	return (sp->st_aclcnt > MIN_ACL_ENTRIES);
#else
	if ((aclcount = acl(sname, GETACLCNT, 0, NULL)) < 0) {
		errmsg(gettext("Cannot get ACL count for '%s'.\n"), name);
		return (FALSE);
	}
	return (aclcount > MIN_ACL_ENTRIES);
#endif	/* HAVE_ST_ACLCNT */
#else	/* HAVE_SUN_ACL */
	/*
	 * Non Sun ACL implementations.
	 */
#ifdef	HAVE_ACL_EXTENDED_FILE
	/*
	 * Linux extension
	 */
	return (acl_extended_file(sname) == 1);
#else
#ifdef	HAVE_POSIX_ACL
	acl_t	acl;

	if ((acl = acl_get_file(sname, ACL_TYPE_ACCESS)) != NULL) {
		int	id = ACL_FIRST_ENTRY;
		int	num;
		acl_entry_t dummy;

		for (num = 0; acl_get_entry(acl, id, &dummy); num++)
			id = ACL_NEXT_ENTRY;
		acl_free(acl);
		if (num > 3)
			return (TRUE);
	}
	/*
	 * Only directories have DEFAULT ACLs
	 */
	if (!S_ISDIR(sp->st_mode))
		return (FALSE);
	if ((acl = acl_get_file(sname, ACL_TYPE_DEFAULT)) != NULL) {
		int	id = ACL_FIRST_ENTRY;
		int	num;
		acl_entry_t dummy;

		for (num = 0; acl_get_entry(acl, id, &dummy); num++)
			id = ACL_NEXT_ENTRY;
		acl_free(acl);
		if (num > 0)
			return (TRUE);
	}
#endif	/* HAVE_POSIX_ACL */

	return (FALSE);

#endif
#endif	/* HAVE_SUN_ACL */
#else	/* USE_ACL */
	return (FALSE);
#endif	/* USE_ACL */
}

EXPORT BOOL
has_xattr(sname)
	char	*sname;
{
#ifdef	_PC_XATTR_EXISTS
		return (pathconf(sname, _PC_XATTR_EXISTS) > 0);
#else
		return (FALSE);
#endif
}
