/* @(#)walk.h	1.6 04/07/26 Copyright 2004 J. Schilling */
/*
 *	Definitions for directory tree walking
 *
 *	Copyright (c) 2004 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Flags to treewalk()
 *
 *	WALK_CHDIR	is not implemented, treewalk() always does chdir()
 */
#define	WALK_PHYS	1	/* Use lstat() instead of stat()	*/
#define	WALK_MOUNT	2	/* Do not cross mount points		*/
#define	WALK_DEPTH	4	/* Call content before calling the dir	*/
#define	WALK_CHDIR	8	/* Use chdir() to each directory	*/
#define	WALK_ARGFOLLOW	0x10	/* Use stat() for top level args only	*/
#define	WALK_ALLFOLLOW	0x20	/* Use stat() for all files		*/

/*
 * The type argument to walkfun
 */
#define	WALK_F		1	/* File	*/
#define	WALK_SL		2	/* Symbolic Link */
#define	WALK_D		3	/* Directory */
#define	WALK_DP		4	/* Directory previously visited */
#define	WALK_DNR	5	/* Directory with no read permission */
#define	WALK_NS		6	/* Unknown file type stat failed */
#define	WALK_SLN	7	/* Symbolic Link that points to nonexistent file */


struct WALK {
	int	flags;
	int	base;
	int	level;
};

/*
 * Flags in struct WALK
 */
#define	WALK_PRUNE	1	/* (*walkfun)() -> walk(): abort waking tree	*/
#define	WALK_NOCHDIR	2	/* walk() -> (*walkfun)(): WALK_DNR is cannot chdir() */

typedef	int	(*walkfun)	__PR((char *_nm, struct stat *_fs, int _type, struct WALK *_state));

extern	int	treewalk	__PR((char *_nm, walkfun _fn, int _flags));
