/* $Id: keyregression.h,v 1.17 2005/06/30 17:06:27 fubob Exp $ */

/*
 *
 * Copyright (C) 2005 Kevin Fu (fubob@mit.edu)
 * Copyright (C) 2004 Anjali Prakash (anjali@cs.jhu.edu)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 */

#ifndef _KEYREGRESSION_H_
#define _KEYREGRESSION_H_

#include "sfsro_prot.h"
#include "err.h"
#include "sfscrypt.h"
#include "bigint.h"


// Member operations
class keyregression {
 public:
  keyregression () 
    : curr_idx (0) { }

  uint32 curr_idx;
  chefs_keyvec hvec;
  vec<ptr<rpc_bytes<> > > kdvec;

  void update (chefs_stm &stm);

  uint32 curr_vers () { return curr_idx; }
  uint32 get_id () { return 0; }
  ptr<rpc_bytes<> > keyder (uint32 idx);
};

class keyregression_owner : public keyregression {
 public:
  //  keyregression_owner () 
  //{ hvec.setsize (1); }
  keyregression_owner (const uint32 max_idx) 
    { hvec.setsize (max_idx+1); kdvec.setsize (max_idx+1); init (); }

  keyregression_owner (const uint32 max_idx, sfs_hash root) 
    { 
      hvec.setsize (max_idx+1); 
      kdvec.setsize (max_idx+1);
      hvec[max_idx] = root;
      update ();
    }

  keyregression_owner (str infile);

  void toFile (str outfile);
  void noKRtoFile (str outfile);

  chefs_stm stm ()
    { chefs_stm s; s.vers = curr_idx; s.keystate = hvec[curr_idx]; return s; }
  
  void wind () { assert (curr_idx + 1 < hvec.size ()); curr_idx++; }
  void set_idx (uint32 idx)
    { assert (idx < hvec.size ()); curr_idx = idx; }
  
private:
  void init ();
  void update ();
};


#endif /* _KEYREGRESSION_H_ */


