/*
 * Smart Gnome Control - database interface definition file
 * Copyright (C) 2004 by Mark J. Fine <fineware@users.sourceforge.net>
 *
 * This program provides a graphical user interface to multiple
 * communications receivers using the Hamlib library.
 *
 * $Id: database.h,v 1.11 2004/12/28 05:56:28 fineware Exp $
 *
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the
 *      Free Software Foundation, Inc.
 *      59 Temple Place - Suite 330
 *      Boston, MA  02111-1307
 *      USA
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gnome.h>
#include <sys/stat.h>

gchar*		db_name;
gchar*      db_ext_name;
gchar*		db_filt;
gboolean    db_changed[5];
int			db_ver;
int			db_index[26];
int			num_freqs;
int			num_stats;
int			num_couns;
int			num_langs;
GtkWidget*	file_selector;
GList*		freqDB; //Array of db_record_t;
GList*		statDB; //Array of Str25;
GList*		counDB; //Array of Str25;
GList*		langDB; //Array of Str25;
gchar*		cur_clist;
gint		cur_row;

typedef union {
	unsigned char	c[4];
	unsigned short	s[2];
	unsigned long	l;
	float			f;
} ShortsFloat;

typedef union {
	unsigned char	s[2];
	unsigned short	i;
} ShortsInt;

typedef struct {
	union {
		guint16		pOn;   // : SmallInt; 2
		guchar		pOf1[2];
	};
	union {
		guint16		pOff;  // : SmallInt; 2
		guchar		pOf2[2];
	};
	guchar		pDays; // : Byte;     1
	guint32		pSInx; // : Integer;  2
	guint32		pCInx; // : Integer;  2
	guint32		pLInx; // : Integer;  2 
	gfloat		pFreq; // : Real;     6
	gchar		pTar[2];  // : Str2;  2
	gchar		pHear; // : Char;     1
} db_record_t;

typedef struct {
	gchar		pStrg[25];
} st_record_t;

void
get_database_file(void);

void
store_filename						   (GtkFileSelection *selector,
                                        gpointer         user_data);

gchar*
days_to_str                            (char in_days);

gchar*
time_rec_to_str                        (db_record_t *out_rec_p);

gchar*
target_rec_to_str                      (db_record_t *out_rec_p);

gchar*
get_station                            (int in_stat);

gchar*
strip_station                          (gchar* in_stat);

gchar*
get_country                            (int in_coun);

gchar*
get_language                           (int in_lang);

void
open_database(void);

void
index_db(void);

void
get_freq_records                       (GtkCList* clist,
                                        gdouble   inFreq);

void
get_sked_records                       (gchar* in_stat,
                                        long   in_time);

gboolean
check_stat_record                      (GtkCList* clist,
                                        int       in_row);

void
get_stat_records                       (int       type,
                                        long      in_time);

void
get_who_records                        (gdouble in_freq,
                                        long    in_time);

void
get_freq_data                          (gchar* in_stat,
                                        long   in_time);

void
get_stat_list_items_ex                 (GtkWidget* in_widget,
                                        gchar*     list_name,
                                        gint       in_row);

void
get_stat_list_items                    (GtkWidget* in_widget,
                                        gint in_row);

void
show_curr_freq                         (gchar* in_stat);

void
tune_from_freq_list_ex                 (GtkWidget* in_widget,
                                        gchar*     list_name,
                                        gint       in_row);

void
tune_from_freq_list                    (GtkWidget* in_widget,
                                        gint in_row);

long
get_gmt_time(void);

long
get_time_filter(void);

void
set_time_filter(void);

void
show_skeds_list                        (gchar* in_stat);

void
clear_sked_list(void);

void
refresh_sked_list                      (gchar* in_stat);

void
show_stat_list                         (int in_what);

void
refresh_stat_list                      (int whichwhat);

void
show_freq_list                         (gchar* in_freq);

void
refresh_who_list                       (gchar* in_freq);

void
show_freq_sidebar(void);

void
update_tuning_buttons                  (GtkCList* clist,
                                        gint      row);

void
select_previous(void);

void
select_next(void);

void
set_query                              (gint in_mode);

void
do_query(void);
