/***************************************************************************
                          devicelist.cpp  -  description
                             -------------------
    begin                : Mon Oct 16 2000
    copyright            : (C) 2000 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "devicelist.h"

User_Device_List::User_Device::User_Device() {
	
	name="New Device";
	hardware_device_index=-1;
}

void User_Device_List::add_device() {

	if (device_count<(MAX_DEVICES-1)) {

		device[device_count]=new User_Device;
		device_count++;
	}

}

void User_Device_List::delete_device(int devicenum) {

	int i;

	if ((devicenum<device_count) && (devicenum>=0)) {

		delete device[devicenum];
		for (i=devicenum;i<device_count-1;i++) device[i]=device[i+1];
		device_count--;
	}

}

bool User_Device_List::load_device_from_reader(File_Reader *file_reader) {

	bool had_success=false;
	Uint8 header[10];
        Uint8 banks_amount;
	int i,j;
	int device_number;
	string tmp_string;

	add_device();
	device_number=device_count-1;

	//header
	file_reader->get_byte_array(header,9);

	device[device_number]->name=file_reader->get_pascal_string();

	//controller names
	for (i=0;i<128;i++) device[device_number]->instrument_map.controller_names[i]=file_reader->get_pascal_string();

		//each bank
	file_reader->get_byte(banks_amount);

	for (i=0;i<banks_amount;i++) {

		if (i>0) device[device_number]->instrument_map.add_bank();

		device[device_number]->instrument_map.bank[i]->name=file_reader->get_pascal_string();
		file_reader->get_byte((Uint8)device[device_number]->instrument_map.bank[i]->bank_select_method);
		file_reader->get_byte((Uint8)device[device_number]->instrument_map.bank[i]->MSB);
		file_reader->get_byte((Uint8)device[device_number]->instrument_map.bank[i]->LSB);
		device[device_number]->instrument_map.bank[i]->custom_bank_select_string=file_reader->get_pascal_string();
		
		for (j=0;j<128;j++) device[device_number]->instrument_map.bank[i]->patch_names[j]=file_reader->get_pascal_string();

	}
	
	
	return had_success;
}

bool User_Device_List::save_device_to_writer(int device_number,File_Writer *file_writer) {

	bool had_success=false;
	int i,j;

	//header
	file_writer->store_byte_array((Uint8*)"SHKT-INST",9);

	file_writer->store_pascal_string(device[device_number]->name.c_str());

	//controller names
	for (i=0;i<128;i++) file_writer->store_pascal_string(device[device_number]->instrument_map.controller_names[i].c_str());

		//each bank

	file_writer->store_byte(device[device_number]->instrument_map.get_banks_count());

	for (i=0;i<device[device_number]->instrument_map.get_banks_count();i++) {

		file_writer->store_pascal_string(device[device_number]->instrument_map.bank[i]->name.c_str());

		file_writer->store_byte((Uint8)device[device_number]->instrument_map.bank[i]->bank_select_method);
		file_writer->store_byte((Uint8)device[device_number]->instrument_map.bank[i]->MSB);
		file_writer->store_byte((Uint8)device[device_number]->instrument_map.bank[i]->LSB);

		file_writer->store_pascal_string(device[device_number]->instrument_map.bank[i]->custom_bank_select_string.c_str());

		for (j=0;j<128;j++) file_writer->store_pascal_string(device[device_number]->instrument_map.bank[i]->patch_names[j].c_str());

	}

	return had_success;
}

void User_Device_List::save_device(int devicenum,string filename) {

	File_Writer writer;

	if (devicenum>=device_count) {

		ERROR("Wants me to save unexistent device?" << devicenum);
		return;
	}

	if (!writer.open(filename.c_str())) {

		save_device_to_writer(devicenum,&writer);		
	}

	writer.close();

}

void User_Device_List::load_device(string filename) {

	File_Reader reader;

	if (!reader.open(filename.c_str())) {

		load_device_from_reader(&reader);		
	}

	reader.close();

}

User_Device_List::User_Device* User_Device_List::get_device(int device_index) {

	if ((device_index<0) || (device_index>=device_count)) {

		ERROR("Request for inexistent device" << device_index);
		return NULL;
	} else {

		return device[device_index];
	}
}


User_Device_List::User_Device_List(){

	device_count=0;

}
User_Device_List::~User_Device_List(){

}
