/***************************************************************************
                          effect_volume.h  -  description
                             -------------------
    begin                : Tue Oct 16 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef EFFECT_VOLUME_H
#define EFFECT_VOLUME_H

#include "effect.h"
#include "event_basic.h"

class Effect_Channel_Volume_Change : public Effect  {

public:

	void notify_command(Uint8 p_parameter) {

                Event_Controller *control_change = new Event_Controller;
		control_change->set_controller(7,p_parameter*127/0xFF);
		queue->push(0,track,column,control_change);

	}
};

class Effect_Volume_Slide : public Effect  {
protected:
	float amount;
	bool slide_down;

public:

	void notify_command(Uint8 p_parameter) {

		if ((p_parameter!=0) && (p_parameter!=0xFF)) {

			if ((p_parameter&0xF0)==0) { //fineslide

				amount=p_parameter&0xF;

			} else if (((p_parameter&0xF0)==0xF0) && ((p_parameter&0x0F)!=0)) {
								
				amount=p_parameter&0xF;
				amount/=5.0;
			} else if ((p_parameter&0x0F)==0) { //fineslide

				amount=p_parameter >> 4;
				amount=0-amount;

			} else if (((p_parameter&0x0F)==0x0F) && ((p_parameter&0xF0)!=0)) {
								
				amount=p_parameter >>4;
				amount/=5.0;
				amount=0-amount;
			}

			parameter=p_parameter;
		}
	}
	
       	void process(int p_time_amount,int p_time_offset) {

	        float modifier;
		Event_Volume_Relative *vol_event = new Event_Volume_Relative;
	
	        modifier=data->variables.tempo*p_time_amount*amount;
		modifier=modifier/((float)time_divisor/1.0);
	        modifier=0-modifier;
		vol_event->set_volume_displacement(modifier);		

		queue->push(p_time_offset,track,column,vol_event);
	}

        Effect_Volume_Slide() {

		processing=true;
	}

};

class Effect_Tremolo : public Effect_Vibrato {

	void set_value(int p_time_offset,int p_value) {

		Event_Volume_Virtual *vol_event = new Event_Volume_Virtual;

	        vol_event->set_volume_displacement((float)p_value/5.0);
	
		queue->push(p_time_offset,track,column,vol_event);
	}
};

class Effect_Pan_Change : public Effect  {

public:

	void notify_command(Uint8 p_parameter) {

                Event_Controller *control_change = new Event_Controller;
		control_change->set_controller(10,p_parameter*127/0xFF);
		queue->push(0,track,column,control_change);

	}
};

class Effect_Aftertouch_Set : public Effect  {

public:

	void notify_command(Uint8 p_parameter) {

                Event_Aftertouch *aftertouch_change = new Event_Aftertouch;
		aftertouch_change->set_aftertouch(p_parameter*127/0xFF);
		queue->push(0,track,column,aftertouch_change);

	}
};

class Effect_Pan_Slide : public Effect  {
protected:
	float amount;
	bool slide_down;

public:

	void notify_command(Uint8 p_parameter) {

		if ((p_parameter!=0) && (p_parameter!=0xFF)) {

			if ((p_parameter&0xF0)==0) { //fineslide

				amount=p_parameter&0xF;

			} else if (((p_parameter&0xF0)==0xF0) && ((p_parameter&0x0F)!=0)) {
								
				amount=p_parameter&0xF;
				amount/=5.0;
			} else if ((p_parameter&0x0F)==0) { //fineslide

				amount=p_parameter >> 4;
				amount=0-amount;

			} else if (((p_parameter&0x0F)==0x0F) && ((p_parameter&0xF0)!=0)) {
								
				amount=p_parameter >>4;
				amount/=5.0;
				amount=0-amount;
			}

			parameter=p_parameter;
		}
	}
	
       	void process(int p_time_amount,int p_time_offset) {

	        float modifier;
		Event_Controller_Relative *ctrl_event = new Event_Controller_Relative;
	
	        modifier=data->variables.tempo*p_time_amount*amount;
		modifier=modifier/((float)time_divisor/100.0);
	
		ctrl_event->set_control_displacement(10,modifier);		

		queue->push(p_time_offset,track,column,ctrl_event);
	}

        Effect_Pan_Slide() {

		processing=true;
	}

};

class Effect_PanBrello : public Effect_Vibrato {

	void set_value(int p_time_offset,int p_value) {

		Event_Controller_Virtual *ctrl_event = new Event_Controller_Virtual;

		ctrl_event->set_controller(10,(float)p_value/5.0);		
	
		queue->push(p_time_offset,track,column,ctrl_event);
	}
};

#endif
