/***************************************************************************
                          interface_status_widget.cpp  -  description
                             -------------------
    begin                : Thu Jan 3 2002
    copyright            : (C) 2002 by red
    email                : red@server
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "interface_status_widget.h"

void Interface_Status_Widget::realize_impl() {
	
	Gdk_WindowAttr attributes,bs_attributes;
        int attributes_mask;

	set_flags(GTK_REALIZED);

	attributes->x=gtkobj()->allocation.x;
	attributes->y=gtkobj()->allocation.y;
	attributes->width = width();
	attributes->height = height();
	attributes->wclass = GDK_INPUT_OUTPUT;
	attributes->window_type = GDK_WINDOW_CHILD;
	attributes->event_mask = get_events () | GDK_EXPOSURE_MASK;
	attributes->visual = get_visual ();
	attributes->colormap = get_colormap ();	
	bs_attributes=attributes;
	
	attributes_mask = GDK_WA_X | GDK_WA_Y | GDK_WA_VISUAL | GDK_WA_COLORMAP;

	window.create(get_parent_window(), attributes, attributes_mask);
	gtkobj()->window=window;

	expose_event.connect(slot(this,&Interface_Status_Widget::do_expose_event));

	bg_col.red=10 * 0xFFFF / 0xFF;;
	bg_col.green=20 * 0xFFFF / 0xFF;;
	bg_col.blue=30 * 0xFFFF / 0xFF;;
	
	fg_col.red=100 * 0xFFFF / 0xFF;;
	fg_col.green=200 * 0xFFFF / 0xFF;;
	fg_col.blue=100 * 0xFFFF / 0xFF;;
	
	get_colormap().alloc(bg_col);
	get_colormap().alloc(fg_col);
	
	
	bg.create(get_window());
	fg.create(get_window());
	
	bg.set_foreground(bg_col);
	fg.set_foreground(fg_col);
	
	bg.set_exposures(1);
	
	window.set_user_data(gtkobj());
	window.set_background(bg_col);

#ifdef WIN32_ENABLED

	font.load("fixedsys");

#else

        font.load("-adobe-courier-bold-r-normal--*-100-*-*-*-*-*-*");

#endif
	font_draw.set_window(&window);		
	font_draw.set_font(&font);		
	font_width=font_draw.get_width();
	font_height=font.ascent()+font.descent();
}
gint Interface_Status_Widget::do_expose_event(GdkEventExpose* p0) {


	draw_impl(NULL);

	return 0;       	
}



void Interface_Status_Widget::draw_impl(GdkRectangle* p0) {

       	if (!is_drawable()) {
       	
//       	        printf("no drawable!\n");
		return;       	
       	}

        window.draw_rectangle(bg,TRUE,0,0,width(),height());       	
       	
	font_draw.do_string(&fg,4,(font_height+3),  "EDITOR: " + editor_status);	
	font_draw.do_string(&fg,4,(font_height+3)*2,"PLAYER: " + play_status);
	font_draw.do_string(&fg,4,(font_height+3)*4,"CURSOR: " + cursor_status);		
	
	font_draw.do_string(&fg,4,height()-3,   "|HELP|: Press ESC for file menu, F1 for section help.");
//	window.draw_rectangle(fg ,true ,0,0,30,30);
	return;

}

void Interface_Status_Widget::set_cursor_status(const char *p_status) {

        if (cursor_status==p_status) return; //we dont bother with extra redraw

	cursor_status=p_status;
	queue_draw();
}
void Interface_Status_Widget::set_play_status(const char *p_status) {

        if (play_status==p_status) return; //we dont bother with extra redraw
	play_status=p_status;
	queue_draw();
	
}
void Interface_Status_Widget::set_editor_status(const char *p_status) {

        if (editor_status==p_status) return; //we dont bother with extra redraw
	editor_status=p_status;
	queue_draw();
	
}

Interface_Status_Widget::Interface_Status_Widget(){
}
Interface_Status_Widget::~Interface_Status_Widget(){
}
