/***************************************************************************
                          event_execute.cpp  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "event_execute.h"

int Event_Execute::get_hw_device(int p_track) {

	return song->user_devices.get_device(song->get_instrument(p_track)->midi.device.get())->hardware_device_index;
}

int Event_Execute::get_hw_channel(int p_track) {

	return song->get_instrument(p_track)->midi.channel.get();
}

Bank* Event_Execute::get_current_bank(int p_track) {

	return song->user_devices.get_device(song->get_instrument(p_track)->midi.device.get())->instrument_map.bank[song->get_instrument(p_track)->midi.bank.get()];
}
void Event_Execute::event_External_NoteOn(int p_track,char p_note, char p_volume) {

	int temp_volume=convert_volume_to_velocity(p_track,p_volume);
	verify_instrument_cache(p_track);
	if (track[p_track].bender_value!=0x2000) {

		event_Pitch_Set(p_track,0,0x2000);
	}
	if (p_note<0) return;
	
	midiout->send_MIDI_noteon(get_hw_device(p_track),get_hw_channel(p_track),p_note,temp_volume);
}
void Event_Execute::event_External_NoteOff(int p_track,char p_note, char p_volume) {

	midiout->send_MIDI_noteoff(get_hw_device(p_track),get_hw_channel(p_track),p_note,127);
}

void Event_Execute::event_NoteOn(int p_track,int p_column,char p_note, char p_volume) {

	char temp_volume;

	if (song->get_instrument(p_track)->mute) return; // do nothing

	stop_channel(p_track,p_column);

	verify_instrument_cache(p_track);

	track[p_track].column[p_column].note=p_note;

	stop_note_in_another_track(p_track,p_column,p_note);

	temp_volume=convert_volume_to_velocity(p_track,p_volume);

	if (track[p_track].bender_value!=0x2000) {

		event_Pitch_Set(p_track,p_column,0x2000);
	}
	if (song->get_instrument(p_track)->VCB.get()==Instrument::VCB_NORMAL) { //tracker emulation
	
		event_Set_Column_Volume(p_track,p_column,64); //return volume to max
	} else {
	
		event_Set_Column_Volume(p_track,p_column,(int)temp_volume*64/128); //return volume to max	
		temp_volume=127;
	}

	midiout->send_MIDI_noteon(get_hw_device(p_track),get_hw_channel(p_track),p_note,temp_volume);
}
void Event_Execute::event_NoteOff(int p_track,int p_column,char p_volume) {

	if (song->get_instrument(p_track)->mute) return; // do nothing
	stop_channel(p_track,p_column);

}

void Event_Execute::event_Set_Column_Volume(int p_track,int p_column,float p_volume) {

	if (p_volume<0) p_volume=0;
	if (p_volume>64) p_volume=64;

	switch (song->get_instrument(p_track)->PNVA_type.get()) {

		case Instrument::PNVA_NOTE_AFTERTOUCH: {

			midiout->send_MIDI_note_aftertouch(get_hw_device(p_track),get_hw_channel(p_track),track[p_track].column[p_column].note,(int)p_volume*127/64);

		} break;

		case Instrument::PNVA_CHAN_AFTERTOUCH: {

			midiout->send_MIDI_channel_aftertouch(get_hw_device(p_track),get_hw_channel(p_track),(int)p_volume*127/64);

		} break;

		case Instrument::PNVA_CONTROLLER: {

			midiout->send_MIDI_control(get_hw_device(p_track),get_hw_channel(p_track),song->get_instrument(p_track)->PNVA_controller.get(),(int)p_volume*127/64);
		} break;

	}

	track[p_track].column[p_column].volume=p_volume;
}

void Event_Execute::event_set_column_volume_virtual(int p_track,int p_column,float p_volume) {


	p_volume=track[p_track].column[p_column].volume+p_volume;

	switch (song->get_instrument(p_track)->PNVA_type.get()) {

		case Instrument::PNVA_NOTE_AFTERTOUCH: {

			midiout->send_MIDI_note_aftertouch(get_hw_device(p_track),get_hw_channel(p_track),track[p_track].column[p_column].note,(int)p_volume*127/64);

		} break;

		case Instrument::PNVA_CHAN_AFTERTOUCH: {

			midiout->send_MIDI_channel_aftertouch(get_hw_device(p_track),get_hw_channel(p_track),(int)p_volume*127/64);

		} break;

		case Instrument::PNVA_CONTROLLER: {

			midiout->send_MIDI_control(get_hw_device(p_track),get_hw_channel(p_track),song->get_instrument(p_track)->PNVA_controller.get(),(int)p_volume*127/64);
		} break;

	}
}

void Event_Execute::event_Controller_Set(int p_track,int p_column,char p_controller,float p_value) {

	if (p_value<0) p_value=0;
	if (p_value>127) p_value=127;
	
	track[p_track].controller[p_controller]=p_value;

	midiout->send_MIDI_control(get_hw_device(p_track),get_hw_channel(p_track),p_controller,p_value);
}

void Event_Execute::event_controller_set_virtual_displacement(int p_track,int p_column,char p_controller,float p_value) {

	float final_val=track[p_track].controller[p_controller]+p_value;
	if (final_val<0) final_val=0;
	if (final_val>127) final_val=127;
	midiout->send_MIDI_control(get_hw_device(p_track),get_hw_channel(p_track),p_controller,final_val);
}

void Event_Execute::event_Pitch_Set(int p_track,int p_column,float p_value) {


	if (p_value<0) p_value=0;
	if (p_value>0x3FFF) p_value=0x3FFF;
	track[p_track].bender_value=p_value;
	midiout->send_MIDI_pitch_bender(get_hw_device(p_track),get_hw_channel(p_track),p_value);
}

void Event_Execute::event_set_aftertouch(int p_track,float p_value) {

	if (p_value<0) p_value=0;
	if (p_value>127) p_value=127;

	track[p_track].aftertouch_value=p_value;
	midiout->send_MIDI_channel_aftertouch(get_hw_device(p_track),get_hw_channel(p_track),p_value);
}

void Event_Execute::event_Pitch_Set_Virtual_Displacement(int p_track,int p_column,float p_value) {

	float final_val=track[p_track].bender_value+p_value;
	if (final_val<0) final_val=0;
	if (final_val>0x3FFF) final_val=0x3FFF;
	midiout->send_MIDI_pitch_bender(get_hw_device(p_track),get_hw_channel(p_track),final_val);
}

/* RETRIEVING */

char Event_Execute::get_last_note(int p_track,int p_column) { // -1 if no note has been set yet

	return track[p_track].column[p_column].note;
}
float Event_Execute::get_controller_value(int p_track, int p_controller) {

	return track[p_track].controller[p_controller];
}
float Event_Execute::get_pitch_value(int p_track) {

	return track[p_track].bender_value;
}
float Event_Execute::get_column_volume(int p_track,int p_column) {

	return track[p_track].column[p_column].volume;
}

float Event_Execute::get_aftertouch(int p_track) {

	return track[p_track].aftertouch_value;
}


/*** RESET ***/

void Event_Execute::adjust_size() {

	unsigned int i;

	if (track.size()!=song->get_tracks()) {

		track.resize(song->get_tracks());
	}

	for (i=0;i<song->get_tracks();i++) {

		if (track[i].column.size()!=song->get_track_width(i)) {
	
			track[i].column.resize(song->get_track_width(i));
		}
	}
}

void Event_Execute::adjust_bender_sens(int p_track) {

	track[p_track].bender_sens=song->get_instrument(p_track)->midi.PBS.get();

	midiout->send_MIDI_RPN(get_hw_device(p_track),get_hw_channel(p_track),0,0,track[p_track].bender_sens,0);
}


void Event_Execute::stop_track(int p_track) {

	int i;
	Instrument::Initial_Value_List::iterator I;
	int aux_ctrlval;

        for (i=0;i<song->get_track_width(p_track);i++)  stop_channel(p_track,i);
	midiout->send_MIDI_control(get_hw_device(p_track),get_hw_channel(p_track),121,0);



	for (I=song->get_instrument(p_track)->initial_value.begin();I!=song->get_instrument(p_track)->initial_value.end();I++) {

		if (I->value==-1) continue;

		if (I->type==Instrument::Initial_Value::CONTROLLER) {

			event_Controller_Set(p_track,0,I->controller,I->value.get());
		}
	}			


	event_Pitch_Set(p_track,0,0x2000);
}


void Event_Execute::reset_track(int p_track) {

	midiout->send_MIDI_control(get_hw_device(p_track),get_hw_channel(p_track),120,0);	
        track[p_track].reset();
	stop_track(p_track);
	event_External_NoteOn(p_track,-1,0); //small hackup to prepare the synth.
	
}

void Event_Execute::reset() {

	unsigned int i;
	adjust_size();
	for (i=0;i<track.size();i++) reset_track(i);
}

void Event_Execute::stop() {

	unsigned int i;
	adjust_size();
	for (i=0;i<track.size();i++) stop_track(i);
}


void Event_Execute::set_midiout(MidiOutDeviceManager *p_midiout) {

	midiout=p_midiout;
}

void Event_Execute::set_song(Song *p_song) {

	song=p_song;
}

Event_Execute::Event_Execute(){
}
Event_Execute::~Event_Execute(){
}
