/***************************************************************************
                          event_queue.cpp  -  description
                             -------------------
    begin                : Thu Aug 16 2001
    copyright            : (C) 2001 by Juan Sebastian Linietsky
    email                : reduz@anime.com.ar
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "event_queue.h"

void Event_Queue::push(int p_time_offset,int p_track, int p_column,Event *p_event) {

	Event_List::iterator I;
	
	p_event->set_track(p_track);
	p_event->set_column(p_column);
	p_event->set_time_offset(p_time_offset);
	p_event->set_event_runner(runner);

	I=event_list.begin();

	for (;I!=event_list.end();I++) {

		if ((*I)->get_time_offset() > p_time_offset) break;
	}

	event_list.insert(I,p_event);
}
void Event_Queue::move_priorities(int p_time_amount) {

	Event_List::iterator I;

	for (I=event_list.begin();I!=event_list.end();I++) {

		(*I)->set_time_offset((*I)->get_time_offset()-p_time_amount);
	}
}

int Event_Queue::get_head_time() {

	Event_List::iterator I;

	if (is_empty()) {

		ERROR("Request for get_head_time() when list is empty!");
		return 0;
	} else {

		I=event_list.begin();

		return (*I)->get_time_offset();
	}
}

bool Event_Queue::is_empty() {

	return event_list.begin()==event_list.end();
}

Event* Event_Queue::pop() {

	Event_List::iterator I;

	if (is_empty()) {

		ERROR("Request for get_head_time() when list is empty!");
		return NULL;
	} else {

		I=event_list.begin();
		event_list.pop_front();

		return (*I);
	}
}
void Event_Queue::set_event_runner(Event_Execute *p_runner) {

	runner=p_runner;
}

void Event_Queue::clear() {

	Event_List::iterator I;

	for (I=event_list.begin();I!=event_list.end();I++) {

		delete (*I);
	}

	event_list.clear();
}
void Event_Queue::delete_extra_events(int p_time,string p_event_name) {

	Event_List::iterator I,L,prev;;

        L=event_list.end();
	
	for (I=event_list.begin();I!=event_list.end();I++) {

		if ((*I)->get_time_offset()>=p_time) break;
                if (*(*I)->get_name()==p_event_name) L=I;
		
	}

	if ((L==event_list.end()) || (L==event_list.begin()) ) return;


	while (L!=event_list.begin()) {

                Event *aux_event;

		prev=L;
		L--;

                if (*(*L)->get_name()==p_event_name) {
                        aux_event=*L;
			event_list.erase(L);
			L=prev;
			delete aux_event;			
		}		
	}
}

Event_Queue::Event_Queue(){
}
Event_Queue::~Event_Queue(){

	clear();
}
