/* Copyright (C) 1993,1994 by the author(s).
 
 This software is published in the hope that it will be useful, but
 WITHOUT ANY WARRANTY for any part of this software to work correctly
 or as described in the manuals. See the ShapeTools Public License
 for details.

 Permission is granted to use, copy, modify, or distribute any part of
 this software but only under the conditions described in the ShapeTools 
 Public License. A copy of this license is supposed to have been given
 to you along with ShapeTools in a file named LICENSE. Among other
 things, this copyright notice and the Public License must be
 preserved on all copies.
 */
/*
 * AtFS -- Attribute Filesystem
 *
 * aftmpfiles.c -- handle temporary- and lock-files
 *
 * Author: Andreas Lampen (Andreas.Lampen@cs.tu-berlin.de)
 *
 * $Header: aftmpfiles.c[7.0] Fri Jun 25 14:32:25 1993 andy@cs.tu-berlin.de frozen $
 */

#include "atfs.h"

/*================================================================
 *      list of tmp files
 *================================================================*/

static char *tmpfilelist[OPEN_MAX];

LOCAL void rmtmpfiles ()
{
  register int i;

  for (i=0; i < OPEN_MAX; i++)
    if (tmpfilelist[i])
      unlink (tmpfilelist[i]);
}

EXPORT void af_regtmpfile (name) /* registrate tmp file */
     char *name;
{
  register int i;

  /* look for free space in list */
  for (i=0; i < OPEN_MAX; i++)
    if (tmpfilelist[i] == NULL) {
      tmpfilelist[i] = name;
      break;
    }
  if (i == OPEN_MAX) /* list is full */
    af_wng ("regtmpfile", "tmpfile list is full -- couldn't register");
}

EXPORT void af_unregtmpfile (name) /* remove tmp file entry */
     char *name;
{
  register int i;
  for (i=0; i < OPEN_MAX; i++)
    if (tmpfilelist[i] == name) {
      tmpfilelist[i] = NULL;
      break;
    }
  if (i == OPEN_MAX) /* name not found */
    af_wng ("unregtmpfile", "name of tmpfile has not been registered before");
}  

/*=========================================================================
 *     af_cleanup -- do cleanup
 *=========================================================================*/

EXPORT void af_cleanup ()
{
  /* remove tmp files */
  rmtmpfiles ();
  af_abort();
}
