/*
 *   Copyright 2011 Marco Martin <mart@kde.org>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU Library General Public License as
 *   published by the Free Software Foundation; either version 2 or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU Library General Public License for more details
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this program; if not, write to the
 *   Free Software Foundation, Inc.,
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 1.0
import org.kde.qtextracomponents 0.1
import org.kde.plasma.core 0.1 as PlasmaCore
import org.kde.plasma.graphicswidgets 0.1 as PlasmaWidgets

Item {
    //FIXME: no hardcoded sizes
    width: 200
    height: 200
    PlasmaCore.FrameSvgItem {
        id: menuFrame
        imagePath: "widgets/lineedit"
        prefix: "sunken"
        anchors {
            top: parent.top
            left: parent.left
            right: parent.right
            bottom: okButton.top
        }
        PlasmaWidgets.TextEdit {
            anchors.fill: parent
            anchors.margins: 5
        }
    }

    PlasmaWidgets.PushButton {
        id: okButton
        text: i18n("Ok")
        anchors {
            horizontalCenter: parent.horizontalCenter
            bottom: parent.bottom
        }
    }
}
