
/****************************************************************************
**
** Copyright (C) 2011 Christian B. Huebschle & George M. Sheldrick
** All rights reserved.
** Contact: chuebsch@moliso.de
**
** This file is part of the ShelXle
**
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file COPYING included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
**
****************************************************************************/
#ifndef FOURXLE_H
#define FOURXLE_H 1
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <ctype.h>
#include <string.h>
//#include <fftw3.h> //if you want you can try to uncoment this, but then you have to coment the following line
#include "kissfft/kiss_fftnd.h"
#include "molecule.h"
#include "chgl.h"
#include <QObject>
#include <QCheckBox>

#ifndef fmin
#define fmin(x, y) (((x) < (y)) ? (x) : (y))
#endif

#ifndef fmax
#define fmax(x, y) (((x) > (y)) ? (x) : (y))
#endif
//! Rec is a reflection type of a fcf 6 file.
typedef struct {
int  ih,//!< h
     ik,//!< k
     il;//!< l 
float fo,//!< F observed
      so,//!< \f$\sigma(observed)\f$
      fc,//!< F calculated
      phi; //!< \f$\varphi\f$ 
} Rec;
#define LM 2000000
//! FNode is a struct for the 3 different edges of a cube 
struct FNode {
  V3 vertex;//!< vertex is the 3d position of the node
  V3 normal;//!< normal is the plane normal of the surface
  char flag;//!< this flag is set when the surface crosses this node
  inline operator char (){
    //! \returns the flag parameter. No Coala ;-)
    return flag;
  }
  inline operator V3(){
    //! \returns the vertex of the node.
    return vertex;
  }
  friend inline double Distance( const FNode& n1, const FNode& n2 ){
    /*! @param n1,n2 nodes vor which the squared distance should be calculated.
     \returns te positional squared distance between two nodes
     */
    return Norm(n1.vertex-n2.vertex);
  }
};
//
//!  FourXle is an QObject that loads a fcf 6 file and creates iso-surfaces in meshed style \inherit QObject 
class FourXle:public QObject{
Q_OBJECT
  public:
          int HKLMX;//!< Maximum of h,k and l values can be used to make a resulution cut. 
          float *datfo,//!<data pointer for the fobs map in real space
		*datfo_fc;//!<data pointer for the fobs-fcalc map in real space
          float f000;
          FourXle(Molecule *mole_, ChGL *chgl_,QToolBar *toolView, double resol=2.5, double wght=1.1);
	  /*!< @param mole_ pointer to the Molecule of ShelXle 
	   *  @param chgl_ pointer to the ChGL widged of ShelXle
	   *  @param toolView pointer to the View Toolbar of ShelXle
	   *  @param resol resolution factor (the higher the more grid points)
	   *  @param wght a parameter to downweight weak reflections
	   */
          ~FourXle();
          bool loadFouAndPerform(const char filename[],bool neu=true);
          double lintrans,//!<degree of thansparency for the maps 0-1. 0 is transparent.
		 linwidth;//!<linewidth of the meshes.
          float sigma[3];//!<sigma values 
          float iso[3];//!<iso values
	//  double mInimum[2],mAximum[2];
	  QProgressBar *balken;//!< a progress bar to make waiting more fun. 
	  int balkenstep;//!< steps for the progress bar 
          V3 urs;//!< origin
          double rr,//!< resolution factor (the higher the more grid points) 
		 rw;//!< a parameter to downweight weak reflections

	  QCheckBox *doMaps;//!< do or notthing todo is the question
	  int maptrunc;//!< truncation type of the meshes
          Molecule *mole;//!< pointer to the Molecule object
	  QColor fopc,//!< Fo positive color
		 fomc,//!< Fo negative color
		 dipc,//!< Fo-Fc positive color
		 dimc;//!< Fo-Fc negative color
	  double map_radius;//!< cut radius for the meshes in Angstrom
          ChGL *chgl;//!< pointer to the ChGL widget
          QString voxelstr;//!< a string to fix dimensions to desired values by comand line option '-voxel 92x92x92 '
	  void deleteLists();
	  void killmaps();
          void jnk();
          void exportMaps(int na, const char filename[], const char atomlist[]);
	  int n1,//!< dimension of the map in a diRection
	      n2,//!< dimension of the map in b diRection
	      n3,//!< dimension of the map in c diRection
	      n4;//!< \f$ n4 = n1 \times n2\f$
	  int n5;//!< \f$ n5 = n1 \times n2 \times n3\f$
	  V3 dx,//!< vector in a direction for each map voxel
	     dy,//!< vector in b direction for each map voxel
	     dz;//!< vector in c direction for each map voxel
  public slots:
          void bewegt(V3 v);
          void inimap();
          void change_iso(int numsteps,int diff);
          void chglDestroyed();
          void foactDestroyed();
          void fofcactDestroyed();
  signals:
  void bigmessage(const QString &);//!< to comunicate with the informaton window

  private:
	  double C[15],D[9],sy[12][192],wave;
	  inline int Intersect( double& vm, double& vp ){ return vm*vp <= 0.0 && (vm<0.0 || vp<0.0); }
          inline int dex(int x,int y,int z);
          inline int dex3(int x,int y,int z);
	  int oldatomsize;
	  int acnt;
	  V3 oc,dxc,dyc,dzc;
	  V3  delDA[27];
#ifdef FFTW3_H
	  fftwf_plan  fwd_plan;//!!!
          fftwf_complex *B;//!!!
#else
	  kiss_fftnd_cfg fwd_plan;//!!!
          kiss_fft_cpx *B;//!!!
#endif
          FNode *nodex,*nodey,*nodez;
	  int *noGoMap;
	  Rec lr[LM];
	  char cen,git;
          int nr,nc,ns;
	  int mtyp,tri;
	  QTime foti,suti;
//          double minnor,maxnor;
          void gen_surface(bool neu,int imin=0, int imax=4);
          void CalcVertex( int ix, int iy, int iz);
	  V3 CalcNormalX( int ix, int iy, int iz );
	  V3 CalcNormalY( int ix, int iy, int iz );
	  V3 CalcNormalZ( int ix, int iy, int iz );
          int IndexSelected( FNode& node0, FNode& node1, FNode& node2, FNode& node3 );
          V3& VectorSelected( FNode& node0, FNode& node1, FNode& node2, FNode& node3 );
          void MakeElement( int ix, int iy, int iz ,int s1, int s2);
          void makeFaces(int n, FNode poly[] );

char titl[80];/*fcmax=0,f000=0,resmax=99999.0,*/
void trimm(char s[]);
void deletes(char *s, int count);
int readHeader(const char *filename);
void sorthkl(int nr, Rec r[]);
};

#endif
