
/****************************************************************************
**
** Copyright (C) 2011 Christian B. Huebschle & George M. Sheldrick
** All rights reserved.
** Contact: chuebsch@moliso.de
**
** This file is part of the ShelXle
**
** This file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file COPYING included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
**
****************************************************************************/
#include "window.h"
#include <QApplication>
//öß
#if (QT_VERSION >= 0x050000)
void mh(QtMsgType type, const QMessageLogContext &context, const QString &msg) {
  QByteArray localMsg = msg.toLocal8Bit();
    QString pth=QDir::homePath()+"/ShelXle_message.txt";
    FILE *er=fopen(pth.toStdString().c_str(),"at");
    fprintf(er,"======%s\n%s\n======\n",QDateTime::currentDateTime().toString().utf16(),localMsg.constData());
    fclose(er);
    if (strstr(localMsg.constData(),"QGLShader::link:")!=NULL) {
      printf("%s\n",localMsg.constData());fflush(stdout);
      return; // ignore useless error messages with shitty intel graphic cards reporting \"No error."
    }
  if (strstr(localMsg.constData(),"QAccessibleWidget")!=NULL) {
    printf("%s\n",localMsg.constData());fflush(stdout);
    return; // ignore useless error messages on win with touch screens
  }
  if (strstr(localMsg.constData(),"QGLShader::link:")!=NULL) {
    printf("%s\n",localMsg.constData());fflush(stdout);
    return; // ignore useless error messages
  }

  switch (type) {
    case QtDebugMsg:
      fprintf(stderr, "Debug: %s (%s:%u, %s)\n", localMsg.constData(), context.file, context.line, context.function);
#if defined Q_WS_WIN  ||  defined Q_WS_MAC
    QMessageBox::information(0,"information",msg);
#endif
      break;
    case QtInfoMsg:
      fprintf(stderr, "Info: %s (%s:%u, %s)\n", localMsg.constData(), context.file, context.line, context.function);
#if defined Q_WS_WIN  ||  defined Q_WS_MAC
    QMessageBox::information(0,"information",msg);
#endif
      break;
    case QtWarningMsg:
      fprintf(stderr, "Warning: %s (%s:%u, %s)\n", localMsg.constData(), context.file, context.line, context.function);
#if defined Q_WS_WIN  ||  defined Q_WS_MAC
    QMessageBox::warning(0,"warning",msg);
#endif
      break;
    case QtCriticalMsg:
      fprintf(stderr, "Critical: %s (%s:%u, %s)\n", localMsg.constData(), context.file, context.line, context.function);
#if defined Q_WS_WIN  || defined Q_WS_MAC
    QMessageBox::critical(0,"critical",msg);
#endif
      break;
    case QtFatalMsg:
      fprintf(stderr, "Fatal: %s (%s:%u, %s)\n", localMsg.constData(), context.file, context.line, context.function);
#if defined Q_WS_WIN  || defined Q_WS_MAC
    QMessageBox::critical(0,"fatal",msg);
#endif
      abort();
  }
}
#else
void mh(QtMsgType type, const char *msg){
    QString pth=QDir::homePath()+"/ShelXle_message.txt";
    FILE *er=fopen(pth.toStdString().c_str(),"wt");
    fprintf(er,"======\n%s\n======\n",msg);
    fclose(er);
    if (strstr(msg,"QGLShader::link:")!=NULL) {
      printf("%s\n",msg);fflush(stdout);
      return; // ignore useless error messages with shitty intel graphic cards reporting \"No error."
    }
  if (strstr(msg,"QAccessibleWidget")!=NULL) {
    printf("%s\n",msg);fflush(stdout);
    return; // ignore useless error messages on win with touch screens
  }
  if (strstr(msg,"QGLShader::link:")!=NULL) {
    printf("%s\n",msg);fflush(stdout);
    return; // ignore useless error messages
  }

  switch (type){
  case QtDebugMsg:

    printf("%s\n",msg);fflush(stdout);

#if defined Q_WS_WIN  ||  defined Q_WS_MAC
    QMessageBox::information(0,"information",msg);
#endif
    break;
  case QtWarningMsg:
    printf("%s\n",msg);fflush(stdout);
#if defined Q_WS_WIN  ||  defined Q_WS_MAC
    QMessageBox::warning(0,"warning",msg);
#endif
    break;
  case QtCriticalMsg:
    printf("%s\n",msg);fflush(stdout);
#if defined Q_WS_WIN  || defined Q_WS_MAC
    QMessageBox::critical(0,"critical",msg);
#endif
    break;
  case QtFatalMsg:
    printf("%s\n",msg);fflush(stdout);
#if defined Q_WS_WIN  || defined Q_WS_MAC
    QMessageBox::critical(0,"fatal",msg);
#endif
    abort();
  }
}

#endif

void printicon(){
  QImage II=QImage(":/icons/SHELxLE.png" );
//  QImage II=QPixmap(":/icons/cbh.png" ).toImage();
  int r, g, b, c216,gray,k=0;
  double alpha;
  char x[9]="@ShelXle";
  for (int j=0; j<II.height(); j++){
  for (int i=0; i<II.width(); i++){
    //printf("%2x",qGray(II.pixel(i,j)));a
    alpha=qAlpha(II.pixel(i,j))/256.0;
    r=(int) (qRed(II.pixel(i,j))/48.0*alpha);
    g=(int) (qGreen(II.pixel(i,j))/48.0*alpha);
    b=(int) (qBlue(II.pixel(i,j))/48.0*alpha);
    c216 = 16 + 36 * r + 6 * g + b;
    gray =qGray(II.pixel(i,j))/11+232;
    gray= (int)(alpha*gray +(235*(1.0-alpha)));
    printf("\e[48;5;%dm\e[38;5;%dm%c",c216,gray,x[k%8]);
    //printf("\e[48;5;%dm\e[38;5;%dm%c",gray,c216,x[k%8]);
    k++;
  }
  printf("\e[0;0;0m\n");j++;
  }


}

int main(int argv, char *args[]){
  QApplication app(argv, args);
  
  app.setOrganizationName("shelxle");
  app.setWindowIcon(QIcon(":/icons/SHELxLE.png"));
  //printicon();
#if (QT_VERSION >= 0x050000)
  qInstallMessageHandler(mh);
#else
  qInstallMsgHandler(mh);
#endif
  Window *window = new Window();
  window->show();
  int istat = app.exec();
  delete window;
  return istat;
}
