/*
 * This file is part of the Shiboken Python Bindings Generator project.
 *
 * Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
 *
 * Contact: PySide team <contact@pyside.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include "shibokenconfig.h"
#include <iostream>
#include <QtCore>

int main(int argc, char* argv[])
{
    QStringList args;
    args.append("--generator-set=shiboken");
    for (int i = 1; i < argc; i++) {
        if (QString("--version") == argv[i]) {
            std::cout << "shiboken v" SHIBOKEN_VERSION << std::endl;
            std::cout << "Copyright (C) 2009-2011 Nokia Corporation and/or its subsidiary(-ies)" << std::endl;
            return EXIT_SUCCESS;
        }
        args.append(argv[i]);
    }
    return QProcess::execute(GENERATOR_BINARY, args);
}

