/** @file shishi_cmd.h
 *  @brief The header file for the command line option parser
 *  generated by GNU Gengetopt version 2.22.4
 *  http://www.gnu.org/software/gengetopt.
 *  DO NOT modify this file, since it can be overwritten
 *  @author GNU Gengetopt by Lorenzo Bettini */

#ifndef SHISHI_CMD_H
#define SHISHI_CMD_H

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h> /* for FILE */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#ifndef CMDLINE_PARSER_PACKAGE
/** @brief the program name (used for printing errors) */
#define CMDLINE_PARSER_PACKAGE "shishi"
#endif

#ifndef CMDLINE_PARSER_PACKAGE_NAME
/** @brief the complete program name (used for help and version) */
#define CMDLINE_PARSER_PACKAGE_NAME "shishi"
#endif

#ifndef CMDLINE_PARSER_VERSION
/** @brief the program version */
#define CMDLINE_PARSER_VERSION VERSION
#endif

/** @brief Where the command line options are stored */
struct gengetopt_args_info
{
  const char *help_help; /**< @brief Print help and exit help description.  */
  const char *version_help; /**< @brief Print version and exit help description.  */
  int destroy_flag;	/**< @brief Destroy tickets in local cache, limited by any --client-name or --server-name. (default=off).  */
  const char *destroy_help; /**< @brief Destroy tickets in local cache, limited by any --client-name or --server-name. help description.  */
  int list_flag;	/**< @brief List tickets in local cache, limited by any --client-name and --server-name. (default=off).  */
  const char *list_help; /**< @brief List tickets in local cache, limited by any --client-name and --server-name. help description.  */
  int renew_flag;	/**< @brief Renew ticket.  Use --server-name to specify ticket, default is the most recent renewable ticket granting ticket for the default realm. (default=off).  */
  const char *renew_help; /**< @brief Renew ticket.  Use --server-name to specify ticket, default is the most recent renewable ticket granting ticket for the default realm. help description.  */
  int forwardable_flag;	/**< @brief Get a forwardable ticket, i.e., one that can be used to get forwarded tickets. (default=off).  */
  const char *forwardable_help; /**< @brief Get a forwardable ticket, i.e., one that can be used to get forwarded tickets. help description.  */
  int forwarded_flag;	/**< @brief Get a forwarded ticket. (default=off).  */
  const char *forwarded_help; /**< @brief Get a forwarded ticket. help description.  */
  int proxiable_flag;	/**< @brief Get a proxiable ticket, i.e., one that can be used to get proxy tickets. (default=off).  */
  const char *proxiable_help; /**< @brief Get a proxiable ticket, i.e., one that can be used to get proxy tickets. help description.  */
  int proxy_flag;	/**< @brief Get a proxy ticket. (default=off).  */
  const char *proxy_help; /**< @brief Get a proxy ticket. help description.  */
  int renewable_flag;	/**< @brief Get a renewable ticket. (default=off).  */
  const char *renewable_help; /**< @brief Get a renewable ticket. help description.  */
  char * client_name_arg;	/**< @brief Client name. Default is login username..  */
  char * client_name_orig;	/**< @brief Client name. Default is login username. original value given at command line.  */
  const char *client_name_help; /**< @brief Client name. Default is login username. help description.  */
  char * encryption_type_arg;	/**< @brief Encryption types to use.  ETYPE is either registered name or integer.  Valid values include 'aes128', 'aes256', 'aes' (same as 'aes256'), '3des', 'des-md5', 'des-md4', 'des-crc', 'des' (same as 'des-md5'), and 'arcfour'..  */
  char * encryption_type_orig;	/**< @brief Encryption types to use.  ETYPE is either registered name or integer.  Valid values include 'aes128', 'aes256', 'aes' (same as 'aes256'), '3des', 'des-md5', 'des-md4', 'des-crc', 'des' (same as 'des-md5'), and 'arcfour'. original value given at command line.  */
  const char *encryption_type_help; /**< @brief Encryption types to use.  ETYPE is either registered name or integer.  Valid values include 'aes128', 'aes256', 'aes' (same as 'aes256'), '3des', 'des-md5', 'des-md4', 'des-crc', 'des' (same as 'des-md5'), and 'arcfour'. help description.  */
  char * endtime_arg;	/**< @brief Specify when ticket validity should expire.  The time syntax may be relative (to the start time), such as '20 hours', or absolute, such as '2001-02-03 04:05:06 CET'. The default is 8 hours after the start time..  */
  char * endtime_orig;	/**< @brief Specify when ticket validity should expire.  The time syntax may be relative (to the start time), such as '20 hours', or absolute, such as '2001-02-03 04:05:06 CET'. The default is 8 hours after the start time. original value given at command line.  */
  const char *endtime_help; /**< @brief Specify when ticket validity should expire.  The time syntax may be relative (to the start time), such as '20 hours', or absolute, such as '2001-02-03 04:05:06 CET'. The default is 8 hours after the start time. help description.  */
  char * realm_arg;	/**< @brief Set default realm..  */
  char * realm_orig;	/**< @brief Set default realm. original value given at command line.  */
  const char *realm_help; /**< @brief Set default realm. help description.  */
  char * renew_till_arg;	/**< @brief Specify renewable life of ticket.  Implies --renewable.  Accepts same time syntax as --endtime.  If --renewable is specified, the default is 1 week after the start time..  */
  char * renew_till_orig;	/**< @brief Specify renewable life of ticket.  Implies --renewable.  Accepts same time syntax as --endtime.  If --renewable is specified, the default is 1 week after the start time. original value given at command line.  */
  const char *renew_till_help; /**< @brief Specify renewable life of ticket.  Implies --renewable.  Accepts same time syntax as --endtime.  If --renewable is specified, the default is 1 week after the start time. help description.  */
  char * server_name_arg;	/**< @brief Server name. Default is 'krbtgt/REALM' where REALM is client realm..  */
  char * server_name_orig;	/**< @brief Server name. Default is 'krbtgt/REALM' where REALM is client realm. original value given at command line.  */
  const char *server_name_help; /**< @brief Server name. Default is 'krbtgt/REALM' where REALM is client realm. help description.  */
  char * starttime_arg;	/**< @brief Specify when ticket should start to be valid.  Accepts same time syntax as --endtime. The default is to become valid immediately..  */
  char * starttime_orig;	/**< @brief Specify when ticket should start to be valid.  Accepts same time syntax as --endtime. The default is to become valid immediately. original value given at command line.  */
  const char *starttime_help; /**< @brief Specify when ticket should start to be valid.  Accepts same time syntax as --endtime. The default is to become valid immediately. help description.  */
  char * ticket_granter_arg;	/**< @brief Service name in ticket to use for authenticating request. Only for TGS. Defaults to 'krbtgt/REALM@REALM' where REALM is client realm..  */
  char * ticket_granter_orig;	/**< @brief Service name in ticket to use for authenticating request. Only for TGS. Defaults to 'krbtgt/REALM@REALM' where REALM is client realm. original value given at command line.  */
  const char *ticket_granter_help; /**< @brief Service name in ticket to use for authenticating request. Only for TGS. Defaults to 'krbtgt/REALM@REALM' where REALM is client realm. help description.  */
  char * configuration_file_arg;	/**< @brief Read user configuration from FILE..  */
  char * configuration_file_orig;	/**< @brief Read user configuration from FILE. original value given at command line.  */
  const char *configuration_file_help; /**< @brief Read user configuration from FILE. help description.  */
  char * ticket_file_arg;	/**< @brief Read tickets from FILE..  */
  char * ticket_file_orig;	/**< @brief Read tickets from FILE. original value given at command line.  */
  const char *ticket_file_help; /**< @brief Read tickets from FILE. help description.  */
  char * library_options_arg;	/**< @brief Parse STRING as a configuration file statement..  */
  char * library_options_orig;	/**< @brief Parse STRING as a configuration file statement. original value given at command line.  */
  const char *library_options_help; /**< @brief Parse STRING as a configuration file statement. help description.  */
  int quiet_flag;	/**< @brief Don't produce any diagnostic output.\n (default=off).  */
  const char *quiet_help; /**< @brief Don't produce any diagnostic output.\n help description.  */
  char * system_configuration_file_arg;	/**< @brief Read system configuration from FILE..  */
  char * system_configuration_file_orig;	/**< @brief Read system configuration from FILE. original value given at command line.  */
  const char *system_configuration_file_help; /**< @brief Read system configuration from FILE. help description.  */
  char * ticket_write_file_arg;	/**< @brief Write tickets from FILE.  Default is to write them back to where they were read from..  */
  char * ticket_write_file_orig;	/**< @brief Write tickets from FILE.  Default is to write them back to where they were read from. original value given at command line.  */
  const char *ticket_write_file_help; /**< @brief Write tickets from FILE.  Default is to write them back to where they were read from. help description.  */
  unsigned int verbose_min; /**< @brief Produce verbose output.\nUse multiple times to increase amount of information.'s minimum occurreces */
  unsigned int verbose_max; /**< @brief Produce verbose output.\nUse multiple times to increase amount of information.'s maximum occurreces */
  const char *verbose_help; /**< @brief Produce verbose output.\nUse multiple times to increase amount of information. help description.  */
  
  unsigned int help_given ;	/**< @brief Whether help was given.  */
  unsigned int version_given ;	/**< @brief Whether version was given.  */
  unsigned int destroy_given ;	/**< @brief Whether destroy was given.  */
  unsigned int list_given ;	/**< @brief Whether list was given.  */
  unsigned int renew_given ;	/**< @brief Whether renew was given.  */
  unsigned int forwardable_given ;	/**< @brief Whether forwardable was given.  */
  unsigned int forwarded_given ;	/**< @brief Whether forwarded was given.  */
  unsigned int proxiable_given ;	/**< @brief Whether proxiable was given.  */
  unsigned int proxy_given ;	/**< @brief Whether proxy was given.  */
  unsigned int renewable_given ;	/**< @brief Whether renewable was given.  */
  unsigned int client_name_given ;	/**< @brief Whether client-name was given.  */
  unsigned int encryption_type_given ;	/**< @brief Whether encryption-type was given.  */
  unsigned int endtime_given ;	/**< @brief Whether endtime was given.  */
  unsigned int realm_given ;	/**< @brief Whether realm was given.  */
  unsigned int renew_till_given ;	/**< @brief Whether renew-till was given.  */
  unsigned int server_name_given ;	/**< @brief Whether server-name was given.  */
  unsigned int starttime_given ;	/**< @brief Whether starttime was given.  */
  unsigned int ticket_granter_given ;	/**< @brief Whether ticket-granter was given.  */
  unsigned int configuration_file_given ;	/**< @brief Whether configuration-file was given.  */
  unsigned int ticket_file_given ;	/**< @brief Whether ticket-file was given.  */
  unsigned int library_options_given ;	/**< @brief Whether library-options was given.  */
  unsigned int quiet_given ;	/**< @brief Whether quiet was given.  */
  unsigned int system_configuration_file_given ;	/**< @brief Whether system-configuration-file was given.  */
  unsigned int ticket_write_file_given ;	/**< @brief Whether ticket-write-file was given.  */
  unsigned int verbose_given ;	/**< @brief Whether verbose was given.  */

  char **inputs ; /**< @brief unamed options (options without names) */
  unsigned inputs_num ; /**< @brief unamed options number */
} ;

/** @brief The additional parameters to pass to parser functions */
struct cmdline_parser_params
{
  int override; /**< @brief whether to override possibly already present options (default 0) */
  int initialize; /**< @brief whether to initialize the option structure gengetopt_args_info (default 1) */
  int check_required; /**< @brief whether to check that all required options were provided (default 1) */
  int check_ambiguity; /**< @brief whether to check for options already specified in the option structure gengetopt_args_info (default 0) */
  int print_errors; /**< @brief whether getopt_long should print an error message for a bad option (default 1) */
} ;

/** @brief the purpose string of the program */
extern const char *gengetopt_args_info_purpose;
/** @brief the usage string of the program */
extern const char *gengetopt_args_info_usage;
/** @brief all the lines making the help output */
extern const char *gengetopt_args_info_help[];

/**
 * The command line parser
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser (int argc, char **argv,
  struct gengetopt_args_info *args_info);

/**
 * The command line parser (version with additional parameters - deprecated)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param override whether to override possibly already present options
 * @param initialize whether to initialize the option structure my_args_info
 * @param check_required whether to check that all required options were provided
 * @return 0 if everything went fine, NON 0 if an error took place
 * @deprecated use cmdline_parser_ext() instead
 */
int cmdline_parser2 (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  int override, int initialize, int check_required);

/**
 * The command line parser (version with additional parameters)
 * @param argc the number of command line options
 * @param argv the command line options
 * @param args_info the structure where option information will be stored
 * @param params additional parameters for the parser
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_ext (int argc, char **argv,
  struct gengetopt_args_info *args_info,
  struct cmdline_parser_params *params);

/**
 * Save the contents of the option struct into an already open FILE stream.
 * @param outfile the stream where to dump options
 * @param args_info the option struct to dump
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_dump(FILE *outfile,
  struct gengetopt_args_info *args_info);

/**
 * Save the contents of the option struct into a (text) file.
 * This file can be read by the config file parser (if generated by gengetopt)
 * @param filename the file where to save
 * @param args_info the option struct to save
 * @return 0 if everything went fine, NON 0 if an error took place
 */
int cmdline_parser_file_save(const char *filename,
  struct gengetopt_args_info *args_info);

/**
 * Print the help
 */
void cmdline_parser_print_help(void);
/**
 * Print the version
 */
void cmdline_parser_print_version(void);

/**
 * Initializes all the fields a cmdline_parser_params structure 
 * to their default values
 * @param params the structure to initialize
 */
void cmdline_parser_params_init(struct cmdline_parser_params *params);

/**
 * Allocates dynamically a cmdline_parser_params structure and initializes
 * all its fields to their default values
 * @return the created and initialized cmdline_parser_params structure
 */
struct cmdline_parser_params *cmdline_parser_params_create(void);

/**
 * Initializes the passed gengetopt_args_info structure's fields
 * (also set default values for options that have a default)
 * @param args_info the structure to initialize
 */
void cmdline_parser_init (struct gengetopt_args_info *args_info);
/**
 * Deallocates the string fields of the gengetopt_args_info structure
 * (but does not deallocate the structure itself)
 * @param args_info the structure to deallocate
 */
void cmdline_parser_free (struct gengetopt_args_info *args_info);

/**
 * Checks that all the required options were specified
 * @param args_info the structure to check
 * @param prog_name the name of the program that will be used to print
 *   possible errors
 * @return
 */
int cmdline_parser_required (struct gengetopt_args_info *args_info,
  const char *prog_name);


#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* SHISHI_CMD_H */
