/***************************************************************************
                          album.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ALBUM_H
#define ALBUM_H

#include "listitem.h"

#include <qfile.h>
#include <qptrlist.h>

class Directory;
class DirectoryView;
class ImageViewer;
class ImageListView;
class MainWindow;
class AlbumImageFileIconItem;

class QFile;

/**
  *@author Richard Groult
  */

class Album : public ListItem
{
public: 
	Album(Directory * parent, QString filename,
		DirectoryView* dirView, ImageViewer * iv,
		ImageListView * imageList, MainWindow * mw);
	~Album();
	
	void addURL(QStringList lst);
	QString pathTo(QString fileName);
	
	virtual  void load (bool refresh=true);
	virtual  void unLoad ();
	
	virtual  ListItem* find (const char *);
	virtual  void goTo (const char *dest);

	virtual  void removeImage ( ListItem* imf);
	virtual  void removeImage (AlbumImageFileIconItem * imf);

	void create(QString dirName);
	bool add(QStringList uris);
	bool acceptDrop(){return true;};
	
	virtual  void rename(QString newDirName);
	virtual  void rename();
	void updateChildren();

	virtual  void properties();
	
protected:
	QPtrList < AlbumImageFileIconItem > list;
	void init();
};

#endif
