/***************************************************************************
                          compressedfileitem.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult, 2003 OGINO Tomonori
    email                : rgroult@jalix.org ogino@nn.iij4u.or.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "compressedfileitem.h"

#include "extract.h"
#include "directoryview.h"
#include "imageviewer.h"
#include "compressedimagefileiconitem.h"
#include "imagelistview.h"
#include "mainwindow.h"
#include "directoryview.h"
#include "directory.h"

#include <qlistview.h>
#include <qfileinfo.h>
#include <qtextcodec.h>

#include <kprocess.h>
#include <kiconloader.h>
#include <kio/job.h>
#include <klocale.h>
#include <kapplication.h>
#include <konq_operations.h>


CompressedFileItem::CompressedFileItem (Directory *parent, QString filename, QString path,
					MainWindow *mw,	DirectoryView* dirView,
					ImageViewer * iv, ImageListView * imageList)
	:ListItem(parent, filename, dirView, iv, imageList, mw)
{
	full.append (path);
	full.append (filename);

	list.setAutoDelete (TRUE);
	QFileInfo * info = new QFileInfo (fullName());
	
	size = QString("%1").arg(info->size());
	extension = info->extension(false);

	setPixmap(0, BarIcon(KMimeType::iconForURL(fullName()), KIcon::SizeSmall ));
	setDropEnabled (FALSE);
}


void
CompressedFileItem::removeImage (CompressedImageFileIconItem * imf)
{
	kdDebug() << __FILE__ << __LINE__ << " CompressedFileItem::removeImage (CompressedImageFileIconItem * imf)" << endl;
	if (list.findRef (imf))
	{
		list.remove(imf);
	}
}

void
CompressedFileItem::load (bool refresh)
{
	if(!imageList->hasImages()) iv->loadImage();
	KApplication::setOverrideCursor (waitCursor); // this might take time
	mw->setMessage(i18n("Loading '")+text(0)+"'...");

	Extract *extract = new Extract (fullName());
	QStringList::iterator s;
	CompressedImageFileIconItem *item;

	for (s = extract->files.begin(); s != extract->files.end(); ++s)
	{
		if(dirView->isImage(new QFileInfo(*s)))
		    {
			item = new CompressedImageFileIconItem (
						imageList,
						this,
						text(0),
						*s,
						*s,
						iv);
			list.append (item);
			mw->slotAddImage();
		}
	}
	KApplication::restoreOverrideCursor ();       // restore original cursor
	
	if(refresh)
	{
		imageList->slotLoadFirst();
	}
	mw->setMessage(i18n("Ready"));
}

void
CompressedFileItem::unLoad()
{
	if(mw->preview())
		imageList->stopLoading();
	
	KShellProcess *proc = new KShellProcess ();

	QString dest;
	dest.setNum (getpid ());
	dest.prepend ("/tmp/.qlist");
	dest.append ("/");
	dest.append (KShellProcess::quote(text (0)));

	*proc << "rm -f -r";
	*proc <<  dest;
	proc->start (KShellProcess::Block);

	mw->slotRemoveImage(list.count());
	list.clear ();
	iv->updateStatus ();
	imageList->slotUpdate();
	if(mw->preview())
		imageList->slotLoadFirst();
}

QString
CompressedFileItem::key (int column, bool ascending) const
{
	if(column!=1)
		return KListViewItem::key(column, ascending).lower();
	else
		return  QString("ZZ")+text(1);
}

void
CompressedFileItem::updateChildren()
{
	kdDebug() << __FILE__ << __LINE__ << " begin  updateChildren() de "<< fullName() << endl;
	full = parent()->fullName()+f.name();
	kdDebug() << __FILE__ << __LINE__ << " end  updateChildren() de "<< fullName() << endl;
}

void
CompressedFileItem::rename(QString newDirName)
{
	kdDebug() << __FILE__ << __LINE__ << " begin CompressedFileItem::rename(QString newDirName)" << newDirName << endl;
	KonqOperations::rename(mw, getURL(), newDirName);
	f.setName(newDirName);
	updateChildren();
	
	repaint();
	kdDebug() << __FILE__ << __LINE__ << " end CompressedFileItem::rename(QString newDirName)=" << fullName() << endl;
}

void
CompressedFileItem::rename()
{
	kdWarning() << __FILE__ << __LINE__ << " TODO CompressedFileItem::rename()" << endl;
}

void
CompressedFileItem::properties()
{
	kdWarning() << __FILE__ << __LINE__ << " TODO CompressedFileItem::properties()" << endl;
}

void
CompressedFileItem::create(QString )
{
	kdWarning() << __FILE__ << __LINE__ << " TODO CompressedFileItem::create(QString )" << endl;
}

