/***************************************************************************
                          compressedfileitem.h -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __COMPRESSEDFILE_H__
#define __COMPRESSEDFILE_H__

#include "listitem.h"

#include <qfile.h>
#include <qptrlist.h>

class CompressedImageFileIconItem;
class ImageListView;
class ImageViewer;
class Directory;
class DirectoryView;
class MainWindow;

class QFile;
class QString;

class CompressedFileItem : public ListItem
{
public:
	CompressedFileItem (Directory * parent, QString filename, QString path,
		      MainWindow *mw, DirectoryView* dirView,
		      ImageViewer * iv, ImageListView * imageList);

	virtual ~CompressedFileItem (){};

	virtual void load (bool refresh=true);
	virtual void unLoad ();
	virtual void removeImage (CompressedImageFileIconItem * imf);
	
	virtual void rename(QString newDirName);
	virtual void rename();
	virtual void properties();
	virtual void create(QString dirName);
	bool acceptDrop(){return false;};

	virtual QString key (int column, bool ascending) const;

private:
	QPtrList < CompressedImageFileIconItem > list;
	void updateChildren();	
};


#endif
