/***************************************************************************
                          confshowimg.h -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef __CONFSHOWIMG_H__
#define __CONFSHOWIMG_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kdialogbase.h>

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QCheckBox;
class QComboBox;
class QGroupBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QRadioButton;
class QSlider;
class QFrame;
class QButtonGroup;

class KColorButton;
class KListView;

class ConfShowImg : public KDialogBase
{
Q_OBJECT

public:
	ConfShowImg(QWidget *parent);
	virtual ~ConfShowImg();

	void initFiling(int openType, QString openDir, bool showSP);
	void initMiscellaneous(bool storeth, bool showf, bool useexif, bool smooth, bool loadfim, bool sHDir, bool sHFile, bool sDir, bool sAll, bool sprelodim);
	void initColor(QColor bgcolor, int gray);
	void initSlideshow(int type, int time);
	void initFullscreen(bool showToolbar, bool showStatusbar);
	void initProperties(bool sMeta, bool sHexa);
	void initPlugins(QStringList lista, QStringList listl);

	QColor getColor();
	int getGrayscale();

	bool checkTrash();
	bool checkDelete();
	bool checkShred();
	int getOpenDirType();
	QString getOpenDir();
	bool checkshowSP();

	bool getStoreth();
	bool getShowFrame();
	bool getUseEXIF();
	bool getSmooth();
	bool getShowHiddenDir();
	bool getShowHiddenFile();
	bool getLoadFirstImage();
	bool getShowDir();
	bool getShowAll();
	bool getPreloadIm();

	int getSlideshowTime();
	int getSlideshowType();

	void setLayout(int l);
	int getLayout();

	bool getShowToolbar();
	bool getShowStatusbar();

	bool getShowMeta();
	bool getShowHexa();

	QStringList getPluginList();

protected slots:
	void slotChangeTime(int);
	void setGrayscale(int);
	void chooseDir();

protected:
	void addPage1();
	void addPage2();
	void addPage3();
	void addPage4();
	void addPage5();
	void addPage6();
	void addPage7();
	void addPage8();

	QFrame *page1, *page2, *page3, *page4, *page5, *page6, *page7, *page8;

	QPixmap *image0	;
	QGroupBox* GroupBox2;
	QSlider* timeSlide;
	QLineEdit* timeLine;
	QLabel* timeLabel;
	QButtonGroup* ButtonGroup3;
	QButtonGroup* fsButtonGroup;
	QCheckBox* wraparound;
	QFrame* Line1;
	QRadioButton* backward;
	QRadioButton* random;
	QRadioButton* forward;
	QComboBox* ComboBox1;
	QGroupBox* GroupBox18;

    QGroupBox* groupBoxTab;
    QCheckBox* showMeta;
    QCheckBox* showHexa;
    QHBoxLayout* page7Layout;
    QVBoxLayout* layoutTab;
    QGridLayout* groupBoxTabLayout;
    QVBoxLayout* layoutCheckBoxTab;




	QLabel* TextLabel4;
	QButtonGroup* ButtonGroup2;
	QRadioButton* RadioButton5;
	QPushButton* PushButton1;
	QRadioButton* RadioButton4;
	KColorButton* color;
	QGroupBox* GroupBox6;
	QCheckBox* grayCheck;
	QSlider* graySlider;
	QLabel* PixmapLabel1;
	QRadioButton* radioButton_1;
	QRadioButton* radioButton_2;
	QRadioButton* radioButton_3;
	QRadioButton* radioButton_4;
	QRadioButton* radioButton_5;

	QCheckBox* sStatusbar;
	QCheckBox* sToolbar;

//page1
 protected:
    QButtonGroup* GroupBox13;
    QRadioButton* openHome;
    QRadioButton* openLast;
    QRadioButton* open_custom;
    QLineEdit* LineEdit2;
    QPushButton* chooseButton;
    QCheckBox* showSP;

protected:
    QHBoxLayout* FilingLayout;
    QVBoxLayout* page1Layout;
    QVBoxLayout* GroupBox8Layout;
    QVBoxLayout* GroupBox13Layout;
    QHBoxLayout* layout1_2;



//page2
protected:
    QGroupBox* groupboxThumbnails;
    QCheckBox* storethCheck;
    QCheckBox* showFrame;
    QCheckBox* useEXIF;
    QGroupBox* groupBox3;
    QCheckBox* smoothCheck;
    QGroupBox* groupBox4;
    QCheckBox* prelodimCheck;
    QCheckBox* loadfirstimCheck;
    QGroupBox* groupBox5;
    QCheckBox* sHiddenDirCheck;
    QCheckBox* sHiddenFileCheck;
    QCheckBox* sAllCheck;
    QCheckBox* sDirCheck;

protected:
    QGridLayout* Form1Layout;
    QVBoxLayout* page2Layout;
    QGridLayout* groupboxThumbnailsLayout;
    QHBoxLayout* layout6;
    QGridLayout* groupBox3Layout;
    QVBoxLayout* groupBox4Layout;
    QGridLayout* groupBox5Layout;

//page8
protected:
    KListView* pluginList;
    QVBoxLayout* Form1Layoutp8;
};

#endif
