/***************************************************************************
                          directory  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __DIRECTORY_H__
#define __DIRECTORY_H__

#include "listitem.h"

#include <qfile.h>
#include <qptrlist.h>

class ImageListView;
class ImageFileIconItem;
class DirFileIconItem;
class FileIconItem;
class ImageViewer;
class MainWindow;
class DirectoryView;

class QFile;

class KAction;

class Directory:public ListItem
{
public:
	Directory (DirectoryView* parent, ImageViewer * iv, ImageListView * imageList, MainWindow * mw);
	Directory (Directory * parent, QString filename, DirectoryView* dirView, ImageViewer * iv,  ImageListView * imageList, MainWindow * mw);
	~Directory();

	QString text (int column) const;

	QString path ();

	void setOpen (bool);
	void recursivelyOpen();

	void setup ();

	void load (bool refresh=true);
	void unLoad ();
	bool refresh(bool preview=true);

	virtual ListItem *find (QString);
	void goTo (QString dest);
	void loadFirst ();

	void removeImage (ImageFileIconItem * imf);

	void createDir(QString dirName);
	void createAlbum(QString albumName);
	void rename(QString newDirName);
	void rename();
	void updateChildren();
	
	void properties();

protected:
	void init();

private:
	bool readable;
	int size;
	
	QString newDirName;
	QPtrList < FileIconItem > list;
};


#endif
