/***************************************************************************
                          directoryview.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#include "directoryview.h"

#include "describeAlbum.h"
#include "directory.h"
#include "replace.h"
#include "imageviewer.h"
#include "imagefileiconitem.h"
#include "compressedimagefileiconitem.h"
#include "imagelistview.h"
#include "mainwindow.h"
#include "album.h"

#ifdef HAVE_LIBDIGIKAM
#include <digikam/albuminfo.h>
#endif

#include <qstring.h>
#include <qfile.h>
#include <qptrlist.h>
#include <qtimer.h>
#include <qprogressdialog.h>
#include <qdropsite.h>
#include <qdragobject.h>
#include <qtooltip.h>
#include <qdatastream.h>
#include <qmessagebox.h>
#include <qprogressdialog.h>
#include <qdir.h>
#include <qclipboard.h>
#include <qpopupmenu.h>

#include <kurlrequesterdlg.h>
#include <kio/job.h>
#include <kio/jobclasses.h>
#include <kmessagebox.h>
#include <klineeditdlg.h>
#include <kglobalsettings.h>
#include <kpropertiesdialog.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kiconloader.h>
#include <klistview.h>
#include <kdirwatch.h>
#include <kapplication.h>
#include <kaction.h>
#include <kpopupmenu.h>
#include <konq_operations.h>
#include <kurldrag.h>
#include <kimageio.h>

DirectoryView::DirectoryView (QWidget * parent, ImageViewer * iv, ImageListView* imageList, MainWindow * mw)
:KListView (parent, "DirectoryView")
{

	this->iv = iv;
	this->imageList = imageList;
	this->mw = mw;

	addColumn (i18n("Name"));
	addColumn (i18n("Type"));
	addColumn (i18n("Size"));

	setColumnAlignment( 1, Qt::AlignLeft );
	setColumnAlignment( 2, Qt::AlignRight );

	setAllColumnsShowFocus(true);
	setShowSortIndicator(true);
	setFullWidth(true);
	setResizeMode( KListView::LastColumn );
	setShowToolTips(true);
	setSelectionModeExt (KListView::Extended);
	setAcceptDrops (true);
	clearWState( WState_Polished );

	setSorting (1);
	sort();

	setShowHiddenDir(false);
	dropping = false;

	currentOperation=NONE;
	autoSkip=false;
	replaceAll=false;
	currentOperation=NONE;
	fileToProcess=NULL;
	destDir=NULL;
	clickedItem=NULL;

	image_pixmap=NULL;

	autoopenTime = 750;
	autoopen_timer = new QTimer (this);
	connect (autoopen_timer, SIGNAL (timeout ()),
			this, SLOT (openFolder ()));

	copyProgress=new QProgressDialog (mw, "copyProgress", true);

	dirWatch = new KDirWatch();
	connect(dirWatch, SIGNAL(dirty (const QString&)),
			mw, SLOT(slotDirChange(const QString&)));
	startWatchDir();

	connect(this, SIGNAL(selectionChanged ()),
			SLOT(slotSelectionChanged ()));
}


void
DirectoryView::initMenu(KActionCollection *actionCollection)
{
	this->actionCollection=actionCollection;

	popup = new QPopupMenu();
	KPopupMenu *popupnew = new KPopupMenu ();
		actionCollection->action("editdirnew")->plug(popupnew);
		actionCollection->action("editalbumnew")->plug(popupnew);
	popup->insertItem(i18n("Create &New"), popupnew);
	actionCollection->action("dirRecOpen")->plug(popup);
	popup->insertSeparator();
	actionCollection->action("editdircopy")->plug(popup);
	actionCollection->action("editdirmove")->plug(popup);
	actionCollection->action("editdirrename")->plug(popup);
	actionCollection->action("editdirtrash")->plug(popup);
	actionCollection->action("editdirdelete")->plug(popup);
	popup->insertSeparator();
	actionCollection->action("editdirpaste files")->plug(popup);
	popup->insertSeparator();
	actionCollection->action("Dir Info")->plug(popup);
	actionCollection->action("Dir Properties")->plug(popup);
}


ListItem*
DirectoryView::getDir(QString dirfullname)
{
	QString res(dirfullname);
	if(res[res.length()-1]=='/')
		res = res.left(res.length()-1);

	int pos = res.find ("/");
	ListItem *ssrep;
	res = res.right(res.length () - pos - 1);
	pos = res.find ("/");
	ssrep = (Directory*)firstChild();

	while (pos != -1 && ssrep!=NULL)
	{
		ssrep = ssrep->find (res.left (pos));
		res =res.right(res.length () - pos - 1);
		if (ssrep)
			pos = res.find ("/");
		else
			break;
	}
	if(!res.isEmpty() && ssrep)
		ssrep = ssrep->find(res);

	return ssrep;
}

void
DirectoryView::removeDir(QString dirfullname)
{
	ListItem * item = getDir(dirfullname);
	if(item)
	{
		if(item->isSelected()) mw->goUp();
		delete(getDir(dirfullname));
	}
}


void
DirectoryView::slotDirInfo()
{
	if(clickedItem)
	{
		   DescribeAlbum(mw, ((Directory*)clickedItem)->fullName(), "IDirInfo", true).exec();
	}
}

void
DirectoryView::slotDirProperty()
{
	if(clickedItem)
	{
		KApplication::setOverrideCursor (waitCursor);
		//KFileItem *item = new KFileItem(( ((ListItem*)clickedItem)->getURL()), KFileItem::Unknown/*"inode/directory"*/, S_IFDIR);        	
		KFileItem *item = new KFileItem(KFileItem::Unknown, KFileItem::Unknown, 
				(((ListItem*)clickedItem)->getURL()), true);
        	KPropertiesDialog *prop	= new KPropertiesDialog( item,
			mw->iv, "KPropertiesDialog",
			true, false);

		KApplication::restoreOverrideCursor ();
		prop->exec();
	}
}

bool
DirectoryView::isDropping()
{
	return dropping;
}

void
DirectoryView::slotShowItem (QListViewItem * item)
{
	ensureItemVisible(item);
}

void
DirectoryView::startWatchDir(QString dir)
{
	dirWatch->stopScan();
	dirWatch->addDir(dir);
	dirWatch->startScan();
}

void DirectoryView::stopWatchDir(QString dir)
{
	dirWatch->removeDir(dir);
}

void
DirectoryView::startWatchDir()
{
	  dirWatch->startScan();
}



void
DirectoryView::stopWatchDir()
{
	dirWatch->stopScan();
}


void
DirectoryView::updateActions(ListItem *item)
{
	if(!item) return;

	bool enableAction;
	if(item->text (1) != i18n("Directory"))
	{
		enableAction=false;
	}
	else
	{
		enableAction=true;
	}
	actionCollection->action("editpaste")->setEnabled(enableAction);
	actionCollection->action("editdirnew")->setEnabled(enableAction);
	actionCollection->action("editalbumnew")->setEnabled(enableAction);
	actionCollection->action("dirRecOpen")->setEnabled(enableAction);
	actionCollection->action("editdircopy")->setEnabled(enableAction);
	actionCollection->action("editdirmove")->setEnabled(enableAction);
}


void
DirectoryView::slotSelectionChanged ()
{
	if(isDropping()) return;

//	kdDebug() << __FILE__ << __LINE__ << " DirectoryView::selectionChanged ()"   << endl;
	updateActions((ListItem*)currentItem());

#ifdef HAVE_LIBDIGIKAM
	mAlbumMan = Digikam::AlbumManager::instance();
	mAlbumMan->setLibraryPath( ((ListItem*)currentItem())->path());

	Digikam::AlbumInfo *album = mAlbumMan->findAlbum(((ListItem*)currentItem())->name());
	if(!album) album = new Digikam::AlbumInfo(mAlbumMan, ((ListItem*)currentItem())->name());
	mAlbumMan->setCurrentAlbum(album);
#endif
//	kdDebug() << __FILE__ << __LINE__ << " DirectoryView::selectionChanged ()"   << endl;
}



void
DirectoryView::contentsDragEnterEvent (QDragEnterEvent * event)
{
	dropping = true;
	setSelectionMode (QListView::Single);
	oldCurrent = selectedItem ();
	if (QTextDrag::canDecode (event))
	{
		event->acceptAction ();
		QListViewItem *i = itemAt (contentsToViewport (event->pos ()));
		if (i)
		{
			dropItem = i;
			autoopen_timer->start (autoopenTime);
		}
	}
}

void
DirectoryView::contentsDragLeaveEvent (QDragLeaveEvent *)
{
	autoopen_timer->stop ();
	dropItem = NULL;
	setMultiSelection (false);
	setCurrentItem (oldCurrent);
	setSelected (oldCurrent, TRUE);
	setSelectionMode (QListView::Extended);
	dropping = false;
}

void
DirectoryView::contentsDragMoveEvent (QDragMoveEvent * e)
{
	if(!dropping)
		return;

	if (!QTextDrag::canDecode (e))
	{
		e->ignore ();
		return;
	}

	QListViewItem *i = itemAt (contentsToViewport ( e->pos ()));
	if (i)
	{
		setSelected (i, TRUE);
		e->acceptAction ();
		if (i != dropItem)
		{
			autoopen_timer->stop ();
			dropItem = i;
			autoopen_timer->start (autoopenTime);
		}
	}
	else
	{
		e->ignore ();
		autoopen_timer->stop ();
		dropItem = NULL;
	}
}


void
DirectoryView::contentsDropEvent (QDropEvent * event)
{
	kdDebug() << __FILE__ << __LINE__ << " DirectoryView::contentsDropEvent (QDropEvent * event)"  << endl;
	autoopen_timer->stop ();
	setSelected (dropItem, false);

	if ( !QUriDrag::canDecode(event) )
	{
		event->ignore();
	}
	else
	{
		event->acceptAction(true);
		imageList->stopLoading();

		QImage image;
		QStrList lst;

		if (QUriDrag::decode (event, lst))
		{
			qWarning("%s %d DirectoryView::contentsDropEvent (QDropEvent * event)",__FILE__,__LINE__);
			if (((ListItem*) dropItem)->text (1) == i18n("Album"))
			{
				((Album*)dropItem)->addURL(QStringList::fromStrList(lst));
			}
			else
			if (((ListItem*) dropItem)->text (1) != i18n("Directory"))
			{
				dropItem = NULL;
				KMessageBox::error (this, i18n("Adding file in an archive is not yet implemented"), i18n("File(s) copy/move"));
			}
			else
			if(!QFileInfo(((Directory*)dropItem)->fullName()).isWritable ())
			{
				dropItem = NULL;
				KMessageBox::error (this, i18n("The destination directory is not writable"), i18n("File(s) copy/move"));
			}
			else
			switch (event->action ())
			{
				case QDropEvent::Copy:
				case QDropEvent::Move:
				{
					if(!dropItem)
					{
						qWarning("%s %d ERROR dropItem est null !!!", __FILE__,__LINE__);
		    				return;
					}
					destDir=new QString( ((Directory*)dropItem)->fullName());

					event->acceptAction();
					contentsDragLeaveEvent(NULL);

					if (event->action () == QDropEvent::Move)
					{
						move(QStringList::fromStrList(lst), *destDir);
					}
					else
					{
						copy(QStringList::fromStrList(lst), *destDir);
					}
				}
		 		return;
		 		default:return;
			}
		}
	}

	setCurrentItem (oldCurrent);
	setSelected (oldCurrent, TRUE);

	dropping = false;
	setSelectionMode (QListView::Extended);

}


QString
DirectoryView::getDestName(QString orgFile, QString destDir)
{
	QString fdest(destDir);

	kdDebug() << __FILE__ << __LINE__ << " DirectoryView::getDestName(QString orgFile, QString destDir) : " << orgFile <<" " << fdest << endl;
	if(replaceAll)
	{
		return  fdest;
	}
	else
	{
	ConfirmReplace cr(copyProgress, "ConfirmReplace", orgFile, fdest);
	switch (cr.exec())
	{
		case 1 : /*Replace()*/
			return fdest;
           	        break;

		case 2 : /*slotSkip*/
			autoSkip=true;
			return NULL;
			break;

		case 3 :/*slotReplaceAll*/
			replaceAll=true;
			return fdest;
			break;

		case 4 : /*slotCancel*/
			setMultiSelection (false);
			clearSelection ();

			setCurrentItem (oldCurrent);
			setSelected (oldCurrent, TRUE);

			setSelectionMode (QListView::Extended);
			dropping = false;

			currentOperation=NONE;

		        return QString();
			break;

		case 5 : /*slotRename*/
			return cr.getRename();
			break;
		}
	}

	return fdest;
}

void
DirectoryView::copyNext()
{
	kdDebug() << __FILE__ << __LINE__ << " DirectoryView::copyNext()"   << endl;
/*
	if(!fileToProcess->isEmpty())
	{
		copyProgress->setProgress(totalFiles-fileToProcess->count());
		QString *dest=getDestName(fileToProcess->first());

		if(dest)
		{
			copyProgress->setProgress(totalFiles-fileToProcess->count());
			copyProgress->setLabelText(i18n("Copy <b>`%1'</b>").arg(shrinkdn(*dest)));
		}

		while( (dest==NULL) && (!fileToProcess->isEmpty()) && (currentOperation!=NONE))
		{
			fileToProcess->removeFirst();
			if(!fileToProcess->isEmpty()) dest=getDestName(fileToProcess->first());
		}
		if(!fileToProcess->isEmpty())
		{
			if(currentOperation!=NONE)
			{
				QString *org=fileToProcess->first();
				copy(org, dest);
			}
		}
		else
		{
			currentOperation=NONE;
		}
	}
	else
	{
		currentOperation=NONE;
	}

	if(currentOperation==NONE)
	{
		currentOperation=NONE;
		delete(fileToProcess); fileToProcess=NULL;

		autoSkip=false;
  		replaceAll=false;

		copyProgress->setProgress(copyProgress->totalSteps());
		copyProgress->hide();
		delete(copyProgress);

		currentItemName=QString();

		delete(destDir); destDir=NULL;

		dropping = false;
		setSelectionMode (QListView::Extended);

		mw->slotRefresh();
		imageList->slotLoadFirst();
	}
	*/
}

void
DirectoryView:: moveNext()
{
	kdDebug() << __FILE__ << __LINE__ << " DirectoryView::moveNext()"   << endl;
/*
	if(!fileToProcess->isEmpty())
	{
		QString *dest=getDestName(fileToProcess->first());
		if(dest)
		{
			copyProgress->setProgress(totalFiles-fileToProcess->count());
			copyProgress->setLabelText(i18n("Move <b>`%1'</b>").arg(shrinkdn(*dest)));
		}
		while( (dest==NULL) && (!fileToProcess->isEmpty()) && (currentOperation!=NONE))
		{
			fileToProcess->removeFirst();
			if(!fileToProcess->isEmpty()) dest=getDestName(fileToProcess->first());
		}
		if(!fileToProcess->isEmpty())
		{
			if(currentOperation!=NONE)
			{
				QString *org=fileToProcess->first();
				int pos = org->findRev ("/");
				const QString itfi(org->right (org->length () - (pos + 1)));
				FileIconItem *fi = imageList->findItem (itfi);
				if(fi)
				{
					FileIconItem *next=fi->nextItem();
					if(next)
						currentItemName=next->text();
					else
					{
						next=fi->prevItem();
						if(next)
							currentItemName=next->text();
						else
							currentItemName=QString();
					}
				}
				else
					currentItemName=QString();
				if(fi && !fi->isMovable())
				{
					copy(org, dest);
				}
				else
				{
					move(org, dest);
				}
			}
		}
		else
		{
			currentOperation=NONE;
		}
	}
	else
	{
		currentOperation=NONE;
	}

	if(currentOperation==NONE)
	{
		currentOperation=NONE;
		delete(fileToProcess); fileToProcess=NULL;

		autoSkip=false;
  		replaceAll=false;

		copyProgress->setProgress(copyProgress->totalSteps());
		copyProgress->hide();
		delete(copyProgress);

		imageList->setCurrentItemName(currentItemName);

		currentItemName=QString();

		delete(destDir); destDir=NULL;

		//
		setCurrentItem (oldCurrent);
		setSelected (oldCurrent, TRUE);

		dropping = false;
		setSelectionMode (QListView::Extended);

		mw->slotRefresh();
		imageList->slotLoadFirst();
	}
*/
}

void
DirectoryView::contentsMouseReleaseEvent(QMouseEvent* e)
{
	if (e->button () == RightButton)
	{
		clickedItem = itemAt(contentsToViewport(e->pos()));
		if (clickedItem->text (1) == i18n("Directory"))
		{
			popup->exec(e->globalPos());
		}
	}
}

void
DirectoryView::contentsMousePressEvent(QMouseEvent * e)
{
	if (e->button () == RightButton)
	{
		clickedItem = itemAt(contentsToViewport(e->pos()));
		updateActions((ListItem*)clickedItem);
		popup->exec(e->globalPos());
		updateActions((ListItem*)currentItem());
	}
	else
	if (e->button () == LeftButton)
		QListView::contentsMousePressEvent (e);

	else
	if (e->button () == MidButton)
		contentsMouseDoubleClickEvent(e);

}

void
DirectoryView::contentsMouseDoubleClickEvent ( QMouseEvent * e )
{
	QListViewItem *item=itemAt(contentsToViewport(e->pos()));
	if(!item)
		return;
	if(item->isOpen())
		item->setOpen(false);
	else
		item->setOpen(true);
}

void
DirectoryView::copyingDirDone( KIO::Job *job)
{
	kdDebug() << __FILE__ << __LINE__ << " DirectoryView::copyingDirDone( KIO::Job *job)"   << endl;
	if(job->error()==0)
	{
		//pas d'erreurs
		ListItem* dest=getDir(dirDest);
		if(dest)
		{
			if(!dest->isOpen())
			{
				//rien a faire
			}
			else
			{
				QString name=QDir(dirOrg).dirName();
				if(!getDir(dirDest+name))
				{
					//ajout du rep
					if(dest->text(1)==i18n("Directory"))
					{
						(void)new Directory( (Directory*)dest, name, this, iv, imageList, mw);
					}
					dest->setExpandable(true);
				}
			}
		}
		else
		{
		}
	}
	else
	{
		//erreur
		job->showErrorDialog(copyProgress);
	}

}

void
DirectoryView::movingDirDone( KIO::Job *job)
{
	kdDebug() << __FILE__ << __LINE__ << " DirectoryView::movingDirDone( KIO::Job *job)"   << endl;
	if(job->error()==0)
	{
		//pas d'erreurs
		ListItem* dest=getDir(dirDest);
		if(dest)
		{
			if(!dest->isOpen())
			{
				//rien a faire
			}
			else
			{
				QString name=QDir(dirOrg).dirName();
				if(!getDir(dirDest+name))
				{
					//ajout du rep
					if(dest->text(1)==i18n("Directory"))
					{
						(void)new Directory( (Directory*)dest, name, this, iv, imageList, mw);
					}
					dest->setExpandable(true);
				}
			}
		}
		else
		{
		}
		ListItem *d = getDir(dirOrg);
		if(d)
		{
			d->setOpen(false);
			d->setSelected(false);
			delete(d);
		}
	}
	else
	{
		//erreur
		job->showErrorDialog(copyProgress);
	}
}

void
DirectoryView::copyingDone( KIO::Job *job)
{
	kdDebug() << __FILE__ << __LINE__ << " DirectoryView::copyingDone( KIO::Job *job)"   << endl;
	if(job->error()==0)
	{
		//pas d'erreurs
	}
	else
	{
		//erreur
		job->showErrorDialog();
	}
	fileToProcess->removeFirst();

	if(currentOperation==COPY)
		copyNext();
	else
		moveNext();
}

void
DirectoryView::movingDone( KIO::Job *job )
{
	kdDebug() << __FILE__ << __LINE__ << " DirectoryView::movingDone( KIO::Job *job )"   << endl;
	if(job->error()==0)
	{

	}
	else
	{
		//erreur
		kdDebug() << __FILE__ << __LINE__ << " DirectoryView::movingDone( KIO::Job *job )"<< endl;
		job->showErrorDialog();
	}
	fileToProcess->removeFirst();

	if(currentOperation==MOVE)
		moveNext();
	else
		copyNext();
}

bool
DirectoryView::copy (QString *dep, QString *dest)
{
	kdDebug() << __FILE__ << __LINE__ << " DirectoryView::copy (QString *dep, QString *dest)"   << endl;
	KURL urldep,urldest;
	urldep.setPath(*dep);
	urldest.setPath(*dest);
	KonqOperations::copy( mw, KonqOperations::COPY, urldep,  urldest);
	return true;
}


bool
DirectoryView::move (QString *dep, QString *dest)
{
	kdDebug() << __FILE__ << __LINE__ << " DirectoryView::move (QString *dep, QString *dest)" << *dep << " " << *dest << endl;

	KURL urldep,urldest;
	urldep.setPath(*dep);
	urldest.setPath(*dest);
	KonqOperations::copy( mw, KonqOperations::MOVE, urldep,  urldest);

	return true;
}



void
DirectoryView::copy(QStringList uris, QString dest)
{
	kdDebug() << __FILE__ << __LINE__ << " DirectoryView::copy (QStringList uris, QString dest)" <<  dest << endl;

	if(!QFileInfo(dest).isDir())
	{
		 KMessageBox::error(mw->iv, "<qt>"+i18n("Unable to copy files into '%1' because it is not a directory.").arg(dest)+"</qt>", i18n("File(s) copy"));
		 return;
	}






	////

	if(!QFileInfo(QFileInfo(dest).dirPath()).isWritable())
	{
		 KMessageBox::error(mw->iv, "<qt>"+i18n("The directory '<b>%1</b>' is not writable").arg(shrinkdn(dest))+"</qt>");
		 return;
	}


	//
	QString fdest = dest;
	QString orgFile = *uris.begin();
	int pos = orgFile.findRev ("/");
	fdest.append(orgFile.right(orgFile.length() - pos));
	if (QDir(orgFile) == QDir(fdest))
	{
		KMessageBox::error (mw, "<qt>"+i18n("Unable to copy <b>%1</b> because the destination file is the same").arg(orgFile)+"</qt>", i18n("File(s) copy"));
	}
	//
	QStringList listExist;
	QStringList list;
	for ( QStringList::Iterator it = uris.begin(); it != uris.end(); ++it ) {
        	fdest = dest;
		orgFile = *it;
		pos = orgFile.findRev ("/");
		fdest.append(orgFile.right(orgFile.length() - pos));

		if (QFileInfo(fdest).isDir() && QFile(QFileInfo(fdest).dirPath(true)+"/"+QFileInfo(fdest).fileName()).exists())
			listExist.append(*it);
		else
			list.append(*it);
	}

	//
	KURL urldest;
	urldest.setPath(dest);
	//
	/*
	for ( QStringList::Iterator it = listExist.begin(); it != listExist.end(); ++it ) {
        	fdest = dest;
		orgFile = KURL(*it).path();
		pos = orgFile.findRev ("/");
		fdest.append(orgFile.right(orgFile.length() - pos-1));

		QString rDest(getDestName(orgFile, fdest));

		kdDebug() << __FILE__ << __LINE__ << " DirectoryView::copy(QStringList uris, QString dest) : " << orgFile <<" ->" << rDest << endl;
		KIO::file_copy(KURL(rDest), urldest, -1, true);
		kdDebug() << __FILE__ << __LINE__ << " DirectoryView::copy(QStringList uris, QString dest) : " << orgFile <<" ->" << rDest << endl;

	}
	kdDebug() << __FILE__ << __LINE__ << " DirectoryView::copy(QStringList uris, QString dest)  " << endl;
	*/
	list += listExist;
	KonqOperations::copy( mw, KonqOperations::COPY, KURL::List(list),  urldest);



}


void
DirectoryView::move(QStringList uris, QString dest)
{
	if(!QFileInfo(QFileInfo(dest).dirPath()).isWritable())
	{
		 KMessageBox::error(mw->iv, "<qt>"+i18n("The directory '<b>%1</b>' is not writable").arg(shrinkdn(dest))+"</qt>");
		 return;
	}

	KURL urldest;
	urldest.setPath(dest);

	//
	QString fdest = dest;
	QString orgFile = *uris.begin();
	int pos = orgFile.findRev ("/");
	fdest.append(orgFile.right(orgFile.length() - pos));
	if (QDir(orgFile) == QDir(fdest))
	{
		KMessageBox::error (mw, "<qt>"+i18n("Can't copy <b>%1</b> because the destination file is the same").arg(orgFile)+"</qt>", i18n("File(s) copy"));
	}
	//
	QStringList listExist;
	QStringList list;
	for ( QStringList::Iterator it = uris.begin(); it != uris.end(); ++it ) {
        	fdest = dest;
		orgFile = *it;
		pos = orgFile.findRev ("/");
		fdest.append(orgFile.right(orgFile.length() - pos));

		if (QFile(QFileInfo(fdest).dirPath(true) + "/" + QFileInfo(fdest).fileName()).exists())
			listExist.append(*it);
		else
			list.append(*it);
	}

	list += listExist;
	KonqOperations::copy( mw, KonqOperations::MOVE, KURL::List(list),  urldest);
}



void
DirectoryView::openFolder ()
{
	autoopen_timer->stop ();
	if (dropItem && !dropItem->isOpen ())
	{
		setOpen(dropItem, true);
	}
}


void
DirectoryView::slotDirPasteFiles()
{
	kdDebug() << __FILE__ << __LINE__ << " DirectoryView::slotDirPasteFiles()"   << endl;
	KURL::List uris;
	if(KURLDrag::decode(KApplication::clipboard()->data(), uris))
	{
		if(!uris.isEmpty())
			copy(uris.toStringList(), ((Directory*)clickedItem)->fullName());
	}

}


void
DirectoryView::slotRename ()
{
  if(!clickedItem) clickedItem=currentItem();
	slotRename(clickedItem);
}


void
DirectoryView::slotRename (QListViewItem *item)
{
  if(!item) return;
	ListItem *dir=(ListItem*)item;
	QString fullname=dir->fullName();
	QString name=dir->name();
	bool ok;
	const QString newName(KLineEditDlg::getText("<qt>"+i18n("Rename '<b>%1</b>':").arg(shrinkdn(fullname)+"</qt>"),
				name,
				&ok, mw)
			.stripWhiteSpace());
	if(ok && newName!="" && newName!=name)
	{
		QString newDirName=dir->path()+"/"+newName;
		if(QFileInfo(newDirName).exists())
		{
			KMessageBox::error(mw->iv, "<qt>"+i18n("The directory '<b>%1</b>' already exists").arg(shrinkdn(newDirName))+"</qt>");
			return;
		}
		dir->rename(newName);
	}
}
void
DirectoryView::renameDone( KIO::Job *job)
{
	if(job->error()==0)
	{
		//pas d'erreurs
		((Directory*)clickedItem)->rename();
	}
	else
	{
		//erreur
		job->showErrorDialog(mw);
	}

}

void
DirectoryView::slotNewAlbum()
{
  if(!clickedItem) clickedItem=currentItem();
	slotNewAlbum(clickedItem);
}


void
DirectoryView::slotNewAlbum (QListViewItem *item)
{
  if(!item) return;
	bool ok;
	const QString newName(KLineEditDlg::getText("<qt>"+i18n("Create new album in <b>%1</b>").arg(shrinkdn(((Directory*)item)->fullName())+"</qt>"),
				i18n("Album"),
				&ok, mw).stripWhiteSpace());
	if(!ok || newName=="")
		return;

	KURL url("file:"+((Directory*)item)->fullName()+"/"+newName+".sia");
	if(url.fileName()!=NULL)
	{
		if(QFileInfo(url.path()).exists())
		{
		 	 KMessageBox::error(mw->iv, "<qt>"+i18n("The album <b>%1</b> already exists").arg(url.fileName())+"</qt>");
		 	 return;
		}
		((Directory*)item)->createAlbum(url.fileName());
	}
}


void
DirectoryView::slotNewDir()
{
	if(!clickedItem) clickedItem=currentItem();
	slotNewDir(clickedItem);
}

void
DirectoryView::slotNewDir (QListViewItem *item)
{
  if(!item) return;
	bool ok;
	const QString newName(KLineEditDlg::getText("<qt>"+i18n("Create new directory in <b>%1</b>").arg(shrinkdn(((Directory*)item)->fullName()))+"</qt>",
				i18n("Directory"),
				&ok, mw).stripWhiteSpace());
	if(!ok || newName=="")
		return;

	KURL url("file:"+((Directory*)item)->fullName()+"/"+newName);
	if(url.fileName()!=NULL)
	{
		if(QFileInfo(url.path()).exists())
		{
		 	 KMessageBox::error(mw->iv, "<qt>"+i18n("The directory '<b>%1</b>' already exists").arg(url.fileName())+"</qt>");
		 	 return;
		}
		((Directory*)item)->createDir(url.fileName());
	}
}

void
DirectoryView:: slotTrash()
{
	if(!clickedItem) clickedItem=currentItem();
	slotTrash(clickedItem);
}

void
DirectoryView::slotTrash (QListViewItem *item)
{
	if(!item) return;
	Directory *dir=(Directory*)item;
	//if(dir->isSelected()){ dir->setSelected(false); mw->goUp();}
	dir->setOpen(false);
	KonqOperations::del(mw, KonqOperations::TRASH, KURL("file:/"+dir->fullName()));
}


void
DirectoryView:: slotSuppr()
{
	if(!clickedItem) clickedItem=currentItem();
	slotSuppr(clickedItem);
}

void
DirectoryView::slotSuppr (QListViewItem *item)
{
	if(!item) return;
	Directory *dir=(Directory*)item;
	//if(dir->isSelected()){ dir->setSelected(false); mw->goUp();}
	dir->setOpen(false);
	KonqOperations::del(mw, KonqOperations::DEL, KURL("file:/"+dir->fullName()));
}

void
DirectoryView::recursivelyOpen()
{
  if(!clickedItem) clickedItem=currentItem();
	recursivelyOpen(clickedItem);
}

void
DirectoryView::recursivelyOpen(QListViewItem *item)
{
  if(!clickedItem) clickedItem=currentItem();
  if(!clickedItem) return;
	((Directory*)item)->recursivelyOpen();
}


void
DirectoryView::slotDirCopy()
{
	Directory* item=(Directory*)clickedItem;
	if(!item)
		return;

		QString destDir=KFileDialog::getExistingDirectory(lastDestDir.isEmpty()?item->fullName():lastDestDir,
									mw,
									i18n("Copy directory %1 to...").arg(shrinkdn(item->fullName())));

	if(!destDir.isEmpty())
	{
		lastDestDir=destDir;
		QString dest=destDir+"/";

		KURL
			urlorg("file:"+item->fullName()),
			urldest("file:"+dest);
		dirOrg=item->fullName();
		dirDest=dest;

		KIO::CopyJob *job = KIO::copy(urlorg, urldest, true);
		connect(job, SIGNAL(result( KIO::Job *)), this, SLOT(copyingDirDone( KIO::Job *)));
	}
}

void
DirectoryView::slotDirMove()
{
	Directory* item=(Directory*)clickedItem;
	if(!item)
		return;

		QString destDir=KFileDialog::getExistingDirectory(lastDestDir.isEmpty()?item->fullName():lastDestDir,
								mw,
								i18n("Move directory %1 to...").arg(shrinkdn(item->fullName())));

	if(!destDir.isEmpty())
	{
		lastDestDir=destDir;
		QString dest=destDir+"/"+item->text(0);
		if(QFileInfo(dest).exists())
		{
		 	 KMessageBox::error(mw->iv, "<qt>"+i18n("The directory '<b>%1</b>' already exists").arg(shrinkdn(dest))+"</qt>");
		 	 return;
		}

		if(!QFileInfo(QFileInfo(dest).dirPath()).isWritable())
		{
		 	 KMessageBox::error(mw->iv, "<qt>"+i18n("The directory '<b>%1</b>' is not writable").arg(shrinkdn(dest))+"</qt>");
		 	 return;
		}

		KURL
			urlorg("file:"+item->fullName()),
			urldest("file:"+dest);

		dirOrg=item->fullName();
		dirDest=destDir+"/";

		KIO::FileCopyJob *job = KIO::file_move(urlorg, urldest, -1, true, false, true);
		connect(job, SIGNAL(result( KIO::Job *)), this, SLOT(movingDirDone( KIO::Job *)));
	}
}

bool
DirectoryView::checkTrash()
{
	return trash;
}

void
DirectoryView::setCheckTrash(bool trash)
{
	this->trash=trash;
}

bool
DirectoryView::checkDelete()
{
	return del;
}

void
DirectoryView::setCheckDelete(bool del)
{
	this->del=del;
}

bool
DirectoryView::checkShred()
{
	return shred;
}

void
DirectoryView::setCheckShred(bool shred)
{
	this->shred=shred;
}


void
DirectoryView::setShowHiddenDir(bool show)
{
	__showHiddenDir__=show;
}

bool
DirectoryView::showHiddenDir()
{
	return __showHiddenDir__;
}

void
DirectoryView::setLoadFirstImage(bool load)
{
	__loadfirstimage__=load;
}

bool
DirectoryView::loadFirstImage()
{
	return __loadfirstimage__;
}


void
DirectoryView::setShowHiddenFile(bool show)
{
	__showHiddenFile__=show;
}

bool
DirectoryView::showHiddenFile()
{
	return __showHiddenFile__;
}

void
DirectoryView::setShowAllFile(bool show)
{
	__showAllFile__=show;
}
void
DirectoryView::setShowDir(bool show)
{
	__showDir__=show;
}

bool
DirectoryView::showDir()
{
	return __showDir__;
}


int
DirectoryView::filter ()
{
	int fil;
	if(showHiddenFile())
		fil = QDir::Hidden|QDir::Files;
	else
		fil = QDir::Files;
	if(showDir())
		fil = fil | QDir::Dirs;
	return fil;
}

bool
DirectoryView::isImage(QString info)
{
	QFileInfo *finfo = new QFileInfo(info);
	bool isImg=isImage(finfo);
	delete(finfo);
	return isImg;
}

bool
DirectoryView::isImage(QFileInfo *info)
{

	QString ext = info->extension( FALSE ).lower();
	return			(
				(ext == "jpg") ||  (ext == "jpeg") ||
					(ext == "gif") ||
					(ext == "png") ||
					(ext == "bmp") ||
					(ext == "tif") || (ext == "tiff")  ||
					(ext == "mng") ||
					(ext == "xpm") ||
					(ext == "xcf") ||
					(ext == "ico") ||
					(ext == "pbm") ||
					(ext == "eps") ||
					(ext == "krl") ||
					(ext == "pnm") ||
					(ext == "pgm") ||
					(ext == "ppm") ||
					(ext == "psd") ||
					(ext == "xbm") ||
					KImageIO::canRead(KImageIO::type(info->filePath ()))
					);

}


QString
DirectoryView::shrinkdn(QString str)
{
	const unsigned int len=20;
	if(str.length()<=len)
		return str;
	else
		return QString(str.left(len/2) + "..." + str.right(len/2));
}


QDragObject*
DirectoryView::dragObject ()
{
	return NULL;
}

#include "directoryview.moc"
