/***************************************************************************
                          dirfileiconitem.cpp  -  description
                             -------------------
    begin                : dim jun 23 2002
    copyright            : (C) 2002 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
 * Copyright (C) 2000 Richard Groult <rgroult@jalix.org>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "dirfileiconitem.h"

#include "imageloader.h"
#include "directory.h"
#include "imageviewer.h"
#include "imagelistview.h"
#include "imagefileinfo.h"
#include "exif.h"

#include <qdragobject.h>
#include <qdropsite.h>
#include <qlistview.h>
#include <qstring.h>
#include <qfile.h>
#include <qpopupmenu.h>
#include <qfileinfo.h>
#include <qdir.h>
#include <qapplication.h>
#include <qdragobject.h>
#include <qmessagebox.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <qiconview.h>
#include <qpixmapcache.h>
#include <qurloperator.h>

#include <kiconloader.h>
#include <kfilemetainfo.h>
#include <kapplication.h>
#include <kpixmap.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kglobalsettings.h>
#include <konq_operations.h>
#include <kio/job.h>

DirFileIconItem::DirFileIconItem (ImageListView *parent,
				Directory *parentDir,
				QString filename,
				QString path,
				ImageViewer *iv,
				QString description):
   FileIconItem (parent, path, filename, "folder", iv)
{
	this->imageList=parent;
	this->parentDir = parentDir;
	this->description=description;
	
	QIconViewItem::setText(f.name());

	full.append (path);
	full.append (filename);
	if(filename.compare("..")==0)
		setSelectable(false);
	else
		__ismovable__=true;

	setRenameEnabled(false);

	size = QString("%1").arg(full, 50).lower();

	QDateTime epoch( QDate( 1980, 1, 1 ) );
	date = QString("%1").arg(epoch.secsTo(QFileInfo(full).lastModified()), 8);

	extension = "000"+full;

	type = "dir";

	setName("DirFileIconItem");

	setPixmap(fileInfo()->pixmap(imageList->currentIconSize));
	haspreview=true;
}


DirFileIconItem::~DirFileIconItem ()
{
}

void
DirFileIconItem::setText( const QString & text )
{
	if(text==this->text())
		return;

	QFileInfo *itemFileInfo = new QFileInfo( full );
	QDir dir( itemFileInfo->dir() );

	if(QFileInfo(itemFileInfo->dirPath(TRUE)+"/"+text).exists())
	{
		KMessageBox::error(iv, "<qt>"+i18n("The directory '<b>%1</b>' already exists").arg(text)+"</qt>");
		delete itemFileInfo;
		return;
	}

	if ( dir.rename( itemFileInfo->fileName(), text ) )
	{
		QString itemFileName = itemFileInfo->dirPath( TRUE ) + "/" + text;
		full = QString("%1/%2")
			.arg(itemFileInfo->dirPath( TRUE ))
			.arg(text);

		delete itemFileInfo;
		itemFileInfo = new QFileInfo( itemFileName );

		f.setName(text);
		QIconViewItem::setText( this->text() );
	}
	else
	{
		KMessageBox::error(iv, "<qt>"+i18n("The directory <b>%1</b> cannot be renamed").arg(text)+"</qt>");
	}
	delete itemFileInfo;
}


bool
DirFileIconItem::suppression (bool suprFile)
{
	if (suprFile)
		return suppression ();
	else
	{
		return true;
	}
}


bool
DirFileIconItem::suppression ()
{
	if (QDir().remove (fullName ()))
	{
		return true;
	}
	else
	{
		return false;
	}
}


bool
DirFileIconItem::moveToTrash()
{
	KURL list("file:/"+fullName());
	KonqOperations::del(imageList, KonqOperations::TRASH, list);	
	return suppression(false);
}


bool
DirFileIconItem::shred()
{
	KIO::del(KURL("file:/"+fullName ()), true, false);
	suppression(false);
	return true;
}



QString
DirFileIconItem::shrink(QString str, int len) const
{
	if(str.length()<=(unsigned int)len)
		return str;
	else
	{
		return str.left(len/2) + "..." + str.right(len/2);
	}
}

QString
DirFileIconItem::toolTipStr() const
{
	QString tip;
	ImageFileInfo iminfo(full, IMAGE, true);

	tip = i18n("<b>name</b>: %1<br><b>location</b>: %2<br>%3")
		.arg(f.name())
		.arg(shrink(parentDir->fullName()))
		.arg(iminfo.hasInfo()?i18n("<b>description</b>: ")+iminfo.getTitle()+"<br>":QString(" "));
	
	tip+=fileInfo()->getToolTipText();
	return tip;
}



QString
DirFileIconItem::text (int column) const
{

	if (column == 0)
		return KIconViewItem::text();
	else if (column == 1)
		return (extension);
	else if (column == 2)
		return (size);
	else 
		return (type);
}

void
DirFileIconItem::setKey ( const QString & k )
{
	if(k=="name")
		KIconViewItem::setKey("00000000000000000000"+text());
	else
	if(k=="size")
		KIconViewItem::setKey(size);
	else
	if(k=="type")
		KIconViewItem::setKey(extension);
	else
	if(k=="date")
		KIconViewItem::setKey(date);
	else
		KIconViewItem::setKey(text());

}

