/***************************************************************************
                          dirfileiconitem.h  -  description
                             -------------------
    begin                : dim jun 23 2002
    copyright            : (C) 2002 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef __DIRFILEICONITEM_H__
#define __DIRFILEICONITEM_H__

#include "fileiconitem.h"

class Directory;
class ImageListView;
class ImageViewer;

class QListView;

class DirFileIconItem:public FileIconItem
{
public:
	DirFileIconItem (ImageListView *parent,
				Directory *parentDir,
				QString filename,
				QString path,
				ImageViewer *iv,
				QString description="");
		
	virtual ~DirFileIconItem();

	virtual void setText(const QString & text );
	virtual QString text (int column=0) const;
	virtual QString toolTipStr() const;
	virtual void setKey ( const QString & k );

	virtual bool suppression();
	virtual bool suppression(bool suprFile);
	virtual bool moveToTrash();
	virtual bool shred();

	int nbrImg;
	bool doPreload;

protected:
	Directory *parentDir;

	QString shrink(QString str, int len=20)const;

private:
	ImageListView *imageList;
};


#endif
