/***************************************************************************
                           extract.cpp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult, 2003 OGINO Tomonori, 2003 Ian Monroe
    email                : rgroult@jalix.org ogino@nn.iij4u.or.jp ian@monroe.nu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "extract.h"

#include <kprocess.h>
#include <kio/job.h>
#include <kzip.h>
#include <kar.h>
#include <ktar.h>
#include <kurl.h>
#include <kmessagebox.h>
#include <klocale.h>

#include <qdir.h>
#include <qvaluelist.h>

void 
Extract::getEntryRecursive( const KArchiveDirectory * entry, const QString & path )
{
	QStringList const & entries(entry->entries());
	QStringList::const_iterator it = entries.begin();
	for(; it != entries.end(); ++it) {
		QString add = path + QChar('/') + *it;
		files += add;
		const KArchiveEntry * child = entry->entry(*it);
		if( child->isDirectory() ){ 
			const KArchiveDirectory * childdir;
			childdir = dynamic_cast<const KArchiveDirectory *>(child);
			getEntryRecursive( childdir, path + QChar('/') + *it );
		}
	}
}

Extract::Extract (QString _filename)
{
	QFileInfo fileinfo ( _filename );

	QString  tmpdir;
	tmpdir.setNum (getpid ());
	tmpdir.prepend ("/tmp/.qlist");
	QDir().mkdir(tmpdir,TRUE);

	dest = tmpdir + '/' + fileinfo.fileName() + '/';
	ext = fileinfo.extension().lower();

	// Warn when the size of archive more than 'big(64MB).'
	QFile::Offset big = 0x4000000;// 64MB
	QFile qfile( _filename );
	if( qfile.size() > big ) {
		QString msg = QString( i18n("The size of selected archive seems to be TOO BIG!\nContinue?(size: %1MB)") ).arg( (qfile.size())>>20 );
		switch( KMessageBox::warningContinueCancel( 0, msg, i18n("Confirm")) ) {
			case KMessageBox::Cancel :
				return;
				break;
		}
	}

	// KZip - sync
	KArchive * arc=NULL;
	if ( ext == "zip" )
		arc = new KZip( fileinfo.absFilePath() );
	else if ( ext == "tar" || ext == "tar.gz" || ext == "tar.bz2" || ext == "tgz" )
		arc = new KTar( fileinfo.absFilePath() );
	else if ( ext == "ar" )
		arc = new KAr( fileinfo.absFilePath() );

	if(arc)
	{
		if ( arc->open( IO_ReadOnly ) ) {
			const KArchiveDirectory * dir = arc->directory();
		        dir->copyTo( dest );
			getEntryRecursive( dir, QString() );
		}
		files.sort();
	} 
	else
		KMessageBox::error( 0, 
			"<qt>"+i18n("Unable to open the archive '<b>%1</b>'.").arg(fileinfo.absFilePath())+"</qt>", 
			i18n("Archive problem"));
}

void
Extract::slotEntryRcv (KIO::Job *, const KIO::UDSEntryList& entries)
{
	KIO::UDSEntryListConstIterator it;
	for(it = entries.begin(); it != entries.end(); ++it ){
		KIO::UDSEntry::const_iterator jt;
		for(jt = (*it).begin(); jt != (*it).end(); ++jt ){
			switch( (*jt).m_uds ) {
				case KIO::UDS_NAME:
					files.append( QString((*jt).m_str) );
					break;
				default:
					break;
			}
		}
	}
	emit finished(this);
}

bool
Extract::canExtract( const QString & _filename )
{
	QFileInfo info( _filename );
	QString ext[2];
	//allow for periods in filenames that aren't part of the extension
	ext[0] = info.extension(true).lower();			
	ext[1] = info.extension(false).lower();
	for(int i = 0; i < 2; i++)	
		if( ext[i] == "zip" || ext[i] == "tar" || ext[i] == "tar.gz" 
		 || ext[i] == "tar.bz2" || ext[i] == "tgz" || ext[i] == "ar" )
			return true;
		
	return false;
}

#include "extract.moc"
