/***************************************************************************
                          extract.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult, 2003 OGINO Tomonori
    email                : rgroult@jalix.org ogino@nn.iij4u.or.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef __EXTRACT_H__
#define __EXTRACT_H__

#include <qptrlist.h>
#include <qstring.h>

#include <kio/global.h>
#include <kio/job.h>
#include <kio/jobclasses.h>

#include <karchive.h>

class Extract:QObject
{
	Q_OBJECT
public:
	Extract (QString filename);
	QStringList files;

	static bool canExtract( const QString & _filename );

public slots:
	void slotEntryRcv (KIO::Job * job, const KIO::UDSEntryList& entries);

signals:
	void finished(Extract *);

private:
	QString ext;
	QString dest;

	void getEntryRecursive( const KArchiveDirectory * entry, const QString & path );
};


#endif
