/***************************************************************************
                          fileiconitem.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org 
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef __FILEICONITEM_H__
#define __FILEICONITEM_H__

#include "imagelistview.h"

#include <qtooltip.h>
#include <qfile.h>

class ImageViewer;

class QIconView;
class QPixmap;
class QFileInfo;
class QToolTip;

class KFileItem;
class KURL;

class FileIconItem : public KFileIconViewItem
{
public:
	FileIconItem(ImageListView *parent, QString path,
					QString filename,
					QString icon,
					ImageViewer *iv);
	virtual ~FileIconItem();

	virtual void setPixmap ( const QPixmap & icon, bool haspreview=false );
	bool hasPreview ();
	void setHasPreview (bool preview);

	FileIconItem* nextItem ();
	FileIconItem* prevItem ();

	virtual void setType(QString type);
	virtual QString getType();

	virtual QString fullName() const;
	virtual KURL getURL();

	virtual void setName(QString n);
	virtual QString name();
	
	virtual void setPath(QString newPath);
	virtual QString path();
	
	QString mimetype() const;
	bool isImage() const;
	bool isMovable() const;

	virtual bool suppression(bool);
	virtual bool suppression();

	virtual bool moveToTrash();
	virtual bool shred();	 

	virtual QString text(int i=0) const;

	virtual QString toolTipStr() const;

	virtual void setWallpaper();

	virtual void setKey ( const QString & k );
	void setSelected (bool s);

protected:
	static QString getFileName(QString *fullName);
	static QString getFileExt(QString *fullName);
	static QString getFullName(QString *fullName);
	static QString getFullPath(QString *fullName);

	static QString getFileName(QString fullName);
	static QString getFileExt(QString fullName);
	static QString getFullName(QString fullName);
	static QString getFullPath(QString fullName);

	virtual void calcRect ( const QString & text_ = QString::null );

	QString size;
	QString extension;
	QString type;
	QString date;
	QString description;

	QFile f;

	QString myName;
	QString full;
	bool haspreview;
	KFileItem *mKFileItem;
	
	ImageViewer *iv;
	
	bool __isimage__, __ismovable__;
	
	ImageListView *imageList;

};

#endif
