/***************************************************************************
                          listitem.h  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult
    email                : rgroult@jalix.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LISTITEM_H
#define LISTITEM_H


/**
  *@author Richard Groult
  */
#include <klistview.h>

#include <qfile.h>
#include <qstring.h>

class ImageViewer;
class MainWindow;
class DirectoryView;
class ImageListView;

class QListViewItem;
class QString;
class QPixmap;
class QString;
class QStringList;

class KURL;

class ListItem : public KListViewItem
{
public: 
	ListItem(DirectoryView *parent, ImageViewer *iv, ImageListView *imageList, MainWindow *mw);
	ListItem(ListItem *parent, QString filename, DirectoryView *dirView, ImageViewer *iv,  ImageListView *imageList, MainWindow *mw);
	virtual ~ListItem();

	virtual QString text (int column) const;

	virtual QString fullName ();
	virtual QString name ();
	virtual QString path ();
	virtual KURL getURL();

	virtual  void setSelected (bool select);

	virtual  void load (bool refresh=true);
	virtual  void unLoad ();
	virtual  bool refresh(bool preview=true);
	virtual  ListItem* find (QString);
	virtual  void goTo (QString);

	virtual  void removeImage ( ListItem* );
	virtual  QString key (int column, bool ascending)  const;
	virtual int compare ( QListViewItem * i, int col, bool ascending ) const;

	virtual  void create(QString dirName);

	virtual  bool add(QStringList uris);
	
	virtual  bool acceptDrop();
	
	virtual  void rename(QString newDirName);
	virtual  void rename();
	virtual  void updateChildren();
	virtual  void properties();
	
	ListItem* firstChild();
	ListItem* nextSibling();
	ListItem* parent();

protected:
	ImageViewer *iv;
	ImageListView *imageList;
	MainWindow *mw;
	DirectoryView *dirView;
	
	QFile f;
	QString full;
	
	QString size;
	QString extension;
};

#endif
