/***************************************************************************
                          mainwindow.cp  -  description
                             -------------------
    begin                : Sat Dec 1 2001
    copyright            : (C) 2001 by Richard Groult, 
    				2003 OGINO Tomonori,
    				2004 Guillaume Duhamel
    email                : rgroult@jalix.org 
    				ogino@nn.iij4u.or.jp
				guillaume.duhamel@univ-rouen.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "mainwindow.h"

#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <math.h>
#include <stdlib.h>

#include "formatconversion.h"
#include "rename.h"
#include "mybookmarkmanager.h"
#include "printImageDialog.h"
#include "confshowimg.h"
#include "imageviewer.h"
#include "extract.h"
#include "imagelistview.h"
#include "directoryview.h"
#include "directory.h"
#include "displayCompare.h"
#include "compressedfileitem.h"
#include "history_action.h"
#include "imagefileiconitem.h"
#include "imageloader.h"
#include "imageloader.h"

#ifdef HAVE_LIBDIGIKAM
#include "digikamplugins/digikampluginmanager.h"
#include <digikam/albummanager.h>
#endif /* HAVE_LIBDIGIKAM */

#include <qmessagebox.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qmemarray.h>
#include <qdict.h>
#include <qkeycode.h>
#include <qdir.h>
#include <qtimer.h>
#include <qptrvector.h>
#include <qprogressdialog.h>
#include <qdatetime.h>
#include <qclipboard.h>
#include <qpainter.h>
#include <qdockarea.h>
#include <qtextcodec.h>

#include <kaboutdata.h>
#include <khelpmenu.h>
#include <kio/job.h>
#include <kaboutapplication.h>
#include <ktoolbarbutton.h>
#include <kmessagebox.h>
#include <kaction.h>
#include <kstdaccel.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>
#include <konq_operations.h>
#include <kglobalsettings.h>
#include <kurlrequesterdlg.h>
#include <kdialogbase.h>
#include <kdockwidget.h>
#include <kcursor.h>
#include <kurldrag.h>
#include <kfiledialog.h>
#include <kiconloader.h>
#include <klocale.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kwin.h>
#include <ktoolbar.h>
#include <kdockwidget.h>
#include <kapplication.h>
#include <kbookmarkmanager.h>
#include <kbookmarkmenu.h>
#include <kbookmarkbar.h>
#include <kbookmark.h>
#include <kaccel.h>
#include <kstatusbar.h>
#include <kpopupmenu.h>
#include <kstandarddirs.h>
#include <kimageeffect.h>
#include <kscan.h>
#include <kprinter.h>
#include <kmenubar.h>
#include <kprogress.h>
#include <kfilemetainfo.h>
#include <kprocess.h>
#include <kcombobox.h>
#include <kurlrequester.h>
#include <kcompletion.h>
#include <kurlcompletion.h>
#include <kurldrag.h>
#include <kio/netaccess.h>

class KDialogBase;

#define  PAS 32

/**
	a class to store datas to look for similaties of 2 images
*/
class ImageSimilarityData
{
public:
	ImageSimilarityData()
	{
		avg_r=(uchar*)malloc(PAS*PAS*sizeof(uchar));
		avg_g=(uchar*)malloc(PAS*PAS*sizeof(uchar));
		avg_b=(uchar*)malloc(PAS*PAS*sizeof(uchar));
	}

	~ImageSimilarityData()
	{
		delete(avg_r);
		delete(avg_g);
		delete(avg_b);
	}

	QString filename;

	uchar *avg_r;
	uchar *avg_g;
	uchar *avg_b;

	int filled;
	float ratio;
};






/**************************************************/
const char* CONFIG_DOCK_GROUP="dock";


MainWindow::MainWindow (QString name)
	:KDockMainWindow (0, name.ascii()),
	KBookmarkOwner()

{
//	kdDebug() << __FILE__ << __LINE__ << "begin MainWindow::MainWindow (QString name)" << endl;
	init ();
	show();

	if(openDirType==0)
		openDir(QDir::homeDirPath());
	else
		openDir(openDirname);

	hasimageselected=true;
	setHasImageSelected(imageList->hasImages());
//	kdDebug() << __FILE__ << __LINE__ << "end MainWindow::MainWindow (QString name)" << endl;
}


MainWindow::MainWindow (QString pic, QString name)
	:KDockMainWindow (0, name.ascii()),
	KBookmarkOwner()
{
	init ();
	show();


	if (QFileInfo (pic).isDir() || QString(pic).right (3) == "sia")
	{
	    openDir(QDir (pic).absPath());

	    hasimageselected=true;
	    setHasImageSelected(imageList->hasImages());
	}
	else
	if (QString (pic).right (3) != "zip")
	{
		QString rep = QDir (pic).absPath ();
		int pos = rep.findRev ("/");
		openDir(rep.left (pos));

		hasimageselected=false;
		setHasImageSelected(true);

		imageList->setCurrentItemName(QFileInfo(pic).fileName());
		iv->loadImage (pic);
		//slotFullScreen();
		inInterface=false;
	}
	else
	{
		QString rep = QDir (pic).absPath ();
		openDir(rep);

		hasimageselected=false;
		setHasImageSelected(true);
	}
}


MainWindow::~MainWindow ()
{

}


void
MainWindow::createActions()
{
	m_actions =actionCollection();

	aBack		=new HistoryAction(i18n("Back"),"back", KStdAccel::shortcut(KStdAccel::Back).keyCodeQt(), this,SLOT(slotBack()), m_actions,"back");
	connect(aBack->popupMenu(), SIGNAL(activated(int)),this, SLOT(backMenuActivated(int)));
	connect(aBack->popupMenu(), SIGNAL( aboutToShow() ), SLOT( slotBackAboutToShow() ) );
	aBack->setEnabled(false);

	aForward	=new HistoryAction(i18n("Forward"),"forward", KStdAccel::shortcut(KStdAccel::Forward).keyCodeQt() , this,SLOT(slotForward()), m_actions,"forward");
	connect(aForward->popupMenu(), SIGNAL(activated(int)),this, SLOT(forwardMenuActivated(int)));
	connect(aForward->popupMenu(), SIGNAL( aboutToShow() ), SLOT( slotForwardAboutToShow() ) );
	aForward->setEnabled(false);

	//
	aCut		=new KAction(i18n("Cut"),"editcut", KStdAccel::shortcut(KStdAccel::Cut), this,SLOT(slotcut()),m_actions ,"editcut");
		aCut->setEnabled(false);
	aCopy		=new KAction(i18n("Copy"),"editcopy", KStdAccel::shortcut(KStdAccel::Copy), this,SLOT(slotcopy()), m_actions,"editcopy");
	aCopyPixmap	=new KAction(i18n("Copy Image"), 0, this,SLOT(slotcopyPixmap()), m_actions,"editcopypixmap");
	aPaste		=new KAction(i18n("Paste"),"editpaste", KStdAccel::shortcut(KStdAccel::Paste), this,SLOT(slotpaste()),m_actions,"editpaste" );

	aPrevious	=new KAction(i18n("Previous Image"),"1leftarrow", Key_PageUp, imageList,SLOT(previous()),m_actions,"Previous Image" );
	aNext		=new KAction(i18n("Next Image"),"1rightarrow", Key_PageDown, imageList,SLOT(next()), m_actions,"Next Image");

	aFirst		=new KAction(i18n("First Image"),"top", KStdAccel::shortcut(KStdAccel::Home), imageList,SLOT(first()),m_actions,"First Image" );
	aLast		=new KAction(i18n("Last Image"),"bottom", KStdAccel::shortcut(KStdAccel::End),imageList ,SLOT(last()),m_actions,"Last Image" );

	//
	aWallpaper_CENTER	=new KAction(i18n("Centered"), 0, iv, SLOT(wallpaperC()), m_actions,"Center");
	aWallpaper_MOSAIC	=new KAction(i18n("Tiled"), 0, iv, SLOT(wallpaperM()), m_actions,"Mosaic");
	aWallpaper_CENTER_MOSAIC=new KAction(i18n("Center Tiled"), 0, iv, SLOT(wallpaperCM()), m_actions,"Center adapt");
	aWallpaper_CENTER_MAX	=new KAction(i18n("Centered Maxpect"), 0, iv, SLOT(wallpaperCMa()), m_actions,"Center max");
	aWallpaper_ADAPT	=new KAction(i18n("Scaled"), 0, iv, SLOT(wallpaperA()), m_actions,"Adapt");
	aWallpaper_LOGO		=new KAction(i18n("Logo"), 0, iv, SLOT(wallpaperL()), m_actions,"Logo");
	KActionMenu *actionWallp = new KActionMenu( i18n("Set as wallpaper"), m_actions, "view_wallp" );
	actionWallp->insert(aWallpaper_CENTER);
	actionWallp->insert(aWallpaper_MOSAIC);
	actionWallp->insert(aWallpaper_CENTER_MOSAIC);
	actionWallp->insert(aWallpaper_CENTER_MAX);
	actionWallp->insert(aWallpaper_ADAPT);
	actionWallp->insert(aWallpaper_LOGO);

	//
	aNewWindow	=new KAction(i18n("New window"),"window_new", KStdAccel::shortcut(KStdAccel::New), this, SLOT(slotNewWindow()),m_actions,"window_new" );

	aPrint		=new KAction(i18n("Print..."),"fileprint", KStdAccel::shortcut(KStdAccel::Print), this, SLOT(slotPrint()), m_actions,"fileprint");
		aPrint->setEnabled(false);

	aOpenLocation	=new KAction(i18n("Open Location"),"fileopen", KStdAccel::shortcut(KStdAccel::Open), this, SLOT(slotOpenLocation()),m_actions,"fileopen" );

	aSaveImage	=new KAction(i18n("Save &As..."),"filesave", KStdAccel::shortcut(KStdAccel::Save), this, SLOT(slotSaveImage()),m_actions,"filesave" );

	aQuit		=new KAction(i18n("Quit"),"exit", KStdAccel::shortcut(KStdAccel::Quit), this, SLOT(quit()),m_actions ,"exit");
	aClose		=new KAction(i18n("Close"),"close", KStdAccel::shortcut(KStdAccel::Close), this, SLOT(close()),m_actions ,"close");
	//
	aUndo		=new KAction(i18n("Undo"),"undo", KStdAccel::shortcut(KStdAccel::Undo), this, SLOT(slotUndo()),m_actions ,"undo");
	aUndo->setEnabled(false);
	aRedo		=new KAction(i18n("Redo"),"redo", KStdAccel::shortcut(KStdAccel::Redo), this, SLOT(slotRedo()),m_actions ,"redo");
	aRedo->setEnabled(false);

	//
	aRename		=new KAction(i18n("Rename file"),"item_rename", KShortcut(Key_F2), imageList, SLOT(slotRename()),m_actions ,"rename");
	aDelete		=new KAction(i18n("Delete file"),"editdelete", KShortcut(SHIFT+Key_Delete), imageList,SLOT(slotSupprimmer()), m_actions,"editdelete");
	aTrash		=new KAction(i18n("Move file to trash"),"edittrash", KShortcut(Key_Delete), imageList,SLOT(slotMoveToTrash()), m_actions,"edittrash");
	aShred		=new KAction(i18n("Shred file"),"editshred", KShortcut(SHIFT+CTRL+Key_Delete), imageList,SLOT(slotShred()), m_actions,"editshred");

	aEditType	=new KAction(i18n("Edit File Type"), 0, this,SLOT(slotEditFileType()), m_actions,"Edit File Type");
	aFileProperties	=new KAction(i18n("Properties"), 0, imageList,SLOT(slotFileProperty()), m_actions,"Properties");
	aImageInfo	=new KAction(i18n("Image Info"), 0, imageList,SLOT(slotImageInfo()), m_actions,"Image Info");
	aDirInfo	=new KAction(i18n("Describe directory"), 0, dirView,SLOT(slotDirInfo()), m_actions,"Dir Info");
	aDirProperties	=new KAction(i18n("Properties"), 0, dirView, SLOT(slotDirProperty()), m_actions,"Dir Properties");

	aSelect		=new KAction(i18n("SelectAll"), KStdAccel::shortcut(KStdAccel::SelectAll) , imageList,SLOT(slotSelectAll()), m_actions,"SelectAll");
	aUnselectAll	=new KAction(i18n("Unselect All"),0, imageList ,SLOT(slotUnselectAll()), m_actions,"Unselect All");
	aInvertSelection=new KAction(i18n("Invert Selection"), KShortcut(CTRL+Key_I),imageList ,SLOT(slotInvertSelection()), m_actions,"Invert Selection");

	aConfigureKey =     KStdAction::keyBindings(this, SLOT(configureKey()), 		actionCollection() );
	aConfigureToolbars= KStdAction::configureToolbars(this, SLOT(configureToolbars()),	actionCollection() );
	aConfigureShowImg = KStdAction::preferences(this, SLOT(configureShowImg()), 		actionCollection() );


	aRenameSeries	=new KAction(i18n("&Rename series..."), 0, this,SLOT(renameSeries()), m_actions,"Rename series");
	aSlideshow	=new KToggleAction(i18n("&Slide show"),"run", 0, this,SLOT(slotSlideShow()), m_actions,"Slideshow");
	aSmooth		=new KToggleAction(i18n("Smooth scaling"), 0, this,SLOT(slotSmooth()), m_actions,"Smooth scaling");

	aRotLeft	=new KAction(i18n("Rotate Left"),"rotation_acw", KShortcut(Key_L), this,SLOT(slotRotateLeft()), m_actions,"Rotate Left");
	aRotRight	=new KAction(i18n("Rotate Right"),"rotation_cw", KShortcut(Key_R), this,SLOT(slotRotateRight()), m_actions,"Rotate Right");
	aHMirror	=new KAction(i18n("Vertical flip"),"flip", 0, this,SLOT(slotMirrorH()), m_actions,"Flip");
	aVMirror	=new KAction(i18n("Horizontal flip"),"miror", 0, this,SLOT(slotMirrorV()), m_actions,"Mirror");
	KActionMenu *actionOrientation = new KActionMenu( i18n("Orientation"), m_actions, "view_Orientation" );
		actionOrientation->insert(aRotLeft);
		actionOrientation->insert(aRotRight);
		actionOrientation->insert(aHMirror);
		actionOrientation->insert(aVMirror);

	aReloadDir	=new KAction(i18n("Refresh"),"reload", 0, this,SLOT(slotRefresh()), m_actions,"Refresh");
	aPreview	=new KToggleAction(i18n("Toggle Thumbnails"),"thumbnail", 0, this,SLOT(slotPreview()), m_actions,"Preview");
	aStop		=new KAction(i18n("Stop"),"stop", 0, this,SLOT(slotStop()), m_actions,"Stop");
	aStop->setEnabled(false);

	aIconSmall	=new KRadioAction(i18n("Small Icons"),"smallthumbnails", 0, this,SLOT(slotIconSize()), m_actions,"Small Icons");
	aIconMed	=new KRadioAction(i18n("Medium Icons"),"medthumbnails", 0, this,SLOT(slotIconSize()), m_actions,"Medium Icons");
	aIconBig	=new KRadioAction(i18n("Large Icons"),"largethumbnails", 0, this,SLOT(slotIconSize()), m_actions,"Big Icons");
	aIconSmall->setExclusiveGroup("IconSize");
	aIconMed->setExclusiveGroup("IconSize");aIconMed->setChecked(true);
	aIconBig->setExclusiveGroup("IconSize");
	KActionMenu *actionIconSize = new KActionMenu( i18n("Icon size"), m_actions, "view_icons" );
	actionIconSize->insert(aIconSmall);
	actionIconSize->insert(aIconMed);
	actionIconSize->insert(aIconBig);

	aArrangementLR	=new KRadioAction(i18n("from left to right"), 0, this, SLOT(slotArrangement()), m_actions,"From left to right");
	aArrangementTB	=new KRadioAction(i18n("from top to bottom"), 0, this, SLOT(slotArrangement()), m_actions,"From top to bottom");
	aArrangementLR->setExclusiveGroup("Arrangement");aArrangementLR->setChecked(true);
	aArrangementTB->setExclusiveGroup("Arrangement");
	aArrangementR	=new KRadioAction(i18n("on the right"), 0, this, SLOT(slotTxtPos()), m_actions,"on the right");
	aArrangementB	=new KRadioAction(i18n("at the bottom"), 0, this, SLOT(slotTxtPos()), m_actions,"at the bottom");
	aArrangementB->setExclusiveGroup("TxtPos");aArrangementB->setChecked(true);
	aArrangementR->setExclusiveGroup("TxtPos");

		KShortcut sc_fs(CTRL+Key_F); sc_fs.append(KKeySequence(KKey(CTRL+Key_Return)));
	aFullScreen	=new KToggleAction(i18n("Full Screen"),"window_fullscreen", sc_fs, this, SLOT(slotFullScreen()),m_actions,"FullScreen" );
		aFullScreen->setChecked(false);
		KShortcut sc_zi(KStdAccel::shortcut(KStdAccel::ZoomIn)); sc_zi.append(KKeySequence((const KKey&)Qt::Key_Plus));
	aZoomIn		=new KAction(i18n("Zoom in"),"viewmag_bis+", sc_zi, this,SLOT(slotZoomIn()), m_actions,"Zoom in");
		KShortcut sc_zo(KStdAccel::shortcut(KStdAccel::ZoomOut)); sc_zo.append(KKeySequence((const KKey&)Qt::Key_Minus));
	aZoomOut	=new KAction(i18n("Zoom out"),"viewmag_bis-", sc_zo, this,SLOT(slotZoomOut()), m_actions,"Zoom out");
	aZoomFit	=new KAction(i18n("Fit to Screen"),"viewmag_full", KShortcut(Key_Slash), this,SLOT(slotZoom()), m_actions,"Fit to Screen");
	aZoomFitWidth=new KToggleAction(i18n("Fit width"),"viewmag_w", 0, this, SLOT(slotfitWidth()), m_actions,"Fit the width");
	aZoomFitHeight=new KToggleAction(i18n("Fit height"),"viewmag_h", 0, this, SLOT(slotfitHeight()), m_actions,"Fit the height");
	aZoomNo		=new KAction(i18n("Original size"),"viewmag_no", KShortcut(Key_Asterisk), this,SLOT(slotZoomNo()), m_actions,"Originale size");
	aZoomLock	=new KToggleAction(i18n("Lock zoom"),"viewmag_lock",0, this,SLOT(slotZoomLock()), m_actions,"ZoomLock");
	aEnlarge	=new KToggleAction(i18n("Enlarge if smaller"),"viewmag_enlarge", 0, this,SLOT(slotEnlarge()), m_actions,"Enlarge");
	aShrink		=new KToggleAction(i18n("Shrink if bigger"),"viewmag_shrink", 0, this,SLOT(slotShrink()), m_actions,"Shrink");
	KActionMenu *actionZoom = new KActionMenu( i18n("Zoom"), m_actions, "view_zoomm" );
	actionZoom->insert(aZoomIn);
	actionZoom->insert(aZoomOut);
	actionZoom->insert(aZoomFit);
	actionZoom->insert(aZoomFitWidth);
	actionZoom->insert(aZoomFitHeight);
	actionZoom->insert(aZoomNo);
	actionZoom->insert(aZoomLock);
	actionZoom->insert(new KActionSeparator());
	actionZoom->insert(aEnlarge);
	actionZoom->insert(aShrink);

	//
	aSortByName	=new KRadioAction(i18n("by name"), 0, imageList,SLOT(slotByName()), m_actions,"by name");
	aSortByType	=new KRadioAction(i18n("by extension"), 0, imageList,SLOT(slotByExtension()), m_actions,"by extension");
	aSortBySize	=new KRadioAction(i18n("by size"), 0, imageList,SLOT(slotBySize()), m_actions,"by size");
	aSortByDate	=new KRadioAction(i18n("by date"), 0, imageList,SLOT(slotByDate()), m_actions,"by date");
	aSortBySize->setExclusiveGroup("sort mode");aSortByType->setExclusiveGroup("sort mode");
	aSortByName->setExclusiveGroup("sort mode");aSortByDate->setExclusiveGroup("sort mode");
	aSortByName->setChecked(true);
	KActionMenu *actionSortMenu = new KActionMenu( i18n("Sort"), m_actions, "view_sort" );
	actionSortMenu->insert(aSortByName);
	actionSortMenu->insert(aSortByType);
	actionSortMenu->insert(aSortBySize);
	actionSortMenu->insert(aSortByDate);

	//
	aOpenWithGimp	=new KAction(i18n("Open with &Gimp"),"gimp", 0, imageList,SLOT(slotGimp()), m_actions,"Open with Gimp");
	aOpenWithKhexedit=new KAction(i18n("Open with &Khexedit"),"khexedit", 0, imageList,SLOT(slotKhexedit()), m_actions,"Open with Khexedit");
	aOpenWith	=new KAction(i18n("&Other..."), 0, imageList,SLOT(slotOpenWith()), m_actions,"Open with");

	aDirNewFolder	=new KAction(i18n("New directory..."),"folder_new", 0, dirView, SLOT(slotNewDir()),m_actions ,"editdirnew");
	aDirNewAlbum	=new KAction(i18n("New album..."),"txt", 0, dirView, SLOT(slotNewAlbum()),m_actions ,"editalbumnew");

	aDirCut		=new KAction(i18n("Cut"),"editcut", 0, this,SLOT(slotDirCut()),m_actions ,"editdircut");
	aDirCopy	=new KAction(i18n("Copy folder to ..."),"editcopy", 0, dirView, SLOT(slotDirCopy()),m_actions ,"editdircopy");
	aDirMove	=new KAction(i18n("Move folder to ..."), 0, dirView, SLOT(slotDirMove()),m_actions ,"editdirmove");
	aDirPaste	=new KAction(i18n("Paste"),"editpaste", 0, this,SLOT(slotDirPaste()),m_actions ,"editdirpaste");
	aDirPasteFiles	=new KAction(i18n("Paste files"),"editpaste", 0, dirView, SLOT(slotDirPasteFiles()),m_actions ,"editdirpaste files");
	aDirRecOpen	=new KAction(i18n("Recursively open"), 0, dirView, SLOT(recursivelyOpen()), m_actions ,"dirRecOpen");

	aDirRename=new KAction(i18n("&Rename item"),"item_rename", 0, dirView,SLOT(slotRename()),m_actions ,"editdirrename");

	aDirTrash=new KAction(i18n("&Move item to trash"),"edittrash", 0, dirView,SLOT(slotTrash()),m_actions ,"editdirtrash");
	aDirDelete=new KAction(i18n("&Delete"),"editdelete", 0, dirView,SLOT(slotSuppr()),m_actions ,"editdirdelete");

	aFilesMoveTo	=new KAction(i18n("Move files to ..."), 0, imageList,SLOT(slotFilesMoveTo()),m_actions ,"moveFilesTo");
	aFilesCopyTo	=new KAction(i18n("Copy files to ..."), 0, imageList, SLOT(slotFilesCopyTo()),m_actions ,"copyFilesTo");

	aScrollXR	=new KAction(i18n("Scroll on the right"), Key_Right, iv, SLOT(scrolldxR()),m_actions ,"ScrollXR");
	aScrollYB	=new KAction(i18n("Scroll at the bottom"),Key_Down , iv, SLOT(scrolldyB()),m_actions ,"ScrollYB");
	aScrollXL	=new KAction(i18n("Scroll on the left"), Key_Left, iv, SLOT(scrolldxL()),m_actions ,"ScrollXL");
	aScrollYT	=new KAction(i18n("Scroll on the top"), Key_Up, iv, SLOT(scrolldyT()),m_actions ,"ScrollYT");

	aCovert		=new KAction(i18n("Format conversion..."), 0, this,SLOT(convert()), m_actions,"convert");
	aToolsRotateLeft=new KAction(i18n("Rotate left"), "rotation_acw", CTRL+Key_L, this, SLOT(toolsRotateLeft()),m_actions ,"aToolsRotateLeft");
	aToolsRotateRight=new KAction(i18n("Rotate right"), "rotation_cw", CTRL+Key_R, this, SLOT(toolsRotateRight()),m_actions ,"aToolsRotateRight");
	KActionMenu *actionConv = new KActionMenu( i18n("Convert"), m_actions, "tools_conv" );
	actionConv->insert(aCovert);
	actionConv->insert(aToolsRotateLeft);
	actionConv->insert(aToolsRotateRight);

	aGoHome		=new KAction(i18n("Go to home directory"), "gohome", 0, this, SLOT(goHome()),m_actions ,"goHome");
	aGoUp		=new KAction(i18n("Go Up"), "up", 0, this, SLOT(goUp()),m_actions ,"goUp");

	aUpdateCache	=new KAction(i18n("Update current directory cache"), 0, this, SLOT(updateCache()),m_actions ,"updateCache");
	aClearCache	=new KAction(i18n("Clear current directory cache"),  0, this, SLOT(clearCache()),m_actions ,"clearCache");
	KActionMenu *actionMaint = new KActionMenu( i18n("Main&tenance"), m_actions, "tools_maint" );
	actionMaint->insert(aUpdateCache);
	actionMaint->insert(aClearCache);

	aEffect_GRAYSCALE=new KToggleAction(i18n("Gray scale"),0, this,SLOT(slotSetFilter()), m_actions,"effect_grayscale");
	aEffect_NORMALIZE=new KToggleAction(i18n("Normalize"),0, this,SLOT(slotSetFilter()), m_actions,"effect_normalize");
	aEffect_EQUALIZE=new KToggleAction(i18n("Equalize"),0, this,SLOT(slotSetFilter()), m_actions,"effect_Equalize");
	aEffect_INTENSITY=new KToggleAction(i18n("Intensity"),0, this,SLOT(slotSetFilter()), m_actions,"effect_Intensity");
	aEffect_INVERT=new KToggleAction(i18n("Invert"),0, this,SLOT(slotSetFilter()), m_actions,"effect_Invert");
	aEffect_EMBOSS=new KToggleAction(i18n("Emboss"),0, this,SLOT(slotSetFilter()), m_actions,"effect_Emboss");
	aEffect_SWIRL=new KToggleAction(i18n("Swirl"),0, this,SLOT(slotSetFilter()), m_actions,"effect_Swirl");
	aEffect_SPREAD=new KToggleAction(i18n("Spread"),0, this,SLOT(slotSetFilter()), m_actions,"effect_Spread");
	aEffect_IMPLODE=new KToggleAction(i18n("Implode"),0, this,SLOT(slotSetFilter()), m_actions,"effect_Implode");
	aEffect_CHARCOAL=new KToggleAction(i18n("Charcoal"),0, this,SLOT(slotSetFilter()), m_actions,"effect_Chaorcoal");
	aEffect_NONE=new KToggleAction(i18n("None"),0, this,SLOT(slotSetFilter()), m_actions,"effect_effect_none");
	KActionMenu *actionEffects = new KActionMenu( i18n("Effects"), m_actions, "view_effects" );
	actionEffects->insert(aEffect_NONE);
	actionEffects->insert(new KActionSeparator());
	actionEffects->insert(aEffect_GRAYSCALE);
	actionEffects->insert(aEffect_NORMALIZE);
	actionEffects->insert(aEffect_EQUALIZE);
	actionEffects->insert(aEffect_INTENSITY);
	actionEffects->insert(aEffect_INVERT);
	actionEffects->insert(new KActionSeparator());
	actionEffects->insert(aEffect_EMBOSS);
	actionEffects->insert(aEffect_SWIRL);
	actionEffects->insert(aEffect_SPREAD);
	actionEffects->insert(aEffect_IMPLODE);
	actionEffects->insert(aEffect_CHARCOAL);

	abookmarkmenu = 	new KActionMenu(i18n("&Bookmark"), m_actions, "bookm");
	mBookMenu=		new KBookmarkMenu(MyBookmarkManager::self(),this, abookmarkmenu->popupMenu(),  m_actions, true);

//#ifndef HAVE_LIBDIGIKAM
	aCompareFast	=new KAction(i18n("&Exact comparison"), 0, this,SLOT(slotCompareFast()), m_actions,"Compare fast");
	aCompareAlmost	=new KAction(i18n("&Approximate comparison"), 0, this,SLOT(slotCompareAlmost()), m_actions,"Compare almost");
	KActionMenu *actionCmp = new KActionMenu( i18n("&Find images"), BarIcon ("filefind", 16), m_actions, "tools_campare" );
	actionCmp->insert(aCompareFast);
	actionCmp->insert(aCompareAlmost);

  aScan	=new KAction(i18n("Scan image..."),  "scanner", 0, this, SLOT(slotScanImage()),m_actions ,"scanimage");
//#endif /*HAVE_LIBDIGIKAM*/

  //
	m_URLHistory=new KHistoryCombo(this);
	m_URLHistory->setDuplicatesEnabled(false);
	m_URLHistory->setAutoDeleteCompletionObject(true);
	m_URLHistory->setDuplicatesEnabled(false);

	m_URLHistoryCompletion=new KURLCompletion(KURLCompletion::DirCompletion);
	m_URLHistory->setCompletionObject(m_URLHistoryCompletion);
	m_URLHistoryCompletion->setDir("file:/");

	KWidgetAction* comboAction=new KWidgetAction( m_URLHistory, i18n("Location Bar"), 0, 0, 0, m_actions, "location_url");
	comboAction->setShortcutConfigurable(false);
	comboAction->setAutoSized(true);

	(void)new KAction( i18n("Clear location bar"),"locationbar_erase", 0, m_URLHistory, SLOT(clearEdit()), m_actions, "clear_location");

	QLabel* m_urlLabel=new QLabel(i18n("L&ocation:"), this, "kde toolbar widget");
	(void)new KWidgetAction( m_urlLabel, i18n("L&ocation: "), 0, 0, 0, m_actions, "location_label");
	m_urlLabel->setBuddy(m_URLHistory);

	aGo     =       new KAction(i18n("Go"), "key_enter", Key_Return, this, SLOT(changeDirectory()), actionCollection(), "location_go");


 	// Non configurable stop-fullscreen accel
	QAccel* accel=new QAccel(this);
	accel->connectItem(accel->insertItem(Key_Escape),this,SLOT(escapePressed()));
	accel->connectItem(accel->insertItem(Key_Space),this,SLOT(spacePressed()));
}


void
MainWindow::createAccels()
{
	m_actions->readShortcutSettings( QString::null );
	mAccel = m_actions->accel();

	imageList->initMenu(m_actions);
	dirView->initMenu(m_actions);
	iv->initMenu(m_actions);
}



void
MainWindow::setActionsEnabled(bool enable)
{
	int count=m_actions->count();
	for (int pos=0;pos<count;++pos)
		m_actions->action(pos)->setEnabled(enable);

}

void
MainWindow::slotIconSize(bool refresh)
{
	slotStop();
	if(aIconSmall->isChecked())
	{
		//imageList->setThumbnailSize(QSize(40, 30));
		imageList->setThumbnailSize(QSize(80, 60), refresh);
	}
	else
	if(aIconMed->isChecked ())
	{
		//imageList->setThumbnailSize(QSize(80, 60));
		imageList->setThumbnailSize(QSize(120, 90), refresh);

	}
	else
	if(aIconBig->isChecked ())
	{
		//imageList->setThumbnailSize(QSize(100, 80));
		imageList->setThumbnailSize(QSize(160, 120), refresh);
	}
	//if(refresh)
		slotRefresh ();
}

void
MainWindow::createMenus()
{
}

#define SB_ITEMS    1
#define SB_SCALE    2
#define SB_NAME     3
#define SB_TYPE     4
#define SB_IMG_SIZE 5
#define SB_BYTES    6
#define SB_DATE     7
#define SB_MSG      8
#define SB_PATH     9
void
MainWindow::createToolbar()
{
}

void
MainWindow::setupActions()
{
}

void
MainWindow::setupStatusBar()
{
}

void
MainWindow::createStatusbar()
{
	//statusBar()->setFixedHeight((int)(1.6*QFontInfo(QApplication::font()).pixelSize()));

	statusBar()->insertItem("", SB_MSG, 1,true);		statusBar()->setItemAlignment(SB_MSG, AlignTop);
	statusBar()->insertItem("", SB_ITEMS, 1,true);		statusBar()->setItemAlignment(SB_ITEMS, AlignTop|AlignHCenter);
	statusBar()->insertItem("", SB_SCALE, 1,true);		statusBar()->setItemAlignment(SB_SCALE, AlignTop|AlignHCenter);
	statusBar()->insertItem("", SB_NAME, 2,true);		statusBar()->setItemAlignment(SB_NAME, AlignTop|AlignHCenter);
	statusBar()->insertItem("", SB_TYPE, 1,true);		statusBar()->setItemAlignment(SB_TYPE, AlignTop|AlignHCenter);
	statusBar()->insertItem("", SB_IMG_SIZE, 1,true);	statusBar()->setItemAlignment(SB_IMG_SIZE, AlignTop|AlignHCenter);
	statusBar()->insertItem("", SB_BYTES, 1,true);		statusBar()->setItemAlignment(SB_BYTES, AlignTop|AlignHCenter);
	statusBar()->insertItem("", SB_DATE, 2,true);		statusBar()->setItemAlignment(SB_DATE, AlignTop|AlignHCenter);

	progress = new KProgress (statusBar(), "QProgressBar de chargement des images de MainWindow");
	progress->setCenterIndicator (true);
	statusBar()->addWidget (progress, 1, FALSE);

	progress->hide();

}
void
MainWindow::setMessage(QString msg)
{
	statusBar()->changeItem(msg,SB_MSG);
}


void
MainWindow::setImageIndex (int index)
{
	imageIndex=index;
	setNbrItems(nbrItems);
}

void
MainWindow::setNbrItems (int nbr)
{
	nbrItems=nbr;
	QString idx = QString("%1 / ").arg(imageIndex+1);
	QString msg = i18n("%1%2 item(s)")
		.arg(imageIndex>=0?idx:QString())
		.arg(nbrItems);
	statusBar()->changeItem(msg, SB_ITEMS);
}

void
MainWindow::setZoom (int zoom)
{
	statusBar()->changeItem(QString("%1%").arg(zoom),SB_SCALE );
}

void
MainWindow::setImagename (QString name)
{
	if(!name.isEmpty())
	{
		QString msg(name);
		statusBar()->changeItem(msg,SB_NAME );
	}
	else
		statusBar()->changeItem("", SB_NAME );
}

void
MainWindow::setImagetype (QString type)
{
	if(!type.isEmpty())
	{
		QString msg(type);
		statusBar()->changeItem(msg.upper(),SB_TYPE );
	}
	else
		statusBar()->changeItem("", SB_TYPE );

}


void
MainWindow::setDim (QSize *size)
{
	if(size)
	{
		QString msg;
		statusBar()->changeItem(QString("%1 x %2").arg(size->width()).arg(size->height()),SB_IMG_SIZE );
	}
	else
		statusBar()->changeItem("", SB_IMG_SIZE );
}

void
MainWindow::setSize (int size)
{
	if(size>=0)
	{
		statusBar()->changeItem(QString("%1").arg(size), SB_BYTES);
	}
	else
		statusBar()->changeItem("", SB_BYTES);
}

void
MainWindow::setDate (QDateTime *date)
{
	if(date)
		statusBar()->changeItem(KLocale(NULL).formatDateTime(*date, false),SB_DATE);
	else
		statusBar()->changeItem("",SB_DATE);
}


void
MainWindow::changeDirectory()
{
       KURL url = KURL(m_URLHistory->currentText());
       if (!url.protocol().compare("http") || !url.protocol().compare("ftp")) 
       {
		QString tmpFile = locateLocal("tmp", "showimg-net/");
		tmpFile += url.filename();
		if( KIO::NetAccess::download( url, tmpFile ) ) 
		{
		       openDir(tmpFile);
		       //KIO::NetAccess::removeTempFile( tmpFile );
		}
		else
		{
			openDir(currentDir());
		}		
       }
       else 
       {
	       openDir(url.path());
       }
}

void
MainWindow::changeDirectory(QString dir)
{
	setCaption(dir);
	setCurrentDir(dir);

	updateHistory();
}


void
MainWindow::backMenuActivated(int item)
{
	go(-(aBack->popupMenu()->indexOf(item)+1));
}

void
MainWindow::forwardMenuActivated(int item)
{
	go(aForward->popupMenu()->indexOf(item)+1);
}


void
MainWindow::createMainView()
{
	dockIL = createDockWidget ("Directory", BarIcon("folder", 16), 0L, i18n("Directory"), i18n("Directory"));
	imageList = new ImageListView (dockIL, "ImageList", this);
	QWhatsThis::add(imageList, i18n( "Images of the selected directories" ) );
	dockIL->setWidget(imageList);
	dockIL->setToolTipString(i18n("Images in the selected directories"));

	dockIV = createDockWidget ("Preview", BarIcon("image", 16),0L, i18n("Preview"), i18n("Preview"));
	iv = new ImageViewer (dockIV, imageList, this, "ImageViewer");
	dockIV->setWidget( iv );
	KCursor::setAutoHideCursor(iv, true);
	QWhatsThis::add(iv, i18n( "Image preview" ) );
	dockIV->setToolTipString(i18n("Image preview"));

	dockDir = createDockWidget ("Tree", BarIcon("view_tree", 16),0L, i18n("Treeview"), i18n("Treeview"));
	dirView = new DirectoryView (dockDir, iv, imageList, this);
	QWhatsThis::add(dirView, i18n( "List of directories" ) );
	dockDir->setWidget( dirView );
	dockDir->setToolTipString(i18n("The directory tree"));

	setMainDockWidget( dockIV );
	setView (dockIV);

	dockDir->manualDock(dockIV, KDockWidget::DockLeft, 35);
	dockIL->manualDock(dockDir, KDockWidget::DockBottom, 35);

	root = new Directory (dirView, iv, imageList, this);
	root->setOpen (TRUE);
}

void
MainWindow::initSize()
{
	config->setGroup("Options");

	int w = config->readNumEntry( "Width", 0 );  // largeur de la fentre
	int h = config->readNumEntry( "Height", 0 ); // hauteur de la fentre

	if (w != 0 && h != 0)
		resize( w, h );
	else
		resize(640,480);
	readDockConfig (config, CONFIG_DOCK_GROUP);
}


void
MainWindow::init ()
{
 total = 0;
	done = 0;
	inFullScreen = false;
	inInterface=false;
	m_scanDialog=NULL;
	m_renameS=NULL;

	config = new KConfig("showimgrc");

	createStatusbar();
	createMainView();

	createActions();
	createAccels();
	aTime	= new KAction("", (const KShortcut&)0, this, SLOT(slotDisplayNBImg()), m_actions,"time");


	setStandardToolBarMenuEnabled(true);


	createGUI("showimgui.rc", false);
	KMainWindow::applyMainWindowSettings(KGlobal::config(), "MainWindow");

#ifdef HAVE_LIBDIGIKAM
	mAlbumManager = new Digikam::AlbumManager(this);
	mAlbumManager->setItemHandler(imageList);


	// Load Plugins
	pluginManager_ = new DigikamPluginManager(this);
#endif /* HAVE_LIBDIGIKAM */

	//menuBar()->insertItem("&Windows", dockHideShowMenu(), -1, 4);
	initSize();

	/////////////////////
	config->setGroup("Options");
	aPreview->setChecked(config->readBoolEntry("preview", false));
	bgColor=config->readColorEntry("bgcolor", new QColor("black"));
	iv->setBackgroundColor(bgColor);
	grayscale=config->readNumEntry("grayscale", 100);
	iv->setToGrayscale(grayscale);
	storeth=config->readBoolEntry("storeth", true);
	showFrame=config->readBoolEntry("showFrame", true);
	imageList->il->setShowFrame(showFrame);
	imageList->setPreloadIm(config->readBoolEntry("preloadIm", true));
	smooth=config->readBoolEntry("smooth", true);
	imageList->setShowMeta(config->readBoolEntry("showMeta", true));
	imageList->setShowHexa(config->readBoolEntry("showHexa", true));
	iv->setSmooth(smooth);
	dirView->setShowHiddenDir(config->readBoolEntry("showhiddenDir", false));
	dirView->setShowHiddenFile(config->readBoolEntry("showhiddenFile", false));
	dirView->setShowDir(config->readBoolEntry("showDir", true));
	dirView->setShowAllFile(config->readBoolEntry("showallFile", false));
	dirView->setLoadFirstImage(config->readBoolEntry("loadFirstImage", true));
	slotIconSize();
	iv->nbImg=config->readNumEntry("nbImg", 0);
	aTime->setText(i18n("%1 images seen").arg(iv->nbImg));
#ifdef HAVE_LIBDIGIKAM
	kdDebug() << "pluginManager_->loadPlugins(config->readListEntry(pluginList)); " << endl;
	pluginManager_->loadPlugins(config->readListEntry("pluginList"));
#endif /* HAVE_LIBDIGIKAM */



	config->setGroup("Slideshow");
	slideshowTime=config->readNumEntry("time", 2);
	slideshowType=config->readNumEntry("type", 0);

	config->setGroup("Zoom");
	aShrink->setChecked(config->readBoolEntry("shrink", true));
	slotShrink();
	aEnlarge->setChecked(config->readBoolEntry("enlarge", false));
	slotEnlarge();
	aZoomLock->setChecked(config->readBoolEntry("lock", false));
	slotZoomLock();

	config->setGroup("confirm");
	checkTrash=config->readBoolEntry("trash", true);
	checkDelete=config->readBoolEntry("delete", true);
	checkShred=config->readBoolEntry("shred", true);
	openDirType=config->readNumEntry("openDirType", 0);
	openDirname=config->readPathEntry("openDirname", QDir::homeDirPath());
	showSP=config->readBoolEntry("showSP", true);
	useEXIF=config->readBoolEntry("useEXIF", true);
		imageList->il->setUseEXIF(useEXIF);
	showToolbar=config->readBoolEntry("showToolbar", true);
	showStatusbar=config->readBoolEntry("showStatusbar", false);

	dirView->setCheckDelete(checkDelete);dirView->setCheckTrash(checkTrash);
	imageList->setCheckDelete(checkDelete);imageList->setCheckTrash(checkTrash);
	imageList->setCheckShred(checkShred);

	timer = new QTimer (this);
	connect (timer, SIGNAL (timeout ()), imageList, SLOT (next ()));

}

void
MainWindow::myDialogSlot()
{
}


bool
MainWindow::preview()
{
	return aPreview->isChecked();
}


QString
MainWindow::getFileName(QString *fullName)
{
		int debut = fullName->findRev ("/");
		int fin = fullName->findRev (".");
		return fullName->mid(debut+1, fin-debut-1);
}


QString
MainWindow::getFileExt(QString *fullName)
{
		int pos = fullName->findRev (".");
		return  fullName->right (fullName->length () - pos-1);
}

QString
MainWindow::getFullName(QString *fullName)
{
		int pos = fullName->findRev ("/");
		return fullName->right (fullName->length () - pos-1);
}

QString
MainWindow::getFullPath(QString *fullName)
{
		int pos = fullName->findRev ("/");
		return fullName->left(pos+1);
}


DirectoryView*
MainWindow::getDirectoryView()
{
	return dirView;
}


void
MainWindow::convert()
{
	QPtrList <QString> list;
	list.setAutoDelete (false);

	for (ImageFileIconItem * item = (ImageFileIconItem *)((QIconView*)imageList)->firstItem ();
	     item != 0;
	     item = (ImageFileIconItem *) item->nextItem ())
	{
		if (item->isSelected () && item->text(3)=="file"  )
	        {
			list.append(new QString(item->fullName()));
		}
	}
	if(list.isEmpty())
	{
		KMessageBox::error(this, i18n("You have to select at least one file"));
		return;
	}
	////////////
	FormatConversion *formatConver = new FormatConversion(this);
	formatConver->setCaption(i18n("Format conversion of %1 image(s)...").arg(list.count()));
	switch(formatConver->exec())
	{
		case QDialog::Accepted :
			break;
		default : return;
	}
	setMessage(i18n("Conversion in progress..."));

	QString ext=formatConver->getType();
	QString opt=formatConver->getOptions();
	bool replace = formatConver->replace();

	stopWatchDir();
	if(preview())imageList->stopLoading();

	QProgressDialog*  progres =  new QProgressDialog ("Conversion", "&Cancel", list.count(), this);
	progres->setMinimumDuration(1);
	progres->show();

	QString *name;
	int done=0;

	KShellProcess* proc = new KShellProcess ();
	connect(proc, SIGNAL(processExited(KProcess *)), this, SLOT(slotEndConvert(KProcess *)));

	QString  msg, com;

	for ( name=list.first(); name != 0; name=list.next() )
	{
		msg = QString("Conversion of <b>%1</b>\n(%2/%3)")
				.arg(*name)
				.arg(done)
				.arg(list.count());
		done++;
		if(list.count()>1)kapp->processEvents();
		if ( progres->wasCancelled() ) break;
		progres->setLabelText (msg);
		progres->setProgress (done);

		proc->clearArguments();
		com = QString("convert %s '%s' '%s'")
		  	     .arg(opt)
			     .arg(*name)
			     .arg(getFullPath(name)+getFileName(name)+"."+ext);
		*proc << com;
		proc->start (KShellProcess::Block);
		if(list.count()>1)kapp->processEvents();
		if(replace && ext!=getFileExt(name))
		{
			FileIconItem *item=imageList->findItem(getFileName(name));
			if(item) item->suppression();
		}
	}
	delete(progres);
	delete(proc);
	setMessage(i18n("Conversion done"));
	if(preview())imageList->slotLoadFirst();
	startWatchDir();
	slotRefresh ();
}

void
MainWindow::slotEndConvert(KProcess *proc)
{
	if(proc->exitStatus()!=0)
	{
		//qWarning(i18n("ERROR: during the conversion"));
	}
}

/////////////////////////////////////////////
//#ifndef HAVE_LIBDIGIKAM
char
MainWindow::getRed(QImage* im, int x, int y)
{
	return qRed(im->pixel(x, y));
}
char
MainWindow::getGreen(QImage* im, int x, int y)
{
	return qGreen(im->pixel(x, y));
}
char
MainWindow::getBlue(QImage* im, int x, int y)
{
	return qBlue(im->pixel(x, y));
}

ImageSimilarityData*
MainWindow::image_sim_fill_data(QString filename)
{
	int w, h;
	uchar *pix;
	int has_alpha;
	int p_step;

	int i,j;
	int x_inc, y_inc;
	int xs, ys;
	const int INC=1;

	QImage *pixbuf;
	ImageSimilarityData *sd = new ImageSimilarityData();
	sd->filename=filename;

	QFileInfo info(QDir::homeDirPath()+"/.showimg/cache/" + QFileInfo(filename).absFilePath()+".dat");
	if(info.exists())
	{
		QFile f(QDir::homeDirPath () + "/.showimg/cache/"+QFileInfo(filename).absFilePath()+".dat");
		if ( f.open(IO_ReadOnly) )
		{
			QDataStream s( &f );
			s >> sd->ratio;
			for(int i=0;i<PAS*PAS;i++) s >> sd->avg_r[i];
			for(int i=0;i<PAS*PAS;i++) s >> sd->avg_g[i];
			for(int i=0;i<PAS*PAS;i++) s >> sd->avg_b[i];
			f.close();
		}
		sd->filled = TRUE;
		return sd;
	}

	pixbuf = new QImage(filename);
	if (!sd || !pixbuf) return 0L;
	KImageEffect::equalize(*pixbuf);

	w = pixbuf->width();
	h = pixbuf->height();
	pix = pixbuf->bits();
	has_alpha = pixbuf->hasAlphaBuffer();
	p_step = has_alpha ? 4 : 3;

	x_inc = w / PAS;
	y_inc = h / PAS;
	if (x_inc < 1 || y_inc < 1) return 0L;

	j = 0;
	for (ys = 0; ys < PAS; ys++)
	{
		i = 0;
		for (xs = 0; xs < PAS; xs++)
		{
			int x, y;
			int r, g, b;
			r = g = b = 0;
			for (y = j; y < j + y_inc; y+=INC)
			{
				for (x = i; x < i + x_inc; x+=INC)
				{
					r +=getRed(pixbuf, x, y);
					g +=getGreen(pixbuf, x, y);
					b +=getBlue(pixbuf, x, y);
				}
			}
			r /= x_inc * y_inc;
			g /= x_inc * y_inc;
			b /= x_inc * y_inc;

			sd->avg_r[ys * PAS + xs] = r;
			sd->avg_g[ys * PAS + xs] = g;
			sd->avg_b[ys * PAS + xs] = b;

			i += x_inc;
		}
		j += y_inc;
	}
	sd->filled = TRUE;
	sd->ratio=((float)w)/h;
	delete(pixbuf);

	//////////////////////SAUVEGARDE//////////////
	QFile f(QDir::homeDirPath () + "/.showimg/cache/"+QFileInfo(filename).absFilePath()+".dat");
	KStandardDirs::makeDir(QFileInfo(f).dirPath(true));
	if ( f.open(IO_WriteOnly) )
	{
		QDataStream s( &f );
		s << sd->ratio;
		for(int i=0;i<PAS*PAS;i++) s << sd->avg_r[i];
		for(int i=0;i<PAS*PAS;i++) s << sd->avg_g[i];
		for(int i=0;i<PAS*PAS;i++) s << sd->avg_b[i];
		f.close();
	}
	return sd;
}

float
MainWindow::image_sim_compare(ImageSimilarityData *a, ImageSimilarityData *b)
{
	float sim;
	int i;

	if (!a || !b || !a->filled || !b->filled) return 0.0;
	sim = 0.0;
	for (i = 0; i < PAS*PAS; i++)
	{
		sim += (float)abs(a->avg_r[i] - b->avg_r[i]) / 255.0;
		sim += (float)abs(a->avg_g[i] - b->avg_g[i]) / 255.0;
		sim += (float)abs(a->avg_b[i] - b->avg_b[i]) / 255.0;
	}
	sim /= (1024.0 * 3.0);
	return 1.0 - sim;
}

float
MainWindow::image_sim_compare_fast(ImageSimilarityData *a, ImageSimilarityData *b, float min)
{
	float sim;
	int i,j;

	if (!a || !b || !a->filled || !b->filled) return 0.0;

	if( fabs(a->ratio - b->ratio) > 0.1 ) return 0.0;
	min = 1.0 - min;
	sim = 0.0;

	for (j = 0; j < PAS*PAS; j+= PAS)
	{
		for (i = j; i < j + PAS; i++)
		{
			sim += (float)abs(a->avg_r[i] - b->avg_r[i]) / 255.0;
			sim += (float)abs(a->avg_g[i] - b->avg_g[i]) / 255.0;
			sim += (float)abs(a->avg_b[i] - b->avg_b[i]) / 255.0;
		}
		/* check for abort, if so return 0.0 */
		if (j>PAS*PAS/3 && 1-sim/((j+1) * 3.0) <min)
		{
			return 0.0;
		}
	}
	sim /= (PAS*PAS * 3.0);

	return 1.0 - sim;
}

void
MainWindow::compareAlmost ()
{
	setMessage(i18n("Comparisons in progress..."));
	QProgressDialog * progres =  new QProgressDialog (i18n("Comparisons"), i18n("&Cancel"), ((QIconView*)imageList)->count (), this,  0, true, 0);
	QDict < QPtrVector < QFile > >*res = new QDict < QPtrVector < QFile > >;

	QPtrVector < ImageSimilarityData > *listRatW = new QPtrVector < ImageSimilarityData >;
	QPtrVector < ImageSimilarityData > *listRatH = new QPtrVector < ImageSimilarityData >;
	QPtrVector < ImageSimilarityData > *list;
	listRatW->setAutoDelete(TRUE);
	listRatH->setAutoDelete(TRUE);

	///////////////
	progres->setLabelText (i18n("Create matrix for:"));

	FileIconItem *item = imageList->firstItem ();
	int total=0;
	while (item){item = item->nextItem();total++;}
	progres->setTotalSteps(total);
	progres->show();

	QTime debut=QTime::currentTime ();
	int current=0;
	ImageSimilarityData *is;
	item = imageList->firstItem ();
	while (item)
	{
		if(!item->isImage()) {item = item->nextItem (); continue;}

		progres->setLabelText (i18n("Create matrix for:\n")+item->fullName());
		if ( progres->wasCancelled() )
		{
			delete (progres);
			delete(res);
			setMessage(i18n("Ready"));
			return;
		}
		progres->setProgress (++current);
		// file creation
		// file added
		if( (is=image_sim_fill_data(item->fullName()))!=NULL )
		{
			if(is->ratio>1)
				list = listRatW;
			else
				list = listRatH;
			list->resize (list->size () + 1);
			list->insert (list->size () - 1, is );
		}
		//we compuate the next one
		item = item->nextItem ();
	}
	kdDebug() << "Time of the creation of matrices is  " << debut.msecsTo(QTime::currentTime()) << endl;
	debut=QTime::currentTime ();

	//////////////
	total=0;
	progres->setProgress(total);
	///////////////The files are compare
	QDict < QFile > *fait = new QDict < QFile >;
	list = listRatW;
	bool done=false;
	while(list!=NULL)
	{
		if (list->size () != 1)
		{
			progres->setLabelText (i18n("Approximate comparison in progress..."));
			for (unsigned int i = 0; i < list->size (); i++)
			{
				////////PROGRESSBAR MANAGEMENT//////////
				progres->setProgress (++total);
				kapp->processEvents();
				if ( progres->wasCancelled() )
				{
					done=true;
					break;
				}
				/////CREATION of ImageSimilarityData of the first image////////
				ImageSimilarityData *i1 = list->at(i);
				if (i1 && !fait->find(i1->filename))
				{
					for (unsigned int j = i + 1; j < list->size (); j++)
					{
						/////CREATION of ImageSimilarityData os the seconde image////////
						ImageSimilarityData *i2 = list->at(j);

						///////COMPARAISON DES IMAGES ////////////
						float eq = image_sim_compare_fast(i1, i2, 0.88);
						if (eq>=0.88)   //files are the same
						{
							QPtrVector < QFile > *vect;
							 //they are added in the file
							if (!res->find (i1->filename))
							{
								vect = new QPtrVector < QFile >;
								vect->setAutoDelete(TRUE);
								res->insert (i1->filename, vect);
		        				}
		        				else
		        				{
		        					vect = (QPtrVector < QFile > *)res->find(i1->filename);
		        				}
		        				vect->resize (vect->size () + 1);
		        				vect->insert (vect->size () - 1, new QFile(i2->filename));
							fait->insert(i2->filename, new QFile(i2->filename));
						}
					}
				}
			}
		}
		if(!done)
		{
			list = listRatH;
			done=true;
		}
		else
			list=NULL;
	}
	delete(fait);
	delete (progres);
	kdDebug() << "Time of the cmp is " << debut.msecsTo(QTime::currentTime()) << endl;
	///////end/////////
	setMessage(i18n("Ready"));
	if(!res->isEmpty())
	{
		DisplayCompare(this, res).exec();
	}
	else
	{
		KMessageBox::information(this, i18n("No similar files found"));
	}

	delete(res);
	delete(listRatH);delete(listRatW);
}


void
MainWindow::compareFast ()
{
	setMessage(i18n("Fast comparisons in progress..."));
	QProgressDialog * progres = new QProgressDialog (i18n("Comparisons"), i18n("&Cancel"), ((QIconView*)imageList)->count (), this,  0, true, 0);
	progres->setLabelText (i18n("Comparison in progress..."));
	progres->show();

	QDict < QPtrVector < QFile > >*dict = new QDict < QPtrVector < QFile > >;
	dict->setAutoDelete(TRUE);
	QDict < QPtrVector < QFile > >*res = new QDict < QPtrVector < QFile > >;
	QPtrVector < QFile > *list;
	long total = 0;

	QString size;
	QFile *file;
	int nbrF=0;

	FileIconItem *item = (ImageFileIconItem *) ((QIconView*)imageList)->firstItem ();
	while (item)
	{
		if(!item->isImage())  {item = item->nextItem (); continue;}
		nbrF++;

		//creation d un file
		file = new QFile (item->fullName ());
		//on recupere la taille sous forme de chaine
		size = QString::number (QFileInfo (*file).size ());
		//si pas dans la table, on creer
		if (!dict->find (size))
		{
			list = new QPtrVector < QFile >;
			list->setAutoDelete(TRUE);
			dict->insert (size, list);
		}
		//on recupere la liste
		list = (QPtrVector < QFile > *)dict->find (size);
		//on ajoute le file
		list->resize (list->size () + 1);
		list->insert (list->size () - 1, file);
		//on passe au suivant
		item = (FileIconItem *) item->nextItem ();
	}

	/////////////
	//comparaison des fichiers
	QDictIterator < QPtrVector < QFile > >it (*dict);        // iterator for dict
	while (it.current ())
	{
		QDict < QFile > *fait = new QDict < QFile >;
		list = (QPtrVector < QFile > *)it.current ();
		if ( progres->wasCancelled() )
			break;
		progres->setProgress (total += list->size ());
		if ( progres->wasCancelled() )
		{
			delete (it);
			delete (progres);
			delete (res);
			KApplication::restoreOverrideCursor ();
			return;
		}
		if (list->size () != 1)
		{
			for (unsigned int i = 0; i < list->size (); i++)
			{
				QFile *file1 = (QFile *) (list->at (i));
				if (!fait->find (file1->name()))
				{
					for (unsigned int j = i + 1; j < list->size (); j++)
					{
						QFile *file2 = (QFile *) (list->at (j));
						if (equals (file1, file2))	  //les fic sont egaux
						{
							QPtrVector < QFile > *vect;
							//on ajoute le file
							if (!res->find (file1->name ()))
							{
								vect = new QPtrVector < QFile >;
								vect->setAutoDelete(TRUE);
								res->insert (file1->name (), vect);
							}
							else
							{
								vect = (QPtrVector < QFile > *)res->find (file1->name ());
							}
							vect->resize (vect->size () + 1);
							vect->insert (vect->size () - 1, file2);

							fait->insert(file2->name(), file2);
						}
					}
				}
			}
		}
		delete(fait);
		++it;
	}

	delete (it);
	delete (progres);
	setMessage(i18n("Ready"));
	if(!res->isEmpty())
	{
		DisplayCompare(this, res).exec();
	}
	else
	{
		KMessageBox::information(this, i18n("No identical files found"));
	}
	delete(res);
}


bool
MainWindow::equals (QFile * f1, QFile * f2)
{
	if (QFileInfo (*f1).size () != QFileInfo (*f2).size ())
	{
		return false;
	}

	f1->open (IO_ReadOnly);
	f2->open (IO_ReadOnly);

	QDataStream s1 (f1);
	QDataStream s2 (f2);

	Q_INT8 b1, b2;
	bool eq = true;

	while (!s1.atEnd () && eq)
	{
		s1 >> b1;
		s2 >> b2;

		eq = (b1 == b2);
	}

	f1->close ();
	f2->close ();

	return eq;
}

void
MainWindow::slotScanned( const QImage& img, int )
{
	if(lastDestDir.isEmpty())lastDestDir=currentDir();
	QString url=KFileDialog::getSaveFileName(lastDestDir,
						"*.png *.jpg *.gif *.bmp",
						iv,
						i18n("Save file as..."));
	if(!url.isEmpty())
	{
		lastDestDir = url;
		QString ext=QFileInfo(lastDestDir).extension().upper();
		if(ext.isEmpty())
		{
			lastDestDir+=".png";
			ext="PNG";
		}
		else
		if(ext=="JPG")
		{
			ext="JPEG";
		}
		if(! img.save(lastDestDir, ext.local8Bit(), 100) )
			KMessageBox::error(this, i18n("Error saving image."));
	}
}

void
MainWindow::slotScanImage()
{
	KApplication::setOverrideCursor (waitCursor);

	if ( !m_scanDialog )
	{
		m_scanDialog = KScanDialog::getScanDialog( this, "scandialog" );
		if ( !m_scanDialog ) // no scanning support installed?
		{
			KApplication::restoreOverrideCursor ();
			KMessageBox::error(this, i18n("Error while initialising scanning (no scanning support installed?)"));
			return;
		}

		connect( m_scanDialog, SIGNAL( finalImage( const QImage&, int )),
			SLOT( slotScanned( const QImage&, int ) ));
	}

	if ( m_scanDialog->setup() ) // only if scanner configured/available
		m_scanDialog->show();

	KApplication::restoreOverrideCursor ();
}
//#else
/*
char MainWindow::getRed(QImage* , int , int ){return 0;}
char MainWindow::getGreen(QImage* , int , int ){return 0;}
char MainWindow::getBlue(QImage* , int , int ){return 0;}
ImageSimilarityData* MainWindow::image_sim_fill_data(QString ){return NULL;}
float MainWindow::image_sim_compare(ImageSimilarityData *, ImageSimilarityData *){return -1;}
float MainWindow::image_sim_compare_fast(ImageSimilarityData *, ImageSimilarityData *, float ){return -1;}
void MainWindow::compareAlmost (){}
void MainWindow::compareFast (){}
bool MainWindow::equals (QFile *, QFile *){return false;}
void MainWindow::slotScanned( const QImage& , int ){};
void MainWindow::slotScanImage(){}
*/
//#endif /* HAVE_LIBDIGIKAM */



ListItem*
MainWindow::findDir(QString dir)
{
	QCString *res=new QCString(dir.local8Bit ());
	while(res->at(res->length()-1)=='/')
		res->setStr(res->left(res->length()-1));

	int pos = res->find("/");
	ListItem *ssrep;

	res->setStr (res->right (res->length () - pos - 1));
	pos = res->find("/");

	ssrep = root;
	while (pos != -1)
	{
		ssrep = ssrep->find (res->left (pos));
		res->setStr (res->right (res->length () - pos - 1));

		if (ssrep)
		{
			pos = res->find ("/");
		}
		else
			return NULL;
	}

	ssrep = ssrep->find (*res);
	if (ssrep)
	{
		return ssrep;
    }
	else
	{
		return NULL;
	}
}


bool
MainWindow::openDir (QString dir)
{

	QString picName;
	if(dirView->isImage(dir))
	{
		picName=QFileInfo(dir).fileName();
		dir=QFileInfo(dir).dirPath(true);
	}

	ListItem *ssrep = NULL;
	ListItem *f_ssrep = NULL;
	QFileInfo info( dir );	
	QStringList list;
	
	if(info.exists())
	{
		list = QStringList::split('/', info.absFilePath() );
		ssrep = root;
	}
	QStringList::iterator it;
	for ( it = list.begin(); it != list.end(); ++it )
	{
		f_ssrep = ssrep->find ( *it );
		if ( ! f_ssrep )
			f_ssrep = new Directory((Directory*)ssrep, *it, dirView, iv, imageList, this);
		ssrep = f_ssrep;
		ssrep->setOpen(true);
	}

	if (ssrep)
	{
//		kdDebug() << __FILE__ << __LINE__ << " begin MainWindow::openDir (QString dir=" << dir << " currentDir= " << currentDir() << endl;
		if(info.absFilePath () != currentDir())
		{
			dirView->clearSelection();
			dirView->slotShowItem(ssrep);
			dirView->setCurrentItem (ssrep);
			dirView->setSelected (ssrep, true);

			setCaption(dir);
			setCurrentDir(dir);
		}
		updateHistory();
		if(!picName.isEmpty()) imageList->setCurrentItemName(picName);
		return true;
	}
	else
	{
		KMessageBox::error(this, "<qt>"+i18n("Unable to open the directory <b>%1</b>").arg(dir)+"</qt>");
		return false;
	}
}



void
MainWindow::nextDir (Directory * r)
{
	if (r == 0)
	{
		return;
	}

	if(!r->fullName ())
	{
		return;
	}
	QListViewItem *dir = r;
	while (dir != 0)
	{
		if (dir->text (1) != i18n("Directory"))
		{
			dir = 0;
		}
		else
		{
			if (dir->isSelected ())
			{
				((Directory *) dir)->unLoad ();
				((Directory *) dir)->load ();
			}

			if (dir->firstChild ())
			{
				nextDir ((Directory *) (dir->firstChild ()));
			}
		}
		dir = dir->itemBelow ();
	}
}


void
MainWindow::renameSeries()
{
	KApplication::setOverrideCursor (waitCursor);

	if(!m_renameS)
		m_renameS = new RenameSeries(this,"RenameSeries",true);
	else
		m_renameS->clear();
	QString fullName, name;
	bool hasFiles=false;
	for (FileIconItem * item = (FileIconItem *) ((QIconView*)imageList)->firstItem (); item != 0; item = (FileIconItem *)item->nextItem ())
	{
		if (item->isSelected () )
		{
			m_renameS->addFile(item->fullName());
			hasFiles=true;
		}
	}
	if(!hasFiles)
	{
		KApplication::restoreOverrideCursor ();
		KMessageBox::error(this, i18n("You have to select at least one file"));
		return;
	}
	KApplication::restoreOverrideCursor ();
	if(m_renameS->exec())
	{
		slotRefresh();
	}

}


void
MainWindow::slotRefresh (QString dir)
{
//	kdDebug() << __FILE__ << __LINE__ << " begin MainWindow::slotRefresh (QString dir)" << endl;

	setMessage(i18n("Refreshing..."));

	QString res = QString(dir);
	int  pos = res.find ("/");
	ListItem *ssrep;

	res = res.right (res.length () - pos - 1);
	pos = res.find ("/");

	ssrep = root;
	while (pos != -1)
	{
		ssrep = ssrep->find (res.left (pos));
		res = res.right (res.length () - pos - 1);

		if (ssrep)
			pos = res.find ("/");
		else
			break;
	}
	ssrep = ssrep->find (res);
	if (ssrep && ssrep->isSelected ())
	{
		ssrep->refresh();
	}
	setMessage(i18n("Ready"));

//	kdDebug() << __FILE__ << __LINE__ << " end MainWindow::slotRefresh (QString dir)" << endl;
}


void
MainWindow::slotRefresh ()
{
//	kdDebug() << __FILE__ << __LINE__ << " begin MainWindow::slotRefresh ()" << endl;

	setMessage(i18n("Refreshing..."));
	QPtrList<ListItem> list;
	QListViewItemIterator it (root);
	for (; it.current (); ++it)
		if (it.current ()->isSelected ())
			list.append((ListItem*)it.current());
	ListItem *dir;
	for ( dir=list.first(); dir != 0; dir=list.next() )
	{
		dir->refresh(false);
	}
	iv->reload();
	imageList->arrangeItemsInGrid();
	imageList->slotLoadFirst();

	setMessage(i18n("Ready"));
//	kdDebug() << __FILE__ << __LINE__ << " end MainWindow::slotRefresh ()" << endl;
}



void
MainWindow::setHasImageSelected(bool selected)
{
//	kdDebug() << __FILE__ << __LINE__ << " begin MainWindow::setHasImageSelected(bool selected)" << endl;
	hasimageselected=selected;

	//aCut->setEnabled(selected);
	aCopy->setEnabled(selected);
	aCopyPixmap->setEnabled(selected);
	aWallpaper_CENTER->setEnabled(selected);
	aWallpaper_MOSAIC->setEnabled(selected);
	aWallpaper_CENTER_MOSAIC->setEnabled(selected);
	aWallpaper_CENTER_MAX->setEnabled(selected);
	aWallpaper_ADAPT->setEnabled(selected);
	aWallpaper_LOGO->setEnabled(selected);
	aPrint->setEnabled(selected);
	aRename->setEnabled(selected);
	aDelete	->setEnabled(selected);
	aTrash	->setEnabled(selected);
	aShred	->setEnabled(selected);
	aEditType->setEnabled(selected);
	aFileProperties->setEnabled(selected);
	aImageInfo->setEnabled(selected);
	aRotLeft->setEnabled(selected);
	aRotRight->setEnabled(selected);
	aHMirror->setEnabled(selected);
	aVMirror->setEnabled(selected);
	aFullScreen->setEnabled(selected);
	aZoomIn	->setEnabled(selected);
	aZoomOut->setEnabled(selected);
	aZoomFit->setEnabled(selected);
	aZoomFitWidth->setEnabled(selected);
	aZoomFitHeight->setEnabled(selected);
	aZoomNo	->setEnabled(selected);
	aZoomLock	->setEnabled(selected);
	aOpenWithGimp->setEnabled(selected);
	aOpenWith->setEnabled(selected);
	aSaveImage->setEnabled(selected);
	aFilesMoveTo->setEnabled(selected);
	aFilesCopyTo->setEnabled(selected);

	FileIconItem* si = imageList->firstSelected();
	if(si)
	{
//		kdDebug() << __FILE__ << __LINE__ << " \t MainWindow::setHasImageSelected(bool selected) getType()"  << si->getType() << endl;
		if(si->getType() != "file" && si->getType() != "dir")
		{
			aPaste->setEnabled(false);
			aRename->setEnabled(false);
			aTrash	->setEnabled(false);
			aImageInfo->setEnabled(false);
			aFilesMoveTo->setEnabled(false);

				//
			if(si->getType()=="filealbum")
			{
				m_actions->action("editdelete")->setText(i18n("Remove from album"));
			}
			else
			if(si->getType()=="zip")
			{
				m_actions->action("editdelete")->setText(i18n("Remove from archive"));
			}
		}
		else
		{
			m_actions->action("editdelete")->setText(i18n("Delete file"));
		}
		if(!imageList->hasOnlyOneImageSelected())
		{
			aRename->setEnabled(false);
			//aFileProperties->setEnabled(false);
			aImageInfo->setEnabled(false);
			aEditType->setEnabled(false);
		}
	}

//	kdDebug() << __FILE__ << __LINE__ << " end MainWindow::setHasImageSelected(bool selected)" << endl;
}


void
MainWindow::slotPreview ()
{
	slotIconSize(false);
	if(aPreview->isChecked())
	{
		imageList->slotLoadFirst();
	}
	else
	{
		slotStop();
		imageList->slotResetThumbnail();
	}
}

void
MainWindow::slotKeepFit ()
{
}

void
MainWindow::slotShrink()
{
	if(aShrink->isChecked())
	{
		aZoomLock->setChecked(false);
		aZoomFitWidth->setChecked(false);
		aZoomFitHeight->setChecked(false);

		slotfitHeight();
		slotfitWidth();
		slotZoomLock();
	}
	iv->setShrink(aShrink->isChecked());
}

void
MainWindow::slotEnlarge()
{
	if(aEnlarge->isChecked())
	{
		aZoomLock->setChecked(false);
		aZoomFitWidth->setChecked(false);
		aZoomFitHeight->setChecked(false);

		slotfitHeight();
		slotfitWidth();
		slotZoomLock();
	}
	iv->setEnlarge(aEnlarge->isChecked());
}

void
MainWindow::slotZoomLock()
{
	if(aZoomLock->isChecked()) {aEnlarge->setChecked(false);slotEnlarge();aShrink->setChecked(false);slotShrink();}
	iv->setZoomLock(aZoomLock->isChecked());

}


void
MainWindow::slotSmooth ()
{
	iv->setSmooth(aSmooth->isChecked());
}


void
MainWindow::slotSlideShow ()
{
	if (!timer->isActive())
	{
		KApplication::setOverrideCursor (KCursor:: blankCursor()); // this might take time
		timer->start (slideshowTime*1000, FALSE);
		if(!inFullScreen) slotFullScreen();
	}
	else
		timer->stop ();
}


void
MainWindow::setOnTop(bool )
{
}

void
MainWindow::escapePressed()
{
	if(fullScreen())
	{
		if(!inInterface)
			quit();
		else
			slotFullScreen();
	}
	else
	{
		slotStop();
	}
}
void
MainWindow::spacePressed()
{
	if(fullScreen())
		imageList->next();
}

void
MainWindow::slotFullScreen()
{
	if(! iv->hasImage())
		return;
	hide();
	setUpdatesEnabled(false);

	if (!inFullScreen )
	{
		imageList->inFullScreen = true;
		inFullScreen = true;
		inInterface=true;

		writeDockConfig (config, CONFIG_DOCK_GROUP);

		makeDockInvisible(dockIL);
		makeDockInvisible(dockDir);

		toolBar("locationToolBar")->hide();
		menuBar()->hide();
		if(!showToolbar)
		{
			toolBar("mainToolBar")->hide();
			toolBar("viewToolBar")->hide();
			topDock()->hide();
		}
		if(!showStatusbar)
		{
			statusBar()->hide();
			bottomDock()->hide();
		}

		aBack->setEnabled(false);aForward->setEnabled(false);aGoHome->setEnabled(false);
		aGoUp->setEnabled(false);aGo->setEnabled(false);

		iv->setBackgroundColor(QColor("black"));

		showFullScreen();
		iv->setFocus();
	}
	else
	{
		inFullScreen = false;
		imageList->inFullScreen = false;
		readDockConfig (config, CONFIG_DOCK_GROUP);

		iv->setBackgroundColor(bgColor);

		topDock()->show();
		bottomDock()->show();
		
		menuBar()->show();

		aBack->setEnabled(true);aPrevious->setEnabled(true);aGoHome->setEnabled(true);
		aGoUp->setEnabled(true);aGo->setEnabled(true);

		menuBar()->show();

		aBack->setEnabled(true);aPrevious->setEnabled(true);aGoHome->setEnabled(true);
		aGoUp->setEnabled(true);aGo->setEnabled(true);

		toolBar("mainToolBar")->show();
		toolBar("viewToolBar")->show();
		toolBar("locationToolBar")->show();
		statusBar()->show();

		if(timer->isActive()) {timer->stop(); aSlideshow->setChecked(false); KApplication::restoreOverrideCursor ();}

		showNormal();
	}
	aFullScreen->setChecked(inFullScreen);
	setUpdatesEnabled(true);
	show();
}


void
MainWindow::closeEvent( QCloseEvent* e)
{
	quit();
	KDockMainWindow::closeEvent(e);
}

bool
MainWindow::closeAppl()
{
	quit();
	return true;
}

void
MainWindow::quit()
{
	if(inFullScreen)
		slotFullScreen();
	/////
	config->setGroup("Options");
	config->writeEntry( "Width", width() ); // largeur de la fentre
	config->writeEntry( "Height", height() ); // hauteur de la fentre

	config->writeEntry( "nbImg", iv->nbImg );
	config->writeEntry( "preview", aPreview->isChecked() );
	config->writeEntry( "bgcolor", bgColor);
	config->writeEntry( "grayscale", grayscale );
	config->writeEntry( "storeth", storeth );
	config->writeEntry( "showFrame", showFrame );
	config->writeEntry( "smooth", smooth );
	config->writeEntry( "showhiddenDir", dirView->showHiddenDir() );
	config->writeEntry( "showhiddenFile", dirView->showHiddenFile() );
	config->writeEntry( "showDir", dirView->showDir() );
	config->writeEntry( "showallFile", dirView->showAllFile() );
	config->writeEntry( "loadFirstImage", dirView->loadFirstImage() );

	config->writeEntry( "preloadIm", imageList->preloadIm());
	config->writeEntry( "showMeta", imageList->showMeta());
	config->writeEntry( "showHexa", imageList->showHexa());

#ifdef HAVE_LIBDIGIKAM
	config->writeEntry( "pluginList", pluginManager_->loadedPluginList() );
#endif /* HAVE_LIBDIGIKAM */

	config->setGroup("Slideshow");
	config->writeEntry( "time", slideshowTime );
	config->writeEntry( "type", slideshowType );

	config->setGroup("Zoom");
	config->writeEntry( "shrink", aShrink->isChecked() );
	config->writeEntry( "enlarge", aEnlarge->isChecked() );
	config->writeEntry( "lock", aZoomLock->isChecked() );

	config->setGroup("confirm");
	config->writeEntry( "trash", checkTrash);
	config->writeEntry( "delete", checkDelete );
	config->writeEntry( "shred", checkShred );
	config->writeEntry( "openDirType", openDirType );
	if(openDirType==1) openDirname=currentDir();
	config->writePathEntry( "openDirname",  openDirname);
	config->writeEntry( "showSP",  showSP);
	config->writeEntry( "useEXIF",  useEXIF);

	config->writeEntry( "showToolbar",  showToolbar);
	config->writeEntry( "showStatusbar",  showStatusbar);



	config->sync();
	writeDockConfig(config, CONFIG_DOCK_GROUP);
	////
	kapp->quit();
}


void
MainWindow::slotAddImage (int number)
{
	total+=number;
	setNbrItems(total);
	progress->setTotalSteps (total);
	if(total>1 && aPreview->isChecked())
		progress->show();
}

void
MainWindow::slotRemoveImage ()
{
	total--;setNbrItems(total);
	progress->setTotalSteps (total);
}

void
MainWindow::slotPreviewDone ()
{
	done++;
	if(total>1)  progress->setProgress (done);
}

void
MainWindow::slotReset (bool init)
{
	aStop->setEnabled(true);
	if(init)
	{
		done = 0;
		progress->setProgress (-1);
	}
	if(total>1) progress->show();
}

void
MainWindow::slotDone()
{
	aStop->setEnabled(false);
	done = total;
	if(total>1)  progress->hide();
}

void
MainWindow::slotRemoveImage (int val)
{
	total -= val;setNbrItems(total);
	progress->setTotalSteps (total);
	progress->setProgress (total);
}


void
MainWindow::slotRotateLeft ()
{
	setMessage(i18n("Rotating..."));
	iv->rotateLeft();
	setMessage(i18n("Ready"));
}

void
MainWindow::slotRotateRight ()
{
	setMessage(i18n("Rotating..."));
	iv->rotateRight();
	setMessage(i18n("Ready"));
}

void
MainWindow::slotMirrorH ()
{
	setMessage(i18n("Flip..."));
	iv->mirror (false, true);
	setMessage(i18n("Ready"));
}


void
MainWindow::slotMirrorV ()
{
	setMessage(i18n("Flip..."));
	iv->mirror (true, false);
	setMessage(i18n("Ready"));
}

void
MainWindow::slotDirChange (const QString & dir)
{
	ListItem* d;
	if((d=findDir(dir))!=NULL)
	{
		if(d->refresh())
		{
			imageList->slotLoadFirst();
		}
	}
}

void
MainWindow::slotFileChange (const QString &)
{
	slotTODO ();
}

void
MainWindow::slotPreferences()
{
	slotTODO ();
}


void
MainWindow::slotTODO ()
{
	KMessageBox::sorry(this,
		i18n("Not yet implemented.\nSorry ;("),
		i18n("Functionality"));
}

void
MainWindow::slotcopyPixmap()
{
	KApplication::setOverrideCursor (waitCursor); // this might take time
	KApplication::clipboard()->setPixmap(iv->getPixmap());
	KApplication::restoreOverrideCursor ();
}

void
MainWindow::slotcopy ()
{
	QString files, name;
	QStringList uris;

	for (FileIconItem* item = imageList->firstItem(); item != 0; item = item->nextItem())
	{
		if (item->isSelected () )
		{
			uris.append(QUriDrag::localFileToUri(item->fullName()));
		}
	}
	QClipboard *cb = KApplication::clipboard();
	cb->setData(new KURLDrag(KURL::List(uris), this, "MainWindow"));
}


void
MainWindow::slotcut ()
{
	slotTODO ();
}

void
MainWindow::slotpaste ()
{
	KURL::List uris;
	if(KURLDrag::decode(KApplication::clipboard()->data(), uris))
	{
		if(!uris.isEmpty())
			dirView->copy(uris.toStringList(), currentTitle());
	}
}


void
MainWindow::slotNewWindow()
{
	new MainWindow("new Main Frame", currentDir());
}

void
MainWindow::slotPrint()
{
	int res;

	KPrinter printer;
	printer.setFullPage( true );
	do {
		if (!printer.setup(this))
			return;
		printImageDialog printDlg(this, iv->getPixmap(), iv->getFilename(), &printer);
		res=printDlg.exec();
	}
	while(res==2);

}


void
MainWindow::slotQuickPrint()
{

}


void
MainWindow::slotOpenLocation()
{
	QString destDir=KFileDialog::getExistingDirectory(currentDir(),
								this,
								i18n("Open Location"));

	if(!destDir.isEmpty())
	{
		if(!QFileInfo(destDir).exists())
		{
			KMessageBox::error(this, "<qt>"+i18n("The directory '<b>%1</b>' does not exist").arg(destDir)+"</qt>");
			return;
		}
		openDir(destDir);
		changeDirectory(destDir);
	}
}

void
MainWindow::slotSaveImage()
{
	if(lastDestDir.isEmpty())lastDestDir=currentDir();
	lastDestDir=iv->slotSave(lastDestDir);
}

void
MainWindow::slotUndo()
{
	slotTODO ();
}


void
MainWindow::slotRedo()
{
	slotTODO ();
}


void
MainWindow::slotMovetotrash()
{
}

void
MainWindow::slotShred()
{
}

void
MainWindow::slotEditFileType()
{
	if(!imageList->currentItem())
		return;
	KonqOperations::editMimeType( ((FileIconItem*)imageList->currentItem())->mimetype());
}


void
MainWindow::slotStop()
{
	imageList->stopLoading ();
	slotDone();
}


void
MainWindow::slotfitWidth()
{
	if(aZoomFitWidth->isChecked())
	{
		aZoomFitHeight->setChecked(false);
		aEnlarge->setChecked(false);
		aShrink->setChecked(false);

	}
	iv->fitWidth(aZoomFitWidth->isChecked(), true);				
}

void
MainWindow::slotfitHeight()
{
	if(aZoomFitHeight->isChecked())
	{
		aZoomFitWidth->setChecked(false);
		aEnlarge->setChecked(false);
		aShrink->setChecked(false);

	}
	iv->fitHeight(aZoomFitHeight->isChecked(), true);
}

void
MainWindow::slotZoomIn()
{
	setMessage(i18n("Zooming In..."));
	iv->zoomIn(1.5);
	setMessage(i18n("Ready"));
}



void
MainWindow::slotZoomOut()
{
	setMessage(i18n("Zooming Out..."));
	iv->zoomOut(1.5);
	setMessage(i18n("Ready"));
}


void
MainWindow::slotZoom()
{
        setMessage(i18n("Toggle fit to screen..."));
	iv->setFit(true);
	setMessage(i18n("Ready"));
}


void
MainWindow::slotZoomNo()
{
	setMessage(i18n("Original size..."));
	iv->originalSize();
	setMessage(i18n("Ready"));
}



void
MainWindow::configureKey()
{
	KKeyDialog::configure(m_actions, this);
}


void
MainWindow::configureToolbars()
{
	saveMainWindowSettings( KGlobal::config(), "MainWindow" );
	KEditToolbar dlg(m_actions);
	if (dlg.exec())
	{
		createGUI();
		applyMainWindowSettings( KGlobal::config(), "MainWindow" );
	}

}


void
MainWindow::configureShowImg()
{
	ConfShowImg conf(this);
	conf.initColor(bgColor, grayscale);
	conf.initFiling(openDirType, openDirname, showSP);
	conf.initMiscellaneous(storeth, showFrame, useEXIF, smooth, dirView->loadFirstImage(), dirView->showHiddenDir(), dirView->showHiddenFile(), dirView->showDir(), dirView->showAllFile(), imageList->preloadIm());
	conf.initSlideshow(slideshowType, slideshowTime);
	conf.initFullscreen(showToolbar, showStatusbar);
	conf.initProperties(imageList->showMeta(), imageList->showHexa());
#ifdef HAVE_LIBDIGIKAM
	conf.initPlugins(pluginManager_->availablePluginList(),	pluginManager_->loadedPluginList());
#endif /* HAVE_LIBDIGIKAM */
	if(conf.exec())
	{
		openDirType=conf.getOpenDirType();
		openDirname=conf.getOpenDir();
		showSP=conf.checkshowSP();
		useEXIF=conf.getUseEXIF();
		showToolbar=conf.getShowToolbar();
		showStatusbar=conf.getShowStatusbar();

		dirView->setCheckDelete(checkDelete);
		dirView->setCheckTrash(checkTrash);
		dirView->setShowHiddenDir(conf.getShowHiddenDir());
		dirView->setShowHiddenFile(conf.getShowHiddenFile());
		dirView->setShowDir(conf.getShowDir());
		dirView->setLoadFirstImage(conf.getLoadFirstImage());
		dirView->setShowAllFile(conf.getShowAll());

		imageList->setPreloadIm(conf.getPreloadIm());
		imageList->setCheckDelete(checkDelete);
		imageList->setCheckTrash(checkTrash);
		imageList->setCheckShred(checkShred);
		imageList->setRandom(conf.getSlideshowType()==2);
		imageList->setShowMeta(conf.getShowMeta());
		imageList->setShowHexa(conf.getShowHexa());

		bgColor = conf.getColor();
		iv->setBackgroundColor(bgColor);

		grayscale=conf.getGrayscale();
		iv->setToGrayscale(grayscale);

		smooth=conf.getSmooth();
		iv->setSmooth(smooth);

		slideshowTime=conf.getSlideshowTime();
		slideshowType=conf.getSlideshowType();

		storeth=conf.getStoreth();
		showFrame=conf.getShowFrame();
		imageList->il->setShowFrame(showFrame);
		imageList->il->setUseEXIF(useEXIF);

		setLayout(conf.getLayout());

#ifdef HAVE_LIBDIGIKAM
		pluginManager_->loadPlugins(conf.getPluginList());
		imageList->selectionChanged(); /* enable plugins*/
		dirView->slotSelectionChanged(); /* enable plugins*/
#endif /* HAVE_LIBDIGIKAM */
	}
}

void
MainWindow::setLayout(int layout)
{
	switch(layout)
	{
		case 1:
				dockDir->manualDock(dockIV, KDockWidget::DockLeft, 35);
				dockIL->manualDock(dockDir, KDockWidget::DockBottom, 35);
				aArrangementB->setChecked(true);
				aArrangementLR->setChecked(true);
			break;
		case 2:
				dockDir->manualDock(dockIV, KDockWidget::DockTop, 35);
				dockIL->manualDock(dockDir, KDockWidget::DockRight, 50);
				aArrangementB->setChecked(true);
				aArrangementLR->setChecked(true);
			break;
		case 3:
				dockIL->manualDock(dockIV, KDockWidget::DockRight, 35);
				dockDir->manualDock(dockIV, KDockWidget::DockTop, 35);
				aArrangementB->setChecked(true);
				aArrangementLR->setChecked(true);
			break;
		case 4:
				dockDir->manualDock(dockIV, KDockWidget::DockLeft, 35);
				dockIL->manualDock(dockIV, KDockWidget::DockTop, 10);
				aArrangementB->setChecked(true);
				aArrangementTB->setChecked(true);
			break;
		default:
			return;
			break;
	}
	slotArrangement();
	slotTxtPos();
}

void
MainWindow::slotBookmark()
{
	kdWarning() << __FILE__ << __LINE__ << " TODO MainWindow::slotBookmark()" << endl;
}


//
/**
	bookmarkmanager
*/
void
MainWindow::openBookmarkURL(const QString& _url)
{
//	kdDebug() << __FILE__ << __LINE__ << " MainWindow::openBookmarkURL(const QString& _url)" << endl;
	KURL url(_url);
	if(!url.isLocalFile())
	{
		KMessageBox::error(this, "<qt>"+i18n("The directory '<b>%1</b>' is not local").arg(url.url())+"</qt>");
		return;
	}
	else
	{
		if(!QFileInfo(url.path()).exists())
		{
			KMessageBox::error(this, "<qt>"+i18n("The directory '<b>%1</b>' does not exist").arg(url.url())+"</qt>");
			return;
		}
		openDir(url.path());
	}
}


QString
MainWindow::currentTitle() const
{
//	kdDebug() << __FILE__ << __LINE__ << " MainWindow::currentTitle() const" << endl;
	return currentDir();
}


QString
MainWindow::currentURL() const
{
//	kdDebug() << __FILE__ << __LINE__ << " MainWindow::currentURL() const" << endl;
	return "file:/"+currentDir();
}

/**
*/

//

void
MainWindow::addToBookmark(QString groupText, QString url)
{
//	kdDebug() << __FILE__ << __LINE__ << " MainWindow::addToBookmark(QString groupText, QString url)" << endl;
	KBookmarkGroup root = MyBookmarkManager::self()->root();
	KBookmark bookm;
	bool bmAlbumExists = false;
	for(bookm = root.first(); !bookm.isNull(); bookm = root.next(bookm))
	{
		if(bookm.text() == groupText)
		{
			bmAlbumExists=true;
			break;
		}
	}
	KBookmarkGroup bmg;
	if(!bmAlbumExists)
	{
		bmg = MyBookmarkManager::self()->root().createNewFolder(MyBookmarkManager::self(), groupText);
		MyBookmarkManager::self()->root().moveItem(bmg, KBookmarkGroup());
	}
	else
	{
		bmg=bookm.toGroup();
	}
	bmg.addBookmark(MyBookmarkManager::self(), url, url, KMimeType::iconForURL(url));
	MyBookmarkManager::self()->emitChanged(root);
//	kdDebug() << __FILE__ << __LINE__ << " MainWindow::addToBookmark(QString groupText, QString url)" << endl;
}

/**
*/


void
MainWindow::slotBack()
{
	go(-1);
}



void
MainWindow::slotForward()
{
	go(+1);
}

void
MainWindow::updateHistory()
{
	///
	m_URLHistoryCompletion->addItem(KURL("file:"+currentDir()).prettyURL());
	m_URLHistory->setEditText(KURL("file:"+currentDir()).prettyURL());
	m_URLHistory->addToHistory(KURL("file:"+currentDir()).prettyURL());

	///
	HistoryEntry * current = m_lstHistory.current();
	HistoryEntry* newEntry = new HistoryEntry;
	newEntry->filePath = currentDir();
	if (current && current->filePath == newEntry->filePath) {
		delete newEntry;
		return;
	}
	if (current)
	{
		m_lstHistory.at( m_lstHistory.count() - 1 ); // go to last one
		for ( ; m_lstHistory.current() != current ; )
		{
			m_lstHistory.removeLast();
		}
	}
	m_lstHistory.append(newEntry);
	aBack->setEnabled( m_lstHistory.at() > 0 );
	aForward->setEnabled( m_lstHistory.at() != ((int)m_lstHistory.count())-1 );


}



void MainWindow::go( int steps )
{
	updateHistory();
	int newPos = m_lstHistory.at() + steps;
	HistoryEntry* l = m_lstHistory.at( newPos );
	if(openDir(l->filePath))
	{
		aBack->setEnabled( m_lstHistory.at() > 0 );
		aForward->setEnabled( m_lstHistory.at() != ((int)m_lstHistory.count())-1 );
	}
}

void
MainWindow::slotForwardAboutToShow()
{
	aForward->popupMenu()->clear();
	HistoryAction::fillHistoryPopup( m_lstHistory, aForward->popupMenu(), false, true );
}


void
MainWindow::slotBackAboutToShow()
{
	aBack->popupMenu()->clear();
	HistoryAction::fillHistoryPopup( m_lstHistory, aBack->popupMenu(), true, false );
}


void
MainWindow::slotDirCut()
{
	slotTODO();
}

void
MainWindow::slotDirCopy()
{
	slotTODO();
}

void
MainWindow::slotDirPaste()
{
	slotTODO();
}

void
MainWindow::slotDirMove()
{
	slotTODO();
}

void
MainWindow::slotArrangement()
{
	if(aArrangementLR->isChecked())
		imageList->setArrangement(ImageListView::LeftToRight);
	else
		imageList->setArrangement(ImageListView::TopToBottom);
	slotIconSize(false);
}

void
MainWindow::slotTxtPos()
{
	if(aArrangementR->isChecked())
		imageList->setItemTextPos(ImageListView::Right);
	else
		imageList->setItemTextPos(ImageListView::Bottom);
}


bool
MainWindow::fullScreen()
{
	return inFullScreen;
}

void
MainWindow::setEmptyImage()
{
	iv->loadImage();
}

void
MainWindow::copyFilesTo(QStringList uris, QString dest)
{
	dirView->copy(uris, dest);
}

void
MainWindow::moveFilesTo(QStringList uris, QString dest)
{
	dirView->move(uris, dest);
}


void
MainWindow::startWatchDir()
{
	dirView->startWatchDir();
}
void
MainWindow::stopWatchDir()
{
	dirView->stopWatchDir();
}



void
MainWindow::toolsRotateLeft()
{
	setMessage(i18n("Rotating..."));
	QPtrList <QString> list;
	list.setAutoDelete (false);

	for (ImageFileIconItem * item = (ImageFileIconItem *)((QIconView*)imageList)->firstItem ();
	     item != 0;
	     item = (ImageFileIconItem *) item->nextItem ())
	{
		if (item->isSelected () && item->text(3)=="file"  )
	        {
			list.append(new QString(item->fullName()));
		}
	}
	if(list.isEmpty())
	{
		KMessageBox::error(this, i18n("You have to select at least one file"));
	}
	else
	{
		stopWatchDir();
		imageList->stopLoading();

		QProgressDialog*  progres =  new QProgressDialog ("Conversion", i18n("&Cancel"), list.count(), this);
		int done=0;
		progres->show();
		QString *name;

		KShellProcess* proc = new KShellProcess ();
		QString  msg, com;

		//
		proc->clearArguments();
		com = QString("which convert");
		*proc << com;proc->start (KShellProcess::Block);
		bool HAVE_convert=proc->exitStatus()==0;

		proc->clearArguments();
		com = QString("which jpegtran");
		*proc << com;proc->start (KShellProcess::Block);
		bool HAVE_jpegtran=proc->exitStatus()==0;
		//
		if(!HAVE_convert)
			KMessageBox::error(this, "<qt>"+i18n("You must install <tt>convert<tt> in order to manipulate images.")+"</qt>");
		else
		for ( name=list.first(); name != 0; name=list.next() )
		{
			if ( progres->wasCancelled() ) break;
			done++;
			msg = "<qt>"
				+ i18n("Conversion of <b>%1</b><br>(%2/%3)")
					.arg(*name)
					.arg(done)
					.arg(list.count())
				+"</qt>";
			progres->setLabelText (msg);
			progres->setProgress (done);
			kapp->processEvents();
			//
			QFileInfo finfo(*name);
			if(finfo.extension().lower() == "jpg" && HAVE_jpegtran)
			{
				QString dest;
				dest.setNum (getpid ());
				dest.prepend ("/tmp/.showimgtmppic-");
				dest.append (finfo.fileName());

				com = QString("jpegtran -rotate 270 -copy all -outfile");
				com += " " 		+ KProcess::quote(dest);
				com += " " 		+ KProcess::quote(*name);
				com += "&& mv -f " 	+ KProcess::quote(dest);
				com += " " 		+ KProcess::quote(*name);
			}
			else
			{
				com = QString("convert -rotate 270)");
				com += " " + KProcess::quote(*name);
				com += " " + KProcess::quote(*name);
			}
			kdDebug() << __FILE__ << __LINE__ << "MainWindow::toolsRotateLeft()\n\t" << com << endl;
			proc->clearArguments();
			*proc << com;
			proc->start (KShellProcess::Block);
			kapp->processEvents ();
		}
		delete(progres);
		delete(proc);
	}
	setMessage(i18n("Ready"));
	startWatchDir();
	slotRefresh();
}


void
MainWindow::toolsRotateRight()
{
	setMessage(i18n("Rotating..."));
	QPtrList <QString> list;
	list.setAutoDelete (false);

	for (ImageFileIconItem * item = (ImageFileIconItem *)((QIconView*)imageList)->firstItem ();
	     item != 0;
	     item = (ImageFileIconItem *) item->nextItem ())
	{
		if (item->isSelected () && item->text(3)=="file"  )
	        {
			list.append(new QString(item->fullName()));
		}
	}
	if(list.isEmpty())
	{
		KMessageBox::error(this, i18n("You have to select at least one file"));
	}
	else
	{
		stopWatchDir();
		imageList->stopLoading();

		QProgressDialog*  progres =  new QProgressDialog ("Conversion", i18n("&Cancel"), list.count(), this);
		progres->setMinimumDuration(1);
		int done=0;
		progres->show();
		QString *name;

		KShellProcess* proc = new KShellProcess ();
		QString  msg, com;

		//
		proc->clearArguments();
		com = QString("which convert");
		*proc << com;proc->start (KShellProcess::Block);
		bool HAVE_convert=proc->exitStatus()==0;

		proc->clearArguments();
		com = QString("which jpegtran");
		*proc << com;proc->start (KShellProcess::Block);
		bool HAVE_jpegtran=proc->exitStatus()==0;
		//
		if(!HAVE_convert)
			KMessageBox::error(this, "<qt>"+i18n("You must install <tt>convert<tt> in order to manipulate images !")+"</qt>");
		else
		for ( name=list.first(); name != 0; name=list.next() )
		{
			if ( progres->wasCancelled() ) break;
			done++;
			msg = "<qt>"
				+i18n("Conversion of <b>%1</b><br>(%2/%3)")
					.arg(*name)
					.arg(done)
					.arg(list.count())
				+"</qt>";
			progres->setLabelText (msg);
			progres->setProgress (done);
			kapp->processEvents();
			//
			QFileInfo finfo(*name);
			if(finfo.extension().lower() == "jpg" && HAVE_jpegtran)
			{
				QString dest;
				dest.setNum (getpid ());
				dest.prepend ("/tmp/.showimgtmppic-");
				dest.append (finfo.fileName());

				com = QString("jpegtran -rotate 90 -copy all -outfile");
				com += " " 		+ KProcess::quote(dest);
				com += " " 		+ KProcess::quote(*name);
				com += "&& mv -f " 	+ KProcess::quote(dest);
				com += " " 		+ KProcess::quote(*name);
			}
			else
			{
				com = QString("convert -rotate 90)");
				com += " " + KProcess::quote(*name);
				com += " " + KProcess::quote(*name);
			}
			kdDebug() << __FILE__ << __LINE__ << "MainWindow::toolsRotateRight()\n\t" << com << endl;
			proc->clearArguments();
			*proc << com;
			proc->start (KShellProcess::Block);
			kapp->processEvents ();
	}
	delete(progres);
	delete(proc);
	}
	setMessage(i18n("Ready"));
	startWatchDir();
	slotRefresh();
}

void
MainWindow::goHome()
{
	openDir(QDir::homeDirPath());
}

void
MainWindow::goUp()
{
	QDir dir(currentDir());dir.cdUp();
	openDir(dir.path());
}

void
MainWindow::clearCache()
{
	clearCache(currentDir());
}

void
MainWindow::clearCache(QString fromDir)
{
	KIO::del(KURL("file:/"+QDir::homeDirPath()+"/.showimg/cache/"+fromDir));
}



void
MainWindow::updateCache()
{
	pdCache=new QProgressDialog (this, "tmppb", true);
	pdCache->setLabelText(i18n("Updating in progress..."));
	pdCache->setTotalSteps(2);
	pdCache->show();
	pdCache->setProgress(2);
	updateCache(currentDir());
	pdCache->close();

	delete(pdCache);
}

void
MainWindow::updateCache(QString fromDir)
{
	pdCache->setLabelText(i18n("Updating in progress for:\n")+fromDir);
	QDir d(QDir::homeDirPath()+"/.showimg/cache/"+fromDir);
	int len=QString(QDir::homeDirPath()+"/.showimg/cache").length();
	bool delDir=false;
	if(!QFileInfo(fromDir).exists())
		delDir=true;

	d.setFilter( QDir::All | QDir::Hidden | QDir::NoSymLinks );
	const QFileInfoList *list;
	if(!(list = d.entryInfoList()))
		return;

	QFileInfoListIterator it( *list );
	QFileInfo *fi;
	while ( (fi = it.current()) != 0 )
	{
		QString fCache=fi->absFilePath();
		QString orgFile=fCache.right(fCache.length()-len);
		if(fi->isDir() && !fromDir.startsWith(orgFile))
		{
			updateCache(orgFile);
		}
		else
		{
			if(!QFileInfo(orgFile).exists() && QFileInfo(orgFile).extension(FALSE)!="dat")
			{
				QDir().remove(fCache);
				QDir().remove(fCache+".dat");
			}
		}
		++it;
	}
	if(delDir)
		QDir().rmdir(QDir::homeDirPath()+"/.showimg/cache/"+fromDir);
}


void
MainWindow::slotSetFilter()
{
	KApplication::setOverrideCursor (waitCursor);
	if(aEffect_NONE->isChecked())
	{
		aEffect_GRAYSCALE->setChecked(false);
		aEffect_NORMALIZE->setChecked(false);
		aEffect_EQUALIZE->setChecked(false);
		aEffect_INTENSITY->setChecked(false);
		aEffect_INVERT->setChecked(false);
		aEffect_EMBOSS->setChecked(false);
		aEffect_SWIRL->setChecked(false);
		aEffect_SPREAD->setChecked(false);
		aEffect_IMPLODE->setChecked(false);
		aEffect_CHARCOAL->setChecked(false);

		aEffect_NONE->setChecked(false);
	}

	iv->applyFilter(EFFECT_GRAYSCALE, aEffect_GRAYSCALE->isChecked());
	iv->applyFilter(EFFECT_NORMALIZE, aEffect_NORMALIZE->isChecked());
	iv->applyFilter(EFFECT_EQUALIZE, aEffect_EQUALIZE->isChecked());
	iv->applyFilter(EFFECT_INTENSITY, aEffect_INTENSITY->isChecked());
	iv->applyFilter(EFFECT_INVERT, aEffect_INVERT->isChecked());
	iv->applyFilter(EFFECT_EMBOSS, aEffect_EMBOSS->isChecked());
	iv->applyFilter(EFFECT_SWIRL, aEffect_SWIRL->isChecked());
	iv->applyFilter(EFFECT_SPREAD, aEffect_SPREAD->isChecked());
	iv->applyFilter(EFFECT_IMPLODE, aEffect_IMPLODE->isChecked());
	iv->applyFilter(EFFECT_CHARCOAL, aEffect_CHARCOAL->isChecked());

	iv->reload();

	KApplication::restoreOverrideCursor ();
}



void
MainWindow::slotDisplayNBImg()
{
	aTime->setText(i18n("%1 images seen").arg(iv->nbImg));
	KMessageBox::information(this, "<qt>"+i18n("You have already seen <b>%1</b> images.").arg(iv->nbImg)+"</qt>");
}

void
MainWindow::setCurrentDir(QString dir)
{
	currentDir_ = QFileInfo(dir).absFilePath ();
}

QString
MainWindow::currentDir() const
{
	return currentDir_;
}

#include "mainwindow.moc"
