/*
 *  Part of the shrinkta program, a dvd backup tool
 *
 *  Copyright (C) 2005  Daryl Gray
 *  E-Mail Daryl Gray darylgray1@dodo.com.au
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
*/
/** $Revision: 1.01 $
 * Libdvd common header
 * @file dvd-demux.h Dvd object header file
 * @ingroup core
 *
 * libdvd
 */

#if !defined (__DVD_H_INSIDE__) && !defined (LIBDVD_COMPILATION)
#error "Only <dvd.h> can be included directly."
#endif

#ifndef __DVD_DEMUX_H__
#define __DVD_DEMUX_H__


G_BEGIN_DECLS


/* --- type macros --- */
#define DVD_DEMUX_TYPE			(dvd_demux_get_type())
#define DVD_DEMUX(o)			(G_TYPE_CHECK_INSTANCE_CAST (o, DVD_DEMUX_TYPE, DvdDemux))
#define DVD_DEMUX_CLASS(k)		(G_TYPE_CHECK_CLASS_CAST    (k, DVD_DEMUX_TYPE, DvdDemuxClass))
#define DVD_IS_DVD_DEMUX(o)		(G_TYPE_CHECK_INSTANCE_TYPE (o, DVD_DEMUX_TYPE))
#define DVD_IS_DVD_DEMUX_CLASS(k)	(G_TYPE_CHECK_CLASS_TYPE    (k, DVD_DEMUX_TYPE))

/* --- typedefs & structures --- */
typedef struct	_DvdDemux		DvdDemux;
typedef struct	_DvdDemuxClass		DvdDemuxClass;


/* DVD may have -: 1 video, 8 audio, 32 subtitles */
#define DVD_DEMUX_DECODERS 41

struct _DvdDemux {
	GObject	 parent;
	
	DvdDecoder *decoder[DVD_DEMUX_DECODERS];
};

struct _DvdDemuxClass {
	GObjectClass	parent;
	/**
	 * output_data Outputs all available tracks.
	 * Bytes = -1 signals end of data stream.
	 * @param chapter Pointer to #DvdChapter emitting signal
	 * @param output #DvdStream data output type
	 * @param track Track data belongs to as a gint
	 * @param bytes Bytes output as a gint
	 * @param buffer Pointer to guint8 output buffer
	 * @param current output presentation time stamp (90kHz pts)
	 * @returns void
	 */
	void (*output_data)	(DvdDemux	*demux,
				 DvdStream	 stream_type,
				 gint		 track,
				 gint		 bytes,
				 guint8		*buffer,
				 guint32	 pts,
				 guint64	 frame_clocks);
};

/* --- prototypes --- */
GType		dvd_demux_get_type	(void);
DvdDemux*	dvd_demux_new		(void);
gboolean	dvd_demux_vob_blocks	(DvdDemux	*demux,
					 guint8		*buffer,
					 guint		 blocks);
void		dvd_demux_reset		(DvdDemux	*demux);
G_END_DECLS

#endif /*__DVD_DEMUX_H__*/
